/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.http.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.ReferenceCountUtil;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.http.netty4.Netty4HttpChannel;
import org.opensearch.http.netty4.Netty4HttpServerTransport;
import org.opensearch.security.filter.SecurityRequestChannel;
import org.opensearch.security.filter.SecurityRequestChannelUnsupported;
import org.opensearch.security.filter.SecurityRequestFactory;
import org.opensearch.security.filter.SecurityResponse;
import org.opensearch.security.filter.SecurityRestFilter;
import org.opensearch.security.filter.SecurityRestUtils;
import org.opensearch.security.http.SecurityHttpServerTransport;
import org.opensearch.security.ssl.transport.SSLConfig;
import org.opensearch.threadpool.ThreadPool;

@ChannelHandler.Sharable
public class Netty4HttpRequestHeaderVerifier
extends SimpleChannelInboundHandler<DefaultHttpRequest> {
    private final SecurityRestFilter restFilter;
    private final ThreadPool threadPool;
    private final SSLConfig sslConfig;
    private final boolean injectUserEnabled;
    private final boolean passthrough;

    public Netty4HttpRequestHeaderVerifier(SecurityRestFilter restFilter, ThreadPool threadPool, Settings settings) {
        this.restFilter = restFilter;
        this.threadPool = threadPool;
        this.injectUserEnabled = settings.getAsBoolean("plugins.security.unsupported.inject_user.enabled", Boolean.valueOf(false));
        boolean disabled = settings.getAsBoolean("plugins.security.disabled", Boolean.valueOf(false));
        this.sslConfig = disabled ? new SSLConfig(false, false) : new SSLConfig(settings);
        boolean client = !"node".equals(settings.get("client.type"));
        this.passthrough = client || disabled || this.sslConfig.isSslOnlyMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead0(ChannelHandlerContext ctx, DefaultHttpRequest msg) throws Exception {
        ReferenceCountUtil.retain((Object)msg);
        if (this.passthrough) {
            ctx.fireChannelRead((Object)msg);
            return;
        }
        ctx.channel().attr(SecurityHttpServerTransport.SHOULD_DECOMPRESS).set((Object)Boolean.FALSE);
        ctx.channel().attr(SecurityHttpServerTransport.IS_AUTHENTICATED).set((Object)Boolean.FALSE);
        Netty4HttpChannel httpChannel = (Netty4HttpChannel)ctx.channel().attr(Netty4HttpServerTransport.HTTP_CHANNEL_KEY).get();
        SecurityRequestChannel requestChannel = SecurityRequestFactory.from((HttpRequest)msg, httpChannel);
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().stashContext();){
            boolean shouldDecompress;
            this.injectUser((HttpRequest)msg, threadContext);
            this.restFilter.checkAndAuthenticateRequest(requestChannel);
            ctx.channel().attr(SecurityHttpServerTransport.UNCONSUMED_PARAMS).set(requestChannel.getUnconsumedParams());
            ThreadContext.StoredContext contextToRestore = this.threadPool.getThreadContext().newStoredContext(false);
            ctx.channel().attr(SecurityHttpServerTransport.CONTEXT_TO_RESTORE).set((Object)contextToRestore);
            requestChannel.getQueuedResponse().ifPresent(response -> ctx.channel().attr(SecurityHttpServerTransport.EARLY_RESPONSE).set(response));
            boolean shouldSkipAuthentication = SecurityRestUtils.shouldSkipAuthentication(requestChannel);
            boolean bl = shouldDecompress = !shouldSkipAuthentication && requestChannel.getQueuedResponse().isEmpty();
            if (requestChannel.getQueuedResponse().isEmpty() || shouldSkipAuthentication) {
                ctx.channel().attr(SecurityHttpServerTransport.SHOULD_DECOMPRESS).set((Object)shouldDecompress);
                ctx.channel().attr(SecurityHttpServerTransport.IS_AUTHENTICATED).set((Object)Boolean.TRUE);
            }
        }
        catch (OpenSearchSecurityException e) {
            SecurityResponse earlyResponse = new SecurityResponse(ExceptionsHelper.status((Throwable)e).getStatus(), (Exception)((Object)e));
            ctx.channel().attr(SecurityHttpServerTransport.EARLY_RESPONSE).set((Object)earlyResponse);
        }
        catch (SecurityRequestChannelUnsupported securityRequestChannelUnsupported) {
        }
        finally {
            ctx.fireChannelRead((Object)msg);
        }
    }

    private void injectUser(HttpRequest request, ThreadContext threadContext) {
        if (this.injectUserEnabled) {
            threadContext.putTransient("injected_user", (Object)request.headers().get("injected_user"));
        }
    }
}

