/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.transport;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.cluster.shards.ClusterSearchShardsResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.security.OpenSearchSecurityPlugin;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auth.BackendRegistry;
import org.opensearch.security.configuration.ClusterInfoHolder;
import org.opensearch.security.ssl.SslExceptionHandler;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.security.ssl.transport.SSLConfig;
import org.opensearch.security.support.Base64Helper;
import org.opensearch.security.support.ConfigConstants;
import org.opensearch.security.support.HeaderHelper;
import org.opensearch.security.transport.InterClusterRequestEvaluator;
import org.opensearch.security.transport.SecurityRequestHandler;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportInterceptor;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportResponseHandler;

public class SecurityInterceptor {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private BackendRegistry backendRegistry;
    private AuditLog auditLog;
    private final ThreadPool threadPool;
    private final PrincipalExtractor principalExtractor;
    private final InterClusterRequestEvaluator requestEvalProvider;
    private final ClusterService cs;
    private final Settings settings;
    private final SslExceptionHandler sslExceptionHandler;
    private final ClusterInfoHolder clusterInfoHolder;
    private final SSLConfig SSLConfig;
    private final Supplier<Boolean> actionTraceEnabled;

    public SecurityInterceptor(Settings settings, ThreadPool threadPool, BackendRegistry backendRegistry, AuditLog auditLog, PrincipalExtractor principalExtractor, InterClusterRequestEvaluator requestEvalProvider, ClusterService cs, SslExceptionHandler sslExceptionHandler, ClusterInfoHolder clusterInfoHolder, SSLConfig SSLConfig2, Supplier<Boolean> actionTraceSupplier) {
        this.backendRegistry = backendRegistry;
        this.auditLog = auditLog;
        this.threadPool = threadPool;
        this.principalExtractor = principalExtractor;
        this.requestEvalProvider = requestEvalProvider;
        this.cs = cs;
        this.settings = settings;
        this.sslExceptionHandler = sslExceptionHandler;
        this.clusterInfoHolder = clusterInfoHolder;
        this.SSLConfig = SSLConfig2;
        this.actionTraceEnabled = actionTraceSupplier;
    }

    public <T extends TransportRequest> SecurityRequestHandler<T> getHandler(String action, TransportRequestHandler<T> actualHandler) {
        return new SecurityRequestHandler<T>(action, actualHandler, this.threadPool, this.auditLog, this.principalExtractor, this.requestEvalProvider, this.cs, this.SSLConfig, this.sslExceptionHandler);
    }

    public <T extends TransportResponse> void sendRequestDecorate(TransportInterceptor.AsyncSender sender, Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler, DiscoveryNode localNode) {
        Map origHeaders0 = this.getThreadContext().getHeaders();
        User user0 = (User)this.getThreadContext().getTransient("_opendistro_security_user");
        String injectedUserString = (String)this.getThreadContext().getTransient("injected_user");
        String injectedRolesString = (String)this.getThreadContext().getTransient("opendistro_security_injected_roles");
        String injectedRolesValidationString = (String)this.getThreadContext().getTransient("opendistro_security_injected_roles_validation");
        String origin0 = (String)this.getThreadContext().getTransient("_opendistro_security_origin");
        Object remoteAddress0 = this.getThreadContext().getTransient("_opendistro_security_remote_address");
        String origCCSTransientDls = (String)this.getThreadContext().getTransient("_opendistro_security_dls_query_ccs");
        String origCCSTransientFls = (String)this.getThreadContext().getTransient("_opendistro_security_fls_fields_ccs");
        String origCCSTransientMf = (String)this.getThreadContext().getTransient("_opendistro_security_masked_fields_ccs");
        boolean isDebugEnabled = this.log.isDebugEnabled();
        boolean useJDKSerialization = connection.getVersion().before(ConfigConstants.FIRST_CUSTOM_SERIALIZATION_SUPPORTED_OS_VERSION);
        boolean isSameNodeRequest = localNode != null && localNode.equals((Object)connection.getNode());
        try (ThreadContext.StoredContext stashedContext = this.getThreadContext().stashContext();){
            RestoringTransportResponseHandler<T> restoringHandler = new RestoringTransportResponseHandler<T>(handler, stashedContext);
            this.getThreadContext().putHeader("_opendistro_security_remotecn", this.cs.getClusterName().value());
            HashMap<String, String> headerMap = new HashMap<String, String>(Maps.filterKeys((Map)origHeaders0, k -> k != null && (k.equals("_opendistro_security_conf_request") || k.equals("_opendistro_security_origin_header") || k.equals("_opendistro_security_remote_address_header") || k.equals("_opendistro_security_user_header") || k.equals("_opendistro_security_dls_query") || k.equals("_opendistro_security_fls_fields") || k.equals("_opendistro_security_masked_fields") || k.equals("_opendistro_security_doc_allowlist") || k.equals("_opendistro_security_filter_level_dls_done") || k.equals("_opendistro_security_dls_mode") || k.equals("_opendistro_security_dls_filter_level_query") || k.equals("_opendistro_security_source_field_context") && !(request instanceof SearchRequest) && !(request instanceof GetRequest) || k.startsWith("_opendistro_security_trace") || k.startsWith("_opendistro_security_initial_action_class_header"))));
            if (OpenSearchSecurityPlugin.GuiceHolder.getRemoteClusterService().isCrossClusterSearchEnabled() && this.clusterInfoHolder.isInitialized() && (action.equals("indices:admin/shards/search_shards") || action.equals("indices:data/read/search")) && !this.clusterInfoHolder.hasNode(connection.getNode()).booleanValue()) {
                if (isDebugEnabled) {
                    this.log.debug("remove dls/fls/mf because we sent a ccs request to a remote cluster");
                }
                headerMap.remove("_opendistro_security_dls_query");
                headerMap.remove("_opendistro_security_dls_mode");
                headerMap.remove("_opendistro_security_masked_fields");
                headerMap.remove("_opendistro_security_fls_fields");
                headerMap.remove("_opendistro_security_filter_level_dls_done");
                headerMap.remove("_opendistro_security_dls_filter_level_query");
                headerMap.remove("_opendistro_security_doc_allowlist");
            }
            if (OpenSearchSecurityPlugin.GuiceHolder.getRemoteClusterService().isCrossClusterSearchEnabled() && this.clusterInfoHolder.isInitialized() && !action.startsWith("internal:") && !action.equals("indices:admin/shards/search_shards") && !this.clusterInfoHolder.hasNode(connection.getNode()).booleanValue()) {
                if (isDebugEnabled) {
                    this.log.debug("add dls/fls/mf from transient");
                }
                if (origCCSTransientDls != null && !origCCSTransientDls.isEmpty()) {
                    headerMap.put("_opendistro_security_dls_query", origCCSTransientDls);
                }
                if (origCCSTransientMf != null && !origCCSTransientMf.isEmpty()) {
                    headerMap.put("_opendistro_security_masked_fields", origCCSTransientMf);
                }
                if (origCCSTransientFls != null && !origCCSTransientFls.isEmpty()) {
                    headerMap.put("_opendistro_security_fls_fields", origCCSTransientFls);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)injectedRolesValidationString) && OpenSearchSecurityPlugin.GuiceHolder.getRemoteClusterService().isCrossClusterSearchEnabled() && !this.clusterInfoHolder.hasNode(connection.getNode()).booleanValue() && this.getThreadContext().getHeader("opendistro_security_injected_roles_validation_header") == null) {
                this.getThreadContext().putHeader("opendistro_security_injected_roles_validation_header", injectedRolesValidationString);
            }
            if (useJDKSerialization) {
                HashMap jdkSerializedHeaders = new HashMap();
                HeaderHelper.getAllSerializedHeaderNames().stream().filter(k -> headerMap.get(k) != null).forEach(k -> jdkSerializedHeaders.put(k, Base64Helper.ensureJDKSerialized((String)headerMap.get(k))));
                headerMap.putAll(jdkSerializedHeaders);
            }
            this.getThreadContext().putHeader(headerMap);
            this.ensureCorrectHeaders(remoteAddress0, user0, origin0, injectedUserString, injectedRolesString, isSameNodeRequest, useJDKSerialization);
            if (this.actionTraceEnabled.get().booleanValue()) {
                this.getThreadContext().putHeader("_opendistro_security_trace" + System.currentTimeMillis() + "#" + UUID.randomUUID().toString(), Thread.currentThread().getName() + " IC -> " + action + " " + this.getThreadContext().getHeaders().entrySet().stream().filter(p -> !((String)p.getKey()).startsWith("_opendistro_security_trace")).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (String)p.getValue())));
            }
            sender.sendRequest(connection, action, request, options, restoringHandler);
        }
    }

    private void ensureCorrectHeaders(Object remoteAdr, User origUser, String origin, String injectedUserString, String injectedRolesString, boolean isSameNodeRequest, boolean useJDKSerialization) {
        String remoteAddressHeader;
        if (origin != null && !origin.isEmpty() && this.getThreadContext().getHeader("_opendistro_security_origin_header") == null) {
            this.getThreadContext().putHeader("_opendistro_security_origin_header", origin);
        }
        if (origin == null && this.getThreadContext().getHeader("_opendistro_security_origin_header") == null) {
            this.getThreadContext().putHeader("_opendistro_security_origin_header", AuditLog.Origin.LOCAL.toString());
        }
        TransportAddress transportAddress = null;
        if (remoteAdr != null && remoteAdr instanceof TransportAddress && (remoteAddressHeader = this.getThreadContext().getHeader("_opendistro_security_remote_address_header")) == null) {
            transportAddress = (TransportAddress)remoteAdr;
        }
        if (isSameNodeRequest) {
            if (transportAddress != null) {
                this.getThreadContext().putTransient("_opendistro_security_remote_address", transportAddress);
            }
            if (origUser != null) {
                this.getThreadContext().putTransient("_opendistro_security_user", (Object)origUser);
            } else if (StringUtils.isNotEmpty((CharSequence)injectedRolesString)) {
                this.getThreadContext().putTransient("opendistro_security_injected_roles", (Object)injectedRolesString);
            } else if (StringUtils.isNotEmpty((CharSequence)injectedUserString)) {
                this.getThreadContext().putTransient("injected_user", (Object)injectedUserString);
            }
        } else {
            String userHeader;
            if (transportAddress != null) {
                this.getThreadContext().putHeader("_opendistro_security_remote_address_header", Base64Helper.serializeObject(transportAddress.address(), useJDKSerialization));
            }
            if ((userHeader = this.getThreadContext().getHeader("_opendistro_security_user_header")) == null) {
                if (origUser != null) {
                    this.getThreadContext().putHeader("_opendistro_security_user_header", Base64Helper.serializeObject(origUser, useJDKSerialization));
                } else if (StringUtils.isNotEmpty((CharSequence)injectedRolesString)) {
                    this.getThreadContext().putHeader("opendistro_security_injected_roles_header", injectedRolesString);
                } else if (StringUtils.isNotEmpty((CharSequence)injectedUserString)) {
                    this.getThreadContext().putHeader("injected_user_header", injectedUserString);
                }
            }
        }
    }

    private ThreadContext getThreadContext() {
        return this.threadPool.getThreadContext();
    }

    private class RestoringTransportResponseHandler<T extends TransportResponse>
    implements TransportResponseHandler<T> {
        private final ThreadContext.StoredContext contextToRestore;
        private final TransportResponseHandler<T> innerHandler;

        private RestoringTransportResponseHandler(TransportResponseHandler<T> innerHandler, ThreadContext.StoredContext contextToRestore) {
            this.contextToRestore = contextToRestore;
            this.innerHandler = innerHandler;
        }

        public T read(StreamInput in) throws IOException {
            return (T)((TransportResponse)this.innerHandler.read(in));
        }

        public void handleResponse(T response) {
            ThreadContext threadContext = SecurityInterceptor.this.getThreadContext();
            Map responseHeaders = threadContext.getResponseHeaders();
            List flsResponseHeader = (List)responseHeaders.get("_opendistro_security_fls_fields");
            List dlsResponseHeader = (List)responseHeaders.get("_opendistro_security_dls_query");
            List maskedFieldsResponseHeader = (List)responseHeaders.get("_opendistro_security_masked_fields");
            this.contextToRestore.restore();
            boolean isDebugEnabled = SecurityInterceptor.this.log.isDebugEnabled();
            if (response instanceof ClusterSearchShardsResponse) {
                if (flsResponseHeader != null && !flsResponseHeader.isEmpty()) {
                    if (isDebugEnabled) {
                        SecurityInterceptor.this.log.debug("add flsResponseHeader as transient");
                    }
                    threadContext.putTransient("_opendistro_security_fls_fields_ccs", flsResponseHeader.get(0));
                }
                if (dlsResponseHeader != null && !dlsResponseHeader.isEmpty()) {
                    if (isDebugEnabled) {
                        SecurityInterceptor.this.log.debug("add dlsResponseHeader as transient");
                    }
                    threadContext.putTransient("_opendistro_security_dls_query_ccs", dlsResponseHeader.get(0));
                }
                if (maskedFieldsResponseHeader != null && !maskedFieldsResponseHeader.isEmpty()) {
                    if (isDebugEnabled) {
                        SecurityInterceptor.this.log.debug("add maskedFieldsResponseHeader as transient");
                    }
                    threadContext.putTransient("_opendistro_security_masked_fields_ccs", maskedFieldsResponseHeader.get(0));
                }
            }
            this.innerHandler.handleResponse(response);
        }

        public void handleException(TransportException e) {
            this.contextToRestore.restore();
            this.innerHandler.handleException(e);
        }

        public String executor() {
            return this.innerHandler.executor();
        }
    }
}

