"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fillAndStroke = void 0;
var color_library_wrappers_1 = require("../../../../../common/color_library_wrappers");
var line_1 = require("./line");
function fillAndStroke(ctx, fill, stroke, path) {
    if (fill) {
        ctx.fillStyle = color_library_wrappers_1.RGBtoString(fill.color);
        if (path) {
            ctx.fill(path);
        }
        else {
            ctx.fill();
        }
    }
    if (stroke && stroke.width > line_1.MIN_STROKE_WIDTH) {
        ctx.strokeStyle = color_library_wrappers_1.RGBtoString(stroke.color);
        ctx.lineWidth = stroke.width;
        if (stroke.dash) {
            ctx.setLineDash(stroke.dash);
        }
        if (path) {
            ctx.stroke(path);
        }
        else {
            ctx.stroke();
        }
    }
}
exports.fillAndStroke = fillAndStroke;
//# sourceMappingURL=utils.js.map