"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSelect = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _form_control_layout = require("../form_control_layout");

var _validatable_control = require("../validatable_control");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; } /*
                                                                                                                                                                                                                                                                                                                     * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                     *
                                                                                                                                                                                                                                                                                                                     * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                     * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                     * compatible open source license.
                                                                                                                                                                                                                                                                                                                     *
                                                                                                                                                                                                                                                                                                                     * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                     * GitHub history for details.
                                                                                                                                                                                                                                                                                                                     */ /*
                                                                                                                                                                                                                                                                                                                         * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                                                                                                                         * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                                                                                                                         * this work for additional information regarding copyright
                                                                                                                                                                                                                                                                                                                         * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                                                                                                                         * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                                                                                                                         * not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                         * You may obtain a copy of the License at
                                                                                                                                                                                                                                                                                                                         *
                                                                                                                                                                                                                                                                                                                         *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                         *
                                                                                                                                                                                                                                                                                                                         * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                                                                                                                         * software distributed under the License is distributed on an
                                                                                                                                                                                                                                                                                                                         * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                                                                                                                         * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                                                                                                                         * specific language governing permissions and limitations
                                                                                                                                                                                                                                                                                                                         * under the License.
                                                                                                                                                                                                                                                                                                                         */

var EuiSelect = function EuiSelect(_ref) {
  var className = _ref.className,
      _ref$options = _ref.options,
      options = _ref$options === void 0 ? [] : _ref$options,
      id = _ref.id,
      name = _ref.name,
      inputRef = _ref.inputRef,
      isInvalid = _ref.isInvalid,
      _ref$fullWidth = _ref.fullWidth,
      fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
      _ref$isLoading = _ref.isLoading,
      isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
      _ref$hasNoInitialSele = _ref.hasNoInitialSelection,
      hasNoInitialSelection = _ref$hasNoInitialSele === void 0 ? false : _ref$hasNoInitialSele,
      defaultValue = _ref.defaultValue,
      _ref$compressed = _ref.compressed,
      compressed = _ref$compressed === void 0 ? false : _ref$compressed,
      _value = _ref.value,
      prepend = _ref.prepend,
      append = _ref.append,
      onMouseUp = _ref.onMouseUp,
      rest = _objectWithoutProperties(_ref, ["className", "options", "id", "name", "inputRef", "isInvalid", "fullWidth", "isLoading", "hasNoInitialSelection", "defaultValue", "compressed", "value", "prepend", "append", "onMouseUp"]);

  // if this is injecting an empty option for `hasNoInitialSelection` then
  // value needs to fallback to an empty string to interact properly with `defaultValue`
  var value = hasNoInitialSelection ? _value !== null && _value !== void 0 ? _value : '' : _value;

  var handleMouseUp = function handleMouseUp(e) {
    // Normalizes cross-browser mouse eventing by preventing propagation,
    // notably for use in conjunction with EuiOutsideClickDetector.
    // See https://github.com/elastic/oui/pull/1926 for full discussion on
    // rationale and alternatives should this intervention become problematic.
    e.nativeEvent.stopImmediatePropagation();
    if (onMouseUp) onMouseUp(e);
  };

  var classes = (0, _classnames.default)('euiSelect', {
    'euiSelect--fullWidth': fullWidth,
    'euiSelect--compressed': compressed,
    'euiSelect--inGroup': prepend || append,
    'euiSelect-isLoading': isLoading
  }, className);
  var emptyOptionNode;

  if (hasNoInitialSelection) {
    emptyOptionNode = /*#__PURE__*/_react.default.createElement("option", {
      value: "",
      disabled: true,
      hidden: true,
      style: {
        display: 'none'
      }
    }, "\xA0");
  } // React HTML input can not have both value and defaultValue properties.
  // https://reactjs.org/docs/uncontrolled-components.html#default-values


  var selectDefaultValue;

  if (value == null) {
    selectDefaultValue = defaultValue || '';
  }

  var icon = {
    type: 'arrowDown',
    side: 'right'
  };
  return /*#__PURE__*/_react.default.createElement(_form_control_layout.EuiFormControlLayout, {
    icon: icon,
    fullWidth: fullWidth,
    isLoading: isLoading,
    compressed: compressed,
    prepend: prepend,
    append: append,
    inputId: id
  }, /*#__PURE__*/_react.default.createElement(_validatable_control.EuiValidatableControl, {
    isInvalid: isInvalid
  }, /*#__PURE__*/_react.default.createElement("select", _extends({
    id: id,
    name: name,
    className: classes,
    ref: inputRef,
    defaultValue: selectDefaultValue,
    value: value,
    onMouseUp: handleMouseUp
  }, rest), emptyOptionNode, options.map(function (option, index) {
    var text = option.text,
        rest = _objectWithoutProperties(option, ["text"]);

    return /*#__PURE__*/_react.default.createElement("option", _extends({}, rest, {
      key: index
    }), text);
  }))));
};

exports.EuiSelect = EuiSelect;
EuiSelect.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  options: _propTypes.default.arrayOf(_propTypes.default.shape({
    text: _propTypes.default.node.isRequired
  }).isRequired),
  isInvalid: _propTypes.default.bool,
  fullWidth: _propTypes.default.bool,
  isLoading: _propTypes.default.bool,

  /**
       * Simulates no selection by creating an empty, selected, hidden first option
       */
  hasNoInitialSelection: _propTypes.default.bool,
  inputRef: _propTypes.default.any,
  value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]),

  /**
       * when `true` creates a shorter height input
       */
  compressed: _propTypes.default.bool,

  /**
       * Creates an input group with element(s) coming before select.
       * `string` | `ReactElement` or an array of these
       */
  prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),

  /**
       * Creates an input group with element(s) coming after select.
       * `string` | `ReactElement` or an array of these
       */
  append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired])
};