/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.catalina.ssi.SSICommand;
import org.apache.catalina.ssi.SSIConditional;
import org.apache.catalina.ssi.SSIConfig;
import org.apache.catalina.ssi.SSIEcho;
import org.apache.catalina.ssi.SSIExec;
import org.apache.catalina.ssi.SSIExternalResolver;
import org.apache.catalina.ssi.SSIFlastmod;
import org.apache.catalina.ssi.SSIFsize;
import org.apache.catalina.ssi.SSIInclude;
import org.apache.catalina.ssi.SSIMediator;
import org.apache.catalina.ssi.SSIPrintenv;
import org.apache.catalina.ssi.SSISet;
import org.apache.catalina.ssi.SSIStopProcessingException;
import org.apache.catalina.util.IOTools;

public class SSIProcessor {
    protected static final String COMMAND_START = "<!--#";
    protected static final String COMMAND_END = "-->";
    protected final SSIExternalResolver ssiExternalResolver;
    protected final HashMap<String, SSICommand> commands = new HashMap();
    protected final int debug;
    protected final boolean allowExec;

    public SSIProcessor(SSIExternalResolver sSIExternalResolver, int n, boolean bl) {
        this.ssiExternalResolver = sSIExternalResolver;
        this.debug = n;
        this.allowExec = bl;
        this.addBuiltinCommands();
    }

    protected void addBuiltinCommands() {
        this.addCommand("config", new SSIConfig());
        this.addCommand("echo", new SSIEcho());
        if (this.allowExec) {
            this.addCommand("exec", new SSIExec());
        }
        this.addCommand("include", new SSIInclude());
        this.addCommand("flastmod", new SSIFlastmod());
        this.addCommand("fsize", new SSIFsize());
        this.addCommand("printenv", new SSIPrintenv());
        this.addCommand("set", new SSISet());
        SSIConditional sSIConditional = new SSIConditional();
        this.addCommand("if", sSIConditional);
        this.addCommand("elif", sSIConditional);
        this.addCommand("endif", sSIConditional);
        this.addCommand("else", sSIConditional);
    }

    public void addCommand(String string, SSICommand sSICommand) {
        this.commands.put(string, sSICommand);
    }

    public long process(Reader reader, long l, PrintWriter printWriter) throws IOException {
        SSIMediator sSIMediator = new SSIMediator(this.ssiExternalResolver, l);
        StringWriter stringWriter = new StringWriter();
        IOTools.flow((Reader)reader, (Writer)stringWriter);
        String string = stringWriter.toString();
        stringWriter = null;
        int n = 0;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            while (n < string.length()) {
                char c = string.charAt(n);
                if (!bl) {
                    if (c == COMMAND_START.charAt(0) && this.charCmp(string, n, COMMAND_START)) {
                        bl = true;
                        n += COMMAND_START.length();
                        stringBuilder.setLength(0);
                        continue;
                    }
                    if (!sSIMediator.getConditionalState().processConditionalCommandsOnly) {
                        printWriter.write(c);
                    }
                    ++n;
                    continue;
                }
                if (c == COMMAND_END.charAt(0) && this.charCmp(string, n, COMMAND_END)) {
                    long l2;
                    bl = false;
                    n += COMMAND_END.length();
                    String string2 = this.parseCmd(stringBuilder);
                    if (this.debug > 0) {
                        this.ssiExternalResolver.log("SSIProcessor.process -- processing command: " + string2, null);
                    }
                    String[] stringArray = this.parseParamNames(stringBuilder, string2.length());
                    String[] stringArray2 = this.parseParamValues(stringBuilder, string2.length(), stringArray.length);
                    String string3 = sSIMediator.getConfigErrMsg();
                    SSICommand sSICommand = this.commands.get(string2.toLowerCase(Locale.ENGLISH));
                    Object object = null;
                    if (sSICommand == null) {
                        object = "Unknown command: " + string2;
                    } else if (stringArray2 == null) {
                        object = "Error parsing directive parameters.";
                    } else if (stringArray.length != stringArray2.length) {
                        object = "Parameter names count does not match parameter values count on command: " + string2;
                    } else if ((!sSIMediator.getConditionalState().processConditionalCommandsOnly || sSICommand instanceof SSIConditional) && (l2 = sSICommand.process(sSIMediator, string2, stringArray, stringArray2, printWriter)) > l) {
                        l = l2;
                    }
                    if (object == null) continue;
                    this.ssiExternalResolver.log((String)object, null);
                    printWriter.write(string3);
                    continue;
                }
                stringBuilder.append(c);
                ++n;
            }
        }
        catch (SSIStopProcessingException sSIStopProcessingException) {
            // empty catch block
        }
        return l;
    }

    protected String[] parseParamNames(StringBuilder stringBuilder, int n) {
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        while (n2 < stringBuilder.length()) {
            if (!bl) {
                while (n2 < stringBuilder.length() && this.isSpace(stringBuilder.charAt(n2))) {
                    ++n2;
                }
                if (n2 >= stringBuilder.length()) break;
                bl = !bl;
                continue;
            }
            while (n2 < stringBuilder.length() && stringBuilder.charAt(n2) != '=') {
                stringBuilder2.append(stringBuilder.charAt(n2));
                ++n2;
            }
            stringBuilder2.append('=');
            bl = !bl;
            n4 = 0;
            boolean bl2 = false;
            while (n2 < stringBuilder.length() && n4 != 2) {
                char c = stringBuilder.charAt(n2);
                if (c == '\\' && !bl2) {
                    bl2 = true;
                } else {
                    if (c == '\"' && !bl2) {
                        ++n4;
                    }
                    bl2 = false;
                }
                ++n2;
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuilder2.toString(), "=");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n3++] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    protected String[] parseParamValues(StringBuilder stringBuilder, int n, int n2) {
        int n3 = 0;
        boolean bl = false;
        String[] stringArray = new String[n2];
        StringBuilder stringBuilder2 = new StringBuilder();
        char c = '\u0000';
        for (int i = n; i < stringBuilder.length(); ++i) {
            if (!bl) {
                while (i < stringBuilder.length() && !this.isQuote(stringBuilder.charAt(i))) {
                    ++i;
                }
                if (i >= stringBuilder.length()) break;
                bl = !bl;
                c = stringBuilder.charAt(i);
                continue;
            }
            boolean bl2 = false;
            while (i < stringBuilder.length()) {
                char c2 = stringBuilder.charAt(i);
                if (c2 == '\\' && !bl2) {
                    bl2 = true;
                } else {
                    if (c2 == c && !bl2) break;
                    if (c2 == '$' && bl2) {
                        stringBuilder2.append('\\');
                    }
                    bl2 = false;
                    stringBuilder2.append(c2);
                }
                ++i;
            }
            if (i == stringBuilder.length()) {
                return null;
            }
            stringArray[n3++] = stringBuilder2.toString();
            stringBuilder2.delete(0, stringBuilder2.length());
            bl = !bl;
        }
        return stringArray;
    }

    private String parseCmd(StringBuilder stringBuilder) {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char c = stringBuilder.charAt(i);
            if (Character.isLetter(c)) {
                if (n == -1) {
                    n = i;
                }
                n2 = i;
                continue;
            }
            if (!this.isSpace(c) || n2 > -1) break;
        }
        if (n == -1) {
            return "";
        }
        return stringBuilder.substring(n, n2 + 1);
    }

    protected boolean charCmp(String string, int n, String string2) {
        return string.regionMatches(n, string2, 0, string2.length());
    }

    protected boolean isSpace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    protected boolean isQuote(char c) {
        return c == '\'' || c == '\"' || c == '`';
    }
}

