import winston from 'winston';
declare const LOG_LEVELS: readonly ["error", "warning", "info", "debug"];
type LogLevel = typeof LOG_LEVELS[number];
declare class Logger {
    private level;
    private output;
    private directory;
    private logger;
    private fileTransport;
    private debugNamespaceIgnoreRegex?;
    init(): void;
    get winston(): winston.Logger;
    addTransport(transport: winston.transport): void;
    removeTransport(transport: winston.transport): void;
    getDebugNamespaceIgnore(): string;
    setDebugNamespaceIgnore(value: string): void;
    getLevel(): LogLevel | 'warn';
    setLevel(level: LogLevel | 'warn'): void;
    warning(message: string, namespace?: string): void;
    info(message: string, namespace?: string): void;
    debug(message: string, namespace?: string): void;
    error(message: string, namespace?: string): void;
    cleanup(): void;
    end(): Promise<void>;
}
declare const _default: Logger;
export default _default;
//# sourceMappingURL=logger.d.ts.map