"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const buffalo_1 = require("../buffalo");
const utils_1 = require("../utils");
const logger_1 = require("../utils/logger");
const definition_1 = require("./definition");
const tstype_1 = require("./tstype");
const Utils = __importStar(require("./utils"));
const NS = 'zh:controller:buffalozcl';
const SEC_KEY_LENGTH = 16;
const extensionFieldSetsDateTypeLookup = {
    6: [definition_1.DataType.UINT8],
    8: [definition_1.DataType.UINT8],
    258: [definition_1.DataType.UINT8, definition_1.DataType.UINT8],
    768: [definition_1.DataType.UINT16, definition_1.DataType.UINT16, definition_1.DataType.UINT16, definition_1.DataType.UINT8, definition_1.DataType.UINT8, definition_1.DataType.UINT8, definition_1.DataType.UINT16, definition_1.DataType.UINT16],
};
class BuffaloZcl extends buffalo_1.Buffalo {
    // TODO: remove read/write int "SB" versions in favor of plain numbers, implemented in buffalo.ts
    writeUInt40SB(value) {
        this.writeUInt32(value[1]);
        this.writeUInt8(value[0]);
    }
    readUInt40SB() {
        const lsb = this.readUInt32();
        const msb = this.readUInt8();
        return [msb, lsb];
    }
    writeUInt48SB(value) {
        this.writeUInt32(value[1]);
        this.writeUInt16(value[0]);
    }
    readUInt48SB() {
        const lsb = this.readUInt32();
        const msb = this.readUInt16();
        return [msb, lsb];
    }
    writeUInt56SB(value) {
        const temp = Buffer.alloc(8);
        temp.writeUInt32LE(value[1], 0);
        temp.writeUInt32LE(value[0], 4);
        this.writeBuffer(temp.subarray(0, 7), 7);
    }
    readUInt56SB() {
        const lsb = this.readUInt32();
        const xsb = this.readUInt16();
        const msb = this.readUInt8();
        return [msb, xsb, lsb];
    }
    readUInt64SB() {
        // XXX: not following pattern, should return as [msb, lsb]
        return this.readIeeeAddr();
    }
    writeUInt64SB(value) {
        // XXX: not following pattern, should pass as number[]
        const msb = parseInt(value.slice(2, 10), 16);
        const lsb = parseInt(value.slice(10), 16);
        this.writeUInt32(lsb);
        this.writeUInt32(msb);
    }
    writeInt40SB(value) {
        this.writeInt32(value[1]);
        this.writeInt8(value[0]);
    }
    readInt40SB() {
        const lsb = this.readInt32();
        const msb = this.readInt8();
        return [msb, lsb];
    }
    writeInt56SB(value) {
        const temp = Buffer.alloc(8);
        temp.writeInt32LE(value[1], 0);
        temp.writeInt32LE(value[0], 4);
        this.writeBuffer(temp.subarray(0, 7), 7);
    }
    readInt56SB() {
        const lsb = this.readInt32();
        const xsb = this.readInt16();
        const msb = this.readInt8();
        return [msb, xsb, lsb];
    }
    writeInt64SB(value) {
        this.writeInt32(value[1]);
        this.writeInt32(value[0]);
    }
    readInt64SB() {
        const lsb = this.readInt32();
        const msb = this.readInt32();
        return [msb, lsb];
    }
    writeOctetStr(value) {
        // TODO: this does not allow "non-value" 0xFF
        this.writeUInt8(value.length);
        this.writeBuffer(value, value.length);
    }
    readOctetStr() {
        const length = this.readUInt8();
        return (length < 0xFF) ? this.readBuffer(length) : Buffer.from([]); // non-value
    }
    writeCharStr(value) {
        // TODO: this does not allow "non-value" 0xFF
        if (typeof value === 'string') {
            this.writeUInt8(value.length);
            this.writeUtf8String(value);
        }
        else {
            this.writeBuffer(value, value.length);
        }
    }
    readCharStr(options) {
        const length = this.readUInt8();
        // TODO: this workaround should be moved to a custom type
        if (options.attrId === 65281) {
            const value = {};
            if (length === 0xFF) {
                return value;
            }
            // Xiaomi struct parsing
            for (let i = 0; i < length; i++) {
                const index = this.readUInt8();
                const dataType = this.readUInt8();
                value[index] = this.read(dataType, {});
                if (this.position === this.buffer.length) {
                    break;
                }
            }
            return value;
        }
        else {
            return (length < 0xFF) ? this.readUtf8String(length) : '';
        }
    }
    writeLongOctetStr(value) {
        // TODO: this does not allow "non-value" 0xFF
        this.writeUInt16(value.length);
        this.writeBuffer(value, value.length);
    }
    readLongOctetStr() {
        const length = this.readUInt16();
        return (length < 0xFFFF) ? this.readBuffer(length) : Buffer.from([]); // non-value
    }
    writeLongCharStr(value) {
        // TODO: this does not allow "non-value" 0xFF
        this.writeUInt16(value.length);
        this.writeUtf8String(value);
    }
    readLongCharStr() {
        const length = this.readUInt16();
        return (length < 0xFFFF) ? this.readUtf8String(length) : ''; // non-value
    }
    writeArray(value) {
        const elTypeNumeric = typeof value.elementType === 'number' ? value.elementType : definition_1.DataType[value.elementType];
        this.writeUInt8(elTypeNumeric);
        // TODO: this does not allow writing "non-value" 0xFFFF
        this.writeUInt16(value.elements.length);
        for (const element of value.elements) {
            this.write(elTypeNumeric, element, {});
        }
        ;
    }
    readArray() {
        const values = [];
        const elementType = this.readUInt8();
        const numberOfElements = this.readUInt16();
        if (numberOfElements < 0xFFFF) {
            for (let i = 0; i < numberOfElements; i++) {
                const value = this.read(elementType, {});
                values.push(value);
            }
        }
        return values;
    }
    writeStruct(value) {
        // XXX: from ZCL spec: "The zeroth element may not be written to."
        //      how does this translates to writing here?
        // TODO: this does not allow writing "non-value" 0xFFFF
        this.writeUInt16(value.length);
        for (const v of value) {
            this.writeUInt8(v.elmType);
            this.write(v.elmType, v.elmVal, {});
        }
    }
    readStruct() {
        const values = [];
        const numberOfElements = this.readUInt16();
        if (numberOfElements < 0xFFFF) {
            for (let i = 0; i < numberOfElements; i++) {
                const elementType = this.readUInt8();
                const value = this.read(elementType, {});
                values.push({ elmType: elementType, elmVal: value });
            }
        }
        return values;
    }
    writeToD(value) {
        this.writeUInt8(value.hours ?? 0xFF);
        this.writeUInt8(value.minutes ?? 0xFF);
        this.writeUInt8(value.seconds ?? 0xFF);
        this.writeUInt8(value.hundredths ?? 0xFF);
    }
    readToD() {
        const hours = this.readUInt8();
        const minutes = this.readUInt8();
        const seconds = this.readUInt8();
        const hundredths = this.readUInt8();
        return { hours, minutes, seconds, hundredths };
    }
    writeDate(value) {
        this.writeUInt8(value.year != null ? (value.year - 1900) : 0xFF);
        this.writeUInt8(value.month ?? 0xFF);
        this.writeUInt8(value.dayOfMonth ?? 0xFF);
        this.writeUInt8(value.dayOfWeek ?? 0xFF);
    }
    readDate() {
        const year = this.readUInt8() + 1900;
        const month = this.readUInt8();
        const dayOfMonth = this.readUInt8();
        const dayOfWeek = this.readUInt8();
        return { year, month, dayOfMonth, dayOfWeek };
    }
    //--- BuffaloZclDataType
    writeListZoneInfo(values) {
        for (const value of values) {
            this.writeUInt8(value.zoneID);
            this.writeUInt16(value.zoneStatus);
        }
    }
    readListZoneInfo(length) {
        const value = [];
        for (let i = 0; i < length; i++) {
            value.push({
                zoneID: this.readUInt8(),
                zoneStatus: this.readUInt16(),
            });
        }
        return value;
    }
    writeExtensionFieldSets(values) {
        for (const value of values) {
            this.writeUInt16(value.clstId);
            this.writeUInt8(value.len);
            value.extField.forEach((entry, index) => {
                this.write(extensionFieldSetsDateTypeLookup[value.clstId][index], entry, {});
            });
        }
    }
    readExtensionFieldSets() {
        const value = [];
        while (this.isMore()) {
            const clstId = this.readUInt16();
            const len = this.readUInt8();
            const end = this.getPosition() + len;
            let index = 0;
            const extField = [];
            while (this.getPosition() < end) {
                extField.push(this.read(extensionFieldSetsDateTypeLookup[clstId][index], {}));
                index++;
            }
            value.push({ extField, clstId, len });
        }
        return value;
    }
    writeListThermoTransitions(value) {
        for (const entry of value) {
            this.writeUInt16(entry.transitionTime);
            if (entry.heatSetpoint != null) {
                this.writeUInt16(entry.heatSetpoint);
            }
            if (entry.coolSetpoint != null) {
                this.writeUInt16(entry.coolSetpoint);
            }
        }
    }
    readListThermoTransitions(options) {
        if (options.payload == null || options.payload.mode == null || options.payload.numoftrans == null) {
            throw new Error('Cannot read LIST_THERMO_TRANSITIONS without required payload options specified');
        }
        const heat = options.payload.mode & 1;
        const cool = options.payload.mode & 2;
        const result = [];
        for (let i = 0; i < options.payload.numoftrans; i++) {
            const entry = {
                transitionTime: this.readUInt16()
            };
            if (heat) {
                entry.heatSetpoint = this.readUInt16();
            }
            if (cool) {
                entry.coolSetpoint = this.readUInt16();
            }
            result.push(entry);
        }
        return result;
    }
    writeGdpFrame(value) {
        if (value.commandID == 0xF0) { // Commissioning Reply
            const v = value;
            const panIDPresent = v.options & (1 << 0);
            const gpdSecurityKeyPresent = v.options & (1 << 1);
            const gpdKeyEncryption = v.options & (1 << 2);
            const securityLevel = v.options & (3 << 3) >> 3;
            const hasGPDKeyMIC = gpdKeyEncryption && gpdSecurityKeyPresent;
            const hasFrameCounter = gpdSecurityKeyPresent &&
                gpdKeyEncryption &&
                (securityLevel === 0b10 || securityLevel === 0b11);
            this.writeUInt8(1 +
                (panIDPresent ? 2 : 0) +
                (gpdSecurityKeyPresent ? 16 : 0) +
                (hasGPDKeyMIC ? 4 : 0) +
                (hasFrameCounter ? 4 : 0)); // Length
            this.writeUInt8(v.options);
            if (panIDPresent) {
                this.writeUInt16(v.panID);
            }
            if (gpdSecurityKeyPresent) {
                this.writeBuffer(v.securityKey, 16);
            }
            if (hasGPDKeyMIC) {
                this.writeUInt32(v.keyMic);
            }
            if (hasFrameCounter) {
                this.writeUInt32(v.frameCounter);
            }
        }
        else if (value.commandID == 0xF3) { // Channel configuration
            const v = value;
            this.writeUInt8(1);
            this.writeUInt8(v.operationalChannel & 0xF | ((v.basic ? 1 : 0) << 4));
        }
        else if (value.commandID == 0xF4 ||
            value.commandID == 0xF5 ||
            (value.commandID >= 0xF7 && value.commandID <= 0xFF)) {
            // Other commands sent to GPD
            const v = value;
            this.writeUInt8(v.buffer.length);
            this.writeBuffer(v.buffer, v.buffer.length);
        }
    }
    readGdpFrame(options) {
        // Commisioning
        if (options.payload?.commandID === 0xE0) {
            const frame = {
                deviceID: this.readUInt8(),
                options: this.readUInt8(),
                extendedOptions: 0,
                securityKey: Buffer.alloc(16),
                keyMic: 0,
                outgoingCounter: 0,
                applicationInfo: 0,
                manufacturerID: 0,
                modelID: 0,
                numGdpCommands: 0,
                gpdCommandIdList: Buffer.alloc(0),
                numServerClusters: 0,
                numClientClusters: 0,
                gpdServerClusters: Buffer.alloc(0),
                gpdClientClusters: Buffer.alloc(0),
            };
            if (frame.options & 0x80) {
                frame.extendedOptions = this.readUInt8();
            }
            if (frame.extendedOptions & 0x20) {
                frame.securityKey = this.readBuffer(16);
            }
            if (frame.extendedOptions & 0x40) {
                frame.keyMic = this.readUInt32();
            }
            if (frame.extendedOptions & 0x80) {
                frame.outgoingCounter = this.readUInt32();
            }
            if (frame.options & 0x04) {
                frame.applicationInfo = this.readUInt8();
            }
            if (frame.applicationInfo & 0x01) {
                frame.manufacturerID = this.readUInt16();
            }
            if (frame.applicationInfo & 0x02) {
                frame.modelID = this.readUInt16();
            }
            if (frame.applicationInfo & 0x04) {
                frame.numGdpCommands = this.readUInt8();
                frame.gpdCommandIdList = this.readBuffer(frame.numGdpCommands);
            }
            if (frame.applicationInfo & 0x08) {
                const len = this.readUInt8();
                frame.numServerClusters = len & 0xF;
                frame.numClientClusters = (len >> 4) & 0xF;
                frame.gpdServerClusters = this.readBuffer(2 * frame.numServerClusters);
                frame.gpdClientClusters = this.readBuffer(2 * frame.numClientClusters);
            }
            return frame;
            // Channel Request
        }
        else if (options.payload?.commandID === 0xE3) {
            const options = this.readUInt8();
            return {
                nextChannel: options & 0xF,
                nextNextChannel: options >> 4,
            };
            // Manufacturer-specific Attribute Reporting
        }
        else if (options.payload?.commandID == 0xA1) {
            if (options.payload.payloadSize == null) {
                throw new Error('Cannot read GDP_FRAME with commandID=0xA1 without payloadSize options specified');
            }
            const start = this.position;
            const frame = {
                manufacturerCode: this.readUInt16(),
                clusterID: this.readUInt16(),
                attributes: {},
            };
            const cluster = Utils.getCluster(frame.clusterID, frame.manufacturerCode, {});
            while (this.position - start < options.payload.payloadSize) {
                const attributeID = this.readUInt16();
                const type = this.readUInt8();
                let attribute = attributeID;
                try {
                    attribute = cluster.getAttribute(attributeID).name;
                }
                catch {
                    logger_1.logger.debug("Unknown attribute " + attributeID + " in cluster " + cluster.name, NS);
                }
                frame.attributes[attribute] = this.read(type, options);
            }
            return frame;
        }
        else if (this.position != this.buffer.length) {
            return { raw: this.buffer.subarray(this.position) };
        }
        else {
            return {};
        }
    }
    writeStructuredSelector(value) {
        if (value != null) {
            const indexes = value.indexes || [];
            const indicatorType = value.indicatorType || tstype_1.StructuredIndicatorType.Whole;
            const indicator = indexes.length + indicatorType;
            this.writeUInt8(indicator);
            for (const index of indexes) {
                this.writeUInt16(index);
            }
        }
    }
    readStructuredSelector() {
        /** [0-15] range */
        const indicator = this.readUInt8();
        if (indicator === 0) {
            // no indexes, whole attribute value is to be read
            return { indicatorType: tstype_1.StructuredIndicatorType.Whole };
        }
        else {
            const indexes = [];
            for (let i = 0; i < indicator; i++) {
                const index = this.readUInt16();
                indexes.push(index);
            }
            return { indexes };
        }
    }
    writeListTuyaDataPointValues(dpValues) {
        for (const dpValue of dpValues) {
            this.writeUInt8(dpValue.dp);
            this.writeUInt8(dpValue.datatype);
            const dataLen = dpValue.data.length;
            this.writeUInt8((dataLen >> 8) & 0xFF);
            this.writeUInt8(dataLen & 0xFF);
            this.writeBuffer(dpValue.data, dataLen);
        }
    }
    readListTuyaDataPointValues() {
        const value = [];
        while (this.isMore()) {
            try {
                const dp = this.readUInt8();
                const datatype = this.readUInt8();
                const len_hi = this.readUInt8();
                const len_lo = this.readUInt8();
                const data = this.readBuffer(len_lo + (len_hi << 8));
                value.push({ dp, datatype, data });
            }
            catch (error) {
                break;
            }
        }
        return value;
    }
    writeListMiboxerZones(values) {
        this.writeUInt8(values.length);
        for (const value of values) {
            this.writeUInt16(value.groupId);
            this.writeUInt8(value.zoneNum);
        }
    }
    readListMiboxerZones() {
        const value = [];
        const len = this.readUInt8();
        for (let i = 0; i < len; i++) {
            value.push({
                groupId: this.readUInt16(),
                zoneNum: this.readUInt8(),
            });
        }
        return value;
    }
    writeBigEndianUInt24(value) {
        this.buffer.writeUIntBE(value, this.position, 3);
        this.position += 3;
    }
    readBigEndianUInt24() {
        const value = this.buffer.readUIntBE(this.position, 3);
        this.position += 3;
        return value;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    write(type, value, options) {
        switch (type) {
            case definition_1.DataType.NO_DATA:
            case definition_1.DataType.UNKNOWN: {
                return; // nothing to write
            }
            case definition_1.DataType.DATA8:
            case definition_1.DataType.BOOLEAN:
            case definition_1.DataType.BITMAP8:
            case definition_1.DataType.UINT8:
            case definition_1.DataType.ENUM8: {
                return this.writeUInt8(value);
            }
            case definition_1.DataType.DATA16:
            case definition_1.DataType.BITMAP16:
            case definition_1.DataType.UINT16:
            case definition_1.DataType.ENUM16:
            case definition_1.DataType.CLUSTER_ID:
            case definition_1.DataType.ATTR_ID: {
                return this.writeUInt16(value);
            }
            case definition_1.DataType.DATA24:
            case definition_1.DataType.BITMAP24:
            case definition_1.DataType.UINT24: {
                return this.writeUInt24(value);
            }
            case definition_1.DataType.DATA32:
            case definition_1.DataType.BITMAP32:
            case definition_1.DataType.UINT32:
            case definition_1.DataType.UTC:
            case definition_1.DataType.BAC_OID: {
                return this.writeUInt32(value);
            }
            case definition_1.DataType.DATA40:
            case definition_1.DataType.BITMAP40:
            case definition_1.DataType.UINT40: {
                return this.writeUInt40SB(value);
            }
            case definition_1.DataType.DATA48:
            case definition_1.DataType.BITMAP48:
            case definition_1.DataType.UINT48: {
                return this.writeUInt48SB(value);
            }
            case definition_1.DataType.DATA56:
            case definition_1.DataType.BITMAP56:
            case definition_1.DataType.UINT56: {
                return this.writeUInt56SB(value);
            }
            case definition_1.DataType.DATA64:
            case definition_1.DataType.BITMAP64:
            case definition_1.DataType.UINT64: {
                return this.writeUInt64SB(value);
            }
            case definition_1.DataType.INT8: {
                return this.writeInt8(value);
            }
            case definition_1.DataType.INT16: {
                return this.writeInt16(value);
            }
            case definition_1.DataType.INT24: {
                return this.writeInt24(value);
            }
            case definition_1.DataType.INT32: {
                return this.writeInt32(value);
            }
            case definition_1.DataType.INT40: {
                return this.writeInt40SB(value);
            }
            case definition_1.DataType.INT48: {
                return this.writeInt48(value);
            }
            case definition_1.DataType.INT56: {
                return this.writeInt56SB(value);
            }
            case definition_1.DataType.INT64: {
                return this.writeInt64SB(value);
            }
            // case DataType.SEMI_PREC: {
            //     // https://tc39.es/proposal-float16array/
            //     // not currently used
            //     return this.writeSemiFloatLE(value);
            // }
            case definition_1.DataType.SINGLE_PREC: {
                return this.writeFloatLE(value);
            }
            case definition_1.DataType.DOUBLE_PREC: {
                return this.writeDoubleLE(value);
            }
            case definition_1.DataType.OCTET_STR: {
                return this.writeOctetStr(value);
            }
            case definition_1.DataType.CHAR_STR: {
                return this.writeCharStr(value);
            }
            case definition_1.DataType.LONG_OCTET_STR: {
                return this.writeLongOctetStr(value);
            }
            case definition_1.DataType.LONG_CHAR_STR: {
                return this.writeLongCharStr(value);
            }
            case definition_1.DataType.ARRAY:
            case definition_1.DataType.SET:
            case definition_1.DataType.BAG: {
                return this.writeArray(value);
            }
            case definition_1.DataType.STRUCT: {
                return this.writeStruct(value);
            }
            case definition_1.DataType.TOD: {
                return this.writeToD(value);
            }
            case definition_1.DataType.DATE: {
                return this.writeDate(value);
            }
            case definition_1.DataType.IEEE_ADDR: {
                return this.writeIeeeAddr(value);
            }
            case definition_1.DataType.SEC_KEY: {
                return this.writeBuffer(value, SEC_KEY_LENGTH);
            }
            case definition_1.BuffaloZclDataType.USE_DATA_TYPE: {
                if (options.dataType == null) {
                    if (Buffer.isBuffer(value) || (0, utils_1.IsNumberArray)(value)) {
                        return this.writeBuffer(value, value.length);
                    }
                    else {
                        throw new Error('Cannot write USE_DATA_TYPE without dataType option specified');
                    }
                }
                return this.write(options.dataType, value, options);
            }
            case definition_1.BuffaloZclDataType.LIST_UINT8: {
                return this.writeListUInt8(value);
            }
            case definition_1.BuffaloZclDataType.LIST_UINT16: {
                return this.writeListUInt16(value);
            }
            case definition_1.BuffaloZclDataType.LIST_UINT24: {
                return this.writeListUInt24(value);
            }
            case definition_1.BuffaloZclDataType.LIST_UINT32: {
                return this.writeListUInt32(value);
            }
            case definition_1.BuffaloZclDataType.LIST_ZONEINFO: {
                return this.writeListZoneInfo(value);
            }
            case definition_1.BuffaloZclDataType.EXTENSION_FIELD_SETS: {
                return this.writeExtensionFieldSets(value);
            }
            case definition_1.BuffaloZclDataType.LIST_THERMO_TRANSITIONS: {
                return this.writeListThermoTransitions(value);
            }
            case definition_1.BuffaloZclDataType.BUFFER: {
                return this.writeBuffer(value, value.length);
            }
            case definition_1.BuffaloZclDataType.GDP_FRAME: {
                return this.writeGdpFrame(value);
            }
            case definition_1.BuffaloZclDataType.STRUCTURED_SELECTOR: {
                return this.writeStructuredSelector(value);
            }
            case definition_1.BuffaloZclDataType.LIST_TUYA_DATAPOINT_VALUES: {
                return this.writeListTuyaDataPointValues(value);
            }
            case definition_1.BuffaloZclDataType.LIST_MIBOXER_ZONES: {
                return this.writeListMiboxerZones(value);
            }
            case definition_1.BuffaloZclDataType.BIG_ENDIAN_UINT24: {
                return this.writeBigEndianUInt24(value);
            }
            default: {
                // In case the type is undefined, write it as a buffer to easily allow for custom types
                // e.g. for https://github.com/Koenkk/zigbee-herdsman/issues/127
                if (Buffer.isBuffer(value) || (0, utils_1.IsNumberArray)(value)) {
                    return this.writeBuffer(value, value.length);
                }
            }
        }
        throw new Error(`Write for '${type}' not available`);
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    read(type, options) {
        switch (type) {
            case definition_1.DataType.NO_DATA:
            case definition_1.DataType.UNKNOWN: {
                return; // nothing to write
            }
            case definition_1.DataType.DATA8:
            case definition_1.DataType.BOOLEAN:
            case definition_1.DataType.BITMAP8:
            case definition_1.DataType.UINT8:
            case definition_1.DataType.ENUM8: {
                return this.readUInt8();
            }
            case definition_1.DataType.DATA16:
            case definition_1.DataType.BITMAP16:
            case definition_1.DataType.UINT16:
            case definition_1.DataType.ENUM16:
            case definition_1.DataType.CLUSTER_ID:
            case definition_1.DataType.ATTR_ID: {
                return this.readUInt16();
            }
            case definition_1.DataType.DATA24:
            case definition_1.DataType.BITMAP24:
            case definition_1.DataType.UINT24: {
                return this.readUInt24();
            }
            case definition_1.DataType.DATA32:
            case definition_1.DataType.BITMAP32:
            case definition_1.DataType.UINT32:
            case definition_1.DataType.UTC:
            case definition_1.DataType.BAC_OID: {
                return this.readUInt32();
            }
            case definition_1.DataType.DATA40:
            case definition_1.DataType.BITMAP40:
            case definition_1.DataType.UINT40: {
                return this.readUInt40SB();
            }
            case definition_1.DataType.DATA48:
            case definition_1.DataType.BITMAP48:
            case definition_1.DataType.UINT48: {
                return this.readUInt48SB();
            }
            case definition_1.DataType.DATA56:
            case definition_1.DataType.BITMAP56:
            case definition_1.DataType.UINT56: {
                return this.readUInt56SB();
            }
            case definition_1.DataType.DATA64:
            case definition_1.DataType.BITMAP64:
            case definition_1.DataType.UINT64: {
                return this.readUInt64SB();
            }
            case definition_1.DataType.INT8: {
                return this.readInt8();
            }
            case definition_1.DataType.INT16: {
                return this.readInt16();
            }
            case definition_1.DataType.INT24: {
                return this.readInt24();
            }
            case definition_1.DataType.INT32: {
                return this.readInt32();
            }
            case definition_1.DataType.INT40: {
                return this.readInt40SB();
            }
            case definition_1.DataType.INT48: {
                return this.readInt48();
            }
            case definition_1.DataType.INT56: {
                return this.readInt56SB();
            }
            case definition_1.DataType.INT64: {
                return this.readInt64SB();
            }
            // case DataType.SEMI_PREC: {
            //     // https://tc39.es/proposal-float16array/
            //     // not currently used
            //     return this.readSemiFloatLE();
            // }
            case definition_1.DataType.SINGLE_PREC: {
                return this.readFloatLE();
            }
            case definition_1.DataType.DOUBLE_PREC: {
                return this.readDoubleLE();
            }
            case definition_1.DataType.OCTET_STR: {
                return this.readOctetStr();
            }
            case definition_1.DataType.CHAR_STR: {
                return this.readCharStr(options);
            }
            case definition_1.DataType.LONG_OCTET_STR: {
                return this.readLongOctetStr();
            }
            case definition_1.DataType.LONG_CHAR_STR: {
                return this.readLongCharStr();
            }
            case definition_1.DataType.ARRAY:
            case definition_1.DataType.SET:
            case definition_1.DataType.BAG: {
                return this.readArray();
            }
            case definition_1.DataType.STRUCT: {
                return this.readStruct();
            }
            case definition_1.DataType.TOD: {
                return this.readToD();
            }
            case definition_1.DataType.DATE: {
                return this.readDate();
            }
            case definition_1.DataType.IEEE_ADDR: {
                return this.readIeeeAddr();
            }
            case definition_1.DataType.SEC_KEY: {
                return this.readBuffer(SEC_KEY_LENGTH);
            }
            case definition_1.BuffaloZclDataType.USE_DATA_TYPE: {
                if (options.dataType == null) {
                    return this.readBuffer(options.length ?? this.buffer.length);
                }
                return this.read(options.dataType, options);
            }
            case definition_1.BuffaloZclDataType.LIST_UINT8: {
                if (options.length == null) {
                    throw new Error('Cannot read LIST_UINT8 without length option specified');
                }
                return this.readListUInt8(options.length);
            }
            case definition_1.BuffaloZclDataType.LIST_UINT16: {
                if (options.length == null) {
                    throw new Error('Cannot read LIST_UINT16 without length option specified');
                }
                return this.readListUInt16(options.length);
            }
            case definition_1.BuffaloZclDataType.LIST_UINT24: {
                if (options.length == null) {
                    throw new Error('Cannot read LIST_UINT24 without length option specified');
                }
                return this.readListUInt24(options.length);
            }
            case definition_1.BuffaloZclDataType.LIST_UINT32: {
                if (options.length == null) {
                    throw new Error('Cannot read LIST_UINT32 without length option specified');
                }
                return this.readListUInt32(options.length);
            }
            case definition_1.BuffaloZclDataType.LIST_ZONEINFO: {
                if (options.length == null) {
                    throw new Error('Cannot read LIST_ZONEINFO without length option specified');
                }
                return this.readListZoneInfo(options.length);
            }
            case definition_1.BuffaloZclDataType.EXTENSION_FIELD_SETS: {
                return this.readExtensionFieldSets();
            }
            case definition_1.BuffaloZclDataType.LIST_THERMO_TRANSITIONS: {
                return this.readListThermoTransitions(options);
            }
            case definition_1.BuffaloZclDataType.BUFFER: {
                // if length option not specified, read the whole buffer
                return this.readBuffer(options.length ?? this.buffer.length);
            }
            case definition_1.BuffaloZclDataType.GDP_FRAME: {
                return this.readGdpFrame(options);
            }
            case definition_1.BuffaloZclDataType.STRUCTURED_SELECTOR: {
                return this.readStructuredSelector();
            }
            case definition_1.BuffaloZclDataType.LIST_TUYA_DATAPOINT_VALUES: {
                return this.readListTuyaDataPointValues();
            }
            case definition_1.BuffaloZclDataType.LIST_MIBOXER_ZONES: {
                return this.readListMiboxerZones();
            }
            case definition_1.BuffaloZclDataType.BIG_ENDIAN_UINT24: {
                return this.readBigEndianUInt24();
            }
        }
        throw new Error(`Read for '${type}' not available`);
    }
}
exports.default = BuffaloZcl;
//# sourceMappingURL=buffaloZcl.js.map