"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint max-len: 0 */
const dataType_1 = __importDefault(require("./dataType"));
const buffaloZclDataType_1 = __importDefault(require("./buffaloZclDataType"));
const manufacturerCode_1 = __importDefault(require("./manufacturerCode"));
const Clusters = {
    genBasic: {
        ID: 0,
        attributes: {
            zclVersion: { ID: 0, type: dataType_1.default.UINT8 },
            appVersion: { ID: 1, type: dataType_1.default.UINT8 },
            stackVersion: { ID: 2, type: dataType_1.default.UINT8 },
            hwVersion: { ID: 3, type: dataType_1.default.UINT8 },
            manufacturerName: { ID: 4, type: dataType_1.default.CHAR_STR },
            modelId: { ID: 5, type: dataType_1.default.CHAR_STR },
            dateCode: { ID: 6, type: dataType_1.default.CHAR_STR },
            powerSource: { ID: 7, type: dataType_1.default.ENUM8 },
            appProfileVersion: { ID: 8, type: dataType_1.default.ENUM8 },
            swBuildId: { ID: 16384, type: dataType_1.default.CHAR_STR },
            locationDesc: { ID: 16, type: dataType_1.default.CHAR_STR },
            physicalEnv: { ID: 17, type: dataType_1.default.ENUM8 },
            deviceEnabled: { ID: 18, type: dataType_1.default.BOOLEAN },
            alarmMask: { ID: 19, type: dataType_1.default.BITMAP8 },
            disableLocalConfig: { ID: 20, type: dataType_1.default.BITMAP8 },
            develcoPrimarySwVersion: { ID: 0x8000, type: dataType_1.default.OCTET_STR, manufacturerCode: manufacturerCode_1.default.DEVELCO },
            develcoPrimaryHwVersion: { ID: 0x8020, type: dataType_1.default.OCTET_STR, manufacturerCode: manufacturerCode_1.default.DEVELCO },
            develcoLedControl: { ID: 0x8100, type: dataType_1.default.BITMAP8, manufacturerCode: manufacturerCode_1.default.DEVELCO },
            schneiderMeterRadioPower: { ID: 0xE200, type: dataType_1.default.INT8, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
        },
        commands: {
            resetFactDefault: {
                ID: 0,
                parameters: [],
            },
            tuyaSetup: {
                ID: 0xf0,
                parameters: [],
            },
        },
        commandsResponse: {},
    },
    genPowerCfg: {
        ID: 1,
        attributes: {
            mainsVoltage: { ID: 0, type: dataType_1.default.UINT16 },
            mainsFrequency: { ID: 1, type: dataType_1.default.UINT8 },
            mainsAlarmMask: { ID: 16, type: dataType_1.default.BITMAP8 },
            mainsVoltMinThres: { ID: 17, type: dataType_1.default.UINT16 },
            mainsVoltMaxThres: { ID: 18, type: dataType_1.default.UINT16 },
            mainsVoltageDwellTripPoint: { ID: 19, type: dataType_1.default.UINT16 },
            batteryVoltage: { ID: 32, type: dataType_1.default.UINT8 },
            batteryPercentageRemaining: { ID: 33, type: dataType_1.default.UINT8 },
            batteryManufacturer: { ID: 48, type: dataType_1.default.CHAR_STR },
            batterySize: { ID: 49, type: dataType_1.default.ENUM8 },
            batteryAHrRating: { ID: 50, type: dataType_1.default.UINT16 },
            batteryQuantity: { ID: 51, type: dataType_1.default.UINT8 },
            batteryRatedVoltage: { ID: 52, type: dataType_1.default.UINT8 },
            batteryAlarmMask: { ID: 53, type: dataType_1.default.BITMAP8 },
            batteryVoltMinThres: { ID: 54, type: dataType_1.default.UINT8 },
            batteryVoltThres1: { ID: 55, type: dataType_1.default.UINT8 },
            batteryVoltThres2: { ID: 56, type: dataType_1.default.UINT8 },
            batteryVoltThres3: { ID: 57, type: dataType_1.default.UINT8 },
            batteryPercentMinThres: { ID: 58, type: dataType_1.default.UINT8 },
            batteryPercentThres1: { ID: 59, type: dataType_1.default.UINT8 },
            batteryPercentThres2: { ID: 60, type: dataType_1.default.UINT8 },
            batteryPercentThres3: { ID: 61, type: dataType_1.default.UINT8 },
            batteryAlarmState: { ID: 62, type: dataType_1.default.BITMAP32 },
        },
        commands: {},
        commandsResponse: {},
    },
    genDeviceTempCfg: {
        ID: 2,
        attributes: {
            currentTemperature: { ID: 0, type: dataType_1.default.INT16 },
            minTempExperienced: { ID: 1, type: dataType_1.default.INT16 },
            maxTempExperienced: { ID: 2, type: dataType_1.default.INT16 },
            overTempTotalDwell: { ID: 3, type: dataType_1.default.UINT16 },
            devTempAlarmMask: { ID: 16, type: dataType_1.default.BITMAP8 },
            lowTempThres: { ID: 17, type: dataType_1.default.INT16 },
            highTempThres: { ID: 18, type: dataType_1.default.INT16 },
            lowTempDwellTripPoint: { ID: 19, type: dataType_1.default.UINT24 },
            highTempDwellTripPoint: { ID: 20, type: dataType_1.default.UINT24 },
        },
        commands: {},
        commandsResponse: {},
    },
    genIdentify: {
        ID: 3,
        attributes: {
            identifyTime: { ID: 0, type: dataType_1.default.UINT16 },
            identifyCommissionState: { ID: 1, type: dataType_1.default.UNKNOWN },
        },
        commands: {
            identify: {
                ID: 0,
                parameters: [
                    { name: 'identifytime', type: dataType_1.default.UINT16 },
                ],
            },
            identifyQuery: {
                ID: 1,
                parameters: [],
            },
            ezmodeInvoke: {
                ID: 2,
                parameters: [
                    { name: 'action', type: dataType_1.default.UINT8 },
                ],
            },
            updateCommissionState: {
                ID: 3,
                parameters: [
                    { name: 'action', type: dataType_1.default.UINT8 },
                    { name: 'commstatemask', type: dataType_1.default.UINT8 },
                ],
            },
            triggerEffect: {
                ID: 64,
                parameters: [
                    { name: 'effectid', type: dataType_1.default.UINT8 },
                    { name: 'effectvariant', type: dataType_1.default.UINT8 },
                ],
            },
        },
        commandsResponse: {
            identifyQueryRsp: {
                ID: 0,
                parameters: [
                    { name: 'timeout', type: dataType_1.default.UINT16 },
                ],
            },
        },
    },
    genGroups: {
        ID: 4,
        attributes: {
            nameSupport: { ID: 0, type: dataType_1.default.BITMAP8 },
        },
        commands: {
            add: {
                ID: 0,
                response: 0,
                parameters: [
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                    { name: 'groupname', type: dataType_1.default.CHAR_STR },
                ],
            },
            view: {
                ID: 1,
                parameters: [
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                ],
            },
            getMembership: {
                ID: 2,
                response: 2,
                parameters: [
                    { name: 'groupcount', type: dataType_1.default.UINT8 },
                    { name: 'grouplist', type: buffaloZclDataType_1.default.LIST_UINT16 },
                ],
            },
            remove: {
                ID: 3,
                response: 3,
                parameters: [
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                ],
            },
            removeAll: {
                ID: 4,
                parameters: [],
            },
            addIfIdentifying: {
                ID: 5,
                parameters: [
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                    { name: 'groupname', type: dataType_1.default.CHAR_STR },
                ],
            },
            miboxerSetZones: {
                ID: 0xf0,
                parameters: [
                    { name: 'zones', type: buffaloZclDataType_1.default.LIST_MIBOXER_ZONES },
                ],
            }
        },
        commandsResponse: {
            addRsp: {
                ID: 0,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                ],
            },
            viewRsp: {
                ID: 1,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                    { name: 'groupname', type: dataType_1.default.CHAR_STR },
                ],
            },
            getMembershipRsp: {
                ID: 2,
                parameters: [
                    { name: 'capacity', type: dataType_1.default.UINT8 },
                    { name: 'groupcount', type: dataType_1.default.UINT8 },
                    { name: 'grouplist', type: buffaloZclDataType_1.default.LIST_UINT16 },
                ],
            },
            removeRsp: {
                ID: 3,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                ],
            },
        },
    },
    genScenes: {
        ID: 5,
        attributes: {
            count: { ID: 0, type: dataType_1.default.UINT8 },
            currentScene: { ID: 1, type: dataType_1.default.UINT8 },
            currentGroup: { ID: 2, type: dataType_1.default.UINT16 },
            sceneValid: { ID: 3, type: dataType_1.default.BOOLEAN },
            nameSupport: { ID: 4, type: dataType_1.default.BITMAP8 },
            lastCfgBy: { ID: 5, type: dataType_1.default.IEEE_ADDR },
        },
        commands: {
            add: {
                ID: 0,
                response: 0,
                parameters: [
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                    { name: 'sceneid', type: dataType_1.default.UINT8 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                    { name: 'scenename', type: dataType_1.default.CHAR_STR },
                    { name: 'extensionfieldsets', type: buffaloZclDataType_1.default.EXTENSION_FIELD_SETS },
                ],
            },
            view: {
                ID: 1,
                response: 1,
                parameters: [
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                    { name: 'sceneid', type: dataType_1.default.UINT8 },
                ],
            },
            remove: {
                ID: 2,
                response: 2,
                parameters: [
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                    { name: 'sceneid', type: dataType_1.default.UINT8 },
                ],
            },
            removeAll: {
                ID: 3,
                response: 3,
                parameters: [
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                ],
            },
            store: {
                ID: 4,
                response: 4,
                parameters: [
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                    { name: 'sceneid', type: dataType_1.default.UINT8 },
                ],
            },
            recall: {
                ID: 5,
                parameters: [
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                    { name: 'sceneid', type: dataType_1.default.UINT8 },
                ],
            },
            getSceneMembership: {
                ID: 6,
                response: 6,
                parameters: [
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                ],
            },
            enhancedAdd: {
                ID: 64,
                response: 64,
                parameters: [
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                    { name: 'sceneid', type: dataType_1.default.UINT8 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                    { name: 'scenename', type: dataType_1.default.CHAR_STR },
                    { name: 'extensionfieldsets', type: buffaloZclDataType_1.default.EXTENSION_FIELD_SETS },
                ],
            },
            enhancedView: {
                ID: 65,
                response: 65,
                parameters: [
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                    { name: 'sceneid', type: dataType_1.default.UINT8 },
                ],
            },
            copy: {
                ID: 66,
                response: 66,
                parameters: [
                    { name: 'mode', type: dataType_1.default.UINT8 },
                    { name: 'groupidfrom', type: dataType_1.default.UINT16 },
                    { name: 'sceneidfrom', type: dataType_1.default.UINT8 },
                    { name: 'groupidto', type: dataType_1.default.UINT16 },
                    { name: 'sceneidto', type: dataType_1.default.UINT8 },
                ],
            },
            tradfriArrowSingle: {
                ID: 7,
                parameters: [
                    { name: 'value', type: dataType_1.default.UINT16 },
                    { name: 'value2', type: dataType_1.default.UINT16 },
                ],
            },
            tradfriArrowHold: {
                ID: 8,
                parameters: [
                    { name: 'value', type: dataType_1.default.UINT16 },
                ],
            },
            tradfriArrowRelease: {
                ID: 9,
                parameters: [
                    { name: 'value', type: dataType_1.default.UINT16 },
                ],
            },
        },
        commandsResponse: {
            addRsp: {
                ID: 0,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'groupId', type: dataType_1.default.UINT16 },
                    { name: 'sceneId', type: dataType_1.default.UINT8 },
                ],
            },
            viewRsp: {
                ID: 1,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                    { name: 'sceneid', type: dataType_1.default.UINT8 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                    { name: 'scenename', type: dataType_1.default.CHAR_STR },
                    { name: 'extensionfieldsets', type: buffaloZclDataType_1.default.EXTENSION_FIELD_SETS },
                ],
            },
            removeRsp: {
                ID: 2,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                    { name: 'sceneid', type: dataType_1.default.UINT8 },
                ],
            },
            removeAllRsp: {
                ID: 3,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                ],
            },
            storeRsp: {
                ID: 4,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                    { name: 'sceneid', type: dataType_1.default.UINT8 },
                ],
            },
            getSceneMembershipRsp: {
                ID: 6,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'capacity', type: dataType_1.default.UINT8 },
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                    { name: 'scenecount', type: dataType_1.default.UINT8 },
                    { name: 'scenelist', type: buffaloZclDataType_1.default.LIST_UINT8 },
                ],
            },
            enhancedAddRsp: {
                ID: 64,
                parameters: [],
            },
            enhancedViewRsp: {
                ID: 65,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'groupid', type: dataType_1.default.UINT16 },
                    { name: 'sceneid', type: dataType_1.default.UINT8 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                    { name: 'scenename', type: dataType_1.default.CHAR_STR },
                    { name: 'extensionfieldsets', type: buffaloZclDataType_1.default.EXTENSION_FIELD_SETS },
                ],
            },
            copyRsp: {
                ID: 66,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'groupidfrom', type: dataType_1.default.UINT16 },
                    { name: 'sceneidfrom', type: dataType_1.default.UINT8 },
                ],
            },
        },
    },
    genOnOff: {
        ID: 6,
        attributes: {
            onOff: { ID: 0, type: dataType_1.default.BOOLEAN },
            globalSceneCtrl: { ID: 16384, type: dataType_1.default.BOOLEAN },
            onTime: { ID: 16385, type: dataType_1.default.UINT16 },
            offWaitTime: { ID: 16386, type: dataType_1.default.UINT16 },
            startUpOnOff: { ID: 16387, type: dataType_1.default.ENUM8 },
            tuyaBacklightSwitch: { ID: 0x5000, type: dataType_1.default.ENUM8 },
            tuyaBacklightMode: { ID: 0x8001, type: dataType_1.default.ENUM8 },
            moesStartUpOnOff: { ID: 0x8002, type: dataType_1.default.ENUM8 },
            tuyaOperationMode: { ID: 0x8004, type: dataType_1.default.ENUM8 },
            elkoPreWarningTime: { ID: 0xE000, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.ADEO },
            elkoOnTimeReload: { ID: 0xE001, type: dataType_1.default.UINT32, manufacturerCode: manufacturerCode_1.default.ADEO },
            elkoOnTimeReloadOptions: { ID: 0xE002, type: dataType_1.default.BITMAP8, manufacturerCode: manufacturerCode_1.default.ADEO },
            nodonTransitionTime: { ID: 0x0001, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.NODON },
        },
        commands: {
            off: {
                ID: 0,
                parameters: [],
            },
            on: {
                ID: 1,
                parameters: [],
            },
            toggle: {
                ID: 2,
                parameters: [],
            },
            offWithEffect: {
                ID: 64,
                parameters: [
                    { name: 'effectid', type: dataType_1.default.UINT8 },
                    { name: 'effectvariant', type: dataType_1.default.UINT8 },
                ],
            },
            onWithRecallGlobalScene: {
                ID: 65,
                parameters: [],
            },
            onWithTimedOff: {
                ID: 66,
                parameters: [
                    { name: 'ctrlbits', type: dataType_1.default.UINT8 },
                    { name: 'ontime', type: dataType_1.default.UINT16 },
                    { name: 'offwaittime', type: dataType_1.default.UINT16 },
                ],
            },
            tuyaAction: {
                ID: 0xFD,
                parameters: [
                    { name: 'value', type: dataType_1.default.UINT8 },
                    { name: 'data', type: buffaloZclDataType_1.default.BUFFER },
                ],
            },
            tuyaAction2: {
                ID: 0xFC,
                parameters: [
                    { name: 'value', type: dataType_1.default.UINT8 },
                ],
            },
        },
        commandsResponse: {},
    },
    genOnOffSwitchCfg: {
        ID: 7,
        attributes: {
            switchType: { ID: 0, type: dataType_1.default.ENUM8 },
            switchMultiFunction: { ID: 2, type: dataType_1.default.UNKNOWN },
            switchActions: { ID: 16, type: dataType_1.default.ENUM8 },
        },
        commands: {},
        commandsResponse: {},
    },
    genLevelCtrl: {
        ID: 8,
        attributes: {
            currentLevel: { ID: 0, type: dataType_1.default.UINT8 },
            remainingTime: { ID: 1, type: dataType_1.default.UINT16 },
            minLevel: { ID: 2, type: dataType_1.default.UINT8 },
            maxLevel: { ID: 3, type: dataType_1.default.UINT8 },
            options: { ID: 15, type: dataType_1.default.BITMAP8 },
            onOffTransitionTime: { ID: 16, type: dataType_1.default.UINT16 },
            onLevel: { ID: 17, type: dataType_1.default.UINT8 },
            onTransitionTime: { ID: 18, type: dataType_1.default.UINT16 },
            offTransitionTime: { ID: 19, type: dataType_1.default.UINT16 },
            defaultMoveRate: { ID: 20, type: dataType_1.default.UINT16 },
            startUpCurrentLevel: { ID: 16384, type: dataType_1.default.UINT8 },
            elkoStartUpCurrentLevel: { ID: 0x4000, type: dataType_1.default.UINT8, manufacturerCode: manufacturerCode_1.default.ADEO },
        },
        commands: {
            moveToLevel: {
                ID: 0,
                parameters: [
                    { name: 'level', type: dataType_1.default.UINT8 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                ],
            },
            move: {
                ID: 1,
                parameters: [
                    { name: 'movemode', type: dataType_1.default.UINT8 },
                    { name: 'rate', type: dataType_1.default.UINT8 },
                ],
            },
            step: {
                ID: 2,
                parameters: [
                    { name: 'stepmode', type: dataType_1.default.UINT8 },
                    { name: 'stepsize', type: dataType_1.default.UINT8 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                ],
            },
            stop: {
                ID: 3,
                parameters: [],
            },
            moveToLevelWithOnOff: {
                ID: 4,
                parameters: [
                    { name: 'level', type: dataType_1.default.UINT8 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                ],
            },
            moveWithOnOff: {
                ID: 5,
                parameters: [
                    { name: 'movemode', type: dataType_1.default.UINT8 },
                    { name: 'rate', type: dataType_1.default.UINT8 },
                ],
            },
            stepWithOnOff: {
                ID: 6,
                parameters: [
                    { name: 'stepmode', type: dataType_1.default.UINT8 },
                    { name: 'stepsize', type: dataType_1.default.UINT8 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                ],
            },
            stopWithOnOff: {
                ID: 7,
                parameters: [],
            },
            moveToLevelTuya: {
                ID: 240,
                parameters: [
                    { name: 'level', type: dataType_1.default.UINT16 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                ],
            },
        },
        commandsResponse: {},
    },
    genAlarms: {
        ID: 9,
        attributes: {
            alarmCount: { ID: 0, type: dataType_1.default.UINT16 },
        },
        commands: {
            reset: {
                ID: 0,
                parameters: [
                    { name: 'alarmcode', type: dataType_1.default.UINT8 },
                    { name: 'clusterid', type: dataType_1.default.UINT16 },
                ],
            },
            resetAll: {
                ID: 1,
                parameters: [],
            },
            getAlarm: {
                ID: 2,
                parameters: [],
            },
            resetLog: {
                ID: 3,
                parameters: [],
            },
            publishEventLog: {
                ID: 4,
                parameters: [],
            },
        },
        commandsResponse: {
            alarm: {
                ID: 0,
                parameters: [
                    { name: 'alarmcode', type: dataType_1.default.UINT8 },
                    { name: 'clusterid', type: dataType_1.default.UINT16 },
                ],
            },
            getRsp: {
                ID: 1,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'alarmcode', type: dataType_1.default.UINT8 },
                    { name: 'clusterid', type: dataType_1.default.UINT16 },
                    { name: 'timestamp', type: dataType_1.default.UINT32 },
                ],
            },
            getEventLog: {
                ID: 2,
                parameters: [],
            },
        },
    },
    genTime: {
        ID: 10,
        attributes: {
            time: { ID: 0, type: dataType_1.default.UTC },
            timeStatus: { ID: 1, type: dataType_1.default.BITMAP8 },
            timeZone: { ID: 2, type: dataType_1.default.INT32 },
            dstStart: { ID: 3, type: dataType_1.default.UINT32 },
            dstEnd: { ID: 4, type: dataType_1.default.UINT32 },
            dstShift: { ID: 5, type: dataType_1.default.INT32 },
            standardTime: { ID: 6, type: dataType_1.default.UINT32 },
            localTime: { ID: 7, type: dataType_1.default.UINT32 },
            lastSetTime: { ID: 8, type: dataType_1.default.UTC },
            validUntilTime: { ID: 9, type: dataType_1.default.UTC },
        },
        commands: {},
        commandsResponse: {},
    },
    genRssiLocation: {
        ID: 11,
        attributes: {
            type: { ID: 0, type: dataType_1.default.DATA8 },
            method: { ID: 1, type: dataType_1.default.ENUM8 },
            age: { ID: 2, type: dataType_1.default.UINT16 },
            qualityMeasure: { ID: 3, type: dataType_1.default.UINT8 },
            numOfDevices: { ID: 4, type: dataType_1.default.UINT8 },
            coordinate1: { ID: 16, type: dataType_1.default.INT16 },
            coordinate2: { ID: 17, type: dataType_1.default.INT16 },
            coordinate3: { ID: 18, type: dataType_1.default.INT16 },
            power: { ID: 19, type: dataType_1.default.INT16 },
            pathLossExponent: { ID: 20, type: dataType_1.default.UINT16 },
            reportingPeriod: { ID: 21, type: dataType_1.default.UINT16 },
            calcPeriod: { ID: 22, type: dataType_1.default.UINT16 },
            numRSSIMeasurements: { ID: 23, type: dataType_1.default.UINT16 },
        },
        commands: {
            setAbsolute: {
                ID: 0,
                parameters: [
                    { name: 'coord1', type: dataType_1.default.INT16 },
                    { name: 'coord2', type: dataType_1.default.INT16 },
                    { name: 'coord3', type: dataType_1.default.INT16 },
                    { name: 'power', type: dataType_1.default.INT16 },
                    { name: 'pathlossexponent', type: dataType_1.default.UINT16 },
                ],
            },
            setDevCfg: {
                ID: 1,
                parameters: [
                    { name: 'power', type: dataType_1.default.INT16 },
                    { name: 'pathlossexponent', type: dataType_1.default.UINT16 },
                    { name: 'calperiod', type: dataType_1.default.UINT16 },
                    { name: 'numrssimeasurements', type: dataType_1.default.UINT8 },
                    { name: 'reportingperiod', type: dataType_1.default.UINT16 },
                ],
            },
            getDevCfg: {
                ID: 2,
                parameters: [
                    { name: 'targetaddr', type: dataType_1.default.IEEE_ADDR },
                ],
            },
            getData: {
                ID: 3,
                parameters: [
                    { name: 'getdatainfo', type: dataType_1.default.UINT8 },
                    { name: 'numrsp', type: dataType_1.default.UINT8 },
                    { name: 'targetaddr', type: dataType_1.default.IEEE_ADDR },
                ],
            },
        },
        commandsResponse: {
            devCfgRsp: {
                ID: 0,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'power', type: dataType_1.default.INT16 },
                    { name: 'pathlossexp', type: dataType_1.default.UINT16 },
                    { name: 'calperiod', type: dataType_1.default.UINT16 },
                    { name: 'numrssimeasurements', type: dataType_1.default.UINT8 },
                    { name: 'reportingperiod', type: dataType_1.default.UINT16 },
                ],
            },
            dataRsp: {
                ID: 1,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'locationtype', type: dataType_1.default.UINT8 },
                    { name: 'coord1', type: dataType_1.default.INT16 },
                    { name: 'coord2', type: dataType_1.default.INT16 },
                    { name: 'coord3', type: dataType_1.default.INT16 },
                    { name: 'power', type: dataType_1.default.INT16 },
                    { name: 'pathlossexp', type: dataType_1.default.UINT16 },
                    { name: 'locationmethod', type: dataType_1.default.UINT8 },
                    { name: 'qualitymeasure', type: dataType_1.default.UINT8 },
                    { name: 'locationage', type: dataType_1.default.UINT16 },
                ],
            },
            dataNotif: {
                ID: 2,
                parameters: [
                    { name: 'locationtype', type: dataType_1.default.UINT8 },
                    { name: 'coord1', type: dataType_1.default.INT16 },
                    { name: 'coord2', type: dataType_1.default.INT16 },
                    { name: 'coord3', type: dataType_1.default.INT16 },
                    { name: 'power', type: dataType_1.default.INT16 },
                    { name: 'pathlossexp', type: dataType_1.default.UINT16 },
                    { name: 'locationmethod', type: dataType_1.default.UINT8 },
                    { name: 'qualitymeasure', type: dataType_1.default.UINT8 },
                    { name: 'locationage', type: dataType_1.default.UINT16 },
                ],
            },
            compactDataNotif: {
                ID: 3,
                parameters: [
                    { name: 'locationtype', type: dataType_1.default.UINT8 },
                    { name: 'coord1', type: dataType_1.default.INT16 },
                    { name: 'coord2', type: dataType_1.default.INT16 },
                    { name: 'coord3', type: dataType_1.default.INT16 },
                    { name: 'qualitymeasure', type: dataType_1.default.UINT8 },
                    { name: 'locationage', type: dataType_1.default.UINT16 },
                ],
            },
            rssiPing: {
                ID: 4,
                parameters: [
                    { name: 'locationtype', type: dataType_1.default.UINT8 },
                ],
            },
        },
    },
    genAnalogInput: {
        ID: 12,
        attributes: {
            description: { ID: 28, type: dataType_1.default.CHAR_STR },
            maxPresentValue: { ID: 65, type: dataType_1.default.SINGLE_PREC },
            minPresentValue: { ID: 69, type: dataType_1.default.SINGLE_PREC },
            outOfService: { ID: 81, type: dataType_1.default.BOOLEAN },
            presentValue: { ID: 85, type: dataType_1.default.SINGLE_PREC },
            reliability: { ID: 103, type: dataType_1.default.ENUM8 },
            resolution: { ID: 106, type: dataType_1.default.SINGLE_PREC },
            statusFlags: { ID: 111, type: dataType_1.default.BITMAP8 },
            engineeringUnits: { ID: 117, type: dataType_1.default.ENUM16 },
            applicationType: { ID: 256, type: dataType_1.default.UINT32 },
        },
        commands: {},
        commandsResponse: {},
    },
    genAnalogOutput: {
        ID: 13,
        attributes: {
            description: { ID: 28, type: dataType_1.default.CHAR_STR },
            maxPresentValue: { ID: 65, type: dataType_1.default.SINGLE_PREC },
            minPresentValue: { ID: 69, type: dataType_1.default.SINGLE_PREC },
            outOfService: { ID: 81, type: dataType_1.default.BOOLEAN },
            presentValue: { ID: 85, type: dataType_1.default.SINGLE_PREC },
            priorityArray: { ID: 87, type: dataType_1.default.ARRAY },
            reliability: { ID: 103, type: dataType_1.default.ENUM8 },
            relinquishDefault: { ID: 104, type: dataType_1.default.SINGLE_PREC },
            resolution: { ID: 106, type: dataType_1.default.SINGLE_PREC },
            statusFlags: { ID: 111, type: dataType_1.default.BITMAP8 },
            engineeringUnits: { ID: 117, type: dataType_1.default.ENUM16 },
            applicationType: { ID: 256, type: dataType_1.default.UINT32 },
        },
        commands: {},
        commandsResponse: {},
    },
    genAnalogValue: {
        ID: 14,
        attributes: {
            description: { ID: 28, type: dataType_1.default.CHAR_STR },
            outOfService: { ID: 81, type: dataType_1.default.BOOLEAN },
            presentValue: { ID: 85, type: dataType_1.default.SINGLE_PREC },
            priorityArray: { ID: 87, type: dataType_1.default.ARRAY },
            reliability: { ID: 103, type: dataType_1.default.ENUM8 },
            relinquishDefault: { ID: 104, type: dataType_1.default.SINGLE_PREC },
            statusFlags: { ID: 111, type: dataType_1.default.BITMAP8 },
            engineeringUnits: { ID: 117, type: dataType_1.default.ENUM16 },
            applicationType: { ID: 256, type: dataType_1.default.UINT32 },
        },
        commands: {},
        commandsResponse: {},
    },
    genBinaryInput: {
        ID: 15,
        attributes: {
            activeText: { ID: 4, type: dataType_1.default.CHAR_STR },
            description: { ID: 28, type: dataType_1.default.CHAR_STR },
            inactiveText: { ID: 46, type: dataType_1.default.CHAR_STR },
            outOfService: { ID: 81, type: dataType_1.default.BOOLEAN },
            polarity: { ID: 84, type: dataType_1.default.ENUM8 },
            presentValue: { ID: 85, type: dataType_1.default.BOOLEAN },
            reliability: { ID: 103, type: dataType_1.default.ENUM8 },
            statusFlags: { ID: 111, type: dataType_1.default.BITMAP8 },
            applicationType: { ID: 256, type: dataType_1.default.UINT32 },
        },
        commands: {},
        commandsResponse: {},
    },
    genBinaryOutput: {
        ID: 16,
        attributes: {
            activeText: { ID: 4, type: dataType_1.default.CHAR_STR },
            description: { ID: 28, type: dataType_1.default.CHAR_STR },
            inactiveText: { ID: 46, type: dataType_1.default.CHAR_STR },
            minimumOffTime: { ID: 66, type: dataType_1.default.UINT32 },
            minimumOnTime: { ID: 67, type: dataType_1.default.UINT32 },
            outOfService: { ID: 81, type: dataType_1.default.BOOLEAN },
            polarity: { ID: 84, type: dataType_1.default.ENUM8 },
            presentValue: { ID: 85, type: dataType_1.default.BOOLEAN },
            priorityArray: { ID: 87, type: dataType_1.default.ARRAY },
            reliability: { ID: 103, type: dataType_1.default.ENUM8 },
            relinquishDefault: { ID: 104, type: dataType_1.default.BOOLEAN },
            statusFlags: { ID: 111, type: dataType_1.default.BITMAP8 },
            applicationType: { ID: 256, type: dataType_1.default.UINT32 },
        },
        commands: {},
        commandsResponse: {},
    },
    genBinaryValue: {
        ID: 17,
        attributes: {
            activeText: { ID: 4, type: dataType_1.default.CHAR_STR },
            description: { ID: 28, type: dataType_1.default.CHAR_STR },
            inactiveText: { ID: 46, type: dataType_1.default.CHAR_STR },
            minimumOffTime: { ID: 66, type: dataType_1.default.UINT32 },
            minimumOnTime: { ID: 67, type: dataType_1.default.UINT32 },
            outOfService: { ID: 81, type: dataType_1.default.BOOLEAN },
            presentValue: { ID: 85, type: dataType_1.default.BOOLEAN },
            priorityArray: { ID: 87, type: dataType_1.default.ARRAY },
            reliability: { ID: 103, type: dataType_1.default.ENUM8 },
            relinquishDefault: { ID: 104, type: dataType_1.default.BOOLEAN },
            statusFlags: { ID: 111, type: dataType_1.default.BITMAP8 },
            applicationType: { ID: 256, type: dataType_1.default.UINT32 },
        },
        commands: {},
        commandsResponse: {},
    },
    genMultistateInput: {
        ID: 18,
        attributes: {
            stateText: { ID: 14, type: dataType_1.default.ARRAY },
            description: { ID: 28, type: dataType_1.default.CHAR_STR },
            numberOfStates: { ID: 74, type: dataType_1.default.UINT16 },
            outOfService: { ID: 81, type: dataType_1.default.BOOLEAN },
            presentValue: { ID: 85, type: dataType_1.default.UINT16 },
            reliability: { ID: 103, type: dataType_1.default.ENUM8 },
            statusFlags: { ID: 111, type: dataType_1.default.BITMAP8 },
            applicationType: { ID: 256, type: dataType_1.default.UINT32 },
        },
        commands: {},
        commandsResponse: {},
    },
    genMultistateOutput: {
        ID: 19,
        attributes: {
            stateText: { ID: 14, type: dataType_1.default.ARRAY },
            description: { ID: 28, type: dataType_1.default.CHAR_STR },
            numberOfStates: { ID: 74, type: dataType_1.default.UINT16 },
            outOfService: { ID: 81, type: dataType_1.default.BOOLEAN },
            presentValue: { ID: 85, type: dataType_1.default.UINT16 },
            priorityArray: { ID: 87, type: dataType_1.default.ARRAY },
            reliability: { ID: 103, type: dataType_1.default.ENUM8 },
            relinquishDefault: { ID: 104, type: dataType_1.default.UINT16 },
            statusFlags: { ID: 111, type: dataType_1.default.BITMAP8 },
            applicationType: { ID: 256, type: dataType_1.default.UINT32 },
        },
        commands: {},
        commandsResponse: {},
    },
    genMultistateValue: {
        ID: 20,
        attributes: {
            stateText: { ID: 14, type: dataType_1.default.ARRAY },
            description: { ID: 28, type: dataType_1.default.CHAR_STR },
            numberOfStates: { ID: 74, type: dataType_1.default.UINT16 },
            outOfService: { ID: 81, type: dataType_1.default.BOOLEAN },
            presentValue: { ID: 85, type: dataType_1.default.UINT16 },
            priorityArray: { ID: 87, type: dataType_1.default.ARRAY },
            reliability: { ID: 103, type: dataType_1.default.ENUM8 },
            relinquishDefault: { ID: 104, type: dataType_1.default.UINT16 },
            statusFlags: { ID: 111, type: dataType_1.default.BITMAP8 },
            applicationType: { ID: 256, type: dataType_1.default.UINT32 },
        },
        commands: {},
        commandsResponse: {},
    },
    genCommissioning: {
        ID: 21,
        attributes: {
            shortress: { ID: 0, type: dataType_1.default.UINT16 },
            extendedPANId: { ID: 1, type: dataType_1.default.IEEE_ADDR },
            panId: { ID: 2, type: dataType_1.default.UINT16 },
            channelmask: { ID: 3, type: dataType_1.default.BITMAP32 },
            protocolVersion: { ID: 4, type: dataType_1.default.UINT8 },
            stackProfile: { ID: 5, type: dataType_1.default.UINT8 },
            startupControl: { ID: 6, type: dataType_1.default.ENUM8 },
            trustCenterress: { ID: 16, type: dataType_1.default.IEEE_ADDR },
            trustCenterMasterKey: { ID: 17, type: dataType_1.default.SEC_KEY },
            networkKey: { ID: 18, type: dataType_1.default.SEC_KEY },
            useInsecureJoin: { ID: 19, type: dataType_1.default.BOOLEAN },
            preconfiguredLinkKey: { ID: 20, type: dataType_1.default.SEC_KEY },
            networkKeySeqNum: { ID: 21, type: dataType_1.default.UINT8 },
            networkKeyType: { ID: 22, type: dataType_1.default.ENUM8 },
            networkManagerress: { ID: 23, type: dataType_1.default.UINT16 },
            scanAttempts: { ID: 32, type: dataType_1.default.UINT8 },
            timeBetweenScans: { ID: 33, type: dataType_1.default.UINT16 },
            rejoinInterval: { ID: 34, type: dataType_1.default.UINT16 },
            maxRejoinInterval: { ID: 35, type: dataType_1.default.UINT16 },
            indirectPollRate: { ID: 48, type: dataType_1.default.UINT16 },
            parentRetryThreshold: { ID: 49, type: dataType_1.default.UINT8 },
            concentratorFlag: { ID: 64, type: dataType_1.default.BOOLEAN },
            concentratorRus: { ID: 65, type: dataType_1.default.UINT8 },
            concentratorDiscoveryTime: { ID: 66, type: dataType_1.default.UINT8 },
        },
        commands: {
            restartDevice: {
                ID: 0,
                parameters: [
                    { name: 'options', type: dataType_1.default.UINT8 },
                    { name: 'delay', type: dataType_1.default.UINT8 },
                    { name: 'jitter', type: dataType_1.default.UINT8 },
                ],
            },
            saveStartupParams: {
                ID: 1,
                parameters: [
                    { name: 'options', type: dataType_1.default.UINT8 },
                    { name: 'index', type: dataType_1.default.UINT8 },
                ],
            },
            restoreStartupParams: {
                ID: 2,
                parameters: [
                    { name: 'options', type: dataType_1.default.UINT8 },
                    { name: 'index', type: dataType_1.default.UINT8 },
                ],
            },
            resetStartupParams: {
                ID: 3,
                parameters: [
                    { name: 'options', type: dataType_1.default.UINT8 },
                    { name: 'index', type: dataType_1.default.UINT8 },
                ],
            },
        },
        commandsResponse: {
            restartDeviceRsp: {
                ID: 0,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            saveStartupParamsRsp: {
                ID: 1,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            restoreStartupParamsRsp: {
                ID: 2,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            resetStartupParamsRsp: {
                ID: 3,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
        },
    },
    genOta: {
        ID: 25,
        attributes: {
            upgradeServerId: { ID: 0, type: dataType_1.default.IEEE_ADDR },
            fileOffset: { ID: 1, type: dataType_1.default.UINT32 },
            currentFileVersion: { ID: 2, type: dataType_1.default.UINT32 },
            currentZigbeeStackVersion: { ID: 3, type: dataType_1.default.UINT16 },
            downloadedFileVersion: { ID: 4, type: dataType_1.default.UINT32 },
            downloadedZigbeeStackVersion: { ID: 5, type: dataType_1.default.UINT16 },
            imageUpgradeStatus: { ID: 6, type: dataType_1.default.ENUM8 },
            manufacturerId: { ID: 7, type: dataType_1.default.UINT16 },
            imageTypeId: { ID: 8, type: dataType_1.default.UINT16 },
            minimumBlockReqDelay: { ID: 9, type: dataType_1.default.UINT16 },
            imageStamp: { ID: 10, type: dataType_1.default.UINT32 },
        },
        commands: {
            queryNextImageRequest: {
                ID: 1,
                response: 2,
                parameters: [
                    { name: 'fieldControl', type: dataType_1.default.UINT8 },
                    { name: 'manufacturerCode', type: dataType_1.default.UINT16 },
                    { name: 'imageType', type: dataType_1.default.UINT16 },
                    { name: 'fileVersion', type: dataType_1.default.UINT32 },
                ],
            },
            imageBlockRequest: {
                ID: 3,
                response: 5,
                parameters: [
                    { name: 'fieldControl', type: dataType_1.default.UINT8 },
                    { name: 'manufacturerCode', type: dataType_1.default.UINT16 },
                    { name: 'imageType', type: dataType_1.default.UINT16 },
                    { name: 'fileVersion', type: dataType_1.default.UINT32 },
                    { name: 'fileOffset', type: dataType_1.default.UINT32 },
                    { name: 'maximumDataSize', type: dataType_1.default.UINT8 },
                ],
            },
            imagePageRequest: {
                ID: 4,
                response: 5,
                parameters: [
                    { name: 'fieldControl', type: dataType_1.default.UINT8 },
                    { name: 'manufacturerCode', type: dataType_1.default.UINT16 },
                    { name: 'imageType', type: dataType_1.default.UINT16 },
                    { name: 'fileVersion', type: dataType_1.default.UINT32 },
                    { name: 'fileOffset', type: dataType_1.default.UINT32 },
                    { name: 'maximumDataSize', type: dataType_1.default.UINT8 },
                    { name: 'pageSize', type: dataType_1.default.UINT16 },
                    { name: 'responseSpacing', type: dataType_1.default.UINT16 },
                ],
            },
            upgradeEndRequest: {
                ID: 6,
                response: 7,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'manufacturerCode', type: dataType_1.default.UINT16 },
                    { name: 'imageType', type: dataType_1.default.UINT16 },
                    { name: 'fileVersion', type: dataType_1.default.UINT32 },
                ],
            }
        },
        commandsResponse: {
            imageNotify: {
                ID: 0,
                parameters: [
                    { name: 'payloadType', type: dataType_1.default.UINT8 },
                    { name: 'queryJitter', type: dataType_1.default.UINT8 },
                ],
            },
            queryNextImageResponse: {
                ID: 2,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'manufacturerCode', type: dataType_1.default.UINT16, conditions: [{ type: 'statusEquals', value: 0 }] },
                    { name: 'imageType', type: dataType_1.default.UINT16, conditions: [{ type: 'statusEquals', value: 0 }] },
                    { name: 'fileVersion', type: dataType_1.default.UINT32, conditions: [{ type: 'statusEquals', value: 0 }] },
                    { name: 'imageSize', type: dataType_1.default.UINT32, conditions: [{ type: 'statusEquals', value: 0 }] },
                ],
            },
            imageBlockResponse: {
                ID: 5,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'manufacturerCode', type: dataType_1.default.UINT16 },
                    { name: 'imageType', type: dataType_1.default.UINT16 },
                    { name: 'fileVersion', type: dataType_1.default.UINT32 },
                    { name: 'fileOffset', type: dataType_1.default.UINT32 },
                    { name: 'dataSize', type: dataType_1.default.UINT8 },
                    { name: 'data', type: buffaloZclDataType_1.default.BUFFER },
                ],
            },
            upgradeEndResponse: {
                ID: 7,
                parameters: [
                    { name: 'manufacturerCode', type: dataType_1.default.UINT16 },
                    { name: 'imageType', type: dataType_1.default.UINT16 },
                    { name: 'fileVersion', type: dataType_1.default.UINT32 },
                    { name: 'currentTime', type: dataType_1.default.UINT32 },
                    { name: 'upgradeTime', type: dataType_1.default.UINT32 },
                ],
            }
        },
    },
    genPollCtrl: {
        ID: 32,
        attributes: {
            checkinInterval: { ID: 0, type: dataType_1.default.UINT32 },
            longPollInterval: { ID: 1, type: dataType_1.default.UINT32 },
            shortPollInterval: { ID: 2, type: dataType_1.default.UINT16 },
            fastPollTimeout: { ID: 3, type: dataType_1.default.UINT16 },
            checkinIntervalMin: { ID: 4, type: dataType_1.default.UINT32 },
            longPollIntervalMin: { ID: 5, type: dataType_1.default.UINT32 },
            fastPollTimeoutMax: { ID: 6, type: dataType_1.default.UINT16 },
        },
        commands: {
            checkinRsp: {
                ID: 0,
                parameters: [
                    { name: 'startFastPolling', type: dataType_1.default.BOOLEAN },
                    { name: 'fastPollTimeout', type: dataType_1.default.UINT16 },
                ],
            },
            fastPollStop: {
                ID: 1,
                parameters: [],
            },
            setLongPollInterval: {
                ID: 2,
                parameters: [
                    { name: 'newLongPollInterval', type: dataType_1.default.UINT32 },
                ],
            },
            setShortPollInterval: {
                ID: 3,
                parameters: [
                    { name: 'newShortPollInterval', type: dataType_1.default.UINT16 },
                ],
            },
        },
        commandsResponse: {
            checkin: {
                ID: 0,
                parameters: [],
            },
        },
    },
    greenPower: {
        ID: 33,
        attributes: {},
        commands: {
            notification: {
                ID: 0,
                parameters: [
                    { name: 'options', type: dataType_1.default.UINT16 },
                    { name: 'srcID', type: dataType_1.default.UINT32, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 0, size: 3, value: 0b000 }] },
                    { name: 'gpdIEEEAddr', type: dataType_1.default.IEEE_ADDR, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 0, size: 3, value: 0b010 }] },
                    { name: 'gpdEndpoint', type: dataType_1.default.UINT8, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 0, size: 3, value: 0b010 }] },
                    { name: 'frameCounter', type: dataType_1.default.UINT32 },
                    { name: 'commandID', type: dataType_1.default.UINT8 },
                    { name: 'payloadSize', type: dataType_1.default.UINT8 },
                    { name: 'commandFrame', type: buffaloZclDataType_1.default.GDP_FRAME },
                    { name: 'gppNwkAddr', type: dataType_1.default.UINT16, conditions: [{ type: 'bitMaskSet', param: 'options', mask: 0x4000 }] },
                    { name: 'gppGddLink', type: dataType_1.default.UINT8, conditions: [{ type: 'bitMaskSet', param: 'options', mask: 0x4000 }] },
                ],
            },
            commissioningNotification: {
                ID: 4,
                parameters: [
                    { name: 'options', type: dataType_1.default.UINT16 },
                    { name: 'srcID', type: dataType_1.default.UINT32, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 0, size: 3, value: 0b000 }] },
                    { name: 'gpdIEEEAddr', type: dataType_1.default.IEEE_ADDR, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 0, size: 3, value: 0b010 }] },
                    { name: 'gpdEndpoint', type: dataType_1.default.UINT8, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 0, size: 3, value: 0b010 }] },
                    { name: 'frameCounter', type: dataType_1.default.UINT32 },
                    { name: 'commandID', type: dataType_1.default.UINT8 },
                    { name: 'payloadSize', type: dataType_1.default.UINT8 },
                    { name: 'commandFrame', type: buffaloZclDataType_1.default.GDP_FRAME },
                    { name: 'gppNwkAddr', type: dataType_1.default.UINT16, conditions: [{ type: 'bitMaskSet', param: 'options', mask: 0x800 }] },
                    { name: 'gppGddLink', type: dataType_1.default.UINT8, conditions: [{ type: 'bitMaskSet', param: 'options', mask: 0x800 }] },
                ],
            },
        },
        commandsResponse: {
            response: {
                ID: 6,
                parameters: [
                    { name: 'options', type: dataType_1.default.UINT8 },
                    { name: 'tempMaster', type: dataType_1.default.UINT16 },
                    { name: 'tempMasterTx', type: dataType_1.default.UINT8 },
                    { name: 'srcID', type: dataType_1.default.UINT32, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 0, size: 3, value: 0b000 }] },
                    { name: 'gpdIEEEAddr', type: dataType_1.default.IEEE_ADDR, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 0, size: 3, value: 0b010 }] },
                    { name: 'gpdEndpoint', type: dataType_1.default.UINT8, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 0, size: 3, value: 0b010 }] },
                    { name: 'gpdCmd', type: dataType_1.default.UINT8 },
                    { name: 'gpdPayload', type: buffaloZclDataType_1.default.GDP_FRAME },
                ],
            },
            pairing: {
                ID: 1,
                parameters: [
                    { name: 'options', type: dataType_1.default.UINT24 },
                    { name: 'srcID', type: dataType_1.default.UINT32, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 0, size: 3, value: 0b000 }] },
                    { name: 'gpdIEEEAddr', type: dataType_1.default.IEEE_ADDR, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 0, size: 3, value: 0b010 }] },
                    { name: 'gpdEndpoint', type: dataType_1.default.UINT8, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 0, size: 3, value: 0b010 }] },
                    { name: 'sinkIEEEAddr', type: dataType_1.default.IEEE_ADDR, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 4, size: 3, value: 0b110 }] },
                    { name: 'sinkIEEEAddr', type: dataType_1.default.IEEE_ADDR, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 4, size: 3, value: 0b000 }] },
                    { name: 'sinkNwkAddr', type: dataType_1.default.UINT16, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 4, size: 3, value: 0b110 }] },
                    { name: 'sinkNwkAddr', type: dataType_1.default.UINT16, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 4, size: 3, value: 0b000 }] },
                    { name: 'sinkGroupID', type: dataType_1.default.UINT16, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 4, size: 3, value: 0b100 }] },
                    { name: 'sinkGroupID', type: dataType_1.default.UINT16, conditions: [{ type: 'bitFieldEnum', param: 'options', offset: 4, size: 3, value: 0b010 }] },
                    { name: 'deviceID', type: dataType_1.default.UINT8, conditions: [{ type: 'bitMaskSet', param: 'options', mask: 0x0008 }] },
                    { name: 'frameCounter', type: dataType_1.default.UINT32, conditions: [{ type: 'bitMaskSet', param: 'options', mask: 0x4000 }] },
                    { name: 'gpdKey', type: dataType_1.default.SEC_KEY, conditions: [{ type: 'bitMaskSet', param: 'options', mask: 0x8000 }] },
                ],
            },
            commisioningMode: {
                ID: 2,
                parameters: [
                    { name: 'options', type: dataType_1.default.UINT8 },
                    { name: 'commisioningWindow', type: dataType_1.default.UINT16 },
                ],
            },
        },
    },
    mobileDeviceCfg: {
        ID: 34,
        attributes: {
            keepAliveTime: { ID: 0, type: dataType_1.default.UINT16 },
            rejoinTimeout: { ID: 1, type: dataType_1.default.UINT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    neighborCleaning: {
        ID: 35,
        attributes: {
            neighborCleaningTimeout: { ID: 0, type: dataType_1.default.UINT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    nearestGateway: {
        ID: 36,
        attributes: {
            nearestGateway: { ID: 0, type: dataType_1.default.UINT16 },
            newMobileNode: { ID: 1, type: dataType_1.default.UINT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    closuresShadeCfg: {
        ID: 256,
        attributes: {
            physicalClosedLimit: { ID: 0, type: dataType_1.default.UINT16 },
            motorStepSize: { ID: 1, type: dataType_1.default.UINT8 },
            status: { ID: 2, type: dataType_1.default.BITMAP8 },
            losedLimit: { ID: 16, type: dataType_1.default.UINT16 },
            mode: { ID: 18, type: dataType_1.default.ENUM8 },
        },
        commands: {},
        commandsResponse: {},
    },
    closuresDoorLock: {
        ID: 257,
        attributes: {
            lockState: { ID: 0, type: dataType_1.default.ENUM8 },
            lockType: { ID: 38, type: dataType_1.default.BITMAP16 },
            actuatorEnabled: { ID: 2, type: dataType_1.default.BOOLEAN },
            doorState: { ID: 3, type: dataType_1.default.ENUM8 },
            doorOpenEvents: { ID: 4, type: dataType_1.default.UINT32 },
            doorClosedEvents: { ID: 5, type: dataType_1.default.UINT32 },
            openPeriod: { ID: 6, type: dataType_1.default.UINT16 },
            numOfLockRecordsSupported: { ID: 16, type: dataType_1.default.UINT16 },
            numOfTotalUsersSupported: { ID: 17, type: dataType_1.default.UINT16 },
            numOfPinUsersSupported: { ID: 18, type: dataType_1.default.UINT16 },
            numOfRfidUsersSupported: { ID: 19, type: dataType_1.default.UINT16 },
            numOfWeekDaySchedulesSupportedPerUser: { ID: 20, type: dataType_1.default.UINT8 },
            numOfYearDaySchedulesSupportedPerUser: { ID: 21, type: dataType_1.default.UINT8 },
            numOfHolidayScheduledsSupported: { ID: 22, type: dataType_1.default.UINT8 },
            maxPinLen: { ID: 23, type: dataType_1.default.UINT8 },
            minPinLen: { ID: 24, type: dataType_1.default.UINT8 },
            maxRfidLen: { ID: 25, type: dataType_1.default.UINT8 },
            minRfidLen: { ID: 26, type: dataType_1.default.UINT8 },
            enableLogging: { ID: 32, type: dataType_1.default.BOOLEAN },
            language: { ID: 33, type: dataType_1.default.CHAR_STR },
            ledSettings: { ID: 34, type: dataType_1.default.UINT8 },
            autoRelockTime: { ID: 35, type: dataType_1.default.UINT32 },
            soundVolume: { ID: 36, type: dataType_1.default.UINT8 },
            operatingMode: { ID: 37, type: dataType_1.default.UINT32 },
            defaultConfigurationRegister: { ID: 39, type: dataType_1.default.BITMAP16 },
            enableLocalProgramming: { ID: 40, type: dataType_1.default.BOOLEAN },
            enableOneTouchLocking: { ID: 41, type: dataType_1.default.BOOLEAN },
            enableInsideStatusLed: { ID: 42, type: dataType_1.default.BOOLEAN },
            enablePrivacyModeButton: { ID: 43, type: dataType_1.default.BOOLEAN },
            wrongCodeEntryLimit: { ID: 48, type: dataType_1.default.UINT8 },
            userCodeTemporaryDisableTime: { ID: 49, type: dataType_1.default.UINT8 },
            sendPinOta: { ID: 50, type: dataType_1.default.BOOLEAN },
            requirePinForRfOperation: { ID: 51, type: dataType_1.default.BOOLEAN },
            zigbeeSecurityLevel: { ID: 52, type: dataType_1.default.UINT8 },
            alarmMask: { ID: 64, type: dataType_1.default.BITMAP16 },
            keypadOperationEventMask: { ID: 65, type: dataType_1.default.BITMAP16 },
            rfOperationEventMask: { ID: 66, type: dataType_1.default.BITMAP16 },
            manualOperationEventMask: { ID: 67, type: dataType_1.default.BITMAP16 },
            rfidOperationEventMask: { ID: 68, type: dataType_1.default.BITMAP16 },
            keypadProgrammingEventMask: { ID: 69, type: dataType_1.default.BITMAP16 },
            rfProgrammingEventMask: { ID: 70, type: dataType_1.default.BITMAP16 },
            rfidProgrammingEventMask: { ID: 71, type: dataType_1.default.BITMAP16 },
        },
        commands: {
            lockDoor: {
                ID: 0,
                response: 0,
                parameters: [
                    { name: 'pincodevalue', type: dataType_1.default.CHAR_STR },
                ],
            },
            unlockDoor: {
                ID: 1,
                response: 1,
                parameters: [
                    { name: 'pincodevalue', type: dataType_1.default.CHAR_STR },
                ],
            },
            toggleDoor: {
                ID: 2,
                response: 2,
                parameters: [
                    { name: 'pincodevalue', type: dataType_1.default.CHAR_STR },
                ],
            },
            unlockWithTimeout: {
                ID: 3,
                response: 3,
                parameters: [
                    { name: 'timeout', type: dataType_1.default.UINT16 },
                    { name: 'pincodevalue', type: dataType_1.default.CHAR_STR },
                ],
            },
            getLogRecord: {
                ID: 4,
                response: 4,
                parameters: [
                    { name: 'logindex', type: dataType_1.default.UINT16 },
                ],
            },
            setPinCode: {
                ID: 5,
                response: 5,
                parameters: [
                    { name: 'userid', type: dataType_1.default.UINT16 },
                    { name: 'userstatus', type: dataType_1.default.UINT8 },
                    { name: 'usertype', type: dataType_1.default.UINT8 },
                    { name: 'pincodevalue', type: dataType_1.default.CHAR_STR },
                ],
            },
            getPinCode: {
                ID: 6,
                response: 6,
                parameters: [
                    { name: 'userid', type: dataType_1.default.UINT16 },
                ],
            },
            clearPinCode: {
                ID: 7,
                response: 7,
                parameters: [
                    { name: 'userid', type: dataType_1.default.UINT16 },
                ],
            },
            clearAllPinCodes: {
                ID: 8,
                response: 8,
                parameters: [],
            },
            setUserStatus: {
                ID: 9,
                response: 9,
                parameters: [
                    { name: 'userid', type: dataType_1.default.UINT16 },
                    { name: 'userstatus', type: dataType_1.default.UINT8 },
                ],
            },
            getUserStatus: {
                ID: 10,
                response: 10,
                parameters: [
                    { name: 'userid', type: dataType_1.default.UINT16 },
                ],
            },
            setWeekDaySchedule: {
                ID: 11,
                response: 11,
                parameters: [
                    { name: 'scheduleid', type: dataType_1.default.UINT8 },
                    { name: 'userid', type: dataType_1.default.UINT16 },
                    { name: 'daysmask', type: dataType_1.default.UINT8 },
                    { name: 'starthour', type: dataType_1.default.UINT8 },
                    { name: 'startminute', type: dataType_1.default.UINT8 },
                    { name: 'endhour', type: dataType_1.default.UINT8 },
                    { name: 'endminute', type: dataType_1.default.UINT8 },
                ],
            },
            getWeekDaySchedule: {
                ID: 12,
                response: 12,
                parameters: [
                    { name: 'scheduleid', type: dataType_1.default.UINT8 },
                    { name: 'userid', type: dataType_1.default.UINT16 },
                ],
            },
            clearWeekDaySchedule: {
                ID: 13,
                response: 13,
                parameters: [
                    { name: 'scheduleid', type: dataType_1.default.UINT8 },
                    { name: 'userid', type: dataType_1.default.UINT16 },
                ],
            },
            setYearDaySchedule: {
                ID: 14,
                response: 14,
                parameters: [
                    { name: 'scheduleid', type: dataType_1.default.UINT8 },
                    { name: 'userid', type: dataType_1.default.UINT16 },
                    { name: 'zigbeelocalstarttime', type: dataType_1.default.UINT32 },
                    { name: 'zigbeelocalendtime', type: dataType_1.default.UINT32 },
                ],
            },
            getYearDaySchedule: {
                ID: 15,
                response: 15,
                parameters: [
                    { name: 'scheduleid', type: dataType_1.default.UINT8 },
                    { name: 'userid', type: dataType_1.default.UINT16 },
                ],
            },
            clearYearDaySchedule: {
                ID: 16,
                response: 16,
                parameters: [
                    { name: 'scheduleid', type: dataType_1.default.UINT8 },
                    { name: 'userid', type: dataType_1.default.UINT16 },
                ],
            },
            setHolidaySchedule: {
                ID: 17,
                response: 17,
                parameters: [
                    { name: 'holidayscheduleid', type: dataType_1.default.UINT8 },
                    { name: 'zigbeelocalstarttime', type: dataType_1.default.UINT32 },
                    { name: 'zigbeelocalendtime', type: dataType_1.default.UINT32 },
                    { name: 'opermodelduringholiday', type: dataType_1.default.UINT8 },
                ],
            },
            getHolidaySchedule: {
                ID: 18,
                response: 18,
                parameters: [
                    { name: 'holidayscheduleid', type: dataType_1.default.UINT8 },
                ],
            },
            clearHolidaySchedule: {
                ID: 19,
                response: 19,
                parameters: [
                    { name: 'holidayscheduleid', type: dataType_1.default.UINT8 },
                ],
            },
            setUserType: {
                ID: 20,
                response: 20,
                parameters: [
                    { name: 'userid', type: dataType_1.default.UINT16 },
                    { name: 'usertype', type: dataType_1.default.UINT8 },
                ],
            },
            getUserType: {
                ID: 21,
                response: 21,
                parameters: [
                    { name: 'userid', type: dataType_1.default.UINT16 },
                ],
            },
            setRfidCode: {
                ID: 22,
                response: 22,
                parameters: [
                    { name: 'userid', type: dataType_1.default.UINT16 },
                    { name: 'userstatus', type: dataType_1.default.UINT8 },
                    { name: 'usertype', type: dataType_1.default.UINT8 },
                    { name: 'pincodevalue', type: dataType_1.default.CHAR_STR },
                ],
            },
            getRfidCode: {
                ID: 23,
                response: 23,
                parameters: [
                    { name: 'userid', type: dataType_1.default.UINT16 },
                ],
            },
            clearRfidCode: {
                ID: 24,
                response: 24,
                parameters: [
                    { name: 'userid', type: dataType_1.default.UINT16 },
                ],
            },
            clearAllRfidCodes: {
                ID: 25,
                response: 25,
                parameters: [],
            },
        },
        commandsResponse: {
            lockDoorRsp: {
                ID: 0,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            unlockDoorRsp: {
                ID: 1,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            toggleDoorRsp: {
                ID: 2,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            unlockWithTimeoutRsp: {
                ID: 3,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            getLogRecordRsp: {
                ID: 4,
                parameters: [
                    { name: 'logentryid', type: dataType_1.default.UINT16 },
                    { name: 'timestamp', type: dataType_1.default.UINT32 },
                    { name: 'eventtype', type: dataType_1.default.UINT8 },
                    { name: 'source', type: dataType_1.default.UINT8 },
                    { name: 'eventidalarmcode', type: dataType_1.default.UINT8 },
                    { name: 'userid', type: dataType_1.default.UINT16 },
                    { name: 'pincodevalue', type: dataType_1.default.CHAR_STR },
                ],
            },
            setPinCodeRsp: {
                ID: 5,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            getPinCodeRsp: {
                ID: 6,
                parameters: [
                    { name: 'userid', type: dataType_1.default.UINT16 },
                    { name: 'userstatus', type: dataType_1.default.UINT8 },
                    { name: 'usertype', type: dataType_1.default.UINT8 },
                    { name: 'pincodevalue', type: dataType_1.default.CHAR_STR },
                ],
            },
            clearPinCodeRsp: {
                ID: 7,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            clearAllPinCodesRsp: {
                ID: 8,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            setUserStatusRsp: {
                ID: 9,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            getUserStatusRsp: {
                ID: 10,
                parameters: [
                    { name: 'userid', type: dataType_1.default.UINT16 },
                    { name: 'userstatus', type: dataType_1.default.UINT8 },
                ],
            },
            setWeekDayScheduleRsp: {
                ID: 11,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            getWeekDayScheduleRsp: {
                ID: 12,
                parameters: [
                    { name: 'scheduleid', type: dataType_1.default.UINT8 },
                    { name: 'userid', type: dataType_1.default.UINT16 },
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'daysmask', type: dataType_1.default.UINT8 },
                    { name: 'starthour', type: dataType_1.default.UINT8 },
                    { name: 'startminute', type: dataType_1.default.UINT8 },
                    { name: 'endhour', type: dataType_1.default.UINT8 },
                    { name: 'endminute', type: dataType_1.default.UINT8 },
                ],
            },
            clearWeekDayScheduleRsp: {
                ID: 13,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            setYearDayScheduleRsp: {
                ID: 14,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            getYearDayScheduleRsp: {
                ID: 15,
                parameters: [
                    { name: 'scheduleid', type: dataType_1.default.UINT8 },
                    { name: 'userid', type: dataType_1.default.UINT16 },
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'zigbeelocalstarttime', type: dataType_1.default.UINT32 },
                    { name: 'zigbeelocalendtime', type: dataType_1.default.UINT32 },
                ],
            },
            clearYearDayScheduleRsp: {
                ID: 16,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            setHolidayScheduleRsp: {
                ID: 17,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            getHolidayScheduleRsp: {
                ID: 18,
                parameters: [
                    { name: 'holidayscheduleid', type: dataType_1.default.UINT8 },
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'zigbeelocalstarttime', type: dataType_1.default.UINT32 },
                    { name: 'zigbeelocalendtime', type: dataType_1.default.UINT32 },
                    { name: 'opermodelduringholiday', type: dataType_1.default.UINT8 },
                ],
            },
            clearHolidayScheduleRsp: {
                ID: 19,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            setUserTypeRsp: {
                ID: 20,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            getUserTypeRsp: {
                ID: 21,
                parameters: [
                    { name: 'userid', type: dataType_1.default.UINT16 },
                    { name: 'usertype', type: dataType_1.default.UINT8 },
                ],
            },
            setRfidCodeRsp: {
                ID: 22,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            getRfidCodeRsp: {
                ID: 23,
                parameters: [
                    { name: 'userid', type: dataType_1.default.UINT16 },
                    { name: 'userstatus', type: dataType_1.default.UINT8 },
                    { name: 'usertype', type: dataType_1.default.UINT8 },
                    { name: 'pincodevalue', type: dataType_1.default.CHAR_STR },
                ],
            },
            clearRfidCodeRsp: {
                ID: 24,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            clearAllRfidCodesRsp: {
                ID: 25,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            operationEventNotification: {
                ID: 32,
                parameters: [
                    { name: 'opereventsrc', type: dataType_1.default.UINT8 },
                    { name: 'opereventcode', type: dataType_1.default.UINT8 },
                    { name: 'userid', type: dataType_1.default.UINT16 },
                    { name: 'pin', type: dataType_1.default.OCTET_STR },
                    { name: 'zigbeelocaltime', type: dataType_1.default.UINT32 },
                    { name: 'data', type: dataType_1.default.UINT8 },
                ],
            },
            programmingEventNotification: {
                ID: 33,
                parameters: [
                    { name: 'programeventsrc', type: dataType_1.default.UINT8 },
                    { name: 'programeventcode', type: dataType_1.default.UINT8 },
                    { name: 'userid', type: dataType_1.default.UINT16 },
                    { name: 'pin', type: dataType_1.default.OCTET_STR },
                    { name: 'usertype', type: dataType_1.default.UINT8 },
                    { name: 'userstatus', type: dataType_1.default.UINT8 },
                    { name: 'zigbeelocaltime', type: dataType_1.default.UINT32 },
                    { name: 'data', type: dataType_1.default.UINT8 },
                ],
            },
        },
    },
    closuresWindowCovering: {
        ID: 258,
        attributes: {
            windowCoveringType: { ID: 0, type: dataType_1.default.ENUM8 },
            physicalClosedLimitLiftCm: { ID: 1, type: dataType_1.default.UINT16 },
            physicalClosedLimitTiltDdegree: { ID: 2, type: dataType_1.default.UINT16 },
            currentPositionLiftCm: { ID: 3, type: dataType_1.default.UINT16 },
            currentPositionTiltDdegree: { ID: 4, type: dataType_1.default.UINT16 },
            numOfActuationsLift: { ID: 5, type: dataType_1.default.UINT16 },
            numOfActuationsTilt: { ID: 6, type: dataType_1.default.UINT16 },
            configStatus: { ID: 7, type: dataType_1.default.BITMAP8 },
            currentPositionLiftPercentage: { ID: 8, type: dataType_1.default.UINT8 },
            currentPositionTiltPercentage: { ID: 9, type: dataType_1.default.UINT8 },
            operationalStatus: { ID: 10, type: dataType_1.default.BITMAP8 },
            installedOpenLimitLiftCm: { ID: 16, type: dataType_1.default.UINT16 },
            installedClosedLimitLiftCm: { ID: 17, type: dataType_1.default.UINT16 },
            installedOpenLimitTiltDdegree: { ID: 18, type: dataType_1.default.UINT16 },
            installedClosedLimitTiltDdegree: { ID: 19, type: dataType_1.default.UINT16 },
            velocityLift: { ID: 20, type: dataType_1.default.UINT16 },
            accelerationTimeLift: { ID: 21, type: dataType_1.default.UINT16 },
            decelerationTimeLift: { ID: 22, type: dataType_1.default.UINT16 },
            windowCoveringMode: { ID: 23, type: dataType_1.default.BITMAP8 },
            intermediateSetpointsLift: { ID: 24, type: dataType_1.default.OCTET_STR },
            intermediateSetpointsTilt: { ID: 25, type: dataType_1.default.OCTET_STR },
            tuyaMovingState: { ID: 0xf000, type: dataType_1.default.ENUM8 },
            tuyaCalibration: { ID: 0xf001, type: dataType_1.default.ENUM8 },
            stepPositionLift: { ID: 0xf001, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.LEGRAND_GROUP },
            tuyaMotorReversal: { ID: 0xf002, type: dataType_1.default.ENUM8 },
            calibrationMode: { ID: 0xf002, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.LEGRAND_GROUP },
            moesCalibrationTime: { ID: 0xf003, type: dataType_1.default.UINT16 },
            targetPositionTiltPercentage: { ID: 0xf003, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.LEGRAND_GROUP },
            stepPositionTilt: { ID: 0xf004, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.LEGRAND_GROUP },
            elkoDriveCloseDuration: { ID: 0xE000, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.ADEO },
            elkoProtectionStatus: { ID: 0xE010, type: dataType_1.default.BITMAP8, manufacturerCode: manufacturerCode_1.default.ADEO },
            elkoProtectionSensor: { ID: 0xE013, type: dataType_1.default.BITMAP8, manufacturerCode: manufacturerCode_1.default.ADEO },
            elkoSunProtectionIlluminanceThreshold: { ID: 0xE012, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.ADEO },
            elkoLiftDriveUpTime: { ID: 0xE014, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.ADEO },
            elkoLiftDriveDownTime: { ID: 0xE015, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.ADEO },
            elkoTiltOpenCloseAndStepTime: { ID: 0xE016, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.ADEO },
            elkoTiltPositionPercentageAfterMoveToLevel: { ID: 0xE017, type: dataType_1.default.UINT8, manufacturerCode: manufacturerCode_1.default.ADEO },
        },
        commands: {
            upOpen: {
                ID: 0,
                parameters: [],
            },
            downClose: {
                ID: 1,
                parameters: [],
            },
            stop: {
                ID: 2,
                parameters: [],
            },
            goToLiftValue: {
                ID: 4,
                parameters: [
                    { name: 'liftvalue', type: dataType_1.default.UINT16 },
                ],
            },
            goToLiftPercentage: {
                ID: 5,
                parameters: [
                    { name: 'percentageliftvalue', type: dataType_1.default.UINT8 },
                ],
            },
            goToTiltValue: {
                ID: 7,
                parameters: [
                    { name: 'tiltvalue', type: dataType_1.default.UINT16 },
                ],
            },
            goToTiltPercentage: {
                ID: 8,
                parameters: [
                    { name: 'percentagetiltvalue', type: dataType_1.default.UINT8 },
                ],
            },
            elkoStopOrStepLiftPercentage: {
                ID: 0x80,
                parameters: [
                    { name: 'direction', type: dataType_1.default.UINT16 },
                    { name: 'stepvalue', type: dataType_1.default.UINT16 },
                ],
            },
        },
        commandsResponse: {},
    },
    barrierControl: {
        ID: 259,
        attributes: {
            movingState: { ID: 1, type: dataType_1.default.ENUM8 },
            safetyStatus: { ID: 2, type: dataType_1.default.BITMAP16 },
            capabilities: { ID: 3, type: dataType_1.default.BITMAP8 },
            openEvents: { ID: 4, type: dataType_1.default.UINT16 },
            closeEvents: { ID: 5, type: dataType_1.default.UINT16 },
            commandOpenEvents: { ID: 6, type: dataType_1.default.UINT16 },
            commandCloseEvents: { ID: 7, type: dataType_1.default.UINT16 },
            openPeriod: { ID: 8, type: dataType_1.default.UINT16 },
            closePeriod: { ID: 9, type: dataType_1.default.UINT16 },
            barrierPosition: { ID: 10, type: dataType_1.default.UINT8 }
        },
        commands: {
            goToPercent: {
                ID: 0,
                parameters: [
                    { name: 'percentOpen', type: dataType_1.default.UINT8 }
                ],
            },
            stop: {
                ID: 1,
                parameters: [],
            },
        },
        commandsResponse: {},
    },
    hvacPumpCfgCtrl: {
        ID: 512,
        attributes: {
            maxPressure: { ID: 0, type: dataType_1.default.INT16 },
            maxSpeed: { ID: 1, type: dataType_1.default.UINT16 },
            maxFlow: { ID: 2, type: dataType_1.default.UINT16 },
            minConstPressure: { ID: 3, type: dataType_1.default.INT16 },
            maxConstPressure: { ID: 4, type: dataType_1.default.INT16 },
            minCompPressure: { ID: 5, type: dataType_1.default.INT16 },
            maxCompPressure: { ID: 6, type: dataType_1.default.INT16 },
            minConstSpeed: { ID: 7, type: dataType_1.default.UINT16 },
            maxConstSpeed: { ID: 8, type: dataType_1.default.UINT16 },
            minConstFlow: { ID: 9, type: dataType_1.default.UINT16 },
            maxConstFlow: { ID: 10, type: dataType_1.default.UINT16 },
            minConstTemp: { ID: 11, type: dataType_1.default.INT16 },
            maxConstTemp: { ID: 12, type: dataType_1.default.INT16 },
            pumpStatus: { ID: 16, type: dataType_1.default.BITMAP16 },
            effectiveOperationMode: { ID: 17, type: dataType_1.default.ENUM8 },
            effectiveControlMode: { ID: 18, type: dataType_1.default.ENUM8 },
            capacity: { ID: 19, type: dataType_1.default.INT16 },
            speed: { ID: 20, type: dataType_1.default.UINT16 },
            lifetimeRunningHours: { ID: 21, type: dataType_1.default.UINT24 },
            power: { ID: 22, type: dataType_1.default.UINT24 },
            lifetimeEnergyConsumed: { ID: 23, type: dataType_1.default.UINT32 },
            operationMode: { ID: 32, type: dataType_1.default.ENUM8 },
            controlMode: { ID: 33, type: dataType_1.default.ENUM8 },
            alarmMask: { ID: 34, type: dataType_1.default.BITMAP16 },
        },
        commands: {},
        commandsResponse: {},
    },
    hvacThermostat: {
        ID: 513,
        attributes: {
            localTemp: { ID: 0, type: dataType_1.default.INT16 },
            outdoorTemp: { ID: 1, type: dataType_1.default.INT16 },
            occupancy: { ID: 2, type: dataType_1.default.BITMAP8 },
            absMinHeatSetpointLimit: { ID: 3, type: dataType_1.default.INT16 },
            absMaxHeatSetpointLimit: { ID: 4, type: dataType_1.default.INT16 },
            absMinCoolSetpointLimit: { ID: 5, type: dataType_1.default.INT16 },
            absMaxCoolSetpointLimit: { ID: 6, type: dataType_1.default.INT16 },
            pICoolingDemand: { ID: 7, type: dataType_1.default.UINT8 },
            pIHeatingDemand: { ID: 8, type: dataType_1.default.UINT8 },
            systemTypeConfig: { ID: 9, type: dataType_1.default.BITMAP8 },
            localTemperatureCalibration: { ID: 16, type: dataType_1.default.INT8 },
            occupiedCoolingSetpoint: { ID: 17, type: dataType_1.default.INT16 },
            occupiedHeatingSetpoint: { ID: 18, type: dataType_1.default.INT16 },
            unoccupiedCoolingSetpoint: { ID: 19, type: dataType_1.default.INT16 },
            unoccupiedHeatingSetpoint: { ID: 20, type: dataType_1.default.INT16 },
            minHeatSetpointLimit: { ID: 21, type: dataType_1.default.INT16 },
            maxHeatSetpointLimit: { ID: 22, type: dataType_1.default.INT16 },
            minCoolSetpointLimit: { ID: 23, type: dataType_1.default.INT16 },
            maxCoolSetpointLimit: { ID: 24, type: dataType_1.default.INT16 },
            minSetpointDeadBand: { ID: 25, type: dataType_1.default.INT8 },
            remoteSensing: { ID: 26, type: dataType_1.default.BITMAP8 },
            ctrlSeqeOfOper: { ID: 27, type: dataType_1.default.ENUM8 },
            systemMode: { ID: 28, type: dataType_1.default.ENUM8 },
            alarmMask: { ID: 29, type: dataType_1.default.BITMAP8 },
            runningMode: { ID: 30, type: dataType_1.default.ENUM8 },
            startOfWeek: { ID: 32, type: dataType_1.default.ENUM8 },
            numberOfWeeklyTrans: { ID: 33, type: dataType_1.default.UINT8 },
            numberOfDailyTrans: { ID: 34, type: dataType_1.default.UINT8 },
            tempSetpointHold: { ID: 35, type: dataType_1.default.ENUM8 },
            tempSetpointHoldDuration: { ID: 36, type: dataType_1.default.UINT16 },
            programingOperMode: { ID: 37, type: dataType_1.default.BITMAP8 },
            runningState: { ID: 41, type: dataType_1.default.BITMAP16 },
            setpointChangeSource: { ID: 48, type: dataType_1.default.ENUM8 },
            setpointChangeAmount: { ID: 49, type: dataType_1.default.INT16 },
            setpointChangeSourceTimeStamp: { ID: 50, type: dataType_1.default.UTC },
            acType: { ID: 64, type: dataType_1.default.ENUM8 },
            acCapacity: { ID: 65, type: dataType_1.default.UINT16 },
            acRefrigerantType: { ID: 66, type: dataType_1.default.ENUM8 },
            acConpressorType: { ID: 67, type: dataType_1.default.ENUM8 },
            acErrorCode: { ID: 68, type: dataType_1.default.BITMAP32 },
            acLouverPosition: { ID: 69, type: dataType_1.default.ENUM8 },
            acCollTemp: { ID: 70, type: dataType_1.default.INT16 },
            acCapacityFormat: { ID: 71, type: dataType_1.default.ENUM8 },
            SinopeOccupancy: { ID: 1024, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.SINOPE_TECHNOLOGIES },
            SinopeMainCycleOutput: { ID: 1025, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.SINOPE_TECHNOLOGIES },
            SinopeBacklight: { ID: 1026, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.SINOPE_TECHNOLOGIES },
            SinopeAuxCycleOutput: { ID: 1028, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.SINOPE_TECHNOLOGIES },
            StelproSystemMode: { ID: 0x401c, type: dataType_1.default.ENUM8 },
            StelproOutdoorTemp: { ID: 0x4001, type: dataType_1.default.INT16 },
            viessmannWindowOpenInternal: { ID: 0x4000, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.VIESSMANN_ELEKTRONIK_GMBH },
            viessmannWindowOpenForce: { ID: 0x4003, type: dataType_1.default.BOOLEAN, manufacturerCode: manufacturerCode_1.default.VIESSMANN_ELEKTRONIK_GMBH },
            viessmannAssemblyMode: { ID: 0x4012, type: dataType_1.default.BOOLEAN, manufacturerCode: manufacturerCode_1.default.VIESSMANN_ELEKTRONIK_GMBH },
            schneiderWiserSpecific: { ID: 0xe110, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            danfossWindowOpenInternal: { ID: 0x4000, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossWindowOpenExternal: { ID: 0x4003, type: dataType_1.default.BOOLEAN, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossDayOfWeek: { ID: 0x4010, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossTriggerTime: { ID: 0x4011, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossMountedModeActive: { ID: 0x4012, type: dataType_1.default.BOOLEAN, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossMountedModeControl: { ID: 0x4013, type: dataType_1.default.BOOLEAN, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossThermostatOrientation: { ID: 0x4014, type: dataType_1.default.BOOLEAN, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossExternalMeasuredRoomSensor: { ID: 0x4015, type: dataType_1.default.INT16, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossRadiatorCovered: { ID: 0x4016, type: dataType_1.default.BOOLEAN, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossAlgorithmScaleFactor: { ID: 0x4020, type: dataType_1.default.UINT8, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossHeatAvailable: { ID: 0x4030, type: dataType_1.default.BOOLEAN, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossHeatRequired: { ID: 0x4031, type: dataType_1.default.BOOLEAN, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossLoadBalancingEnable: { ID: 0x4032, type: dataType_1.default.BOOLEAN, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossLoadRoomMean: { ID: 0x4040, type: dataType_1.default.INT16, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossLoadEstimate: { ID: 0x404a, type: dataType_1.default.INT16, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossRegulationSetpointOffset: { ID: 0x404b, type: dataType_1.default.INT8, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossAdaptionRunControl: { ID: 0x404c, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossAdaptionRunStatus: { ID: 0x404d, type: dataType_1.default.BITMAP8, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossAdaptionRunSettings: { ID: 0x404e, type: dataType_1.default.BITMAP8, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossPreheatStatus: { ID: 0x404f, type: dataType_1.default.BOOLEAN, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossPreheatTime: { ID: 0x4050, type: dataType_1.default.UINT32, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossWindowOpenFeatureEnable: { ID: 0x4051, type: dataType_1.default.BOOLEAN, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossRoomStatusCode: { ID: 0x4100, type: dataType_1.default.BITMAP16, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossOutputStatus: { ID: 0x4110, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossRoomFloorSensorMode: { ID: 0x4120, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossFloorMinSetpoint: { ID: 0x4121, type: dataType_1.default.INT16, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossFloorMaxSetpoint: { ID: 0x4122, type: dataType_1.default.INT16, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            elkoLoad: { ID: 0x0401, type: dataType_1.default.UINT16 },
            elkoDisplayText: { ID: 0x0402, type: dataType_1.default.CHAR_STR },
            elkoSensor: { ID: 0x0403, type: dataType_1.default.ENUM8 },
            elkoRegulatorTime: { ID: 0x0404, type: dataType_1.default.UINT8 },
            elkoRegulatorMode: { ID: 0x0405, type: dataType_1.default.BOOLEAN },
            elkoPowerStatus: { ID: 0x0406, type: dataType_1.default.BOOLEAN },
            elkoDateTime: { ID: 0x0407, type: dataType_1.default.OCTET_STR },
            elkoMeanPower: { ID: 0x0408, type: dataType_1.default.UINT16 },
            elkoExternalTemp: { ID: 0x0409, type: dataType_1.default.INT16 },
            elkoNightSwitching: { ID: 0x0411, type: dataType_1.default.BOOLEAN },
            elkoFrostGuard: { ID: 0x0412, type: dataType_1.default.BOOLEAN },
            elkoChildLock: { ID: 0x0413, type: dataType_1.default.BOOLEAN },
            elkoMaxFloorTemp: { ID: 0x0414, type: dataType_1.default.UINT8 },
            elkoRelayState: { ID: 0x0415, type: dataType_1.default.BOOLEAN },
            elkoVersion: { ID: 0x0416, type: dataType_1.default.OCTET_STR },
            elkoCalibration: { ID: 0x0417, type: dataType_1.default.INT8 },
            elkoLastMessageId: { ID: 0x0418, type: dataType_1.default.UINT8 },
            elkoLastMessageStatus: { ID: 0x0419, type: dataType_1.default.UINT8 },
            fourNoksHysteresisHigh: { ID: 0x0101, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.ASTREL_GROUP_SRL },
            fourNoksHysteresisLow: { ID: 0x0102, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.ASTREL_GROUP_SRL },
        },
        commands: {
            setpointRaiseLower: {
                ID: 0,
                parameters: [
                    { name: 'mode', type: dataType_1.default.UINT8 },
                    { name: 'amount', type: dataType_1.default.INT8 },
                ],
            },
            setWeeklySchedule: {
                ID: 1,
                parameters: [
                    { name: 'numoftrans', type: dataType_1.default.UINT8 },
                    { name: 'dayofweek', type: dataType_1.default.UINT8 },
                    { name: 'mode', type: dataType_1.default.UINT8 },
                    { name: 'transitions', type: buffaloZclDataType_1.default.LIST_THERMO_TRANSITIONS },
                ],
            },
            getWeeklySchedule: {
                ID: 2,
                parameters: [
                    { name: 'daystoreturn', type: dataType_1.default.UINT8 },
                    { name: 'modetoreturn', type: dataType_1.default.UINT8 },
                ],
            },
            clearWeeklySchedule: {
                ID: 3,
                parameters: [],
            },
            getRelayStatusLog: {
                ID: 4,
                parameters: [],
            },
            danfossSetpointCommand: {
                ID: 64,
                parameters: [
                    { name: 'setpointType', type: dataType_1.default.ENUM8 },
                    { name: 'setpoint', type: dataType_1.default.INT16 },
                ],
            },
            schneiderWiserThermostatBoost: {
                ID: 0x80,
                parameters: [
                    { name: 'command', type: dataType_1.default.ENUM8 },
                    { name: 'enable', type: dataType_1.default.ENUM8 },
                    { name: 'temperature', type: dataType_1.default.UINT16 },
                    { name: 'duration', type: dataType_1.default.UINT16 },
                ],
            },
            wiserSmartSetSetpoint: {
                ID: 224,
                parameters: [
                    { name: 'operatingmode', type: dataType_1.default.UINT8 },
                    { name: 'zonemode', type: dataType_1.default.UINT8 },
                    { name: 'setpoint', type: dataType_1.default.INT16 },
                    { name: 'reserved', type: dataType_1.default.UINT8 },
                ],
            },
            wiserSmartSetFipMode: {
                ID: 225,
                parameters: [
                    { name: 'zonemode', type: dataType_1.default.UINT8 },
                    { name: 'fipmode', type: dataType_1.default.ENUM8 },
                    { name: 'reserved', type: dataType_1.default.UINT8 },
                ],
            },
            wiserSmartCalibrateValve: {
                ID: 226,
                parameters: [],
            },
            plugwiseCalibrateValve: {
                ID: 0xa0,
                parameters: [],
            },
            boschCalibrateValve: {
                ID: 0x41,
                parameters: [],
            },
        },
        commandsResponse: {
            getWeeklyScheduleRsp: {
                ID: 0,
                parameters: [
                    { name: 'numoftrans', type: dataType_1.default.UINT8 },
                    { name: 'dayofweek', type: dataType_1.default.UINT8 },
                    { name: 'mode', type: dataType_1.default.UINT8 },
                    { name: 'transitions', type: buffaloZclDataType_1.default.LIST_THERMO_TRANSITIONS },
                ],
            },
            getRelayStatusLogRsp: {
                ID: 1,
                parameters: [
                    { name: 'timeofday', type: dataType_1.default.UINT16 },
                    { name: 'relaystatus', type: dataType_1.default.UINT16 },
                    { name: 'localtemp', type: dataType_1.default.UINT16 },
                    { name: 'humidity', type: dataType_1.default.UINT8 },
                    { name: 'setpoint', type: dataType_1.default.UINT16 },
                    { name: 'unreadentries', type: dataType_1.default.UINT16 },
                ],
            },
        },
    },
    hvacFanCtrl: {
        ID: 514,
        attributes: {
            fanMode: { ID: 0, type: dataType_1.default.ENUM8 },
            fanModeSequence: { ID: 1, type: dataType_1.default.ENUM8 },
        },
        commands: {},
        commandsResponse: {},
    },
    hvacDehumidificationCtrl: {
        ID: 515,
        attributes: {
            relativeHumidity: { ID: 0, type: dataType_1.default.UINT8 },
            dehumidCooling: { ID: 1, type: dataType_1.default.UINT8 },
            rhDehumidSetpoint: { ID: 16, type: dataType_1.default.UINT8 },
            relativeHumidityMode: { ID: 17, type: dataType_1.default.ENUM8 },
            dehumidLockout: { ID: 18, type: dataType_1.default.ENUM8 },
            dehumidHysteresis: { ID: 19, type: dataType_1.default.UINT8 },
            dehumidMaxCool: { ID: 20, type: dataType_1.default.UINT8 },
            relativeHumidDisplay: { ID: 21, type: dataType_1.default.ENUM8 },
        },
        commands: {},
        commandsResponse: {},
    },
    hvacUserInterfaceCfg: {
        ID: 516,
        attributes: {
            tempDisplayMode: { ID: 0, type: dataType_1.default.ENUM8 },
            keypadLockout: { ID: 1, type: dataType_1.default.ENUM8 },
            programmingVisibility: { ID: 2, type: dataType_1.default.ENUM8 },
            danfossViewingDirection: { ID: 0x4000, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
        },
        commands: {},
        commandsResponse: {},
    },
    lightingColorCtrl: {
        ID: 768,
        attributes: {
            currentHue: { ID: 0, type: dataType_1.default.UINT8 },
            currentSaturation: { ID: 1, type: dataType_1.default.UINT8 },
            remainingTime: { ID: 2, type: dataType_1.default.UINT16 },
            currentX: { ID: 3, type: dataType_1.default.UINT16 },
            currentY: { ID: 4, type: dataType_1.default.UINT16 },
            driftCompensation: { ID: 5, type: dataType_1.default.ENUM8 },
            compensationText: { ID: 6, type: dataType_1.default.CHAR_STR },
            colorTemperature: { ID: 7, type: dataType_1.default.UINT16 },
            colorMode: { ID: 8, type: dataType_1.default.ENUM8 },
            options: { ID: 15, type: dataType_1.default.BITMAP8 },
            numPrimaries: { ID: 16, type: dataType_1.default.UINT8 },
            primary1X: { ID: 17, type: dataType_1.default.UINT16 },
            primary1Y: { ID: 18, type: dataType_1.default.UINT16 },
            primary1Intensity: { ID: 19, type: dataType_1.default.UINT8 },
            primary2X: { ID: 21, type: dataType_1.default.UINT16 },
            primary2Y: { ID: 22, type: dataType_1.default.UINT16 },
            primary2Intensity: { ID: 23, type: dataType_1.default.UINT8 },
            primary3X: { ID: 25, type: dataType_1.default.UINT16 },
            primary3Y: { ID: 26, type: dataType_1.default.UINT16 },
            primary3Intensity: { ID: 27, type: dataType_1.default.UINT8 },
            primary4X: { ID: 32, type: dataType_1.default.UINT16 },
            primary4Y: { ID: 33, type: dataType_1.default.UINT16 },
            primary4Intensity: { ID: 34, type: dataType_1.default.UINT8 },
            primary5X: { ID: 36, type: dataType_1.default.UINT16 },
            primary5Y: { ID: 37, type: dataType_1.default.UINT16 },
            primary5Intensity: { ID: 38, type: dataType_1.default.UINT8 },
            primary6X: { ID: 40, type: dataType_1.default.UINT16 },
            primary6Y: { ID: 41, type: dataType_1.default.UINT16 },
            primary6Intensity: { ID: 42, type: dataType_1.default.UINT8 },
            whitePointX: { ID: 48, type: dataType_1.default.UINT16 },
            whitePointY: { ID: 49, type: dataType_1.default.UINT16 },
            colorPointRX: { ID: 50, type: dataType_1.default.UINT16 },
            colorPointRY: { ID: 51, type: dataType_1.default.UINT16 },
            colorPointRIntensity: { ID: 52, type: dataType_1.default.UINT8 },
            colorPointGX: { ID: 54, type: dataType_1.default.UINT16 },
            colorPointGY: { ID: 55, type: dataType_1.default.UINT16 },
            colorPointGIntensity: { ID: 56, type: dataType_1.default.UINT8 },
            colorPointBX: { ID: 58, type: dataType_1.default.UINT16 },
            colorPointBY: { ID: 59, type: dataType_1.default.UINT16 },
            colorPointBIntensity: { ID: 60, type: dataType_1.default.UINT8 },
            enhancedCurrentHue: { ID: 16384, type: dataType_1.default.UINT16 },
            enhancedColorMode: { ID: 16385, type: dataType_1.default.ENUM8 },
            colorLoopActive: { ID: 16386, type: dataType_1.default.UINT8 },
            colorLoopDirection: { ID: 16387, type: dataType_1.default.UINT8 },
            colorLoopTime: { ID: 16388, type: dataType_1.default.UINT16 },
            colorLoopStartEnhancedHue: { ID: 16389, type: dataType_1.default.UINT16 },
            colorLoopStoredEnhancedHue: { ID: 16390, type: dataType_1.default.UINT16 },
            colorCapabilities: { ID: 16394, type: dataType_1.default.UINT16 },
            colorTempPhysicalMin: { ID: 16395, type: dataType_1.default.UINT16 },
            colorTempPhysicalMax: { ID: 16396, type: dataType_1.default.UINT16 },
            coupleColorTempToLevelMin: { ID: 16397, type: dataType_1.default.UINT16 },
            startUpColorTemperature: { ID: 16400, type: dataType_1.default.UINT16 },
            tuyaBrightness: { ID: 61441, type: dataType_1.default.UINT16 },
            tuyaRgbMode: { ID: 61440, type: dataType_1.default.UINT16 },
        },
        commands: {
            moveToHue: {
                ID: 0,
                parameters: [
                    { name: 'hue', type: dataType_1.default.UINT8 },
                    { name: 'direction', type: dataType_1.default.UINT8 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                ],
            },
            moveHue: {
                ID: 1,
                parameters: [
                    { name: 'movemode', type: dataType_1.default.UINT8 },
                    { name: 'rate', type: dataType_1.default.UINT8 },
                ],
            },
            stepHue: {
                ID: 2,
                parameters: [
                    { name: 'stepmode', type: dataType_1.default.UINT8 },
                    { name: 'stepsize', type: dataType_1.default.UINT8 },
                    { name: 'transtime', type: dataType_1.default.UINT8 },
                ],
            },
            moveToSaturation: {
                ID: 3,
                parameters: [
                    { name: 'saturation', type: dataType_1.default.UINT8 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                ],
            },
            moveSaturation: {
                ID: 4,
                parameters: [
                    { name: 'movemode', type: dataType_1.default.UINT8 },
                    { name: 'rate', type: dataType_1.default.UINT8 },
                ],
            },
            stepSaturation: {
                ID: 5,
                parameters: [
                    { name: 'stepmode', type: dataType_1.default.UINT8 },
                    { name: 'stepsize', type: dataType_1.default.UINT8 },
                    { name: 'transtime', type: dataType_1.default.UINT8 },
                ],
            },
            moveToHueAndSaturation: {
                ID: 6,
                parameters: [
                    { name: 'hue', type: dataType_1.default.UINT8 },
                    { name: 'saturation', type: dataType_1.default.UINT8 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                ],
            },
            tuyaMoveToHueAndSaturationBrightness: {
                ID: 6,
                parameters: [
                    { name: 'hue', type: dataType_1.default.UINT8 },
                    { name: 'saturation', type: dataType_1.default.UINT8 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                    { name: 'brightness', type: dataType_1.default.UINT8 },
                ],
            },
            moveToColor: {
                ID: 7,
                parameters: [
                    { name: 'colorx', type: dataType_1.default.UINT16 },
                    { name: 'colory', type: dataType_1.default.UINT16 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                ],
            },
            moveColor: {
                ID: 8,
                parameters: [
                    { name: 'ratex', type: dataType_1.default.INT16 },
                    { name: 'ratey', type: dataType_1.default.INT16 },
                ],
            },
            stepColor: {
                ID: 9,
                parameters: [
                    { name: 'stepx', type: dataType_1.default.INT16 },
                    { name: 'stepy', type: dataType_1.default.INT16 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                ],
            },
            moveToColorTemp: {
                ID: 10,
                parameters: [
                    { name: 'colortemp', type: dataType_1.default.UINT16 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                ],
            },
            enhancedMoveToHue: {
                ID: 64,
                parameters: [
                    { name: 'enhancehue', type: dataType_1.default.UINT16 },
                    { name: 'direction', type: dataType_1.default.UINT8 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                ],
            },
            enhancedMoveHue: {
                ID: 65,
                parameters: [
                    { name: 'movemode', type: dataType_1.default.UINT8 },
                    { name: 'rate', type: dataType_1.default.UINT16 },
                ],
            },
            enhancedStepHue: {
                ID: 66,
                parameters: [
                    { name: 'stepmode', type: dataType_1.default.UINT8 },
                    { name: 'stepsize', type: dataType_1.default.UINT16 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                ],
            },
            enhancedMoveToHueAndSaturation: {
                ID: 67,
                parameters: [
                    { name: 'enhancehue', type: dataType_1.default.UINT16 },
                    { name: 'saturation', type: dataType_1.default.UINT8 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                ],
            },
            colorLoopSet: {
                ID: 68,
                parameters: [
                    { name: 'updateflags', type: dataType_1.default.UINT8 },
                    { name: 'action', type: dataType_1.default.UINT8 },
                    { name: 'direction', type: dataType_1.default.UINT8 },
                    { name: 'time', type: dataType_1.default.UINT16 },
                    { name: 'starthue', type: dataType_1.default.UINT16 },
                ],
            },
            stopMoveStep: {
                ID: 71,
                parameters: [
                    { name: 'bits', type: dataType_1.default.UINT8 },
                    { name: 'bytee', type: dataType_1.default.UINT8 },
                    { name: 'action', type: dataType_1.default.UINT8 },
                    { name: 'direction', type: dataType_1.default.UINT8 },
                    { name: 'time', type: dataType_1.default.UINT16 },
                    { name: 'starthue', type: dataType_1.default.UINT16 },
                ],
            },
            moveColorTemp: {
                ID: 75,
                parameters: [
                    { name: 'movemode', type: dataType_1.default.UINT8 },
                    { name: 'rate', type: dataType_1.default.UINT16 },
                    { name: 'minimum', type: dataType_1.default.UINT16 },
                    { name: 'maximum', type: dataType_1.default.UINT16 },
                ],
            },
            stepColorTemp: {
                ID: 76,
                parameters: [
                    { name: 'stepmode', type: dataType_1.default.UINT8 },
                    { name: 'stepsize', type: dataType_1.default.UINT16 },
                    { name: 'transtime', type: dataType_1.default.UINT16 },
                    { name: 'minimum', type: dataType_1.default.UINT16 },
                    { name: 'maximum', type: dataType_1.default.UINT16 },
                ],
            },
            tuyaMoveToHueAndSaturationBrightness2: {
                ID: 225,
                parameters: [
                    { name: 'hue', type: dataType_1.default.UINT16 },
                    { name: 'saturation', type: dataType_1.default.UINT16 },
                    { name: 'brightness', type: dataType_1.default.UINT16 },
                ],
            },
            tuyaRgbMode: {
                ID: 240,
                parameters: [
                    { name: 'enable', type: dataType_1.default.UINT8 },
                ]
            },
            tuyaOnStartUp: {
                ID: 249,
                parameters: [
                    { name: 'mode', type: dataType_1.default.UINT16 },
                    { name: 'data', type: buffaloZclDataType_1.default.LIST_UINT8 },
                ],
            },
            tuyaDoNotDisturb: {
                ID: 250,
                parameters: [
                    { name: 'enable', type: dataType_1.default.UINT8 },
                ],
            },
            tuyaOnOffTransitionTime: {
                ID: 251,
                parameters: [
                    { name: 'unknown', type: dataType_1.default.UINT8 },
                    { name: 'onTransitionTime', type: buffaloZclDataType_1.default.BIG_ENDIAN_UINT24 },
                    { name: 'offTransitionTime', type: buffaloZclDataType_1.default.BIG_ENDIAN_UINT24 },
                ],
            },
        },
        commandsResponse: {},
    },
    lightingBallastCfg: {
        ID: 769,
        attributes: {
            physicalMinLevel: { ID: 0, type: dataType_1.default.UINT8 },
            physicalMaxLevel: { ID: 1, type: dataType_1.default.UINT8 },
            ballastStatus: { ID: 2, type: dataType_1.default.BITMAP8 },
            minLevel: { ID: 16, type: dataType_1.default.UINT8 },
            maxLevel: { ID: 17, type: dataType_1.default.UINT8 },
            powerOnLevel: { ID: 18, type: dataType_1.default.UINT8 },
            powerOnFadeTime: { ID: 19, type: dataType_1.default.UINT16 },
            intrinsicBallastFactor: { ID: 20, type: dataType_1.default.UINT8 },
            ballastFactorAdjustment: { ID: 21, type: dataType_1.default.UINT8 },
            lampQuantity: { ID: 32, type: dataType_1.default.UINT8 },
            lampType: { ID: 48, type: dataType_1.default.CHAR_STR },
            lampManufacturer: { ID: 49, type: dataType_1.default.CHAR_STR },
            lampRatedHours: { ID: 50, type: dataType_1.default.UINT24 },
            lampBurnHours: { ID: 51, type: dataType_1.default.UINT24 },
            lampAlarmMode: { ID: 52, type: dataType_1.default.BITMAP8 },
            lampBurnHoursTripPoint: { ID: 53, type: dataType_1.default.UINT24 },
            elkoControlMode: { ID: 0xE000, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.ADEO },
            wiserControlMode: { ID: 0xE000, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
        },
        commands: {},
        commandsResponse: {},
    },
    msIlluminanceMeasurement: {
        ID: 1024,
        attributes: {
            measuredValue: { ID: 0, type: dataType_1.default.UINT16 },
            minMeasuredValue: { ID: 1, type: dataType_1.default.UINT16 },
            maxMeasuredValue: { ID: 2, type: dataType_1.default.UINT16 },
            tolerance: { ID: 3, type: dataType_1.default.UINT16 },
            lightSensorType: { ID: 4, type: dataType_1.default.ENUM8 },
        },
        commands: {},
        commandsResponse: {},
    },
    msIlluminanceLevelSensing: {
        ID: 1025,
        attributes: {
            levelStatus: { ID: 0, type: dataType_1.default.ENUM8 },
            lightSensorType: { ID: 1, type: dataType_1.default.ENUM8 },
            illuminanceTargetLevel: { ID: 16, type: dataType_1.default.UINT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    msTemperatureMeasurement: {
        ID: 1026,
        attributes: {
            measuredValue: { ID: 0, type: dataType_1.default.INT16 },
            minMeasuredValue: { ID: 1, type: dataType_1.default.INT16 },
            maxMeasuredValue: { ID: 2, type: dataType_1.default.INT16 },
            tolerance: { ID: 3, type: dataType_1.default.UINT16 },
            minPercentChange: { ID: 16, type: dataType_1.default.UNKNOWN },
            minAbsoluteChange: { ID: 17, type: dataType_1.default.UNKNOWN },
            sprutTemperatureOffset: { ID: 0x6600, type: dataType_1.default.INT16, manufacturerCode: manufacturerCode_1.default.CUSTOM_SPRUT_DEVICE },
        },
        commands: {},
        commandsResponse: {},
    },
    msPressureMeasurement: {
        ID: 1027,
        attributes: {
            measuredValue: { ID: 0, type: dataType_1.default.INT16 },
            minMeasuredValue: { ID: 1, type: dataType_1.default.INT16 },
            maxMeasuredValue: { ID: 2, type: dataType_1.default.INT16 },
            tolerance: { ID: 3, type: dataType_1.default.UINT16 },
            scaledValue: { ID: 0x0010, type: dataType_1.default.INT16 },
            minScaledValue: { ID: 0x0011, type: dataType_1.default.INT16 },
            maxScaledValue: { ID: 0x0012, type: dataType_1.default.INT16 },
            scaledTolerance: { ID: 0x0013, type: dataType_1.default.UINT16 },
            scale: { ID: 0x0014, type: dataType_1.default.INT8 },
        },
        commands: {},
        commandsResponse: {},
    },
    msFlowMeasurement: {
        ID: 1028,
        attributes: {
            measuredValue: { ID: 0, type: dataType_1.default.UINT16 },
            minMeasuredValue: { ID: 1, type: dataType_1.default.UINT16 },
            maxMeasuredValue: { ID: 2, type: dataType_1.default.UINT16 },
            tolerance: { ID: 3, type: dataType_1.default.UINT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    msRelativeHumidity: {
        ID: 1029,
        attributes: {
            measuredValue: { ID: 0, type: dataType_1.default.UINT16 },
            minMeasuredValue: { ID: 1, type: dataType_1.default.UINT16 },
            maxMeasuredValue: { ID: 2, type: dataType_1.default.UINT16 },
            tolerance: { ID: 3, type: dataType_1.default.UINT16 },
            sprutHeater: { ID: 0x6600, type: dataType_1.default.BOOLEAN, manufacturerCode: manufacturerCode_1.default.CUSTOM_SPRUT_DEVICE },
        },
        commands: {},
        commandsResponse: {},
    },
    msOccupancySensing: {
        ID: 1030,
        attributes: {
            occupancy: { ID: 0x0000, type: dataType_1.default.BITMAP8 },
            occupancySensorType: { ID: 0x0001, type: dataType_1.default.ENUM8 },
            occupancySensorTypeBitmap: { ID: 0x0002, type: dataType_1.default.BITMAP8 },
            pirOToUDelay: { ID: 0x0010, type: dataType_1.default.UINT16 },
            pirUToODelay: { ID: 0x0011, type: dataType_1.default.UINT16 },
            pirUToOThreshold: { ID: 0x0012, type: dataType_1.default.UINT8 },
            ultrasonicOToUDelay: { ID: 0x0020, type: dataType_1.default.UINT16 },
            ultrasonicUToODelay: { ID: 0x0021, type: dataType_1.default.UINT16 },
            ultrasonicUToOThreshold: { ID: 0x0022, type: dataType_1.default.UINT8 },
            contactOToUDelay: { ID: 0x0030, type: dataType_1.default.UINT16 },
            contactUToODelay: { ID: 0x0031, type: dataType_1.default.UINT16 },
            contactUToOThreshold: { ID: 0x0032, type: dataType_1.default.UINT8 },
            elkoOccupancyDfltOperationMode: { ID: 0xE000, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.ADEO },
            elkoOccupancyOperationMode: { ID: 0xE001, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.ADEO },
            elkoForceOffTimeout: { ID: 0xE002, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.ADEO },
            elkoOccupancySensitivity: { ID: 0xE003, type: dataType_1.default.UINT8, manufacturerCode: manufacturerCode_1.default.ADEO },
            sprutOccupancyLevel: { ID: 0x6600, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.CUSTOM_SPRUT_DEVICE },
            sprutOccupancySensitivity: { ID: 0x6601, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.CUSTOM_SPRUT_DEVICE },
        },
        commands: {},
        commandsResponse: {},
    },
    msSoilMoisture: {
        ID: 1032,
        attributes: {
            measuredValue: { ID: 0, type: dataType_1.default.UINT16 },
            minMeasuredValue: { ID: 1, type: dataType_1.default.UINT16 },
            maxMeasuredValue: { ID: 2, type: dataType_1.default.UINT16 },
            tolerance: { ID: 3, type: dataType_1.default.UINT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    pHMeasurement: {
        ID: 1033,
        attributes: {
            measuredValue: { ID: 0, type: dataType_1.default.UINT16 },
            minMeasuredValue: { ID: 1, type: dataType_1.default.UINT16 },
            maxMeasuredValue: { ID: 2, type: dataType_1.default.UINT16 },
            tolerance: { ID: 3, type: dataType_1.default.UINT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    msCO2: {
        ID: 1037,
        attributes: {
            measuredValue: { ID: 0, type: dataType_1.default.SINGLE_PREC },
            minMeasuredValue: { ID: 1, type: dataType_1.default.SINGLE_PREC },
            maxMeasuredValue: { ID: 2, type: dataType_1.default.SINGLE_PREC },
            sprutCO2Calibration: { ID: 0x6600, type: dataType_1.default.BOOLEAN, manufacturerCode: manufacturerCode_1.default.CUSTOM_SPRUT_DEVICE },
            sprutCO2AutoCalibration: { ID: 0x6601, type: dataType_1.default.BOOLEAN, manufacturerCode: manufacturerCode_1.default.CUSTOM_SPRUT_DEVICE },
        },
        commands: {},
        commandsResponse: {},
    },
    pm25Measurement: {
        ID: 0x042a,
        attributes: {
            measuredValue: { ID: 0x0000, type: dataType_1.default.UINT16 },
            measuredMinValue: { ID: 0x0001, type: dataType_1.default.UINT16 },
            measuredMaxValue: { ID: 0x0002, type: dataType_1.default.UINT16 },
            measuredTolerance: { ID: 0x0003, type: dataType_1.default.UINT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    ssIasZone: {
        ID: 1280,
        attributes: {
            zoneState: { ID: 0, type: dataType_1.default.ENUM8 },
            zoneType: { ID: 1, type: dataType_1.default.ENUM16 },
            zoneStatus: { ID: 2, type: dataType_1.default.BITMAP16 },
            iasCieAddr: { ID: 16, type: dataType_1.default.IEEE_ADDR },
            zoneId: { ID: 17, type: dataType_1.default.UINT8 },
            numZoneSensitivityLevelsSupported: { ID: 18, type: dataType_1.default.UINT8 },
            currentZoneSensitivityLevel: { ID: 19, type: dataType_1.default.UINT8 },
            develcoAlarmOffDelay: { ID: 0x8001, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.DEVELCO },
        },
        commands: {
            enrollRsp: {
                ID: 0,
                parameters: [
                    { name: 'enrollrspcode', type: dataType_1.default.UINT8 },
                    { name: 'zoneid', type: dataType_1.default.UINT8 },
                ],
            },
            initNormalOpMode: {
                ID: 1,
                parameters: [],
            },
            initTestMode: {
                ID: 2,
                parameters: [],
            },
            boschTestTamper: {
                ID: 0xF3,
                parameters: [
                    { name: 'data', type: dataType_1.default.UINT8 },
                ],
            },
            boschSmokeDetectorSiren: {
                ID: 0x80,
                parameters: [{ name: "data", type: dataType_1.default.UINT16 }],
            },
        },
        commandsResponse: {
            statusChangeNotification: {
                ID: 0,
                parameters: [
                    { name: 'zonestatus', type: dataType_1.default.UINT16 },
                    { name: 'extendedstatus', type: dataType_1.default.UINT8 },
                ],
            },
            enrollReq: {
                ID: 1,
                parameters: [
                    { name: 'zonetype', type: dataType_1.default.UINT16 },
                    { name: 'manucode', type: dataType_1.default.UINT16 },
                ],
            },
        },
    },
    ssIasAce: {
        ID: 1281,
        attributes: {},
        commands: {
            arm: {
                ID: 0,
                response: 0,
                parameters: [
                    { name: 'armmode', type: dataType_1.default.UINT8 },
                    { name: 'code', type: dataType_1.default.CHAR_STR },
                    { name: 'zoneid', type: dataType_1.default.UINT8 },
                ],
            },
            bypass: {
                ID: 1,
                parameters: [
                    { name: 'numofzones', type: dataType_1.default.UINT8 },
                    { name: 'zoneidlist', type: buffaloZclDataType_1.default.LIST_UINT8 },
                ],
            },
            emergency: {
                ID: 2,
                parameters: [],
            },
            fire: {
                ID: 3,
                parameters: [],
            },
            panic: {
                ID: 4,
                parameters: [],
            },
            getZoneIDMap: {
                ID: 5,
                response: 1,
                parameters: [],
            },
            getZoneInfo: {
                ID: 6,
                response: 2,
                parameters: [
                    { name: 'zoneid', type: dataType_1.default.UINT8 },
                ],
            },
            getPanelStatus: {
                ID: 7,
                response: 5,
                parameters: [],
            },
            getBypassedZoneList: {
                ID: 8,
                parameters: [],
            },
            getZoneStatus: {
                ID: 9,
                response: 8,
                parameters: [
                    { name: 'startzoneid', type: dataType_1.default.UINT8 },
                    { name: 'maxnumzoneid', type: dataType_1.default.UINT8 },
                    { name: 'zonestatusmaskflag', type: dataType_1.default.UINT8 },
                    { name: 'zonestatusmask', type: dataType_1.default.UINT16 },
                ],
            },
        },
        commandsResponse: {
            armRsp: {
                ID: 0,
                parameters: [
                    { name: 'armnotification', type: dataType_1.default.UINT8 },
                ],
            },
            getZoneIDMapRsp: {
                ID: 1,
                parameters: [
                    { name: 'zoneidmapsection0', type: dataType_1.default.UINT16 },
                    { name: 'zoneidmapsection1', type: dataType_1.default.UINT16 },
                    { name: 'zoneidmapsection2', type: dataType_1.default.UINT16 },
                    { name: 'zoneidmapsection3', type: dataType_1.default.UINT16 },
                    { name: 'zoneidmapsection4', type: dataType_1.default.UINT16 },
                    { name: 'zoneidmapsection5', type: dataType_1.default.UINT16 },
                    { name: 'zoneidmapsection6', type: dataType_1.default.UINT16 },
                    { name: 'zoneidmapsection7', type: dataType_1.default.UINT16 },
                    { name: 'zoneidmapsection8', type: dataType_1.default.UINT16 },
                    { name: 'zoneidmapsection9', type: dataType_1.default.UINT16 },
                    { name: 'zoneidmapsection10', type: dataType_1.default.UINT16 },
                    { name: 'zoneidmapsection11', type: dataType_1.default.UINT16 },
                    { name: 'zoneidmapsection12', type: dataType_1.default.UINT16 },
                    { name: 'zoneidmapsection13', type: dataType_1.default.UINT16 },
                    { name: 'zoneidmapsection14', type: dataType_1.default.UINT16 },
                    { name: 'zoneidmapsection15', type: dataType_1.default.UINT16 },
                ],
            },
            getZoneInfoRsp: {
                ID: 2,
                parameters: [
                    { name: 'zoneid', type: dataType_1.default.UINT8 },
                    { name: 'zonetype', type: dataType_1.default.UINT16 },
                    { name: 'ieeeaddr', type: dataType_1.default.IEEE_ADDR },
                    { name: 'zonelabel', type: dataType_1.default.CHAR_STR },
                ],
            },
            zoneStatusChanged: {
                ID: 3,
                parameters: [
                    { name: 'zoneid', type: dataType_1.default.UINT8 },
                    { name: 'zonestatus', type: dataType_1.default.UINT16 },
                    { name: 'audiblenotif', type: dataType_1.default.UINT8 },
                    { name: 'zonelabel', type: dataType_1.default.CHAR_STR },
                ],
            },
            panelStatusChanged: {
                ID: 4,
                parameters: [
                    { name: 'panelstatus', type: dataType_1.default.UINT8 },
                    { name: 'secondsremain', type: dataType_1.default.UINT8 },
                    { name: 'audiblenotif', type: dataType_1.default.UINT8 },
                    { name: 'alarmstatus', type: dataType_1.default.UINT8 },
                ],
            },
            getPanelStatusRsp: {
                ID: 5,
                parameters: [
                    { name: 'panelstatus', type: dataType_1.default.UINT8 },
                    { name: 'secondsremain', type: dataType_1.default.UINT8 },
                    { name: 'audiblenotif', type: dataType_1.default.UINT8 },
                    { name: 'alarmstatus', type: dataType_1.default.UINT8 },
                ],
            },
            setBypassedZoneList: {
                ID: 6,
                parameters: [
                    { name: 'numofzones', type: dataType_1.default.UINT8 },
                    { name: 'zoneid', type: buffaloZclDataType_1.default.LIST_UINT8 },
                ],
            },
            bypassRsp: {
                ID: 7,
                parameters: [
                    { name: 'numofzones', type: dataType_1.default.UINT8 },
                    { name: 'bypassresult', type: buffaloZclDataType_1.default.LIST_UINT8 },
                ],
            },
            getZoneStatusRsp: {
                ID: 8,
                parameters: [
                    { name: 'zonestatuscomplete', type: dataType_1.default.UINT8 },
                    { name: 'numofzones', type: dataType_1.default.UINT8 },
                    { name: 'zoneinfo', type: buffaloZclDataType_1.default.LIST_ZONEINFO },
                ],
            },
        },
    },
    ssIasWd: {
        ID: 1282,
        attributes: {
            maxDuration: { ID: 0, type: dataType_1.default.UINT16 },
        },
        commands: {
            startWarning: {
                ID: 0,
                parameters: [
                    { name: 'startwarninginfo', type: dataType_1.default.UINT8 },
                    { name: 'warningduration', type: dataType_1.default.UINT16 },
                    { name: 'strobedutycycle', type: dataType_1.default.UINT8 },
                    { name: 'strobelevel', type: dataType_1.default.UINT8 },
                ],
            },
            squawk: {
                ID: 1,
                parameters: [
                    { name: 'squawkinfo', type: dataType_1.default.UINT8 },
                ],
            },
            boschOutdoorSiren: {
                ID: 240,
                parameters: [
                    { name: 'data', type: dataType_1.default.UINT8 },
                ],
            },
        },
        commandsResponse: {},
    },
    piGenericTunnel: {
        ID: 1536,
        attributes: {
            maxIncomeTransSize: { ID: 1, type: dataType_1.default.UINT16 },
            maxOutgoTransSize: { ID: 2, type: dataType_1.default.UINT16 },
            protocolAddr: { ID: 3, type: dataType_1.default.OCTET_STR },
        },
        commands: {
            matchProtocolAddr: {
                ID: 0,
                parameters: [
                    { name: 'protocoladdr', type: dataType_1.default.CHAR_STR },
                ],
            },
        },
        commandsResponse: {
            matchProtocolAddrRsp: {
                ID: 0,
                parameters: [
                    { name: 'devieeeaddr', type: dataType_1.default.IEEE_ADDR },
                    { name: 'protocoladdr', type: dataType_1.default.CHAR_STR },
                ],
            },
            advertiseProtocolAddr: {
                ID: 1,
                parameters: [
                    { name: 'protocoladdr', type: dataType_1.default.CHAR_STR },
                ],
            },
        },
    },
    piBacnetProtocolTunnel: {
        ID: 1537,
        attributes: {},
        commands: {
            transferNpdu: {
                ID: 0,
                parameters: [
                    { name: 'npdu', type: dataType_1.default.UINT8 },
                ],
            },
        },
        commandsResponse: {},
    },
    piAnalogInputReg: {
        ID: 1538,
        attributes: {
            covIncrement: { ID: 22, type: dataType_1.default.SINGLE_PREC },
            deviceType: { ID: 31, type: dataType_1.default.CHAR_STR },
            objectId: { ID: 75, type: dataType_1.default.BAC_OID },
            objectName: { ID: 77, type: dataType_1.default.CHAR_STR },
            objectType: { ID: 79, type: dataType_1.default.ENUM16 },
            updateInterval: { ID: 118, type: dataType_1.default.UINT8 },
            profileName: { ID: 168, type: dataType_1.default.CHAR_STR },
        },
        commands: {},
        commandsResponse: {},
    },
    piAnalogInputExt: {
        ID: 1539,
        attributes: {
            ackedTransitions: { ID: 0, type: dataType_1.default.BITMAP8 },
            notificationClass: { ID: 17, type: dataType_1.default.UINT16 },
            deadband: { ID: 25, type: dataType_1.default.SINGLE_PREC },
            eventEnable: { ID: 35, type: dataType_1.default.BITMAP8 },
            eventState: { ID: 36, type: dataType_1.default.ENUM8 },
            highLimit: { ID: 45, type: dataType_1.default.SINGLE_PREC },
            limitEnable: { ID: 52, type: dataType_1.default.BITMAP8 },
            lowLimit: { ID: 59, type: dataType_1.default.SINGLE_PREC },
            notifyType: { ID: 72, type: dataType_1.default.ENUM8 },
            timeDelay: { ID: 113, type: dataType_1.default.UINT8 },
            eventTimeStamps: { ID: 130, type: dataType_1.default.ARRAY },
        },
        commands: {
            transferApdu: {
                ID: 0,
                parameters: [],
            },
            connectReq: {
                ID: 1,
                parameters: [],
            },
            disconnectReq: {
                ID: 2,
                parameters: [],
            },
            connectStatusNoti: {
                ID: 3,
                parameters: [],
            },
        },
        commandsResponse: {},
    },
    piAnalogOutputReg: {
        ID: 1540,
        attributes: {
            covIncrement: { ID: 22, type: dataType_1.default.SINGLE_PREC },
            deviceType: { ID: 31, type: dataType_1.default.CHAR_STR },
            objectId: { ID: 75, type: dataType_1.default.BAC_OID },
            objectName: { ID: 77, type: dataType_1.default.CHAR_STR },
            objectType: { ID: 79, type: dataType_1.default.ENUM16 },
            updateInterval: { ID: 118, type: dataType_1.default.UINT8 },
            profileName: { ID: 168, type: dataType_1.default.CHAR_STR },
        },
        commands: {},
        commandsResponse: {},
    },
    piAnalogOutputExt: {
        ID: 1541,
        attributes: {
            ackedTransitions: { ID: 0, type: dataType_1.default.BITMAP8 },
            notificationClass: { ID: 17, type: dataType_1.default.UINT16 },
            deadband: { ID: 25, type: dataType_1.default.SINGLE_PREC },
            eventEnable: { ID: 35, type: dataType_1.default.BITMAP8 },
            eventState: { ID: 36, type: dataType_1.default.ENUM8 },
            highLimit: { ID: 45, type: dataType_1.default.SINGLE_PREC },
            limitEnable: { ID: 52, type: dataType_1.default.BITMAP8 },
            lowLimit: { ID: 59, type: dataType_1.default.SINGLE_PREC },
            notifyType: { ID: 72, type: dataType_1.default.ENUM8 },
            timeDelay: { ID: 113, type: dataType_1.default.UINT8 },
            eventTimeStamps: { ID: 130, type: dataType_1.default.ARRAY },
        },
        commands: {},
        commandsResponse: {},
    },
    piAnalogValueReg: {
        ID: 1542,
        attributes: {
            covIncrement: { ID: 22, type: dataType_1.default.SINGLE_PREC },
            objectId: { ID: 75, type: dataType_1.default.BAC_OID },
            objectName: { ID: 77, type: dataType_1.default.CHAR_STR },
            objectType: { ID: 79, type: dataType_1.default.ENUM16 },
            profileName: { ID: 168, type: dataType_1.default.CHAR_STR },
        },
        commands: {},
        commandsResponse: {},
    },
    piAnalogValueExt: {
        ID: 1543,
        attributes: {
            ackedTransitions: { ID: 0, type: dataType_1.default.BITMAP8 },
            notificationClass: { ID: 17, type: dataType_1.default.UINT16 },
            deadband: { ID: 25, type: dataType_1.default.SINGLE_PREC },
            eventEnable: { ID: 35, type: dataType_1.default.BITMAP8 },
            eventState: { ID: 36, type: dataType_1.default.ENUM8 },
            highLimit: { ID: 45, type: dataType_1.default.SINGLE_PREC },
            limitEnable: { ID: 52, type: dataType_1.default.BITMAP8 },
            lowLimit: { ID: 59, type: dataType_1.default.SINGLE_PREC },
            notifyType: { ID: 72, type: dataType_1.default.ENUM8 },
            timeDelay: { ID: 113, type: dataType_1.default.UINT8 },
            eventTimeStamps: { ID: 130, type: dataType_1.default.ARRAY },
        },
        commands: {},
        commandsResponse: {},
    },
    piBinaryInputReg: {
        ID: 1544,
        attributes: {
            changeOfStateCount: { ID: 15, type: dataType_1.default.UINT32 },
            changeOfStateTime: { ID: 16, type: dataType_1.default.STRUCT },
            deviceType: { ID: 31, type: dataType_1.default.CHAR_STR },
            elapsedActiveTime: { ID: 33, type: dataType_1.default.UINT32 },
            objectIdentifier: { ID: 75, type: dataType_1.default.BAC_OID },
            objectName: { ID: 77, type: dataType_1.default.CHAR_STR },
            objectType: { ID: 79, type: dataType_1.default.ENUM16 },
            timeOfATReset: { ID: 114, type: dataType_1.default.STRUCT },
            timeOfSCReset: { ID: 115, type: dataType_1.default.STRUCT },
            profileName: { ID: 168, type: dataType_1.default.CHAR_STR },
        },
        commands: {},
        commandsResponse: {},
    },
    piBinaryInputExt: {
        ID: 1545,
        attributes: {
            ackedTransitions: { ID: 0, type: dataType_1.default.BITMAP8 },
            alarmValue: { ID: 6, type: dataType_1.default.BOOLEAN },
            notificationClass: { ID: 17, type: dataType_1.default.UINT16 },
            eventEnable: { ID: 35, type: dataType_1.default.BITMAP8 },
            eventState: { ID: 36, type: dataType_1.default.ENUM8 },
            notifyType: { ID: 72, type: dataType_1.default.ENUM8 },
            timeDelay: { ID: 113, type: dataType_1.default.UINT8 },
            eventTimeStamps: { ID: 130, type: dataType_1.default.ARRAY },
        },
        commands: {},
        commandsResponse: {},
    },
    piBinaryOutputReg: {
        ID: 1546,
        attributes: {
            changeOfStateCount: { ID: 15, type: dataType_1.default.UINT32 },
            changeOfStateTime: { ID: 16, type: dataType_1.default.STRUCT },
            deviceType: { ID: 31, type: dataType_1.default.CHAR_STR },
            elapsedActiveTime: { ID: 33, type: dataType_1.default.UINT32 },
            feedBackValue: { ID: 40, type: dataType_1.default.ENUM8 },
            objectIdentifier: { ID: 75, type: dataType_1.default.BAC_OID },
            objectName: { ID: 77, type: dataType_1.default.CHAR_STR },
            objectType: { ID: 79, type: dataType_1.default.ENUM16 },
            timeOfATReset: { ID: 114, type: dataType_1.default.STRUCT },
            timeOfSCReset: { ID: 115, type: dataType_1.default.STRUCT },
            profileName: { ID: 168, type: dataType_1.default.CHAR_STR },
        },
        commands: {},
        commandsResponse: {},
    },
    piBinaryOutputExt: {
        ID: 1547,
        attributes: {
            ackedTransitions: { ID: 0, type: dataType_1.default.BITMAP8 },
            notificationClass: { ID: 17, type: dataType_1.default.UINT16 },
            eventEnable: { ID: 35, type: dataType_1.default.BITMAP8 },
            eventState: { ID: 36, type: dataType_1.default.ENUM8 },
            notifyType: { ID: 72, type: dataType_1.default.ENUM8 },
            timeDelay: { ID: 113, type: dataType_1.default.UINT8 },
            eventTimeStamps: { ID: 130, type: dataType_1.default.ARRAY },
        },
        commands: {},
        commandsResponse: {},
    },
    piBinaryValueReg: {
        ID: 1548,
        attributes: {
            changeOfStateCount: { ID: 15, type: dataType_1.default.UINT32 },
            changeOfStateTime: { ID: 16, type: dataType_1.default.STRUCT },
            elapsedActiveTime: { ID: 33, type: dataType_1.default.UINT32 },
            objectIdentifier: { ID: 75, type: dataType_1.default.BAC_OID },
            objectName: { ID: 77, type: dataType_1.default.CHAR_STR },
            objectType: { ID: 79, type: dataType_1.default.ENUM16 },
            timeOfATReset: { ID: 114, type: dataType_1.default.STRUCT },
            timeOfSCReset: { ID: 115, type: dataType_1.default.STRUCT },
            profileName: { ID: 168, type: dataType_1.default.CHAR_STR },
        },
        commands: {},
        commandsResponse: {},
    },
    piBinaryValueExt: {
        ID: 1549,
        attributes: {
            ackedTransitions: { ID: 0, type: dataType_1.default.BITMAP8 },
            alarmValue: { ID: 6, type: dataType_1.default.BOOLEAN },
            notificationClass: { ID: 17, type: dataType_1.default.UINT16 },
            eventEnable: { ID: 35, type: dataType_1.default.BITMAP8 },
            eventState: { ID: 36, type: dataType_1.default.ENUM8 },
            notifyType: { ID: 72, type: dataType_1.default.ENUM8 },
            timeDelay: { ID: 113, type: dataType_1.default.UINT8 },
            eventTimeStamps: { ID: 130, type: dataType_1.default.ARRAY },
        },
        commands: {},
        commandsResponse: {},
    },
    piMultistateInputReg: {
        ID: 1550,
        attributes: {
            deviceType: { ID: 31, type: dataType_1.default.CHAR_STR },
            objectId: { ID: 75, type: dataType_1.default.BAC_OID },
            objectName: { ID: 77, type: dataType_1.default.CHAR_STR },
            objectType: { ID: 79, type: dataType_1.default.ENUM16 },
            profileName: { ID: 168, type: dataType_1.default.CHAR_STR },
        },
        commands: {},
        commandsResponse: {},
    },
    piMultistateInputExt: {
        ID: 1551,
        attributes: {
            ackedTransitions: { ID: 0, type: dataType_1.default.BITMAP8 },
            alarmValue: { ID: 6, type: dataType_1.default.UINT16 },
            notificationClass: { ID: 17, type: dataType_1.default.UINT16 },
            eventEnable: { ID: 35, type: dataType_1.default.BITMAP8 },
            eventState: { ID: 36, type: dataType_1.default.ENUM8 },
            faultValues: { ID: 37, type: dataType_1.default.UINT16 },
            notifyType: { ID: 72, type: dataType_1.default.ENUM8 },
            timeDelay: { ID: 113, type: dataType_1.default.UINT8 },
            eventTimeStamps: { ID: 130, type: dataType_1.default.ARRAY },
        },
        commands: {},
        commandsResponse: {},
    },
    piMultistateOutputReg: {
        ID: 1552,
        attributes: {
            deviceType: { ID: 31, type: dataType_1.default.CHAR_STR },
            feedBackValue: { ID: 40, type: dataType_1.default.ENUM8 },
            objectId: { ID: 75, type: dataType_1.default.BAC_OID },
            objectName: { ID: 77, type: dataType_1.default.CHAR_STR },
            objectType: { ID: 79, type: dataType_1.default.ENUM16 },
            profileName: { ID: 168, type: dataType_1.default.CHAR_STR },
        },
        commands: {},
        commandsResponse: {},
    },
    piMultistateOutputExt: {
        ID: 1553,
        attributes: {
            ackedTransitions: { ID: 0, type: dataType_1.default.BITMAP8 },
            notificationClass: { ID: 17, type: dataType_1.default.UINT16 },
            eventEnable: { ID: 35, type: dataType_1.default.BITMAP8 },
            eventState: { ID: 36, type: dataType_1.default.ENUM8 },
            notifyType: { ID: 72, type: dataType_1.default.ENUM8 },
            timeDelay: { ID: 113, type: dataType_1.default.UINT8 },
            eventTimeStamps: { ID: 130, type: dataType_1.default.ARRAY },
        },
        commands: {},
        commandsResponse: {},
    },
    piMultistateValueReg: {
        ID: 1554,
        attributes: {
            objectId: { ID: 75, type: dataType_1.default.BAC_OID },
            objectName: { ID: 77, type: dataType_1.default.CHAR_STR },
            objectType: { ID: 79, type: dataType_1.default.ENUM16 },
            profileName: { ID: 168, type: dataType_1.default.CHAR_STR },
        },
        commands: {},
        commandsResponse: {},
    },
    piMultistateValueExt: {
        ID: 1555,
        attributes: {
            ackedTransitions: { ID: 0, type: dataType_1.default.BITMAP8 },
            alarmValue: { ID: 6, type: dataType_1.default.UINT16 },
            notificationClass: { ID: 17, type: dataType_1.default.UINT16 },
            eventEnable: { ID: 35, type: dataType_1.default.BITMAP8 },
            eventState: { ID: 36, type: dataType_1.default.ENUM8 },
            faultValues: { ID: 37, type: dataType_1.default.UINT16 },
            notifyType: { ID: 72, type: dataType_1.default.ENUM8 },
            timeDelay: { ID: 113, type: dataType_1.default.UINT8 },
            eventTimeStamps: { ID: 130, type: dataType_1.default.ARRAY },
        },
        commands: {},
        commandsResponse: {},
    },
    pi11073ProtocolTunnel: {
        ID: 1556,
        attributes: {
            deviceidList: { ID: 0, type: dataType_1.default.ARRAY },
            managerTarget: { ID: 1, type: dataType_1.default.IEEE_ADDR },
            managerEndpoint: { ID: 2, type: dataType_1.default.UINT8 },
            connected: { ID: 3, type: dataType_1.default.BOOLEAN },
            preemptible: { ID: 4, type: dataType_1.default.BOOLEAN },
            idleTimeout: { ID: 5, type: dataType_1.default.UINT16 },
        },
        commands: {
            transferApdu: {
                ID: 0,
                parameters: [],
            },
            connectReq: {
                ID: 1,
                parameters: [],
            },
            disconnectReq: {
                ID: 2,
                parameters: [],
            },
            connectStatusNoti: {
                ID: 3,
                parameters: [],
            },
        },
        commandsResponse: {},
    },
    piIso7818ProtocolTunnel: {
        ID: 1557,
        attributes: {
            status: { ID: 0, type: dataType_1.default.UINT8 },
        },
        commands: {},
        commandsResponse: {},
    },
    piRetailTunnel: {
        ID: 1559,
        attributes: {
            manufacturerCode: { ID: 0, type: dataType_1.default.UINT16 },
            msProfile: { ID: 1, type: dataType_1.default.UINT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    seMetering: {
        ID: 1794,
        attributes: {
            currentSummDelivered: { ID: 0, type: dataType_1.default.UINT48 },
            currentSummReceived: { ID: 1, type: dataType_1.default.UINT48 },
            currentMaxDemandDelivered: { ID: 2, type: dataType_1.default.UINT48 },
            currentMaxDemandReceived: { ID: 3, type: dataType_1.default.UINT48 },
            dftSumm: { ID: 4, type: dataType_1.default.UINT48 },
            dailyFreezeTime: { ID: 5, type: dataType_1.default.UINT16 },
            powerFactor: { ID: 6, type: dataType_1.default.INT8 },
            readingSnapshotTime: { ID: 7, type: dataType_1.default.UTC },
            currentMaxDemandDeliverdTime: { ID: 8, type: dataType_1.default.UTC },
            currentMaxDemandReceivedTime: { ID: 9, type: dataType_1.default.UTC },
            defaultUpdatePeriod: { ID: 10, type: dataType_1.default.UINT8 },
            fastPollUpdatePeriod: { ID: 11, type: dataType_1.default.UINT8 },
            currentBlockPeriodConsumpDelivered: { ID: 12, type: dataType_1.default.UINT48 },
            dailyConsumpTarget: { ID: 13, type: dataType_1.default.UINT24 },
            currentBlock: { ID: 14, type: dataType_1.default.ENUM8 },
            profileIntervalPeriod: { ID: 15, type: dataType_1.default.ENUM8 },
            intervalReadReportingPeriod: { ID: 16, type: dataType_1.default.UINT16 },
            presetReadingTime: { ID: 17, type: dataType_1.default.UINT16 },
            volumePerReport: { ID: 18, type: dataType_1.default.UINT16 },
            flowRestriction: { ID: 19, type: dataType_1.default.UINT8 },
            supplyStatus: { ID: 20, type: dataType_1.default.ENUM8 },
            currentInEnergyCarrierSumm: { ID: 21, type: dataType_1.default.UINT48 },
            currentOutEnergyCarrierSumm: { ID: 22, type: dataType_1.default.UINT48 },
            inletTempreature: { ID: 23, type: dataType_1.default.INT24 },
            outletTempreature: { ID: 24, type: dataType_1.default.INT24 },
            controlTempreature: { ID: 25, type: dataType_1.default.INT24 },
            currentInEnergyCarrierDemand: { ID: 26, type: dataType_1.default.INT24 },
            currentOutEnergyCarrierDemand: { ID: 27, type: dataType_1.default.INT24 },
            currentBlockPeriodConsumpReceived: { ID: 29, type: dataType_1.default.UINT48 },
            currentBlockReceived: { ID: 30, type: dataType_1.default.UINT48 },
            DFTSummationReceived: { ID: 31, type: dataType_1.default.UINT48 },
            activeRegisterTierDelivered: { ID: 32, type: dataType_1.default.ENUM8 },
            activeRegisterTierReceived: { ID: 33, type: dataType_1.default.ENUM8 },
            currentTier1SummDelivered: { ID: 256, type: dataType_1.default.UINT48 },
            currentTier1SummReceived: { ID: 257, type: dataType_1.default.UINT48 },
            currentTier2SummDelivered: { ID: 258, type: dataType_1.default.UINT48 },
            currentTier2SummReceived: { ID: 259, type: dataType_1.default.UINT48 },
            currentTier3SummDelivered: { ID: 260, type: dataType_1.default.UINT48 },
            currentTier3SummReceived: { ID: 261, type: dataType_1.default.UINT48 },
            currentTier4SummDelivered: { ID: 262, type: dataType_1.default.UINT48 },
            currentTier4SummReceived: { ID: 263, type: dataType_1.default.UINT48 },
            currentTier5SummDelivered: { ID: 264, type: dataType_1.default.UINT48 },
            currentTier5SummReceived: { ID: 265, type: dataType_1.default.UINT48 },
            currentTier6SummDelivered: { ID: 266, type: dataType_1.default.UINT48 },
            currentTier6SummReceived: { ID: 267, type: dataType_1.default.UINT48 },
            currentTier7SummDelivered: { ID: 268, type: dataType_1.default.UINT48 },
            currentTier7SummReceived: { ID: 269, type: dataType_1.default.UINT48 },
            currentTier8SummDelivered: { ID: 270, type: dataType_1.default.UINT48 },
            currentTier8SummReceived: { ID: 271, type: dataType_1.default.UINT48 },
            currentTier9SummDelivered: { ID: 272, type: dataType_1.default.UINT48 },
            currentTier9SummReceived: { ID: 273, type: dataType_1.default.UINT48 },
            currentTier10SummDelivered: { ID: 274, type: dataType_1.default.UINT48 },
            currentTier10SummReceived: { ID: 275, type: dataType_1.default.UINT48 },
            currentTier11SummDelivered: { ID: 276, type: dataType_1.default.UINT48 },
            currentTier11SummReceived: { ID: 277, type: dataType_1.default.UINT48 },
            currentTier12SummDelivered: { ID: 278, type: dataType_1.default.UINT48 },
            currentTier12SummReceived: { ID: 279, type: dataType_1.default.UINT48 },
            currentTier13SummDelivered: { ID: 280, type: dataType_1.default.UINT48 },
            currentTier13SummReceived: { ID: 281, type: dataType_1.default.UINT48 },
            currentTier14SummDelivered: { ID: 282, type: dataType_1.default.UINT48 },
            currentTier14SummReceived: { ID: 283, type: dataType_1.default.UINT48 },
            currentTier15SummDelivered: { ID: 284, type: dataType_1.default.UINT48 },
            currentTier15SummReceived: { ID: 285, type: dataType_1.default.UINT48 },
            status: { ID: 512, type: dataType_1.default.BITMAP8 },
            remainingBattLife: { ID: 513, type: dataType_1.default.UINT8 },
            hoursInOperation: { ID: 514, type: dataType_1.default.UINT24 },
            hoursInFault: { ID: 515, type: dataType_1.default.UINT24 },
            extendedStatus: { ID: 516, type: dataType_1.default.BITMAP64 },
            unitOfMeasure: { ID: 768, type: dataType_1.default.ENUM8 },
            multiplier: { ID: 769, type: dataType_1.default.UINT24 },
            divisor: { ID: 770, type: dataType_1.default.UINT24 },
            summaFormatting: { ID: 771, type: dataType_1.default.BITMAP8 },
            demandFormatting: { ID: 772, type: dataType_1.default.BITMAP8 },
            historicalConsumpFormatting: { ID: 773, type: dataType_1.default.BITMAP8 },
            meteringDeviceType: { ID: 774, type: dataType_1.default.BITMAP8 },
            siteId: { ID: 775, type: dataType_1.default.OCTET_STR },
            meterSerialNumber: { ID: 776, type: dataType_1.default.OCTET_STR },
            energyCarrierUnitOfMeas: { ID: 777, type: dataType_1.default.ENUM8 },
            energyCarrierSummFormatting: { ID: 778, type: dataType_1.default.BITMAP8 },
            energyCarrierDemandFormatting: { ID: 779, type: dataType_1.default.BITMAP8 },
            temperatureUnitOfMeas: { ID: 780, type: dataType_1.default.ENUM8 },
            temperatureFormatting: { ID: 781, type: dataType_1.default.BITMAP8 },
            moduleSerialNumber: { ID: 782, type: dataType_1.default.OCTET_STR },
            operatingTariffLevel: { ID: 783, type: dataType_1.default.OCTET_STR },
            instantaneousDemand: { ID: 1024, type: dataType_1.default.INT24 },
            currentdayConsumpDelivered: { ID: 1025, type: dataType_1.default.UINT24 },
            currentdayConsumpReceived: { ID: 1026, type: dataType_1.default.UINT24 },
            previousdayConsumpDelivered: { ID: 1027, type: dataType_1.default.UINT24 },
            previousdayConsumpReceived: { ID: 1028, type: dataType_1.default.UINT24 },
            curPartProfileIntStartTimeDelivered: { ID: 1029, type: dataType_1.default.UTC },
            curPartProfileIntStartTimeReceived: { ID: 1030, type: dataType_1.default.UTC },
            curPartProfileIntValueDelivered: { ID: 1031, type: dataType_1.default.UINT24 },
            curPartProfileIntValueReceived: { ID: 1032, type: dataType_1.default.UINT24 },
            currentDayMaxPressure: { ID: 1033, type: dataType_1.default.UINT48 },
            currentDayMinPressure: { ID: 1034, type: dataType_1.default.UINT48 },
            previousDayMaxPressure: { ID: 1035, type: dataType_1.default.UINT48 },
            previousDayMinPressure: { ID: 1036, type: dataType_1.default.UINT48 },
            currentDayMaxDemand: { ID: 1037, type: dataType_1.default.INT24 },
            previousDayMaxDemand: { ID: 1038, type: dataType_1.default.INT24 },
            currentMonthMaxDemand: { ID: 1039, type: dataType_1.default.INT24 },
            currentYearMaxDemand: { ID: 1040, type: dataType_1.default.INT24 },
            currentdayMaxEnergyCarrDemand: { ID: 1041, type: dataType_1.default.INT24 },
            previousdayMaxEnergyCarrDemand: { ID: 1042, type: dataType_1.default.INT24 },
            curMonthMaxEnergyCarrDemand: { ID: 1043, type: dataType_1.default.INT24 },
            curMonthMinEnergyCarrDemand: { ID: 1044, type: dataType_1.default.INT24 },
            curYearMaxEnergyCarrDemand: { ID: 1045, type: dataType_1.default.INT24 },
            curYearMinEnergyCarrDemand: { ID: 1046, type: dataType_1.default.INT24 },
            maxNumberOfPeriodsDelivered: { ID: 1280, type: dataType_1.default.UINT8 },
            currentDemandDelivered: { ID: 1536, type: dataType_1.default.UINT24 },
            demandLimit: { ID: 1537, type: dataType_1.default.UINT24 },
            demandIntegrationPeriod: { ID: 1538, type: dataType_1.default.UINT8 },
            numberOfDemandSubintervals: { ID: 1539, type: dataType_1.default.UINT8 },
            demandLimitArmDuration: { ID: 1540, type: dataType_1.default.UINT16 },
            genericAlarmMask: { ID: 2048, type: dataType_1.default.BITMAP16 },
            electricityAlarmMask: { ID: 2049, type: dataType_1.default.BITMAP32 },
            genFlowPressureAlarmMask: { ID: 2050, type: dataType_1.default.BITMAP16 },
            waterSpecificAlarmMask: { ID: 2051, type: dataType_1.default.BITMAP16 },
            heatCoolSpecificAlarmMASK: { ID: 2052, type: dataType_1.default.BITMAP16 },
            gasSpecificAlarmMask: { ID: 2053, type: dataType_1.default.BITMAP16 },
            extendedGenericAlarmMask: { ID: 2054, type: dataType_1.default.BITMAP48 },
            manufactureAlarmMask: { ID: 2055, type: dataType_1.default.BITMAP16 },
            billToDate: { ID: 2560, type: dataType_1.default.UINT32 },
            billToDateTimeStamp: { ID: 2561, type: dataType_1.default.UTC },
            projectedBill: { ID: 2562, type: dataType_1.default.UINT32 },
            projectedBillTimeStamp: { ID: 2563, type: dataType_1.default.UTC },
            notificationControlFlags: { ID: 0, type: dataType_1.default.BITMAP32 },
            notificationFlags: { ID: 1, type: dataType_1.default.BITMAP32 },
            priceNotificationFlags: { ID: 2, type: dataType_1.default.BITMAP32 },
            calendarNotificationFlags: { ID: 3, type: dataType_1.default.BITMAP32 },
            prePayNotificationFlags: { ID: 4, type: dataType_1.default.BITMAP32 },
            deviceManagementFlags: { ID: 5, type: dataType_1.default.BITMAP32 },
            changeReportingProfile: { ID: 256, type: dataType_1.default.UNKNOWN },
            develcoPulseConfiguration: { ID: 0x0300, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.DEVELCO },
            develcoCurrentSummation: { ID: 0x0301, type: dataType_1.default.UINT48, manufacturerCode: manufacturerCode_1.default.DEVELCO },
            develcoInterfaceMode: { ID: 0x0302, type: dataType_1.default.ENUM16, manufacturerCode: manufacturerCode_1.default.DEVELCO },
            owonL1PhasePower: { ID: 0x2000, type: dataType_1.default.INT24, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL2PhasePower: { ID: 0x2001, type: dataType_1.default.INT24, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL3PhasePower: { ID: 0x2002, type: dataType_1.default.INT24, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL1PhaseReactivePower: { ID: 0x2100, type: dataType_1.default.INT24, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL2PhaseReactivePower: { ID: 0x2101, type: dataType_1.default.INT24, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL3PhaseReactivePower: { ID: 0x2102, type: dataType_1.default.INT24, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonReactivePowerSum: { ID: 0x2103, type: dataType_1.default.INT24, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL1PhaseVoltage: { ID: 0x3000, type: dataType_1.default.UINT24, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL2PhaseVoltage: { ID: 0x3001, type: dataType_1.default.UINT24, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL3PhaseVoltage: { ID: 0x3002, type: dataType_1.default.UINT24, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL1PhaseCurrent: { ID: 0x3100, type: dataType_1.default.UINT24, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL2PhaseCurrent: { ID: 0x3101, type: dataType_1.default.UINT24, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL3PhaseCurrent: { ID: 0x3102, type: dataType_1.default.UINT24, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonCurrentSum: { ID: 0x3103, type: dataType_1.default.UINT24, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonLeakageCurrent: { ID: 0x3104, type: dataType_1.default.UINT24, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL1Energy: { ID: 0x4000, type: dataType_1.default.UINT48, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL2Energy: { ID: 0x4001, type: dataType_1.default.UINT48, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL3Energy: { ID: 0x4002, type: dataType_1.default.UINT48, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL1ReactiveEnergy: { ID: 0x4100, type: dataType_1.default.UINT48, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL2ReactiveEnergy: { ID: 0x4101, type: dataType_1.default.UINT48, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL3ReactiveEnergy: { ID: 0x4102, type: dataType_1.default.UINT48, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonReactiveEnergySum: { ID: 0x4103, type: dataType_1.default.UINT48, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL1PowerFactor: { ID: 0x4104, type: dataType_1.default.INT8, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL2PowerFactor: { ID: 0x4105, type: dataType_1.default.INT8, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonL3PowerFactor: { ID: 0x4106, type: dataType_1.default.INT8, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonFrequency: { ID: 0x5005, type: dataType_1.default.UINT8, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonReportMap: { ID: 0x1000, type: dataType_1.default.BITMAP8, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonLastHistoricalRecordTime: { ID: 0x5000, type: dataType_1.default.UINT32, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonOldestHistoricalRecordTime: { ID: 0x5001, type: dataType_1.default.UINT32, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonMinimumReportCycle: { ID: 0x5002, type: dataType_1.default.UINT32, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonMaximumReportCycle: { ID: 0x5003, type: dataType_1.default.UINT32, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonSentHistoricalRecordState: { ID: 0x5004, type: dataType_1.default.UINT8, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonAccumulativeEnergyThreshold: { ID: 0x5006, type: dataType_1.default.UINT8, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonReportMode: { ID: 0x5007, type: dataType_1.default.UINT8, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            owonPercentChangeInPower: { ID: 0x5007, type: dataType_1.default.UINT8, manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC },
            schneiderActiveEnergyTotal: { ID: 0x4010, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderReactiveEnergyTotal: { ID: 0x4011, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderApparentEnergyTotal: { ID: 0x4012, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderPartialActiveEnergyTotal: { ID: 0x4014, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderPartialReactiveEnergyTotal: { ID: 0x4015, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderPartialApparentEnergyTotal: { ID: 0x4016, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderPartialActiveEnergyL1Phase: { ID: 0x4100, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderPartialReactiveEnergyL1Phase: { ID: 0x4101, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderPartialApparentEnergyL1Phase: { ID: 0x4102, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderActiveEnergyL1Phase: { ID: 0x4103, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderReactiveEnergyL1Phase: { ID: 0x4104, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderApparentEnergyL1Phase: { ID: 0x4105, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderPartialActiveEnergyL2Phase: { ID: 0x4200, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderPartialReactiveEnergyL2Phase: { ID: 0x4201, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderPartialApparentEnergyL2Phase: { ID: 0x4202, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderActiveEnergyL2Phase: { ID: 0x4203, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderReactiveEnergyL2Phase: { ID: 0x4204, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderApparentEnergyL2Phase: { ID: 0x4205, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderPartialActiveEnergyL3Phase: { ID: 0x4300, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderPartialReactiveEnergyL3Phase: { ID: 0x4301, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderPartialApparentEnergyL3Phase: { ID: 0x4302, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderActiveEnergyL3Phase: { ID: 0x4303, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderReactiveEnergyL3Phase: { ID: 0x4304, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderApparentEnergyL3Phase: { ID: 0x4305, type: dataType_1.default.INT48, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderActiveEnergyMultiplier: { ID: 0x4400, type: dataType_1.default.UINT24, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderActiveEnergyDivisor: { ID: 0x4401, type: dataType_1.default.UINT24, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderReactiveEnergyMultiplier: { ID: 0x4402, type: dataType_1.default.UINT24, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderReactiveEnergyDivisor: { ID: 0x4403, type: dataType_1.default.UINT24, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderApparentEnergyMultiplier: { ID: 0x4404, type: dataType_1.default.UINT24, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderApparentEnergyDivisor: { ID: 0x4405, type: dataType_1.default.UINT24, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderEnergyResetDateTime: { ID: 0x4501, type: dataType_1.default.UTC, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderEnergyCountersReportingPeriod: { ID: 0x4600, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
        },
        commands: {
            getProfile: {
                ID: 0,
                parameters: [],
            },
            reqMirror: {
                ID: 1,
                parameters: [],
            },
            mirrorRem: {
                ID: 2,
                parameters: [],
            },
            reqFastPollMode: {
                ID: 3,
                parameters: [],
            },
            getSnapshot: {
                ID: 4,
                parameters: [],
            },
            takeSnapshot: {
                ID: 5,
                parameters: [],
            },
            mirrorReportAttrRsp: {
                ID: 6,
                parameters: [],
            },
            owonGetHistoryRecord: {
                ID: 0x20,
                parameters: [],
            },
            owonStopSendingHistoricalRecord: {
                ID: 0x21,
                parameters: [],
            },
        },
        commandsResponse: {
            getProfileRsp: {
                ID: 0,
                parameters: [],
            },
            reqMirrorRsp: {
                ID: 1,
                parameters: [],
            },
            mirrorRemRsp: {
                ID: 2,
                parameters: [],
            },
            reqFastPollModeRsp: {
                ID: 3,
                parameters: [],
            },
            getSnapshotRsp: {
                ID: 4,
                parameters: [],
            },
            owonGetHistoryRecordRsp: {
                ID: 0x20,
                parameters: [],
            },
        },
    },
    tunneling: {
        ID: 0x0704,
        attributes: {},
        commands: {
            transferData: {
                ID: 2,
                parameters: [
                    { name: 'tunnelID', type: dataType_1.default.UINT16 },
                    { name: 'data', type: buffaloZclDataType_1.default.BUFFER },
                ],
            },
        },
        commandsResponse: {
            transferDataResp: {
                ID: 1,
                parameters: [
                    { name: 'tunnelID', type: dataType_1.default.UINT16 },
                    { name: 'data', type: buffaloZclDataType_1.default.BUFFER },
                ],
            },
        },
    },
    telecommunicationsInformation: {
        ID: 2304,
        attributes: {
            nodeDescription: { ID: 0, type: dataType_1.default.CHAR_STR },
            deliveryEnable: { ID: 1, type: dataType_1.default.BOOLEAN },
            pushInformationTimer: { ID: 2, type: dataType_1.default.UINT32 },
            enableSecureConfiguration: { ID: 3, type: dataType_1.default.BOOLEAN },
            numberOfContents: { ID: 16, type: dataType_1.default.UINT16 },
            contentRootID: { ID: 17, type: dataType_1.default.UINT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    telecommunicationsVoiceOverZigbee: {
        ID: 2308,
        attributes: {
            codecType: { ID: 0, type: dataType_1.default.ENUM8 },
            samplingFrequency: { ID: 1, type: dataType_1.default.ENUM8 },
            codecrate: { ID: 2, type: dataType_1.default.ENUM8 },
            establishmentTimeout: { ID: 3, type: dataType_1.default.UINT8 },
            codecTypeSub1: { ID: 4, type: dataType_1.default.ENUM8 },
            codecTypeSub2: { ID: 5, type: dataType_1.default.ENUM8 },
            codecTypeSub3: { ID: 6, type: dataType_1.default.ENUM8 },
            compressionType: { ID: 7, type: dataType_1.default.ENUM8 },
            compressionRate: { ID: 8, type: dataType_1.default.ENUM8 },
            optionFlags: { ID: 9, type: dataType_1.default.BITMAP8 },
            threshold: { ID: 10, type: dataType_1.default.UINT8 },
        },
        commands: {},
        commandsResponse: {},
    },
    telecommunicationsChatting: {
        ID: 2309,
        attributes: {
            uID: { ID: 0, type: dataType_1.default.UINT16 },
            nickname: { ID: 1, type: dataType_1.default.CHAR_STR },
            cID: { ID: 16, type: dataType_1.default.UINT16 },
            name: { ID: 17, type: dataType_1.default.CHAR_STR },
            enableAddChat: { ID: 18, type: dataType_1.default.BOOLEAN },
        },
        commands: {},
        commandsResponse: {},
    },
    haApplianceIdentification: {
        ID: 2816,
        attributes: {
            basicIdentification: { ID: 0, type: dataType_1.default.UINT56 },
            companyName: { ID: 16, type: dataType_1.default.CHAR_STR },
            companyId: { ID: 17, type: dataType_1.default.UINT16 },
            brandName: { ID: 18, type: dataType_1.default.CHAR_STR },
            brandId: { ID: 19, type: dataType_1.default.UINT16 },
            model: { ID: 20, type: dataType_1.default.OCTET_STR },
            partNumber: { ID: 21, type: dataType_1.default.OCTET_STR },
            productRevision: { ID: 22, type: dataType_1.default.OCTET_STR },
            softwareRevision: { ID: 23, type: dataType_1.default.OCTET_STR },
            productTypeName: { ID: 24, type: dataType_1.default.OCTET_STR },
            productTypeId: { ID: 25, type: dataType_1.default.UINT16 },
            cecedSpecificationVersion: { ID: 26, type: dataType_1.default.UINT8 },
        },
        commands: {},
        commandsResponse: {},
    },
    haMeterIdentification: {
        ID: 2817,
        attributes: {
            companyName: { ID: 0, type: dataType_1.default.CHAR_STR },
            meterTypeId: { ID: 1, type: dataType_1.default.UINT16 },
            dataQualityId: { ID: 4, type: dataType_1.default.UINT16 },
            customerName: { ID: 5, type: dataType_1.default.CHAR_STR },
            model: { ID: 6, type: dataType_1.default.CHAR_STR },
            partNumber: { ID: 7, type: dataType_1.default.CHAR_STR },
            productRevision: { ID: 8, type: dataType_1.default.CHAR_STR },
            softwareRevision: { ID: 10, type: dataType_1.default.CHAR_STR },
            utilityName: { ID: 11, type: dataType_1.default.CHAR_STR },
            pod: { ID: 12, type: dataType_1.default.CHAR_STR },
            availablePower: { ID: 13, type: dataType_1.default.INT24 },
            powerThreshold: { ID: 14, type: dataType_1.default.INT24 },
        },
        commands: {},
        commandsResponse: {},
    },
    haApplianceEventsAlerts: {
        ID: 2818,
        attributes: {},
        commands: {
            getAlerts: {
                ID: 0,
                parameters: [],
            },
        },
        commandsResponse: {
            getAlertsRsp: {
                ID: 0,
                parameters: [
                    { name: 'alertscount', type: dataType_1.default.UINT8 },
                    { name: 'aalert', type: buffaloZclDataType_1.default.LIST_UINT24 },
                ],
            },
            alertsNotification: {
                ID: 1,
                parameters: [
                    { name: 'alertscount', type: dataType_1.default.UINT8 },
                    { name: 'aalert', type: buffaloZclDataType_1.default.LIST_UINT24 },
                ],
            },
            eventNotification: {
                ID: 2,
                parameters: [
                    { name: 'eventheader', type: dataType_1.default.UINT8 },
                    { name: 'eventid', type: dataType_1.default.UINT8 },
                ],
            },
        },
    },
    haApplianceStatistics: {
        ID: 2819,
        attributes: {
            logMaxSize: { ID: 0, type: dataType_1.default.UINT32 },
            logQueueMaxSize: { ID: 1, type: dataType_1.default.UINT8 },
        },
        commands: {
            log: {
                ID: 0,
                parameters: [
                    { name: 'logid', type: dataType_1.default.UINT32 },
                ],
            },
            logQueue: {
                ID: 1,
                parameters: [],
            },
        },
        commandsResponse: {
            logNotification: {
                ID: 0,
                parameters: [
                    { name: 'timestamp', type: dataType_1.default.UINT32 },
                    { name: 'logid', type: dataType_1.default.UINT32 },
                    { name: 'loglength', type: dataType_1.default.UINT32 },
                    { name: 'logpayload', type: buffaloZclDataType_1.default.LIST_UINT8 },
                ],
            },
            logRsp: {
                ID: 1,
                parameters: [
                    { name: 'timestamp', type: dataType_1.default.UINT32 },
                    { name: 'logid', type: dataType_1.default.UINT32 },
                    { name: 'loglength', type: dataType_1.default.UINT32 },
                    { name: 'logpayload', type: buffaloZclDataType_1.default.LIST_UINT8 },
                ],
            },
            logQueueRsp: {
                ID: 2,
                parameters: [
                    { name: 'logqueuesize', type: dataType_1.default.UINT8 },
                    { name: 'logid', type: buffaloZclDataType_1.default.LIST_UINT32 },
                ],
            },
            statisticsAvailable: {
                ID: 3,
                parameters: [
                    { name: 'logqueuesize', type: dataType_1.default.UINT8 },
                    { name: 'logid', type: buffaloZclDataType_1.default.LIST_UINT32 },
                ],
            },
        },
    },
    haElectricalMeasurement: {
        ID: 2820,
        attributes: {
            measurementType: { ID: 0, type: dataType_1.default.BITMAP32 },
            dcVoltage: { ID: 256, type: dataType_1.default.INT16 },
            dcVoltageMin: { ID: 257, type: dataType_1.default.INT16 },
            dcvoltagemax: { ID: 258, type: dataType_1.default.INT16 },
            dcCurrent: { ID: 259, type: dataType_1.default.INT16 },
            dcCurrentMin: { ID: 260, type: dataType_1.default.INT16 },
            dcCurrentMax: { ID: 261, type: dataType_1.default.INT16 },
            dcPower: { ID: 262, type: dataType_1.default.INT16 },
            dcPowerMin: { ID: 263, type: dataType_1.default.INT16 },
            dcPowerMax: { ID: 264, type: dataType_1.default.INT16 },
            dcVoltageMultiplier: { ID: 512, type: dataType_1.default.UINT16 },
            dcVoltageDivisor: { ID: 513, type: dataType_1.default.UINT16 },
            dcCurrentMultiplier: { ID: 514, type: dataType_1.default.UINT16 },
            dcCurrentDivisor: { ID: 515, type: dataType_1.default.UINT16 },
            dcPowerMultiplier: { ID: 516, type: dataType_1.default.UINT16 },
            dcPowerDivisor: { ID: 517, type: dataType_1.default.UINT16 },
            acFrequency: { ID: 768, type: dataType_1.default.UINT16 },
            acFrequencyMin: { ID: 769, type: dataType_1.default.UINT16 },
            acFrequencyMax: { ID: 770, type: dataType_1.default.UINT16 },
            neutralCurrent: { ID: 771, type: dataType_1.default.UINT16 },
            totalActivePower: { ID: 772, type: dataType_1.default.INT32 },
            totalReactivePower: { ID: 773, type: dataType_1.default.INT32 },
            totalApparentPower: { ID: 774, type: dataType_1.default.UINT32 },
            meas1stHarmonicCurrent: { ID: 775, type: dataType_1.default.INT16 },
            meas3rdHarmonicCurrent: { ID: 776, type: dataType_1.default.INT16 },
            meas5thHarmonicCurrent: { ID: 777, type: dataType_1.default.INT16 },
            meas7thHarmonicCurrent: { ID: 778, type: dataType_1.default.INT16 },
            meas9thHarmonicCurrent: { ID: 779, type: dataType_1.default.INT16 },
            meas11thHarmonicCurrent: { ID: 780, type: dataType_1.default.INT16 },
            measPhase1stHarmonicCurrent: { ID: 781, type: dataType_1.default.INT16 },
            measPhase3rdHarmonicCurrent: { ID: 782, type: dataType_1.default.INT16 },
            measPhase5thHarmonicCurrent: { ID: 783, type: dataType_1.default.INT16 },
            measPhase7thHarmonicCurrent: { ID: 784, type: dataType_1.default.INT16 },
            measPhase9thHarmonicCurrent: { ID: 785, type: dataType_1.default.INT16 },
            measPhase11thHarmonicCurrent: { ID: 786, type: dataType_1.default.INT16 },
            acFrequencyMultiplier: { ID: 1024, type: dataType_1.default.UINT16 },
            acFrequencyDivisor: { ID: 1025, type: dataType_1.default.UINT16 },
            powerMultiplier: { ID: 1026, type: dataType_1.default.UINT32 },
            powerDivisor: { ID: 1027, type: dataType_1.default.UINT32 },
            harmonicCurrentMultiplier: { ID: 1028, type: dataType_1.default.INT8 },
            phaseHarmonicCurrentMultiplier: { ID: 1029, type: dataType_1.default.INT8 },
            instantaneousVoltage: { ID: 1280, type: dataType_1.default.INT16 },
            instantaneousLineCurrent: { ID: 1281, type: dataType_1.default.UINT16 },
            instantaneousActiveCurrent: { ID: 1282, type: dataType_1.default.INT16 },
            instantaneousReactiveCurrent: { ID: 1283, type: dataType_1.default.INT16 },
            instantaneousPower: { ID: 1284, type: dataType_1.default.INT16 },
            rmsVoltage: { ID: 1285, type: dataType_1.default.UINT16 },
            rmsVoltageMin: { ID: 1286, type: dataType_1.default.UINT16 },
            rmsVoltageMax: { ID: 1287, type: dataType_1.default.UINT16 },
            rmsCurrent: { ID: 1288, type: dataType_1.default.UINT16 },
            rmsCurrentMin: { ID: 1289, type: dataType_1.default.UINT16 },
            rmsCurrentMax: { ID: 1290, type: dataType_1.default.UINT16 },
            activePower: { ID: 1291, type: dataType_1.default.INT16 },
            activePowerMin: { ID: 1292, type: dataType_1.default.INT16 },
            activePowerMax: { ID: 1293, type: dataType_1.default.INT16 },
            reactivePower: { ID: 1294, type: dataType_1.default.INT16 },
            apparentPower: { ID: 1295, type: dataType_1.default.UINT16 },
            powerFactor: { ID: 1296, type: dataType_1.default.INT8 },
            averageRmsVoltageMeasPeriod: { ID: 1297, type: dataType_1.default.UINT16 },
            averageRmsOverVoltageCounter: { ID: 1298, type: dataType_1.default.UINT16 },
            averageRmsUnderVoltageCounter: { ID: 1299, type: dataType_1.default.UINT16 },
            rmsExtremeOverVoltagePeriod: { ID: 1300, type: dataType_1.default.UINT16 },
            rmsExtremeUnderVoltagePeriod: { ID: 1301, type: dataType_1.default.UINT16 },
            rmsVoltageSagPeriod: { ID: 1302, type: dataType_1.default.UINT16 },
            rmsVoltageSwellPeriod: { ID: 1303, type: dataType_1.default.UINT16 },
            acVoltageMultiplier: { ID: 1536, type: dataType_1.default.UINT16 },
            acVoltageDivisor: { ID: 1537, type: dataType_1.default.UINT16 },
            acCurrentMultiplier: { ID: 1538, type: dataType_1.default.UINT16 },
            acCurrentDivisor: { ID: 1539, type: dataType_1.default.UINT16 },
            acPowerMultiplier: { ID: 1540, type: dataType_1.default.UINT16 },
            acPowerDivisor: { ID: 1541, type: dataType_1.default.UINT16 },
            dcOverloadAlarmsMask: { ID: 1792, type: dataType_1.default.BITMAP8 },
            dcVoltageOverload: { ID: 1793, type: dataType_1.default.INT16 },
            dcCurrentOverload: { ID: 1794, type: dataType_1.default.INT16 },
            acAlarmsMask: { ID: 2048, type: dataType_1.default.BITMAP16 },
            acVoltageOverload: { ID: 2049, type: dataType_1.default.INT16 },
            acCurrentOverload: { ID: 2050, type: dataType_1.default.INT16 },
            acActivePowerOverload: { ID: 2051, type: dataType_1.default.INT16 },
            acReactivePowerOverload: { ID: 2052, type: dataType_1.default.INT16 },
            averageRmsOverVoltage: { ID: 2053, type: dataType_1.default.INT16 },
            averageRmsUnderVoltage: { ID: 2054, type: dataType_1.default.INT16 },
            rmsExtremeOverVoltage: { ID: 2055, type: dataType_1.default.INT16 },
            rmsExtremeUnderVoltage: { ID: 2056, type: dataType_1.default.INT16 },
            rmsVoltageSag: { ID: 2057, type: dataType_1.default.INT16 },
            rmsVoltageSwell: { ID: 2058, type: dataType_1.default.INT16 },
            lineCurrentPhB: { ID: 2305, type: dataType_1.default.UINT16 },
            activeCurrentPhB: { ID: 2306, type: dataType_1.default.INT16 },
            reactiveCurrentPhB: { ID: 2307, type: dataType_1.default.INT16 },
            rmsVoltagePhB: { ID: 2309, type: dataType_1.default.UINT16 },
            rmsVoltageMinPhB: { ID: 2310, type: dataType_1.default.UINT16 },
            rmsVoltageMaxPhB: { ID: 2311, type: dataType_1.default.UINT16 },
            rmsCurrentPhB: { ID: 2312, type: dataType_1.default.UINT16 },
            rmsCurrentMinPhB: { ID: 2313, type: dataType_1.default.UINT16 },
            rmsCurrentMaxPhB: { ID: 2314, type: dataType_1.default.UINT16 },
            activePowerPhB: { ID: 2315, type: dataType_1.default.INT16 },
            activePowerMinPhB: { ID: 2316, type: dataType_1.default.INT16 },
            activePowerMaxPhB: { ID: 2317, type: dataType_1.default.INT16 },
            reactivePowerPhB: { ID: 2318, type: dataType_1.default.INT16 },
            apparentPowerPhB: { ID: 2319, type: dataType_1.default.UINT16 },
            powerFactorPhB: { ID: 2320, type: dataType_1.default.INT8 },
            averageRmsVoltageMeasurePeriodPhB: { ID: 2321, type: dataType_1.default.UINT16 },
            averageRmsOverVoltageCounterPhB: { ID: 2322, type: dataType_1.default.UINT16 },
            averageUnderVoltageCounterPhB: { ID: 2323, type: dataType_1.default.UINT16 },
            rmsExtremeOverVoltagePeriodPhB: { ID: 2324, type: dataType_1.default.UINT16 },
            rmsExtremeUnderVoltagePeriodPhB: { ID: 2325, type: dataType_1.default.UINT16 },
            rmsVoltageSagPeriodPhB: { ID: 2326, type: dataType_1.default.UINT16 },
            rmsVoltageSwellPeriodPhB: { ID: 2327, type: dataType_1.default.UINT16 },
            lineCurrentPhC: { ID: 2561, type: dataType_1.default.UINT16 },
            activeCurrentPhC: { ID: 2562, type: dataType_1.default.INT16 },
            reactiveCurrentPhC: { ID: 2563, type: dataType_1.default.INT16 },
            rmsVoltagePhC: { ID: 2565, type: dataType_1.default.UINT16 },
            rmsVoltageMinPhC: { ID: 2566, type: dataType_1.default.UINT16 },
            rmsVoltageMaxPhC: { ID: 2567, type: dataType_1.default.UINT16 },
            rmsCurrentPhC: { ID: 2568, type: dataType_1.default.UINT16 },
            rmsCurrentMinPhC: { ID: 2569, type: dataType_1.default.UINT16 },
            rmsCurrentMaxPhC: { ID: 2570, type: dataType_1.default.UINT16 },
            activePowerPhC: { ID: 2571, type: dataType_1.default.INT16 },
            activePowerMinPhC: { ID: 2572, type: dataType_1.default.INT16 },
            activePowerMaxPhC: { ID: 2573, type: dataType_1.default.INT16 },
            reactivePowerPhC: { ID: 2574, type: dataType_1.default.INT16 },
            apparentPowerPhC: { ID: 2575, type: dataType_1.default.UINT16 },
            powerFactorPhC: { ID: 2576, type: dataType_1.default.INT8 },
            averageRmsVoltageMeasPeriodPhC: { ID: 2577, type: dataType_1.default.UINT16 },
            averageRmsOverVoltageCounterPhC: { ID: 2578, type: dataType_1.default.UINT16 },
            averageUnderVoltageCounterPhC: { ID: 2579, type: dataType_1.default.UINT16 },
            rmsExtremeOverVoltagePeriodPhC: { ID: 2580, type: dataType_1.default.UINT16 },
            rmsExtremeUnderVoltagePeriodPhC: { ID: 2581, type: dataType_1.default.UINT16 },
            rmsVoltageSagPeriodPhC: { ID: 2582, type: dataType_1.default.UINT16 },
            rmsVoltageSwellPeriodPhC: { ID: 2583, type: dataType_1.default.UINT16 },
            schneiderActivePowerDemandTotal: { ID: 0x4300, type: dataType_1.default.INT32, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderReactivePowerDemandTotal: { ID: 0x4303, type: dataType_1.default.INT32, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderApparentPowerDemandTotal: { ID: 0x4318, type: dataType_1.default.INT32, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderDemandIntervalDuration: { ID: 0x4319, type: dataType_1.default.UINT24, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderDemandDateTime: { ID: 0x4320, type: dataType_1.default.UTC, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderActivePowerDemandPhase1: { ID: 0x4509, type: dataType_1.default.INT32, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderReactivePowerDemandPhase1: { ID: 0x450A, type: dataType_1.default.INT32, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderApparentPowerDemandPhase1: { ID: 0x450B, type: dataType_1.default.INT32, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderDemandIntervalMinimalVoltageL1: { ID: 0x4510, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderDemandIntervalMaximalCurrentI1: { ID: 0x4513, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderActivePowerDemandPhase2: { ID: 0x4909, type: dataType_1.default.INT32, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderReactivePowerDemandPhase2: { ID: 0x490A, type: dataType_1.default.INT32, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderApparentPowerDemandPhase2: { ID: 0x490B, type: dataType_1.default.INT32, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderDemandIntervalMinimalVoltageL2: { ID: 0x4910, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderDemandIntervalMaximalCurrentI2: { ID: 0x4913, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderActivePowerDemandPhase3: { ID: 0x4A09, type: dataType_1.default.INT32, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderReactivePowerDemandPhase3: { ID: 0x4A0A, type: dataType_1.default.INT32, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderApparentPowerDemandPhase3: { ID: 0x4A0B, type: dataType_1.default.INT32, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderDemandIntervalMinimalVoltageL3: { ID: 0x4A10, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderDemandIntervalMaximalCurrentI3: { ID: 0x4A13, type: dataType_1.default.UINT16, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderCurrentSensorMultiplier: { ID: 0x4E00, type: dataType_1.default.UINT8, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
        },
        commands: {
            getProfileInfo: {
                ID: 0,
                parameters: [],
            },
            getMeasurementProfile: {
                ID: 1,
                parameters: [
                    { name: 'attrId', type: dataType_1.default.UINT16 },
                    { name: 'starttime', type: dataType_1.default.UINT32 },
                    { name: 'numofuntervals', type: dataType_1.default.UINT8 },
                ],
            },
        },
        commandsResponse: {
            getProfileInfoRsp: {
                ID: 0,
                parameters: [
                    { name: 'profilecount', type: dataType_1.default.UINT8 },
                    { name: 'profileintervalperiod', type: dataType_1.default.UINT8 },
                    { name: 'maxnumofintervals', type: dataType_1.default.UINT8 },
                    { name: 'numofattrs', type: dataType_1.default.UINT8 },
                    { name: 'listofattr', type: buffaloZclDataType_1.default.LIST_UINT16 },
                ],
            },
            getMeasurementProfileRsp: {
                ID: 1,
                parameters: [
                    { name: 'starttime', type: dataType_1.default.UINT32 },
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'profileintervalperiod', type: dataType_1.default.UINT8 },
                    { name: 'numofintervalsdeliv', type: dataType_1.default.UINT8 },
                    { name: 'attrId', type: dataType_1.default.UINT16 },
                    { name: 'intervals', type: buffaloZclDataType_1.default.LIST_UINT8 },
                ],
            },
        },
    },
    haDiagnostic: {
        ID: 2821,
        attributes: {
            numberOfResets: { ID: 0, type: dataType_1.default.UINT16 },
            persistentMemoryWrites: { ID: 1, type: dataType_1.default.UINT16 },
            macRxBcast: { ID: 256, type: dataType_1.default.UINT32 },
            macTxBcast: { ID: 257, type: dataType_1.default.UINT32 },
            macRxUcast: { ID: 258, type: dataType_1.default.UINT32 },
            macTxUcast: { ID: 259, type: dataType_1.default.UINT32 },
            macTxUcastRetry: { ID: 260, type: dataType_1.default.UINT16 },
            macTxUcastFail: { ID: 261, type: dataType_1.default.UINT16 },
            aPSRxBcast: { ID: 262, type: dataType_1.default.UINT16 },
            aPSTxBcast: { ID: 263, type: dataType_1.default.UINT16 },
            aPSRxUcast: { ID: 264, type: dataType_1.default.UINT16 },
            aPSTxUcastSuccess: { ID: 265, type: dataType_1.default.UINT16 },
            aPSTxUcastRetry: { ID: 266, type: dataType_1.default.UINT16 },
            aPSTxUcastFail: { ID: 267, type: dataType_1.default.UINT16 },
            routeDiscInitiated: { ID: 268, type: dataType_1.default.UINT16 },
            neighborAdded: { ID: 269, type: dataType_1.default.UINT16 },
            neighborRemoved: { ID: 270, type: dataType_1.default.UINT16 },
            neighborStale: { ID: 271, type: dataType_1.default.UINT16 },
            joinIndication: { ID: 272, type: dataType_1.default.UINT16 },
            childMoved: { ID: 273, type: dataType_1.default.UINT16 },
            nwkFcFailure: { ID: 274, type: dataType_1.default.UINT16 },
            apsFcFailure: { ID: 275, type: dataType_1.default.UINT16 },
            apsUnauthorizedKey: { ID: 276, type: dataType_1.default.UINT16 },
            nwkDecryptFailures: { ID: 277, type: dataType_1.default.UINT16 },
            apsDecryptFailures: { ID: 278, type: dataType_1.default.UINT16 },
            packetBufferAllocateFailures: { ID: 279, type: dataType_1.default.UINT16 },
            relayedUcast: { ID: 280, type: dataType_1.default.UINT16 },
            phyToMacQueueLimitReached: { ID: 281, type: dataType_1.default.UINT16 },
            packetValidateDropCount: { ID: 282, type: dataType_1.default.UINT16 },
            averageMacRetryPerApsMessageSent: { ID: 283, type: dataType_1.default.UINT16 },
            lastMessageLqi: { ID: 284, type: dataType_1.default.UINT8 },
            lastMessageRssi: { ID: 285, type: dataType_1.default.INT8 },
            danfossSystemStatusCode: { ID: 0x4000, type: dataType_1.default.BITMAP16, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossSystemStatusWater: { ID: 0x4200, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            danfossMultimasterRole: { ID: 0x4201, type: dataType_1.default.ENUM8, manufacturerCode: manufacturerCode_1.default.DANFOSS_A_S },
            schneiderMeterStatus: { ID: 0xFF01, type: dataType_1.default.UINT32, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderDiagnosticRegister1: { ID: 0xFF02, type: dataType_1.default.UINT32, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
            schneiderCommunicationQuality: { ID: 0x4000, type: dataType_1.default.UINT8, manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC },
        },
        commands: {},
        commandsResponse: {},
    },
    touchlink: {
        ID: 4096,
        attributes: {},
        commands: {
            scanRequest: {
                ID: 0,
                response: 1,
                parameters: [
                    { name: 'transactionID', type: dataType_1.default.UINT32 },
                    { name: 'zigbeeInformation', type: dataType_1.default.BITMAP8 },
                    { name: 'touchlinkInformation', type: dataType_1.default.BITMAP8 },
                ],
            },
            identifyRequest: {
                ID: 6,
                parameters: [
                    { name: 'transactionID', type: dataType_1.default.UINT32 },
                    { name: 'duration', type: dataType_1.default.UINT16 },
                ],
            },
            resetToFactoryNew: {
                ID: 7,
                parameters: [
                    { name: 'transactionID', type: dataType_1.default.UINT32 },
                ],
            },
        },
        commandsResponse: {
            scanResponse: {
                ID: 1,
                parameters: [
                    { name: 'transactionID', type: dataType_1.default.UINT32 },
                    { name: 'rssiCorrection', type: dataType_1.default.UINT8 },
                    { name: 'zigbeeInformation', type: dataType_1.default.UINT8 },
                    { name: 'touchlinkInformation', type: dataType_1.default.UINT8 },
                    { name: 'keyBitmask', type: dataType_1.default.UINT16 },
                    { name: 'responseID', type: dataType_1.default.UINT32 },
                    { name: 'extendedPanID', type: dataType_1.default.IEEE_ADDR },
                    { name: 'networkUpdateID', type: dataType_1.default.UINT8 },
                    { name: 'logicalChannel', type: dataType_1.default.UINT8 },
                    { name: 'panID', type: dataType_1.default.UINT16 },
                    { name: 'networkAddress', type: dataType_1.default.UINT16 },
                    { name: 'numberOfSubDevices', type: dataType_1.default.UINT8 },
                    { name: 'totalGroupIdentifiers', type: dataType_1.default.UINT8 },
                    // Below are optional according to the spec, not all devices send these.
                    // e.g. https://github.com/Koenkk/zigbee2mqtt/issues/8535#issuecomment-909199162
                    // Since we don't have a way to deal with optional attributes yet and since we don't
                    // use these attributes anyway, disable them for now.
                    // {name: 'endpointID', type: DataType.UINT8},
                    // {name: 'profileID', type: DataType.UINT16},
                    // {name: 'deviceID', type: DataType.UINT16},
                    // {name: 'version', type: DataType.UINT8},
                    // {name: 'groupIdentifierCount', type: DataType.UINT8},
                ],
            },
        },
    },
    manuSpecificIkeaAirPurifier: {
        ID: 0xfc7d,
        manufacturerCode: manufacturerCode_1.default.IKEA_OF_SWEDEN,
        attributes: {
            filterRunTime: { ID: 0x0000, type: dataType_1.default.UINT32 },
            replaceFilter: { ID: 0x0001, type: dataType_1.default.UINT8 },
            filterLifeTime: { ID: 0x0002, type: dataType_1.default.UINT32 },
            controlPanelLight: { ID: 0x0003, type: dataType_1.default.BOOLEAN },
            particulateMatter25Measurement: { ID: 0x0004, type: dataType_1.default.UINT16 },
            childLock: { ID: 0x0005, type: dataType_1.default.BOOLEAN },
            fanMode: { ID: 0x0006, type: dataType_1.default.UINT8 },
            fanSpeed: { ID: 0x0007, type: dataType_1.default.UINT8 },
            deviceRunTime: { ID: 0x0008, type: dataType_1.default.UINT32 },
        },
        commands: {},
        commandsResponse: {},
    },
    msIkeaVocIndexMeasurement: {
        ID: 0xfc7e,
        manufacturerCode: manufacturerCode_1.default.IKEA_OF_SWEDEN,
        attributes: {
            measuredValue: { ID: 0x0000, type: dataType_1.default.SINGLE_PREC },
            measuredMinValue: { ID: 0x0001, type: dataType_1.default.SINGLE_PREC },
            measuredMaxValue: { ID: 0x0002, type: dataType_1.default.SINGLE_PREC },
        },
        commands: {},
        commandsResponse: {},
    },
    manuSpecificClusterAduroSmart: {
        ID: 64716,
        attributes: {},
        commands: {
            cmd0: {
                ID: 0,
                parameters: [],
            },
        },
        commandsResponse: {},
    },
    manuSpecificOsram: {
        ID: 64527,
        attributes: {},
        commands: {
            saveStartupParams: {
                ID: 1,
                parameters: [],
            },
            resetStartupParams: {
                ID: 2,
                parameters: [],
            },
        },
        commandsResponse: {
            saveStartupParamsRsp: {
                ID: 0,
                parameters: [],
            },
        },
    },
    manuSpecificPhilips: {
        ID: 0xFC00,
        manufacturerCode: manufacturerCode_1.default.SIGNIFY_NETHERLANDS_B_V,
        attributes: {
            config: { ID: 49, type: dataType_1.default.BITMAP16 },
        },
        commands: {},
        commandsResponse: {
            hueNotification: {
                ID: 0,
                parameters: [
                    { name: 'button', type: dataType_1.default.UINT8 },
                    { name: 'unknown1', type: dataType_1.default.UINT24 },
                    { name: 'type', type: dataType_1.default.UINT8 },
                    { name: 'unknown2', type: dataType_1.default.UINT8 },
                    { name: 'time', type: dataType_1.default.UINT8 },
                    { name: 'unknown2', type: dataType_1.default.UINT8 },
                ],
            },
        },
    },
    manuSpecificPhilips2: {
        ID: 0xFC03,
        manufacturerCode: manufacturerCode_1.default.SIGNIFY_NETHERLANDS_B_V,
        attributes: {
            state: { ID: 0x0002, type: dataType_1.default.OCTET_STR },
        },
        commands: {
            multiColor: {
                ID: 0,
                parameters: [
                    { name: 'data', type: buffaloZclDataType_1.default.BUFFER },
                ],
            },
        },
        commandsResponse: {},
    },
    manuSpecificSinope: {
        ID: 65281,
        manufacturerCode: manufacturerCode_1.default.SINOPE_TECHNOLOGIES,
        attributes: {
            // attribute ID :1's readable
            keypadLockout: { ID: 2, type: dataType_1.default.ENUM8 },
            // 'firmware number': {ID: 3, type: DataType.UNKNOWN},
            firmwareVersion: { ID: 4, type: dataType_1.default.CHAR_STR },
            outdoorTempToDisplay: { ID: 16, type: dataType_1.default.INT16 },
            outdoorTempToDisplayTimeout: { ID: 17, type: dataType_1.default.UINT16 },
            secondScreenBehavior: { ID: 18, type: dataType_1.default.ENUM8 }, // auto:0,setpoint:1,outside:2
            currentTimeToDisplay: { ID: 32, type: dataType_1.default.UINT32 },
            ledIntensityOn: { ID: 82, type: dataType_1.default.UINT8 },
            ledIntensityOff: { ID: 83, type: dataType_1.default.UINT8 },
            ledColorOn: { ID: 80, type: dataType_1.default.UINT24 }, // inversed hex BBGGRR
            ledColorOff: { ID: 81, type: dataType_1.default.UINT24 },
            onLedIntensity: { ID: 82, type: dataType_1.default.UINT8 }, // percent
            offLedIntensity: { ID: 83, type: dataType_1.default.UINT8 }, // percent
            actionReport: { ID: 84, type: dataType_1.default.ENUM8 }, // singleTapUp: 1,2, doubleTapUp: 1,4, singleTapDown: 17,18, doubleTapDown: 17,20
            minimumBrightness: { ID: 85, type: dataType_1.default.UINT16 },
            connectedLoadRM: { ID: 96, type: dataType_1.default.UINT16 }, // unit watt/hr for Calypso RM3500 & Load Controller RM3250
            currentLoad: { ID: 112, type: dataType_1.default.BITMAP8 }, // related to ecoMode(s)
            ecoMode: { ID: 113, type: dataType_1.default.INT8 }, // default:-128||-100-0-100%
            ecoMode1: { ID: 114, type: dataType_1.default.UINT8 }, // default:255||0-99
            ecoMode2: { ID: 115, type: dataType_1.default.UINT8 }, // default 255||0-100
            unknown: { ID: 117, type: dataType_1.default.BITMAP32 }, // RW *testing*
            drConfigWaterTempMin: { ID: 118, type: dataType_1.default.UINT8 }, // value 45 or 0
            drConfigWaterTempTime: { ID: 119, type: dataType_1.default.UINT8 }, // default 2
            drWTTimeOn: { ID: 120, type: dataType_1.default.UINT16 },
            unknown1: { ID: 128, type: dataType_1.default.UINT32 }, // readOnly stringNumber *testing*
            dimmerTimmer: { ID: 160, type: dataType_1.default.UINT32 },
            unknown2: { ID: 256, type: dataType_1.default.UINT8 }, // readOnly *testing*
            floorControlMode: { ID: 261, type: dataType_1.default.ENUM8 }, // airFloorMode
            auxOutputMode: { ID: 262, type: dataType_1.default.ENUM8 },
            floorTemperature: { ID: 263, type: dataType_1.default.INT16 },
            ambiantMaxHeatSetpointLimit: { ID: 264, type: dataType_1.default.INT16 },
            floorMinHeatSetpointLimit: { ID: 265, type: dataType_1.default.INT16 },
            floorMaxHeatSetpointLimit: { ID: 266, type: dataType_1.default.INT16 },
            temperatureSensor: { ID: 267, type: dataType_1.default.ENUM8 },
            floorLimitStatus: { ID: 268, type: dataType_1.default.ENUM8 },
            roomTemperature: { ID: 269, type: dataType_1.default.INT16 },
            timeFormatToDisplay: { ID: 276, type: dataType_1.default.ENUM8 },
            GFCiStatus: { ID: 277, type: dataType_1.default.ENUM8 },
            auxConnectedLoad: { ID: 280, type: dataType_1.default.UINT16 },
            connectedLoad: { ID: 281, type: dataType_1.default.UINT16 },
            pumpProtection: { ID: 296, type: dataType_1.default.UINT8 },
            unknown3: { ID: 298, type: dataType_1.default.ENUM8 }, // RW default:60||5,10,15,20,30,60 *testing*
            currentSetpoint: { ID: 299, type: dataType_1.default.INT16 }, // W:to ocuppiedHeatSetpoint, R:depends of SinopeOccupancy
            // attribute ID: 300's readable, returns a buffer
            reportLocalTemperature: { ID: 301, type: dataType_1.default.INT16 },
            // attribute ID: 512's readable
            flowMeterConfig: { ID: 576, type: dataType_1.default.ARRAY },
            coldLoadPickupStatus: { ID: 643, type: dataType_1.default.UINT8 },
        },
        commands: {},
        commandsResponse: {},
    },
    manuSpecificLegrandDevices: {
        ID: 0xfc01,
        manufacturerCode: manufacturerCode_1.default.LEGRAND_GROUP,
        attributes: {
        // attributes seems to vary depending on the device. Can't be static
        },
        commands: {},
        commandsResponse: {}
    },
    manuSpecificLegrandDevices2: {
        ID: 0xfc40,
        manufacturerCode: manufacturerCode_1.default.LEGRAND_GROUP,
        attributes: {},
        commands: {
            command0: {
                ID: 0,
                parameters: [
                    { name: 'data', type: buffaloZclDataType_1.default.BUFFER },
                ],
            },
        },
        commandsResponse: {}
    },
    manuSpecificLegrandDevices3: {
        ID: 0xfc41,
        manufacturerCode: manufacturerCode_1.default.LEGRAND_GROUP,
        attributes: {},
        commands: {
            command0: {
                ID: 0,
                parameters: [
                    { name: 'data', type: buffaloZclDataType_1.default.BUFFER },
                ],
            },
        },
        commandsResponse: {}
    },
    manuSpecificNiko1: {
        ID: 0xfc00,
        manufacturerCode: manufacturerCode_1.default.NIKO_NV,
        attributes: {
            /* WARNING: 0x0000 has different datatypes!
             *          enum8 (switch) vs. bitmap8 (outlet)
             *          unknown usage/function on outlet
             */
            switchOperationMode: { ID: 0x0000, type: dataType_1.default.ENUM8 },
            outletLedColor: { ID: 0x0100, type: dataType_1.default.UINT24 },
            outletChildLock: { ID: 0x0101, type: dataType_1.default.UINT8 },
            outletLedState: { ID: 0x0104, type: dataType_1.default.UINT8 },
        },
        commands: {},
        commandsResponse: {}
    },
    manuSpecificNiko2: {
        ID: 0xfc01,
        manufacturerCode: manufacturerCode_1.default.NIKO_NV,
        attributes: {
            switchAction: { ID: 0x0002, type: dataType_1.default.UINT8 },
        },
        commands: {},
        commandsResponse: {}
    },
    wiserDeviceInfo: {
        ID: 0xFE03, // 65027
        attributes: {
            deviceInfo: { ID: 32, type: dataType_1.default.CHAR_STR },
        },
        commands: {},
        commandsResponse: {}
    },
    /**
     * Tuya cluster
     *
     * Common parameters:
     *
     *  seq -  Sequence number of transmitted data, range 0-65535, revert to 0 after reaching 65535
     *
     * Official Tuya documentation: https://developer.tuya.com/en/docs/iot-device-dev/tuya-zigbee-universal-docking-access-standard?id=K9ik6zvofpzql#subtitle-6-Private%20cluster
     *
     */
    manuSpecificTuya: {
        ID: 0xEF00, // 61184
        attributes: {},
        commands: {
            /**
             * Gateway-side data request
             */
            dataRequest: {
                ID: 0,
                parameters: [
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'dpValues', type: buffaloZclDataType_1.default.LIST_TUYA_DATAPOINT_VALUES },
                ],
            },
            /**
             * GW send, trigger MCU side to report all current information, no zcl payload.
             * Note: Device side can make a policy, data better not to report centrally
             */
            dataQuery: {
                ID: 3,
                parameters: [],
            },
            /**
             * Gw->Zigbee gateway query MCU version
             */
            mcuVersionRequest: {
                ID: 0x10,
                parameters: [
                    { name: 'seq', type: dataType_1.default.UINT16 },
                ],
            },
            /**
             * FIXME: This command is not listed in Tuya zigbee cluster description,
             *  but there is some command 0x04 (description is: Command Issuance)
             *  in `Serial command list` section of the same document
             *  So, need to investigate more information about it
             */
            sendData: {
                ID: 4,
                parameters: [
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'dpValues', type: buffaloZclDataType_1.default.LIST_TUYA_DATAPOINT_VALUES },
                ],
            },
            /**
             * Gw->Zigbee gateway notifies MCU of upgrade
             */
            mcuOtaNotify: {
                ID: 0x12,
                parameters: [
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    // FIXME: key is fixed (8 byte) uint8 array
                    //  Ask Koen is there any type to read fixed size uint_8t.
                    //  currently there is `length` property in options but sems it is
                    //  ignored in `writePayloadCluster()` and other methods.
                    //  So, as workaround we use hi/low for key, which is not best solution
                    { name: 'key_hi', type: dataType_1.default.UINT32 },
                    { name: 'key_lo', type: dataType_1.default.UINT32 },
                    { name: 'version', type: dataType_1.default.UINT8 },
                    { name: 'imageSize', type: dataType_1.default.UINT32 },
                    { name: 'crc', type: dataType_1.default.UINT32 },
                ],
            },
            /**
             * Gw->Zigbee gateway returns the requested upgrade package for MCU
             */
            mcuOtaBlockDataResponse: {
                ID: 0x14,
                parameters: [
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'key_hi', type: dataType_1.default.UINT32 },
                    { name: 'key_lo', type: dataType_1.default.UINT32 },
                    { name: 'version', type: dataType_1.default.UINT8 },
                    { name: 'offset', type: dataType_1.default.UINT32 },
                    { name: 'imageData', type: buffaloZclDataType_1.default.LIST_UINT8 },
                ],
            },
            /**
             * Time synchronization (bidirectional)
             */
            mcuSyncTime: {
                ID: 0x24,
                parameters: [
                    { name: 'payloadSize', type: dataType_1.default.UINT16 },
                    { name: 'payload', type: buffaloZclDataType_1.default.LIST_UINT8 },
                ]
            },
            /**
             * Gateway connection status (bidirectional)
             */
            mcuGatewayConnectionStatus: {
                ID: 0x25,
                parameters: [
                    { name: 'payloadSize', type: dataType_1.default.UINT16 },
                    { name: 'payload', type: dataType_1.default.UINT8 },
                ]
            }
        },
        commandsResponse: {
            /**
             * Reply to MCU-side data request
             */
            dataResponse: {
                ID: 1,
                parameters: [
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'dpValues', type: buffaloZclDataType_1.default.LIST_TUYA_DATAPOINT_VALUES },
                ],
            },
            /**
             * MCU-side data active upload (bidirectional)
             */
            dataReport: {
                ID: 2,
                parameters: [
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'dpValues', type: buffaloZclDataType_1.default.LIST_TUYA_DATAPOINT_VALUES },
                ],
            },
            /**
             * FIXME: This command is not listed in Tuya zigbee cluster description,
             *  but there is some command 0x05 (description is: Status query)
             *  in `Serial command list` section of the same document
             *  So, need to investigate more information about it
             */
            activeStatusReportAlt: {
                ID: 5,
                parameters: [
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'dpValues', type: buffaloZclDataType_1.default.LIST_TUYA_DATAPOINT_VALUES },
                ],
            },
            /**
             * FIXME: This command is not listed in Tuya zigbee cluster description,
             *  but there is some command 0x06 (description is: Status query)
             *  in `Serial command list` section of the same document
             *  So, need to investigate more information about it
             */
            activeStatusReport: {
                ID: 6,
                parameters: [
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'dpValues', type: buffaloZclDataType_1.default.LIST_TUYA_DATAPOINT_VALUES },
                ],
            },
            /**
             * Zigbee->Gw MCU return version or actively report version
             */
            mcuVersionResponse: {
                ID: 0x11,
                parameters: [
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'version', type: dataType_1.default.UINT8 },
                ],
            },
            /**
             * Zigbee->Gw requests an upgrade package for the MCU
             */
            mcuOtaBlockDataRequest: {
                ID: 0x13,
                parameters: [
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'key_hi', type: dataType_1.default.UINT32 },
                    { name: 'key_lo', type: dataType_1.default.UINT32 },
                    { name: 'version', type: dataType_1.default.UINT8 },
                    { name: 'offset', type: dataType_1.default.UINT32 },
                    { name: 'size', type: dataType_1.default.UINT32 },
                ],
            },
            /**
             * Zigbee->Gw returns the upgrade result for the mcu
             */
            mcuOtaResult: {
                ID: 0x15,
                parameters: [
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'status', type: dataType_1.default.UINT8 },
                    { name: 'key_hi', type: dataType_1.default.UINT32 },
                    { name: 'key_lo', type: dataType_1.default.UINT32 },
                    { name: 'version', type: dataType_1.default.UINT8 },
                ],
            },
            /**
             * Time synchronization (bidirectional)
             */
            mcuSyncTime: {
                ID: 0x24,
                parameters: [
                    { name: 'payloadSize', type: dataType_1.default.UINT16 }
                ]
            },
            /**
             * Gateway connection status (bidirectional)
             */
            mcuGatewayConnectionStatus: {
                ID: 0x25,
                parameters: [
                    { name: 'payloadSize', type: dataType_1.default.UINT16 }
                ]
            }
        },
    },
    manuSpecificLumi: {
        ID: 0xFCC0,
        manufacturerCode: manufacturerCode_1.default.LUMI_UNITED_TECHOLOGY_LTD_SHENZHEN,
        attributes: {
            mode: { ID: 0x0009, type: dataType_1.default.UINT8 },
            illuminance: { ID: 0x0112, type: dataType_1.default.UINT32 },
            displayUnit: { ID: 0x0114, type: dataType_1.default.UINT8 },
            airQuality: { ID: 0x0129, type: dataType_1.default.UINT8 },
            curtainReverse: { ID: 0x0400, type: dataType_1.default.BOOLEAN },
            curtainHandOpen: { ID: 0x0401, type: dataType_1.default.BOOLEAN },
            curtainCalibrated: { ID: 0x0402, type: dataType_1.default.BOOLEAN },
        },
        commands: {},
        commandsResponse: {}
    },
    liXeePrivate: {
        ID: 0xFF66,
        manufacturerCode: manufacturerCode_1.default.NXP_SEMICONDUCTORS,
        attributes: {
            currentTarif: { ID: 0x0000, type: dataType_1.default.CHAR_STR },
            tomorrowColor: { ID: 0x0001, type: dataType_1.default.CHAR_STR },
            scheduleHPHC: { ID: 0x0002, type: dataType_1.default.UINT8 },
            presencePotential: { ID: 0x0003, type: dataType_1.default.UINT8 },
            startNoticeEJP: { ID: 0x0004, type: dataType_1.default.UINT8 },
            warnDPS: { ID: 0x0005, type: dataType_1.default.UINT16 },
            warnDIR1: { ID: 0x0006, type: dataType_1.default.UINT16 },
            warnDIR2: { ID: 0x0007, type: dataType_1.default.UINT16 },
            warnDIR3: { ID: 0x0008, type: dataType_1.default.UINT16 },
            motDEtat: { ID: 0x0009, type: dataType_1.default.CHAR_STR },
            currentPrice: { ID: 0x0200, type: dataType_1.default.CHAR_STR },
            currentIndexTarif: { ID: 0x0201, type: dataType_1.default.UINT8 },
            currentDate: { ID: 0x0202, type: dataType_1.default.CHAR_STR },
            activeEnergyOutD01: { ID: 0x0203, type: dataType_1.default.UINT32 },
            activeEnergyOutD02: { ID: 0x0204, type: dataType_1.default.UINT32 },
            activeEnergyOutD03: { ID: 0x0205, type: dataType_1.default.UINT32 },
            activeEnergyOutD04: { ID: 0x0206, type: dataType_1.default.UINT32 },
            injectedVA: { ID: 0x0207, type: dataType_1.default.UINT16 },
            injectedVAMaxN: { ID: 0x0208, type: dataType_1.default.INT16 },
            injectedVAMaxN1: { ID: 0x0209, type: dataType_1.default.INT16 },
            injectedActiveLoadN: { ID: 0x0210, type: dataType_1.default.INT16 },
            injectedActiveLoadN1: { ID: 0x0211, type: dataType_1.default.INT16 },
            drawnVAMaxN1: { ID: 0x0212, type: dataType_1.default.INT16 },
            drawnVAMaxN1P2: { ID: 0x0213, type: dataType_1.default.INT16 },
            drawnVAMaxN1P3: { ID: 0x0214, type: dataType_1.default.INT16 },
            message1: { ID: 0x0215, type: dataType_1.default.CHAR_STR },
            message2: { ID: 0x0216, type: dataType_1.default.CHAR_STR },
            statusRegister: { ID: 0x0217, type: dataType_1.default.OCTET_STR },
            startMobilePoint1: { ID: 0x0218, type: dataType_1.default.UINT8 },
            stopMobilePoint1: { ID: 0x0219, type: dataType_1.default.UINT8 },
            startMobilePoint2: { ID: 0x0220, type: dataType_1.default.UINT8 },
            stopMobilePoint2: { ID: 0x0221, type: dataType_1.default.UINT8 },
            startMobilePoint3: { ID: 0x0222, type: dataType_1.default.UINT8 },
            stopMobilePoint3: { ID: 0x0223, type: dataType_1.default.UINT8 },
            relais: { ID: 0x0224, type: dataType_1.default.UINT16 },
            daysNumberCurrentCalendar: { ID: 0x0225, type: dataType_1.default.UINT8 },
            daysNumberNextCalendar: { ID: 0x0226, type: dataType_1.default.UINT8 },
            daysProfileCurrentCalendar: { ID: 0x0227, type: dataType_1.default.LONG_OCTET_STR },
            daysProfileNextCalendar: { ID: 0x0228, type: dataType_1.default.LONG_OCTET_STR },
            linkyMode: { ID: 0x0300, type: dataType_1.default.UINT8 },
        },
        commands: {},
        commandsResponse: {},
    },
    manuSpecificTuya_2: {
        ID: 0xE002,
        attributes: {
            alarm_temperature_max: { ID: 53258, type: dataType_1.default.INT16 },
            alarm_temperature_min: { ID: 53259, type: dataType_1.default.INT16 },
            alarm_humidity_max: { ID: 53261, type: dataType_1.default.INT16 },
            alarm_humidity_min: { ID: 53262, type: dataType_1.default.INT16 },
            alarm_humidity: { ID: 53263, type: dataType_1.default.ENUM8 },
            alarm_temperature: { ID: 53254, type: dataType_1.default.ENUM8 },
            unknown: { ID: 53264, type: dataType_1.default.UINT8 },
        },
        commands: {},
        commandsResponse: {},
    },
    manuSpecificTuya_3: {
        ID: 0xe001,
        attributes: {
            powerOnBehavior: { ID: 0xd010, type: dataType_1.default.ENUM8 },
            switchMode: { ID: 0xd020, type: dataType_1.default.ENUM8 },
            switchType: { ID: 0xd030, type: dataType_1.default.ENUM8 },
        },
        commands: {
            setOptions1: {
                ID: 0xE5,
                parameters: [
                    { name: 'data', type: buffaloZclDataType_1.default.BUFFER },
                ],
            },
            setOptions2: {
                ID: 0xE6,
                parameters: [
                    { name: 'data', type: buffaloZclDataType_1.default.BUFFER },
                ],
            },
            setOptions3: {
                ID: 0xE7,
                parameters: [
                    { name: 'data', type: buffaloZclDataType_1.default.BUFFER },
                ],
            },
        },
        commandsResponse: {},
    },
    manuSpecificCentraliteHumidity: {
        ID: 0xFC45,
        manufacturerCode: manufacturerCode_1.default.CENTRALITE_SYSTEMS_INC,
        attributes: {
            measuredValue: { ID: 0, type: dataType_1.default.UINT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    manuSpecificSmartThingsArrivalSensor: {
        ID: 0xFC05,
        manufacturerCode: manufacturerCode_1.default.SMARTTHINGS_INC,
        attributes: {},
        commands: {},
        commandsResponse: {
            arrivalSensorNotify: {
                ID: 1,
                parameters: [],
            },
        },
    },
    manuSpecificSamsungAccelerometer: {
        ID: 0xFC02,
        manufacturerCode: manufacturerCode_1.default.SMARTTHINGS_INC,
        attributes: {
            motion_threshold_multiplier: { ID: 0, type: dataType_1.default.UINT8 },
            motion_threshold: { ID: 2, type: dataType_1.default.UINT16 },
            acceleration: { ID: 16, type: dataType_1.default.BITMAP8 },
            x_axis: { ID: 18, type: dataType_1.default.INT16 },
            y_axis: { ID: 19, type: dataType_1.default.INT16 },
            z_axis: { ID: 20, type: dataType_1.default.INT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    heimanSpecificFormaldehydeMeasurement: {
        // from HS2AQ-3.0海曼智能空气质量检测仪API文档-V01
        ID: 0x042b,
        manufacturerCode: manufacturerCode_1.default.HEIMAN_TECHNOLOGY_CO_LTD,
        attributes: {
            measuredValue: { ID: 0x0000, type: dataType_1.default.UINT16 },
            measuredMinValue: { ID: 0x0001, type: dataType_1.default.UINT16 },
            measuredMaxValue: { ID: 0x0002, type: dataType_1.default.UINT16 },
            measuredTolerance: { ID: 0x0003, type: dataType_1.default.UINT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    heimanSpecificAirQuality: {
        // from HS2AQ-3.0海曼智能空气质量检测仪API文档-V01
        ID: 0xfc81,
        manufacturerCode: manufacturerCode_1.default.HEIMAN_TECHNOLOGY_CO_LTD,
        attributes: {
            language: { ID: 0xf000, type: dataType_1.default.UINT8 },
            unitOfMeasure: { ID: 0xf001, type: dataType_1.default.UINT8 },
            batteryState: { ID: 0xf002, type: dataType_1.default.UINT8 }, //  (0 is not charged, 1 is charging, 2 is fully charged)
            pm10measuredValue: { ID: 0xf003, type: dataType_1.default.UINT16 },
            tvocMeasuredValue: { ID: 0xf004, type: dataType_1.default.UINT16 },
            aqiMeasuredValue: { ID: 0xf005, type: dataType_1.default.UINT16 },
            temperatureMeasuredMax: { ID: 0xf006, type: dataType_1.default.INT16 },
            temperatureMeasuredMin: { ID: 0xf007, type: dataType_1.default.INT16 },
            humidityMeasuredMax: { ID: 0xf008, type: dataType_1.default.UINT16 },
            humidityMeasuredMin: { ID: 0xf009, type: dataType_1.default.UINT16 },
            alarmEnable: { ID: 0xf00a, type: dataType_1.default.UINT16 },
        },
        commands: {
            setLanguage: {
                ID: 0x011b,
                parameters: [
                    { name: 'languageCode', type: dataType_1.default.UINT8 },
                ],
            },
            setUnitOfTemperature: {
                ID: 0x011c,
                parameters: [
                    { name: 'unitsCode', type: dataType_1.default.UINT8 },
                ],
            },
            getTime: {
                ID: 0x011d,
                parameters: [],
            },
        },
        commandsResponse: {},
    },
    heimanSpecificScenes: {
        // from HS2SS-3.0海曼智能情景开关API文档-V01
        ID: 0xfc80,
        manufacturerCode: manufacturerCode_1.default.HEIMAN_TECHNOLOGY_CO_LTD,
        attributes: {},
        commands: {
            cinema: {
                ID: 0xf0,
                parameters: [],
            },
            atHome: {
                ID: 0xf1,
                parameters: [],
            },
            sleep: {
                ID: 0xf2,
                parameters: [],
            },
            goOut: {
                ID: 0xf3,
                parameters: [],
            },
            repast: {
                ID: 0xf4,
                parameters: [],
            },
        },
        commandsResponse: {},
    },
    tradfriButton: {
        ID: 0xfc80,
        manufacturerCode: manufacturerCode_1.default.IKEA_OF_SWEDEN,
        attributes: {},
        commands: {
            action1: {
                ID: 1,
                parameters: [
                    { name: 'data', type: dataType_1.default.UINT8 },
                ],
            },
            action2: {
                ID: 2,
                parameters: [
                    { name: 'data', type: dataType_1.default.UINT8 },
                ],
            },
            action3: {
                ID: 3,
                parameters: [
                    { name: 'data', type: dataType_1.default.UINT8 },
                ],
            },
            action4: {
                ID: 4,
                parameters: [
                    { name: 'data', type: dataType_1.default.UINT8 },
                ],
            },
            action6: {
                ID: 6,
                parameters: [
                    { name: 'data', type: dataType_1.default.UINT8 },
                ],
            },
        },
        commandsResponse: {},
    },
    heimanSpecificInfraRedRemote: {
        // from HS2IRC-3.0海曼智能红外转发控制器API-V01文档
        ID: 0xfc82,
        manufacturerCode: manufacturerCode_1.default.HEIMAN_TECHNOLOGY_CO_LTD,
        attributes: {},
        commands: {
            sendKey: {
                ID: 0xf0,
                parameters: [
                    { name: 'id', type: dataType_1.default.UINT8 },
                    { name: 'keyCode', type: dataType_1.default.UINT8 },
                ],
            },
            studyKey: {
                // Total we can have 30 keycode for each device ID (1..30).
                ID: 0xf1,
                // response: 0xf2,
                parameters: [
                    { name: 'id', type: dataType_1.default.UINT8 },
                    { name: 'keyCode', type: dataType_1.default.UINT8 },
                ],
            },
            deleteKey: {
                ID: 0xf3,
                parameters: [
                    // 1-15 - Delete specific ID, >= 16 - Delete All
                    { name: 'id', type: dataType_1.default.UINT8 },
                    // 1-30 - Delete specific keycode, >= 31 - Delete All keycodes for the ID
                    { name: 'keyCode', type: dataType_1.default.UINT8 },
                ],
            },
            createId: {
                // Total we can have 15 device IDs (1..15).
                ID: 0xf4,
                // response: 0xf5,
                parameters: [
                    { name: 'modelType', type: dataType_1.default.UINT8 },
                ],
            },
            getIdAndKeyCodeList: {
                ID: 0xf6,
                // response: 0xf7,
                parameters: [],
            },
        },
        commandsResponse: {
            studyKeyRsp: {
                ID: 0xf2,
                parameters: [
                    { name: 'id', type: dataType_1.default.UINT8 },
                    { name: 'keyCode', type: dataType_1.default.UINT8 },
                    { name: 'result', type: dataType_1.default.UINT8 }, // 0 - success, 1 - fail
                ],
            },
            createIdRsp: {
                ID: 0xf5,
                parameters: [
                    { name: 'id', type: dataType_1.default.UINT8 }, // 0xFF - create failed
                    { name: 'modelType', type: dataType_1.default.UINT8 },
                ],
            },
            getIdAndKeyCodeListRsp: {
                ID: 0xf7,
                parameters: [
                    { name: 'packetsTotal', type: dataType_1.default.UINT8 },
                    { name: 'packetNumber', type: dataType_1.default.UINT8 },
                    { name: 'packetLength', type: dataType_1.default.UINT8 }, // Max length is 70 bytes
                    // HELP for learnedDevicesList data structure:
                    //   struct structPacketPayload {
                    //     uint8_t ID;
                    //     uint8_t ModeType;
                    //     uint8_t KeyNum;
                    //     uint8_t KeyCode[KeyNum];
                    //   } arayPacketPayload[CurentPacketLenght];
                    // }
                    { name: 'learnedDevicesList', type: buffaloZclDataType_1.default.LIST_UINT8 },
                ],
            },
        },
    },
    develcoSpecificAirQuality: {
        ID: 0xFC03,
        manufacturerCode: manufacturerCode_1.default.DEVELCO,
        attributes: {
            measuredValue: { ID: 0x0000, type: dataType_1.default.UINT16 },
            minMeasuredValue: { ID: 0x0001, type: dataType_1.default.UINT16 },
            maxMeasuredValue: { ID: 0x0002, type: dataType_1.default.UINT16 },
            resolution: { ID: 0x0003, type: dataType_1.default.UINT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    schneiderSpecificPilotMode: {
        ID: 0xFF23,
        manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC,
        attributes: {
            pilotMode: { ID: 0x0031, type: dataType_1.default.ENUM8 },
        },
        commands: {},
        commandsResponse: {},
    },
    elkoOccupancySettingClusterServer: {
        ID: 0xFF19,
        manufacturerCode: manufacturerCode_1.default.ADEO,
        attributes: {
            AmbienceLightThreshold: { ID: 0x0000, type: dataType_1.default.UINT16 },
            OccupancyActions: { ID: 0x0001, type: dataType_1.default.ENUM8 },
            UnoccupiedLevelDflt: { ID: 0x0002, type: dataType_1.default.UINT8 },
            UnoccupiedLevel: { ID: 0x0003, type: dataType_1.default.UINT8 },
        },
        commands: {},
        commandsResponse: {},
    },
    elkoSwitchConfigurationClusterServer: {
        ID: 0xFF17,
        manufacturerCode: manufacturerCode_1.default.ADEO,
        attributes: {
            SwitchIndication: { ID: 0x0000, type: dataType_1.default.ENUM8 },
            UpSceneID: { ID: 0x0010, type: dataType_1.default.UINT8 },
            UpGroupID: { ID: 0x0011, type: dataType_1.default.UINT16 },
            DownSceneID: { ID: 0x0020, type: dataType_1.default.UINT8 },
            DownGroupID: { ID: 0x0021, type: dataType_1.default.UINT16 },
            SwitchActions: { ID: 0x0001, type: dataType_1.default.ENUM8 },
        },
        commands: {},
        commandsResponse: {},
    },
    manuSpecificSchneiderLightSwitchConfiguration: {
        ID: 0xFF17,
        manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC,
        attributes: {
            ledIndication: { ID: 0x0000, type: dataType_1.default.ENUM8 },
            upSceneID: { ID: 0x0010, type: dataType_1.default.UINT8 },
            upGroupID: { ID: 0x0011, type: dataType_1.default.UINT16 },
            downSceneID: { ID: 0x0020, type: dataType_1.default.UINT8 },
            downGroupID: { ID: 0x0021, type: dataType_1.default.UINT16 },
            switchActions: { ID: 0x0001, type: dataType_1.default.ENUM8 },
        },
        commands: {},
        commandsResponse: {},
    },
    manuSpecificSchneiderFanSwitchConfiguration: {
        ID: 0xFC04,
        manufacturerCode: manufacturerCode_1.default.SCHNEIDER_ELECTRIC,
        attributes: {
            ledIndication: { ID: 0x0002, type: dataType_1.default.UINT8 },
            ledOrientation: { ID: 0x0060, type: dataType_1.default.UINT8 },
        },
        commands: {},
        commandsResponse: {},
    },
    sprutDevice: {
        ID: 26112,
        manufacturerCode: 26214,
        attributes: {
            debug: { ID: 0, type: dataType_1.default.BOOLEAN },
        },
        commands: {},
        commandsResponse: {},
    },
    sprutVoc: {
        ID: 26113,
        manufacturerCode: 26214,
        attributes: {
            voc: { ID: 26112, type: dataType_1.default.UINT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    sprutNoise: {
        ID: 26114,
        manufacturerCode: 26214,
        attributes: {
            noise: { ID: 26112, type: dataType_1.default.SINGLE_PREC },
            noiseDetected: { ID: 26113, type: dataType_1.default.BITMAP8 },
            noiseDetectLevel: { ID: 26114, type: dataType_1.default.SINGLE_PREC },
            noiseAfterDetectDelay: { ID: 26115, type: dataType_1.default.UINT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    sprutIrBlaster: {
        ID: 26115,
        manufacturerCode: 26214,
        attributes: {},
        commands: {
            playStore: {
                ID: 0x00,
                parameters: [
                    { name: 'param', type: dataType_1.default.UINT8 },
                ],
            },
            learnStart: {
                ID: 0x01,
                parameters: [
                    { name: 'value', type: dataType_1.default.UINT8 },
                ],
            },
            learnStop: {
                ID: 0x02,
                parameters: [
                    { name: 'value', type: dataType_1.default.UINT8 },
                ],
            },
            clearStore: {
                ID: 0x03,
                parameters: [],
            },
            playRam: {
                ID: 0x04,
                parameters: [],
            },
            learnRamStart: {
                ID: 0x05,
                parameters: [],
            },
            learnRamStop: {
                ID: 0x06,
                parameters: [],
            },
        },
        commandsResponse: {},
    },
    manuSpecificSiglisZigfred: {
        ID: 0xFC42,
        manufacturerCode: 0x129C,
        attributes: {
            buttonEvent: { ID: 0x0008, type: dataType_1.default.UINT32 },
        },
        commands: {
            siglisZigfredButtonEvent: {
                ID: 0x02,
                parameters: [
                    { name: 'button', type: dataType_1.default.UINT8 },
                    { name: 'type', type: dataType_1.default.UINT8 },
                    { name: 'duration', type: dataType_1.default.UINT16 },
                ],
            },
        },
        commandsResponse: {},
    },
    manuSpecificInovelli: {
        ID: 64561,
        manufacturerCode: 0x122f,
        attributes: {
            dimmingSpeedUpRemote: { ID: 0x001, type: dataType_1.default.UINT8 },
            dimmingSpeedUpLocal: { ID: 0x0002, type: dataType_1.default.UINT8 },
            rampRateOffToOnRemote: { ID: 0x0003, type: dataType_1.default.UINT8 },
            rampRateOffToOnLocal: { ID: 0x0004, type: dataType_1.default.UINT8 },
            dimmingSpeedDownRemote: { ID: 0x0005, type: dataType_1.default.UINT8 },
            dimmingSpeedDownLocal: { ID: 0x0006, type: dataType_1.default.UINT8 },
            rampRateOnToOffRemote: { ID: 0x0007, type: dataType_1.default.UINT8 },
            rampRateOnToOffLocal: { ID: 0x0008, type: dataType_1.default.UINT8 },
            minimumLevel: { ID: 0x0009, type: dataType_1.default.UINT8 },
            maximumLevel: { ID: 0x000a, type: dataType_1.default.UINT8 },
            invertSwitch: { ID: 0x000b, type: dataType_1.default.BOOLEAN },
            autoTimerOff: { ID: 0x000c, type: dataType_1.default.UINT16 },
            defaultLevelLocal: { ID: 0x000d, type: dataType_1.default.UINT8 },
            defaultLevelRemote: { ID: 0x000e, type: dataType_1.default.UINT8 },
            stateAfterPowerRestored: { ID: 0x000f, type: dataType_1.default.UINT8 },
            loadLevelIndicatorTimeout: { ID: 0x0011, type: dataType_1.default.UINT8 },
            activePowerReports: { ID: 0x0012, type: dataType_1.default.UINT8 },
            periodicPowerAndEnergyReports: { ID: 0x0013, type: dataType_1.default.UINT16 },
            activeEnergyReports: { ID: 0x0014, type: dataType_1.default.UINT16 },
            powerType: { ID: 0x0015, type: dataType_1.default.BOOLEAN },
            switchType: { ID: 0x0016, type: dataType_1.default.UINT8 },
            quickStartTime: { ID: 0x0017, type: dataType_1.default.UINT8 },
            quickStartLevel: { ID: 0x0018, type: dataType_1.default.UINT8 },
            higherOutputInNonNeutral: { ID: 0x0019, type: dataType_1.default.BOOLEAN },
            nonNeutralAuxMediumGear: { ID: 0x001e, type: dataType_1.default.UINT8 },
            nonNeutralAuxLowGear: { ID: 0x001f, type: dataType_1.default.UINT8 },
            internalTemperature: { ID: 0x0020, type: dataType_1.default.UINT8 },
            overheat: { ID: 0x0021, type: dataType_1.default.BOOLEAN },
            buttonDelay: { ID: 0x0032, type: dataType_1.default.UINT8 },
            deviceBindNumber: { ID: 0x0033, type: dataType_1.default.UINT8 },
            smartBulbMode: { ID: 0x0034, type: dataType_1.default.BOOLEAN },
            doubleTapUpToParam55: { ID: 0x0035, type: dataType_1.default.BOOLEAN },
            doubleTapDownToParam56: { ID: 0x0036, type: dataType_1.default.BOOLEAN },
            brightnessLevelForDoubleTapUp: { ID: 0x0037, type: dataType_1.default.UINT8 },
            brightnessLevelForDoubleTapDown: { ID: 0x0038, type: dataType_1.default.UINT8 },
            defaultLed1ColorWhenOn: { ID: 0x003c, type: dataType_1.default.UINT8 },
            defaultLed1ColorWhenOff: { ID: 0x003d, type: dataType_1.default.UINT8 },
            defaultLed1IntensityWhenOn: { ID: 0x003e, type: dataType_1.default.UINT8 },
            defaultLed1IntensityWhenOff: { ID: 0x003f, type: dataType_1.default.UINT8 },
            defaultLed2ColorWhenOn: { ID: 0x0041, type: dataType_1.default.UINT8 },
            defaultLed2ColorWhenOff: { ID: 0x0042, type: dataType_1.default.UINT8 },
            defaultLed2IntensityWhenOn: { ID: 0x0043, type: dataType_1.default.UINT8 },
            defaultLed2IntensityWhenOff: { ID: 0x0044, type: dataType_1.default.UINT8 },
            defaultLed3ColorWhenOn: { ID: 0x0046, type: dataType_1.default.UINT8 },
            defaultLed3ColorWhenOff: { ID: 0x0047, type: dataType_1.default.UINT8 },
            defaultLed3IntensityWhenOn: { ID: 0x0048, type: dataType_1.default.UINT8 },
            defaultLed3IntensityWhenOff: { ID: 0x0049, type: dataType_1.default.UINT8 },
            defaultLed4ColorWhenOn: { ID: 0x004b, type: dataType_1.default.UINT8 },
            defaultLed4ColorWhenOff: { ID: 0x004c, type: dataType_1.default.UINT8 },
            defaultLed4IntensityWhenOn: { ID: 0x004d, type: dataType_1.default.UINT8 },
            defaultLed4IntensityWhenOff: { ID: 0x004e, type: dataType_1.default.UINT8 },
            defaultLed5ColorWhenOn: { ID: 0x0050, type: dataType_1.default.UINT8 },
            defaultLed5ColorWhenOff: { ID: 0x0051, type: dataType_1.default.UINT8 },
            defaultLed5IntensityWhenOn: { ID: 0x0052, type: dataType_1.default.UINT8 },
            defaultLed5IntensityWhenOff: { ID: 0x0053, type: dataType_1.default.UINT8 },
            defaultLed6ColorWhenOn: { ID: 0x0055, type: dataType_1.default.UINT8 },
            defaultLed6ColorWhenOff: { ID: 0x0056, type: dataType_1.default.UINT8 },
            defaultLed6IntensityWhenOn: { ID: 0x0057, type: dataType_1.default.UINT8 },
            defaultLed6IntensityWhenOff: { ID: 0x0058, type: dataType_1.default.UINT8 },
            defaultLed7ColorWhenOn: { ID: 0x005a, type: dataType_1.default.UINT8 },
            defaultLed7ColorWhenOff: { ID: 0x005b, type: dataType_1.default.UINT8 },
            defaultLed7IntensityWhenOn: { ID: 0x005c, type: dataType_1.default.UINT8 },
            defaultLed7IntensityWhenOff: { ID: 0x005d, type: dataType_1.default.UINT8 },
            ledColorWhenOn: { ID: 0x005f, type: dataType_1.default.UINT8 },
            ledColorWhenOff: { ID: 0x060, type: dataType_1.default.UINT8 },
            ledIntensityWhenOn: { ID: 0x0061, type: dataType_1.default.UINT8 },
            ledIntensityWhenOff: { ID: 0x0062, type: dataType_1.default.UINT8 },
            ledBarScaling: { ID: 0x0064, type: dataType_1.default.BOOLEAN },
            singleTapBehavior: { ID: 0x0078, type: dataType_1.default.UINT8 },
            fanTimerMode: { ID: 0x0079, type: dataType_1.default.UINT8 },
            auxSwitchUniqueScenes: { ID: 0x007b, type: dataType_1.default.BOOLEAN },
            bindingOffToOnSyncLevel: { ID: 0x007d, type: dataType_1.default.BOOLEAN },
            breezeMode: { ID: 0x0081, type: dataType_1.default.UINT32 },
            fanControlMode: { ID: 0x0082, type: dataType_1.default.UINT8 },
            lowLevelForFanControlMode: { ID: 0x0083, type: dataType_1.default.UINT8 },
            mediumLevelForFanControlMode: { ID: 0x0084, type: dataType_1.default.UINT8 },
            highLevelForFanControlMode: { ID: 0x0085, type: dataType_1.default.UINT8 },
            ledColorForFanControlMode: { ID: 0x0086, type: dataType_1.default.UINT8 },
            localProtection: { ID: 0x0100, type: dataType_1.default.BOOLEAN },
            remoteProtection: { ID: 0x0101, type: dataType_1.default.BOOLEAN },
            outputMode: { ID: 0x0102, type: dataType_1.default.BOOLEAN },
            onOffLedMode: { ID: 0x0103, type: dataType_1.default.BOOLEAN },
            firmwareUpdateInProgressIndicator: { ID: 0x0104, type: dataType_1.default.BOOLEAN },
            relayClick: { ID: 0x105, type: dataType_1.default.BOOLEAN },
            doubleTapClearNotifications: { ID: 0x106, type: dataType_1.default.BOOLEAN },
            fanLedLevelType: { ID: 0x0107, type: dataType_1.default.UINT8 },
        },
        commands: {
            ledEffect: {
                ID: 1,
                parameters: [
                    { name: 'effect', type: dataType_1.default.UINT8 },
                    { name: 'color', type: dataType_1.default.UINT8 },
                    { name: 'level', type: dataType_1.default.UINT8 },
                    { name: 'duration', type: dataType_1.default.UINT8 },
                ],
            },
            individualLedEffect: {
                ID: 3,
                parameters: [
                    { name: 'led', type: dataType_1.default.UINT8 },
                    { name: 'effect', type: dataType_1.default.UINT8 },
                    { name: 'color', type: dataType_1.default.UINT8 },
                    { name: 'level', type: dataType_1.default.UINT8 },
                    { name: 'duration', type: dataType_1.default.UINT8 },
                ]
            }
        },
        commandsResponse: {},
    },
    owonClearMetering: {
        ID: 0xFFE0,
        manufacturerCode: manufacturerCode_1.default.OWON_TECHNOLOGY_INC,
        attributes: {},
        commands: {
            owonClearMeasurementData: {
                ID: 0x00,
                parameters: [],
            },
        },
        commandsResponse: {},
    },
    zosungIRTransmit: {
        ID: 0xed00,
        attributes: {},
        commands: {
            zosungSendIRCode00: {
                ID: 0,
                parameters: [
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'length', type: dataType_1.default.UINT32 },
                    { name: 'unk1', type: dataType_1.default.UINT32 },
                    { name: 'unk2', type: dataType_1.default.UINT16 },
                    { name: 'unk3', type: dataType_1.default.UINT8 },
                    { name: 'cmd', type: dataType_1.default.UINT8 },
                    { name: 'unk4', type: dataType_1.default.UINT16 },
                ],
            },
            zosungSendIRCode01: {
                ID: 1,
                parameters: [
                    { name: 'zero', type: dataType_1.default.UINT8 },
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'length', type: dataType_1.default.UINT32 },
                    { name: 'unk1', type: dataType_1.default.UINT32 },
                    { name: 'unk2', type: dataType_1.default.UINT16 },
                    { name: 'unk3', type: dataType_1.default.UINT8 },
                    { name: 'cmd', type: dataType_1.default.UINT8 },
                    { name: 'unk4', type: dataType_1.default.UINT16 },
                ],
            },
            zosungSendIRCode02: {
                ID: 2,
                parameters: [
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'position', type: dataType_1.default.UINT32 },
                    { name: 'maxlen', type: dataType_1.default.UINT8 },
                ],
            },
            zosungSendIRCode03: {
                ID: 3,
                parameters: [
                    { name: 'zero', type: dataType_1.default.UINT8 },
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'position', type: dataType_1.default.UINT32 },
                    { name: 'msgpart', type: dataType_1.default.OCTET_STR },
                    { name: 'msgpartcrc', type: dataType_1.default.UINT8 },
                ],
            },
            zosungSendIRCode04: {
                ID: 4,
                parameters: [
                    { name: 'zero0', type: dataType_1.default.UINT8 },
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'zero1', type: dataType_1.default.UINT16 },
                ],
            },
            zosungSendIRCode05: {
                ID: 5,
                parameters: [
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'zero', type: dataType_1.default.UINT16 },
                ],
            },
        },
        commandsResponse: {
            zosungSendIRCode03Resp: {
                ID: 3,
                parameters: [
                    { name: 'zero', type: dataType_1.default.UINT8 },
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'position', type: dataType_1.default.UINT32 },
                    { name: 'msgpart', type: dataType_1.default.OCTET_STR },
                    { name: 'msgpartcrc', type: dataType_1.default.UINT8 },
                ],
            },
            zosungSendIRCode05Resp: {
                ID: 5,
                parameters: [
                    { name: 'seq', type: dataType_1.default.UINT16 },
                    { name: 'zero', type: dataType_1.default.UINT16 },
                ],
            },
        },
    },
    zosungIRControl: {
        ID: 0xe004,
        attributes: {},
        commands: {
            zosungControlIRCommand00: {
                ID: 0,
                parameters: [
                    // JSON string with a command.
                    { name: 'data', type: buffaloZclDataType_1.default.BUFFER },
                ],
            },
        },
        commandsResponse: {},
    },
    manuSpecificBosch: {
        ID: 0xe000,
        manufacturerCode: manufacturerCode_1.default.ROBERT_BOSCH_GMBH,
        attributes: {
            sensitivity: { ID: 0x4003, type: dataType_1.default.UINT16 },
        },
        commands: {
            initiateTestMode: {
                ID: 0x00,
                parameters: [],
            },
        },
        commandsResponse: {},
    },
    manuSpecificBosch3: {
        ID: 0xe002,
        manufacturerCode: manufacturerCode_1.default.ROBERT_BOSCH_GMBH,
        attributes: {
            humidity: { ID: 0x4000, type: dataType_1.default.UINT16 },
            unknown1: { ID: 0x4001, type: dataType_1.default.UINT16 },
            unknown2: { ID: 0x4002, type: dataType_1.default.UINT16 },
            airpurity: { ID: 0x4003, type: dataType_1.default.UINT16 },
            temperature: { ID: 0x4004, type: dataType_1.default.INT16 },
            illuminance_lux: { ID: 0x4005, type: dataType_1.default.UINT16 },
            battery: { ID: 0x4006, type: dataType_1.default.UINT16 },
            unknown3: { ID: 0x4007, type: dataType_1.default.UINT16 },
            unknown4: { ID: 0x4008, type: dataType_1.default.UINT16 },
            pressure: { ID: 0x4009, type: dataType_1.default.UINT16 }, // Not yet confirmed
            unknown6: { ID: 0x400a, type: dataType_1.default.UINT16 },
            unknown7: { ID: 0x400b, type: dataType_1.default.UINT16 },
            unknown8: { ID: 0x400c, type: dataType_1.default.UINT16 },
        },
        commands: {},
        commandsResponse: {},
    },
    manuSpecificBosch5: {
        ID: 0xe004,
        manufacturerCode: manufacturerCode_1.default.ROBERT_BOSCH_GMBH,
        attributes: {
            unknown_attribute: { ID: 0x4000, type: dataType_1.default.BITMAP8 }, // 0,1 ??? read during pairing
            pre_alarm: { ID: 0x4001, type: dataType_1.default.BITMAP8 }, // 0,1 on/off
        },
        commands: {},
        commandsResponse: {},
    },
    manuSpecificBosch7: {
        ID: 0xe006,
        manufacturerCode: manufacturerCode_1.default.ROBERT_BOSCH_GMBH,
        attributes: {
            unknown1: { ID: 0x5003, type: dataType_1.default.INT8 }, // perhaps signal strength? -7?
            unknown2: { ID: 0x5004, type: dataType_1.default.UINT8 }, // ????
            heartbeat: { ID: 0x5005, type: dataType_1.default.BITMAP8 }, // 0,1 on/off
        },
        commands: {
            pairingCompleted: {
                ID: 0x01,
                parameters: [],
            },
        },
        commandsResponse: {},
    },
    manuSpecificBosch8: {
        ID: 0xe007,
        manufacturerCode: manufacturerCode_1.default.ROBERT_BOSCH_GMBH,
        attributes: {
            alarm_status: { ID: 0x5000, type: dataType_1.default.BITMAP32 },
        },
        commands: {
            burglarAlarm: {
                ID: 0x01,
                parameters: [
                    { name: 'data', type: dataType_1.default.UINT8 }, // data:1 trips the siren data:0 should stop the siren
                ],
            },
        },
        commandsResponse: {},
    },
    manuSpecificBosch9: {
        ID: 0xfca1,
        manufacturerCode: manufacturerCode_1.default.ROBERT_BOSCH_GMBH,
        attributes: {},
        commands: {
            confirmButtonPressed: {
                ID: 0x0010,
                parameters: [
                    { name: 'data', type: buffaloZclDataType_1.default.BUFFER },
                ],
            },
            pairingCompleted: {
                ID: 0x0012,
                parameters: [
                    { name: 'data', type: buffaloZclDataType_1.default.BUFFER },
                ],
            },
        },
        commandsResponse: {},
    },
    manuSpecificBosch10: {
        ID: 0xfca0,
        manufacturerCode: manufacturerCode_1.default.ROBERT_BOSCH_GMBH,
        attributes: {
            deviceMode: { ID: 0x0000, type: dataType_1.default.ENUM8 },
            switchType: { ID: 0x0001, type: dataType_1.default.ENUM8 },
            calibrationOpeningTime: { ID: 0x0002, type: dataType_1.default.UINT32 },
            calibrationClosingTime: { ID: 0x0003, type: dataType_1.default.UINT32 },
            childLock: { ID: 0x0008, type: dataType_1.default.BOOLEAN },
            motorState: { ID: 0x0013, type: dataType_1.default.ENUM8 },
        },
        commands: {},
        commandsResponse: {},
    },
    manuSpecificBosch11: {
        ID: 0xfcac,
        manufacturerCode: manufacturerCode_1.default.ROBERT_BOSCH_GMBH,
        attributes: {
            alarmOnMotion: { ID: 0x0003, type: dataType_1.default.BOOLEAN },
        },
        commands: {},
        commandsResponse: {},
    },
    manuSpecificAssaDoorLock: {
        ID: 0xFC00,
        attributes: {
            autoLockTime: { ID: 0x0012, type: dataType_1.default.UINT8 },
            wrongCodeAttempts: { ID: 0x0013, type: dataType_1.default.UINT8 },
            shutdownTime: { ID: 0x0014, type: dataType_1.default.UINT8 },
            batteryLevel: { ID: 0x0015, type: dataType_1.default.UINT8 },
            insideEscutcheonLED: { ID: 0x0016, type: dataType_1.default.UINT8 },
            volume: { ID: 0x0017, type: dataType_1.default.UINT8 },
            lockMode: { ID: 0x0018, type: dataType_1.default.UINT8 },
            language: { ID: 0x0019, type: dataType_1.default.UINT8 },
            allCodesLockout: { ID: 0x001A, type: dataType_1.default.BOOLEAN },
            oneTouchLocking: { ID: 0x001B, type: dataType_1.default.BOOLEAN },
            privacyButtonSetting: { ID: 0x001C, type: dataType_1.default.BOOLEAN },
            /* enableLogging: {ID: 0x0020, type: DataType.BOOLEAN},*/ // marked in C4 driver as not supported
            numberLogRecordsSupported: { ID: 0x0021, type: dataType_1.default.UINT16 },
            numberPinsSupported: { ID: 0x0030, type: dataType_1.default.UINT8 },
            numberScheduleSlotsPerUser: { ID: 0x0040, type: dataType_1.default.UINT8 },
            alarmMask: { ID: 0x0050, type: dataType_1.default.UINT8 },
        },
        commands: {
            getLockStatus: {
                ID: 0x10,
                response: 0,
                parameters: [],
            },
            getBatteryLevel: {
                ID: 0x12,
                parameters: [],
            },
            setRFLockoutTime: {
                ID: 0x13,
                parameters: [],
            },
            /* getLogRecord: {
                ID: 0x20,
                parameters: [],
            },*/ // marked in C4 driver as not supported
            userCodeSet: {
                ID: 0x30,
                parameters: [
                    // bit pack ("bbb", slot, status, pinLength) .. pin
                    { name: 'payload', type: dataType_1.default.CHAR_STR },
                ],
            },
            userCodeGet: {
                ID: 0x31,
                parameters: [
                    // bit pack ("b", slot)
                    { name: 'payload', type: dataType_1.default.CHAR_STR },
                ],
            },
            userCodeClear: {
                ID: 0x32,
                parameters: [
                    // bit pack ("b", slot)
                    { name: 'payload', type: dataType_1.default.CHAR_STR },
                ],
            },
            clearAllUserCodes: {
                ID: 0x33,
                parameters: [],
            },
            setUserCodeStatus: {
                ID: 0x34,
                parameters: [],
            },
            getUserCodeStatus: {
                ID: 0x35,
                parameters: [],
            },
            getLastUserIdEntered: {
                ID: 0x36,
                parameters: [],
            },
            userAdded: {
                ID: 0x37,
                parameters: [],
            },
            userDeleted: {
                ID: 0x38,
                parameters: [],
            },
            setScheduleSlot: {
                ID: 0x40,
                parameters: [
                    // bit pack ("bbbbbbb", 0, slot, weeklyScheduleNumber, startHour, startMinute, hours, minutes)
                    { name: 'payload', type: dataType_1.default.CHAR_STR },
                ],
            },
            getScheduleSlot: {
                ID: 0x41,
                parameters: [
                    // bit pack ("bb", slot, userId)
                    { name: 'payload', type: dataType_1.default.CHAR_STR },
                ],
            },
            setScheduleSlotStatus: {
                ID: 0x42,
                parameters: [
                    // bit pack ("bbb", 0, slot, status)
                    { name: 'payload', type: dataType_1.default.CHAR_STR },
                ],
            },
            reflash: {
                ID: 0x60,
                response: 1,
                parameters: [
                    // bit pack ("bI", version, length)
                    { name: 'payload', type: dataType_1.default.CHAR_STR },
                ],
            },
            reflashData: {
                ID: 0x61,
                response: 2,
                parameters: [
                    // bit pack ("IH", segmentId - 1, length) .. string sub (data, start, finish)
                    { name: 'payload', type: dataType_1.default.CHAR_STR },
                ],
            },
            reflashStatus: {
                ID: 0x62,
                response: 3,
                parameters: [
                    // bit pack ("bI", reflashStatusParameter, 0x00)
                    { name: 'payload', type: dataType_1.default.CHAR_STR },
                ],
            },
            getReflashLock: {
                ID: 0x90,
                parameters: [],
            },
            getHistory: {
                ID: 0xA0,
                parameters: [],
            },
            getLogin: {
                ID: 0xA1,
                parameters: [],
            },
            getUser: {
                ID: 0xA2,
                parameters: [],
            },
            getUsers: {
                ID: 0xA3,
                parameters: [],
            },
            getMandatoryAttributes: {
                ID: 0xB0,
                parameters: [],
            },
            readAttribute: {
                ID: 0xB1,
                parameters: [],
            },
            writeAttribute: {
                ID: 0xB2,
                parameters: [],
            },
            configureReporting: {
                ID: 0xB3,
                parameters: [],
            },
            getBasicClusterAttributes: {
                ID: 0xB4,
                parameters: [],
            },
        },
        commandsResponse: {
            getLockStatusRsp: {
                ID: 0,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            reflashRsp: {
                ID: 1,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            reflashDataRsp: {
                ID: 2,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            reflashStatusRsp: {
                ID: 3,
                parameters: [
                    { name: 'status', type: dataType_1.default.UINT8 },
                ],
            },
            /* boltStateRsp: {
                ID: 4,
                parameters: [
                    {name: 'state', type: DataType.UINT8},
                ],
            },*/ // C4 driver has this response yet there is no command - maybe a non-specific cluster response?
            /* lockStatusReportRsp: {
                ID: 5,
                parameters: [
                    {name: 'status', type: DataType.UINT8},
                ],
            },*/ // C4 driver has this response yet there is no command - maybe a non-specific cluster response?
            /* handleStateRsp: {
                ID: 6,
                parameters: [
                    {name: 'state', type: DataType.UINT8},
                ],
            },*/ // C4 driver has this response yet there is no command - maybe a non-specific cluster response?
            /* userStatusRsp: {
                ID: 7,
                parameters: [
                    {name: 'status', type: DataType.UINT8},
                ],
            },*/ // C4 driver has this response yet there is no command - maybe a non-specific cluster response?
        },
    },
    manuSpecificDoorman: {
        ID: 0xEACC,
        attributes: {},
        commands: {
            getConfigurationParameter: {
                ID: 0xFC,
                parameters: [
                    // bit pack ("bbb", 0x00, 0x00, configurationId)
                    { name: 'payload', type: dataType_1.default.CHAR_STR },
                ],
            },
            setConfigurationParameter: {
                ID: 0xFD,
                parameters: [
                    // bit pack ("bbbb", 0x00, 0x00, configurationId, value)
                    { name: 'payload', type: dataType_1.default.CHAR_STR },
                ],
            },
            integrationModeActivation: {
                ID: 0x25,
                parameters: [
                    // bit pack ("bbbbb", slot, codeType, string sub (userCode, 1, 2), string sub (userCode, 3, 4), string sub (userCode, 5, 6)) .. String duplicate (0xff, 12)
                    { name: 'payload', type: dataType_1.default.CHAR_STR },
                ],
            },
            armDisarm: {
                ID: 0x4E,
                parameters: [
                    // bit pack ("bb", lockSequenceNumber, operatingParameter)
                    { name: 'payload', type: dataType_1.default.CHAR_STR },
                ],
            },
        },
        commandsResponse: {},
    },
    manuSpecificNodOnPilotWire: {
        ID: 0xFC00,
        manufacturerCode: manufacturerCode_1.default.NODON,
        attributes: {
            mode: { ID: 0x0000, type: dataType_1.default.UINT8 }
        },
        commands: {
            setMode: {
                ID: 0x0000,
                parameters: [
                    { name: 'mode', type: dataType_1.default.UINT8 },
                ],
            },
        },
        commandsResponse: {},
    },
    manuSpecificProfalux1: {
        ID: 0xfc21, // Config cluster, 0xfc20 mostly for commands it seems
        manufacturerCode: manufacturerCode_1.default.PROFALUX,
        attributes: {
            motorCoverType: { ID: 0, type: dataType_1.default.UINT8 }, // 0 : rolling shutters (volet), 1 : rolling shutters with tilt (BSO), 2: shade (store)
        },
        commands: {},
        commandsResponse: {},
    },
    manuSpecificAmazonWWAH: {
        ID: 0xfc57,
        manufacturerCode: manufacturerCode_1.default.AMAZON_LAB126,
        attributes: {
            disableOTADowngrades: { ID: 0x0002, type: dataType_1.default.BOOLEAN },
            mgmtLeaveWithoutRejoinEnabled: { ID: 0x0003, type: dataType_1.default.BOOLEAN },
            nwkRetryCount: { ID: 0x0004, type: dataType_1.default.UINT8 },
            macRetryCount: { ID: 0x0005, type: dataType_1.default.UINT8 },
            routerCheckInEnabled: { ID: 0x0006, type: dataType_1.default.BOOLEAN },
            touchlinkInterpanEnabled: { ID: 0x0007, type: dataType_1.default.BOOLEAN },
            wwahParentClassificationEnabled: { ID: 0x0008, type: dataType_1.default.BOOLEAN },
            wwahAppEventRetryEnabled: { ID: 0x0009, type: dataType_1.default.BOOLEAN },
            wwahAppEventRetryQueueSize: { ID: 0x000A, type: dataType_1.default.UINT8 },
            wwahRejoinEnabled: { ID: 0x000B, type: dataType_1.default.BOOLEAN },
            macPollFailureWaitTime: { ID: 0x000C, type: dataType_1.default.UINT8 },
            configurationModeEnabled: { ID: 0x000D, type: dataType_1.default.BOOLEAN },
            currentDebugReportID: { ID: 0x000E, type: dataType_1.default.UINT8 },
            tcSecurityOnNwkKeyRotationEnabled: { ID: 0x000F, type: dataType_1.default.BOOLEAN },
            wwahBadParentRecoveryEnabled: { ID: 0x0010, type: dataType_1.default.BOOLEAN },
            pendingNetworkUpdateChannel: { ID: 0x0011, type: dataType_1.default.UINT8 },
            pendingNetworkUpdatePANID: { ID: 0x0012, type: dataType_1.default.UINT16 },
            otaMaxOfflineDuration: { ID: 0x0013, type: dataType_1.default.UINT16 },
            clusterRevision: { ID: 0xFFFD, type: dataType_1.default.UINT16 },
        },
        commands: {
            clearBindingTable: {
                ID: 0x0A,
                parameters: [],
            },
        },
        commandsResponse: {},
    },
};
exports.default = Clusters;
//# sourceMappingURL=cluster.js.map