"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StructuredIndicatorType = void 0;
/**
 * The upper 4 bits of the Indicator subfield for Attributes Structured commands.
 */
var StructuredIndicatorType;
(function (StructuredIndicatorType) {
    /**
     * Write: Only for attributes of type other than array, structure, set or bag
     *
     * Read: Only for attributes of type other than array or structure
     */
    StructuredIndicatorType[StructuredIndicatorType["Whole"] = 0] = "Whole";
    /** Add element to the set/bag */
    StructuredIndicatorType[StructuredIndicatorType["WriteAdd"] = 16] = "WriteAdd";
    /** Remove element from the set/bag */
    StructuredIndicatorType[StructuredIndicatorType["WriteRemove"] = 32] = "WriteRemove";
})(StructuredIndicatorType || (exports.StructuredIndicatorType = StructuredIndicatorType = {}));
//# sourceMappingURL=tstype.js.map