"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BroadcastAddress = void 0;
/**
 * ZigBee Broadcast Addresses
 *
 * ZigBee specifies three different broadcast addresses that reach different collections of nodes.
 * Broadcasts are normally sent only to routers.
 * Broadcasts can also be forwarded to end devices, either all of them or only those that do not sleep.
 * Broadcasting to end devices is both significantly more resource-intensive and significantly less reliable than broadcasting to routers.
 */
var BroadcastAddress;
(function (BroadcastAddress) {
    /** Broadcast to all routers. */
    BroadcastAddress[BroadcastAddress["DEFAULT"] = 65532] = "DEFAULT";
    /** Broadcast to all non-sleepy devices. */
    BroadcastAddress[BroadcastAddress["RX_ON_WHEN_IDLE"] = 65533] = "RX_ON_WHEN_IDLE";
    /** Broadcast to all devices, including sleepy end devices. */
    BroadcastAddress[BroadcastAddress["SLEEPY"] = 65535] = "SLEEPY";
})(BroadcastAddress || (exports.BroadcastAddress = BroadcastAddress = {}));
;
//# sourceMappingURL=enums.js.map