/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.util.function.Supplier;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;

public class ManualIterator
implements FocusIterator,
SequenceIterator,
ReversibleIterator,
LastPositionFinder,
GroundedIterator,
LookaheadIterator {
    private Item item;
    private int _position;
    private Supplier<Integer> lengthFinder;

    public ManualIterator() {
        this.item = null;
        this._position = 0;
    }

    public ManualIterator(Item value, int position) {
        this.item = value;
        this._position = position;
    }

    public ManualIterator(Item value) {
        this.item = value;
        this._position = 1;
        this.lengthFinder = () -> 1;
    }

    public void setContextItem(Item value) {
        this.item = value;
    }

    public void setLengthFinder(Supplier<Integer> finder) {
        this.lengthFinder = finder;
    }

    public void incrementPosition() {
        ++this._position;
    }

    public void setPosition(int position) {
        this._position = position;
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.position() != this.getLength();
    }

    @Override
    public Item next() {
        return null;
    }

    @Override
    public Item current() {
        return this.item;
    }

    @Override
    public int position() {
        return this._position;
    }

    @Override
    public boolean supportsGetLength() {
        return true;
    }

    @Override
    public int getLength() {
        if (this.lengthFinder == null) {
            throw new UncheckedXPathException("Saxon streaming restriction: last() cannot be used when consuming a sequence of streamed nodes, even if the items being processed are grounded");
        }
        int length = this.lengthFinder.get();
        return length;
    }

    @Override
    public boolean isActuallyGrounded() {
        return true;
    }

    @Override
    public ManualIterator getReverseIterator() {
        return new ManualIterator(this.item);
    }

    @Override
    public GroundedValue materialize() {
        return this.item;
    }

    @Override
    public GroundedValue getResidue() {
        return this.item;
    }
}

