/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.io.File;
import tim.prune.data.DataPoint;
import tim.prune.data.Timestamp;

public abstract class MediaObject {
    protected final File _file;
    protected final String _name;
    protected final byte[] _data;
    protected String _url = null;
    protected Timestamp _timestamp = null;
    protected DataPoint _dataPoint = null;
    private Status _originalStatus = Status.NOT_CONNECTED;
    private Status _currentStatus = Status.NOT_CONNECTED;

    public MediaObject(File file, Timestamp timestamp) {
        this._file = file;
        this._name = file.getName();
        this._data = null;
        this._timestamp = timestamp;
    }

    public MediaObject(byte[] byArray, String string, String string2) {
        this._file = null;
        this._data = byArray;
        this._name = string;
        this._url = string2;
        this._timestamp = null;
    }

    public File getFile() {
        return this._file;
    }

    public String getName() {
        return this._name;
    }

    public Timestamp getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this._timestamp = timestamp;
    }

    public byte[] getByteData() {
        return this._data;
    }

    public String getUrl() {
        return this._url;
    }

    public String getFullPath() {
        if (this._file != null) {
            return this._file.getAbsolutePath();
        }
        return this.getUrl();
    }

    public boolean isValid() {
        return this._file != null && this._file.exists() && this._file.canRead() || this._data != null && this._data.length > 0;
    }

    public boolean hasTimestamp() {
        return this._timestamp != null && this._timestamp.isValid();
    }

    public boolean equals(MediaObject mediaObject) {
        if (this._file != null) {
            return mediaObject != null && mediaObject.getFile() != null && this.getFile() != null && mediaObject.getFile().equals(this.getFile());
        }
        return mediaObject != null && this._name != null && mediaObject._name != null && this._name.equals(mediaObject._name) && this._data != null && mediaObject._data != null && this._data.length == mediaObject._data.length;
    }

    public void setDataPoint(DataPoint dataPoint) {
        this._dataPoint = dataPoint;
        if (dataPoint == null) {
            this.setCurrentStatus(Status.NOT_CONNECTED);
        } else {
            this.setCurrentStatus(Status.CONNECTED);
        }
    }

    public DataPoint getDataPoint() {
        return this._dataPoint;
    }

    public void setOriginalStatus(Status status) {
        this._originalStatus = status;
        this._currentStatus = status;
    }

    public Status getOriginalStatus() {
        return this._originalStatus;
    }

    public Status getCurrentStatus() {
        return this._currentStatus;
    }

    public void setCurrentStatus(Status status) {
        this._currentStatus = status;
    }

    public boolean isConnected() {
        return this._currentStatus != Status.NOT_CONNECTED;
    }

    public boolean isModified() {
        return this._currentStatus != this._originalStatus;
    }

    public static enum Status {
        NOT_CONNECTED,
        TAGGED,
        CONNECTED;

    }
}

