/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.search;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.function.search.GenericDownloaderFunction;
import tim.prune.function.search.GetWikipediaXmlHandler;
import tim.prune.function.search.SearchResult;

public class GetWikipediaFunction
extends GenericDownloaderFunction {
    private static final int MAX_RESULTS = 20;
    private static final int MAX_DISTANCE = 15;
    private static final String GEONAMES_USERNAME = "gpsprune";

    public GetWikipediaFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.getwikipedia";
    }

    @Override
    protected String getColumnKey(int n) {
        if (n == 0) {
            return "dialog.wikipedia.column.name";
        }
        return "dialog.wikipedia.column.distance";
    }

    @Override
    public void run() {
        this._statusLabel.setText(I18nManager.getText("confirm.running"));
        double d = 0.0;
        double d2 = 0.0;
        DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
        if (dataPoint == null) {
            d = this._app.getViewport().getCentreLatitude();
            d2 = this._app.getViewport().getCentreLongitude();
        } else {
            d = dataPoint.getLatitude().getDouble();
            d2 = dataPoint.getLongitude().getDouble();
        }
        String string = I18nManager.getText("wikipedia.lang");
        this.submitSearch(d, d2, string);
        if (this._trackListModel.isEmpty() && this._errorMessage == null && string.equals("als")) {
            this.submitSearch(d, d2, "de");
        }
        if (this._trackListModel.isEmpty() && this._errorMessage == null && !string.equals("en")) {
            this.submitSearch(d, d2, "en");
        }
        if (this._errorMessage == null && this._trackListModel.isEmpty()) {
            this._errorMessage = I18nManager.getText("dialog.wikipedia.nonefound");
        }
        this._statusLabel.setText(this._errorMessage == null ? "" : this._errorMessage);
    }

    private void submitSearch(double d, double d2, String string) {
        Object object;
        Serializable serializable;
        String string2 = "http://api.geonames.org/findNearbyWikipedia?lat=" + d + "&lng=" + d2 + "&maxRows=" + 20 + "&radius=" + 15 + "&lang=" + string + "&username=" + GEONAMES_USERNAME;
        GetWikipediaXmlHandler getWikipediaXmlHandler = new GetWikipediaXmlHandler();
        InputStream inputStream = null;
        try {
            serializable = new URL(string2);
            object = SAXParserFactory.newInstance().newSAXParser();
            inputStream = serializable.openStream();
            ((SAXParser)object).parse(inputStream, (DefaultHandler)getWikipediaXmlHandler);
        }
        catch (Exception exception) {
            this._errorMessage = String.valueOf(exception.getClass().getName()) + " - " + exception.getMessage();
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        serializable = getWikipediaXmlHandler.getTrackList();
        this._trackListModel.addTracks((ArrayList<SearchResult>)serializable, true);
        if (this._trackListModel.isEmpty() && (object = getWikipediaXmlHandler.getErrorMessage()) != null && !((String)object).equals("")) {
            this._app.showErrorMessageNoLookup(this.getNameKey(), (String)object);
            this._errorMessage = object;
        }
    }
}

