/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.discovery;

import io.micronaut.cache.CacheConfiguration;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.Toggleable;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Named;
import java.time.Duration;

@Named(value="discovery-client")
@ConfigurationProperties(value="micronaut.caches.discovery-client")
@Requires(property="micronaut.caches.discovery-client.enabled", notEquals="false")
public class DiscoveryClientCacheConfiguration
extends CacheConfiguration
implements Toggleable {
    public static final String CACHE_NAME = "discovery-client";
    public static final String SETTING_ENABLED = "micronaut.caches.discovery-client.enabled";
    public static final boolean DEFAULT_ENABLED = true;
    private boolean enabled = true;

    public DiscoveryClientCacheConfiguration(ApplicationConfiguration applicationConfiguration) {
        super(CACHE_NAME, applicationConfiguration);
        this.setExpireAfterAccess(Duration.ofSeconds(30L));
        this.setExpireAfterWrite(Duration.ofSeconds(30L));
        this.setInitialCapacity(5);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

