// Generated by gmmproc 2.64.2 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_MAPINFO_H
#define _GSTREAMERMM_MAPINFO_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2013-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>


namespace Gst
{

class Memory;

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var MapFlags MAP_READ
 * Map for read access.
 * 
 *  @var MapFlags MAP_WRITE
 * Map for write access.
 * 
 *  @var MapFlags MAP_FLAG_LAST
 * First flag that can be used for custom purposes.
 * 
 *  @enum MapFlags
 * 
 * Flags used when mapping memory
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%MapFlags operator|(MapFlags, MapFlags)</tt><br>
 * <tt>%MapFlags operator&(MapFlags, MapFlags)</tt><br>
 * <tt>%MapFlags operator^(MapFlags, MapFlags)</tt><br>
 * <tt>%MapFlags operator~(MapFlags)</tt><br>
 * <tt>%MapFlags& operator|=(MapFlags&, MapFlags)</tt><br>
 * <tt>%MapFlags& operator&=(MapFlags&, MapFlags)</tt><br>
 * <tt>%MapFlags& operator^=(MapFlags&, MapFlags)</tt><br>
 */
enum MapFlags
{
  MAP_READ = GST_LOCK_FLAG_READ,
  MAP_WRITE = GST_LOCK_FLAG_WRITE,
  MAP_FLAG_LAST = (1 << 16)
};

/** @ingroup gstreamermmEnums */
inline MapFlags operator|(MapFlags lhs, MapFlags rhs)
  { return static_cast<MapFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MapFlags operator&(MapFlags lhs, MapFlags rhs)
  { return static_cast<MapFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MapFlags operator^(MapFlags lhs, MapFlags rhs)
  { return static_cast<MapFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MapFlags operator~(MapFlags flags)
  { return static_cast<MapFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline MapFlags& operator|=(MapFlags& lhs, MapFlags rhs)
  { return (lhs = static_cast<MapFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MapFlags& operator&=(MapFlags& lhs, MapFlags rhs)
  { return (lhs = static_cast<MapFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MapFlags& operator^=(MapFlags& lhs, MapFlags rhs)
  { return (lhs = static_cast<MapFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::MapFlags> : public Glib::Value_Flags<Gst::MapFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


/* A structure containing the result of a map operation such as
 * Memory::map(). It contains the data and size.
 *
 * Last reviewed on 2016-06-05 (1.8.0)
 */
class MapInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = MapInfo;
  using BaseObjectType = GstMapInfo;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
  MapInfo();

  explicit MapInfo(const GstMapInfo& castitem);

  MapInfo(MapInfo&& other);
  MapInfo& operator=(MapInfo&& other);

  /** Get flags used when mapping the memory.
   */
  MapFlags get_flags() const;

  /** Get a pointer to the mapped data.
   */
  guint8* get_data();
  const guint8* get_data() const;

  /** Get the maximum bytes in data.
   */
  gsize get_maxsize() const;

  /** Get the valid size in data.
   */
  gsize get_size() const;

  /** Get a Glib::RefPtr to the mapped memory.
   */
  Glib::RefPtr<Gst::Memory> get_memory();
  Glib::RefPtr<const Gst::Memory> get_memory() const;

  GstMapInfo* gobj() { return &m_spec; };
  const GstMapInfo* gobj() const { return &m_spec; };

protected:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  GstMapInfo m_spec;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


};

}//namespace Gst


#endif /* _GSTREAMERMM_MAPINFO_H */

