/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.gui.ui.MainWindow;
import jadx.gui.utils.Utils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class ProgressPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -3238438119672015733L;
    private static final Icon ICON_CANCEL = Utils.openIcon("cross");
    private final JProgressBar progressBar;
    private final JLabel progressLabel = new JLabel();

    public ProgressPanel(final MainWindow mainWindow, boolean showCancelButton) {
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setStringPainted(false);
        this.progressLabel.setLabelFor(this.progressBar);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(new BoxLayout(this, 0));
        this.setVisible(false);
        this.add(this.progressLabel);
        this.add(this.progressBar);
        if (showCancelButton) {
            JButton cancelButton = new JButton(ICON_CANCEL);
            cancelButton.setPreferredSize(new Dimension(ICON_CANCEL.getIconWidth(), ICON_CANCEL.getIconHeight()));
            cancelButton.setToolTipText("Cancel background jobs");
            cancelButton.setBorderPainted(false);
            cancelButton.setFocusPainted(false);
            cancelButton.setContentAreaFilled(false);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mainWindow.cancelBackgroundJobs();
                }
            });
            this.add(cancelButton);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            int progress = (Integer)evt.getNewValue();
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(progress);
            this.progressBar.setString(progress + "%");
            this.progressBar.setStringPainted(true);
        } else if ("label".equals(evt.getPropertyName())) {
            this.setLabel((String)evt.getNewValue());
        }
    }

    public void setLabel(String label) {
        this.progressLabel.setText(label);
    }

    public void setIndeterminate(boolean newValue) {
        this.progressBar.setIndeterminate(newValue);
    }

    public void changeLabel(SwingWorker<?, ?> task, String label) {
        task.firePropertyChange("label", null, label);
    }
}

