/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.api.GenericImageDialog;
import org.jmol.api.Interface;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolAudioPlayer;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolDialogInterface;
import org.jmol.api.JmolStatusListener;
import org.jmol.c.CBK;
import org.jmol.script.SV;
import org.jmol.util.BSUtil;
import org.jmol.util.JmolAudio;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class StatusManager {
    protected Viewer vwr;
    JmolStatusListener jsl;
    public JmolCallbackListener cbl;
    public String statusList = "";
    public boolean allowStatusReporting;
    public Map<String, Lst<Lst<Object>>> messageQueue = new Hashtable<String, Lst<Lst<Object>>>();
    private int statusPtr = 0;
    private static int MAXIMUM_QUEUE_LENGTH = 16;
    private Map<String, String> jmolScriptCallbacks = new Hashtable<String, String>();
    private Map<String, GenericImageDialog> imageMap;
    private boolean echoing = false;
    private int minSyncRepeatMs = 100;
    public boolean syncingScripts = false;
    boolean syncingMouse = false;
    private boolean drivingSync;
    private boolean isSynced;
    private boolean syncDisabled;
    boolean stereoSync;
    public static final int SYNC_OFF = 0;
    public static final int SYNC_DRIVER = 1;
    public static final int SYNC_SLAVE = 2;
    public static final int SYNC_DISABLE = 3;
    public static final int SYNC_ENABLE = 4;
    public static final int SYNC_STEREO = 5;
    private int qualityJPG = -1;
    private int qualityPNG = -1;
    private String imageType;
    private Map<String, JmolAudioPlayer> audios;

    StatusManager(Viewer vwr) {
        this.vwr = vwr;
    }

    private boolean recordStatus(String statusName) {
        return this.allowStatusReporting && this.statusList.length() > 0 && (this.statusList.equals("all") || this.statusList.indexOf(statusName) >= 0);
    }

    private synchronized void setStatusChanged(String statusName, int intInfo, Object statusInfo, boolean isReplace) {
        Lst<Lst<Object>> statusRecordSet;
        if (!this.recordStatus(statusName)) {
            return;
        }
        Lst<Object> msgRecord = new Lst<Object>();
        msgRecord.addLast(Integer.valueOf(++this.statusPtr));
        msgRecord.addLast(statusName);
        msgRecord.addLast(Integer.valueOf(intInfo));
        msgRecord.addLast(statusInfo);
        Lst<Lst<Object>> lst = statusRecordSet = isReplace ? null : this.messageQueue.get(statusName);
        if (statusRecordSet == null) {
            statusRecordSet = new Lst();
            this.messageQueue.put(statusName, statusRecordSet);
        } else if (statusRecordSet.size() == MAXIMUM_QUEUE_LENGTH) {
            statusRecordSet.removeItemAt(0);
        }
        statusRecordSet.addLast(msgRecord);
    }

    synchronized Lst<Lst<Lst<Object>>> getStatusChanged(String newStatusList) {
        boolean isRemove = newStatusList.length() > 0 && newStatusList.charAt(0) == '-';
        boolean isAdd = newStatusList.length() > 0 && newStatusList.charAt(0) == '+';
        boolean getList = false;
        if (isRemove) {
            this.statusList = PT.rep(this.statusList, newStatusList.substring(1, newStatusList.length()), "");
        } else if (this.statusList.equals(newStatusList = PT.rep(newStatusList, "+", "")) || isAdd && this.statusList.indexOf(newStatusList) >= 0) {
            getList = true;
        } else {
            if (!isAdd) {
                this.statusList = "";
            }
            this.statusList = this.statusList + newStatusList;
            if (Logger.debugging) {
                Logger.debug("StatusManager messageQueue = " + this.statusList);
            }
        }
        Lst<Lst<Lst<Object>>> list = new Lst<Lst<Lst<Object>>>();
        if (getList) {
            for (Map.Entry<String, Lst<Lst<Object>>> e : this.messageQueue.entrySet()) {
                list.addLast(e.getValue());
            }
        }
        this.messageQueue.clear();
        this.statusPtr = 0;
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void setCallbackFunction(String callbackType, Object callbackObject) {
        String callbackFunction;
        CBK cbk = CBK.getCallback(callbackType);
        String string = callbackFunction = callbackObject instanceof String ? (String)callbackObject : null;
        if (cbk != null) {
            boolean isSync;
            String callback = CBK.getCallback(callbackType).name();
            Logger.info("StatusManager " + callback + "callback set f=" + callbackFunction);
            boolean bl = isSync = callbackFunction != null && callbackFunction.startsWith("SYNC:");
            if (isSync) {
                if (!callbackFunction.toLowerCase().trim().equals("sync:off")) {
                    this.jmolScriptCallbacks.put("SYNC:" + callback, "_");
                    Logger.info("SYNC callback for " + callback + " activated");
                    return;
                }
                this.jmolScriptCallbacks.remove("SYNC:" + callback);
                Logger.info("SYNC callback for " + callback + " deactivated");
            } else {
                int pt;
                String lc = "";
                int n = callbackFunction == null ? 0 : ((lc = callbackFunction.toLowerCase()).startsWith("script:") ? 7 : (pt = lc.startsWith("jmolscript:") ? 11 : 0));
                if (pt != 0) {
                    this.jmolScriptCallbacks.put(callback, callbackFunction.substring(pt).trim());
                    return;
                }
                if (callbackObject == null) {
                    this.jmolScriptCallbacks.remove(callback);
                }
            }
        }
        if (this.cbl != null) {
            this.cbl.setCallbackFunction(callbackType, (String)callbackObject);
        }
    }

    boolean notifyEnabled(CBK type) {
        return this.cbl != null && this.cbl.notifyEnabled(type);
    }

    private String getJmolScriptCallback(CBK callback) {
        return this.jmolScriptCallbacks.get(callback.name());
    }

    private void fireJmolScriptCallback(boolean isEnabled, CBK callback, Object[] o, boolean doWait) {
        String name = callback.name();
        if (o[0] != null) {
            Object[] params = new Object[o.length];
            System.arraycopy(o, 0, params, 0, o.length);
            String cmd = "try{\n" + params[0] + "\n}";
            params[0] = name;
            this.vwr.evalCallback(cmd, params, doWait);
        }
        if (this.jmolScriptCallbacks.containsKey("SYNC:" + callback.name())) {
            o[0] = "SYNC";
        }
        if (isEnabled) {
            this.cbl.notifyCallback(callback, o);
        }
    }

    synchronized void setStatusAppletReady(String htmlName, boolean isReady) {
        String sJmol = isReady ? this.getJmolScriptCallback(CBK.APPLETREADY) : null;
        boolean isEnabled = this.notifyEnabled(CBK.APPLETREADY);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.APPLETREADY, new Object[]{sJmol, htmlName, isReady, null}, true);
        }
    }

    synchronized void setStatusAtomMoved(BS bsMoved) {
        String sJmol = this.getJmolScriptCallback(CBK.ATOMMOVED);
        this.setStatusChanged("atomMoved", -1, bsMoved, false);
        boolean isEnabled = this.notifyEnabled(CBK.ATOMMOVED);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.ATOMMOVED, new Object[]{sJmol, bsMoved, bsMoved.cardinality()}, true);
        }
    }

    synchronized void setStatusSelect(BS atoms) {
        String sJmol = this.getJmolScriptCallback(CBK.SELECT);
        this.setStatusChanged("select", -1, atoms, false);
        boolean isEnabled = this.notifyEnabled(CBK.SELECT);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.SELECT, new Object[]{sJmol, atoms, atoms.cardinality(), atoms.nextSetBit(0), atoms.length()}, true);
        }
    }

    public void setStatusStructureModified(int atomIndex, int modelIndex, int mode, String msg, int n, BS bsAtoms) {
        if (atomIndex >= 0 && bsAtoms == null) {
            bsAtoms = BSUtil.newAndSetBit(atomIndex);
        }
        String sJmol = this.getJmolScriptCallback(CBK.STRUCTUREMODIFIED);
        boolean isEnabled = this.notifyEnabled(CBK.STRUCTUREMODIFIED);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.STRUCTUREMODIFIED, new Object[]{sJmol, mode, atomIndex, modelIndex, msg, n, bsAtoms}, true);
        }
    }

    synchronized void setStatusAtomPicked(int atomIndex, String strInfo, Map<String, Object> map) {
        String sJmol = this.getJmolScriptCallback(CBK.PICK);
        Logger.info("setStatusAtomPicked(" + atomIndex + "," + strInfo + ")");
        this.setStatusChanged("atomPicked", atomIndex, strInfo, false);
        boolean isEnabled = this.notifyEnabled(CBK.PICK);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.PICK, new Object[]{sJmol, strInfo, atomIndex, map}, true);
        }
    }

    synchronized int setStatusClicked(int x, int y, int action, int clickCount, int mode) {
        String sJmol = this.getJmolScriptCallback(CBK.CLICK);
        int[] m = new int[]{action, mode};
        boolean isEnabled = this.notifyEnabled(CBK.CLICK);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.CLICK, new Object[]{sJmol, x, y, action, clickCount, m}, true);
        }
        return m[0];
    }

    synchronized void setStatusResized(int width, int height) {
        String sJmol = this.getJmolScriptCallback(CBK.RESIZE);
        boolean isEnabled = this.notifyEnabled(CBK.RESIZE);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.RESIZE, new Object[]{sJmol, width, height}, true);
        }
    }

    boolean haveHoverCallback() {
        return this.jmolScriptCallbacks.containsKey(CBK.HOVER.name()) || this.notifyEnabled(CBK.HOVER);
    }

    synchronized void setStatusAtomHovered(int iatom, String strInfo) {
        String sJmol = this.getJmolScriptCallback(CBK.HOVER);
        boolean isEnabled = this.notifyEnabled(CBK.HOVER);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.HOVER, new Object[]{sJmol, strInfo, iatom}, true);
        }
    }

    synchronized void setStatusObjectHovered(String id, String strInfo, T3 pt) {
        String sJmol = this.getJmolScriptCallback(CBK.HOVER);
        boolean isEnabled = this.notifyEnabled(CBK.HOVER);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.HOVER, new Object[]{sJmol, strInfo, -1, id, Float.valueOf(pt.x), Float.valueOf(pt.y), Float.valueOf(pt.z)}, true);
        }
    }

    synchronized void showImage(String title, Object image) {
        String[] a = PT.split(title, "\u0001");
        title = a.length < 2 ? "Jmol" : (a.length < 3 || a[2].equals("null") ? a[1].substring(a[1].lastIndexOf("/") + 1) : a[2]);
        String sJmol = this.getJmolScriptCallback(CBK.IMAGE);
        boolean isEnabled = this.notifyEnabled(CBK.IMAGE);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.IMAGE, new Object[]{sJmol, title, image}, true);
        }
        if (Boolean.TRUE.equals(image)) {
            if (this.imageMap == null) {
                return;
            }
            Lst<String> lst = new Lst<String>();
            for (String key : this.imageMap.keySet()) {
                lst.addLast(key);
            }
            int i = lst.size();
            while (--i >= 0) {
                this.imageMap.get(lst.get(i)).closeMe();
            }
            return;
        }
        if (this.imageMap == null) {
            this.imageMap = new Hashtable<String, GenericImageDialog>();
        }
        GenericImageDialog d = this.imageMap.get(title);
        if (Boolean.FALSE.equals(image)) {
            if (d != null) {
                d.closeMe();
            }
            return;
        }
        if (d == null && image != null) {
            d = this.vwr.apiPlatform.getImageDialog(title, this.imageMap);
        }
        if (d == null) {
            return;
        }
        if (image == null) {
            d.closeMe();
        } else {
            d.setImage(image);
        }
    }

    synchronized void setFileLoadStatus(String fullPathName, String fileName, String modelName, String errorMsg, int ptLoad, boolean doCallback, Boolean isAsync) {
        boolean isEnabled;
        if (fullPathName == null && "resetUndo".equals(fileName)) {
            JmolAppConsoleInterface appConsole = (JmolAppConsoleInterface)this.vwr.getProperty("DATA_API", "getAppConsole", null);
            if (appConsole != null) {
                appConsole.zap();
            }
            fileName = this.vwr.getZapName();
        }
        this.setStatusChanged("fileLoaded", ptLoad, fullPathName, false);
        if (errorMsg != null) {
            this.setStatusChanged("fileLoadError", ptLoad, errorMsg, false);
        }
        String sJmol = this.getJmolScriptCallback(CBK.LOADSTRUCT);
        boolean bl = isEnabled = doCallback && this.notifyEnabled(CBK.LOADSTRUCT);
        if (isEnabled || sJmol != null) {
            String name = (String)this.vwr.getP("_smilesString");
            if (name.length() != 0) {
                fileName = name;
            }
            this.fireJmolScriptCallback(isEnabled, CBK.LOADSTRUCT, new Object[]{sJmol, fullPathName, fileName, modelName, errorMsg, ptLoad, this.vwr.getP("_modelNumber"), this.vwr.getModelNumberDotted(this.vwr.ms.mc - 1), isAsync}, true);
        }
    }

    synchronized void setStatusModelKit(int istate) {
        String state = istate == 1 ? "ON" : "OFF";
        this.setStatusChanged("modelkit", istate, state, false);
        String sJmol = this.getJmolScriptCallback(CBK.MODELKIT);
        boolean isEnabled = this.notifyEnabled(CBK.MODELKIT);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.MODELKIT, new Object[]{sJmol, state}, true);
        }
    }

    synchronized void setStatusFrameChanged(int fileNo, int modelNo, int firstNo, int lastNo, int currentFrame, float currentMorphModel, String entryName) {
        if (this.vwr.ms == null) {
            return;
        }
        boolean animating = this.vwr.am.animationOn;
        int frameNo = animating ? -2 - currentFrame : currentFrame;
        this.setStatusChanged("frameChanged", frameNo, currentFrame >= 0 ? this.vwr.getModelNumberDotted(currentFrame) : "", false);
        String sJmol = this.getJmolScriptCallback(CBK.ANIMFRAME);
        boolean isEnabled = this.notifyEnabled(CBK.ANIMFRAME);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.ANIMFRAME, new Object[]{sJmol, new int[]{frameNo, fileNo, modelNo, firstNo, lastNo, currentFrame}, entryName, Float.valueOf(currentMorphModel)}, false);
        }
        if (!animating && !this.vwr.isJSNoAWT) {
            this.vwr.checkMenuUpdate();
        }
    }

    synchronized boolean setStatusDragDropped(int mode, int x, int y, String fileName, String[] retType) {
        this.setStatusChanged("dragDrop", 0, "", false);
        String sJmol = this.getJmolScriptCallback(CBK.DRAGDROP);
        boolean isEnabled = this.notifyEnabled(CBK.DRAGDROP);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.DRAGDROP, new Object[]{sJmol, mode, x, y, fileName, retType}, true);
        }
        return isEnabled;
    }

    synchronized void setScriptEcho(String strEcho, boolean isScriptQueued) {
        if (strEcho == null || this.echoing) {
            return;
        }
        this.echoing = true;
        this.setStatusChanged("scriptEcho", 0, strEcho, false);
        String sJmol = this.getJmolScriptCallback(CBK.ECHO);
        boolean isEnabled = this.notifyEnabled(CBK.ECHO);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.ECHO, new Object[]{sJmol, strEcho, isScriptQueued ? 1 : 0}, true);
        }
        this.echoing = false;
    }

    synchronized void setStatusMeasuring(String status, int intInfo, String strMeasure, float value) {
        this.setStatusChanged(status, intInfo, strMeasure, false);
        String sJmol = null;
        if (status.equals("measureCompleted")) {
            Logger.info("measurement[" + intInfo + "] = " + strMeasure);
            sJmol = this.getJmolScriptCallback(CBK.MEASURE);
        } else if (status.equals("measurePicked")) {
            this.setStatusChanged("measurePicked", intInfo, strMeasure, false);
            Logger.info("measurePicked " + intInfo + " " + strMeasure);
        }
        boolean isEnabled = this.notifyEnabled(CBK.MEASURE);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.MEASURE, new Object[]{sJmol, strMeasure, intInfo, status, Float.valueOf(value)}, true);
        }
    }

    synchronized void notifyError(String errType, String errMsg, String errMsgUntranslated) {
        String sJmol = this.getJmolScriptCallback(CBK.ERROR);
        boolean isEnabled = this.notifyEnabled(CBK.ERROR);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.ERROR, new Object[]{sJmol, errType, errMsg, this.vwr.getShapeErrorState(), errMsgUntranslated}, true);
        }
    }

    synchronized void notifyMinimizationStatus(String minStatus, Integer minSteps, Float minEnergy, Float minEnergyDiff, String ff) {
        String sJmol = this.getJmolScriptCallback(CBK.MINIMIZATION);
        boolean isEnabled = this.notifyEnabled(CBK.MINIMIZATION);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.MINIMIZATION, new Object[]{sJmol, minStatus, minSteps, minEnergy, minEnergyDiff, ff}, true);
        }
    }

    synchronized void setScriptStatus(String strStatus, String statusMessage, int msWalltime, String strErrorMessageUntranslated) {
        boolean isScriptCompletion;
        if (msWalltime < -1) {
            int iscript = -2 - msWalltime;
            this.setStatusChanged("scriptStarted", iscript, statusMessage, false);
            strStatus = "script " + iscript + " started";
        } else if (strStatus == null) {
            return;
        }
        String sJmol = msWalltime == 0 ? this.getJmolScriptCallback(CBK.SCRIPT) : null;
        boolean bl = isScriptCompletion = strStatus == "Script completed";
        if (this.recordStatus("script")) {
            boolean isError = strErrorMessageUntranslated != null;
            this.setStatusChanged(isError ? "scriptError" : "scriptStatus", 0, strStatus, false);
            if (isError || isScriptCompletion) {
                this.setStatusChanged("scriptTerminated", 1, "Jmol script terminated" + (isError ? " unsuccessfully: " + strStatus : " successfully"), false);
            }
        }
        if (isScriptCompletion && this.vwr.getBoolean(603979879) && this.vwr.getBoolean(603979825)) {
            strStatus = this.vwr.getChimeMessenger().scriptCompleted(this, statusMessage, strErrorMessageUntranslated);
        }
        Object[] data = new Object[]{sJmol, strStatus, statusMessage, isScriptCompletion ? -1 : msWalltime, strErrorMessageUntranslated};
        boolean isEnabled = this.notifyEnabled(CBK.SCRIPT);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.SCRIPT, data, true);
        }
        this.processScript(data);
    }

    void processScript(Object[] data) {
        int msWalltime = (Integer)data[3];
        this.vwr.notifyScriptEditor(msWalltime, data);
        if (msWalltime == 0) {
            this.vwr.sendConsoleMessage(data[1] == null ? null : data[1].toString());
        }
    }

    boolean doSync() {
        return this.isSynced && this.drivingSync && !this.syncDisabled;
    }

    synchronized void setSync(String mouseCommand) {
        if (this.syncingMouse) {
            if (mouseCommand != null) {
                String sJmol = this.getJmolScriptCallback(CBK.SYNC);
                if (sJmol != null) {
                    this.fireJmolScriptCallback(false, CBK.SYNC, new Object[]{sJmol, mouseCommand, "sending mouseSync"}, true);
                }
                this.syncSend(mouseCommand, "*", 0);
            }
        } else if (!this.syncingScripts) {
            this.syncSend("!" + this.vwr.tm.getMoveToText((float)this.minSyncRepeatMs / 1000.0f, false), "*", 0);
        }
    }

    void setSyncDriver(int syncMode) {
        if (this.stereoSync && syncMode != 4) {
            this.syncSend("SET_GRAPHICS_OFF", "*", 0);
            this.stereoSync = false;
        }
        switch (syncMode) {
            case 4: {
                if (!this.syncDisabled) {
                    return;
                }
                this.syncDisabled = false;
                break;
            }
            case 3: {
                this.syncDisabled = true;
                break;
            }
            case 5: {
                this.drivingSync = true;
                this.isSynced = true;
                this.stereoSync = true;
                break;
            }
            case 1: {
                this.drivingSync = true;
                this.isSynced = true;
                break;
            }
            case 2: {
                this.drivingSync = false;
                this.isSynced = true;
                break;
            }
            default: {
                this.drivingSync = false;
                this.isSynced = false;
            }
        }
        if (Logger.debugging) {
            Logger.debug(this.vwr.appletName + " sync mode=" + syncMode + "; synced? " + this.isSynced + "; driving? " + this.drivingSync + "; disabled? " + this.syncDisabled);
        }
    }

    public Object syncSend(String script, Object appletNameOrProp, int port) {
        if (port != 0 || this.notifyEnabled(CBK.SYNC)) {
            Object[] o = new Object[]{null, script, appletNameOrProp, port};
            if (this.cbl != null) {
                this.cbl.notifyCallback(CBK.SYNC, o);
            }
            return o[0];
        }
        return null;
    }

    public Object processService(Map<String, Object> info) {
        Object s = info.get("service");
        if (s == null) {
            return null;
        }
        if (s instanceof SV) {
            Hashtable<String, Object> m = new Hashtable<String, Object>();
            for (Map.Entry<String, Object> e : info.entrySet()) {
                m.put(e.getKey(), SV.oValue(e.getValue()));
            }
            info = m;
        }
        if (this.notifyEnabled(CBK.SERVICE)) {
            this.cbl.notifyCallback(CBK.SERVICE, new Object[]{null, info});
        }
        return info;
    }

    public int getSyncMode() {
        return !this.isSynced ? 0 : (this.drivingSync ? 1 : 2);
    }

    synchronized void showUrl(String urlString) {
        if (this.jsl != null) {
            this.jsl.showUrl(urlString);
        }
    }

    public synchronized void clearConsole() {
        this.vwr.sendConsoleMessage(null);
        if (this.jsl != null) {
            this.cbl.notifyCallback(CBK.MESSAGE, null);
        }
    }

    float[][] functionXY(String functionName, int nX, int nY) {
        return this.jsl == null ? new float[Math.abs(nX)][Math.abs(nY)] : this.jsl.functionXY(functionName, nX, nY);
    }

    float[][][] functionXYZ(String functionName, int nX, int nY, int nZ) {
        return this.jsl == null ? new float[Math.abs(nX)][Math.abs(nY)][Math.abs(nY)] : this.jsl.functionXYZ(functionName, nX, nY, nZ);
    }

    String jsEval(String strEval) {
        return this.jsl == null ? "" : this.jsl.eval(strEval);
    }

    String createImage(String fileNameOrError, String type, String text, byte[] bytes, int quality) {
        return this.jsl == null ? null : this.jsl.createImage(fileNameOrError, type, text == null ? bytes : (byte[])text, quality);
    }

    Map<String, Object> getRegistryInfo() {
        return this.jsl == null ? null : this.jsl.getRegistryInfo();
    }

    String dialogAsk(String type, String fileName, Map<String, Object> params) {
        boolean isImage = type.equals("Save Image");
        JmolDialogInterface sd = (JmolDialogInterface)Interface.getOption("dialog.Dialog", this.vwr, "status");
        if (sd == null) {
            return null;
        }
        sd.setupUI(false);
        if (isImage) {
            sd.setImageInfo(this.qualityJPG, this.qualityPNG, this.imageType);
        }
        String outputFileName = sd.getFileNameFromDialog(this.vwr, type, fileName);
        if (isImage && outputFileName != null) {
            this.qualityJPG = sd.getQuality("JPG");
            this.qualityPNG = sd.getQuality("PNG");
            String sType = sd.getType();
            if (params != null) {
                params.put("qualityJPG", this.qualityJPG);
                params.put("qualityPNG", this.qualityPNG);
                if (sType != null) {
                    params.put("dialogImageType", sType);
                }
            }
            if (sType != null) {
                this.imageType = sType;
            }
        }
        return outputFileName;
    }

    Map<String, Object> getJspecViewProperties(String myParam) {
        return this.jsl == null ? null : this.jsl.getJSpecViewProperty(myParam == null || myParam.length() == 0 ? "" : ":" + myParam);
    }

    public int[] resizeInnerPanel(int width, int height) {
        int[] nArray;
        if (this.jsl == null || width == this.vwr.getScreenWidth() && height == this.vwr.getScreenHeight()) {
            int[] nArray2 = new int[2];
            nArray2[0] = width;
            nArray = nArray2;
            nArray2[1] = height;
        } else {
            nArray = this.jsl.resizeInnerPanel("preferredWidthHeight " + width + " " + height + ";");
        }
        return nArray;
    }

    public void resizeInnerPanelString(String data) {
        if (this.jsl != null) {
            this.jsl.resizeInnerPanel(data);
        }
    }

    public void registerAudio(String id, Map<String, Object> htParams) {
        this.stopAudio(id);
        if (this.audios == null) {
            this.audios = new Hashtable<String, JmolAudioPlayer>();
        }
        if (htParams == null) {
            this.audios.remove(id);
        } else {
            this.audios.put(id, (JmolAudioPlayer)htParams.get("audioPlayer"));
        }
    }

    private void stopAudio(String id) {
        if (this.audios == null) {
            return;
        }
        JmolAudioPlayer player = this.audios.get(id);
        if (player != null) {
            player.action("kill");
        }
    }

    public void playAudio(Map<String, Object> htParams) {
        if (!this.vwr.getBoolean(603979797)) {
            if (htParams == null) {
                return;
            }
            htParams.put("status", "close");
            Logger.info("allowAudio is set false");
            this.notifyAudioStatus(htParams);
            return;
        }
        try {
            String id;
            String action = htParams == null ? "close" : (String)htParams.get("action");
            String string = id = htParams == null ? null : (String)htParams.get("id");
            if (action != null && action.length() > 0) {
                if (id == null || id.length() == 0) {
                    if (this.audios == null || this.audios.isEmpty()) {
                        return;
                    }
                    if (action.equals("close")) {
                        for (String key : this.audios.keySet()) {
                            JmolAudioPlayer player = this.audios.remove(key);
                            player.action("close");
                        }
                    }
                    return;
                }
                JmolAudioPlayer player = this.audios.get(id);
                if (player != null) {
                    player.action(action);
                    return;
                }
            }
            try {
                ((JmolAudio)Interface.getInterface("org.jmol.util.JmolAudio", this.vwr, "script")).playAudio(this.vwr, htParams);
            }
            catch (Exception e) {
                Logger.info(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void notifyAudioStatus(Map<String, Object> htParams) {
        String status = (String)htParams.get("status");
        String script = (String)htParams.get(status);
        if (script != null) {
            this.vwr.script(script);
        }
        if (status == "ended") {
            this.registerAudio((String)htParams.get("id"), null);
        }
        String sJmol = this.getJmolScriptCallback(CBK.AUDIO);
        boolean isEnabled = this.notifyEnabled(CBK.AUDIO);
        if (isEnabled || sJmol != null) {
            this.fireJmolScriptCallback(isEnabled, CBK.AUDIO, new Object[]{sJmol, htParams, status}, true);
        }
    }

    void syncScript(String script, String applet, int port) {
        if ("GET_GRAPHICS".equalsIgnoreCase(script)) {
            this.setSyncDriver(5);
            this.syncSend(script, applet, 0);
            this.vwr.setBooleanProperty("_syncMouse", false);
            this.vwr.setBooleanProperty("_syncScript", false);
            return;
        }
        if ("=".equals(applet)) {
            applet = "~";
            this.setSyncDriver(2);
        }
        boolean disableSend = "~".equals(applet);
        if (port > 0 || !disableSend && !".".equals(applet)) {
            this.syncSend(script, applet, port);
            if (!"*".equals(applet) || script.startsWith("{")) {
                return;
            }
        }
        if (script.equalsIgnoreCase("on") || script.equalsIgnoreCase("true")) {
            this.setSyncDriver(1);
            return;
        }
        if (script.equalsIgnoreCase("off") || script.equalsIgnoreCase("false")) {
            this.setSyncDriver(0);
            return;
        }
        if (script.equalsIgnoreCase("slave")) {
            this.setSyncDriver(2);
            return;
        }
        int syncMode = this.getSyncMode();
        if (syncMode == 0) {
            return;
        }
        if (syncMode != 1) {
            disableSend = false;
        }
        if (Logger.debugging) {
            Logger.debug(this.vwr.htmlName + " syncing with script: " + script);
        }
        if (disableSend) {
            this.setSyncDriver(3);
        }
        if (script.indexOf("Mouse: ") != 0) {
            int serviceMode = JC.getServiceCommand(script);
            switch (serviceMode) {
                case 42: 
                case 49: 
                case 56: 
                case 63: 
                case 70: {
                    this.syncSend(script, ".", port);
                    return;
                }
                case -1: {
                    break;
                }
                case 0: 
                case 28: 
                case 35: 
                case 77: {
                    if (disableSend) {
                        return;
                    }
                }
                case 7: 
                case 14: 
                case 21: {
                    script = this.vwr.getJSV().processSync(script, serviceMode);
                    if (script != null) break;
                    return;
                }
            }
            this.vwr.evalStringQuietSync(script, true, false);
            return;
        }
        this.mouseScript(script);
        if (disableSend) {
            this.vwr.setSyncDriver(4);
        }
    }

    void mouseScript(String script) {
        String[] tokens = PT.getTokens(script);
        String key = tokens[1];
        try {
            key = (key.toLowerCase() + "...............").substring(0, 15);
            switch ("zoombyfactor...zoomby.........rotatezby......rotatexyby.....translatexyby..rotatemolecule.spinxyby.......rotatearcball..".indexOf(key)) {
                case 0: {
                    switch (tokens.length) {
                        case 3: {
                            this.vwr.zoomByFactor(PT.parseFloat(tokens[2]), Integer.MAX_VALUE, Integer.MAX_VALUE);
                            return;
                        }
                        case 5: {
                            this.vwr.zoomByFactor(PT.parseFloat(tokens[2]), PT.parseInt(tokens[3]), PT.parseInt(tokens[4]));
                            return;
                        }
                    }
                    break;
                }
                case 15: {
                    switch (tokens.length) {
                        case 3: {
                            this.vwr.zoomBy(PT.parseInt(tokens[2]));
                            return;
                        }
                    }
                    break;
                }
                case 30: {
                    switch (tokens.length) {
                        case 3: {
                            this.vwr.rotateZBy(PT.parseInt(tokens[2]), Integer.MAX_VALUE, Integer.MAX_VALUE);
                            return;
                        }
                        case 5: {
                            this.vwr.rotateZBy(PT.parseInt(tokens[2]), PT.parseInt(tokens[3]), PT.parseInt(tokens[4]));
                        }
                    }
                    break;
                }
                case 45: {
                    this.vwr.rotateXYBy(PT.parseFloat(tokens[2]), PT.parseFloat(tokens[3]));
                    return;
                }
                case 60: {
                    this.vwr.translateXYBy(PT.parseInt(tokens[2]), PT.parseInt(tokens[3]));
                    return;
                }
                case 75: {
                    this.vwr.rotateSelected(PT.parseFloat(tokens[2]), PT.parseFloat(tokens[3]), null);
                    return;
                }
                case 90: {
                    this.vwr.spinXYBy(PT.parseInt(tokens[2]), PT.parseInt(tokens[3]), PT.parseFloat(tokens[4]));
                    return;
                }
                case 105: {
                    this.vwr.rotateXYBy(PT.parseInt(tokens[2]), PT.parseInt(tokens[3]));
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.vwr.showString("error reading SYNC command: " + script, false);
    }
}

