/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.anno.TypePopulator;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DescriptorInfo;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.Opcodes;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ClassDefiningJRubyClassLoader;
import org.jruby.util.CodegenUtils;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class InvocationMethodFactory
extends MethodFactory
implements Opcodes {
    private static final Logger LOG = LoggerFactory.getLogger(InvocationMethodFactory.class);
    private static final boolean DEBUG = false;
    private static final String COMPILED_CALL_SIG = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class));
    private static final String COMPILED_CALL_SIG_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class));
    private static final String COMPILED_CALL_SIG_ZERO_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, Block.class));
    private static final String COMPILED_CALL_SIG_ZERO = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class));
    private static final String COMPILED_CALL_SIG_ONE_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_ONE = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class));
    private static final String COMPILED_CALL_SIG_TWO_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_TWO = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class));
    private static final String COMPILED_CALL_SIG_THREE_BLOCK = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
    private static final String COMPILED_CALL_SIG_THREE = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
    private static final String JAVA_SUPER_SIG = CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, Visibility.class, String.class));
    public static final int THIS_INDEX = 0;
    public static final int THREADCONTEXT_INDEX = 1;
    public static final int RECEIVER_INDEX = 2;
    public static final int CLASS_INDEX = 3;
    public static final int NAME_INDEX = 4;
    public static final int ARGS_INDEX = 5;
    public static final int BLOCK_INDEX = 6;
    protected final ClassDefiningJRubyClassLoader classLoader;
    protected final Object syncObject;
    private boolean seenUndefinedClasses = false;
    private boolean haveWarnedUser = false;
    private static final Class[] RubyModule_and_Visibility_and_Name = new Class[]{RubyModule.class, Visibility.class, String.class};
    @Deprecated
    private static final Class[] RubyModule_and_Visibility = new Class[]{RubyModule.class, Visibility.class};

    public InvocationMethodFactory(ClassLoader classLoader) {
        this.syncObject = classLoader;
        this.classLoader = classLoader instanceof ClassDefiningJRubyClassLoader ? (ClassDefiningJRubyClassLoader)classLoader : new ClassDefiningJRubyClassLoader(classLoader);
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, List<JavaMethodDescriptor> descs, String name2) {
        JavaMethodDescriptor desc1 = descs.get(0);
        String javaMethodName = desc1.name;
        try {
            Class c = this.getAnnotatedMethodClass(descs);
            DescriptorInfo info = new DescriptorInfo(descs);
            JavaMethod ic = this.constructJavaMethod(implementationClass, desc1, name2, c);
            TypePopulator.populateMethod(ic, Arity.optional().getValue(), javaMethodName, desc1.isStatic, desc1.anno.notImplemented(), implementationClass.getRuntime().isBootingCore(), desc1.declaringClass, desc1.name, desc1.returnClass, desc1.parameters);
            return ic;
        }
        catch (Exception e) {
            LOG.error(e);
            throw implementationClass.getRuntime().newLoadError(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getAnnotatedMethodClass(List<JavaMethodDescriptor> descs) {
        DescriptorInfo info;
        Class superclass2;
        String generatedClassPath;
        Class c;
        JavaMethodDescriptor desc1 = descs.get(0);
        if (!Modifier.isPublic(desc1.declaringClass.getModifiers())) {
            LOG.warn("binding non-public class {} reflected handles won't work", desc1.declaringClassName);
        }
        String javaMethodName = desc1.name;
        String generatedClassName = CodegenUtils.getAnnotatedBindingClassName(javaMethodName, (CharSequence)desc1.declaringClassName, desc1.isStatic, desc1.actualRequired, desc1.optional, descs.size() > 1, desc1.anno.frame());
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            generatedClassName = generatedClassName + "_DBG";
        }
        if ((c = this.tryClass(generatedClassName, generatedClassPath = generatedClassName.replace('.', '/'), desc1.declaringClass, superclass2 = InvocationMethodFactory.determineSuperclass(info = new DescriptorInfo(descs)))) == null) {
            Object object = this.syncObject;
            synchronized (object) {
                c = this.tryClass(generatedClassName, generatedClassPath, desc1.declaringClass, superclass2);
                if (c == null) {
                    String superClassString = CodegenUtils.p(superclass2);
                    ClassWriter cw = InvocationMethodFactory.createJavaMethodCtor(generatedClassPath, superClassString, info.getParameterDesc());
                    this.addAnnotatedMethodInvoker(cw, superClassString, descs, info.acceptsKeywords());
                    c = this.endClass(cw, generatedClassName);
                }
            }
        }
        return c;
    }

    private static Class determineSuperclass(DescriptorInfo info) {
        Class<Object> superClass = info.getMin() == -1 ? (info.isBlock() ? JavaMethod.JavaMethodNBlock.class : JavaMethod.JavaMethodN.class) : (info.isRest() ? (info.isBlock() ? JavaMethod.BLOCK_REST_METHODS[info.getMin()][info.getMax()] : JavaMethod.REST_METHODS[info.getMin()][info.getMax()]) : (info.isBlock() ? JavaMethod.BLOCK_METHODS[info.getMin()][info.getMax()] : JavaMethod.METHODS[info.getMin()][info.getMax()]));
        if (superClass == null) {
            throw new RuntimeException("invalid multi combination");
        }
        return superClass;
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, JavaMethodDescriptor desc, String name2) {
        String javaMethodName = desc.name;
        try {
            Class c = this.getAnnotatedMethodClass(Collections.singletonList(desc));
            JavaMethod ic = this.constructJavaMethod(implementationClass, desc, name2, c);
            TypePopulator.populateMethod(ic, Arity.fromAnnotation(desc.anno, desc.actualRequired).getValue(), javaMethodName, desc.isStatic, desc.anno.notImplemented(), implementationClass.getRuntime().isBootingCore(), desc.declaringClass, desc.name, desc.returnClass, desc.parameters);
            return ic;
        }
        catch (Exception e) {
            LOG.error(e);
            throw implementationClass.getRuntime().newLoadError(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaMethod constructJavaMethod(RubyModule implementationClass, JavaMethodDescriptor desc, String name2, Class c) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        JavaMethod ic;
        DynamicMethod.Version version = c.getAnnotation(DynamicMethod.Version.class);
        if (version == null) {
            JavaMethod.NAME_PASSER.set(name2);
            try {
                ic = (JavaMethod)c.getConstructor(RubyModule_and_Visibility).newInstance(new Object[]{implementationClass, desc.anno.visibility()});
            }
            finally {
                JavaMethod.NAME_PASSER.remove();
            }
        } else {
            ic = (JavaMethod)c.getConstructor(RubyModule_and_Visibility_and_Name).newInstance(new Object[]{implementationClass, desc.anno.visibility(), name2});
        }
        return ic;
    }

    private static void checkArity(JRubyMethod jrubyMethod, SkinnyMethodAdapter method2, int specificArity) {
        switch (specificArity) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        Label arityError = new Label();
        Label noArityError = new Label();
        boolean checkArity = false;
        if (jrubyMethod.rest()) {
            if (jrubyMethod.required() > 0) {
                method2.aload(5);
                method2.arraylength();
                method2.ldc(jrubyMethod.required());
                method2.if_icmplt(arityError);
                checkArity = true;
            }
        } else if (jrubyMethod.optional() > 0) {
            if (jrubyMethod.required() > 0) {
                method2.aload(5);
                method2.arraylength();
                method2.ldc(jrubyMethod.required());
                method2.if_icmplt(arityError);
            }
            method2.aload(5);
            method2.arraylength();
            method2.ldc(jrubyMethod.required() + jrubyMethod.optional());
            method2.if_icmpgt(arityError);
            checkArity = true;
        } else {
            method2.aload(5);
            method2.arraylength();
            method2.ldc(jrubyMethod.required());
            method2.if_icmpne(arityError);
            checkArity = true;
        }
        if (checkArity) {
            method2.go_to(noArityError);
            method2.label(arityError);
            method2.aload(1);
            method2.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            method2.aload(5);
            method2.ldc(jrubyMethod.required());
            method2.ldc(jrubyMethod.required() + jrubyMethod.optional());
            method2.invokestatic(CodegenUtils.p(Arity.class), "checkArgumentCount", CodegenUtils.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
            method2.pop();
            method2.label(noArityError);
        }
    }

    private static ClassWriter createJavaMethodCtor(String namePath, String sup, String parameterDesc) {
        ClassWriter cw = new ClassWriter(3);
        String sourceFile = namePath.substring(namePath.lastIndexOf(47) + 1) + ".gen";
        cw.visit(RubyInstanceConfig.JAVA_VERSION, 33, namePath, null, sup, null);
        cw.visitSource(sourceFile, null);
        AnnotationVisitor av = cw.visitAnnotation(CodegenUtils.ci(DynamicMethod.Version.class), true);
        av.visit("version", 0);
        av.visitEnd();
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cw, 1, "<init>", JAVA_SUPER_SIG, null, null);
        mv.start();
        mv.aloadMany(0, 1, 2, 3);
        mv.invokespecial(sup, "<init>", JAVA_SUPER_SIG);
        mv.aload(0);
        mv.ldc(parameterDesc.toString());
        mv.invokevirtual(CodegenUtils.p(JavaMethod.class), "setParameterDesc", CodegenUtils.sig(Void.TYPE, String.class));
        mv.voidreturn();
        mv.end();
        return cw;
    }

    private void invokeCallConfigPre(SkinnyMethodAdapter mv, String superClass, int specificArity, boolean block, CallConfiguration callConfig) {
        if (callConfig.isNoop()) {
            return;
        }
        InvocationMethodFactory.prepareForPre(mv, specificArity, block, callConfig);
        mv.invokevirtual(superClass, InvocationMethodFactory.getPreMethod(callConfig), InvocationMethodFactory.getPreSignature(callConfig));
    }

    private void invokeCallConfigPost(SkinnyMethodAdapter mv, String superClass, CallConfiguration callConfig) {
        if (callConfig.isNoop()) {
            return;
        }
        mv.aload(1);
        mv.invokestatic(superClass, InvocationMethodFactory.getPostMethod(callConfig), CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class)));
    }

    private static void prepareForPre(SkinnyMethodAdapter mv, int specificArity, boolean block, CallConfiguration callConfig) {
        if (callConfig.isNoop()) {
            return;
        }
        mv.aloadMany(0, 1);
        switch (callConfig.framing()) {
            case Full: {
                mv.aloadMany(2, 3, 4);
                InvocationMethodFactory.loadBlockForPre(mv, specificArity, block);
                break;
            }
            case Backtrace: {
                mv.aload(4);
                break;
            }
            case None: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown call configuration");
            }
        }
    }

    private static String getPreMethod(CallConfiguration callConfig) {
        switch (callConfig) {
            case FrameFullScopeFull: {
                return "preFrameAndScope";
            }
            case FrameFullScopeDummy: {
                return "preFrameAndDummyScope";
            }
            case FrameFullScopeNone: {
                return "preFrameOnly";
            }
            case FrameBacktraceScopeFull: {
                return "preBacktraceAndScope";
            }
            case FrameBacktraceScopeDummy: {
                return "preBacktraceDummyScope";
            }
            case FrameBacktraceScopeNone: {
                return "preBacktraceOnly";
            }
            case FrameNoneScopeFull: {
                return "preScopeOnly";
            }
            case FrameNoneScopeDummy: {
                return "preNoFrameDummyScope";
            }
            case FrameNoneScopeNone: {
                return "preNoop";
            }
        }
        throw new RuntimeException("Unknown call configuration");
    }

    private static String getPreSignature(CallConfiguration callConfig) {
        switch (callConfig) {
            case FrameFullScopeFull: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, Block.class));
            }
            case FrameFullScopeDummy: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, Block.class));
            }
            case FrameFullScopeNone: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, Block.class));
            }
            case FrameBacktraceScopeFull: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class));
            }
            case FrameBacktraceScopeDummy: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class));
            }
            case FrameBacktraceScopeNone: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class));
            }
            case FrameNoneScopeFull: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class));
            }
            case FrameNoneScopeDummy: {
                return CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class));
            }
            case FrameNoneScopeNone: {
                return CodegenUtils.sig(Void.TYPE, new Class[0]);
            }
        }
        throw new RuntimeException("Unknown call configuration");
    }

    public static String getPostMethod(CallConfiguration callConfig) {
        switch (callConfig) {
            case FrameFullScopeFull: {
                return "postFrameAndScope";
            }
            case FrameFullScopeDummy: {
                return "postFrameAndScope";
            }
            case FrameFullScopeNone: {
                return "postFrameOnly";
            }
            case FrameBacktraceScopeFull: {
                return "postBacktraceAndScope";
            }
            case FrameBacktraceScopeDummy: {
                return "postBacktraceDummyScope";
            }
            case FrameBacktraceScopeNone: {
                return "postBacktraceOnly";
            }
            case FrameNoneScopeFull: {
                return "postScopeOnly";
            }
            case FrameNoneScopeDummy: {
                return "postNoFrameDummyScope";
            }
            case FrameNoneScopeNone: {
                return "postNoop";
            }
        }
        throw new RuntimeException("Unknown call configuration");
    }

    private static void loadArguments(SkinnyMethodAdapter mv, JavaMethodDescriptor desc, int specificArity) {
        switch (specificArity) {
            default: {
                mv.aload(5);
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                Class[] argumentTypes = desc.getArgumentTypes();
                InvocationMethodFactory.loadArgumentWithCast(mv, 1, argumentTypes[0]);
                break;
            }
            case 2: {
                Class[] argumentTypes = desc.getArgumentTypes();
                InvocationMethodFactory.loadArgumentWithCast(mv, 1, argumentTypes[0]);
                InvocationMethodFactory.loadArgumentWithCast(mv, 2, argumentTypes[1]);
                break;
            }
            case 3: {
                Class[] argumentTypes = desc.getArgumentTypes();
                InvocationMethodFactory.loadArgumentWithCast(mv, 1, argumentTypes[0]);
                InvocationMethodFactory.loadArgumentWithCast(mv, 2, argumentTypes[1]);
                InvocationMethodFactory.loadArgumentWithCast(mv, 3, argumentTypes[2]);
            }
        }
    }

    private static void loadArgumentWithCast(SkinnyMethodAdapter mv, int argNumber, Class coerceType) {
        mv.aload(5 + (argNumber - 1));
        if (coerceType != IRubyObject.class && coerceType != IRubyObject[].class) {
            if (coerceType == RubyString.class) {
                mv.invokeinterface(CodegenUtils.p(IRubyObject.class), "convertToString", CodegenUtils.sig(RubyString.class, new Class[0]));
            } else {
                throw new RuntimeException("Unknown coercion target: " + coerceType);
            }
        }
    }

    private static void loadBlockForPre(SkinnyMethodAdapter mv, int specificArity, boolean getsBlock) {
        if (!getsBlock) {
            mv.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            return;
        }
        InvocationMethodFactory.loadBlock(mv, specificArity, getsBlock);
    }

    private static void loadBlock(SkinnyMethodAdapter mv, int specificArity, boolean getsBlock) {
        if (!getsBlock) {
            return;
        }
        switch (specificArity) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                mv.aload(5 + specificArity);
                break;
            }
            default: {
                mv.aload(6);
            }
        }
    }

    private static void loadReceiver(String typePath, JavaMethodDescriptor desc, SkinnyMethodAdapter mv) {
        if (Modifier.isStatic(desc.modifiers)) {
            if (desc.hasContext) {
                mv.aload(1);
            }
            mv.aload(2);
        } else {
            mv.aload(2);
            mv.checkcast(typePath);
            if (desc.hasContext) {
                mv.aload(1);
            }
        }
    }

    private Class tryClass(String name2, String path2, Class targetClass, Class expectedSuperclass) {
        Class<?> c;
        try {
            if (!this.classLoader.hasClass(name2)) {
                this.seenUndefinedClasses = true;
                return null;
            }
            c = this.classLoader.loadClass(name2);
        }
        catch (ClassNotFoundException e) {
            this.seenUndefinedClasses = true;
            return null;
        }
        catch (Exception e) {
            this.seenUndefinedClasses = true;
            return null;
        }
        if (c.getSuperclass() == expectedSuperclass) {
            if (this.seenUndefinedClasses && !this.haveWarnedUser) {
                this.haveWarnedUser = true;
                System.err.println("WARNING: while creating new bindings for " + targetClass + ",\nfound an existing binding; you may want to run a clean build.");
            }
            return c;
        }
        this.seenUndefinedClasses = true;
        return null;
    }

    protected Class endClass(ClassWriter cw, String name2) {
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        return this.classLoader.defineClass(name2, code);
    }

    private SkinnyMethodAdapter beginMethod(ClassWriter cw, String methodName, int specificArity, boolean block) {
        switch (specificArity) {
            default: {
                if (block) {
                    return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_BLOCK, null, null);
                }
                return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG, null, null);
            }
            case 0: {
                if (block) {
                    return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_ZERO_BLOCK, null, null);
                }
                return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_ZERO, null, null);
            }
            case 1: {
                if (block) {
                    return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_ONE_BLOCK, null, null);
                }
                return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_ONE, null, null);
            }
            case 2: {
                if (block) {
                    return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_TWO_BLOCK, null, null);
                }
                return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_TWO, null, null);
            }
            case 3: 
        }
        if (block) {
            return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_THREE_BLOCK, null, null);
        }
        return new SkinnyMethodAdapter(cw, 1, methodName, COMPILED_CALL_SIG_THREE, null, null);
    }

    private void addAnnotatedMethodInvoker(ClassWriter cw, String superClass, List<JavaMethodDescriptor> descs, boolean acceptsKeywords) {
        for (JavaMethodDescriptor desc : descs) {
            int specificArity = desc.calculateSpecificCallArity();
            SkinnyMethodAdapter mv = this.beginMethod(cw, "call", specificArity, desc.hasBlock);
            mv.visitCode();
            this.createAnnotatedMethodInvocation(desc, mv, superClass, specificArity, desc.hasBlock, acceptsKeywords);
            mv.end();
        }
    }

    private void createAnnotatedMethodInvocation(JavaMethodDescriptor desc, SkinnyMethodAdapter method2, String superClass, int specificArity, boolean block, boolean acceptsKeywords) {
        CallConfiguration callConfig;
        String typePath = desc.declaringClassPath;
        String javaMethodName = desc.name;
        if (!acceptsKeywords) {
            method2.aload(1);
            method2.ldc(0);
            method2.putfield("org/jruby/runtime/ThreadContext", "callInfo", "I");
        }
        if (desc.anno.checkArity()) {
            InvocationMethodFactory.checkArity(desc.anno, method2, specificArity);
        }
        if (!(callConfig = CallConfiguration.getCallConfigByAnno(desc.anno)).isNoop()) {
            this.invokeCallConfigPre(method2, superClass, specificArity, block, callConfig);
        }
        boolean FULL_TRACE_ENABLED = RubyInstanceConfig.FULL_TRACE_ENABLED;
        int traceBoolIndex = -1;
        if (FULL_TRACE_ENABLED) {
            switch (specificArity) {
                case -1: {
                    traceBoolIndex = 5 + (block ? 1 : 0) + 1;
                    break;
                }
                case 0: {
                    traceBoolIndex = 5 + (block ? 1 : 0);
                    break;
                }
                default: {
                    traceBoolIndex = 5 + specificArity + (block ? 1 : 0) + 1;
                }
            }
            method2.aload(1);
            method2.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class, new Class[0]));
            method2.invokevirtual(CodegenUtils.p(Ruby.class), "hasEventHooks", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
            method2.istore(traceBoolIndex);
            InvocationMethodFactory.invokeCCallTrace(method2, traceBoolIndex);
        }
        Label tryBegin = new Label();
        Label tryEnd = new Label();
        Label doFinally = new Label();
        if (!callConfig.isNoop()) {
            method2.trycatch(tryBegin, tryEnd, doFinally, null);
        }
        method2.label(tryBegin);
        InvocationMethodFactory.loadReceiver(typePath, desc, method2);
        InvocationMethodFactory.loadArguments(method2, desc, specificArity);
        InvocationMethodFactory.loadBlock(method2, specificArity, block);
        if (Modifier.isStatic(desc.modifiers)) {
            method2.invokestatic(typePath, javaMethodName, CodegenUtils.sig(desc.returnClass, desc.parameters));
        } else {
            method2.invokevirtual(typePath, javaMethodName, CodegenUtils.sig(desc.returnClass, desc.parameters));
        }
        if (desc.returnClass == Void.TYPE) {
            method2.aload(1);
            method2.getfield(CodegenUtils.p(ThreadContext.class), "nil", CodegenUtils.ci(IRubyObject.class));
        }
        method2.label(tryEnd);
        if (FULL_TRACE_ENABLED) {
            InvocationMethodFactory.invokeCReturnTrace(method2, traceBoolIndex);
        }
        if (!callConfig.isNoop()) {
            this.invokeCallConfigPost(method2, superClass, callConfig);
        }
        method2.visitInsn(176);
        if (!callConfig.isNoop()) {
            method2.label(doFinally);
            if (FULL_TRACE_ENABLED) {
                InvocationMethodFactory.invokeCReturnTrace(method2, traceBoolIndex);
            }
            if (!callConfig.isNoop()) {
                this.invokeCallConfigPost(method2, superClass, callConfig);
            }
            method2.athrow();
        }
    }

    private static void invokeCCallTrace(SkinnyMethodAdapter method2, int traceBoolIndex) {
        method2.aloadMany(0, 1);
        method2.iload(traceBoolIndex);
        method2.aload(4);
        method2.invokevirtual(CodegenUtils.p(JavaMethod.class), "callTrace", CodegenUtils.sig(Void.TYPE, ThreadContext.class, Boolean.TYPE, String.class));
    }

    private static void invokeCReturnTrace(SkinnyMethodAdapter method2, int traceBoolIndex) {
        method2.aloadMany(0, 1);
        method2.iload(traceBoolIndex);
        method2.aload(4);
        method2.invokevirtual(CodegenUtils.p(JavaMethod.class), "returnTrace", CodegenUtils.sig(Void.TYPE, ThreadContext.class, Boolean.TYPE, String.class));
    }
}

