/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.LineAndColumn;
import org.jetbrains.kotlin.ir.SourceRangeInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/AbstractIrFileEntry;", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "<init>", "()V", "lineStartOffsets", "", "getLineStartOffsets", "()[I", "getLineNumber", "", "offset", "getColumnNumber", "getLineAndColumnNumbers", "Lorg/jetbrains/kotlin/ir/LineAndColumn;", "getSourceRangeInfo", "Lorg/jetbrains/kotlin/ir/SourceRangeInfo;", "beginOffset", "endOffset", "ir.tree"})
public abstract class AbstractIrFileEntry
implements IrFileEntry {
    @NotNull
    protected abstract int[] getLineStartOffsets();

    @Override
    public int getLineNumber(int offset2) {
        if (offset2 < 0) {
            return -1;
        }
        int index = ArraysKt.binarySearch$default(this.getLineStartOffsets(), offset2, 0, 0, 6, null);
        return index >= 0 ? index : -index - 2;
    }

    @Override
    public int getColumnNumber(int offset2) {
        if (offset2 < 0) {
            return -1;
        }
        int lineNumber = this.getLineNumber(offset2);
        if (lineNumber < 0) {
            return -1;
        }
        return offset2 - this.getLineStartOffsets()[lineNumber];
    }

    @Override
    @NotNull
    public LineAndColumn getLineAndColumnNumbers(int offset2) {
        if (offset2 < 0) {
            return new LineAndColumn(-1, -1);
        }
        int lineNumber = this.getLineNumber(offset2);
        if (lineNumber < 0) {
            return new LineAndColumn(lineNumber, -1);
        }
        int columnNumber = offset2 - this.getLineStartOffsets()[lineNumber];
        return new LineAndColumn(lineNumber, columnNumber);
    }

    @Override
    @NotNull
    public SourceRangeInfo getSourceRangeInfo(int beginOffset, int endOffset) {
        LineAndColumn lineAndColumn = this.getLineAndColumnNumbers(beginOffset);
        int startLineNumber = lineAndColumn.component1();
        int startColumnNumber = lineAndColumn.component2();
        LineAndColumn lineAndColumn2 = this.getLineAndColumnNumbers(endOffset);
        int endLineNumber = lineAndColumn2.component1();
        int endColumnNumber = lineAndColumn2.component2();
        return new SourceRangeInfo(this.getName(), beginOffset, startLineNumber, startColumnNumber, endOffset, endLineNumber, endColumnNumber);
    }

    @Override
    public boolean getSupportsDebugInfo() {
        return IrFileEntry.DefaultImpls.getSupportsDebugInfo(this);
    }
}

