#include "icosahedron.h"
#include "PI.h"

template <typename DerivedV, typename DerivedF>
IGL_INLINE void igl::icosahedron(
  Eigen::PlainObjectBase<DerivedV> & V,
  Eigen::PlainObjectBase<DerivedF> & F)
{
  V.resize(12,3);
  V.row(0) << 0,0,1;
  const auto r = (1+sqrt(5))/2 - 0.5;
  const auto z = 0.5/r;
  const auto pi = atan(1)*4;
  for(int i = 0;i<5;i++)
  {
    const auto beta = (i*2)*igl::PI/5;
    V.row(i+6) << cos(beta)/r,sin(beta)/r,-z;
    const auto alpha = beta - igl::PI/5;
    V.row(i+1) << cos(alpha)/r,sin(alpha)/r,z;
  }
  V.row(11) << 0,0,-1;
  F.resize(20,3);
  F<< 
    0,1,2,
    0,2,3,
    0,3,4,
    0,4,5,
    0,5,1,
    1,6,2,
    2,7,3,
    3,8,4,
    4,9,5,
    5,10,1,
    6,7,2,
    7,8,3,
    8,9,4,
    9,10,5,
    10,6,1,
    6,11,7,
    7,11,8,
    8,11,9,
    9,11,10,
    10,11,6;
}

#ifdef IGL_STATIC_LIBRARY
// Explicit template instantiation
// generated by autoexplicit.sh
template void igl::icosahedron<Eigen::Matrix<double, -1, -1, 0, -1, -1>, Eigen::Matrix<int, -1, -1, 0, -1, -1> >(Eigen::PlainObjectBase<Eigen::Matrix<double, -1, -1, 0, -1, -1> >&, Eigen::PlainObjectBase<Eigen::Matrix<int, -1, -1, 0, -1, -1> >&);
#endif
