/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_si extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "\u0dbb\u0dd4." },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MRU", "MRU" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "STN", "STN" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VES", "VES" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "XOF", "\u0dc3\u0dd2\u0dc6\u0dca\u0d91" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "aed", "\u0d91\u0d9a\u0dca\u0dc3\u0dad\u0dca \u0d85\u0dbb\u0dcf\u0db6\u0dd2 \u0d91\u0db8\u0dd2\u0dbb\u0dda\u0da7\u0dca\u0dc3\u0dca \u0da9\u0dd2\u0dbb\u0dcf\u0db8\u0dca" },
            { "afn", "\u0d87\u0dc6\u0dca\u0d9c\u0db1\u0dd2\u0dae\u0dcf\u0db1 \u0d87\u0dc6\u0dca\u0d9c\u0db1\u0dd2" },
            { "all", "\u0d87\u0dbd\u0dca\u0db6\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dbd\u0dd9\u0d9a\u0dca" },
            { "amd", "\u0d86\u0dbb\u0dca\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da9\u0dca\u200d\u0dbb\u0dd1\u0db8\u0dca" },
            { "ang", "\u0db1\u0dd9\u0daf\u0dbb\u0dca\u0dbd\u0db1\u0dca\u0dad \u0d87\u0db1\u0dca\u0da7\u0dd2\u0dbd\u0dd2\u0dba\u0db1\u0dca \u0d9c\u0dd2\u0dbd\u0dca\u0da9\u0dbb\u0dca" },
            { "aoa", "\u0d87\u0db1\u0dca\u0d9c\u0ddd\u0dbd\u0dcf\u0db1\u0dd4 \u0d9a\u0dca\u0dc0\u0db1\u0dca\u0dc3\u0dcf" },
            { "ars", "\u0d86\u0dbb\u0dca\u0da2\u0db1\u0dca\u0da7\u0dd2\u0db1\u0dcf \u0db4\u0dd9\u0dc3\u0ddd" },
            { "aud", "\u0d94\u0dc3\u0dca\u0da7\u0dca\u200d\u0dbb\u0dda\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "awg", "\u0d85\u0dbb\u0dd6\u0db6\u0dcf\u0db1\u0dd4 \u0dc6\u0dca\u0dbd\u0ddd\u0dbb\u0dd2\u0db1\u0dca" },
            { "azn", "\u0d85\u0dc3\u0dbb\u0dca\u0db6\u0dba\u0dd2\u0da2\u0dcf\u0db1\u0dd4 \u0db8\u0db1\u0dcf\u0da7\u0dca" },
            { "bam", "\u0db6\u0ddc\u0dc3\u0dca\u0db1\u0dd2\u0dba\u0dcf \u0dc4\u0dbb\u0dca\u0dc3\u0d9c\u0ddc\u0dc0\u0dd3\u0db1\u0dcf \u0db4\u0dbb\u0dd2\u0dc0\u0dbb\u0dca\u0dad\u0dca\u200d\u0dba \u0db8\u0dcf\u0dbb\u0dca\u0d9a\u0dca" },
            { "bbd", "\u0db6\u0dcf\u0db6\u0dda\u0da9\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "bdt", "\u0db6\u0d82\u0d9c\u0dca\u0dbd\u0dcf\u0daf\u0dda\u0dc1\u0dca \u0da7\u0d9a\u0dcf" },
            { "bgn", "\u0db6\u0dbd\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dbd\u0dd2\u0dc0\u0dca" },
            { "bhd", "\u0db6\u0dc4\u0dbb\u0dda\u0db1\u0dca \u0da9\u0dd2\u0db1\u0dcf\u0dbb\u0dca" },
            { "bif", "\u0db6\u0dd4\u0dbb\u0dd4\u0db1\u0dca\u0daf\u0dd2 \u0dc6\u0dca\u200d\u0dbb\u0dd1\u0db1\u0dca\u0d9a\u0dca" },
            { "bmd", "\u0db6\u0dbb\u0dca\u0db8\u0dd2\u0dba\u0dd4\u0da9\u0dcf\u0db1\u0dd4 \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "bnd", "\u0db6\u0dd8\u0db1\u0dcf\u0dba\u0dd2 \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "bob", "\u0db6\u0ddc\u0dbd\u0dd2\u0dc0\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db6\u0ddc\u0dbd\u0dd2\u0dc0\u0dd2\u0dba\u0dcf\u0db1\u0ddd" },
            { "brl", "\u0db6\u0dca\u200d\u0dbb\u0dc3\u0dd3\u0dbd \u0dbb\u0dd2\u0dba\u0dbd\u0dca" },
            { "bsd", "\u0db6\u0dc4\u0db8\u0dcf\u0db1\u0dd4 \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "btn", "\u0db7\u0dd6\u0dad\u0dcf\u0db1 \u0db1\u0d9c\u0dd4\u0dbd\u0dca\u0da7\u0dca\u200d\u0dbb\u0db8\u0dca" },
            { "bwp", "\u0db6\u0ddc\u0da7\u0dca\u0dc3\u0dca\u0dc0\u0dcf\u0db1\u0dcf \u0db4\u0dd4\u0dbd\u0dcf" },
            { "byn", "\u0db6\u0dd9\u0dbd\u0dbb\u0dd6\u0dc3\u0dca \u0dbb\u0dd6\u0db6\u0dbd\u0dca" },
            { "byr", "\u0db6\u0dd9\u0dbd\u0dbb\u0dd6\u0dc3\u0dca \u0dbb\u0dd6\u0db6\u0dbd\u0dca (2000\u20132016)" },
            { "bzd", "\u0db6\u0dd9\u0dbd\u0dd3\u0dc3\u0dca \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "cad", "\u0d9a\u0dd0\u0db1\u0dda\u0da9\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "cdf", "\u0d9a\u0ddc\u0d82\u0d9c\u0ddd \u0dc6\u0dca\u200d\u0dbb\u0dd1\u0db1\u0dca\u0d9a\u0dca" },
            { "chf", "\u0dc3\u0dca\u0dc0\u0dd2\u0dc3\u0dca \u0dc6\u0dca\u200d\u0dbb\u0dd1\u0db1\u0dca\u0d9a\u0dca" },
            { "clp", "\u0da0\u0dd2\u0dbd\u0dd2 \u0db4\u0dd0\u0dc3\u0ddd" },
            { "cnh", "\u0da0\u0dd3\u0db1 \u0dba\u0dd4\u0d86\u0db1\u0dca (\u0d91\u0dad\u0dd9\u0dbb)" },
            { "cny", "\u0da0\u0dd3\u0db1 \u0dba\u0dd4\u0d86\u0db1\u0dca" },
            { "cop", "\u0d9a\u0ddc\u0dbd\u0ddc\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db4\u0dd9\u0dc3\u0ddd" },
            { "crc", "\u0d9a\u0ddc\u0dc3\u0dca\u0da7 \u0dbb\u0dd2\u0d9a\u0dcf \u0d9a\u0ddc\u0dbd\u0ddd\u0db1\u0dca" },
            { "cuc", "\u0db8\u0dcf\u0dbb\u0dd4\u0d9a\u0dc5 \u0dc4\u0dd0\u0d9a\u0dd2 \u0d9a\u0dd2\u0dba\u0dd4\u0db6\u0dcf\u0db1\u0dd4 \u0db4\u0dd0\u0dc3\u0ddd" },
            { "cup", "\u0d9a\u0dd2\u0dba\u0dd4\u0db6\u0dcf\u0db1\u0dd4 \u0db4\u0dd0\u0dc3\u0ddd" },
            { "cve", "\u0d9a\u0dda\u0db4\u0dca \u0dc0\u0dbb\u0dca\u0da9\u0dca \u0d91\u0dc3\u0dca\u0d9a\u0dd2\u0dba\u0dd4\u0da9\u0ddd" },
            { "czk", "\u0da0\u0dd9\u0d9a\u0dca \u0dbb\u0dd2\u0db4\u0db6\u0dca\u0dbd\u0dd2\u0d9a\u0dca \u0d9a\u0ddc\u0dbb\u0dd6\u0db1\u0dcf" },
            { "djf", "\u0da2\u0dd2\u0db6\u0dd6\u0dad\u0dd2 \u0dc6\u0dca\u200d\u0dbb\u0dd1\u0db1\u0dca\u0d9a\u0dca" },
            { "dkk", "\u0da9\u0dd0\u0db1\u0dd2\u0dc2\u0dca \u0d9a\u0dca\u200d\u0dbb\u0ddd\u0db1\u0dca" },
            { "dop", "\u0da9\u0ddc\u0db8\u0dd2\u0db1\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0db4\u0dd9\u0dc3\u0ddd" },
            { "dzd", "\u0d87\u0dbd\u0dca\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da9\u0dd2\u0db1\u0dcf\u0dbb\u0dca" },
            { "egp", "\u0d8a\u0da2\u0dd2\u0db4\u0dca\u0dad\u0dd4 \u0db4\u0dc0\u0dd4\u0db8\u0dca" },
            { "ern", "\u0d91\u0dbb\u0dd2\u0dad\u0dca\u200d\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db1\u0dd0\u0d9a\u0dca\u0dc6\u0dcf" },
            { "etb", "\u0d89\u0dad\u0dd2\u0dba\u0ddd\u0db4\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db6\u0dd3\u0dbb\u0dca" },
            { "eur", "\u0dba\u0dd4\u0dbb\u0ddd" },
            { "fjd", "\u0dc6\u0dd2\u0da2\u0dd2\u0dba\u0db1\u0dca \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "fkp", "\u0dc6\u0ddd\u0d9a\u0dca\u0dbd\u0db1\u0dca\u0da9\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca \u0db4\u0dc0\u0dd4\u0db8\u0dca" },
            { "gbp", "\u0db6\u0dca\u200d\u0dbb\u0dd2\u0dad\u0dcf\u0db1\u0dca\u200d\u0dba \u0dc3\u0dca\u0da7\u0dbb\u0dca\u0dbd\u0dd2\u0db1\u0dca \u0db4\u0dc0\u0dd4\u0db8\u0dca" },
            { "gel", "\u0da2\u0ddd\u0da2\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dbd\u0dd0\u0dbb\u0dd3" },
            { "ghs", "\u0d9d\u0dcf\u0db1\u0dcf \u0dc3\u0dd9\u0da9\u0dd2" },
            { "gip", "\u0da2\u0dd2\u0db6\u0dca\u200d\u0dbb\u0ddd\u0dbd\u0dca\u0da7\u0dcf \u0db4\u0dc0\u0dd4\u0db8\u0dca" },
            { "gmd", "\u0d9c\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0daf\u0dbd\u0dcf\u0dc3\u0dd2" },
            { "gnf", "\u0d9c\u0dd2\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc6\u0dca\u0dbb\u0dd1\u0db1\u0dca\u0d9a\u0dca" },
            { "gtq", "\u0d9c\u0ddd\u0dad\u0db8\u0dcf\u0dbd\u0dcf\u0db1\u0dd4 \u0d9a\u0dca\u0dc0\u0dd9\u0da7\u0dca\u0dc3\u0dbd\u0dca" },
            { "gyd", "\u0d9c\u0dba\u0db1\u0dcf \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "hkd", "\u0dc4\u0ddc\u0d82\u0d9a\u0ddc\u0d82 \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "hnl", "\u0dc4\u0ddc\u0db1\u0dca\u0da9\u0dd4\u0dbb\u0dcf\u0db1\u0dd4 \u0dbd\u0dd9\u0db8\u0dca\u0db4\u0dd2\u0dbb\u0dcf" },
            { "hrk", "\u0d9a\u0dca\u200d\u0dbb\u0ddc\u0d92\u0dc2\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d9a\u0dd6\u0db1\u0dcf" },
            { "htg", "\u0dc4\u0dba\u0dd2\u0da7\u0dd2 \u0d9c\u0ddd\u0dbb\u0dca\u0da9\u0dca" },
            { "huf", "\u0dc4\u0d82\u0d9c\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc6\u0dbb\u0dd2\u0db1\u0dca\u0da7\u0dca" },
            { "idr", "\u0d89\u0db1\u0dca\u0daf\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dbb\u0dd4\u0db4\u0dd2\u0dba\u0dcf" },
            { "ils", "\u0d8a\u0dc1\u0dca\u200d\u0dbb\u0dcf\u0dba\u0dbd \u0db1\u0dc0 \u0dc1\u0dd9\u0d9a\u0dbd\u0dca" },
            { "inr", "\u0d89\u0db1\u0dca\u0daf\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dbb\u0dd4\u0db4\u0dd2\u0dba\u0dbd\u0dca" },
            { "iqd", "\u0d89\u0dbb\u0dcf\u0d9a \u0da9\u0dd2\u0db1\u0dcf\u0dbb\u0dca" },
            { "irr", "\u0d89\u0dbb\u0dcf\u0db1 \u0dbb\u0dd2\u0dba\u0dcf\u0dbd\u0dca" },
            { "isk", "\u0d85\u0dba\u0dd2\u0dc3\u0dca\u0dbd\u0db1\u0dca\u0dad\u0dd2\u0d9a \u0d9a\u0dca\u200d\u0dbb\u0ddd\u0db1\u0dcf" },
            { "jmd", "\u0da2\u0dd0\u0db8\u0dd9\u0dba\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "jod", "\u0da2\u0ddd\u0dbb\u0dca\u0daf\u0dcf\u0db1\u0dca \u0da9\u0dd2\u0db1\u0dcf\u0dbb\u0dca" },
            { "jpy", "\u0da2\u0db4\u0db1\u0dca \u0dba\u0dd9\u0db1\u0dca" },
            { "kes", "\u0d9a\u0dd9\u0db1\u0dca\u0dba\u0dcf\u0db1\u0dd4 \u0dc1\u0dd2\u0dbd\u0dd2\u0d82" },
            { "kgs", "\u0d9a\u0dd2\u0dbb\u0dd2\u0d9c\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1 \u0dc3\u0db8\u0dca" },
            { "khr", "\u0d9a\u0dcf\u0db8\u0dca\u0db6\u0ddd\u0da2 \u0dbb\u0dd2\u0dba\u0dda\u0dbd\u0dca" },
            { "kmf", "\u0d9a\u0ddc\u0db8\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc6\u0dca\u200d\u0dbb\u0dd1\u0db1\u0dca\u0d9a\u0dca" },
            { "kpw", "\u0d8b\u0dad\u0dd4\u0dbb\u0dd4 \u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc0\u0ddc\u0db1\u0dca" },
            { "krw", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d9a\u0ddc\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc0\u0ddc\u0db1\u0dca" },
            { "kwd", "\u0d9a\u0dd4\u0dc0\u0dda\u0da7\u0dca \u0da9\u0dd2\u0db1\u0dcf\u0dbb\u0dca" },
            { "kyd", "\u0d9a\u0dda\u0db8\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "kzt", "\u0d9a\u0dc3\u0d9a\u0dc3\u0dca\u0dae\u0dcf\u0db1 \u0da7\u0dd9\u0db1\u0dca\u0d9c" },
            { "lak", "\u0dbd\u0dcf\u0d95\u0dc3\u0dca \u0d9a\u0dd2\u0db4\u0dca" },
            { "lbp", "\u0dbd\u0dd9\u0db6\u0db1\u0db1 \u0db4\u0dc0\u0dd4\u0db8\u0dca" },
            { "lkr", "\u0dc1\u0dca\u200d\u0dbb\u0dd3 \u0dbd\u0d82\u0d9a\u0dcf \u0dbb\u0dd4\u0db4\u0dd2\u0dba\u0dbd" },
            { "lrd", "\u0dbd\u0dba\u0dd2\u0db6\u0dda\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "ltl", "\u0dbd\u0dd2\u0dad\u0dd4\u0dc0\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4" },
            { "lvl", "\u0dbd\u0dd0\u0da7\u0dca\u0dc0\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dbd\u0dd0\u0da7\u0dca\u0dc3\u0dca" },
            { "lyd", "\u0dbd\u0dd2\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da9\u0dd2\u0db1\u0dcf\u0dbb\u0dca" },
            { "mad", "\u0db8\u0ddc\u0dbb\u0ddc\u0d9a\u0dca\u0d9a\u0ddd \u0da9\u0dd2\u0dbb\u0dca\u0dc4\u0dd0\u0db8\u0dca" },
            { "mdl", "\u0db8\u0ddd\u0dbd\u0dca\u0da9\u0ddd\u0dc0\u0dcf\u0db1\u0dd4 \u0dbd\u0dd9\u0dc0\u0dca" },
            { "mga", "\u0db8\u0dbd\u0d9c\u0dcf\u0dc3\u0dd2 \u0d85\u0dbb\u0dd2\u0dba\u0dcf\u0dbb\u0dd2" },
            { "mkd", "\u0db8\u0dd0\u0dc3\u0da9\u0ddd\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da9\u0dd2\u0db1\u0dcf\u0dbb\u0dca" },
            { "mmk", "\u0db6\u0dd4\u0dbb\u0dd4\u0db8 \u0d9a\u0dca\u0dba\u0dcf\u0da7\u0dca" },
            { "mnt", "\u0db8\u0ddc\u0db1\u0dca\u0d9c\u0ddd\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da7\u0d9c\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dca" },
            { "mop", "\u0db8\u0dd0\u0d9a\u0db1\u0dd3\u0dc3\u0dca \u0db4\u0da7\u0d9a\u0dcf" },
            { "mro", "\u0db8\u0dd4\u0dbb\u0dd4\u0dc3\u0dd2 \u0d94\u0dba\u0dd2\u0d9c\u0dd4\u0dba\u0dd2\u0dba\u0dcf (1973\u20132017)" },
            { "mru", "\u0db8\u0dd4\u0dbb\u0dd4\u0dc3\u0dd2 \u0d94\u0dba\u0dd2\u0d9c\u0dd4\u0dba\u0dd2\u0dba\u0dcf" },
            { "mur", "\u0db8\u0dd4\u0dbb\u0dd2\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dbb\u0dd4\u0db4\u0dd2\u0dba\u0dbd\u0dca" },
            { "mvr", "\u0db8\u0dcf\u0dbd\u0daf\u0dd2\u0dc0\u0dba\u0dd2\u0db1\u0dca \u0dbb\u0dd4\u0dc6\u0dd2\u0dba\u0dcf" },
            { "mwk", "\u0db8\u0dbd\u0dcf\u0dc0\u0dd2 \u0d9a\u0dca\u0dc0\u0dcf\u0da0\u0dcf" },
            { "mxn", "\u0db8\u0dd9\u0d9a\u0dca\u0dc3\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "myr", "\u0db8\u0dd0\u0dbd\u0dda\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dbb\u0dd2\u0db1\u0dca\u0d9c\u0dd2\u0da7\u0dca" },
            { "mzn", "\u0db8\u0ddc\u0dc3\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0d9a\u0db1\u0dca \u0db8\u0dd9\u0da7\u0dd2\u0d9a\u0dbd\u0dca" },
            { "nad", "\u0db1\u0dd0\u0db8\u0dd3\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "ngn", "\u0db1\u0dba\u0dd2\u0da2\u0dd3\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db1\u0dba\u0dd2\u0dbb\u0dcf" },
            { "nio", "\u0db1\u0dd2\u0d9a\u0dbb\u0d9c\u0dd4\u0dc0\u0dcf\u0db1\u0dd4 \u0d9a\u0ddc\u0da9\u0ddd\u0db6\u0dcf" },
            { "nok", "\u0db1\u0ddc\u0dbb\u0dca\u0dc0\u0dd3\u0da2\u0dd2\u0dba\u0db1\u0dca \u0d9a\u0dca\u200d\u0dbb\u0ddd\u0db1\u0dca" },
            { "npr", "\u0db1\u0dda\u0db4\u0dcf\u0dbd \u0dbb\u0dd4\u0db4\u0dd2\u0dba\u0dbd\u0dca" },
            { "nzd", "\u0db1\u0dc0\u0dc3\u0dd3\u0dbd\u0db1\u0dca\u0dad \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "omr", "\u0d95\u0db8\u0dcf\u0db1\u0dca \u0dbb\u0dd2\u0dba\u0dcf\u0dbd\u0dca" },
            { "pab", "\u0db4\u0dd0\u0db1\u0db8\u0dcf \u0db6\u0dd0\u0dbd\u0dca\u0db6\u0ddd" },
            { "pen", "\u0db4\u0dda\u0dbb\u0dd4 \u0dc3\u0ddc\u0dbd\u0dca" },
            { "pgk", "\u0db4\u0dd0\u0db4\u0dd4\u0dc0\u0dcf \u0db1\u0dd2\u0dc0\u0dca \u0d9c\u0dd2\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d9a\u0dd2\u0db1\u0dcf" },
            { "php", "\u0db4\u0dd2\u0dbd\u0dd2\u0db4\u0dd3\u0db1 \u0db4\u0dd9\u0dc3\u0ddd" },
            { "pkr", "\u0db4\u0dcf\u0d9a\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1 \u0dbb\u0dd4\u0db4\u0dd2\u0dba\u0dbd\u0dca" },
            { "pln", "\u0db4\u0ddc\u0dbd\u0dd2\u0dc2\u0dca \u0dc3\u0dca\u0dbd\u0ddc\u0da7\u0dd2" },
            { "pyg", "\u0db4\u0dd0\u0dbb\u0d9c\u0dd4\u0dc0\u0dda \u0d9c\u0dd4\u0dc0\u0dbb\u0dcf\u0db1\u0dd2" },
            { "qar", "\u0d9a\u0da7\u0dcf\u0dbb\u0dca \u0dbb\u0dd2\u0dba\u0dcf\u0dbd\u0dca" },
            { "ron", "\u0dbb\u0ddc\u0db8\u0dda\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dbd\u0dd9\u0dc0\u0dca" },
            { "rsd", "\u0dc3\u0dbb\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da9\u0dd2\u0db1\u0dcf\u0dbb\u0dca" },
            { "rub", "\u0dbb\u0dd4\u0dc3\u0dd2\u0dba\u0db1\u0dca \u0dbb\u0dd6\u0db6\u0dbd\u0dca" },
            { "rwf", "\u0dbb\u0dd4\u0dc0\u0db1\u0dca\u0da9\u0dcf \u0dc6\u0dca\u200d\u0dbb\u0dd1\u0db1\u0dca\u0d9a\u0dca" },
            { "sar", "\u0dc3\u0dc0\u0dd4\u0daf\u0dd2 \u0dbb\u0dd2\u0dba\u0dcf\u0dbd\u0dca" },
            { "sbd", "\u0dc3\u0ddc\u0dbd\u0db8\u0db1\u0dca \u0daf\u0dd6\u0db4\u0dad\u0dca \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "scr", "\u0dc3\u0dd3\u0dc2\u0dd9\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dbb\u0dd4\u0db4\u0dd2\u0dba\u0dbd" },
            { "sdg", "\u0dc3\u0dd4\u0da9\u0dcf\u0db1 \u0db4\u0dc0\u0dd4\u0db8\u0dca" },
            { "sek", "\u0dc3\u0dca\u0dc0\u0dd9\u0da9\u0dd2\u0dc2\u0dca \u0d9a\u0dca\u200d\u0dbb\u0ddd\u0db1\u0dcf" },
            { "sgd", "\u0dc3\u0dd2\u0d82\u0d9c\u0db4\u0dca\u0db4\u0dd6\u0dbb\u0dd4 \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "shp", "\u0dc1\u0dcf\u0db1\u0dca\u0dad \u0dc4\u0dd9\u0dbd\u0dda\u0db1\u0dcf \u0db4\u0dc0\u0dd4\u0db8\u0dca" },
            { "sll", "\u0dc3\u0dd2\u0dba\u0dbb\u0dcf \u0dbd\u0dd2\u0dba\u0ddc\u0db1\u0dca \u0dbd\u0dd2\u0dba\u0ddc\u0db1\u0dca" },
            { "sos", "\u0dc3\u0ddd\u0db8\u0dcf\u0dbd\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc1\u0dd2\u0dbd\u0dd2\u0d82" },
            { "srd", "\u0dc3\u0dd4\u0dbb\u0dd2\u0db1\u0dcf\u0db8\u0dca \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "ssp", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0dc3\u0dd4\u0da9\u0dcf\u0db1 \u0db4\u0dc0\u0dd4\u0db8\u0dca" },
            { "std", "\u0dc3\u0dcf\u0d95 \u0dad\u0ddd\u0db8\u0dca \u0dc3\u0dc4 \u0db4\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dca\u0dc3\u0dd2\u0db4\u0dca \u0daf\u0ddc\u0db6\u0dca\u200d\u0dbb\u0dcf (1977\u20132017)" },
            { "stn", "\u0dc3\u0dcf\u0d95 \u0dad\u0ddd\u0db8\u0dca \u0dc3\u0dc4 \u0db4\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dca\u0dc3\u0dd2\u0db4\u0dca \u0daf\u0ddc\u0db6\u0dca\u200d\u0dbb\u0dcf" },
            { "syp", "\u0dc3\u0dd2\u0dbb\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0db4\u0dc0\u0dd4\u0db8\u0dca" },
            { "szl", "\u0dc3\u0dca\u0dc0\u0dcf\u0dc3\u0dd2 \u0dbd\u0dd2\u0dbd\u0db1\u0dca\u0da2\u0db1\u0dd2" },
            { "thb", "\u0dad\u0dcf\u0dba\u0dd2 \u0db6\u0dcf\u0dad\u0dca" },
            { "tjs", "\u0dad\u0da2\u0dd2\u0d9a\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1 \u0dc3\u0db8\u0ddc\u0db1\u0dd2" },
            { "tmt", "\u0dad\u0d9a\u0dca\u0db8\u0dd9\u0db1\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1 \u0db8\u0db1\u0dcf\u0da7\u0dca" },
            { "tnd", "\u0da7\u0dd2\u0dba\u0dd4\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da9\u0dd2\u0db1\u0dcf\u0dbb\u0dca" },
            { "top", "\u0da7\u0ddc\u0d82\u0d9c\u0dcf\u0db1\u0dd4 \u0db4\u0dcf\u0db1\u0dca\u0d9c\u0dcf" },
            { "try", "\u0dad\u0dd4\u0dbb\u0dca\u0d9a\u0dd2 \u0dbd\u0dd2\u0dbb\u0dcf" },
            { "ttd", "\u0da7\u0dca\u200d\u0dbb\u0dd2\u0db1\u0dd2\u0da9\u0dd1\u0da9\u0dca \u0dc3\u0dc4 \u0da7\u0ddc\u0db6\u0dd1\u0d9c\u0ddd \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "twd", "\u0db1\u0dc0 \u0dad\u0dcf\u0dba\u0dd2\u0dc0\u0dcf\u0db1 \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "tzs", "\u0da7\u0dd0\u0db1\u0dca\u0dc3\u0dcf\u0db1\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc1\u0dd2\u0dbd\u0dd2\u0d82" },
            { "uah", "\u0dba\u0dd4\u0d9a\u0dca\u0dbb\u0dda\u0db1 \u0dc4\u0dca\u200d\u0dbb\u0dd2\u0dc0\u0dca\u0db1\u0dd2\u0dba\u0dcf" },
            { "ugx", "\u0d8b\u0d9c\u0db1\u0dca\u0da9\u0dcf \u0dc1\u0dd2\u0dbd\u0dd2\u0d82" },
            { "usd", "\u0d87\u0db8\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "uyu", "\u0d8b\u0dbb\u0dd4\u0d9c\u0dd4\u0dc0\u0dda \u0db4\u0dd9\u0dc3\u0ddd" },
            { "uzs", "\u0d8b\u0dc3\u0dca\u0db6\u0dd9\u0d9a\u0dd2\u0dc3\u0dca\u0dae\u0dcf\u0db1 \u0dc3\u0db8\u0dca" },
            { "vef", "\u0dc0\u0dd9\u0db1\u0dd2\u0dc3\u0dd2\u0dba\u0dd4\u0dbd\u0dcf\u0db1\u0dd4 \u0db6\u0ddc\u0dbd\u0dd2\u0dc0\u0dbb\u0dca (2008\u20132018)" },
            { "ves", "\u0dc0\u0dd9\u0db1\u0dd2\u0dc3\u0dd2\u0dba\u0dd4\u0dbd\u0dcf\u0db1\u0dd4 \u0db6\u0ddc\u0dbd\u0dd2\u0dc0\u0dbb\u0dca" },
            { "vnd", "\u0dc0\u0dd2\u0dba\u0da7\u0dca\u0db1\u0dcf\u0db8 \u0da9\u0ddc\u0db1\u0dca" },
            { "vuv", "\u0dc0\u0db1\u0dd4\u0dc0\u0dcf\u0da7\u0dd4 \u0dc0\u0dcf\u0da7\u0dd4" },
            { "wst", "\u0dc3\u0dd0\u0db8\u0ddd\u0dc0\u0dcf \u0da7\u0dcf\u0dbd\u0dcf" },
            { "xaf", "\u0dc3\u0dd2\u0dc6\u0dca\u0d91 \u0dc6\u0dca\u0dbb\u0dd1\u0db1\u0dca\u0d9a\u0dca \u0db6\u0dd2\u0d8a\u0d91\u0dc3\u0dd2" },
            { "xcd", "\u0db1\u0dd0\u0d9c\u0dd9\u0db1\u0dc4\u0dd2\u0dbb \u0d9a\u0dd0\u0dbb\u0dd2\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0da9\u0ddc\u0dbd\u0dbb\u0dca" },
            { "xof", "\u0dc3\u0dd2\u0dc6\u0dca\u0d91 \u0dc6\u0dca\u0dbb\u0dd1\u0db1\u0dca\u0d9a\u0dca \u0db6\u0dd2\u0dc3\u0dd3\u0d8a\u0d91\u0d94" },
            { "xpf", "\u0db4\u0dca\u200d\u0dbb\u0d82\u0dc1 \u0db4\u0ddc\u0dbd\u0dd2\u0db1\u0dd3\u0dc3\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0dc6\u0dca\u200d\u0dbb\u0dd1\u0db1\u0dca\u0d9a\u0dca" },
            { "xxx", "\u0db1\u0ddc\u0daf\u0dad\u0dca \u0db8\u0dd4\u0daf\u0dbd\u0dca" },
            { "yer", "\u0dba\u0dda\u0db8\u0db1 \u0dbb\u0dd2\u0dba\u0dcf\u0dbd\u0dca" },
            { "zar", "\u0daf\u0d9a\u0dd4\u0dab\u0dd4 \u0d85\u0db4\u0dca\u200d\u0dbb\u0dd2\u0d9a\u0dcf\u0db1\u0dd4 \u0dbb\u0dd0\u0db1\u0dca\u0da9\u0dca" },
            { "zmk", "\u0dc3\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d9a\u0dca\u0dc0\u0dcf\u0da0\u0dcf (1968\u20132012)" },
            { "zmw", "\u0dc3\u0dd0\u0db8\u0dca\u0db6\u0dd2\u0dba\u0dcf\u0db1\u0dd4 \u0d9a\u0dca\u0dc0\u0dcf\u0da0\u0dcf" },
        };
        return data;
    }
}
