/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UCenteredCharacter;
import net.sourceforge.plantuml.klimt.shape.URectangle;

public class BoxedCharacter
extends AbstractTextBlock
implements TextBlock {
    private final String c;
    private final UFont font;
    private final HColor innerCircle;
    private final HColor circle;
    private final HColor fontColor;
    private final double radius;

    public BoxedCharacter(char c, double size, UFont font, HColor innerCircle, HColor circle, HColor fontColor) {
        this.c = "" + c;
        this.font = font;
        this.innerCircle = innerCircle;
        this.circle = circle;
        this.fontColor = fontColor;
        this.radius = size;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.circle != null) {
            ug = ug.apply(this.circle);
        }
        ug = this.innerCircle == null ? ug.apply(HColors.none().bg()) : ug.apply(this.innerCircle.bg());
        ug.draw(URectangle.build(2.0 * this.radius, 2.0 * this.radius));
        ug = ug.apply(this.fontColor);
        ug = ug.apply(new UTranslate(this.radius, this.radius));
        ug.draw(new UCenteredCharacter(this.c.charAt(0), this.font));
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        return 2.0 * this.radius;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return 2.0 * this.radius;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(this.getPreferredWidth(stringBounder), this.getPreferredHeight(stringBounder));
    }
}

