/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ftp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.ftp.FtpConnexion;
import net.sourceforge.plantuml.ftp.FtpLoop;
import net.sourceforge.plantuml.log.Logme;

public class FtpServer {
    private final Map<String, FtpConnexion> datas = new TreeMap<String, FtpConnexion>();
    private final ExecutorService exeImage = Executors.newFixedThreadPool(2);
    private final int listenPort;
    private int portFree = 10042;
    private String ip;
    private final FileFormat defaultfileFormat;

    public FtpServer(int listenPort, FileFormat defaultfileFormat) {
        this.listenPort = listenPort;
        this.defaultfileFormat = defaultfileFormat == null ? FileFormat.PNG : defaultfileFormat;
    }

    public synchronized int getFreePort() {
        ++this.portFree;
        return this.portFree;
    }

    public void go() throws IOException {
        ServerSocket s = new ServerSocket(this.listenPort);
        ExecutorService exe = Executors.newCachedThreadPool();
        while (true) {
            Socket incoming = s.accept();
            this.ip = incoming.getLocalAddress().getHostAddress();
            System.out.println("New Client Connected from " + incoming.getInetAddress().getHostName() + "... ");
            exe.submit(new FtpLoop(incoming, this));
        }
    }

    public String getIpServer() {
        return this.ip;
    }

    public synchronized FtpConnexion getFtpConnexion(String user) {
        FtpConnexion data = this.datas.get(Objects.requireNonNull(user));
        if (data == null) {
            data = new FtpConnexion(user, this.defaultfileFormat);
            this.datas.put(user, data);
        }
        return data;
    }

    public static void main(String[] args) throws IOException {
        System.out.println("****************************** ************************************************** ");
        System.out.println("****************************** FTP SERVER***********************************");
        System.out.println("****************************** ************************************************** ");
        System.out.println("Server Started...");
        System.out.println("Waiting for connections...");
        System.out.println(" ");
        new FtpServer(4242, FileFormat.PNG).go();
    }

    public void processImage(final FtpConnexion connexion, final String name) {
        this.exeImage.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    connexion.processImage(name);
                }
                catch (IOException e) {
                    Logme.error(e);
                }
            }
        });
    }

    public final String getCharset() {
        return StandardCharsets.UTF_8.name();
    }
}

