/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.util.ArrayList;
import org.apache.batik.apps.svgbrowser.AbstractCompoundCommand;
import org.apache.batik.apps.svgbrowser.AbstractUndoableCommand;
import org.apache.batik.apps.svgbrowser.HistoryBrowser;
import org.apache.batik.apps.svgbrowser.UndoableCommand;
import org.apache.batik.dom.util.DOMUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HistoryBrowserInterface {
    private static final String ATTRIBUTE_ADDED_COMMAND = "Attribute added: ";
    private static final String ATTRIBUTE_REMOVED_COMMAND = "Attribute removed: ";
    private static final String ATTRIBUTE_MODIFIED_COMMAND = "Attribute modified: ";
    private static final String NODE_INSERTED_COMMAND = "Node inserted: ";
    private static final String NODE_REMOVED_COMMAND = "Node removed: ";
    private static final String CHAR_DATA_MODIFIED_COMMAND = "Node value changed: ";
    private static final String OUTER_EDIT_COMMAND = "Document changed outside DOM Viewer";
    private static final String COMPOUND_TREE_NODE_DROP = "Node moved";
    private static final String REMOVE_SELECTED_NODES = "Nodes removed";
    protected HistoryBrowser historyBrowser;
    protected AbstractCompoundCommand currentCompoundCommand;

    public HistoryBrowserInterface(HistoryBrowser.CommandController commandController) {
        this.historyBrowser = new HistoryBrowser(commandController);
    }

    public void setCommmandController(HistoryBrowser.CommandController commandController) {
        this.historyBrowser.setCommandController(commandController);
    }

    public CompoundUpdateCommand createCompoundUpdateCommand(String string) {
        CompoundUpdateCommand compoundUpdateCommand = new CompoundUpdateCommand(string);
        return compoundUpdateCommand;
    }

    public CompoundUpdateCommand createNodeChangedCommand(Node node) {
        return new CompoundUpdateCommand(this.getNodeChangedCommandName(node));
    }

    public CompoundUpdateCommand createNodesDroppedCommand(ArrayList arrayList) {
        return new CompoundUpdateCommand(COMPOUND_TREE_NODE_DROP);
    }

    public CompoundUpdateCommand createRemoveSelectedTreeNodesCommand(ArrayList arrayList) {
        return new CompoundUpdateCommand(REMOVE_SELECTED_NODES);
    }

    public void performCompoundUpdateCommand(UndoableCommand undoableCommand) {
        this.historyBrowser.addCommand(undoableCommand);
    }

    public HistoryBrowser getHistoryBrowser() {
        return this.historyBrowser;
    }

    public void nodeInserted(Node node, Node node2, Node node3) {
        this.historyBrowser.addCommand(this.createNodeInsertedCommand(node, node2, node3));
    }

    public NodeInsertedCommand createNodeInsertedCommand(Node node, Node node2, Node node3) {
        return new NodeInsertedCommand(NODE_INSERTED_COMMAND + this.getBracketedNodeName(node3), node, node2, node3);
    }

    public void nodeRemoved(Node node, Node node2, Node node3) {
        this.historyBrowser.addCommand(this.createNodeRemovedCommand(node, node2, node3));
    }

    public NodeRemovedCommand createNodeRemovedCommand(Node node, Node node2, Node node3) {
        return new NodeRemovedCommand(NODE_REMOVED_COMMAND + this.getBracketedNodeName(node3), node, node2, node3);
    }

    public void attributeAdded(Element element, String string, String string2, String string3) {
        this.historyBrowser.addCommand(this.createAttributeAddedCommand(element, string, string2, string3));
    }

    public AttributeAddedCommand createAttributeAddedCommand(Element element, String string, String string2, String string3) {
        return new AttributeAddedCommand(ATTRIBUTE_ADDED_COMMAND + this.getBracketedNodeName(element), element, string, string2, string3);
    }

    public void attributeRemoved(Element element, String string, String string2, String string3) {
        this.historyBrowser.addCommand(this.createAttributeRemovedCommand(element, string, string2, string3));
    }

    public AttributeRemovedCommand createAttributeRemovedCommand(Element element, String string, String string2, String string3) {
        return new AttributeRemovedCommand(ATTRIBUTE_REMOVED_COMMAND + this.getBracketedNodeName(element), element, string, string2, string3);
    }

    public void attributeModified(Element element, String string, String string2, String string3, String string4) {
        this.historyBrowser.addCommand(this.createAttributeModifiedCommand(element, string, string2, string3, string4));
    }

    public AttributeModifiedCommand createAttributeModifiedCommand(Element element, String string, String string2, String string3, String string4) {
        return new AttributeModifiedCommand(ATTRIBUTE_MODIFIED_COMMAND + this.getBracketedNodeName(element), element, string, string2, string3, string4);
    }

    public void charDataModified(Node node, String string, String string2) {
        this.historyBrowser.addCommand(this.createCharDataModifiedCommand(node, string, string2));
    }

    public CharDataModifiedCommand createCharDataModifiedCommand(Node node, String string, String string2) {
        return new CharDataModifiedCommand(CHAR_DATA_MODIFIED_COMMAND + this.getBracketedNodeName(node), node, string, string2);
    }

    public void appendChild(Node node, Node node2) {
        this.historyBrowser.addCommand(this.createAppendChildCommand(node, node2));
    }

    public AppendChildCommand createAppendChildCommand(Node node, Node node2) {
        return new AppendChildCommand(this.getAppendChildCommandName(node, node2), node, node2);
    }

    public void insertChildBefore(Node node, Node node2, Node node3) {
        if (node2 == null) {
            this.historyBrowser.addCommand(this.createAppendChildCommand(node, node3));
        } else {
            this.historyBrowser.addCommand(this.createInsertNodeBeforeCommand(node, node2, node3));
        }
    }

    public UndoableCommand createInsertChildCommand(Node node, Node node2, Node node3) {
        if (node2 == null) {
            return this.createAppendChildCommand(node, node3);
        }
        return this.createInsertNodeBeforeCommand(node, node2, node3);
    }

    public InsertNodeBeforeCommand createInsertNodeBeforeCommand(Node node, Node node2, Node node3) {
        return new InsertNodeBeforeCommand(this.getInsertBeforeCommandName(node, node3, node2), node, node2, node3);
    }

    public void replaceChild(Node node, Node node2, Node node3) {
    }

    public void removeChild(Node node, Node node2) {
        this.historyBrowser.addCommand(this.createRemoveChildCommand(node, node2));
    }

    public RemoveChildCommand createRemoveChildCommand(Node node, Node node2) {
        return new RemoveChildCommand(this.getRemoveChildCommandName(node, node2), node, node2);
    }

    public void setNodeValue(Node node, String string) {
        this.historyBrowser.addCommand(this.createChangeNodeValueCommand(node, string));
    }

    public ChangeNodeValueCommand createChangeNodeValueCommand(Node node, String string) {
        return new ChangeNodeValueCommand(this.getChangeNodeValueCommandName(node, string), node, string);
    }

    public AbstractCompoundCommand getCurrentCompoundCommand() {
        if (this.currentCompoundCommand == null) {
            this.currentCompoundCommand = this.createCompoundUpdateCommand(OUTER_EDIT_COMMAND);
        }
        return this.currentCompoundCommand;
    }

    public void addToCurrentCompoundCommand(AbstractUndoableCommand abstractUndoableCommand) {
        this.getCurrentCompoundCommand().addCommand(abstractUndoableCommand);
        this.historyBrowser.fireDoCompoundEdit(new HistoryBrowser.HistoryBrowserEvent(this.getCurrentCompoundCommand()));
    }

    public void performCurrentCompoundCommand() {
        if (this.getCurrentCompoundCommand().getCommandNumber() > 0) {
            this.historyBrowser.addCommand(this.getCurrentCompoundCommand());
            this.historyBrowser.fireCompoundEditPerformed(new HistoryBrowser.HistoryBrowserEvent(this.currentCompoundCommand));
            this.currentCompoundCommand = null;
        }
    }

    private String getNodeAsString(Node node) {
        String string = "";
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            string = element.getAttributeNS(null, "id");
        }
        if (string.length() != 0) {
            return node.getNodeName() + " \"" + string + "\"";
        }
        return node.getNodeName();
    }

    private String getBracketedNodeName(Node node) {
        return "(" + this.getNodeAsString(node) + ")";
    }

    private String getAppendChildCommandName(Node node, Node node2) {
        return "Append " + this.getNodeAsString(node2) + " to " + this.getNodeAsString(node);
    }

    private String getInsertBeforeCommandName(Node node, Node node2, Node node3) {
        return "Insert " + this.getNodeAsString(node2) + " to " + this.getNodeAsString(node) + " before " + this.getNodeAsString(node3);
    }

    private String getRemoveChildCommandName(Node node, Node node2) {
        return "Remove " + this.getNodeAsString(node2) + " from " + this.getNodeAsString(node);
    }

    private String getChangeNodeValueCommandName(Node node, String string) {
        return "Change " + this.getNodeAsString(node) + " value to " + string;
    }

    private String getNodeChangedCommandName(Node node) {
        return "Node " + this.getNodeAsString(node) + " changed";
    }

    public static class ChangeNodeValueCommand
    extends AbstractUndoableCommand {
        protected Node contextNode;
        protected String newValue;

        public ChangeNodeValueCommand(String string, Node node, String string2) {
            this.setName(string);
            this.contextNode = node;
            this.newValue = string2;
        }

        public void execute() {
            String string = this.contextNode.getNodeValue();
            this.contextNode.setNodeValue(this.newValue);
            this.newValue = string;
        }

        public void undo() {
            this.execute();
        }

        public void redo() {
            this.execute();
        }

        public boolean shouldExecute() {
            return this.contextNode != null;
        }
    }

    public static class RemoveChildCommand
    extends AbstractUndoableCommand {
        protected Node parentNode;
        protected Node childNode;
        protected int indexInChildrenArray;

        public RemoveChildCommand(String string, Node node, Node node2) {
            this.setName(string);
            this.parentNode = node;
            this.childNode = node2;
        }

        public void execute() {
            this.indexInChildrenArray = DOMUtilities.getChildIndex(this.childNode, this.parentNode);
            this.parentNode.removeChild(this.childNode);
        }

        public void undo() {
            Node node = this.parentNode.getChildNodes().item(this.indexInChildrenArray);
            this.parentNode.insertBefore(this.childNode, node);
        }

        public void redo() {
            this.parentNode.removeChild(this.childNode);
        }

        public boolean shouldExecute() {
            return this.parentNode != null && this.childNode != null;
        }
    }

    public static class ReplaceChildCommand
    extends AbstractUndoableCommand {
        protected Node oldParent;
        protected Node oldNextSibling;
        protected Node newNextSibling;
        protected Node parent;
        protected Node child;

        public ReplaceChildCommand(String string, Node node, Node node2, Node node3) {
            this.setName(string);
            this.oldParent = node3.getParentNode();
            this.oldNextSibling = node3.getNextSibling();
            this.parent = node;
            this.child = node3;
            this.newNextSibling = node2;
        }

        public void execute() {
            if (this.newNextSibling != null) {
                this.parent.insertBefore(this.child, this.newNextSibling);
            } else {
                this.parent.appendChild(this.child);
            }
        }

        public void undo() {
            if (this.oldParent != null) {
                this.oldParent.insertBefore(this.child, this.oldNextSibling);
            } else {
                this.parent.removeChild(this.child);
            }
        }

        public void redo() {
            this.execute();
        }

        public boolean shouldExecute() {
            return this.parent != null && this.child != null;
        }
    }

    public static class InsertNodeBeforeCommand
    extends AbstractUndoableCommand {
        protected Node oldParent;
        protected Node oldNextSibling;
        protected Node newNextSibling;
        protected Node parent;
        protected Node child;

        public InsertNodeBeforeCommand(String string, Node node, Node node2, Node node3) {
            this.setName(string);
            this.oldParent = node3.getParentNode();
            this.oldNextSibling = node3.getNextSibling();
            this.parent = node;
            this.child = node3;
            this.newNextSibling = node2;
        }

        public void execute() {
            if (this.newNextSibling != null) {
                this.parent.insertBefore(this.child, this.newNextSibling);
            } else {
                this.parent.appendChild(this.child);
            }
        }

        public void undo() {
            if (this.oldParent != null) {
                this.oldParent.insertBefore(this.child, this.oldNextSibling);
            } else {
                this.parent.removeChild(this.child);
            }
        }

        public void redo() {
            this.execute();
        }

        public boolean shouldExecute() {
            return this.parent != null && this.child != null;
        }
    }

    public static class AppendChildCommand
    extends AbstractUndoableCommand {
        protected Node oldParentNode;
        protected Node oldNextSibling;
        protected Node parentNode;
        protected Node childNode;

        public AppendChildCommand(String string, Node node, Node node2) {
            this.setName(string);
            this.oldParentNode = node2.getParentNode();
            this.oldNextSibling = node2.getNextSibling();
            this.parentNode = node;
            this.childNode = node2;
        }

        public void execute() {
            this.parentNode.appendChild(this.childNode);
        }

        public void undo() {
            if (this.oldParentNode != null) {
                this.oldParentNode.insertBefore(this.childNode, this.oldNextSibling);
            } else {
                this.parentNode.removeChild(this.childNode);
            }
        }

        public void redo() {
            this.execute();
        }

        public boolean shouldExecute() {
            return this.parentNode != null && this.childNode != null;
        }
    }

    public static class CharDataModifiedCommand
    extends AbstractUndoableCommand {
        protected Node contextNode;
        protected String oldValue;
        protected String newValue;

        public CharDataModifiedCommand(String string, Node node, String string2, String string3) {
            this.setName(string);
            this.contextNode = node;
            this.oldValue = string2;
            this.newValue = string3;
        }

        public void execute() {
        }

        public void undo() {
            this.contextNode.setNodeValue(this.oldValue);
        }

        public void redo() {
            this.contextNode.setNodeValue(this.newValue);
        }

        public boolean shouldExecute() {
            return this.contextNode != null;
        }
    }

    public static class AttributeModifiedCommand
    extends AbstractUndoableCommand {
        protected Element contextElement;
        protected String attributeName;
        protected String prevAttributeValue;
        protected String newAttributeValue;
        protected String namespaceURI;

        public AttributeModifiedCommand(String string, Element element, String string2, String string3, String string4, String string5) {
            this.setName(string);
            this.contextElement = element;
            this.attributeName = string2;
            this.prevAttributeValue = string3;
            this.newAttributeValue = string4;
            this.namespaceURI = string5;
        }

        public void execute() {
        }

        public void undo() {
            this.contextElement.setAttributeNS(this.namespaceURI, this.attributeName, this.prevAttributeValue);
        }

        public void redo() {
            this.contextElement.setAttributeNS(this.namespaceURI, this.attributeName, this.newAttributeValue);
        }

        public boolean shouldExecute() {
            return this.contextElement != null && this.attributeName.length() != 0;
        }
    }

    public static class AttributeRemovedCommand
    extends AbstractUndoableCommand {
        protected Element contextElement;
        protected String attributeName;
        protected String prevValue;
        protected String namespaceURI;

        public AttributeRemovedCommand(String string, Element element, String string2, String string3, String string4) {
            this.setName(string);
            this.contextElement = element;
            this.attributeName = string2;
            this.prevValue = string3;
            this.namespaceURI = string4;
        }

        public void execute() {
        }

        public void undo() {
            this.contextElement.setAttributeNS(this.namespaceURI, this.attributeName, this.prevValue);
        }

        public void redo() {
            this.contextElement.removeAttributeNS(this.namespaceURI, this.attributeName);
        }

        public boolean shouldExecute() {
            return this.contextElement != null && this.attributeName.length() != 0;
        }
    }

    public static class AttributeAddedCommand
    extends AbstractUndoableCommand {
        protected Element contextElement;
        protected String attributeName;
        protected String newValue;
        protected String namespaceURI;

        public AttributeAddedCommand(String string, Element element, String string2, String string3, String string4) {
            this.setName(string);
            this.contextElement = element;
            this.attributeName = string2;
            this.newValue = string3;
            this.namespaceURI = string4;
        }

        public void execute() {
        }

        public void undo() {
            this.contextElement.removeAttributeNS(this.namespaceURI, this.attributeName);
        }

        public void redo() {
            this.contextElement.setAttributeNS(this.namespaceURI, this.attributeName, this.newValue);
        }

        public boolean shouldExecute() {
            return this.contextElement != null && this.attributeName.length() != 0;
        }
    }

    public static class NodeRemovedCommand
    extends AbstractUndoableCommand {
        protected Node oldSibling;
        protected Node oldParent;
        protected Node contextNode;

        public NodeRemovedCommand(String string, Node node, Node node2, Node node3) {
            this.setName(string);
            this.oldParent = node;
            this.contextNode = node3;
            this.oldSibling = node2;
        }

        public void execute() {
        }

        public void undo() {
            if (this.oldSibling != null) {
                this.oldParent.insertBefore(this.contextNode, this.oldSibling);
            } else {
                this.oldParent.appendChild(this.contextNode);
            }
        }

        public void redo() {
            this.oldParent.removeChild(this.contextNode);
        }

        public boolean shouldExecute() {
            return this.oldParent != null && this.contextNode != null;
        }
    }

    public static class NodeInsertedCommand
    extends AbstractUndoableCommand {
        protected Node newSibling;
        protected Node newParent;
        protected Node contextNode;

        public NodeInsertedCommand(String string, Node node, Node node2, Node node3) {
            this.setName(string);
            this.newParent = node;
            this.contextNode = node3;
            this.newSibling = node2;
        }

        public void execute() {
        }

        public void undo() {
            this.newParent.removeChild(this.contextNode);
        }

        public void redo() {
            if (this.newSibling != null) {
                this.newParent.insertBefore(this.contextNode, this.newSibling);
            } else {
                this.newParent.appendChild(this.contextNode);
            }
        }

        public boolean shouldExecute() {
            return this.newParent != null && this.contextNode != null;
        }
    }

    public static class CompoundUpdateCommand
    extends AbstractCompoundCommand {
        public CompoundUpdateCommand(String string) {
            this.setName(string);
        }
    }
}

