/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.Comparer;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Pattern;

public class BytecodeConstant
extends Expression {
    public static final BytecodeConstant NULL = new NullMetadata();
    private final Object _constant;

    public BytecodeConstant(Object constant) {
        super(-34);
        this._constant = constant;
    }

    public final Object getConstantValue() {
        return this._constant;
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        if (this._constant instanceof AstNode) {
            return ((AstNode)this._constant).acceptVisitor(visitor, data);
        }
        return visitor.visitBytecodeConstant(this, data);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.UNKNOWN;
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof Pattern) {
            return other.matches(this, match);
        }
        return other instanceof BytecodeConstant && Comparer.equals(this._constant, ((BytecodeConstant)other)._constant);
    }

    private static final class NullMetadata
    extends BytecodeConstant {
        public NullMetadata() {
            super(null);
        }

        @Override
        public final boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }
    }
}

