# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
TopoDS module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_topods.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _TopoDS
else:
    import _TopoDS

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _TopoDS.delete_SwigPyIterator

    def value(self):
        return _TopoDS.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _TopoDS.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _TopoDS.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _TopoDS.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _TopoDS.SwigPyIterator_equal(self, x)

    def copy(self):
        return _TopoDS.SwigPyIterator_copy(self)

    def next(self):
        return _TopoDS.SwigPyIterator_next(self)

    def __next__(self):
        return _TopoDS.SwigPyIterator___next__(self)

    def previous(self):
        return _TopoDS.SwigPyIterator_previous(self)

    def advance(self, n):
        return _TopoDS.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _TopoDS.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _TopoDS.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _TopoDS.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _TopoDS.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _TopoDS.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _TopoDS.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _TopoDS:
_TopoDS.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _TopoDS.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Message
import OCC.Core.TCollection
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_TopoDS_HShape_Create():
    return _TopoDS.Handle_TopoDS_HShape_Create()

def Handle_TopoDS_HShape_DownCast(t):
    return _TopoDS.Handle_TopoDS_HShape_DownCast(t)

def Handle_TopoDS_HShape_IsNull(t):
    return _TopoDS.Handle_TopoDS_HShape_IsNull(t)

def Handle_TopoDS_TShape_Create():
    return _TopoDS.Handle_TopoDS_TShape_Create()

def Handle_TopoDS_TShape_DownCast(t):
    return _TopoDS.Handle_TopoDS_TShape_DownCast(t)

def Handle_TopoDS_TShape_IsNull(t):
    return _TopoDS.Handle_TopoDS_TShape_IsNull(t)

def Handle_TopoDS_TCompSolid_Create():
    return _TopoDS.Handle_TopoDS_TCompSolid_Create()

def Handle_TopoDS_TCompSolid_DownCast(t):
    return _TopoDS.Handle_TopoDS_TCompSolid_DownCast(t)

def Handle_TopoDS_TCompSolid_IsNull(t):
    return _TopoDS.Handle_TopoDS_TCompSolid_IsNull(t)

def Handle_TopoDS_TCompound_Create():
    return _TopoDS.Handle_TopoDS_TCompound_Create()

def Handle_TopoDS_TCompound_DownCast(t):
    return _TopoDS.Handle_TopoDS_TCompound_DownCast(t)

def Handle_TopoDS_TCompound_IsNull(t):
    return _TopoDS.Handle_TopoDS_TCompound_IsNull(t)

def Handle_TopoDS_TEdge_Create():
    return _TopoDS.Handle_TopoDS_TEdge_Create()

def Handle_TopoDS_TEdge_DownCast(t):
    return _TopoDS.Handle_TopoDS_TEdge_DownCast(t)

def Handle_TopoDS_TEdge_IsNull(t):
    return _TopoDS.Handle_TopoDS_TEdge_IsNull(t)

def Handle_TopoDS_TFace_Create():
    return _TopoDS.Handle_TopoDS_TFace_Create()

def Handle_TopoDS_TFace_DownCast(t):
    return _TopoDS.Handle_TopoDS_TFace_DownCast(t)

def Handle_TopoDS_TFace_IsNull(t):
    return _TopoDS.Handle_TopoDS_TFace_IsNull(t)

def Handle_TopoDS_TShell_Create():
    return _TopoDS.Handle_TopoDS_TShell_Create()

def Handle_TopoDS_TShell_DownCast(t):
    return _TopoDS.Handle_TopoDS_TShell_DownCast(t)

def Handle_TopoDS_TShell_IsNull(t):
    return _TopoDS.Handle_TopoDS_TShell_IsNull(t)

def Handle_TopoDS_TSolid_Create():
    return _TopoDS.Handle_TopoDS_TSolid_Create()

def Handle_TopoDS_TSolid_DownCast(t):
    return _TopoDS.Handle_TopoDS_TSolid_DownCast(t)

def Handle_TopoDS_TSolid_IsNull(t):
    return _TopoDS.Handle_TopoDS_TSolid_IsNull(t)

def Handle_TopoDS_TVertex_Create():
    return _TopoDS.Handle_TopoDS_TVertex_Create()

def Handle_TopoDS_TVertex_DownCast(t):
    return _TopoDS.Handle_TopoDS_TVertex_DownCast(t)

def Handle_TopoDS_TVertex_IsNull(t):
    return _TopoDS.Handle_TopoDS_TVertex_IsNull(t)

def Handle_TopoDS_TWire_Create():
    return _TopoDS.Handle_TopoDS_TWire_Create()

def Handle_TopoDS_TWire_DownCast(t):
    return _TopoDS.Handle_TopoDS_TWire_DownCast(t)

def Handle_TopoDS_TWire_IsNull(t):
    return _TopoDS.Handle_TopoDS_TWire_IsNull(t)
class TopoDS_ListIteratorOfListOfShape(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _TopoDS.TopoDS_ListIteratorOfListOfShape_swiginit(self, _TopoDS.new_TopoDS_ListIteratorOfListOfShape(*args))

    def More(self):
        return _TopoDS.TopoDS_ListIteratorOfListOfShape_More(self)

    def Next(self):
        return _TopoDS.TopoDS_ListIteratorOfListOfShape_Next(self)

    def Value(self):
        return _TopoDS.TopoDS_ListIteratorOfListOfShape_Value(self)

    def ChangeValue(self):
        return _TopoDS.TopoDS_ListIteratorOfListOfShape_ChangeValue(self)
    __swig_destroy__ = _TopoDS.delete_TopoDS_ListIteratorOfListOfShape

# Register TopoDS_ListIteratorOfListOfShape in _TopoDS:
_TopoDS.TopoDS_ListIteratorOfListOfShape_swigregister(TopoDS_ListIteratorOfListOfShape)
class TopoDS_ListOfShape(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _TopoDS.TopoDS_ListOfShape_begin(self)

    def end(self):
        return _TopoDS.TopoDS_ListOfShape_end(self)

    def cbegin(self):
        return _TopoDS.TopoDS_ListOfShape_cbegin(self)

    def cend(self):
        return _TopoDS.TopoDS_ListOfShape_cend(self)

    def __init__(self, *args):
        _TopoDS.TopoDS_ListOfShape_swiginit(self, _TopoDS.new_TopoDS_ListOfShape(*args))

    def Size(self):
        return _TopoDS.TopoDS_ListOfShape_Size(self)

    def Assign(self, theOther):
        return _TopoDS.TopoDS_ListOfShape_Assign(self, theOther)

    def Set(self, theOther):
        return _TopoDS.TopoDS_ListOfShape_Set(self, theOther)

    def Clear(self, theAllocator=0):
        return _TopoDS.TopoDS_ListOfShape_Clear(self, theAllocator)

    def First(self):
        return _TopoDS.TopoDS_ListOfShape_First(self)

    def Last(self):
        return _TopoDS.TopoDS_ListOfShape_Last(self)

    def Append(self, *args):
        return _TopoDS.TopoDS_ListOfShape_Append(self, *args)

    def Prepend(self, *args):
        return _TopoDS.TopoDS_ListOfShape_Prepend(self, *args)

    def RemoveFirst(self):
        return _TopoDS.TopoDS_ListOfShape_RemoveFirst(self)

    def Remove(self, theIter):
        return _TopoDS.TopoDS_ListOfShape_Remove(self, theIter)

    def InsertBefore(self, *args):
        return _TopoDS.TopoDS_ListOfShape_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _TopoDS.TopoDS_ListOfShape_InsertAfter(self, *args)

    def Reverse(self):
        return _TopoDS.TopoDS_ListOfShape_Reverse(self)
    __swig_destroy__ = _TopoDS.delete_TopoDS_ListOfShape

    def __len__(self):
        return self.Size()


# Register TopoDS_ListOfShape in _TopoDS:
_TopoDS.TopoDS_ListOfShape_swigregister(TopoDS_ListOfShape)
class topods(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def CompSolid(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopoDS_CompSolid

        Description
        -----------
        Casts shape s to the more specialized return type, compsolid. exceptions standard_typemismatch if s cannot be cast to this return type.

        Parameters
        ----------
        &: TopoDS_Shape

        Return
        -------
        TopoDS_CompSolid

        Description
        -----------
        No available documentation.

        """
        return _TopoDS.topods_CompSolid(*args)

    @staticmethod
    def Compound(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopoDS_Compound

        Description
        -----------
        Casts shape s to the more specialized return type, compound. exceptions standard_typemismatch if s cannot be cast to this return type.

        Parameters
        ----------
        &: TopoDS_Shape

        Return
        -------
        TopoDS_Compound

        Description
        -----------
        No available documentation.

        """
        return _TopoDS.topods_Compound(*args)

    @staticmethod
    def Edge(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Casts shape s to the more specialized return type, edge exceptions standard_typemismatch if s cannot be cast to this return type.

        Parameters
        ----------
        &: TopoDS_Shape

        Return
        -------
        TopoDS_Edge

        Description
        -----------
        No available documentation.

        """
        return _TopoDS.topods_Edge(*args)

    @staticmethod
    def Face(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopoDS_Face

        Description
        -----------
        Casts shape s to the more specialized return type, face. exceptions standard_typemismatch if s cannot be cast to this return type.

        Parameters
        ----------
        &: TopoDS_Shape

        Return
        -------
        TopoDS_Face

        Description
        -----------
        No available documentation.

        """
        return _TopoDS.topods_Face(*args)

    @staticmethod
    def Shell(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopoDS_Shell

        Description
        -----------
        Casts shape s to the more specialized return type, shell. exceptions standard_typemismatch if s cannot be cast to this return type.

        Parameters
        ----------
        &: TopoDS_Shape

        Return
        -------
        TopoDS_Shell

        Description
        -----------
        No available documentation.

        """
        return _TopoDS.topods_Shell(*args)

    @staticmethod
    def Solid(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopoDS_Solid

        Description
        -----------
        Casts shape s to the more specialized return type, solid. exceptions standard_typemismatch if s cannot be cast to this return type.

        Parameters
        ----------
        &: TopoDS_Shape

        Return
        -------
        TopoDS_Solid

        Description
        -----------
        No available documentation.

        """
        return _TopoDS.topods_Solid(*args)

    @staticmethod
    def Vertex(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        Basic tool to access the data structure. casts shape s to the more specialized return type, vertex. exceptions standard_typemismatch if s cannot be cast to this return type.

        Parameters
        ----------
        &: TopoDS_Shape

        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        No available documentation.

        """
        return _TopoDS.topods_Vertex(*args)

    @staticmethod
    def Wire(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopoDS_Wire

        Description
        -----------
        Casts shape s to the more specialized return type, wire. exceptions standard_typemismatch if s cannot be cast to this return type.

        Parameters
        ----------
        &: TopoDS_Shape

        Return
        -------
        TopoDS_Wire

        Description
        -----------
        No available documentation.

        """
        return _TopoDS.topods_Wire(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _TopoDS.topods_swiginit(self, _TopoDS.new_topods())
    __swig_destroy__ = _TopoDS.delete_topods

# Register topods in _TopoDS:
_TopoDS.topods_swigregister(topods)
class TopoDS_AlertAttribute(OCC.Core.Message.Message_AttributeStream):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theName: str (optional, default to TCollection_AsciiString())

        Return
        -------
        None

        Description
        -----------
        Constructor with shape argument.

        """
        _TopoDS.TopoDS_AlertAttribute_swiginit(self, _TopoDS.new_TopoDS_AlertAttribute(*args))

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _TopoDS.TopoDS_AlertAttribute_DumpJsonToString(self, depth)

    def GetShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns contained shape.

        """
        return _TopoDS.TopoDS_AlertAttribute_GetShape(self, *args)

    @staticmethod
    def Send(*args):
        r"""

        Parameters
        ----------
        theMessenger: Message_Messenger
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Push shape information into messenger.

        """
        return _TopoDS.TopoDS_AlertAttribute_Send(*args)

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_AlertAttribute

# Register TopoDS_AlertAttribute in _TopoDS:
_TopoDS.TopoDS_AlertAttribute_swigregister(TopoDS_AlertAttribute)
class TopoDS_AlertWithShape(OCC.Core.Message.Message_Alert):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Constructor with shape argument.

        """
        _TopoDS.TopoDS_AlertWithShape_swiginit(self, _TopoDS.new_TopoDS_AlertWithShape(*args))

    def GetShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns contained shape.

        """
        return _TopoDS.TopoDS_AlertWithShape_GetShape(self, *args)

    def SetShape(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Sets the shape.

        """
        return _TopoDS.TopoDS_AlertWithShape_SetShape(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_AlertWithShape

# Register TopoDS_AlertWithShape in _TopoDS:
_TopoDS.TopoDS_AlertWithShape_swigregister(TopoDS_AlertWithShape)
class TopoDS_Builder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def Add(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        C: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Add the shape c in the shape s. exceptions - topods_frozenshape if s is not free and cannot be modified. - topods__uncompatibleshapes if s and c are not compatible.

        """
        return _TopoDS.TopoDS_Builder_Add(self, *args)

    def MakeCompSolid(self, *args):
        r"""

        Parameters
        ----------
        C: TopoDS_CompSolid

        Return
        -------
        None

        Description
        -----------
        Make an empty composite solid.

        """
        return _TopoDS.TopoDS_Builder_MakeCompSolid(self, *args)

    def MakeCompound(self, *args):
        r"""

        Parameters
        ----------
        C: TopoDS_Compound

        Return
        -------
        None

        Description
        -----------
        Make an empty compound.

        """
        return _TopoDS.TopoDS_Builder_MakeCompound(self, *args)

    def MakeShell(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shell

        Return
        -------
        None

        Description
        -----------
        Make an empty shell.

        """
        return _TopoDS.TopoDS_Builder_MakeShell(self, *args)

    def MakeSolid(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Solid

        Return
        -------
        None

        Description
        -----------
        Make a solid covering the whole 3d space.

        """
        return _TopoDS.TopoDS_Builder_MakeSolid(self, *args)

    def MakeWire(self, *args):
        r"""

        Parameters
        ----------
        W: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        Make an empty wire.

        """
        return _TopoDS.TopoDS_Builder_MakeWire(self, *args)

    def Remove(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        C: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Remove the shape c from the shape s. exceptions topods_frozenshape if s is frozen and cannot be modified.

        """
        return _TopoDS.TopoDS_Builder_Remove(self, *args)

    __repr__ = _dumps_object


    def __init__(self):
        _TopoDS.TopoDS_Builder_swiginit(self, _TopoDS.new_TopoDS_Builder())
    __swig_destroy__ = _TopoDS.delete_TopoDS_Builder

# Register TopoDS_Builder in _TopoDS:
_TopoDS.TopoDS_Builder_swigregister(TopoDS_Builder)
class TopoDS_HShape(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an empty shape object.

        Parameters
        ----------
        aShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Constructs a shape object defined by the shape ashape.

        """
        _TopoDS.TopoDS_HShape_swiginit(self, _TopoDS.new_TopoDS_HShape(*args))

    def ChangeShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Exchanges the topods_shape object defining this shape for another one referencing the same underlying shape accesses the list of shapes within the underlying shape referenced by the topods_shape object. returns a reference to a topods_shape based on this shape. the topods_shape can be modified.

        """
        return _TopoDS.TopoDS_HShape_ChangeShape(self, *args)

    def Shape(self, *args):
        r"""

        Parameters
        ----------
        aShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Loads this shape with the shape ashape.
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns a reference to a constant topods_shape based on this shape.

        """
        return _TopoDS.TopoDS_HShape_Shape(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_HShape_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_HShape

# Register TopoDS_HShape in _TopoDS:
_TopoDS.TopoDS_HShape_swigregister(TopoDS_HShape)
class TopoDS_Iterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty iterator.

        Parameters
        ----------
        S: TopoDS_Shape
        cumOri: bool (optional, default to Standard_True)
        cumLoc: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Creates an iterator on <s> sub-shapes. note: - if cumori is true, the function composes all sub-shapes with the orientation of s. - if cumloc is true, the function multiplies all sub-shapes by the location of s, i.e. it applies to each sub-shape the transformation that is associated with s.

        """
        _TopoDS.TopoDS_Iterator_swiginit(self, _TopoDS.new_TopoDS_Iterator(*args))

    def Initialize(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        cumOri: bool (optional, default to Standard_True)
        cumLoc: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Initializes this iterator with shape s. note: - if cumori is true, the function composes all sub-shapes with the orientation of s. - if cumloc is true, the function multiplies all sub-shapes by the location of s, i.e. it applies to each sub-shape the transformation that is associated with s.

        """
        return _TopoDS.TopoDS_Iterator_Initialize(self, *args)

    def More(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if there is another sub-shape in the shape which this iterator is scanning.

        """
        return _TopoDS.TopoDS_Iterator_More(self, *args)

    def Next(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Moves on to the next sub-shape in the shape which this iterator is scanning. exceptions standard_nomoreobject if there are no more sub-shapes in the shape.

        """
        return _TopoDS.TopoDS_Iterator_Next(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the current sub-shape in the shape which this iterator is scanning. exceptions standard_nosuchobject if there is no current sub-shape.

        """
        return _TopoDS.TopoDS_Iterator_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Iterator

# Register TopoDS_Iterator in _TopoDS:
_TopoDS.TopoDS_Iterator_swigregister(TopoDS_Iterator)
class TopoDS_Shape(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(TopoDS_Shape self, TopoDS_Shape arg0) -> TopoDS_ShapeReturn
        -------
        None

        Description
        -----------
        Creates a null shape referring to nothing.

        """
        _TopoDS.TopoDS_Shape_swiginit(self, _TopoDS.new_TopoDS_Shape(*args))

    def Checked(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the checked flag.

        Parameters
        ----------
        theIsChecked: bool

        Return
        -------
        None

        Description
        -----------
        Sets the checked flag.

        """
        return _TopoDS.TopoDS_Shape_Checked(self, *args)

    def Closed(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the closedness flag.

        Parameters
        ----------
        theIsClosed: bool

        Return
        -------
        None

        Description
        -----------
        Sets the closedness flag.

        """
        return _TopoDS.TopoDS_Shape_Closed(self, *args)

    def Complement(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Complements the orientation, using the complement method from the topabs package.

        """
        return _TopoDS.TopoDS_Shape_Complement(self, *args)

    def Complemented(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns a shape similar to <self> with the orientation complemented, using the complement method from the topabs package.

        """
        return _TopoDS.TopoDS_Shape_Complemented(self, *args)

    def Compose(self, *args):
        r"""

        Parameters
        ----------
        theOrient: TopAbs_Orientation

        Return
        -------
        None

        Description
        -----------
        Updates the shape orientation by composition with theorient, using the compose method from the topabs package.

        """
        return _TopoDS.TopoDS_Shape_Compose(self, *args)

    def Composed(self, *args):
        r"""

        Parameters
        ----------
        theOrient: TopAbs_Orientation

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns a shape similar to <self> with the orientation composed with theorient, using the compose method from the topabs package.

        """
        return _TopoDS.TopoDS_Shape_Composed(self, *args)

    def Convex(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the convexness flag.

        Parameters
        ----------
        theIsConvex: bool

        Return
        -------
        None

        Description
        -----------
        Sets the convexness flag.

        """
        return _TopoDS.TopoDS_Shape_Convex(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _TopoDS.TopoDS_Shape_DumpJsonToString(self, depth)

    def EmptyCopied(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns a new shape with the same orientation and location and a new tshape with the same geometry and no sub-shapes.

        """
        return _TopoDS.TopoDS_Shape_EmptyCopied(self, *args)

    def EmptyCopy(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Replace <self> by a new shape with the same orientation and location and a new tshape with the same geometry and no sub-shapes.

        """
        return _TopoDS.TopoDS_Shape_EmptyCopy(self, *args)

    def Free(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the free flag.

        Parameters
        ----------
        theIsFree: bool

        Return
        -------
        None

        Description
        -----------
        Sets the free flag.

        """
        return _TopoDS.TopoDS_Shape_Free(self, *args)

    def HashCode(self, *args):
        r"""

        Parameters
        ----------
        theUpperBound: int

        Return
        -------
        int

        Description
        -----------
        Returns a hashed value denoting <self>. this value is in the range [1, theupperbound]. it is computed from the tshape and the location. the orientation is not used. @param theupperbound the upper bound of the range a computing hash code must be within return a computed hash code, in the range [1, theupperbound].

        """
        return _TopoDS.TopoDS_Shape_HashCode(self, *args)

    def __hash__(self):
        r"""Json string serializer."""
        return _TopoDS.TopoDS_Shape___hash__(self)

    def Infinite(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the infinity flag.

        Parameters
        ----------
        theIsInfinite: bool

        Return
        -------
        None

        Description
        -----------
        Sets the infinity flag.

        """
        return _TopoDS.TopoDS_Shape_Infinite(self, *args)

    def IsEqual(self, *args):
        r"""

        Parameters
        ----------
        theOther: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Returns true if two shapes are equal, i.e. if they share the same tshape with the same locations and orientations.

        """
        return _TopoDS.TopoDS_Shape_IsEqual(self, *args)

    def IsNotEqual(self, *args):
        r"""

        Parameters
        ----------
        theOther: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Negation of the isequal method.

        """
        return _TopoDS.TopoDS_Shape_IsNotEqual(self, *args)

    def IsNull(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this shape is null. in other words, it references no underlying shape with the potential to be given a location and an orientation.

        """
        return _TopoDS.TopoDS_Shape_IsNull(self, *args)

    def IsPartner(self, *args):
        r"""

        Parameters
        ----------
        theOther: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Returns true if two shapes are partners, i.e. if they share the same tshape. locations and orientations may differ.

        """
        return _TopoDS.TopoDS_Shape_IsPartner(self, *args)

    def IsSame(self, *args):
        r"""

        Parameters
        ----------
        theOther: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Returns true if two shapes are same, i.e. if they share the same tshape with the same locations. orientations may differ.

        """
        return _TopoDS.TopoDS_Shape_IsSame(self, *args)

    def Located(self, *args):
        r"""

        Parameters
        ----------
        theLoc: TopLoc_Location
        theRaiseExc: bool (optional, default to Standard_True)

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns a shape similar to <self> with the local coordinate system set to <loc>.

        """
        return _TopoDS.TopoDS_Shape_Located(self, *args)

    def Location(self, *args):
        r"""
        Return
        -------
        TopLoc_Location

        Description
        -----------
        Returns the shape local coordinate system.

        Parameters
        ----------
        theLoc: TopLoc_Location
        theRaiseExc: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Sets the shape local coordinate system.

        """
        return _TopoDS.TopoDS_Shape_Location(self, *args)

    def Locked(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the locked flag.

        Parameters
        ----------
        theIsLocked: bool

        Return
        -------
        None

        Description
        -----------
        Sets the locked flag.

        """
        return _TopoDS.TopoDS_Shape_Locked(self, *args)

    def Modified(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the modification flag.

        Parameters
        ----------
        theIsModified: bool

        Return
        -------
        None

        Description
        -----------
        Sets the modification flag.

        """
        return _TopoDS.TopoDS_Shape_Modified(self, *args)

    def Move(self, *args):
        r"""

        Parameters
        ----------
        thePosition: TopLoc_Location
        theRaiseExc: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Multiplies the shape location by theposition.

        """
        return _TopoDS.TopoDS_Shape_Move(self, *args)

    def Moved(self, *args):
        r"""

        Parameters
        ----------
        thePosition: TopLoc_Location
        theRaiseExc: bool (optional, default to Standard_True)

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns a shape similar to <self> with a location multiplied by theposition.

        """
        return _TopoDS.TopoDS_Shape_Moved(self, *args)

    def NbChildren(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of direct sub-shapes (children). @sa topods_iterator for accessing sub-shapes.

        """
        return _TopoDS.TopoDS_Shape_NbChildren(self, *args)

    def Nullify(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Destroys the reference to the underlying shape stored in this shape. as a result, this shape becomes null.

        """
        return _TopoDS.TopoDS_Shape_Nullify(self, *args)

    def Orientable(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the orientability flag.

        Parameters
        ----------
        theIsOrientable: bool

        Return
        -------
        None

        Description
        -----------
        Sets the orientability flag.

        """
        return _TopoDS.TopoDS_Shape_Orientable(self, *args)

    def Orientation(self, *args):
        r"""
        Return
        -------
        TopAbs_Orientation

        Description
        -----------
        Returns the shape orientation.

        Parameters
        ----------
        theOrient: TopAbs_Orientation

        Return
        -------
        None

        Description
        -----------
        Sets the shape orientation.

        """
        return _TopoDS.TopoDS_Shape_Orientation(self, *args)

    def Oriented(self, *args):
        r"""

        Parameters
        ----------
        theOrient: TopAbs_Orientation

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns a shape similar to <self> with the orientation set to <or>.

        """
        return _TopoDS.TopoDS_Shape_Oriented(self, *args)

    def Reverse(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reverses the orientation, using the reverse method from the topabs package.

        """
        return _TopoDS.TopoDS_Shape_Reverse(self, *args)

    def Reversed(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns a shape similar to <self> with the orientation reversed, using the reverse method from the topabs package.

        """
        return _TopoDS.TopoDS_Shape_Reversed(self, *args)

    def ShapeType(self, *args):
        r"""
        Return
        -------
        TopAbs_ShapeEnum

        Description
        -----------
        Returns the value of the topabs_shapeenum enumeration that corresponds to this shape, for example vertex, edge, and so on. exceptions standard_nullobject if this shape is null.

        """
        return _TopoDS.TopoDS_Shape_ShapeType(self, *args)

    def TShape(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TopoDS_TShape>

        Description
        -----------
        Returns a handle to the actual shape implementation.

        Parameters
        ----------
        theTShape: TopoDS_TShape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _TopoDS.TopoDS_Shape_TShape(self, *args)

    def __ne_wrapper__(self, other):
        r"""Json string serializer."""
        return _TopoDS.TopoDS_Shape___ne_wrapper__(self, other)

    def __ne__(self, right):
        try:
            return self.__ne_wrapper__(right)
        except:
            return True


    def __eq_wrapper__(self, other):
        r"""Json string serializer."""
        return _TopoDS.TopoDS_Shape___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    def __getstate__(self):
        from .BRepTools import breptools
        str_shape = breptools.WriteToString(self, True)
        return str_shape
    def __setstate__(self, state):
        from .BRepTools import breptools
        the_shape = breptools.ReadFromString(state)
        self.this = the_shape.this


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Shape

# Register TopoDS_Shape in _TopoDS:
_TopoDS.TopoDS_Shape_swigregister(TopoDS_Shape)
class TopoDS_TShape(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Checked(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the checked flag.

        Parameters
        ----------
        theIsChecked: bool

        Return
        -------
        None

        Description
        -----------
        Sets the checked flag.

        """
        return _TopoDS.TopoDS_TShape_Checked(self, *args)

    def Closed(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the closedness flag.

        Parameters
        ----------
        theIsClosed: bool

        Return
        -------
        None

        Description
        -----------
        Sets the closedness flag.

        """
        return _TopoDS.TopoDS_TShape_Closed(self, *args)

    def Convex(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the convexness flag.

        Parameters
        ----------
        theIsConvex: bool

        Return
        -------
        None

        Description
        -----------
        Sets the convexness flag.

        """
        return _TopoDS.TopoDS_TShape_Convex(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _TopoDS.TopoDS_TShape_DumpJsonToString(self, depth)

    def EmptyCopy(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TopoDS_TShape>

        Description
        -----------
        Returns a copy of the tshape with no sub-shapes.

        """
        return _TopoDS.TopoDS_TShape_EmptyCopy(self, *args)

    def Free(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the free flag.

        Parameters
        ----------
        theIsFree: bool

        Return
        -------
        None

        Description
        -----------
        Sets the free flag.

        """
        return _TopoDS.TopoDS_TShape_Free(self, *args)

    def Infinite(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the infinity flag.

        Parameters
        ----------
        theIsInfinite: bool

        Return
        -------
        None

        Description
        -----------
        Sets the infinity flag.

        """
        return _TopoDS.TopoDS_TShape_Infinite(self, *args)

    def Locked(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the locked flag.

        Parameters
        ----------
        theIsLocked: bool

        Return
        -------
        None

        Description
        -----------
        Sets the locked flag.

        """
        return _TopoDS.TopoDS_TShape_Locked(self, *args)

    def Modified(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the modification flag.

        Parameters
        ----------
        theIsModified: bool

        Return
        -------
        None

        Description
        -----------
        Sets the modification flag.

        """
        return _TopoDS.TopoDS_TShape_Modified(self, *args)

    def NbChildren(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of direct sub-shapes (children). @sa topods_iterator for accessing sub-shapes.

        """
        return _TopoDS.TopoDS_TShape_NbChildren(self, *args)

    def Orientable(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the orientability flag.

        Parameters
        ----------
        theIsOrientable: bool

        Return
        -------
        None

        Description
        -----------
        Sets the orientability flag.

        """
        return _TopoDS.TopoDS_TShape_Orientable(self, *args)

    def ShapeType(self, *args):
        r"""
        Return
        -------
        TopAbs_ShapeEnum

        Description
        -----------
        Returns the type as a term of the shapeenum enum: vertex, edge, wire, face, ....

        """
        return _TopoDS.TopoDS_TShape_ShapeType(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TShape_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TShape

# Register TopoDS_TShape in _TopoDS:
_TopoDS.TopoDS_TShape_swigregister(TopoDS_TShape)
class TopoDS_CompSolid(TopoDS_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an undefined compsolid.

        """
        _TopoDS.TopoDS_CompSolid_swiginit(self, _TopoDS.new_TopoDS_CompSolid(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_CompSolid

# Register TopoDS_CompSolid in _TopoDS:
_TopoDS.TopoDS_CompSolid_swigregister(TopoDS_CompSolid)
class TopoDS_Compound(TopoDS_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an undefined compound.

        """
        _TopoDS.TopoDS_Compound_swiginit(self, _TopoDS.new_TopoDS_Compound(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Compound

# Register TopoDS_Compound in _TopoDS:
_TopoDS.TopoDS_Compound_swigregister(TopoDS_Compound)
class TopoDS_Edge(TopoDS_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Undefined edge.

        """
        _TopoDS.TopoDS_Edge_swiginit(self, _TopoDS.new_TopoDS_Edge(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Edge

# Register TopoDS_Edge in _TopoDS:
_TopoDS.TopoDS_Edge_swigregister(TopoDS_Edge)
class TopoDS_Face(TopoDS_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Undefined face.

        """
        _TopoDS.TopoDS_Face_swiginit(self, _TopoDS.new_TopoDS_Face(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Face

# Register TopoDS_Face in _TopoDS:
_TopoDS.TopoDS_Face_swigregister(TopoDS_Face)
class TopoDS_Shell(TopoDS_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an undefined shell.

        """
        _TopoDS.TopoDS_Shell_swiginit(self, _TopoDS.new_TopoDS_Shell(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Shell

# Register TopoDS_Shell in _TopoDS:
_TopoDS.TopoDS_Shell_swigregister(TopoDS_Shell)
class TopoDS_Solid(TopoDS_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an undefined solid.

        """
        _TopoDS.TopoDS_Solid_swiginit(self, _TopoDS.new_TopoDS_Solid(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Solid

# Register TopoDS_Solid in _TopoDS:
_TopoDS.TopoDS_Solid_swigregister(TopoDS_Solid)
class TopoDS_TCompSolid(TopoDS_TShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty tcompsolid.

        """
        _TopoDS.TopoDS_TCompSolid_swiginit(self, _TopoDS.new_TopoDS_TCompSolid(*args))


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TCompSolid_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TCompSolid

# Register TopoDS_TCompSolid in _TopoDS:
_TopoDS.TopoDS_TCompSolid_swigregister(TopoDS_TCompSolid)
class TopoDS_TCompound(TopoDS_TShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty tcompound.

        """
        _TopoDS.TopoDS_TCompound_swiginit(self, _TopoDS.new_TopoDS_TCompound(*args))


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TCompound_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TCompound

# Register TopoDS_TCompound in _TopoDS:
_TopoDS.TopoDS_TCompound_swigregister(TopoDS_TCompound)
class TopoDS_TEdge(TopoDS_TShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TEdge_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TEdge

# Register TopoDS_TEdge in _TopoDS:
_TopoDS.TopoDS_TEdge_swigregister(TopoDS_TEdge)
class TopoDS_TFace(TopoDS_TShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty tface.

        """
        _TopoDS.TopoDS_TFace_swiginit(self, _TopoDS.new_TopoDS_TFace(*args))


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TFace_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TFace

# Register TopoDS_TFace in _TopoDS:
_TopoDS.TopoDS_TFace_swigregister(TopoDS_TFace)
class TopoDS_TShell(TopoDS_TShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty tshell.

        """
        _TopoDS.TopoDS_TShell_swiginit(self, _TopoDS.new_TopoDS_TShell(*args))


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TShell_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TShell

# Register TopoDS_TShell in _TopoDS:
_TopoDS.TopoDS_TShell_swigregister(TopoDS_TShell)
class TopoDS_TSolid(TopoDS_TShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty tsolid.

        """
        _TopoDS.TopoDS_TSolid_swiginit(self, _TopoDS.new_TopoDS_TSolid(*args))


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TSolid_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TSolid

# Register TopoDS_TSolid in _TopoDS:
_TopoDS.TopoDS_TSolid_swigregister(TopoDS_TSolid)
class TopoDS_TVertex(TopoDS_TShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TVertex_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TVertex

# Register TopoDS_TVertex in _TopoDS:
_TopoDS.TopoDS_TVertex_swigregister(TopoDS_TVertex)
class TopoDS_TWire(TopoDS_TShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty twire.

        """
        _TopoDS.TopoDS_TWire_swiginit(self, _TopoDS.new_TopoDS_TWire(*args))


    @staticmethod
    def DownCast(t):
      return Handle_TopoDS_TWire_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_TWire

# Register TopoDS_TWire in _TopoDS:
_TopoDS.TopoDS_TWire_swigregister(TopoDS_TWire)
class TopoDS_Vertex(TopoDS_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(TopoDS_Vertex self, TopoDS_Vertex arg0) -> TopoDS_VertexReturn
        -------
        None

        Description
        -----------
        Undefined vertex.

        """
        _TopoDS.TopoDS_Vertex_swiginit(self, _TopoDS.new_TopoDS_Vertex(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Vertex

# Register TopoDS_Vertex in _TopoDS:
_TopoDS.TopoDS_Vertex_swigregister(TopoDS_Vertex)
class TopoDS_Wire(TopoDS_Shape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Undefined wire.

        """
        _TopoDS.TopoDS_Wire_swiginit(self, _TopoDS.new_TopoDS_Wire(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _TopoDS.delete_TopoDS_Wire

# Register TopoDS_Wire in _TopoDS:
_TopoDS.TopoDS_Wire_swigregister(TopoDS_Wire)



@deprecated
def topods_CompSolid(*args):
	return topods.CompSolid(*args)

@deprecated
def topods_CompSolid(*args):
	return topods.CompSolid(*args)

@deprecated
def topods_Compound(*args):
	return topods.Compound(*args)

@deprecated
def topods_Compound(*args):
	return topods.Compound(*args)

@deprecated
def topods_Edge(*args):
	return topods.Edge(*args)

@deprecated
def topods_Edge(*args):
	return topods.Edge(*args)

@deprecated
def topods_Face(*args):
	return topods.Face(*args)

@deprecated
def topods_Face(*args):
	return topods.Face(*args)

@deprecated
def topods_Shell(*args):
	return topods.Shell(*args)

@deprecated
def topods_Shell(*args):
	return topods.Shell(*args)

@deprecated
def topods_Solid(*args):
	return topods.Solid(*args)

@deprecated
def topods_Solid(*args):
	return topods.Solid(*args)

@deprecated
def topods_Vertex(*args):
	return topods.Vertex(*args)

@deprecated
def topods_Vertex(*args):
	return topods.Vertex(*args)

@deprecated
def topods_Wire(*args):
	return topods.Wire(*args)

@deprecated
def topods_Wire(*args):
	return topods.Wire(*args)

@deprecated
def TopoDS_AlertAttribute_Send(*args):
	return TopoDS_AlertAttribute.Send(*args)



