# This file has been autogenerated by the pywayland scanner

# Copyright © 2015 Martin Gräßlin
# Copyright © 2022 Simon Ser
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSeat
from .ext_idle_notification_v1 import ExtIdleNotificationV1


class ExtIdleNotifierV1(Interface):
    """Idle notification manager

    This interface allows clients to monitor user idle status.

    After binding to this global, clients can create
    :class:`~pywayland.protocol.ext_idle_notify_v1.ExtIdleNotificationV1`
    objects to get notified when the user is idle for a given amount of time.
    """

    name = "ext_idle_notifier_v1"
    version = 1


class ExtIdleNotifierV1Proxy(Proxy[ExtIdleNotifierV1]):
    interface = ExtIdleNotifierV1

    @ExtIdleNotifierV1.request()
    def destroy(self) -> None:
        """Destroy the manager

        Destroy the manager object. All objects created via this interface
        remain valid.
        """
        self._marshal(0)
        self._destroy()

    @ExtIdleNotifierV1.request(
        Argument(ArgumentType.NewId, interface=ExtIdleNotificationV1),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Object, interface=WlSeat),
    )
    def get_idle_notification(self, timeout: int, seat: WlSeat) -> Proxy[ExtIdleNotificationV1]:
        """Create a notification object

        Create a new idle notification object.

        The notification object has a minimum timeout duration and is tied to a
        seat. The client will be notified if the seat is inactive for at least
        the provided timeout. See
        :class:`~pywayland.protocol.ext_idle_notify_v1.ExtIdleNotificationV1`
        for more details.

        A zero timeout is valid and means the client wants to be notified as
        soon as possible when the seat is inactive.

        :param timeout:
            minimum idle timeout in msec
        :type timeout:
            `ArgumentType.Uint`
        :param seat:
        :type seat:
            :class:`~pywayland.protocol.wayland.WlSeat`
        :returns:
            :class:`~pywayland.protocol.ext_idle_notify_v1.ExtIdleNotificationV1`
        """
        id = self._marshal_constructor(1, ExtIdleNotificationV1, timeout, seat)
        return id


class ExtIdleNotifierV1Resource(Resource):
    interface = ExtIdleNotifierV1


class ExtIdleNotifierV1Global(Global):
    interface = ExtIdleNotifierV1


ExtIdleNotifierV1._gen_c()
ExtIdleNotifierV1.proxy_class = ExtIdleNotifierV1Proxy
ExtIdleNotifierV1.resource_class = ExtIdleNotifierV1Resource
ExtIdleNotifierV1.global_class = ExtIdleNotifierV1Global
