"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  AccountFilterType: () => AccountFilterType,
  AccountGateStatus: () => AccountGateStatus,
  ActivateOrganizationsAccessCommand: () => ActivateOrganizationsAccessCommand,
  ActivateTypeCommand: () => ActivateTypeCommand,
  AlreadyExistsException: () => AlreadyExistsException,
  AttributeChangeType: () => AttributeChangeType,
  BatchDescribeTypeConfigurationsCommand: () => BatchDescribeTypeConfigurationsCommand,
  CFNRegistryException: () => CFNRegistryException,
  CallAs: () => CallAs,
  CancelUpdateStackCommand: () => CancelUpdateStackCommand,
  Capability: () => Capability,
  Category: () => Category,
  ChangeAction: () => ChangeAction,
  ChangeSetHooksStatus: () => ChangeSetHooksStatus,
  ChangeSetNotFoundException: () => ChangeSetNotFoundException,
  ChangeSetStatus: () => ChangeSetStatus,
  ChangeSetType: () => ChangeSetType,
  ChangeSource: () => ChangeSource,
  ChangeType: () => ChangeType,
  CloudFormation: () => CloudFormation,
  CloudFormationClient: () => CloudFormationClient,
  CloudFormationServiceException: () => CloudFormationServiceException,
  ConcurrencyMode: () => ConcurrencyMode,
  ConcurrentResourcesLimitExceededException: () => ConcurrentResourcesLimitExceededException,
  ContinueUpdateRollbackCommand: () => ContinueUpdateRollbackCommand,
  CreateChangeSetCommand: () => CreateChangeSetCommand,
  CreateGeneratedTemplateCommand: () => CreateGeneratedTemplateCommand,
  CreateStackCommand: () => CreateStackCommand,
  CreateStackInstancesCommand: () => CreateStackInstancesCommand,
  CreateStackSetCommand: () => CreateStackSetCommand,
  CreatedButModifiedException: () => CreatedButModifiedException,
  DeactivateOrganizationsAccessCommand: () => DeactivateOrganizationsAccessCommand,
  DeactivateTypeCommand: () => DeactivateTypeCommand,
  DeleteChangeSetCommand: () => DeleteChangeSetCommand,
  DeleteGeneratedTemplateCommand: () => DeleteGeneratedTemplateCommand,
  DeleteStackCommand: () => DeleteStackCommand,
  DeleteStackInstancesCommand: () => DeleteStackInstancesCommand,
  DeleteStackSetCommand: () => DeleteStackSetCommand,
  DeprecatedStatus: () => DeprecatedStatus,
  DeregisterTypeCommand: () => DeregisterTypeCommand,
  DescribeAccountLimitsCommand: () => DescribeAccountLimitsCommand,
  DescribeChangeSetCommand: () => DescribeChangeSetCommand,
  DescribeChangeSetHooksCommand: () => DescribeChangeSetHooksCommand,
  DescribeGeneratedTemplateCommand: () => DescribeGeneratedTemplateCommand,
  DescribeOrganizationsAccessCommand: () => DescribeOrganizationsAccessCommand,
  DescribePublisherCommand: () => DescribePublisherCommand,
  DescribeResourceScanCommand: () => DescribeResourceScanCommand,
  DescribeStackDriftDetectionStatusCommand: () => DescribeStackDriftDetectionStatusCommand,
  DescribeStackEventsCommand: () => DescribeStackEventsCommand,
  DescribeStackInstanceCommand: () => DescribeStackInstanceCommand,
  DescribeStackResourceCommand: () => DescribeStackResourceCommand,
  DescribeStackResourceDriftsCommand: () => DescribeStackResourceDriftsCommand,
  DescribeStackResourcesCommand: () => DescribeStackResourcesCommand,
  DescribeStackSetCommand: () => DescribeStackSetCommand,
  DescribeStackSetOperationCommand: () => DescribeStackSetOperationCommand,
  DescribeStacksCommand: () => DescribeStacksCommand,
  DescribeTypeCommand: () => DescribeTypeCommand,
  DescribeTypeRegistrationCommand: () => DescribeTypeRegistrationCommand,
  DetailedStatus: () => DetailedStatus,
  DetectStackDriftCommand: () => DetectStackDriftCommand,
  DetectStackResourceDriftCommand: () => DetectStackResourceDriftCommand,
  DetectStackSetDriftCommand: () => DetectStackSetDriftCommand,
  DifferenceType: () => DifferenceType,
  EstimateTemplateCostCommand: () => EstimateTemplateCostCommand,
  EvaluationType: () => EvaluationType,
  ExecuteChangeSetCommand: () => ExecuteChangeSetCommand,
  ExecutionStatus: () => ExecutionStatus,
  GeneratedTemplateDeletionPolicy: () => GeneratedTemplateDeletionPolicy,
  GeneratedTemplateNotFoundException: () => GeneratedTemplateNotFoundException,
  GeneratedTemplateResourceStatus: () => GeneratedTemplateResourceStatus,
  GeneratedTemplateStatus: () => GeneratedTemplateStatus,
  GeneratedTemplateUpdateReplacePolicy: () => GeneratedTemplateUpdateReplacePolicy,
  GetGeneratedTemplateCommand: () => GetGeneratedTemplateCommand,
  GetStackPolicyCommand: () => GetStackPolicyCommand,
  GetTemplateCommand: () => GetTemplateCommand,
  GetTemplateSummaryCommand: () => GetTemplateSummaryCommand,
  HandlerErrorCode: () => HandlerErrorCode,
  HookFailureMode: () => HookFailureMode,
  HookInvocationPoint: () => HookInvocationPoint,
  HookStatus: () => HookStatus,
  HookTargetType: () => HookTargetType,
  IdentityProvider: () => IdentityProvider,
  ImportStacksToStackSetCommand: () => ImportStacksToStackSetCommand,
  InsufficientCapabilitiesException: () => InsufficientCapabilitiesException,
  InvalidChangeSetStatusException: () => InvalidChangeSetStatusException,
  InvalidOperationException: () => InvalidOperationException,
  InvalidStateTransitionException: () => InvalidStateTransitionException,
  LimitExceededException: () => LimitExceededException,
  ListChangeSetsCommand: () => ListChangeSetsCommand,
  ListExportsCommand: () => ListExportsCommand,
  ListGeneratedTemplatesCommand: () => ListGeneratedTemplatesCommand,
  ListImportsCommand: () => ListImportsCommand,
  ListResourceScanRelatedResourcesCommand: () => ListResourceScanRelatedResourcesCommand,
  ListResourceScanResourcesCommand: () => ListResourceScanResourcesCommand,
  ListResourceScansCommand: () => ListResourceScansCommand,
  ListStackInstanceResourceDriftsCommand: () => ListStackInstanceResourceDriftsCommand,
  ListStackInstancesCommand: () => ListStackInstancesCommand,
  ListStackResourcesCommand: () => ListStackResourcesCommand,
  ListStackSetAutoDeploymentTargetsCommand: () => ListStackSetAutoDeploymentTargetsCommand,
  ListStackSetOperationResultsCommand: () => ListStackSetOperationResultsCommand,
  ListStackSetOperationsCommand: () => ListStackSetOperationsCommand,
  ListStackSetsCommand: () => ListStackSetsCommand,
  ListStacksCommand: () => ListStacksCommand,
  ListTypeRegistrationsCommand: () => ListTypeRegistrationsCommand,
  ListTypeVersionsCommand: () => ListTypeVersionsCommand,
  ListTypesCommand: () => ListTypesCommand,
  NameAlreadyExistsException: () => NameAlreadyExistsException,
  OnFailure: () => OnFailure,
  OnStackFailure: () => OnStackFailure,
  OperationIdAlreadyExistsException: () => OperationIdAlreadyExistsException,
  OperationInProgressException: () => OperationInProgressException,
  OperationNotFoundException: () => OperationNotFoundException,
  OperationResultFilterName: () => OperationResultFilterName,
  OperationStatus: () => OperationStatus,
  OperationStatusCheckFailedException: () => OperationStatusCheckFailedException,
  OrganizationStatus: () => OrganizationStatus,
  PermissionModels: () => PermissionModels,
  PolicyAction: () => PolicyAction,
  ProvisioningType: () => ProvisioningType,
  PublishTypeCommand: () => PublishTypeCommand,
  PublisherStatus: () => PublisherStatus,
  RecordHandlerProgressCommand: () => RecordHandlerProgressCommand,
  RegionConcurrencyType: () => RegionConcurrencyType,
  RegisterPublisherCommand: () => RegisterPublisherCommand,
  RegisterTypeCommand: () => RegisterTypeCommand,
  RegistrationStatus: () => RegistrationStatus,
  RegistryType: () => RegistryType,
  Replacement: () => Replacement,
  RequiresRecreation: () => RequiresRecreation,
  ResourceAttribute: () => ResourceAttribute,
  ResourceScanInProgressException: () => ResourceScanInProgressException,
  ResourceScanLimitExceededException: () => ResourceScanLimitExceededException,
  ResourceScanNotFoundException: () => ResourceScanNotFoundException,
  ResourceScanStatus: () => ResourceScanStatus,
  ResourceSignalStatus: () => ResourceSignalStatus,
  ResourceStatus: () => ResourceStatus,
  RollbackStackCommand: () => RollbackStackCommand,
  SetStackPolicyCommand: () => SetStackPolicyCommand,
  SetTypeConfigurationCommand: () => SetTypeConfigurationCommand,
  SetTypeDefaultVersionCommand: () => SetTypeDefaultVersionCommand,
  SignalResourceCommand: () => SignalResourceCommand,
  StackDriftDetectionStatus: () => StackDriftDetectionStatus,
  StackDriftStatus: () => StackDriftStatus,
  StackInstanceDetailedStatus: () => StackInstanceDetailedStatus,
  StackInstanceFilterName: () => StackInstanceFilterName,
  StackInstanceNotFoundException: () => StackInstanceNotFoundException,
  StackInstanceStatus: () => StackInstanceStatus,
  StackNotFoundException: () => StackNotFoundException,
  StackResourceDriftStatus: () => StackResourceDriftStatus,
  StackSetDriftDetectionStatus: () => StackSetDriftDetectionStatus,
  StackSetDriftStatus: () => StackSetDriftStatus,
  StackSetNotEmptyException: () => StackSetNotEmptyException,
  StackSetNotFoundException: () => StackSetNotFoundException,
  StackSetOperationAction: () => StackSetOperationAction,
  StackSetOperationResultStatus: () => StackSetOperationResultStatus,
  StackSetOperationStatus: () => StackSetOperationStatus,
  StackSetStatus: () => StackSetStatus,
  StackStatus: () => StackStatus,
  StaleRequestException: () => StaleRequestException,
  StartResourceScanCommand: () => StartResourceScanCommand,
  StopStackSetOperationCommand: () => StopStackSetOperationCommand,
  TemplateFormat: () => TemplateFormat,
  TemplateStage: () => TemplateStage,
  TestTypeCommand: () => TestTypeCommand,
  ThirdPartyType: () => ThirdPartyType,
  TokenAlreadyExistsException: () => TokenAlreadyExistsException,
  TypeConfigurationNotFoundException: () => TypeConfigurationNotFoundException,
  TypeNotFoundException: () => TypeNotFoundException,
  TypeTestsStatus: () => TypeTestsStatus,
  UpdateGeneratedTemplateCommand: () => UpdateGeneratedTemplateCommand,
  UpdateStackCommand: () => UpdateStackCommand,
  UpdateStackInstancesCommand: () => UpdateStackInstancesCommand,
  UpdateStackSetCommand: () => UpdateStackSetCommand,
  UpdateTerminationProtectionCommand: () => UpdateTerminationProtectionCommand,
  ValidateTemplateCommand: () => ValidateTemplateCommand,
  VersionBump: () => VersionBump,
  Visibility: () => Visibility,
  WarningType: () => WarningType,
  __Client: () => import_smithy_client.Client,
  paginateDescribeAccountLimits: () => paginateDescribeAccountLimits,
  paginateDescribeStackEvents: () => paginateDescribeStackEvents,
  paginateDescribeStackResourceDrifts: () => paginateDescribeStackResourceDrifts,
  paginateDescribeStacks: () => paginateDescribeStacks,
  paginateListChangeSets: () => paginateListChangeSets,
  paginateListExports: () => paginateListExports,
  paginateListGeneratedTemplates: () => paginateListGeneratedTemplates,
  paginateListImports: () => paginateListImports,
  paginateListResourceScanRelatedResources: () => paginateListResourceScanRelatedResources,
  paginateListResourceScanResources: () => paginateListResourceScanResources,
  paginateListResourceScans: () => paginateListResourceScans,
  paginateListStackInstances: () => paginateListStackInstances,
  paginateListStackResources: () => paginateListStackResources,
  paginateListStackSetOperationResults: () => paginateListStackSetOperationResults,
  paginateListStackSetOperations: () => paginateListStackSetOperations,
  paginateListStackSets: () => paginateListStackSets,
  paginateListStacks: () => paginateListStacks,
  paginateListTypeRegistrations: () => paginateListTypeRegistrations,
  paginateListTypeVersions: () => paginateListTypeVersions,
  paginateListTypes: () => paginateListTypes,
  waitForChangeSetCreateComplete: () => waitForChangeSetCreateComplete,
  waitForStackCreateComplete: () => waitForStackCreateComplete,
  waitForStackDeleteComplete: () => waitForStackDeleteComplete,
  waitForStackExists: () => waitForStackExists,
  waitForStackImportComplete: () => waitForStackImportComplete,
  waitForStackRollbackComplete: () => waitForStackRollbackComplete,
  waitForStackUpdateComplete: () => waitForStackUpdateComplete,
  waitForTypeRegistrationComplete: () => waitForTypeRegistrationComplete,
  waitUntilChangeSetCreateComplete: () => waitUntilChangeSetCreateComplete,
  waitUntilStackCreateComplete: () => waitUntilStackCreateComplete,
  waitUntilStackDeleteComplete: () => waitUntilStackDeleteComplete,
  waitUntilStackExists: () => waitUntilStackExists,
  waitUntilStackImportComplete: () => waitUntilStackImportComplete,
  waitUntilStackRollbackComplete: () => waitUntilStackRollbackComplete,
  waitUntilStackUpdateComplete: () => waitUntilStackUpdateComplete,
  waitUntilTypeRegistrationComplete: () => waitUntilTypeRegistrationComplete
});
module.exports = __toCommonJS(src_exports);

// src/CloudFormationClient.ts
var import_middleware_host_header = require("@aws-sdk/middleware-host-header");
var import_middleware_logger = require("@aws-sdk/middleware-logger");
var import_middleware_recursion_detection = require("@aws-sdk/middleware-recursion-detection");
var import_middleware_user_agent = require("@aws-sdk/middleware-user-agent");
var import_config_resolver = require("@smithy/config-resolver");
var import_core = require("@smithy/core");
var import_middleware_content_length = require("@smithy/middleware-content-length");
var import_middleware_endpoint = require("@smithy/middleware-endpoint");
var import_middleware_retry = require("@smithy/middleware-retry");

var import_httpAuthSchemeProvider = require("./auth/httpAuthSchemeProvider");

// src/endpoint/EndpointParameters.ts
var resolveClientEndpointParameters = /* @__PURE__ */ __name((options) => {
  return {
    ...options,
    useDualstackEndpoint: options.useDualstackEndpoint ?? false,
    useFipsEndpoint: options.useFipsEndpoint ?? false,
    defaultSigningName: "cloudformation"
  };
}, "resolveClientEndpointParameters");
var commonParams = {
  UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
  Endpoint: { type: "builtInParams", name: "endpoint" },
  Region: { type: "builtInParams", name: "region" },
  UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
};

// src/CloudFormationClient.ts
var import_runtimeConfig = require("././runtimeConfig");

// src/runtimeExtensions.ts
var import_region_config_resolver = require("@aws-sdk/region-config-resolver");
var import_protocol_http = require("@smithy/protocol-http");
var import_smithy_client = require("@smithy/smithy-client");

// src/auth/httpAuthExtensionConfiguration.ts
var getHttpAuthExtensionConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
  const _httpAuthSchemes = runtimeConfig.httpAuthSchemes;
  let _httpAuthSchemeProvider = runtimeConfig.httpAuthSchemeProvider;
  let _credentials = runtimeConfig.credentials;
  return {
    setHttpAuthScheme(httpAuthScheme) {
      const index = _httpAuthSchemes.findIndex((scheme) => scheme.schemeId === httpAuthScheme.schemeId);
      if (index === -1) {
        _httpAuthSchemes.push(httpAuthScheme);
      } else {
        _httpAuthSchemes.splice(index, 1, httpAuthScheme);
      }
    },
    httpAuthSchemes() {
      return _httpAuthSchemes;
    },
    setHttpAuthSchemeProvider(httpAuthSchemeProvider) {
      _httpAuthSchemeProvider = httpAuthSchemeProvider;
    },
    httpAuthSchemeProvider() {
      return _httpAuthSchemeProvider;
    },
    setCredentials(credentials) {
      _credentials = credentials;
    },
    credentials() {
      return _credentials;
    }
  };
}, "getHttpAuthExtensionConfiguration");
var resolveHttpAuthRuntimeConfig = /* @__PURE__ */ __name((config) => {
  return {
    httpAuthSchemes: config.httpAuthSchemes(),
    httpAuthSchemeProvider: config.httpAuthSchemeProvider(),
    credentials: config.credentials()
  };
}, "resolveHttpAuthRuntimeConfig");

// src/runtimeExtensions.ts
var asPartial = /* @__PURE__ */ __name((t) => t, "asPartial");
var resolveRuntimeExtensions = /* @__PURE__ */ __name((runtimeConfig, extensions) => {
  const extensionConfiguration = {
    ...asPartial((0, import_region_config_resolver.getAwsRegionExtensionConfiguration)(runtimeConfig)),
    ...asPartial((0, import_smithy_client.getDefaultExtensionConfiguration)(runtimeConfig)),
    ...asPartial((0, import_protocol_http.getHttpHandlerExtensionConfiguration)(runtimeConfig)),
    ...asPartial(getHttpAuthExtensionConfiguration(runtimeConfig))
  };
  extensions.forEach((extension) => extension.configure(extensionConfiguration));
  return {
    ...runtimeConfig,
    ...(0, import_region_config_resolver.resolveAwsRegionExtensionConfiguration)(extensionConfiguration),
    ...(0, import_smithy_client.resolveDefaultRuntimeConfig)(extensionConfiguration),
    ...(0, import_protocol_http.resolveHttpHandlerRuntimeConfig)(extensionConfiguration),
    ...resolveHttpAuthRuntimeConfig(extensionConfiguration)
  };
}, "resolveRuntimeExtensions");

// src/CloudFormationClient.ts
var _CloudFormationClient = class _CloudFormationClient extends import_smithy_client.Client {
  constructor(...[configuration]) {
    const _config_0 = (0, import_runtimeConfig.getRuntimeConfig)(configuration || {});
    const _config_1 = resolveClientEndpointParameters(_config_0);
    const _config_2 = (0, import_config_resolver.resolveRegionConfig)(_config_1);
    const _config_3 = (0, import_middleware_endpoint.resolveEndpointConfig)(_config_2);
    const _config_4 = (0, import_middleware_retry.resolveRetryConfig)(_config_3);
    const _config_5 = (0, import_middleware_host_header.resolveHostHeaderConfig)(_config_4);
    const _config_6 = (0, import_middleware_user_agent.resolveUserAgentConfig)(_config_5);
    const _config_7 = (0, import_httpAuthSchemeProvider.resolveHttpAuthSchemeConfig)(_config_6);
    const _config_8 = resolveRuntimeExtensions(_config_7, (configuration == null ? void 0 : configuration.extensions) || []);
    super(_config_8);
    this.config = _config_8;
    this.middlewareStack.use((0, import_middleware_retry.getRetryPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_content_length.getContentLengthPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_host_header.getHostHeaderPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_logger.getLoggerPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_recursion_detection.getRecursionDetectionPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_user_agent.getUserAgentPlugin)(this.config));
    this.middlewareStack.use(
      (0, import_core.getHttpAuthSchemeEndpointRuleSetPlugin)(this.config, {
        httpAuthSchemeParametersProvider: this.getDefaultHttpAuthSchemeParametersProvider(),
        identityProviderConfigProvider: this.getIdentityProviderConfigProvider()
      })
    );
    this.middlewareStack.use((0, import_core.getHttpSigningPlugin)(this.config));
  }
  /**
   * Destroy underlying resources, like sockets. It's usually not necessary to do this.
   * However in Node.js, it's best to explicitly shut down the client's agent when it is no longer needed.
   * Otherwise, sockets might stay open for quite a long time before the server terminates them.
   */
  destroy() {
    super.destroy();
  }
  getDefaultHttpAuthSchemeParametersProvider() {
    return import_httpAuthSchemeProvider.defaultCloudFormationHttpAuthSchemeParametersProvider;
  }
  getIdentityProviderConfigProvider() {
    return async (config) => new import_core.DefaultIdentityProviderConfig({
      "aws.auth#sigv4": config.credentials
    });
  }
};
__name(_CloudFormationClient, "CloudFormationClient");
var CloudFormationClient = _CloudFormationClient;

// src/CloudFormation.ts


// src/commands/ActivateOrganizationsAccessCommand.ts

var import_middleware_serde = require("@smithy/middleware-serde");

var import_types = require("@smithy/types");

// src/protocols/Aws_query.ts
var import_core2 = require("@aws-sdk/core");


var import_uuid = require("uuid");

// src/models/CloudFormationServiceException.ts

var _CloudFormationServiceException = class _CloudFormationServiceException extends import_smithy_client.ServiceException {
  /**
   * @internal
   */
  constructor(options) {
    super(options);
    Object.setPrototypeOf(this, _CloudFormationServiceException.prototype);
  }
};
__name(_CloudFormationServiceException, "CloudFormationServiceException");
var CloudFormationServiceException = _CloudFormationServiceException;

// src/models/models_0.ts
var AccountFilterType = {
  DIFFERENCE: "DIFFERENCE",
  INTERSECTION: "INTERSECTION",
  NONE: "NONE",
  UNION: "UNION"
};
var AccountGateStatus = {
  FAILED: "FAILED",
  SKIPPED: "SKIPPED",
  SUCCEEDED: "SUCCEEDED"
};
var _InvalidOperationException = class _InvalidOperationException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidOperationException",
      $fault: "client",
      ...opts
    });
    this.name = "InvalidOperationException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _InvalidOperationException.prototype);
    this.Message = opts.Message;
  }
};
__name(_InvalidOperationException, "InvalidOperationException");
var InvalidOperationException = _InvalidOperationException;
var _OperationNotFoundException = class _OperationNotFoundException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OperationNotFoundException",
      $fault: "client",
      ...opts
    });
    this.name = "OperationNotFoundException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _OperationNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
__name(_OperationNotFoundException, "OperationNotFoundException");
var OperationNotFoundException = _OperationNotFoundException;
var ThirdPartyType = {
  HOOK: "HOOK",
  MODULE: "MODULE",
  RESOURCE: "RESOURCE"
};
var VersionBump = {
  MAJOR: "MAJOR",
  MINOR: "MINOR"
};
var _CFNRegistryException = class _CFNRegistryException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CFNRegistryException",
      $fault: "client",
      ...opts
    });
    this.name = "CFNRegistryException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _CFNRegistryException.prototype);
    this.Message = opts.Message;
  }
};
__name(_CFNRegistryException, "CFNRegistryException");
var CFNRegistryException = _CFNRegistryException;
var _TypeNotFoundException = class _TypeNotFoundException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TypeNotFoundException",
      $fault: "client",
      ...opts
    });
    this.name = "TypeNotFoundException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _TypeNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
__name(_TypeNotFoundException, "TypeNotFoundException");
var TypeNotFoundException = _TypeNotFoundException;
var _AlreadyExistsException = class _AlreadyExistsException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AlreadyExistsException",
      $fault: "client",
      ...opts
    });
    this.name = "AlreadyExistsException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _AlreadyExistsException.prototype);
    this.Message = opts.Message;
  }
};
__name(_AlreadyExistsException, "AlreadyExistsException");
var AlreadyExistsException = _AlreadyExistsException;
var AttributeChangeType = {
  Add: "Add",
  Modify: "Modify",
  Remove: "Remove"
};
var _TypeConfigurationNotFoundException = class _TypeConfigurationNotFoundException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TypeConfigurationNotFoundException",
      $fault: "client",
      ...opts
    });
    this.name = "TypeConfigurationNotFoundException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _TypeConfigurationNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
__name(_TypeConfigurationNotFoundException, "TypeConfigurationNotFoundException");
var TypeConfigurationNotFoundException = _TypeConfigurationNotFoundException;
var CallAs = {
  DELEGATED_ADMIN: "DELEGATED_ADMIN",
  SELF: "SELF"
};
var _TokenAlreadyExistsException = class _TokenAlreadyExistsException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TokenAlreadyExistsException",
      $fault: "client",
      ...opts
    });
    this.name = "TokenAlreadyExistsException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _TokenAlreadyExistsException.prototype);
    this.Message = opts.Message;
  }
};
__name(_TokenAlreadyExistsException, "TokenAlreadyExistsException");
var TokenAlreadyExistsException = _TokenAlreadyExistsException;
var Capability = {
  CAPABILITY_AUTO_EXPAND: "CAPABILITY_AUTO_EXPAND",
  CAPABILITY_IAM: "CAPABILITY_IAM",
  CAPABILITY_NAMED_IAM: "CAPABILITY_NAMED_IAM"
};
var Category = {
  ACTIVATED: "ACTIVATED",
  AWS_TYPES: "AWS_TYPES",
  REGISTERED: "REGISTERED",
  THIRD_PARTY: "THIRD_PARTY"
};
var ChangeAction = {
  Add: "Add",
  Dynamic: "Dynamic",
  Import: "Import",
  Modify: "Modify",
  Remove: "Remove"
};
var ChangeSource = {
  Automatic: "Automatic",
  DirectModification: "DirectModification",
  ParameterReference: "ParameterReference",
  ResourceAttribute: "ResourceAttribute",
  ResourceReference: "ResourceReference"
};
var EvaluationType = {
  Dynamic: "Dynamic",
  Static: "Static"
};
var ResourceAttribute = {
  CreationPolicy: "CreationPolicy",
  DeletionPolicy: "DeletionPolicy",
  Metadata: "Metadata",
  Properties: "Properties",
  Tags: "Tags",
  UpdatePolicy: "UpdatePolicy",
  UpdateReplacePolicy: "UpdateReplacePolicy"
};
var RequiresRecreation = {
  Always: "Always",
  Conditionally: "Conditionally",
  Never: "Never"
};
var PolicyAction = {
  Delete: "Delete",
  ReplaceAndDelete: "ReplaceAndDelete",
  ReplaceAndRetain: "ReplaceAndRetain",
  ReplaceAndSnapshot: "ReplaceAndSnapshot",
  Retain: "Retain",
  Snapshot: "Snapshot"
};
var Replacement = {
  Conditional: "Conditional",
  False: "False",
  True: "True"
};
var ChangeType = {
  Resource: "Resource"
};
var HookFailureMode = {
  FAIL: "FAIL",
  WARN: "WARN"
};
var HookInvocationPoint = {
  PRE_PROVISION: "PRE_PROVISION"
};
var HookTargetType = {
  RESOURCE: "RESOURCE"
};
var ChangeSetHooksStatus = {
  PLANNED: "PLANNED",
  PLANNING: "PLANNING",
  UNAVAILABLE: "UNAVAILABLE"
};
var _ChangeSetNotFoundException = class _ChangeSetNotFoundException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ChangeSetNotFoundException",
      $fault: "client",
      ...opts
    });
    this.name = "ChangeSetNotFoundException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _ChangeSetNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
__name(_ChangeSetNotFoundException, "ChangeSetNotFoundException");
var ChangeSetNotFoundException = _ChangeSetNotFoundException;
var ChangeSetStatus = {
  CREATE_COMPLETE: "CREATE_COMPLETE",
  CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS",
  CREATE_PENDING: "CREATE_PENDING",
  DELETE_COMPLETE: "DELETE_COMPLETE",
  DELETE_FAILED: "DELETE_FAILED",
  DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
  DELETE_PENDING: "DELETE_PENDING",
  FAILED: "FAILED"
};
var ExecutionStatus = {
  AVAILABLE: "AVAILABLE",
  EXECUTE_COMPLETE: "EXECUTE_COMPLETE",
  EXECUTE_FAILED: "EXECUTE_FAILED",
  EXECUTE_IN_PROGRESS: "EXECUTE_IN_PROGRESS",
  OBSOLETE: "OBSOLETE",
  UNAVAILABLE: "UNAVAILABLE"
};
var ChangeSetType = {
  CREATE: "CREATE",
  IMPORT: "IMPORT",
  UPDATE: "UPDATE"
};
var OnStackFailure = {
  DELETE: "DELETE",
  DO_NOTHING: "DO_NOTHING",
  ROLLBACK: "ROLLBACK"
};
var _InsufficientCapabilitiesException = class _InsufficientCapabilitiesException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InsufficientCapabilitiesException",
      $fault: "client",
      ...opts
    });
    this.name = "InsufficientCapabilitiesException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _InsufficientCapabilitiesException.prototype);
    this.Message = opts.Message;
  }
};
__name(_InsufficientCapabilitiesException, "InsufficientCapabilitiesException");
var InsufficientCapabilitiesException = _InsufficientCapabilitiesException;
var _LimitExceededException = class _LimitExceededException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "LimitExceededException",
      $fault: "client",
      ...opts
    });
    this.name = "LimitExceededException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _LimitExceededException.prototype);
    this.Message = opts.Message;
  }
};
__name(_LimitExceededException, "LimitExceededException");
var LimitExceededException = _LimitExceededException;
var _ConcurrentResourcesLimitExceededException = class _ConcurrentResourcesLimitExceededException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ConcurrentResourcesLimitExceededException",
      $fault: "client",
      ...opts
    });
    this.name = "ConcurrentResourcesLimitExceededException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _ConcurrentResourcesLimitExceededException.prototype);
    this.Message = opts.Message;
  }
};
__name(_ConcurrentResourcesLimitExceededException, "ConcurrentResourcesLimitExceededException");
var ConcurrentResourcesLimitExceededException = _ConcurrentResourcesLimitExceededException;
var GeneratedTemplateDeletionPolicy = {
  DELETE: "DELETE",
  RETAIN: "RETAIN"
};
var GeneratedTemplateUpdateReplacePolicy = {
  DELETE: "DELETE",
  RETAIN: "RETAIN"
};
var OnFailure = {
  DELETE: "DELETE",
  DO_NOTHING: "DO_NOTHING",
  ROLLBACK: "ROLLBACK"
};
var ConcurrencyMode = {
  SOFT_FAILURE_TOLERANCE: "SOFT_FAILURE_TOLERANCE",
  STRICT_FAILURE_TOLERANCE: "STRICT_FAILURE_TOLERANCE"
};
var RegionConcurrencyType = {
  PARALLEL: "PARALLEL",
  SEQUENTIAL: "SEQUENTIAL"
};
var _OperationIdAlreadyExistsException = class _OperationIdAlreadyExistsException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OperationIdAlreadyExistsException",
      $fault: "client",
      ...opts
    });
    this.name = "OperationIdAlreadyExistsException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _OperationIdAlreadyExistsException.prototype);
    this.Message = opts.Message;
  }
};
__name(_OperationIdAlreadyExistsException, "OperationIdAlreadyExistsException");
var OperationIdAlreadyExistsException = _OperationIdAlreadyExistsException;
var _OperationInProgressException = class _OperationInProgressException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OperationInProgressException",
      $fault: "client",
      ...opts
    });
    this.name = "OperationInProgressException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _OperationInProgressException.prototype);
    this.Message = opts.Message;
  }
};
__name(_OperationInProgressException, "OperationInProgressException");
var OperationInProgressException = _OperationInProgressException;
var _StackSetNotFoundException = class _StackSetNotFoundException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StackSetNotFoundException",
      $fault: "client",
      ...opts
    });
    this.name = "StackSetNotFoundException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _StackSetNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
__name(_StackSetNotFoundException, "StackSetNotFoundException");
var StackSetNotFoundException = _StackSetNotFoundException;
var _StaleRequestException = class _StaleRequestException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StaleRequestException",
      $fault: "client",
      ...opts
    });
    this.name = "StaleRequestException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _StaleRequestException.prototype);
    this.Message = opts.Message;
  }
};
__name(_StaleRequestException, "StaleRequestException");
var StaleRequestException = _StaleRequestException;
var _CreatedButModifiedException = class _CreatedButModifiedException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CreatedButModifiedException",
      $fault: "client",
      ...opts
    });
    this.name = "CreatedButModifiedException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _CreatedButModifiedException.prototype);
    this.Message = opts.Message;
  }
};
__name(_CreatedButModifiedException, "CreatedButModifiedException");
var CreatedButModifiedException = _CreatedButModifiedException;
var PermissionModels = {
  SELF_MANAGED: "SELF_MANAGED",
  SERVICE_MANAGED: "SERVICE_MANAGED"
};
var _NameAlreadyExistsException = class _NameAlreadyExistsException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NameAlreadyExistsException",
      $fault: "client",
      ...opts
    });
    this.name = "NameAlreadyExistsException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _NameAlreadyExistsException.prototype);
    this.Message = opts.Message;
  }
};
__name(_NameAlreadyExistsException, "NameAlreadyExistsException");
var NameAlreadyExistsException = _NameAlreadyExistsException;
var _InvalidChangeSetStatusException = class _InvalidChangeSetStatusException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidChangeSetStatusException",
      $fault: "client",
      ...opts
    });
    this.name = "InvalidChangeSetStatusException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _InvalidChangeSetStatusException.prototype);
    this.Message = opts.Message;
  }
};
__name(_InvalidChangeSetStatusException, "InvalidChangeSetStatusException");
var InvalidChangeSetStatusException = _InvalidChangeSetStatusException;
var _GeneratedTemplateNotFoundException = class _GeneratedTemplateNotFoundException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "GeneratedTemplateNotFoundException",
      $fault: "client",
      ...opts
    });
    this.name = "GeneratedTemplateNotFoundException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _GeneratedTemplateNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
__name(_GeneratedTemplateNotFoundException, "GeneratedTemplateNotFoundException");
var GeneratedTemplateNotFoundException = _GeneratedTemplateNotFoundException;
var _StackSetNotEmptyException = class _StackSetNotEmptyException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StackSetNotEmptyException",
      $fault: "client",
      ...opts
    });
    this.name = "StackSetNotEmptyException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _StackSetNotEmptyException.prototype);
    this.Message = opts.Message;
  }
};
__name(_StackSetNotEmptyException, "StackSetNotEmptyException");
var StackSetNotEmptyException = _StackSetNotEmptyException;
var RegistryType = {
  HOOK: "HOOK",
  MODULE: "MODULE",
  RESOURCE: "RESOURCE"
};
var GeneratedTemplateResourceStatus = {
  COMPLETE: "COMPLETE",
  FAILED: "FAILED",
  IN_PROGRESS: "IN_PROGRESS",
  PENDING: "PENDING"
};
var WarningType = {
  MUTUALLY_EXCLUSIVE_PROPERTIES: "MUTUALLY_EXCLUSIVE_PROPERTIES",
  MUTUALLY_EXCLUSIVE_TYPES: "MUTUALLY_EXCLUSIVE_TYPES",
  UNSUPPORTED_PROPERTIES: "UNSUPPORTED_PROPERTIES"
};
var GeneratedTemplateStatus = {
  COMPLETE: "COMPLETE",
  CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS",
  CREATE_PENDING: "CREATE_PENDING",
  DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
  DELETE_PENDING: "DELETE_PENDING",
  FAILED: "FAILED",
  UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS",
  UPDATE_PENDING: "UPDATE_PENDING"
};
var OrganizationStatus = {
  DISABLED: "DISABLED",
  DISABLED_PERMANENTLY: "DISABLED_PERMANENTLY",
  ENABLED: "ENABLED"
};
var IdentityProvider = {
  AWS_Marketplace: "AWS_Marketplace",
  Bitbucket: "Bitbucket",
  GitHub: "GitHub"
};
var PublisherStatus = {
  UNVERIFIED: "UNVERIFIED",
  VERIFIED: "VERIFIED"
};
var ResourceScanStatus = {
  COMPLETE: "COMPLETE",
  EXPIRED: "EXPIRED",
  FAILED: "FAILED",
  IN_PROGRESS: "IN_PROGRESS"
};
var _ResourceScanNotFoundException = class _ResourceScanNotFoundException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceScanNotFoundException",
      $fault: "client",
      ...opts
    });
    this.name = "ResourceScanNotFoundException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _ResourceScanNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
__name(_ResourceScanNotFoundException, "ResourceScanNotFoundException");
var ResourceScanNotFoundException = _ResourceScanNotFoundException;
var StackDriftDetectionStatus = {
  DETECTION_COMPLETE: "DETECTION_COMPLETE",
  DETECTION_FAILED: "DETECTION_FAILED",
  DETECTION_IN_PROGRESS: "DETECTION_IN_PROGRESS"
};
var StackDriftStatus = {
  DRIFTED: "DRIFTED",
  IN_SYNC: "IN_SYNC",
  NOT_CHECKED: "NOT_CHECKED",
  UNKNOWN: "UNKNOWN"
};
var DetailedStatus = {
  CONFIGURATION_COMPLETE: "CONFIGURATION_COMPLETE",
  VALIDATION_FAILED: "VALIDATION_FAILED"
};
var HookStatus = {
  HOOK_COMPLETE_FAILED: "HOOK_COMPLETE_FAILED",
  HOOK_COMPLETE_SUCCEEDED: "HOOK_COMPLETE_SUCCEEDED",
  HOOK_FAILED: "HOOK_FAILED",
  HOOK_IN_PROGRESS: "HOOK_IN_PROGRESS"
};
var ResourceStatus = {
  CREATE_COMPLETE: "CREATE_COMPLETE",
  CREATE_FAILED: "CREATE_FAILED",
  CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS",
  DELETE_COMPLETE: "DELETE_COMPLETE",
  DELETE_FAILED: "DELETE_FAILED",
  DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
  DELETE_SKIPPED: "DELETE_SKIPPED",
  IMPORT_COMPLETE: "IMPORT_COMPLETE",
  IMPORT_FAILED: "IMPORT_FAILED",
  IMPORT_IN_PROGRESS: "IMPORT_IN_PROGRESS",
  IMPORT_ROLLBACK_COMPLETE: "IMPORT_ROLLBACK_COMPLETE",
  IMPORT_ROLLBACK_FAILED: "IMPORT_ROLLBACK_FAILED",
  IMPORT_ROLLBACK_IN_PROGRESS: "IMPORT_ROLLBACK_IN_PROGRESS",
  ROLLBACK_COMPLETE: "ROLLBACK_COMPLETE",
  ROLLBACK_FAILED: "ROLLBACK_FAILED",
  ROLLBACK_IN_PROGRESS: "ROLLBACK_IN_PROGRESS",
  UPDATE_COMPLETE: "UPDATE_COMPLETE",
  UPDATE_FAILED: "UPDATE_FAILED",
  UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS",
  UPDATE_ROLLBACK_COMPLETE: "UPDATE_ROLLBACK_COMPLETE",
  UPDATE_ROLLBACK_FAILED: "UPDATE_ROLLBACK_FAILED",
  UPDATE_ROLLBACK_IN_PROGRESS: "UPDATE_ROLLBACK_IN_PROGRESS"
};
var StackInstanceDetailedStatus = {
  CANCELLED: "CANCELLED",
  FAILED: "FAILED",
  FAILED_IMPORT: "FAILED_IMPORT",
  INOPERABLE: "INOPERABLE",
  PENDING: "PENDING",
  RUNNING: "RUNNING",
  SKIPPED_SUSPENDED_ACCOUNT: "SKIPPED_SUSPENDED_ACCOUNT",
  SUCCEEDED: "SUCCEEDED"
};
var StackInstanceStatus = {
  CURRENT: "CURRENT",
  INOPERABLE: "INOPERABLE",
  OUTDATED: "OUTDATED"
};
var _StackInstanceNotFoundException = class _StackInstanceNotFoundException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StackInstanceNotFoundException",
      $fault: "client",
      ...opts
    });
    this.name = "StackInstanceNotFoundException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _StackInstanceNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
__name(_StackInstanceNotFoundException, "StackInstanceNotFoundException");
var StackInstanceNotFoundException = _StackInstanceNotFoundException;
var StackResourceDriftStatus = {
  DELETED: "DELETED",
  IN_SYNC: "IN_SYNC",
  MODIFIED: "MODIFIED",
  NOT_CHECKED: "NOT_CHECKED"
};
var DifferenceType = {
  ADD: "ADD",
  NOT_EQUAL: "NOT_EQUAL",
  REMOVE: "REMOVE"
};
var StackStatus = {
  CREATE_COMPLETE: "CREATE_COMPLETE",
  CREATE_FAILED: "CREATE_FAILED",
  CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS",
  DELETE_COMPLETE: "DELETE_COMPLETE",
  DELETE_FAILED: "DELETE_FAILED",
  DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
  IMPORT_COMPLETE: "IMPORT_COMPLETE",
  IMPORT_IN_PROGRESS: "IMPORT_IN_PROGRESS",
  IMPORT_ROLLBACK_COMPLETE: "IMPORT_ROLLBACK_COMPLETE",
  IMPORT_ROLLBACK_FAILED: "IMPORT_ROLLBACK_FAILED",
  IMPORT_ROLLBACK_IN_PROGRESS: "IMPORT_ROLLBACK_IN_PROGRESS",
  REVIEW_IN_PROGRESS: "REVIEW_IN_PROGRESS",
  ROLLBACK_COMPLETE: "ROLLBACK_COMPLETE",
  ROLLBACK_FAILED: "ROLLBACK_FAILED",
  ROLLBACK_IN_PROGRESS: "ROLLBACK_IN_PROGRESS",
  UPDATE_COMPLETE: "UPDATE_COMPLETE",
  UPDATE_COMPLETE_CLEANUP_IN_PROGRESS: "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS",
  UPDATE_FAILED: "UPDATE_FAILED",
  UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS",
  UPDATE_ROLLBACK_COMPLETE: "UPDATE_ROLLBACK_COMPLETE",
  UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS: "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS",
  UPDATE_ROLLBACK_FAILED: "UPDATE_ROLLBACK_FAILED",
  UPDATE_ROLLBACK_IN_PROGRESS: "UPDATE_ROLLBACK_IN_PROGRESS"
};
var StackSetDriftDetectionStatus = {
  COMPLETED: "COMPLETED",
  FAILED: "FAILED",
  IN_PROGRESS: "IN_PROGRESS",
  PARTIAL_SUCCESS: "PARTIAL_SUCCESS",
  STOPPED: "STOPPED"
};
var StackSetDriftStatus = {
  DRIFTED: "DRIFTED",
  IN_SYNC: "IN_SYNC",
  NOT_CHECKED: "NOT_CHECKED"
};
var StackSetStatus = {
  ACTIVE: "ACTIVE",
  DELETED: "DELETED"
};
var StackSetOperationAction = {
  CREATE: "CREATE",
  DELETE: "DELETE",
  DETECT_DRIFT: "DETECT_DRIFT",
  UPDATE: "UPDATE"
};
var StackSetOperationStatus = {
  FAILED: "FAILED",
  QUEUED: "QUEUED",
  RUNNING: "RUNNING",
  STOPPED: "STOPPED",
  STOPPING: "STOPPING",
  SUCCEEDED: "SUCCEEDED"
};
var DeprecatedStatus = {
  DEPRECATED: "DEPRECATED",
  LIVE: "LIVE"
};
var ProvisioningType = {
  FULLY_MUTABLE: "FULLY_MUTABLE",
  IMMUTABLE: "IMMUTABLE",
  NON_PROVISIONABLE: "NON_PROVISIONABLE"
};
var TypeTestsStatus = {
  FAILED: "FAILED",
  IN_PROGRESS: "IN_PROGRESS",
  NOT_TESTED: "NOT_TESTED",
  PASSED: "PASSED"
};
var Visibility = {
  PRIVATE: "PRIVATE",
  PUBLIC: "PUBLIC"
};
var RegistrationStatus = {
  COMPLETE: "COMPLETE",
  FAILED: "FAILED",
  IN_PROGRESS: "IN_PROGRESS"
};
var TemplateFormat = {
  JSON: "JSON",
  YAML: "YAML"
};
var TemplateStage = {
  Original: "Original",
  Processed: "Processed"
};
var _StackNotFoundException = class _StackNotFoundException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StackNotFoundException",
      $fault: "client",
      ...opts
    });
    this.name = "StackNotFoundException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _StackNotFoundException.prototype);
    this.Message = opts.Message;
  }
};
__name(_StackNotFoundException, "StackNotFoundException");
var StackNotFoundException = _StackNotFoundException;
var _ResourceScanInProgressException = class _ResourceScanInProgressException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceScanInProgressException",
      $fault: "client",
      ...opts
    });
    this.name = "ResourceScanInProgressException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _ResourceScanInProgressException.prototype);
    this.Message = opts.Message;
  }
};
__name(_ResourceScanInProgressException, "ResourceScanInProgressException");
var ResourceScanInProgressException = _ResourceScanInProgressException;
var StackInstanceFilterName = {
  DETAILED_STATUS: "DETAILED_STATUS",
  DRIFT_STATUS: "DRIFT_STATUS",
  LAST_OPERATION_ID: "LAST_OPERATION_ID"
};
var OperationResultFilterName = {
  OPERATION_RESULT_STATUS: "OPERATION_RESULT_STATUS"
};
var StackSetOperationResultStatus = {
  CANCELLED: "CANCELLED",
  FAILED: "FAILED",
  PENDING: "PENDING",
  RUNNING: "RUNNING",
  SUCCEEDED: "SUCCEEDED"
};
var _InvalidStateTransitionException = class _InvalidStateTransitionException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidStateTransitionException",
      $fault: "client",
      ...opts
    });
    this.name = "InvalidStateTransitionException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _InvalidStateTransitionException.prototype);
    this.Message = opts.Message;
  }
};
__name(_InvalidStateTransitionException, "InvalidStateTransitionException");
var InvalidStateTransitionException = _InvalidStateTransitionException;
var _OperationStatusCheckFailedException = class _OperationStatusCheckFailedException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OperationStatusCheckFailedException",
      $fault: "client",
      ...opts
    });
    this.name = "OperationStatusCheckFailedException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _OperationStatusCheckFailedException.prototype);
    this.Message = opts.Message;
  }
};
__name(_OperationStatusCheckFailedException, "OperationStatusCheckFailedException");
var OperationStatusCheckFailedException = _OperationStatusCheckFailedException;
var OperationStatus = {
  FAILED: "FAILED",
  IN_PROGRESS: "IN_PROGRESS",
  PENDING: "PENDING",
  SUCCESS: "SUCCESS"
};
var HandlerErrorCode = {
  AccessDenied: "AccessDenied",
  AlreadyExists: "AlreadyExists",
  GeneralServiceException: "GeneralServiceException",
  HandlerInternalFailure: "HandlerInternalFailure",
  InternalFailure: "InternalFailure",
  InvalidCredentials: "InvalidCredentials",
  InvalidRequest: "InvalidRequest",
  InvalidTypeConfiguration: "InvalidTypeConfiguration",
  NetworkFailure: "NetworkFailure",
  NonCompliant: "NonCompliant",
  NotFound: "NotFound",
  NotUpdatable: "NotUpdatable",
  ResourceConflict: "ResourceConflict",
  ServiceInternalError: "ServiceInternalError",
  ServiceLimitExceeded: "ServiceLimitExceeded",
  ServiceTimeout: "NotStabilized",
  Throttling: "Throttling",
  Unknown: "Unknown",
  UnsupportedTarget: "UnsupportedTarget"
};

// src/models/models_1.ts
var ResourceSignalStatus = {
  FAILURE: "FAILURE",
  SUCCESS: "SUCCESS"
};
var _ResourceScanLimitExceededException = class _ResourceScanLimitExceededException extends CloudFormationServiceException {
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceScanLimitExceededException",
      $fault: "client",
      ...opts
    });
    this.name = "ResourceScanLimitExceededException";
    this.$fault = "client";
    Object.setPrototypeOf(this, _ResourceScanLimitExceededException.prototype);
    this.Message = opts.Message;
  }
};
__name(_ResourceScanLimitExceededException, "ResourceScanLimitExceededException");
var ResourceScanLimitExceededException = _ResourceScanLimitExceededException;

// src/protocols/Aws_query.ts
var se_ActivateOrganizationsAccessCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ActivateOrganizationsAccessInput(input, context),
    [_A]: _AOA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ActivateOrganizationsAccessCommand");
var se_ActivateTypeCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ActivateTypeInput(input, context),
    [_A]: _AT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ActivateTypeCommand");
var se_BatchDescribeTypeConfigurationsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_BatchDescribeTypeConfigurationsInput(input, context),
    [_A]: _BDTC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_BatchDescribeTypeConfigurationsCommand");
var se_CancelUpdateStackCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CancelUpdateStackInput(input, context),
    [_A]: _CUS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CancelUpdateStackCommand");
var se_ContinueUpdateRollbackCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ContinueUpdateRollbackInput(input, context),
    [_A]: _CUR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ContinueUpdateRollbackCommand");
var se_CreateChangeSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateChangeSetInput(input, context),
    [_A]: _CCS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateChangeSetCommand");
var se_CreateGeneratedTemplateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateGeneratedTemplateInput(input, context),
    [_A]: _CGT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateGeneratedTemplateCommand");
var se_CreateStackCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateStackInput(input, context),
    [_A]: _CS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateStackCommand");
var se_CreateStackInstancesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateStackInstancesInput(input, context),
    [_A]: _CSI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateStackInstancesCommand");
var se_CreateStackSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateStackSetInput(input, context),
    [_A]: _CSS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateStackSetCommand");
var se_DeactivateOrganizationsAccessCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeactivateOrganizationsAccessInput(input, context),
    [_A]: _DOA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeactivateOrganizationsAccessCommand");
var se_DeactivateTypeCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeactivateTypeInput(input, context),
    [_A]: _DT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeactivateTypeCommand");
var se_DeleteChangeSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteChangeSetInput(input, context),
    [_A]: _DCS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteChangeSetCommand");
var se_DeleteGeneratedTemplateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteGeneratedTemplateInput(input, context),
    [_A]: _DGT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteGeneratedTemplateCommand");
var se_DeleteStackCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteStackInput(input, context),
    [_A]: _DS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteStackCommand");
var se_DeleteStackInstancesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteStackInstancesInput(input, context),
    [_A]: _DSI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteStackInstancesCommand");
var se_DeleteStackSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteStackSetInput(input, context),
    [_A]: _DSS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteStackSetCommand");
var se_DeregisterTypeCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeregisterTypeInput(input, context),
    [_A]: _DTe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeregisterTypeCommand");
var se_DescribeAccountLimitsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeAccountLimitsInput(input, context),
    [_A]: _DAL,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeAccountLimitsCommand");
var se_DescribeChangeSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeChangeSetInput(input, context),
    [_A]: _DCSe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeChangeSetCommand");
var se_DescribeChangeSetHooksCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeChangeSetHooksInput(input, context),
    [_A]: _DCSH,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeChangeSetHooksCommand");
var se_DescribeGeneratedTemplateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeGeneratedTemplateInput(input, context),
    [_A]: _DGTe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeGeneratedTemplateCommand");
var se_DescribeOrganizationsAccessCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeOrganizationsAccessInput(input, context),
    [_A]: _DOAe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeOrganizationsAccessCommand");
var se_DescribePublisherCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribePublisherInput(input, context),
    [_A]: _DP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribePublisherCommand");
var se_DescribeResourceScanCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeResourceScanInput(input, context),
    [_A]: _DRS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeResourceScanCommand");
var se_DescribeStackDriftDetectionStatusCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeStackDriftDetectionStatusInput(input, context),
    [_A]: _DSDDS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeStackDriftDetectionStatusCommand");
var se_DescribeStackEventsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeStackEventsInput(input, context),
    [_A]: _DSE,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeStackEventsCommand");
var se_DescribeStackInstanceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeStackInstanceInput(input, context),
    [_A]: _DSIe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeStackInstanceCommand");
var se_DescribeStackResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeStackResourceInput(input, context),
    [_A]: _DSR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeStackResourceCommand");
var se_DescribeStackResourceDriftsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeStackResourceDriftsInput(input, context),
    [_A]: _DSRD,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeStackResourceDriftsCommand");
var se_DescribeStackResourcesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeStackResourcesInput(input, context),
    [_A]: _DSRe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeStackResourcesCommand");
var se_DescribeStacksCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeStacksInput(input, context),
    [_A]: _DSe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeStacksCommand");
var se_DescribeStackSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeStackSetInput(input, context),
    [_A]: _DSSe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeStackSetCommand");
var se_DescribeStackSetOperationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeStackSetOperationInput(input, context),
    [_A]: _DSSO,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeStackSetOperationCommand");
var se_DescribeTypeCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeTypeInput(input, context),
    [_A]: _DTes,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeTypeCommand");
var se_DescribeTypeRegistrationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeTypeRegistrationInput(input, context),
    [_A]: _DTR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeTypeRegistrationCommand");
var se_DetectStackDriftCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DetectStackDriftInput(input, context),
    [_A]: _DSD,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DetectStackDriftCommand");
var se_DetectStackResourceDriftCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DetectStackResourceDriftInput(input, context),
    [_A]: _DSRDe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DetectStackResourceDriftCommand");
var se_DetectStackSetDriftCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DetectStackSetDriftInput(input, context),
    [_A]: _DSSD,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DetectStackSetDriftCommand");
var se_EstimateTemplateCostCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_EstimateTemplateCostInput(input, context),
    [_A]: _ETC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_EstimateTemplateCostCommand");
var se_ExecuteChangeSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ExecuteChangeSetInput(input, context),
    [_A]: _ECS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ExecuteChangeSetCommand");
var se_GetGeneratedTemplateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_GetGeneratedTemplateInput(input, context),
    [_A]: _GGT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetGeneratedTemplateCommand");
var se_GetStackPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_GetStackPolicyInput(input, context),
    [_A]: _GSP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetStackPolicyCommand");
var se_GetTemplateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_GetTemplateInput(input, context),
    [_A]: _GT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetTemplateCommand");
var se_GetTemplateSummaryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_GetTemplateSummaryInput(input, context),
    [_A]: _GTS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_GetTemplateSummaryCommand");
var se_ImportStacksToStackSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ImportStacksToStackSetInput(input, context),
    [_A]: _ISTSS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ImportStacksToStackSetCommand");
var se_ListChangeSetsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListChangeSetsInput(input, context),
    [_A]: _LCS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListChangeSetsCommand");
var se_ListExportsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListExportsInput(input, context),
    [_A]: _LE,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListExportsCommand");
var se_ListGeneratedTemplatesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListGeneratedTemplatesInput(input, context),
    [_A]: _LGT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListGeneratedTemplatesCommand");
var se_ListImportsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListImportsInput(input, context),
    [_A]: _LI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListImportsCommand");
var se_ListResourceScanRelatedResourcesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListResourceScanRelatedResourcesInput(input, context),
    [_A]: _LRSRR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListResourceScanRelatedResourcesCommand");
var se_ListResourceScanResourcesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListResourceScanResourcesInput(input, context),
    [_A]: _LRSR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListResourceScanResourcesCommand");
var se_ListResourceScansCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListResourceScansInput(input, context),
    [_A]: _LRS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListResourceScansCommand");
var se_ListStackInstanceResourceDriftsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListStackInstanceResourceDriftsInput(input, context),
    [_A]: _LSIRD,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListStackInstanceResourceDriftsCommand");
var se_ListStackInstancesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListStackInstancesInput(input, context),
    [_A]: _LSI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListStackInstancesCommand");
var se_ListStackResourcesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListStackResourcesInput(input, context),
    [_A]: _LSR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListStackResourcesCommand");
var se_ListStacksCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListStacksInput(input, context),
    [_A]: _LS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListStacksCommand");
var se_ListStackSetAutoDeploymentTargetsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListStackSetAutoDeploymentTargetsInput(input, context),
    [_A]: _LSSADT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListStackSetAutoDeploymentTargetsCommand");
var se_ListStackSetOperationResultsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListStackSetOperationResultsInput(input, context),
    [_A]: _LSSOR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListStackSetOperationResultsCommand");
var se_ListStackSetOperationsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListStackSetOperationsInput(input, context),
    [_A]: _LSSO,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListStackSetOperationsCommand");
var se_ListStackSetsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListStackSetsInput(input, context),
    [_A]: _LSS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListStackSetsCommand");
var se_ListTypeRegistrationsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListTypeRegistrationsInput(input, context),
    [_A]: _LTR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListTypeRegistrationsCommand");
var se_ListTypesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListTypesInput(input, context),
    [_A]: _LT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListTypesCommand");
var se_ListTypeVersionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListTypeVersionsInput(input, context),
    [_A]: _LTV,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListTypeVersionsCommand");
var se_PublishTypeCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_PublishTypeInput(input, context),
    [_A]: _PT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PublishTypeCommand");
var se_RecordHandlerProgressCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RecordHandlerProgressInput(input, context),
    [_A]: _RHP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RecordHandlerProgressCommand");
var se_RegisterPublisherCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RegisterPublisherInput(input, context),
    [_A]: _RP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RegisterPublisherCommand");
var se_RegisterTypeCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RegisterTypeInput(input, context),
    [_A]: _RT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RegisterTypeCommand");
var se_RollbackStackCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RollbackStackInput(input, context),
    [_A]: _RS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RollbackStackCommand");
var se_SetStackPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_SetStackPolicyInput(input, context),
    [_A]: _SSP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SetStackPolicyCommand");
var se_SetTypeConfigurationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_SetTypeConfigurationInput(input, context),
    [_A]: _STC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SetTypeConfigurationCommand");
var se_SetTypeDefaultVersionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_SetTypeDefaultVersionInput(input, context),
    [_A]: _STDV,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SetTypeDefaultVersionCommand");
var se_SignalResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_SignalResourceInput(input, context),
    [_A]: _SR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SignalResourceCommand");
var se_StartResourceScanCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_StartResourceScanInput(input, context),
    [_A]: _SRS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StartResourceScanCommand");
var se_StopStackSetOperationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_StopStackSetOperationInput(input, context),
    [_A]: _SSSO,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StopStackSetOperationCommand");
var se_TestTypeCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_TestTypeInput(input, context),
    [_A]: _TT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_TestTypeCommand");
var se_UpdateGeneratedTemplateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_UpdateGeneratedTemplateInput(input, context),
    [_A]: _UGT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateGeneratedTemplateCommand");
var se_UpdateStackCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_UpdateStackInput(input, context),
    [_A]: _US,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateStackCommand");
var se_UpdateStackInstancesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_UpdateStackInstancesInput(input, context),
    [_A]: _USI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateStackInstancesCommand");
var se_UpdateStackSetCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_UpdateStackSetInput(input, context),
    [_A]: _USS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateStackSetCommand");
var se_UpdateTerminationProtectionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_UpdateTerminationProtectionInput(input, context),
    [_A]: _UTP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_UpdateTerminationProtectionCommand");
var se_ValidateTemplateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ValidateTemplateInput(input, context),
    [_A]: _VT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ValidateTemplateCommand");
var de_ActivateOrganizationsAccessCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ActivateOrganizationsAccessOutput(data.ActivateOrganizationsAccessResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ActivateOrganizationsAccessCommand");
var de_ActivateTypeCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ActivateTypeOutput(data.ActivateTypeResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ActivateTypeCommand");
var de_BatchDescribeTypeConfigurationsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_BatchDescribeTypeConfigurationsOutput(data.BatchDescribeTypeConfigurationsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_BatchDescribeTypeConfigurationsCommand");
var de_CancelUpdateStackCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_CancelUpdateStackCommand");
var de_ContinueUpdateRollbackCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ContinueUpdateRollbackOutput(data.ContinueUpdateRollbackResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ContinueUpdateRollbackCommand");
var de_CreateChangeSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateChangeSetOutput(data.CreateChangeSetResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateChangeSetCommand");
var de_CreateGeneratedTemplateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateGeneratedTemplateOutput(data.CreateGeneratedTemplateResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateGeneratedTemplateCommand");
var de_CreateStackCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateStackOutput(data.CreateStackResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateStackCommand");
var de_CreateStackInstancesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateStackInstancesOutput(data.CreateStackInstancesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateStackInstancesCommand");
var de_CreateStackSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateStackSetOutput(data.CreateStackSetResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateStackSetCommand");
var de_DeactivateOrganizationsAccessCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeactivateOrganizationsAccessOutput(data.DeactivateOrganizationsAccessResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeactivateOrganizationsAccessCommand");
var de_DeactivateTypeCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeactivateTypeOutput(data.DeactivateTypeResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeactivateTypeCommand");
var de_DeleteChangeSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeleteChangeSetOutput(data.DeleteChangeSetResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteChangeSetCommand");
var de_DeleteGeneratedTemplateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeleteGeneratedTemplateCommand");
var de_DeleteStackCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeleteStackCommand");
var de_DeleteStackInstancesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeleteStackInstancesOutput(data.DeleteStackInstancesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteStackInstancesCommand");
var de_DeleteStackSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeleteStackSetOutput(data.DeleteStackSetResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteStackSetCommand");
var de_DeregisterTypeCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeregisterTypeOutput(data.DeregisterTypeResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeregisterTypeCommand");
var de_DescribeAccountLimitsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeAccountLimitsOutput(data.DescribeAccountLimitsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeAccountLimitsCommand");
var de_DescribeChangeSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeChangeSetOutput(data.DescribeChangeSetResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeChangeSetCommand");
var de_DescribeChangeSetHooksCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeChangeSetHooksOutput(data.DescribeChangeSetHooksResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeChangeSetHooksCommand");
var de_DescribeGeneratedTemplateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeGeneratedTemplateOutput(data.DescribeGeneratedTemplateResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeGeneratedTemplateCommand");
var de_DescribeOrganizationsAccessCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeOrganizationsAccessOutput(data.DescribeOrganizationsAccessResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeOrganizationsAccessCommand");
var de_DescribePublisherCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribePublisherOutput(data.DescribePublisherResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribePublisherCommand");
var de_DescribeResourceScanCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeResourceScanOutput(data.DescribeResourceScanResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeResourceScanCommand");
var de_DescribeStackDriftDetectionStatusCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeStackDriftDetectionStatusOutput(data.DescribeStackDriftDetectionStatusResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeStackDriftDetectionStatusCommand");
var de_DescribeStackEventsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeStackEventsOutput(data.DescribeStackEventsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeStackEventsCommand");
var de_DescribeStackInstanceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeStackInstanceOutput(data.DescribeStackInstanceResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeStackInstanceCommand");
var de_DescribeStackResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeStackResourceOutput(data.DescribeStackResourceResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeStackResourceCommand");
var de_DescribeStackResourceDriftsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeStackResourceDriftsOutput(data.DescribeStackResourceDriftsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeStackResourceDriftsCommand");
var de_DescribeStackResourcesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeStackResourcesOutput(data.DescribeStackResourcesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeStackResourcesCommand");
var de_DescribeStacksCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeStacksOutput(data.DescribeStacksResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeStacksCommand");
var de_DescribeStackSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeStackSetOutput(data.DescribeStackSetResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeStackSetCommand");
var de_DescribeStackSetOperationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeStackSetOperationOutput(data.DescribeStackSetOperationResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeStackSetOperationCommand");
var de_DescribeTypeCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeTypeOutput(data.DescribeTypeResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeTypeCommand");
var de_DescribeTypeRegistrationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeTypeRegistrationOutput(data.DescribeTypeRegistrationResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeTypeRegistrationCommand");
var de_DetectStackDriftCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DetectStackDriftOutput(data.DetectStackDriftResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DetectStackDriftCommand");
var de_DetectStackResourceDriftCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DetectStackResourceDriftOutput(data.DetectStackResourceDriftResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DetectStackResourceDriftCommand");
var de_DetectStackSetDriftCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DetectStackSetDriftOutput(data.DetectStackSetDriftResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DetectStackSetDriftCommand");
var de_EstimateTemplateCostCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_EstimateTemplateCostOutput(data.EstimateTemplateCostResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_EstimateTemplateCostCommand");
var de_ExecuteChangeSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ExecuteChangeSetOutput(data.ExecuteChangeSetResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ExecuteChangeSetCommand");
var de_GetGeneratedTemplateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_GetGeneratedTemplateOutput(data.GetGeneratedTemplateResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetGeneratedTemplateCommand");
var de_GetStackPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_GetStackPolicyOutput(data.GetStackPolicyResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetStackPolicyCommand");
var de_GetTemplateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_GetTemplateOutput(data.GetTemplateResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetTemplateCommand");
var de_GetTemplateSummaryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_GetTemplateSummaryOutput(data.GetTemplateSummaryResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_GetTemplateSummaryCommand");
var de_ImportStacksToStackSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ImportStacksToStackSetOutput(data.ImportStacksToStackSetResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ImportStacksToStackSetCommand");
var de_ListChangeSetsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListChangeSetsOutput(data.ListChangeSetsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListChangeSetsCommand");
var de_ListExportsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListExportsOutput(data.ListExportsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListExportsCommand");
var de_ListGeneratedTemplatesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListGeneratedTemplatesOutput(data.ListGeneratedTemplatesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListGeneratedTemplatesCommand");
var de_ListImportsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListImportsOutput(data.ListImportsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListImportsCommand");
var de_ListResourceScanRelatedResourcesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListResourceScanRelatedResourcesOutput(data.ListResourceScanRelatedResourcesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListResourceScanRelatedResourcesCommand");
var de_ListResourceScanResourcesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListResourceScanResourcesOutput(data.ListResourceScanResourcesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListResourceScanResourcesCommand");
var de_ListResourceScansCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListResourceScansOutput(data.ListResourceScansResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListResourceScansCommand");
var de_ListStackInstanceResourceDriftsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListStackInstanceResourceDriftsOutput(data.ListStackInstanceResourceDriftsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListStackInstanceResourceDriftsCommand");
var de_ListStackInstancesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListStackInstancesOutput(data.ListStackInstancesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListStackInstancesCommand");
var de_ListStackResourcesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListStackResourcesOutput(data.ListStackResourcesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListStackResourcesCommand");
var de_ListStacksCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListStacksOutput(data.ListStacksResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListStacksCommand");
var de_ListStackSetAutoDeploymentTargetsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListStackSetAutoDeploymentTargetsOutput(data.ListStackSetAutoDeploymentTargetsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListStackSetAutoDeploymentTargetsCommand");
var de_ListStackSetOperationResultsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListStackSetOperationResultsOutput(data.ListStackSetOperationResultsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListStackSetOperationResultsCommand");
var de_ListStackSetOperationsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListStackSetOperationsOutput(data.ListStackSetOperationsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListStackSetOperationsCommand");
var de_ListStackSetsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListStackSetsOutput(data.ListStackSetsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListStackSetsCommand");
var de_ListTypeRegistrationsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListTypeRegistrationsOutput(data.ListTypeRegistrationsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListTypeRegistrationsCommand");
var de_ListTypesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListTypesOutput(data.ListTypesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListTypesCommand");
var de_ListTypeVersionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ListTypeVersionsOutput(data.ListTypeVersionsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListTypeVersionsCommand");
var de_PublishTypeCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_PublishTypeOutput(data.PublishTypeResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PublishTypeCommand");
var de_RecordHandlerProgressCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_RecordHandlerProgressOutput(data.RecordHandlerProgressResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RecordHandlerProgressCommand");
var de_RegisterPublisherCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_RegisterPublisherOutput(data.RegisterPublisherResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RegisterPublisherCommand");
var de_RegisterTypeCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_RegisterTypeOutput(data.RegisterTypeResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RegisterTypeCommand");
var de_RollbackStackCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_RollbackStackOutput(data.RollbackStackResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RollbackStackCommand");
var de_SetStackPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_SetStackPolicyCommand");
var de_SetTypeConfigurationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_SetTypeConfigurationOutput(data.SetTypeConfigurationResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_SetTypeConfigurationCommand");
var de_SetTypeDefaultVersionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_SetTypeDefaultVersionOutput(data.SetTypeDefaultVersionResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_SetTypeDefaultVersionCommand");
var de_SignalResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_SignalResourceCommand");
var de_StartResourceScanCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_StartResourceScanOutput(data.StartResourceScanResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StartResourceScanCommand");
var de_StopStackSetOperationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_StopStackSetOperationOutput(data.StopStackSetOperationResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StopStackSetOperationCommand");
var de_TestTypeCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_TestTypeOutput(data.TestTypeResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_TestTypeCommand");
var de_UpdateGeneratedTemplateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_UpdateGeneratedTemplateOutput(data.UpdateGeneratedTemplateResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateGeneratedTemplateCommand");
var de_UpdateStackCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_UpdateStackOutput(data.UpdateStackResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateStackCommand");
var de_UpdateStackInstancesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_UpdateStackInstancesOutput(data.UpdateStackInstancesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateStackInstancesCommand");
var de_UpdateStackSetCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_UpdateStackSetOutput(data.UpdateStackSetResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateStackSetCommand");
var de_UpdateTerminationProtectionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_UpdateTerminationProtectionOutput(data.UpdateTerminationProtectionResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_UpdateTerminationProtectionCommand");
var de_ValidateTemplateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ValidateTemplateOutput(data.ValidateTemplateResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ValidateTemplateCommand");
var de_CommandError = /* @__PURE__ */ __name(async (output, context) => {
  const parsedOutput = {
    ...output,
    body: await (0, import_core2.parseXmlErrorBody)(output.body, context)
  };
  const errorCode = loadQueryErrorCode(output, parsedOutput.body);
  switch (errorCode) {
    case "InvalidOperationException":
    case "com.amazonaws.cloudformation#InvalidOperationException":
      throw await de_InvalidOperationExceptionRes(parsedOutput, context);
    case "OperationNotFoundException":
    case "com.amazonaws.cloudformation#OperationNotFoundException":
      throw await de_OperationNotFoundExceptionRes(parsedOutput, context);
    case "CFNRegistryException":
    case "com.amazonaws.cloudformation#CFNRegistryException":
      throw await de_CFNRegistryExceptionRes(parsedOutput, context);
    case "TypeNotFoundException":
    case "com.amazonaws.cloudformation#TypeNotFoundException":
      throw await de_TypeNotFoundExceptionRes(parsedOutput, context);
    case "TypeConfigurationNotFoundException":
    case "com.amazonaws.cloudformation#TypeConfigurationNotFoundException":
      throw await de_TypeConfigurationNotFoundExceptionRes(parsedOutput, context);
    case "TokenAlreadyExistsException":
    case "com.amazonaws.cloudformation#TokenAlreadyExistsException":
      throw await de_TokenAlreadyExistsExceptionRes(parsedOutput, context);
    case "AlreadyExistsException":
    case "com.amazonaws.cloudformation#AlreadyExistsException":
      throw await de_AlreadyExistsExceptionRes(parsedOutput, context);
    case "InsufficientCapabilitiesException":
    case "com.amazonaws.cloudformation#InsufficientCapabilitiesException":
      throw await de_InsufficientCapabilitiesExceptionRes(parsedOutput, context);
    case "LimitExceededException":
    case "com.amazonaws.cloudformation#LimitExceededException":
      throw await de_LimitExceededExceptionRes(parsedOutput, context);
    case "ConcurrentResourcesLimitExceeded":
    case "com.amazonaws.cloudformation#ConcurrentResourcesLimitExceededException":
      throw await de_ConcurrentResourcesLimitExceededExceptionRes(parsedOutput, context);
    case "OperationIdAlreadyExistsException":
    case "com.amazonaws.cloudformation#OperationIdAlreadyExistsException":
      throw await de_OperationIdAlreadyExistsExceptionRes(parsedOutput, context);
    case "OperationInProgressException":
    case "com.amazonaws.cloudformation#OperationInProgressException":
      throw await de_OperationInProgressExceptionRes(parsedOutput, context);
    case "StackSetNotFoundException":
    case "com.amazonaws.cloudformation#StackSetNotFoundException":
      throw await de_StackSetNotFoundExceptionRes(parsedOutput, context);
    case "StaleRequestException":
    case "com.amazonaws.cloudformation#StaleRequestException":
      throw await de_StaleRequestExceptionRes(parsedOutput, context);
    case "CreatedButModifiedException":
    case "com.amazonaws.cloudformation#CreatedButModifiedException":
      throw await de_CreatedButModifiedExceptionRes(parsedOutput, context);
    case "NameAlreadyExistsException":
    case "com.amazonaws.cloudformation#NameAlreadyExistsException":
      throw await de_NameAlreadyExistsExceptionRes(parsedOutput, context);
    case "InvalidChangeSetStatus":
    case "com.amazonaws.cloudformation#InvalidChangeSetStatusException":
      throw await de_InvalidChangeSetStatusExceptionRes(parsedOutput, context);
    case "GeneratedTemplateNotFound":
    case "com.amazonaws.cloudformation#GeneratedTemplateNotFoundException":
      throw await de_GeneratedTemplateNotFoundExceptionRes(parsedOutput, context);
    case "StackSetNotEmptyException":
    case "com.amazonaws.cloudformation#StackSetNotEmptyException":
      throw await de_StackSetNotEmptyExceptionRes(parsedOutput, context);
    case "ChangeSetNotFound":
    case "com.amazonaws.cloudformation#ChangeSetNotFoundException":
      throw await de_ChangeSetNotFoundExceptionRes(parsedOutput, context);
    case "ResourceScanNotFound":
    case "com.amazonaws.cloudformation#ResourceScanNotFoundException":
      throw await de_ResourceScanNotFoundExceptionRes(parsedOutput, context);
    case "StackInstanceNotFoundException":
    case "com.amazonaws.cloudformation#StackInstanceNotFoundException":
      throw await de_StackInstanceNotFoundExceptionRes(parsedOutput, context);
    case "StackNotFoundException":
    case "com.amazonaws.cloudformation#StackNotFoundException":
      throw await de_StackNotFoundExceptionRes(parsedOutput, context);
    case "ResourceScanInProgress":
    case "com.amazonaws.cloudformation#ResourceScanInProgressException":
      throw await de_ResourceScanInProgressExceptionRes(parsedOutput, context);
    case "ConditionalCheckFailed":
    case "com.amazonaws.cloudformation#OperationStatusCheckFailedException":
      throw await de_OperationStatusCheckFailedExceptionRes(parsedOutput, context);
    case "InvalidStateTransition":
    case "com.amazonaws.cloudformation#InvalidStateTransitionException":
      throw await de_InvalidStateTransitionExceptionRes(parsedOutput, context);
    case "ResourceScanLimitExceeded":
    case "com.amazonaws.cloudformation#ResourceScanLimitExceededException":
      throw await de_ResourceScanLimitExceededExceptionRes(parsedOutput, context);
    default:
      const parsedBody = parsedOutput.body;
      return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode
      });
  }
}, "de_CommandError");
var de_AlreadyExistsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_AlreadyExistsException(body.Error, context);
  const exception = new AlreadyExistsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AlreadyExistsExceptionRes");
var de_CFNRegistryExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_CFNRegistryException(body.Error, context);
  const exception = new CFNRegistryException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CFNRegistryExceptionRes");
var de_ChangeSetNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ChangeSetNotFoundException(body.Error, context);
  const exception = new ChangeSetNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ChangeSetNotFoundExceptionRes");
var de_ConcurrentResourcesLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ConcurrentResourcesLimitExceededException(body.Error, context);
  const exception = new ConcurrentResourcesLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ConcurrentResourcesLimitExceededExceptionRes");
var de_CreatedButModifiedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_CreatedButModifiedException(body.Error, context);
  const exception = new CreatedButModifiedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CreatedButModifiedExceptionRes");
var de_GeneratedTemplateNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_GeneratedTemplateNotFoundException(body.Error, context);
  const exception = new GeneratedTemplateNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_GeneratedTemplateNotFoundExceptionRes");
var de_InsufficientCapabilitiesExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InsufficientCapabilitiesException(body.Error, context);
  const exception = new InsufficientCapabilitiesException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InsufficientCapabilitiesExceptionRes");
var de_InvalidChangeSetStatusExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidChangeSetStatusException(body.Error, context);
  const exception = new InvalidChangeSetStatusException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidChangeSetStatusExceptionRes");
var de_InvalidOperationExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidOperationException(body.Error, context);
  const exception = new InvalidOperationException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidOperationExceptionRes");
var de_InvalidStateTransitionExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidStateTransitionException(body.Error, context);
  const exception = new InvalidStateTransitionException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidStateTransitionExceptionRes");
var de_LimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_LimitExceededException(body.Error, context);
  const exception = new LimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_LimitExceededExceptionRes");
var de_NameAlreadyExistsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_NameAlreadyExistsException(body.Error, context);
  const exception = new NameAlreadyExistsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_NameAlreadyExistsExceptionRes");
var de_OperationIdAlreadyExistsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_OperationIdAlreadyExistsException(body.Error, context);
  const exception = new OperationIdAlreadyExistsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OperationIdAlreadyExistsExceptionRes");
var de_OperationInProgressExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_OperationInProgressException(body.Error, context);
  const exception = new OperationInProgressException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OperationInProgressExceptionRes");
var de_OperationNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_OperationNotFoundException(body.Error, context);
  const exception = new OperationNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OperationNotFoundExceptionRes");
var de_OperationStatusCheckFailedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_OperationStatusCheckFailedException(body.Error, context);
  const exception = new OperationStatusCheckFailedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OperationStatusCheckFailedExceptionRes");
var de_ResourceScanInProgressExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ResourceScanInProgressException(body.Error, context);
  const exception = new ResourceScanInProgressException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceScanInProgressExceptionRes");
var de_ResourceScanLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ResourceScanLimitExceededException(body.Error, context);
  const exception = new ResourceScanLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceScanLimitExceededExceptionRes");
var de_ResourceScanNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ResourceScanNotFoundException(body.Error, context);
  const exception = new ResourceScanNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceScanNotFoundExceptionRes");
var de_StackInstanceNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_StackInstanceNotFoundException(body.Error, context);
  const exception = new StackInstanceNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_StackInstanceNotFoundExceptionRes");
var de_StackNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_StackNotFoundException(body.Error, context);
  const exception = new StackNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_StackNotFoundExceptionRes");
var de_StackSetNotEmptyExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_StackSetNotEmptyException(body.Error, context);
  const exception = new StackSetNotEmptyException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_StackSetNotEmptyExceptionRes");
var de_StackSetNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_StackSetNotFoundException(body.Error, context);
  const exception = new StackSetNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_StackSetNotFoundExceptionRes");
var de_StaleRequestExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_StaleRequestException(body.Error, context);
  const exception = new StaleRequestException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_StaleRequestExceptionRes");
var de_TokenAlreadyExistsExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_TokenAlreadyExistsException(body.Error, context);
  const exception = new TokenAlreadyExistsException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TokenAlreadyExistsExceptionRes");
var de_TypeConfigurationNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_TypeConfigurationNotFoundException(body.Error, context);
  const exception = new TypeConfigurationNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TypeConfigurationNotFoundExceptionRes");
var de_TypeNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_TypeNotFoundException(body.Error, context);
  const exception = new TypeNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TypeNotFoundExceptionRes");
var se_AccountList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_AccountList");
var se_ActivateOrganizationsAccessInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  return entries;
}, "se_ActivateOrganizationsAccessInput");
var se_ActivateTypeInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_T] != null) {
    entries[_T] = input[_T];
  }
  if (input[_PTA] != null) {
    entries[_PTA] = input[_PTA];
  }
  if (input[_PI] != null) {
    entries[_PI] = input[_PI];
  }
  if (input[_TN] != null) {
    entries[_TN] = input[_TN];
  }
  if (input[_TNA] != null) {
    entries[_TNA] = input[_TNA];
  }
  if (input[_AU] != null) {
    entries[_AU] = input[_AU];
  }
  if (input[_LC] != null) {
    const memberEntries = se_LoggingConfig(input[_LC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `LoggingConfig.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_ERA] != null) {
    entries[_ERA] = input[_ERA];
  }
  if (input[_VB] != null) {
    entries[_VB] = input[_VB];
  }
  if (input[_MV] != null) {
    entries[_MV] = input[_MV];
  }
  return entries;
}, "se_ActivateTypeInput");
var se_AutoDeployment = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_RSOAR] != null) {
    entries[_RSOAR] = input[_RSOAR];
  }
  return entries;
}, "se_AutoDeployment");
var se_BatchDescribeTypeConfigurationsInput = /* @__PURE__ */ __name((input, context) => {
  var _a;
  const entries = {};
  if (input[_TCI] != null) {
    const memberEntries = se_TypeConfigurationIdentifiers(input[_TCI], context);
    if (((_a = input[_TCI]) == null ? void 0 : _a.length) === 0) {
      entries.TypeConfigurationIdentifiers = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `TypeConfigurationIdentifiers.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_BatchDescribeTypeConfigurationsInput");
var se_CancelUpdateStackInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_CRT] != null) {
    entries[_CRT] = input[_CRT];
  }
  return entries;
}, "se_CancelUpdateStackInput");
var se_Capabilities = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_Capabilities");
var se_ContinueUpdateRollbackInput = /* @__PURE__ */ __name((input, context) => {
  var _a;
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_RARN] != null) {
    entries[_RARN] = input[_RARN];
  }
  if (input[_RTS] != null) {
    const memberEntries = se_ResourcesToSkip(input[_RTS], context);
    if (((_a = input[_RTS]) == null ? void 0 : _a.length) === 0) {
      entries.ResourcesToSkip = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ResourcesToSkip.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_CRT] != null) {
    entries[_CRT] = input[_CRT];
  }
  return entries;
}, "se_ContinueUpdateRollbackInput");
var se_CreateChangeSetInput = /* @__PURE__ */ __name((input, context) => {
  var _a, _b, _c, _d, _e2, _f;
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_TB] != null) {
    entries[_TB] = input[_TB];
  }
  if (input[_TURL] != null) {
    entries[_TURL] = input[_TURL];
  }
  if (input[_UPT] != null) {
    entries[_UPT] = input[_UPT];
  }
  if (input[_P] != null) {
    const memberEntries = se_Parameters(input[_P], context);
    if (((_a = input[_P]) == null ? void 0 : _a.length) === 0) {
      entries.Parameters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Parameters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_C] != null) {
    const memberEntries = se_Capabilities(input[_C], context);
    if (((_b = input[_C]) == null ? void 0 : _b.length) === 0) {
      entries.Capabilities = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Capabilities.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_RTe] != null) {
    const memberEntries = se_ResourceTypes(input[_RTe], context);
    if (((_c = input[_RTe]) == null ? void 0 : _c.length) === 0) {
      entries.ResourceTypes = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ResourceTypes.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_RARN] != null) {
    entries[_RARN] = input[_RARN];
  }
  if (input[_RC] != null) {
    const memberEntries = se_RollbackConfiguration(input[_RC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `RollbackConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_NARN] != null) {
    const memberEntries = se_NotificationARNs(input[_NARN], context);
    if (((_d = input[_NARN]) == null ? void 0 : _d.length) === 0) {
      entries.NotificationARNs = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `NotificationARNs.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Ta] != null) {
    const memberEntries = se_Tags(input[_Ta], context);
    if (((_e2 = input[_Ta]) == null ? void 0 : _e2.length) === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_CSN] != null) {
    entries[_CSN] = input[_CSN];
  }
  if (input[_CT] != null) {
    entries[_CT] = input[_CT];
  }
  if (input[_D] != null) {
    entries[_D] = input[_D];
  }
  if (input[_CST] != null) {
    entries[_CST] = input[_CST];
  }
  if (input[_RTI] != null) {
    const memberEntries = se_ResourcesToImport(input[_RTI], context);
    if (((_f = input[_RTI]) == null ? void 0 : _f.length) === 0) {
      entries.ResourcesToImport = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ResourcesToImport.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_INS] != null) {
    entries[_INS] = input[_INS];
  }
  if (input[_OSF] != null) {
    entries[_OSF] = input[_OSF];
  }
  if (input[_IER] != null) {
    entries[_IER] = input[_IER];
  }
  return entries;
}, "se_CreateChangeSetInput");
var se_CreateGeneratedTemplateInput = /* @__PURE__ */ __name((input, context) => {
  var _a;
  const entries = {};
  if (input[_R] != null) {
    const memberEntries = se_ResourceDefinitions(input[_R], context);
    if (((_a = input[_R]) == null ? void 0 : _a.length) === 0) {
      entries.Resources = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Resources.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_GTN] != null) {
    entries[_GTN] = input[_GTN];
  }
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_TC] != null) {
    const memberEntries = se_TemplateConfiguration(input[_TC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `TemplateConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreateGeneratedTemplateInput");
var se_CreateStackInput = /* @__PURE__ */ __name((input, context) => {
  var _a, _b, _c, _d, _e2;
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_TB] != null) {
    entries[_TB] = input[_TB];
  }
  if (input[_TURL] != null) {
    entries[_TURL] = input[_TURL];
  }
  if (input[_P] != null) {
    const memberEntries = se_Parameters(input[_P], context);
    if (((_a = input[_P]) == null ? void 0 : _a.length) === 0) {
      entries.Parameters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Parameters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DR] != null) {
    entries[_DR] = input[_DR];
  }
  if (input[_RC] != null) {
    const memberEntries = se_RollbackConfiguration(input[_RC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `RollbackConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_TIM] != null) {
    entries[_TIM] = input[_TIM];
  }
  if (input[_NARN] != null) {
    const memberEntries = se_NotificationARNs(input[_NARN], context);
    if (((_b = input[_NARN]) == null ? void 0 : _b.length) === 0) {
      entries.NotificationARNs = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `NotificationARNs.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_C] != null) {
    const memberEntries = se_Capabilities(input[_C], context);
    if (((_c = input[_C]) == null ? void 0 : _c.length) === 0) {
      entries.Capabilities = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Capabilities.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_RTe] != null) {
    const memberEntries = se_ResourceTypes(input[_RTe], context);
    if (((_d = input[_RTe]) == null ? void 0 : _d.length) === 0) {
      entries.ResourceTypes = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ResourceTypes.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_RARN] != null) {
    entries[_RARN] = input[_RARN];
  }
  if (input[_OF] != null) {
    entries[_OF] = input[_OF];
  }
  if (input[_SPB] != null) {
    entries[_SPB] = input[_SPB];
  }
  if (input[_SPURL] != null) {
    entries[_SPURL] = input[_SPURL];
  }
  if (input[_Ta] != null) {
    const memberEntries = se_Tags(input[_Ta], context);
    if (((_e2 = input[_Ta]) == null ? void 0 : _e2.length) === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_CRT] != null) {
    entries[_CRT] = input[_CRT];
  }
  if (input[_ETP] != null) {
    entries[_ETP] = input[_ETP];
  }
  if (input[_REOC] != null) {
    entries[_REOC] = input[_REOC];
  }
  return entries;
}, "se_CreateStackInput");
var se_CreateStackInstancesInput = /* @__PURE__ */ __name((input, context) => {
  var _a, _b, _c;
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_Ac] != null) {
    const memberEntries = se_AccountList(input[_Ac], context);
    if (((_a = input[_Ac]) == null ? void 0 : _a.length) === 0) {
      entries.Accounts = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Accounts.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DTep] != null) {
    const memberEntries = se_DeploymentTargets(input[_DTep], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DeploymentTargets.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Re] != null) {
    const memberEntries = se_RegionList(input[_Re], context);
    if (((_b = input[_Re]) == null ? void 0 : _b.length) === 0) {
      entries.Regions = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Regions.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_PO] != null) {
    const memberEntries = se_Parameters(input[_PO], context);
    if (((_c = input[_PO]) == null ? void 0 : _c.length) === 0) {
      entries.ParameterOverrides = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ParameterOverrides.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_OP] != null) {
    const memberEntries = se_StackSetOperationPreferences(input[_OP], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `OperationPreferences.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_OI] === void 0) {
    input[_OI] = (0, import_uuid.v4)();
  }
  if (input[_OI] != null) {
    entries[_OI] = input[_OI];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  return entries;
}, "se_CreateStackInstancesInput");
var se_CreateStackSetInput = /* @__PURE__ */ __name((input, context) => {
  var _a, _b, _c;
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_D] != null) {
    entries[_D] = input[_D];
  }
  if (input[_TB] != null) {
    entries[_TB] = input[_TB];
  }
  if (input[_TURL] != null) {
    entries[_TURL] = input[_TURL];
  }
  if (input[_SI] != null) {
    entries[_SI] = input[_SI];
  }
  if (input[_P] != null) {
    const memberEntries = se_Parameters(input[_P], context);
    if (((_a = input[_P]) == null ? void 0 : _a.length) === 0) {
      entries.Parameters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Parameters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_C] != null) {
    const memberEntries = se_Capabilities(input[_C], context);
    if (((_b = input[_C]) == null ? void 0 : _b.length) === 0) {
      entries.Capabilities = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Capabilities.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Ta] != null) {
    const memberEntries = se_Tags(input[_Ta], context);
    if (((_c = input[_Ta]) == null ? void 0 : _c.length) === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_ARARN] != null) {
    entries[_ARARN] = input[_ARARN];
  }
  if (input[_ERN] != null) {
    entries[_ERN] = input[_ERN];
  }
  if (input[_PM] != null) {
    entries[_PM] = input[_PM];
  }
  if (input[_AD] != null) {
    const memberEntries = se_AutoDeployment(input[_AD], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `AutoDeployment.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  if (input[_CRT] === void 0) {
    input[_CRT] = (0, import_uuid.v4)();
  }
  if (input[_CRT] != null) {
    entries[_CRT] = input[_CRT];
  }
  if (input[_ME] != null) {
    const memberEntries = se_ManagedExecution(input[_ME], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ManagedExecution.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreateStackSetInput");
var se_DeactivateOrganizationsAccessInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  return entries;
}, "se_DeactivateOrganizationsAccessInput");
var se_DeactivateTypeInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TN] != null) {
    entries[_TN] = input[_TN];
  }
  if (input[_T] != null) {
    entries[_T] = input[_T];
  }
  if (input[_Ar] != null) {
    entries[_Ar] = input[_Ar];
  }
  return entries;
}, "se_DeactivateTypeInput");
var se_DeleteChangeSetInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_CSN] != null) {
    entries[_CSN] = input[_CSN];
  }
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  return entries;
}, "se_DeleteChangeSetInput");
var se_DeleteGeneratedTemplateInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_GTN] != null) {
    entries[_GTN] = input[_GTN];
  }
  return entries;
}, "se_DeleteGeneratedTemplateInput");
var se_DeleteStackInput = /* @__PURE__ */ __name((input, context) => {
  var _a;
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_RR] != null) {
    const memberEntries = se_RetainResources(input[_RR], context);
    if (((_a = input[_RR]) == null ? void 0 : _a.length) === 0) {
      entries.RetainResources = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `RetainResources.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_RARN] != null) {
    entries[_RARN] = input[_RARN];
  }
  if (input[_CRT] != null) {
    entries[_CRT] = input[_CRT];
  }
  return entries;
}, "se_DeleteStackInput");
var se_DeleteStackInstancesInput = /* @__PURE__ */ __name((input, context) => {
  var _a, _b;
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_Ac] != null) {
    const memberEntries = se_AccountList(input[_Ac], context);
    if (((_a = input[_Ac]) == null ? void 0 : _a.length) === 0) {
      entries.Accounts = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Accounts.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DTep] != null) {
    const memberEntries = se_DeploymentTargets(input[_DTep], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DeploymentTargets.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Re] != null) {
    const memberEntries = se_RegionList(input[_Re], context);
    if (((_b = input[_Re]) == null ? void 0 : _b.length) === 0) {
      entries.Regions = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Regions.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_OP] != null) {
    const memberEntries = se_StackSetOperationPreferences(input[_OP], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `OperationPreferences.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_RSe] != null) {
    entries[_RSe] = input[_RSe];
  }
  if (input[_OI] === void 0) {
    input[_OI] = (0, import_uuid.v4)();
  }
  if (input[_OI] != null) {
    entries[_OI] = input[_OI];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  return entries;
}, "se_DeleteStackInstancesInput");
var se_DeleteStackSetInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  return entries;
}, "se_DeleteStackSetInput");
var se_DeploymentTargets = /* @__PURE__ */ __name((input, context) => {
  var _a, _b;
  const entries = {};
  if (input[_Ac] != null) {
    const memberEntries = se_AccountList(input[_Ac], context);
    if (((_a = input[_Ac]) == null ? void 0 : _a.length) === 0) {
      entries.Accounts = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Accounts.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_AUc] != null) {
    entries[_AUc] = input[_AUc];
  }
  if (input[_OUI] != null) {
    const memberEntries = se_OrganizationalUnitIdList(input[_OUI], context);
    if (((_b = input[_OUI]) == null ? void 0 : _b.length) === 0) {
      entries.OrganizationalUnitIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `OrganizationalUnitIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_AFT] != null) {
    entries[_AFT] = input[_AFT];
  }
  return entries;
}, "se_DeploymentTargets");
var se_DeregisterTypeInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_Ar] != null) {
    entries[_Ar] = input[_Ar];
  }
  if (input[_T] != null) {
    entries[_T] = input[_T];
  }
  if (input[_TN] != null) {
    entries[_TN] = input[_TN];
  }
  if (input[_VI] != null) {
    entries[_VI] = input[_VI];
  }
  return entries;
}, "se_DeregisterTypeInput");
var se_DescribeAccountLimitsInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  return entries;
}, "se_DescribeAccountLimitsInput");
var se_DescribeChangeSetHooksInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_CSN] != null) {
    entries[_CSN] = input[_CSN];
  }
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_LRI] != null) {
    entries[_LRI] = input[_LRI];
  }
  return entries;
}, "se_DescribeChangeSetHooksInput");
var se_DescribeChangeSetInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_CSN] != null) {
    entries[_CSN] = input[_CSN];
  }
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_IPV] != null) {
    entries[_IPV] = input[_IPV];
  }
  return entries;
}, "se_DescribeChangeSetInput");
var se_DescribeGeneratedTemplateInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_GTN] != null) {
    entries[_GTN] = input[_GTN];
  }
  return entries;
}, "se_DescribeGeneratedTemplateInput");
var se_DescribeOrganizationsAccessInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  return entries;
}, "se_DescribeOrganizationsAccessInput");
var se_DescribePublisherInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_PI] != null) {
    entries[_PI] = input[_PI];
  }
  return entries;
}, "se_DescribePublisherInput");
var se_DescribeResourceScanInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RSI] != null) {
    entries[_RSI] = input[_RSI];
  }
  return entries;
}, "se_DescribeResourceScanInput");
var se_DescribeStackDriftDetectionStatusInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SDDI] != null) {
    entries[_SDDI] = input[_SDDI];
  }
  return entries;
}, "se_DescribeStackDriftDetectionStatusInput");
var se_DescribeStackEventsInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  return entries;
}, "se_DescribeStackEventsInput");
var se_DescribeStackInstanceInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_SIA] != null) {
    entries[_SIA] = input[_SIA];
  }
  if (input[_SIR] != null) {
    entries[_SIR] = input[_SIR];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  return entries;
}, "se_DescribeStackInstanceInput");
var se_DescribeStackResourceDriftsInput = /* @__PURE__ */ __name((input, context) => {
  var _a;
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_SRDSF] != null) {
    const memberEntries = se_StackResourceDriftStatusFilters(input[_SRDSF], context);
    if (((_a = input[_SRDSF]) == null ? void 0 : _a.length) === 0) {
      entries.StackResourceDriftStatusFilters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `StackResourceDriftStatusFilters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  return entries;
}, "se_DescribeStackResourceDriftsInput");
var se_DescribeStackResourceInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_LRI] != null) {
    entries[_LRI] = input[_LRI];
  }
  return entries;
}, "se_DescribeStackResourceInput");
var se_DescribeStackResourcesInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_LRI] != null) {
    entries[_LRI] = input[_LRI];
  }
  if (input[_PRI] != null) {
    entries[_PRI] = input[_PRI];
  }
  return entries;
}, "se_DescribeStackResourcesInput");
var se_DescribeStackSetInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  return entries;
}, "se_DescribeStackSetInput");
var se_DescribeStackSetOperationInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_OI] != null) {
    entries[_OI] = input[_OI];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  return entries;
}, "se_DescribeStackSetOperationInput");
var se_DescribeStacksInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  return entries;
}, "se_DescribeStacksInput");
var se_DescribeTypeInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_T] != null) {
    entries[_T] = input[_T];
  }
  if (input[_TN] != null) {
    entries[_TN] = input[_TN];
  }
  if (input[_Ar] != null) {
    entries[_Ar] = input[_Ar];
  }
  if (input[_VI] != null) {
    entries[_VI] = input[_VI];
  }
  if (input[_PI] != null) {
    entries[_PI] = input[_PI];
  }
  if (input[_PVN] != null) {
    entries[_PVN] = input[_PVN];
  }
  return entries;
}, "se_DescribeTypeInput");
var se_DescribeTypeRegistrationInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RTeg] != null) {
    entries[_RTeg] = input[_RTeg];
  }
  return entries;
}, "se_DescribeTypeRegistrationInput");
var se_DetectStackDriftInput = /* @__PURE__ */ __name((input, context) => {
  var _a;
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_LRIo] != null) {
    const memberEntries = se_LogicalResourceIds(input[_LRIo], context);
    if (((_a = input[_LRIo]) == null ? void 0 : _a.length) === 0) {
      entries.LogicalResourceIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `LogicalResourceIds.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_DetectStackDriftInput");
var se_DetectStackResourceDriftInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_LRI] != null) {
    entries[_LRI] = input[_LRI];
  }
  return entries;
}, "se_DetectStackResourceDriftInput");
var se_DetectStackSetDriftInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_OP] != null) {
    const memberEntries = se_StackSetOperationPreferences(input[_OP], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `OperationPreferences.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_OI] === void 0) {
    input[_OI] = (0, import_uuid.v4)();
  }
  if (input[_OI] != null) {
    entries[_OI] = input[_OI];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  return entries;
}, "se_DetectStackSetDriftInput");
var se_EstimateTemplateCostInput = /* @__PURE__ */ __name((input, context) => {
  var _a;
  const entries = {};
  if (input[_TB] != null) {
    entries[_TB] = input[_TB];
  }
  if (input[_TURL] != null) {
    entries[_TURL] = input[_TURL];
  }
  if (input[_P] != null) {
    const memberEntries = se_Parameters(input[_P], context);
    if (((_a = input[_P]) == null ? void 0 : _a.length) === 0) {
      entries.Parameters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Parameters.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_EstimateTemplateCostInput");
var se_ExecuteChangeSetInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_CSN] != null) {
    entries[_CSN] = input[_CSN];
  }
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_CRT] != null) {
    entries[_CRT] = input[_CRT];
  }
  if (input[_DR] != null) {
    entries[_DR] = input[_DR];
  }
  if (input[_REOC] != null) {
    entries[_REOC] = input[_REOC];
  }
  return entries;
}, "se_ExecuteChangeSetInput");
var se_GetGeneratedTemplateInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_F] != null) {
    entries[_F] = input[_F];
  }
  if (input[_GTN] != null) {
    entries[_GTN] = input[_GTN];
  }
  return entries;
}, "se_GetGeneratedTemplateInput");
var se_GetStackPolicyInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  return entries;
}, "se_GetStackPolicyInput");
var se_GetTemplateInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_CSN] != null) {
    entries[_CSN] = input[_CSN];
  }
  if (input[_TS] != null) {
    entries[_TS] = input[_TS];
  }
  return entries;
}, "se_GetTemplateInput");
var se_GetTemplateSummaryInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TB] != null) {
    entries[_TB] = input[_TB];
  }
  if (input[_TURL] != null) {
    entries[_TURL] = input[_TURL];
  }
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  if (input[_TSC] != null) {
    const memberEntries = se_TemplateSummaryConfig(input[_TSC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `TemplateSummaryConfig.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_GetTemplateSummaryInput");
var se_ImportStacksToStackSetInput = /* @__PURE__ */ __name((input, context) => {
  var _a, _b;
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_SIt] != null) {
    const memberEntries = se_StackIdList(input[_SIt], context);
    if (((_a = input[_SIt]) == null ? void 0 : _a.length) === 0) {
      entries.StackIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `StackIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_SIU] != null) {
    entries[_SIU] = input[_SIU];
  }
  if (input[_OUI] != null) {
    const memberEntries = se_OrganizationalUnitIdList(input[_OUI], context);
    if (((_b = input[_OUI]) == null ? void 0 : _b.length) === 0) {
      entries.OrganizationalUnitIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `OrganizationalUnitIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_OP] != null) {
    const memberEntries = se_StackSetOperationPreferences(input[_OP], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `OperationPreferences.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_OI] === void 0) {
    input[_OI] = (0, import_uuid.v4)();
  }
  if (input[_OI] != null) {
    entries[_OI] = input[_OI];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  return entries;
}, "se_ImportStacksToStackSetInput");
var se_JazzLogicalResourceIds = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_JazzLogicalResourceIds");
var se_JazzResourceIdentifierProperties = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  Object.keys(input).filter((key) => input[key] != null).forEach((key) => {
    entries[`entry.${counter}.key`] = key;
    entries[`entry.${counter}.value`] = input[key];
    counter++;
  });
  return entries;
}, "se_JazzResourceIdentifierProperties");
var se_ListChangeSetsInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  return entries;
}, "se_ListChangeSetsInput");
var se_ListExportsInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  return entries;
}, "se_ListExportsInput");
var se_ListGeneratedTemplatesInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  return entries;
}, "se_ListGeneratedTemplatesInput");
var se_ListImportsInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_EN] != null) {
    entries[_EN] = input[_EN];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  return entries;
}, "se_ListImportsInput");
var se_ListResourceScanRelatedResourcesInput = /* @__PURE__ */ __name((input, context) => {
  var _a;
  const entries = {};
  if (input[_RSI] != null) {
    entries[_RSI] = input[_RSI];
  }
  if (input[_R] != null) {
    const memberEntries = se_ScannedResourceIdentifiers(input[_R], context);
    if (((_a = input[_R]) == null ? void 0 : _a.length) === 0) {
      entries.Resources = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Resources.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  return entries;
}, "se_ListResourceScanRelatedResourcesInput");
var se_ListResourceScanResourcesInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RSI] != null) {
    entries[_RSI] = input[_RSI];
  }
  if (input[_RI] != null) {
    entries[_RI] = input[_RI];
  }
  if (input[_RTP] != null) {
    entries[_RTP] = input[_RTP];
  }
  if (input[_TK] != null) {
    entries[_TK] = input[_TK];
  }
  if (input[_TV] != null) {
    entries[_TV] = input[_TV];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  return entries;
}, "se_ListResourceScanResourcesInput");
var se_ListResourceScansInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  return entries;
}, "se_ListResourceScansInput");
var se_ListStackInstanceResourceDriftsInput = /* @__PURE__ */ __name((input, context) => {
  var _a;
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_SIRDS] != null) {
    const memberEntries = se_StackResourceDriftStatusFilters(input[_SIRDS], context);
    if (((_a = input[_SIRDS]) == null ? void 0 : _a.length) === 0) {
      entries.StackInstanceResourceDriftStatuses = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `StackInstanceResourceDriftStatuses.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_SIA] != null) {
    entries[_SIA] = input[_SIA];
  }
  if (input[_SIR] != null) {
    entries[_SIR] = input[_SIR];
  }
  if (input[_OI] != null) {
    entries[_OI] = input[_OI];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  return entries;
}, "se_ListStackInstanceResourceDriftsInput");
var se_ListStackInstancesInput = /* @__PURE__ */ __name((input, context) => {
  var _a;
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_StackInstanceFilters(input[_Fi], context);
    if (((_a = input[_Fi]) == null ? void 0 : _a.length) === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_SIA] != null) {
    entries[_SIA] = input[_SIA];
  }
  if (input[_SIR] != null) {
    entries[_SIR] = input[_SIR];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  return entries;
}, "se_ListStackInstancesInput");
var se_ListStackResourcesInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  return entries;
}, "se_ListStackResourcesInput");
var se_ListStackSetAutoDeploymentTargetsInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  return entries;
}, "se_ListStackSetAutoDeploymentTargetsInput");
var se_ListStackSetOperationResultsInput = /* @__PURE__ */ __name((input, context) => {
  var _a;
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_OI] != null) {
    entries[_OI] = input[_OI];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_OperationResultFilters(input[_Fi], context);
    if (((_a = input[_Fi]) == null ? void 0 : _a.length) === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ListStackSetOperationResultsInput");
var se_ListStackSetOperationsInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  return entries;
}, "se_ListStackSetOperationsInput");
var se_ListStackSetsInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_S] != null) {
    entries[_S] = input[_S];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  return entries;
}, "se_ListStackSetsInput");
var se_ListStacksInput = /* @__PURE__ */ __name((input, context) => {
  var _a;
  const entries = {};
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_SSF] != null) {
    const memberEntries = se_StackStatusFilter(input[_SSF], context);
    if (((_a = input[_SSF]) == null ? void 0 : _a.length) === 0) {
      entries.StackStatusFilter = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `StackStatusFilter.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ListStacksInput");
var se_ListTypeRegistrationsInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_T] != null) {
    entries[_T] = input[_T];
  }
  if (input[_TN] != null) {
    entries[_TN] = input[_TN];
  }
  if (input[_TA] != null) {
    entries[_TA] = input[_TA];
  }
  if (input[_RSF] != null) {
    entries[_RSF] = input[_RSF];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  return entries;
}, "se_ListTypeRegistrationsInput");
var se_ListTypesInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_Vi] != null) {
    entries[_Vi] = input[_Vi];
  }
  if (input[_PTr] != null) {
    entries[_PTr] = input[_PTr];
  }
  if (input[_DSep] != null) {
    entries[_DSep] = input[_DSep];
  }
  if (input[_T] != null) {
    entries[_T] = input[_T];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_TypeFilters(input[_Fi], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  return entries;
}, "se_ListTypesInput");
var se_ListTypeVersionsInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_T] != null) {
    entries[_T] = input[_T];
  }
  if (input[_TN] != null) {
    entries[_TN] = input[_TN];
  }
  if (input[_Ar] != null) {
    entries[_Ar] = input[_Ar];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_DSep] != null) {
    entries[_DSep] = input[_DSep];
  }
  if (input[_PI] != null) {
    entries[_PI] = input[_PI];
  }
  return entries;
}, "se_ListTypeVersionsInput");
var se_LoggingConfig = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_LRA] != null) {
    entries[_LRA] = input[_LRA];
  }
  if (input[_LGN] != null) {
    entries[_LGN] = input[_LGN];
  }
  return entries;
}, "se_LoggingConfig");
var se_LogicalResourceIds = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_LogicalResourceIds");
var se_ManagedExecution = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_Act] != null) {
    entries[_Act] = input[_Act];
  }
  return entries;
}, "se_ManagedExecution");
var se_NotificationARNs = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_NotificationARNs");
var se_OperationResultFilter = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_N] != null) {
    entries[_N] = input[_N];
  }
  if (input[_Va] != null) {
    entries[_Va] = input[_Va];
  }
  return entries;
}, "se_OperationResultFilter");
var se_OperationResultFilters = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_OperationResultFilter(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`member.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_OperationResultFilters");
var se_OrganizationalUnitIdList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_OrganizationalUnitIdList");
var se_Parameter = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_PK] != null) {
    entries[_PK] = input[_PK];
  }
  if (input[_PV] != null) {
    entries[_PV] = input[_PV];
  }
  if (input[_UPV] != null) {
    entries[_UPV] = input[_UPV];
  }
  if (input[_RV] != null) {
    entries[_RV] = input[_RV];
  }
  return entries;
}, "se_Parameter");
var se_Parameters = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_Parameter(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`member.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_Parameters");
var se_PublishTypeInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_T] != null) {
    entries[_T] = input[_T];
  }
  if (input[_Ar] != null) {
    entries[_Ar] = input[_Ar];
  }
  if (input[_TN] != null) {
    entries[_TN] = input[_TN];
  }
  if (input[_PVN] != null) {
    entries[_PVN] = input[_PVN];
  }
  return entries;
}, "se_PublishTypeInput");
var se_RecordHandlerProgressInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_BT] != null) {
    entries[_BT] = input[_BT];
  }
  if (input[_OS] != null) {
    entries[_OS] = input[_OS];
  }
  if (input[_COS] != null) {
    entries[_COS] = input[_COS];
  }
  if (input[_SM] != null) {
    entries[_SM] = input[_SM];
  }
  if (input[_EC] != null) {
    entries[_EC] = input[_EC];
  }
  if (input[_RM] != null) {
    entries[_RM] = input[_RM];
  }
  if (input[_CRT] != null) {
    entries[_CRT] = input[_CRT];
  }
  return entries;
}, "se_RecordHandlerProgressInput");
var se_RegionList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_RegionList");
var se_RegisterPublisherInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_ATAC] != null) {
    entries[_ATAC] = input[_ATAC];
  }
  if (input[_CAo] != null) {
    entries[_CAo] = input[_CAo];
  }
  return entries;
}, "se_RegisterPublisherInput");
var se_RegisterTypeInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_T] != null) {
    entries[_T] = input[_T];
  }
  if (input[_TN] != null) {
    entries[_TN] = input[_TN];
  }
  if (input[_SHP] != null) {
    entries[_SHP] = input[_SHP];
  }
  if (input[_LC] != null) {
    const memberEntries = se_LoggingConfig(input[_LC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `LoggingConfig.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_ERA] != null) {
    entries[_ERA] = input[_ERA];
  }
  if (input[_CRT] != null) {
    entries[_CRT] = input[_CRT];
  }
  return entries;
}, "se_RegisterTypeInput");
var se_ResourceDefinition = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RTes] != null) {
    entries[_RTes] = input[_RTes];
  }
  if (input[_LRI] != null) {
    entries[_LRI] = input[_LRI];
  }
  if (input[_RI] != null) {
    const memberEntries = se_ResourceIdentifierProperties(input[_RI], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ResourceIdentifier.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ResourceDefinition");
var se_ResourceDefinitions = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_ResourceDefinition(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`member.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_ResourceDefinitions");
var se_ResourceIdentifierProperties = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  Object.keys(input).filter((key) => input[key] != null).forEach((key) => {
    entries[`entry.${counter}.key`] = key;
    entries[`entry.${counter}.value`] = input[key];
    counter++;
  });
  return entries;
}, "se_ResourceIdentifierProperties");
var se_ResourcesToImport = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_ResourceToImport(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`member.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_ResourcesToImport");
var se_ResourcesToSkip = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_ResourcesToSkip");
var se_ResourceToImport = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RTes] != null) {
    entries[_RTes] = input[_RTes];
  }
  if (input[_LRI] != null) {
    entries[_LRI] = input[_LRI];
  }
  if (input[_RI] != null) {
    const memberEntries = se_ResourceIdentifierProperties(input[_RI], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ResourceIdentifier.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ResourceToImport");
var se_ResourceTypes = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_ResourceTypes");
var se_RetainResources = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_RetainResources");
var se_RollbackConfiguration = /* @__PURE__ */ __name((input, context) => {
  var _a;
  const entries = {};
  if (input[_RTo] != null) {
    const memberEntries = se_RollbackTriggers(input[_RTo], context);
    if (((_a = input[_RTo]) == null ? void 0 : _a.length) === 0) {
      entries.RollbackTriggers = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `RollbackTriggers.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MTIM] != null) {
    entries[_MTIM] = input[_MTIM];
  }
  return entries;
}, "se_RollbackConfiguration");
var se_RollbackStackInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_RARN] != null) {
    entries[_RARN] = input[_RARN];
  }
  if (input[_CRT] != null) {
    entries[_CRT] = input[_CRT];
  }
  if (input[_REOC] != null) {
    entries[_REOC] = input[_REOC];
  }
  return entries;
}, "se_RollbackStackInput");
var se_RollbackTrigger = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_Ar] != null) {
    entries[_Ar] = input[_Ar];
  }
  if (input[_T] != null) {
    entries[_T] = input[_T];
  }
  return entries;
}, "se_RollbackTrigger");
var se_RollbackTriggers = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_RollbackTrigger(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`member.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_RollbackTriggers");
var se_ScannedResourceIdentifier = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RTes] != null) {
    entries[_RTes] = input[_RTes];
  }
  if (input[_RI] != null) {
    const memberEntries = se_JazzResourceIdentifierProperties(input[_RI], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ResourceIdentifier.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ScannedResourceIdentifier");
var se_ScannedResourceIdentifiers = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_ScannedResourceIdentifier(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`member.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_ScannedResourceIdentifiers");
var se_SetStackPolicyInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_SPB] != null) {
    entries[_SPB] = input[_SPB];
  }
  if (input[_SPURL] != null) {
    entries[_SPURL] = input[_SPURL];
  }
  return entries;
}, "se_SetStackPolicyInput");
var se_SetTypeConfigurationInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TA] != null) {
    entries[_TA] = input[_TA];
  }
  if (input[_Co] != null) {
    entries[_Co] = input[_Co];
  }
  if (input[_CAon] != null) {
    entries[_CAon] = input[_CAon];
  }
  if (input[_TN] != null) {
    entries[_TN] = input[_TN];
  }
  if (input[_T] != null) {
    entries[_T] = input[_T];
  }
  return entries;
}, "se_SetTypeConfigurationInput");
var se_SetTypeDefaultVersionInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_Ar] != null) {
    entries[_Ar] = input[_Ar];
  }
  if (input[_T] != null) {
    entries[_T] = input[_T];
  }
  if (input[_TN] != null) {
    entries[_TN] = input[_TN];
  }
  if (input[_VI] != null) {
    entries[_VI] = input[_VI];
  }
  return entries;
}, "se_SetTypeDefaultVersionInput");
var se_SignalResourceInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_LRI] != null) {
    entries[_LRI] = input[_LRI];
  }
  if (input[_UI] != null) {
    entries[_UI] = input[_UI];
  }
  if (input[_S] != null) {
    entries[_S] = input[_S];
  }
  return entries;
}, "se_SignalResourceInput");
var se_StackIdList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_StackIdList");
var se_StackInstanceFilter = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_N] != null) {
    entries[_N] = input[_N];
  }
  if (input[_Va] != null) {
    entries[_Va] = input[_Va];
  }
  return entries;
}, "se_StackInstanceFilter");
var se_StackInstanceFilters = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_StackInstanceFilter(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`member.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_StackInstanceFilters");
var se_StackResourceDriftStatusFilters = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_StackResourceDriftStatusFilters");
var se_StackSetOperationPreferences = /* @__PURE__ */ __name((input, context) => {
  var _a;
  const entries = {};
  if (input[_RCT] != null) {
    entries[_RCT] = input[_RCT];
  }
  if (input[_RO] != null) {
    const memberEntries = se_RegionList(input[_RO], context);
    if (((_a = input[_RO]) == null ? void 0 : _a.length) === 0) {
      entries.RegionOrder = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `RegionOrder.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_FTC] != null) {
    entries[_FTC] = input[_FTC];
  }
  if (input[_FTP] != null) {
    entries[_FTP] = input[_FTP];
  }
  if (input[_MCC] != null) {
    entries[_MCC] = input[_MCC];
  }
  if (input[_MCP] != null) {
    entries[_MCP] = input[_MCP];
  }
  if (input[_CM] != null) {
    entries[_CM] = input[_CM];
  }
  return entries;
}, "se_StackSetOperationPreferences");
var se_StackStatusFilter = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_StackStatusFilter");
var se_StartResourceScanInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_CRT] != null) {
    entries[_CRT] = input[_CRT];
  }
  return entries;
}, "se_StartResourceScanInput");
var se_StopStackSetOperationInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_OI] != null) {
    entries[_OI] = input[_OI];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  return entries;
}, "se_StopStackSetOperationInput");
var se_Tag = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_K] != null) {
    entries[_K] = input[_K];
  }
  if (input[_Val] != null) {
    entries[_Val] = input[_Val];
  }
  return entries;
}, "se_Tag");
var se_Tags = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_Tag(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`member.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_Tags");
var se_TemplateConfiguration = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DPe] != null) {
    entries[_DPe] = input[_DPe];
  }
  if (input[_URP] != null) {
    entries[_URP] = input[_URP];
  }
  return entries;
}, "se_TemplateConfiguration");
var se_TemplateSummaryConfig = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TURTAW] != null) {
    entries[_TURTAW] = input[_TURTAW];
  }
  return entries;
}, "se_TemplateSummaryConfig");
var se_TestTypeInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_Ar] != null) {
    entries[_Ar] = input[_Ar];
  }
  if (input[_T] != null) {
    entries[_T] = input[_T];
  }
  if (input[_TN] != null) {
    entries[_TN] = input[_TN];
  }
  if (input[_VI] != null) {
    entries[_VI] = input[_VI];
  }
  if (input[_LDB] != null) {
    entries[_LDB] = input[_LDB];
  }
  return entries;
}, "se_TestTypeInput");
var se_TypeConfigurationIdentifier = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TA] != null) {
    entries[_TA] = input[_TA];
  }
  if (input[_TCA] != null) {
    entries[_TCA] = input[_TCA];
  }
  if (input[_TCAy] != null) {
    entries[_TCAy] = input[_TCAy];
  }
  if (input[_T] != null) {
    entries[_T] = input[_T];
  }
  if (input[_TN] != null) {
    entries[_TN] = input[_TN];
  }
  return entries;
}, "se_TypeConfigurationIdentifier");
var se_TypeConfigurationIdentifiers = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_TypeConfigurationIdentifier(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`member.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_TypeConfigurationIdentifiers");
var se_TypeFilters = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_Ca] != null) {
    entries[_Ca] = input[_Ca];
  }
  if (input[_PI] != null) {
    entries[_PI] = input[_PI];
  }
  if (input[_TNP] != null) {
    entries[_TNP] = input[_TNP];
  }
  return entries;
}, "se_TypeFilters");
var se_UpdateGeneratedTemplateInput = /* @__PURE__ */ __name((input, context) => {
  var _a, _b;
  const entries = {};
  if (input[_GTN] != null) {
    entries[_GTN] = input[_GTN];
  }
  if (input[_NGTN] != null) {
    entries[_NGTN] = input[_NGTN];
  }
  if (input[_AR] != null) {
    const memberEntries = se_ResourceDefinitions(input[_AR], context);
    if (((_a = input[_AR]) == null ? void 0 : _a.length) === 0) {
      entries.AddResources = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `AddResources.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_RRe] != null) {
    const memberEntries = se_JazzLogicalResourceIds(input[_RRe], context);
    if (((_b = input[_RRe]) == null ? void 0 : _b.length) === 0) {
      entries.RemoveResources = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `RemoveResources.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_RAR] != null) {
    entries[_RAR] = input[_RAR];
  }
  if (input[_TC] != null) {
    const memberEntries = se_TemplateConfiguration(input[_TC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `TemplateConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_UpdateGeneratedTemplateInput");
var se_UpdateStackInput = /* @__PURE__ */ __name((input, context) => {
  var _a, _b, _c, _d, _e2;
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_TB] != null) {
    entries[_TB] = input[_TB];
  }
  if (input[_TURL] != null) {
    entries[_TURL] = input[_TURL];
  }
  if (input[_UPT] != null) {
    entries[_UPT] = input[_UPT];
  }
  if (input[_SPDUB] != null) {
    entries[_SPDUB] = input[_SPDUB];
  }
  if (input[_SPDUURL] != null) {
    entries[_SPDUURL] = input[_SPDUURL];
  }
  if (input[_P] != null) {
    const memberEntries = se_Parameters(input[_P], context);
    if (((_a = input[_P]) == null ? void 0 : _a.length) === 0) {
      entries.Parameters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Parameters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_C] != null) {
    const memberEntries = se_Capabilities(input[_C], context);
    if (((_b = input[_C]) == null ? void 0 : _b.length) === 0) {
      entries.Capabilities = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Capabilities.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_RTe] != null) {
    const memberEntries = se_ResourceTypes(input[_RTe], context);
    if (((_c = input[_RTe]) == null ? void 0 : _c.length) === 0) {
      entries.ResourceTypes = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ResourceTypes.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_RARN] != null) {
    entries[_RARN] = input[_RARN];
  }
  if (input[_RC] != null) {
    const memberEntries = se_RollbackConfiguration(input[_RC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `RollbackConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_SPB] != null) {
    entries[_SPB] = input[_SPB];
  }
  if (input[_SPURL] != null) {
    entries[_SPURL] = input[_SPURL];
  }
  if (input[_NARN] != null) {
    const memberEntries = se_NotificationARNs(input[_NARN], context);
    if (((_d = input[_NARN]) == null ? void 0 : _d.length) === 0) {
      entries.NotificationARNs = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `NotificationARNs.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Ta] != null) {
    const memberEntries = se_Tags(input[_Ta], context);
    if (((_e2 = input[_Ta]) == null ? void 0 : _e2.length) === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DR] != null) {
    entries[_DR] = input[_DR];
  }
  if (input[_CRT] != null) {
    entries[_CRT] = input[_CRT];
  }
  if (input[_REOC] != null) {
    entries[_REOC] = input[_REOC];
  }
  return entries;
}, "se_UpdateStackInput");
var se_UpdateStackInstancesInput = /* @__PURE__ */ __name((input, context) => {
  var _a, _b, _c;
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_Ac] != null) {
    const memberEntries = se_AccountList(input[_Ac], context);
    if (((_a = input[_Ac]) == null ? void 0 : _a.length) === 0) {
      entries.Accounts = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Accounts.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DTep] != null) {
    const memberEntries = se_DeploymentTargets(input[_DTep], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DeploymentTargets.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Re] != null) {
    const memberEntries = se_RegionList(input[_Re], context);
    if (((_b = input[_Re]) == null ? void 0 : _b.length) === 0) {
      entries.Regions = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Regions.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_PO] != null) {
    const memberEntries = se_Parameters(input[_PO], context);
    if (((_c = input[_PO]) == null ? void 0 : _c.length) === 0) {
      entries.ParameterOverrides = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ParameterOverrides.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_OP] != null) {
    const memberEntries = se_StackSetOperationPreferences(input[_OP], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `OperationPreferences.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_OI] === void 0) {
    input[_OI] = (0, import_uuid.v4)();
  }
  if (input[_OI] != null) {
    entries[_OI] = input[_OI];
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  return entries;
}, "se_UpdateStackInstancesInput");
var se_UpdateStackSetInput = /* @__PURE__ */ __name((input, context) => {
  var _a, _b, _c, _d, _e2;
  const entries = {};
  if (input[_SSN] != null) {
    entries[_SSN] = input[_SSN];
  }
  if (input[_D] != null) {
    entries[_D] = input[_D];
  }
  if (input[_TB] != null) {
    entries[_TB] = input[_TB];
  }
  if (input[_TURL] != null) {
    entries[_TURL] = input[_TURL];
  }
  if (input[_UPT] != null) {
    entries[_UPT] = input[_UPT];
  }
  if (input[_P] != null) {
    const memberEntries = se_Parameters(input[_P], context);
    if (((_a = input[_P]) == null ? void 0 : _a.length) === 0) {
      entries.Parameters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Parameters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_C] != null) {
    const memberEntries = se_Capabilities(input[_C], context);
    if (((_b = input[_C]) == null ? void 0 : _b.length) === 0) {
      entries.Capabilities = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Capabilities.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Ta] != null) {
    const memberEntries = se_Tags(input[_Ta], context);
    if (((_c = input[_Ta]) == null ? void 0 : _c.length) === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_OP] != null) {
    const memberEntries = se_StackSetOperationPreferences(input[_OP], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `OperationPreferences.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_ARARN] != null) {
    entries[_ARARN] = input[_ARARN];
  }
  if (input[_ERN] != null) {
    entries[_ERN] = input[_ERN];
  }
  if (input[_DTep] != null) {
    const memberEntries = se_DeploymentTargets(input[_DTep], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DeploymentTargets.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_PM] != null) {
    entries[_PM] = input[_PM];
  }
  if (input[_AD] != null) {
    const memberEntries = se_AutoDeployment(input[_AD], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `AutoDeployment.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_OI] === void 0) {
    input[_OI] = (0, import_uuid.v4)();
  }
  if (input[_OI] != null) {
    entries[_OI] = input[_OI];
  }
  if (input[_Ac] != null) {
    const memberEntries = se_AccountList(input[_Ac], context);
    if (((_d = input[_Ac]) == null ? void 0 : _d.length) === 0) {
      entries.Accounts = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Accounts.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Re] != null) {
    const memberEntries = se_RegionList(input[_Re], context);
    if (((_e2 = input[_Re]) == null ? void 0 : _e2.length) === 0) {
      entries.Regions = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Regions.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_CA] != null) {
    entries[_CA] = input[_CA];
  }
  if (input[_ME] != null) {
    const memberEntries = se_ManagedExecution(input[_ME], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ManagedExecution.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_UpdateStackSetInput");
var se_UpdateTerminationProtectionInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_ETP] != null) {
    entries[_ETP] = input[_ETP];
  }
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  return entries;
}, "se_UpdateTerminationProtectionInput");
var se_ValidateTemplateInput = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TB] != null) {
    entries[_TB] = input[_TB];
  }
  if (input[_TURL] != null) {
    entries[_TURL] = input[_TURL];
  }
  return entries;
}, "se_ValidateTemplateInput");
var de_AccountGateResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_SRt] != null) {
    contents[_SRt] = (0, import_smithy_client.expectString)(output[_SRt]);
  }
  return contents;
}, "de_AccountGateResult");
var de_AccountLimit = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_Val] != null) {
    contents[_Val] = (0, import_smithy_client.strictParseInt32)(output[_Val]);
  }
  return contents;
}, "de_AccountLimit");
var de_AccountLimitList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_AccountLimit(entry, context);
  });
}, "de_AccountLimitList");
var de_AccountList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_AccountList");
var de_ActivateOrganizationsAccessOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_ActivateOrganizationsAccessOutput");
var de_ActivateTypeOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  return contents;
}, "de_ActivateTypeOutput");
var de_AllowedValues = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_AllowedValues");
var de_AlreadyExistsException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_AlreadyExistsException");
var de_AutoDeployment = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.parseBoolean)(output[_E]);
  }
  if (output[_RSOAR] != null) {
    contents[_RSOAR] = (0, import_smithy_client.parseBoolean)(output[_RSOAR]);
  }
  return contents;
}, "de_AutoDeployment");
var de_BatchDescribeTypeConfigurationsError = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_EC] != null) {
    contents[_EC] = (0, import_smithy_client.expectString)(output[_EC]);
  }
  if (output[_EM] != null) {
    contents[_EM] = (0, import_smithy_client.expectString)(output[_EM]);
  }
  if (output[_TCIy] != null) {
    contents[_TCIy] = de_TypeConfigurationIdentifier(output[_TCIy], context);
  }
  return contents;
}, "de_BatchDescribeTypeConfigurationsError");
var de_BatchDescribeTypeConfigurationsErrors = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_BatchDescribeTypeConfigurationsError(entry, context);
  });
}, "de_BatchDescribeTypeConfigurationsErrors");
var de_BatchDescribeTypeConfigurationsOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Errors === "") {
    contents[_Er] = [];
  } else if (output[_Er] != null && output[_Er][_m] != null) {
    contents[_Er] = de_BatchDescribeTypeConfigurationsErrors((0, import_smithy_client.getArrayIfSingleItem)(output[_Er][_m]), context);
  }
  if (output.UnprocessedTypeConfigurations === "") {
    contents[_UTC] = [];
  } else if (output[_UTC] != null && output[_UTC][_m] != null) {
    contents[_UTC] = de_UnprocessedTypeConfigurations((0, import_smithy_client.getArrayIfSingleItem)(output[_UTC][_m]), context);
  }
  if (output.TypeConfigurations === "") {
    contents[_TCy] = [];
  } else if (output[_TCy] != null && output[_TCy][_m] != null) {
    contents[_TCy] = de_TypeConfigurationDetailsList((0, import_smithy_client.getArrayIfSingleItem)(output[_TCy][_m]), context);
  }
  return contents;
}, "de_BatchDescribeTypeConfigurationsOutput");
var de_Capabilities = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_Capabilities");
var de_CFNRegistryException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_CFNRegistryException");
var de_Change = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_T] != null) {
    contents[_T] = (0, import_smithy_client.expectString)(output[_T]);
  }
  if (output[_HIC] != null) {
    contents[_HIC] = (0, import_smithy_client.strictParseInt32)(output[_HIC]);
  }
  if (output[_RCe] != null) {
    contents[_RCe] = de_ResourceChange(output[_RCe], context);
  }
  return contents;
}, "de_Change");
var de_Changes = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Change(entry, context);
  });
}, "de_Changes");
var de_ChangeSetHook = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_IP] != null) {
    contents[_IP] = (0, import_smithy_client.expectString)(output[_IP]);
  }
  if (output[_FM] != null) {
    contents[_FM] = (0, import_smithy_client.expectString)(output[_FM]);
  }
  if (output[_TN] != null) {
    contents[_TN] = (0, import_smithy_client.expectString)(output[_TN]);
  }
  if (output[_TVI] != null) {
    contents[_TVI] = (0, import_smithy_client.expectString)(output[_TVI]);
  }
  if (output[_TCVI] != null) {
    contents[_TCVI] = (0, import_smithy_client.expectString)(output[_TCVI]);
  }
  if (output[_TD] != null) {
    contents[_TD] = de_ChangeSetHookTargetDetails(output[_TD], context);
  }
  return contents;
}, "de_ChangeSetHook");
var de_ChangeSetHookResourceTargetDetails = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_LRI] != null) {
    contents[_LRI] = (0, import_smithy_client.expectString)(output[_LRI]);
  }
  if (output[_RTes] != null) {
    contents[_RTes] = (0, import_smithy_client.expectString)(output[_RTes]);
  }
  if (output[_RA] != null) {
    contents[_RA] = (0, import_smithy_client.expectString)(output[_RA]);
  }
  return contents;
}, "de_ChangeSetHookResourceTargetDetails");
var de_ChangeSetHooks = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ChangeSetHook(entry, context);
  });
}, "de_ChangeSetHooks");
var de_ChangeSetHookTargetDetails = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_TTa] != null) {
    contents[_TTa] = (0, import_smithy_client.expectString)(output[_TTa]);
  }
  if (output[_RTD] != null) {
    contents[_RTD] = de_ChangeSetHookResourceTargetDetails(output[_RTD], context);
  }
  return contents;
}, "de_ChangeSetHookTargetDetails");
var de_ChangeSetNotFoundException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_ChangeSetNotFoundException");
var de_ChangeSetSummaries = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ChangeSetSummary(entry, context);
  });
}, "de_ChangeSetSummaries");
var de_ChangeSetSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  if (output[_SN] != null) {
    contents[_SN] = (0, import_smithy_client.expectString)(output[_SN]);
  }
  if (output[_CSIh] != null) {
    contents[_CSIh] = (0, import_smithy_client.expectString)(output[_CSIh]);
  }
  if (output[_CSN] != null) {
    contents[_CSN] = (0, import_smithy_client.expectString)(output[_CSN]);
  }
  if (output[_ES] != null) {
    contents[_ES] = (0, import_smithy_client.expectString)(output[_ES]);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_SRt] != null) {
    contents[_SRt] = (0, import_smithy_client.expectString)(output[_SRt]);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_INS] != null) {
    contents[_INS] = (0, import_smithy_client.parseBoolean)(output[_INS]);
  }
  if (output[_PCSI] != null) {
    contents[_PCSI] = (0, import_smithy_client.expectString)(output[_PCSI]);
  }
  if (output[_RCSI] != null) {
    contents[_RCSI] = (0, import_smithy_client.expectString)(output[_RCSI]);
  }
  if (output[_IER] != null) {
    contents[_IER] = (0, import_smithy_client.parseBoolean)(output[_IER]);
  }
  return contents;
}, "de_ChangeSetSummary");
var de_ConcurrentResourcesLimitExceededException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_ConcurrentResourcesLimitExceededException");
var de_ContinueUpdateRollbackOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_ContinueUpdateRollbackOutput");
var de_CreateChangeSetOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_I] != null) {
    contents[_I] = (0, import_smithy_client.expectString)(output[_I]);
  }
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  return contents;
}, "de_CreateChangeSetOutput");
var de_CreatedButModifiedException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_CreatedButModifiedException");
var de_CreateGeneratedTemplateOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_GTI] != null) {
    contents[_GTI] = (0, import_smithy_client.expectString)(output[_GTI]);
  }
  return contents;
}, "de_CreateGeneratedTemplateOutput");
var de_CreateStackInstancesOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OI] != null) {
    contents[_OI] = (0, import_smithy_client.expectString)(output[_OI]);
  }
  return contents;
}, "de_CreateStackInstancesOutput");
var de_CreateStackOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  return contents;
}, "de_CreateStackOutput");
var de_CreateStackSetOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SSI] != null) {
    contents[_SSI] = (0, import_smithy_client.expectString)(output[_SSI]);
  }
  return contents;
}, "de_CreateStackSetOutput");
var de_DeactivateOrganizationsAccessOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_DeactivateOrganizationsAccessOutput");
var de_DeactivateTypeOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_DeactivateTypeOutput");
var de_DeleteChangeSetOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_DeleteChangeSetOutput");
var de_DeleteStackInstancesOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OI] != null) {
    contents[_OI] = (0, import_smithy_client.expectString)(output[_OI]);
  }
  return contents;
}, "de_DeleteStackInstancesOutput");
var de_DeleteStackSetOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_DeleteStackSetOutput");
var de_DeploymentTargets = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Accounts === "") {
    contents[_Ac] = [];
  } else if (output[_Ac] != null && output[_Ac][_m] != null) {
    contents[_Ac] = de_AccountList((0, import_smithy_client.getArrayIfSingleItem)(output[_Ac][_m]), context);
  }
  if (output[_AUc] != null) {
    contents[_AUc] = (0, import_smithy_client.expectString)(output[_AUc]);
  }
  if (output.OrganizationalUnitIds === "") {
    contents[_OUI] = [];
  } else if (output[_OUI] != null && output[_OUI][_m] != null) {
    contents[_OUI] = de_OrganizationalUnitIdList((0, import_smithy_client.getArrayIfSingleItem)(output[_OUI][_m]), context);
  }
  if (output[_AFT] != null) {
    contents[_AFT] = (0, import_smithy_client.expectString)(output[_AFT]);
  }
  return contents;
}, "de_DeploymentTargets");
var de_DeregisterTypeOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_DeregisterTypeOutput");
var de_DescribeAccountLimitsOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.AccountLimits === "") {
    contents[_AL] = [];
  } else if (output[_AL] != null && output[_AL][_m] != null) {
    contents[_AL] = de_AccountLimitList((0, import_smithy_client.getArrayIfSingleItem)(output[_AL][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_DescribeAccountLimitsOutput");
var de_DescribeChangeSetHooksOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CSIh] != null) {
    contents[_CSIh] = (0, import_smithy_client.expectString)(output[_CSIh]);
  }
  if (output[_CSN] != null) {
    contents[_CSN] = (0, import_smithy_client.expectString)(output[_CSN]);
  }
  if (output.Hooks === "") {
    contents[_H] = [];
  } else if (output[_H] != null && output[_H][_m] != null) {
    contents[_H] = de_ChangeSetHooks((0, import_smithy_client.getArrayIfSingleItem)(output[_H][_m]), context);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  if (output[_SN] != null) {
    contents[_SN] = (0, import_smithy_client.expectString)(output[_SN]);
  }
  return contents;
}, "de_DescribeChangeSetHooksOutput");
var de_DescribeChangeSetOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CSN] != null) {
    contents[_CSN] = (0, import_smithy_client.expectString)(output[_CSN]);
  }
  if (output[_CSIh] != null) {
    contents[_CSIh] = (0, import_smithy_client.expectString)(output[_CSIh]);
  }
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  if (output[_SN] != null) {
    contents[_SN] = (0, import_smithy_client.expectString)(output[_SN]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output.Parameters === "") {
    contents[_P] = [];
  } else if (output[_P] != null && output[_P][_m] != null) {
    contents[_P] = de_Parameters((0, import_smithy_client.getArrayIfSingleItem)(output[_P][_m]), context);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output[_ES] != null) {
    contents[_ES] = (0, import_smithy_client.expectString)(output[_ES]);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_SRt] != null) {
    contents[_SRt] = (0, import_smithy_client.expectString)(output[_SRt]);
  }
  if (output.NotificationARNs === "") {
    contents[_NARN] = [];
  } else if (output[_NARN] != null && output[_NARN][_m] != null) {
    contents[_NARN] = de_NotificationARNs((0, import_smithy_client.getArrayIfSingleItem)(output[_NARN][_m]), context);
  }
  if (output[_RC] != null) {
    contents[_RC] = de_RollbackConfiguration(output[_RC], context);
  }
  if (output.Capabilities === "") {
    contents[_C] = [];
  } else if (output[_C] != null && output[_C][_m] != null) {
    contents[_C] = de_Capabilities((0, import_smithy_client.getArrayIfSingleItem)(output[_C][_m]), context);
  }
  if (output.Tags === "") {
    contents[_Ta] = [];
  } else if (output[_Ta] != null && output[_Ta][_m] != null) {
    contents[_Ta] = de_Tags((0, import_smithy_client.getArrayIfSingleItem)(output[_Ta][_m]), context);
  }
  if (output.Changes === "") {
    contents[_Ch] = [];
  } else if (output[_Ch] != null && output[_Ch][_m] != null) {
    contents[_Ch] = de_Changes((0, import_smithy_client.getArrayIfSingleItem)(output[_Ch][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  if (output[_INS] != null) {
    contents[_INS] = (0, import_smithy_client.parseBoolean)(output[_INS]);
  }
  if (output[_PCSI] != null) {
    contents[_PCSI] = (0, import_smithy_client.expectString)(output[_PCSI]);
  }
  if (output[_RCSI] != null) {
    contents[_RCSI] = (0, import_smithy_client.expectString)(output[_RCSI]);
  }
  if (output[_OSF] != null) {
    contents[_OSF] = (0, import_smithy_client.expectString)(output[_OSF]);
  }
  if (output[_IER] != null) {
    contents[_IER] = (0, import_smithy_client.parseBoolean)(output[_IER]);
  }
  return contents;
}, "de_DescribeChangeSetOutput");
var de_DescribeGeneratedTemplateOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_GTI] != null) {
    contents[_GTI] = (0, import_smithy_client.expectString)(output[_GTI]);
  }
  if (output[_GTN] != null) {
    contents[_GTN] = (0, import_smithy_client.expectString)(output[_GTN]);
  }
  if (output.Resources === "") {
    contents[_R] = [];
  } else if (output[_R] != null && output[_R][_m] != null) {
    contents[_R] = de_ResourceDetails((0, import_smithy_client.getArrayIfSingleItem)(output[_R][_m]), context);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_SRt] != null) {
    contents[_SRt] = (0, import_smithy_client.expectString)(output[_SRt]);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output[_LUT] != null) {
    contents[_LUT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LUT]));
  }
  if (output[_Pr] != null) {
    contents[_Pr] = de_TemplateProgress(output[_Pr], context);
  }
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  if (output[_TC] != null) {
    contents[_TC] = de_TemplateConfiguration(output[_TC], context);
  }
  if (output[_TW] != null) {
    contents[_TW] = (0, import_smithy_client.strictParseInt32)(output[_TW]);
  }
  return contents;
}, "de_DescribeGeneratedTemplateOutput");
var de_DescribeOrganizationsAccessOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  return contents;
}, "de_DescribeOrganizationsAccessOutput");
var de_DescribePublisherOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PI] != null) {
    contents[_PI] = (0, import_smithy_client.expectString)(output[_PI]);
  }
  if (output[_PS] != null) {
    contents[_PS] = (0, import_smithy_client.expectString)(output[_PS]);
  }
  if (output[_IPd] != null) {
    contents[_IPd] = (0, import_smithy_client.expectString)(output[_IPd]);
  }
  if (output[_PP] != null) {
    contents[_PP] = (0, import_smithy_client.expectString)(output[_PP]);
  }
  return contents;
}, "de_DescribePublisherOutput");
var de_DescribeResourceScanOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RSI] != null) {
    contents[_RSI] = (0, import_smithy_client.expectString)(output[_RSI]);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_SRt] != null) {
    contents[_SRt] = (0, import_smithy_client.expectString)(output[_SRt]);
  }
  if (output[_ST] != null) {
    contents[_ST] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_ST]));
  }
  if (output[_ET] != null) {
    contents[_ET] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_ET]));
  }
  if (output[_PC] != null) {
    contents[_PC] = (0, import_smithy_client.strictParseFloat)(output[_PC]);
  }
  if (output.ResourceTypes === "") {
    contents[_RTe] = [];
  } else if (output[_RTe] != null && output[_RTe][_m] != null) {
    contents[_RTe] = de_ResourceTypes((0, import_smithy_client.getArrayIfSingleItem)(output[_RTe][_m]), context);
  }
  if (output[_RSes] != null) {
    contents[_RSes] = (0, import_smithy_client.strictParseInt32)(output[_RSes]);
  }
  if (output[_RRes] != null) {
    contents[_RRes] = (0, import_smithy_client.strictParseInt32)(output[_RRes]);
  }
  return contents;
}, "de_DescribeResourceScanOutput");
var de_DescribeStackDriftDetectionStatusOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  if (output[_SDDI] != null) {
    contents[_SDDI] = (0, import_smithy_client.expectString)(output[_SDDI]);
  }
  if (output[_SDS] != null) {
    contents[_SDS] = (0, import_smithy_client.expectString)(output[_SDS]);
  }
  if (output[_DSet] != null) {
    contents[_DSet] = (0, import_smithy_client.expectString)(output[_DSet]);
  }
  if (output[_DSRet] != null) {
    contents[_DSRet] = (0, import_smithy_client.expectString)(output[_DSRet]);
  }
  if (output[_DSRC] != null) {
    contents[_DSRC] = (0, import_smithy_client.strictParseInt32)(output[_DSRC]);
  }
  if (output[_Ti] != null) {
    contents[_Ti] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_Ti]));
  }
  return contents;
}, "de_DescribeStackDriftDetectionStatusOutput");
var de_DescribeStackEventsOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.StackEvents === "") {
    contents[_SE] = [];
  } else if (output[_SE] != null && output[_SE][_m] != null) {
    contents[_SE] = de_StackEvents((0, import_smithy_client.getArrayIfSingleItem)(output[_SE][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_DescribeStackEventsOutput");
var de_DescribeStackInstanceOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SIta] != null) {
    contents[_SIta] = de_StackInstance(output[_SIta], context);
  }
  return contents;
}, "de_DescribeStackInstanceOutput");
var de_DescribeStackResourceDriftsOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.StackResourceDrifts === "") {
    contents[_SRD] = [];
  } else if (output[_SRD] != null && output[_SRD][_m] != null) {
    contents[_SRD] = de_StackResourceDrifts((0, import_smithy_client.getArrayIfSingleItem)(output[_SRD][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_DescribeStackResourceDriftsOutput");
var de_DescribeStackResourceOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SRDt] != null) {
    contents[_SRDt] = de_StackResourceDetail(output[_SRDt], context);
  }
  return contents;
}, "de_DescribeStackResourceOutput");
var de_DescribeStackResourcesOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.StackResources === "") {
    contents[_SRta] = [];
  } else if (output[_SRta] != null && output[_SRta][_m] != null) {
    contents[_SRta] = de_StackResources((0, import_smithy_client.getArrayIfSingleItem)(output[_SRta][_m]), context);
  }
  return contents;
}, "de_DescribeStackResourcesOutput");
var de_DescribeStackSetOperationOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SSO] != null) {
    contents[_SSO] = de_StackSetOperation(output[_SSO], context);
  }
  return contents;
}, "de_DescribeStackSetOperationOutput");
var de_DescribeStackSetOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SS] != null) {
    contents[_SS] = de_StackSet(output[_SS], context);
  }
  return contents;
}, "de_DescribeStackSetOutput");
var de_DescribeStacksOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Stacks === "") {
    contents[_St] = [];
  } else if (output[_St] != null && output[_St][_m] != null) {
    contents[_St] = de_Stacks((0, import_smithy_client.getArrayIfSingleItem)(output[_St][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_DescribeStacksOutput");
var de_DescribeTypeOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  if (output[_T] != null) {
    contents[_T] = (0, import_smithy_client.expectString)(output[_T]);
  }
  if (output[_TN] != null) {
    contents[_TN] = (0, import_smithy_client.expectString)(output[_TN]);
  }
  if (output[_DVI] != null) {
    contents[_DVI] = (0, import_smithy_client.expectString)(output[_DVI]);
  }
  if (output[_IDV] != null) {
    contents[_IDV] = (0, import_smithy_client.parseBoolean)(output[_IDV]);
  }
  if (output[_TTS] != null) {
    contents[_TTS] = (0, import_smithy_client.expectString)(output[_TTS]);
  }
  if (output[_TTSD] != null) {
    contents[_TTSD] = (0, import_smithy_client.expectString)(output[_TTSD]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_Sc] != null) {
    contents[_Sc] = (0, import_smithy_client.expectString)(output[_Sc]);
  }
  if (output[_PTr] != null) {
    contents[_PTr] = (0, import_smithy_client.expectString)(output[_PTr]);
  }
  if (output[_DSep] != null) {
    contents[_DSep] = (0, import_smithy_client.expectString)(output[_DSep]);
  }
  if (output[_LC] != null) {
    contents[_LC] = de_LoggingConfig(output[_LC], context);
  }
  if (output.RequiredActivatedTypes === "") {
    contents[_RAT] = [];
  } else if (output[_RAT] != null && output[_RAT][_m] != null) {
    contents[_RAT] = de_RequiredActivatedTypes((0, import_smithy_client.getArrayIfSingleItem)(output[_RAT][_m]), context);
  }
  if (output[_ERA] != null) {
    contents[_ERA] = (0, import_smithy_client.expectString)(output[_ERA]);
  }
  if (output[_Vi] != null) {
    contents[_Vi] = (0, import_smithy_client.expectString)(output[_Vi]);
  }
  if (output[_SU] != null) {
    contents[_SU] = (0, import_smithy_client.expectString)(output[_SU]);
  }
  if (output[_DU] != null) {
    contents[_DU] = (0, import_smithy_client.expectString)(output[_DU]);
  }
  if (output[_LU] != null) {
    contents[_LU] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LU]));
  }
  if (output[_TCi] != null) {
    contents[_TCi] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_TCi]));
  }
  if (output[_CSo] != null) {
    contents[_CSo] = (0, import_smithy_client.expectString)(output[_CSo]);
  }
  if (output[_PI] != null) {
    contents[_PI] = (0, import_smithy_client.expectString)(output[_PI]);
  }
  if (output[_OTN] != null) {
    contents[_OTN] = (0, import_smithy_client.expectString)(output[_OTN]);
  }
  if (output[_OTA] != null) {
    contents[_OTA] = (0, import_smithy_client.expectString)(output[_OTA]);
  }
  if (output[_PVN] != null) {
    contents[_PVN] = (0, import_smithy_client.expectString)(output[_PVN]);
  }
  if (output[_LPV] != null) {
    contents[_LPV] = (0, import_smithy_client.expectString)(output[_LPV]);
  }
  if (output[_IA] != null) {
    contents[_IA] = (0, import_smithy_client.parseBoolean)(output[_IA]);
  }
  if (output[_AU] != null) {
    contents[_AU] = (0, import_smithy_client.parseBoolean)(output[_AU]);
  }
  return contents;
}, "de_DescribeTypeOutput");
var de_DescribeTypeRegistrationOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PSr] != null) {
    contents[_PSr] = (0, import_smithy_client.expectString)(output[_PSr]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_TA] != null) {
    contents[_TA] = (0, import_smithy_client.expectString)(output[_TA]);
  }
  if (output[_TVA] != null) {
    contents[_TVA] = (0, import_smithy_client.expectString)(output[_TVA]);
  }
  return contents;
}, "de_DescribeTypeRegistrationOutput");
var de_DetectStackDriftOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SDDI] != null) {
    contents[_SDDI] = (0, import_smithy_client.expectString)(output[_SDDI]);
  }
  return contents;
}, "de_DetectStackDriftOutput");
var de_DetectStackResourceDriftOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SRDta] != null) {
    contents[_SRDta] = de_StackResourceDrift(output[_SRDta], context);
  }
  return contents;
}, "de_DetectStackResourceDriftOutput");
var de_DetectStackSetDriftOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OI] != null) {
    contents[_OI] = (0, import_smithy_client.expectString)(output[_OI]);
  }
  return contents;
}, "de_DetectStackSetDriftOutput");
var de_EstimateTemplateCostOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_U] != null) {
    contents[_U] = (0, import_smithy_client.expectString)(output[_U]);
  }
  return contents;
}, "de_EstimateTemplateCostOutput");
var de_ExecuteChangeSetOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_ExecuteChangeSetOutput");
var de_Export = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ESI] != null) {
    contents[_ESI] = (0, import_smithy_client.expectString)(output[_ESI]);
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_Val] != null) {
    contents[_Val] = (0, import_smithy_client.expectString)(output[_Val]);
  }
  return contents;
}, "de_Export");
var de_Exports = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Export(entry, context);
  });
}, "de_Exports");
var de_GeneratedTemplateNotFoundException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_GeneratedTemplateNotFoundException");
var de_GetGeneratedTemplateOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_TB] != null) {
    contents[_TB] = (0, import_smithy_client.expectString)(output[_TB]);
  }
  return contents;
}, "de_GetGeneratedTemplateOutput");
var de_GetStackPolicyOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SPB] != null) {
    contents[_SPB] = (0, import_smithy_client.expectString)(output[_SPB]);
  }
  return contents;
}, "de_GetStackPolicyOutput");
var de_GetTemplateOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_TB] != null) {
    contents[_TB] = (0, import_smithy_client.expectString)(output[_TB]);
  }
  if (output.StagesAvailable === "") {
    contents[_SA] = [];
  } else if (output[_SA] != null && output[_SA][_m] != null) {
    contents[_SA] = de_StageList((0, import_smithy_client.getArrayIfSingleItem)(output[_SA][_m]), context);
  }
  return contents;
}, "de_GetTemplateOutput");
var de_GetTemplateSummaryOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Parameters === "") {
    contents[_P] = [];
  } else if (output[_P] != null && output[_P][_m] != null) {
    contents[_P] = de_ParameterDeclarations((0, import_smithy_client.getArrayIfSingleItem)(output[_P][_m]), context);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output.Capabilities === "") {
    contents[_C] = [];
  } else if (output[_C] != null && output[_C][_m] != null) {
    contents[_C] = de_Capabilities((0, import_smithy_client.getArrayIfSingleItem)(output[_C][_m]), context);
  }
  if (output[_CR] != null) {
    contents[_CR] = (0, import_smithy_client.expectString)(output[_CR]);
  }
  if (output.ResourceTypes === "") {
    contents[_RTe] = [];
  } else if (output[_RTe] != null && output[_RTe][_m] != null) {
    contents[_RTe] = de_ResourceTypes((0, import_smithy_client.getArrayIfSingleItem)(output[_RTe][_m]), context);
  }
  if (output[_V] != null) {
    contents[_V] = (0, import_smithy_client.expectString)(output[_V]);
  }
  if (output[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(output[_Me]);
  }
  if (output.DeclaredTransforms === "") {
    contents[_DTec] = [];
  } else if (output[_DTec] != null && output[_DTec][_m] != null) {
    contents[_DTec] = de_TransformsList((0, import_smithy_client.getArrayIfSingleItem)(output[_DTec][_m]), context);
  }
  if (output.ResourceIdentifierSummaries === "") {
    contents[_RIS] = [];
  } else if (output[_RIS] != null && output[_RIS][_m] != null) {
    contents[_RIS] = de_ResourceIdentifierSummaries((0, import_smithy_client.getArrayIfSingleItem)(output[_RIS][_m]), context);
  }
  if (output[_W] != null) {
    contents[_W] = de_Warnings(output[_W], context);
  }
  return contents;
}, "de_GetTemplateSummaryOutput");
var de_Imports = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_Imports");
var de_ImportStacksToStackSetOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OI] != null) {
    contents[_OI] = (0, import_smithy_client.expectString)(output[_OI]);
  }
  return contents;
}, "de_ImportStacksToStackSetOutput");
var de_InsufficientCapabilitiesException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_InsufficientCapabilitiesException");
var de_InvalidChangeSetStatusException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_InvalidChangeSetStatusException");
var de_InvalidOperationException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_InvalidOperationException");
var de_InvalidStateTransitionException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_InvalidStateTransitionException");
var de_JazzResourceIdentifierProperties = /* @__PURE__ */ __name((output, context) => {
  return output.reduce((acc, pair) => {
    if (pair["value"] === null) {
      return acc;
    }
    acc[pair["key"]] = (0, import_smithy_client.expectString)(pair["value"]);
    return acc;
  }, {});
}, "de_JazzResourceIdentifierProperties");
var de_LimitExceededException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_LimitExceededException");
var de_ListChangeSetsOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Summaries === "") {
    contents[_Su] = [];
  } else if (output[_Su] != null && output[_Su][_m] != null) {
    contents[_Su] = de_ChangeSetSummaries((0, import_smithy_client.getArrayIfSingleItem)(output[_Su][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListChangeSetsOutput");
var de_ListExportsOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Exports === "") {
    contents[_Ex] = [];
  } else if (output[_Ex] != null && output[_Ex][_m] != null) {
    contents[_Ex] = de_Exports((0, import_smithy_client.getArrayIfSingleItem)(output[_Ex][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListExportsOutput");
var de_ListGeneratedTemplatesOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Summaries === "") {
    contents[_Su] = [];
  } else if (output[_Su] != null && output[_Su][_m] != null) {
    contents[_Su] = de_TemplateSummaries((0, import_smithy_client.getArrayIfSingleItem)(output[_Su][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListGeneratedTemplatesOutput");
var de_ListImportsOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Imports === "") {
    contents[_Im] = [];
  } else if (output[_Im] != null && output[_Im][_m] != null) {
    contents[_Im] = de_Imports((0, import_smithy_client.getArrayIfSingleItem)(output[_Im][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListImportsOutput");
var de_ListResourceScanRelatedResourcesOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.RelatedResources === "") {
    contents[_RRel] = [];
  } else if (output[_RRel] != null && output[_RRel][_m] != null) {
    contents[_RRel] = de_RelatedResources((0, import_smithy_client.getArrayIfSingleItem)(output[_RRel][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListResourceScanRelatedResourcesOutput");
var de_ListResourceScanResourcesOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Resources === "") {
    contents[_R] = [];
  } else if (output[_R] != null && output[_R][_m] != null) {
    contents[_R] = de_ScannedResources((0, import_smithy_client.getArrayIfSingleItem)(output[_R][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListResourceScanResourcesOutput");
var de_ListResourceScansOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.ResourceScanSummaries === "") {
    contents[_RSS] = [];
  } else if (output[_RSS] != null && output[_RSS][_m] != null) {
    contents[_RSS] = de_ResourceScanSummaries((0, import_smithy_client.getArrayIfSingleItem)(output[_RSS][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListResourceScansOutput");
var de_ListStackInstanceResourceDriftsOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Summaries === "") {
    contents[_Su] = [];
  } else if (output[_Su] != null && output[_Su][_m] != null) {
    contents[_Su] = de_StackInstanceResourceDriftsSummaries((0, import_smithy_client.getArrayIfSingleItem)(output[_Su][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListStackInstanceResourceDriftsOutput");
var de_ListStackInstancesOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Summaries === "") {
    contents[_Su] = [];
  } else if (output[_Su] != null && output[_Su][_m] != null) {
    contents[_Su] = de_StackInstanceSummaries((0, import_smithy_client.getArrayIfSingleItem)(output[_Su][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListStackInstancesOutput");
var de_ListStackResourcesOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.StackResourceSummaries === "") {
    contents[_SRSt] = [];
  } else if (output[_SRSt] != null && output[_SRSt][_m] != null) {
    contents[_SRSt] = de_StackResourceSummaries((0, import_smithy_client.getArrayIfSingleItem)(output[_SRSt][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListStackResourcesOutput");
var de_ListStackSetAutoDeploymentTargetsOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Summaries === "") {
    contents[_Su] = [];
  } else if (output[_Su] != null && output[_Su][_m] != null) {
    contents[_Su] = de_StackSetAutoDeploymentTargetSummaries((0, import_smithy_client.getArrayIfSingleItem)(output[_Su][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListStackSetAutoDeploymentTargetsOutput");
var de_ListStackSetOperationResultsOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Summaries === "") {
    contents[_Su] = [];
  } else if (output[_Su] != null && output[_Su][_m] != null) {
    contents[_Su] = de_StackSetOperationResultSummaries((0, import_smithy_client.getArrayIfSingleItem)(output[_Su][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListStackSetOperationResultsOutput");
var de_ListStackSetOperationsOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Summaries === "") {
    contents[_Su] = [];
  } else if (output[_Su] != null && output[_Su][_m] != null) {
    contents[_Su] = de_StackSetOperationSummaries((0, import_smithy_client.getArrayIfSingleItem)(output[_Su][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListStackSetOperationsOutput");
var de_ListStackSetsOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Summaries === "") {
    contents[_Su] = [];
  } else if (output[_Su] != null && output[_Su][_m] != null) {
    contents[_Su] = de_StackSetSummaries((0, import_smithy_client.getArrayIfSingleItem)(output[_Su][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListStackSetsOutput");
var de_ListStacksOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.StackSummaries === "") {
    contents[_SSt] = [];
  } else if (output[_SSt] != null && output[_SSt][_m] != null) {
    contents[_SSt] = de_StackSummaries((0, import_smithy_client.getArrayIfSingleItem)(output[_SSt][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListStacksOutput");
var de_ListTypeRegistrationsOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.RegistrationTokenList === "") {
    contents[_RTL] = [];
  } else if (output[_RTL] != null && output[_RTL][_m] != null) {
    contents[_RTL] = de_RegistrationTokenList((0, import_smithy_client.getArrayIfSingleItem)(output[_RTL][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListTypeRegistrationsOutput");
var de_ListTypesOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.TypeSummaries === "") {
    contents[_TSy] = [];
  } else if (output[_TSy] != null && output[_TSy][_m] != null) {
    contents[_TSy] = de_TypeSummaries((0, import_smithy_client.getArrayIfSingleItem)(output[_TSy][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListTypesOutput");
var de_ListTypeVersionsOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.TypeVersionSummaries === "") {
    contents[_TVS] = [];
  } else if (output[_TVS] != null && output[_TVS][_m] != null) {
    contents[_TVS] = de_TypeVersionSummaries((0, import_smithy_client.getArrayIfSingleItem)(output[_TVS][_m]), context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  return contents;
}, "de_ListTypeVersionsOutput");
var de_LoggingConfig = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_LRA] != null) {
    contents[_LRA] = (0, import_smithy_client.expectString)(output[_LRA]);
  }
  if (output[_LGN] != null) {
    contents[_LGN] = (0, import_smithy_client.expectString)(output[_LGN]);
  }
  return contents;
}, "de_LoggingConfig");
var de_LogicalResourceIds = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_LogicalResourceIds");
var de_ManagedExecution = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Act] != null) {
    contents[_Act] = (0, import_smithy_client.parseBoolean)(output[_Act]);
  }
  return contents;
}, "de_ManagedExecution");
var de_ModuleInfo = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_TH] != null) {
    contents[_TH] = (0, import_smithy_client.expectString)(output[_TH]);
  }
  if (output[_LIH] != null) {
    contents[_LIH] = (0, import_smithy_client.expectString)(output[_LIH]);
  }
  return contents;
}, "de_ModuleInfo");
var de_NameAlreadyExistsException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_NameAlreadyExistsException");
var de_NotificationARNs = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_NotificationARNs");
var de_OperationIdAlreadyExistsException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_OperationIdAlreadyExistsException");
var de_OperationInProgressException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_OperationInProgressException");
var de_OperationNotFoundException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_OperationNotFoundException");
var de_OperationStatusCheckFailedException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_OperationStatusCheckFailedException");
var de_OrganizationalUnitIdList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_OrganizationalUnitIdList");
var de_Output = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OK] != null) {
    contents[_OK] = (0, import_smithy_client.expectString)(output[_OK]);
  }
  if (output[_OV] != null) {
    contents[_OV] = (0, import_smithy_client.expectString)(output[_OV]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_EN] != null) {
    contents[_EN] = (0, import_smithy_client.expectString)(output[_EN]);
  }
  return contents;
}, "de_Output");
var de_Outputs = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Output(entry, context);
  });
}, "de_Outputs");
var de_Parameter = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PK] != null) {
    contents[_PK] = (0, import_smithy_client.expectString)(output[_PK]);
  }
  if (output[_PV] != null) {
    contents[_PV] = (0, import_smithy_client.expectString)(output[_PV]);
  }
  if (output[_UPV] != null) {
    contents[_UPV] = (0, import_smithy_client.parseBoolean)(output[_UPV]);
  }
  if (output[_RV] != null) {
    contents[_RV] = (0, import_smithy_client.expectString)(output[_RV]);
  }
  return contents;
}, "de_Parameter");
var de_ParameterConstraints = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.AllowedValues === "") {
    contents[_AV] = [];
  } else if (output[_AV] != null && output[_AV][_m] != null) {
    contents[_AV] = de_AllowedValues((0, import_smithy_client.getArrayIfSingleItem)(output[_AV][_m]), context);
  }
  return contents;
}, "de_ParameterConstraints");
var de_ParameterDeclaration = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PK] != null) {
    contents[_PK] = (0, import_smithy_client.expectString)(output[_PK]);
  }
  if (output[_DV] != null) {
    contents[_DV] = (0, import_smithy_client.expectString)(output[_DV]);
  }
  if (output[_PTa] != null) {
    contents[_PTa] = (0, import_smithy_client.expectString)(output[_PTa]);
  }
  if (output[_NE] != null) {
    contents[_NE] = (0, import_smithy_client.parseBoolean)(output[_NE]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_PCa] != null) {
    contents[_PCa] = de_ParameterConstraints(output[_PCa], context);
  }
  return contents;
}, "de_ParameterDeclaration");
var de_ParameterDeclarations = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ParameterDeclaration(entry, context);
  });
}, "de_ParameterDeclarations");
var de_Parameters = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Parameter(entry, context);
  });
}, "de_Parameters");
var de_PhysicalResourceIdContext = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_PhysicalResourceIdContextKeyValuePair(entry, context);
  });
}, "de_PhysicalResourceIdContext");
var de_PhysicalResourceIdContextKeyValuePair = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_K] != null) {
    contents[_K] = (0, import_smithy_client.expectString)(output[_K]);
  }
  if (output[_Val] != null) {
    contents[_Val] = (0, import_smithy_client.expectString)(output[_Val]);
  }
  return contents;
}, "de_PhysicalResourceIdContextKeyValuePair");
var de_PropertyDifference = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PPr] != null) {
    contents[_PPr] = (0, import_smithy_client.expectString)(output[_PPr]);
  }
  if (output[_EV] != null) {
    contents[_EV] = (0, import_smithy_client.expectString)(output[_EV]);
  }
  if (output[_AVc] != null) {
    contents[_AVc] = (0, import_smithy_client.expectString)(output[_AVc]);
  }
  if (output[_DTi] != null) {
    contents[_DTi] = (0, import_smithy_client.expectString)(output[_DTi]);
  }
  return contents;
}, "de_PropertyDifference");
var de_PropertyDifferences = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_PropertyDifference(entry, context);
  });
}, "de_PropertyDifferences");
var de_PublishTypeOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PTA] != null) {
    contents[_PTA] = (0, import_smithy_client.expectString)(output[_PTA]);
  }
  return contents;
}, "de_PublishTypeOutput");
var de_RecordHandlerProgressOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_RecordHandlerProgressOutput");
var de_RegionList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_RegionList");
var de_RegisterPublisherOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PI] != null) {
    contents[_PI] = (0, import_smithy_client.expectString)(output[_PI]);
  }
  return contents;
}, "de_RegisterPublisherOutput");
var de_RegisterTypeOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RTeg] != null) {
    contents[_RTeg] = (0, import_smithy_client.expectString)(output[_RTeg]);
  }
  return contents;
}, "de_RegisterTypeOutput");
var de_RegistrationTokenList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_RegistrationTokenList");
var de_RelatedResources = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ScannedResource(entry, context);
  });
}, "de_RelatedResources");
var de_RequiredActivatedType = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_TNA] != null) {
    contents[_TNA] = (0, import_smithy_client.expectString)(output[_TNA]);
  }
  if (output[_OTN] != null) {
    contents[_OTN] = (0, import_smithy_client.expectString)(output[_OTN]);
  }
  if (output[_PI] != null) {
    contents[_PI] = (0, import_smithy_client.expectString)(output[_PI]);
  }
  if (output.SupportedMajorVersions === "") {
    contents[_SMV] = [];
  } else if (output[_SMV] != null && output[_SMV][_m] != null) {
    contents[_SMV] = de_SupportedMajorVersions((0, import_smithy_client.getArrayIfSingleItem)(output[_SMV][_m]), context);
  }
  return contents;
}, "de_RequiredActivatedType");
var de_RequiredActivatedTypes = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_RequiredActivatedType(entry, context);
  });
}, "de_RequiredActivatedTypes");
var de_ResourceChange = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PA] != null) {
    contents[_PA] = (0, import_smithy_client.expectString)(output[_PA]);
  }
  if (output[_A] != null) {
    contents[_A] = (0, import_smithy_client.expectString)(output[_A]);
  }
  if (output[_LRI] != null) {
    contents[_LRI] = (0, import_smithy_client.expectString)(output[_LRI]);
  }
  if (output[_PRI] != null) {
    contents[_PRI] = (0, import_smithy_client.expectString)(output[_PRI]);
  }
  if (output[_RTes] != null) {
    contents[_RTes] = (0, import_smithy_client.expectString)(output[_RTes]);
  }
  if (output[_Rep] != null) {
    contents[_Rep] = (0, import_smithy_client.expectString)(output[_Rep]);
  }
  if (output.Scope === "") {
    contents[_Sco] = [];
  } else if (output[_Sco] != null && output[_Sco][_m] != null) {
    contents[_Sco] = de_Scope((0, import_smithy_client.getArrayIfSingleItem)(output[_Sco][_m]), context);
  }
  if (output.Details === "") {
    contents[_De] = [];
  } else if (output[_De] != null && output[_De][_m] != null) {
    contents[_De] = de_ResourceChangeDetails((0, import_smithy_client.getArrayIfSingleItem)(output[_De][_m]), context);
  }
  if (output[_CSIh] != null) {
    contents[_CSIh] = (0, import_smithy_client.expectString)(output[_CSIh]);
  }
  if (output[_MI] != null) {
    contents[_MI] = de_ModuleInfo(output[_MI], context);
  }
  if (output[_BC] != null) {
    contents[_BC] = (0, import_smithy_client.expectString)(output[_BC]);
  }
  if (output[_AC] != null) {
    contents[_AC] = (0, import_smithy_client.expectString)(output[_AC]);
  }
  return contents;
}, "de_ResourceChange");
var de_ResourceChangeDetail = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Tar] != null) {
    contents[_Tar] = de_ResourceTargetDefinition(output[_Tar], context);
  }
  if (output[_Ev] != null) {
    contents[_Ev] = (0, import_smithy_client.expectString)(output[_Ev]);
  }
  if (output[_CSh] != null) {
    contents[_CSh] = (0, import_smithy_client.expectString)(output[_CSh]);
  }
  if (output[_CE] != null) {
    contents[_CE] = (0, import_smithy_client.expectString)(output[_CE]);
  }
  return contents;
}, "de_ResourceChangeDetail");
var de_ResourceChangeDetails = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ResourceChangeDetail(entry, context);
  });
}, "de_ResourceChangeDetails");
var de_ResourceDetail = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RTes] != null) {
    contents[_RTes] = (0, import_smithy_client.expectString)(output[_RTes]);
  }
  if (output[_LRI] != null) {
    contents[_LRI] = (0, import_smithy_client.expectString)(output[_LRI]);
  }
  if (output.ResourceIdentifier === "") {
    contents[_RI] = {};
  } else if (output[_RI] != null && output[_RI][_e] != null) {
    contents[_RI] = de_ResourceIdentifierProperties((0, import_smithy_client.getArrayIfSingleItem)(output[_RI][_e]), context);
  }
  if (output[_RSeso] != null) {
    contents[_RSeso] = (0, import_smithy_client.expectString)(output[_RSeso]);
  }
  if (output[_RSR] != null) {
    contents[_RSR] = (0, import_smithy_client.expectString)(output[_RSR]);
  }
  if (output.Warnings === "") {
    contents[_W] = [];
  } else if (output[_W] != null && output[_W][_m] != null) {
    contents[_W] = de_WarningDetails((0, import_smithy_client.getArrayIfSingleItem)(output[_W][_m]), context);
  }
  return contents;
}, "de_ResourceDetail");
var de_ResourceDetails = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ResourceDetail(entry, context);
  });
}, "de_ResourceDetails");
var de_ResourceIdentifierProperties = /* @__PURE__ */ __name((output, context) => {
  return output.reduce((acc, pair) => {
    if (pair["value"] === null) {
      return acc;
    }
    acc[pair["key"]] = (0, import_smithy_client.expectString)(pair["value"]);
    return acc;
  }, {});
}, "de_ResourceIdentifierProperties");
var de_ResourceIdentifiers = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_ResourceIdentifiers");
var de_ResourceIdentifierSummaries = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ResourceIdentifierSummary(entry, context);
  });
}, "de_ResourceIdentifierSummaries");
var de_ResourceIdentifierSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RTes] != null) {
    contents[_RTes] = (0, import_smithy_client.expectString)(output[_RTes]);
  }
  if (output.LogicalResourceIds === "") {
    contents[_LRIo] = [];
  } else if (output[_LRIo] != null && output[_LRIo][_m] != null) {
    contents[_LRIo] = de_LogicalResourceIds((0, import_smithy_client.getArrayIfSingleItem)(output[_LRIo][_m]), context);
  }
  if (output.ResourceIdentifiers === "") {
    contents[_RIe] = [];
  } else if (output[_RIe] != null && output[_RIe][_m] != null) {
    contents[_RIe] = de_ResourceIdentifiers((0, import_smithy_client.getArrayIfSingleItem)(output[_RIe][_m]), context);
  }
  return contents;
}, "de_ResourceIdentifierSummary");
var de_ResourceScanInProgressException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_ResourceScanInProgressException");
var de_ResourceScanLimitExceededException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_ResourceScanLimitExceededException");
var de_ResourceScanNotFoundException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_ResourceScanNotFoundException");
var de_ResourceScanSummaries = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ResourceScanSummary(entry, context);
  });
}, "de_ResourceScanSummaries");
var de_ResourceScanSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RSI] != null) {
    contents[_RSI] = (0, import_smithy_client.expectString)(output[_RSI]);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_SRt] != null) {
    contents[_SRt] = (0, import_smithy_client.expectString)(output[_SRt]);
  }
  if (output[_ST] != null) {
    contents[_ST] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_ST]));
  }
  if (output[_ET] != null) {
    contents[_ET] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_ET]));
  }
  if (output[_PC] != null) {
    contents[_PC] = (0, import_smithy_client.strictParseFloat)(output[_PC]);
  }
  return contents;
}, "de_ResourceScanSummary");
var de_ResourceTargetDefinition = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_At] != null) {
    contents[_At] = (0, import_smithy_client.expectString)(output[_At]);
  }
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_RReq] != null) {
    contents[_RReq] = (0, import_smithy_client.expectString)(output[_RReq]);
  }
  if (output[_Pa] != null) {
    contents[_Pa] = (0, import_smithy_client.expectString)(output[_Pa]);
  }
  if (output[_BV] != null) {
    contents[_BV] = (0, import_smithy_client.expectString)(output[_BV]);
  }
  if (output[_AVf] != null) {
    contents[_AVf] = (0, import_smithy_client.expectString)(output[_AVf]);
  }
  if (output[_ACT] != null) {
    contents[_ACT] = (0, import_smithy_client.expectString)(output[_ACT]);
  }
  return contents;
}, "de_ResourceTargetDefinition");
var de_ResourceTypes = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_ResourceTypes");
var de_RollbackConfiguration = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.RollbackTriggers === "") {
    contents[_RTo] = [];
  } else if (output[_RTo] != null && output[_RTo][_m] != null) {
    contents[_RTo] = de_RollbackTriggers((0, import_smithy_client.getArrayIfSingleItem)(output[_RTo][_m]), context);
  }
  if (output[_MTIM] != null) {
    contents[_MTIM] = (0, import_smithy_client.strictParseInt32)(output[_MTIM]);
  }
  return contents;
}, "de_RollbackConfiguration");
var de_RollbackStackOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  return contents;
}, "de_RollbackStackOutput");
var de_RollbackTrigger = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  if (output[_T] != null) {
    contents[_T] = (0, import_smithy_client.expectString)(output[_T]);
  }
  return contents;
}, "de_RollbackTrigger");
var de_RollbackTriggers = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_RollbackTrigger(entry, context);
  });
}, "de_RollbackTriggers");
var de_ScannedResource = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RTes] != null) {
    contents[_RTes] = (0, import_smithy_client.expectString)(output[_RTes]);
  }
  if (output.ResourceIdentifier === "") {
    contents[_RI] = {};
  } else if (output[_RI] != null && output[_RI][_e] != null) {
    contents[_RI] = de_JazzResourceIdentifierProperties((0, import_smithy_client.getArrayIfSingleItem)(output[_RI][_e]), context);
  }
  if (output[_MBS] != null) {
    contents[_MBS] = (0, import_smithy_client.parseBoolean)(output[_MBS]);
  }
  return contents;
}, "de_ScannedResource");
var de_ScannedResources = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ScannedResource(entry, context);
  });
}, "de_ScannedResources");
var de_Scope = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_Scope");
var de_SetTypeConfigurationOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CAonf] != null) {
    contents[_CAonf] = (0, import_smithy_client.expectString)(output[_CAonf]);
  }
  return contents;
}, "de_SetTypeConfigurationOutput");
var de_SetTypeDefaultVersionOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_SetTypeDefaultVersionOutput");
var de_Stack = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  if (output[_SN] != null) {
    contents[_SN] = (0, import_smithy_client.expectString)(output[_SN]);
  }
  if (output[_CSIh] != null) {
    contents[_CSIh] = (0, import_smithy_client.expectString)(output[_CSIh]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output.Parameters === "") {
    contents[_P] = [];
  } else if (output[_P] != null && output[_P][_m] != null) {
    contents[_P] = de_Parameters((0, import_smithy_client.getArrayIfSingleItem)(output[_P][_m]), context);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output[_DTel] != null) {
    contents[_DTel] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_DTel]));
  }
  if (output[_LUT] != null) {
    contents[_LUT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LUT]));
  }
  if (output[_RC] != null) {
    contents[_RC] = de_RollbackConfiguration(output[_RC], context);
  }
  if (output[_SSta] != null) {
    contents[_SSta] = (0, import_smithy_client.expectString)(output[_SSta]);
  }
  if (output[_SSR] != null) {
    contents[_SSR] = (0, import_smithy_client.expectString)(output[_SSR]);
  }
  if (output[_DR] != null) {
    contents[_DR] = (0, import_smithy_client.parseBoolean)(output[_DR]);
  }
  if (output.NotificationARNs === "") {
    contents[_NARN] = [];
  } else if (output[_NARN] != null && output[_NARN][_m] != null) {
    contents[_NARN] = de_NotificationARNs((0, import_smithy_client.getArrayIfSingleItem)(output[_NARN][_m]), context);
  }
  if (output[_TIM] != null) {
    contents[_TIM] = (0, import_smithy_client.strictParseInt32)(output[_TIM]);
  }
  if (output.Capabilities === "") {
    contents[_C] = [];
  } else if (output[_C] != null && output[_C][_m] != null) {
    contents[_C] = de_Capabilities((0, import_smithy_client.getArrayIfSingleItem)(output[_C][_m]), context);
  }
  if (output.Outputs === "") {
    contents[_O] = [];
  } else if (output[_O] != null && output[_O][_m] != null) {
    contents[_O] = de_Outputs((0, import_smithy_client.getArrayIfSingleItem)(output[_O][_m]), context);
  }
  if (output[_RARN] != null) {
    contents[_RARN] = (0, import_smithy_client.expectString)(output[_RARN]);
  }
  if (output.Tags === "") {
    contents[_Ta] = [];
  } else if (output[_Ta] != null && output[_Ta][_m] != null) {
    contents[_Ta] = de_Tags((0, import_smithy_client.getArrayIfSingleItem)(output[_Ta][_m]), context);
  }
  if (output[_ETP] != null) {
    contents[_ETP] = (0, import_smithy_client.parseBoolean)(output[_ETP]);
  }
  if (output[_PIa] != null) {
    contents[_PIa] = (0, import_smithy_client.expectString)(output[_PIa]);
  }
  if (output[_RIo] != null) {
    contents[_RIo] = (0, import_smithy_client.expectString)(output[_RIo]);
  }
  if (output[_DI] != null) {
    contents[_DI] = de_StackDriftInformation(output[_DI], context);
  }
  if (output[_REOC] != null) {
    contents[_REOC] = (0, import_smithy_client.parseBoolean)(output[_REOC]);
  }
  if (output[_DSeta] != null) {
    contents[_DSeta] = (0, import_smithy_client.expectString)(output[_DSeta]);
  }
  return contents;
}, "de_Stack");
var de_StackDriftInformation = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SDS] != null) {
    contents[_SDS] = (0, import_smithy_client.expectString)(output[_SDS]);
  }
  if (output[_LCT] != null) {
    contents[_LCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LCT]));
  }
  return contents;
}, "de_StackDriftInformation");
var de_StackDriftInformationSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SDS] != null) {
    contents[_SDS] = (0, import_smithy_client.expectString)(output[_SDS]);
  }
  if (output[_LCT] != null) {
    contents[_LCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LCT]));
  }
  return contents;
}, "de_StackDriftInformationSummary");
var de_StackEvent = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  if (output[_EI] != null) {
    contents[_EI] = (0, import_smithy_client.expectString)(output[_EI]);
  }
  if (output[_SN] != null) {
    contents[_SN] = (0, import_smithy_client.expectString)(output[_SN]);
  }
  if (output[_LRI] != null) {
    contents[_LRI] = (0, import_smithy_client.expectString)(output[_LRI]);
  }
  if (output[_PRI] != null) {
    contents[_PRI] = (0, import_smithy_client.expectString)(output[_PRI]);
  }
  if (output[_RTes] != null) {
    contents[_RTes] = (0, import_smithy_client.expectString)(output[_RTes]);
  }
  if (output[_Ti] != null) {
    contents[_Ti] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_Ti]));
  }
  if (output[_RSeso] != null) {
    contents[_RSeso] = (0, import_smithy_client.expectString)(output[_RSeso]);
  }
  if (output[_RSR] != null) {
    contents[_RSR] = (0, import_smithy_client.expectString)(output[_RSR]);
  }
  if (output[_RPe] != null) {
    contents[_RPe] = (0, import_smithy_client.expectString)(output[_RPe]);
  }
  if (output[_CRT] != null) {
    contents[_CRT] = (0, import_smithy_client.expectString)(output[_CRT]);
  }
  if (output[_HT] != null) {
    contents[_HT] = (0, import_smithy_client.expectString)(output[_HT]);
  }
  if (output[_HS] != null) {
    contents[_HS] = (0, import_smithy_client.expectString)(output[_HS]);
  }
  if (output[_HSR] != null) {
    contents[_HSR] = (0, import_smithy_client.expectString)(output[_HSR]);
  }
  if (output[_HIP] != null) {
    contents[_HIP] = (0, import_smithy_client.expectString)(output[_HIP]);
  }
  if (output[_HFM] != null) {
    contents[_HFM] = (0, import_smithy_client.expectString)(output[_HFM]);
  }
  if (output[_DSeta] != null) {
    contents[_DSeta] = (0, import_smithy_client.expectString)(output[_DSeta]);
  }
  return contents;
}, "de_StackEvent");
var de_StackEvents = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_StackEvent(entry, context);
  });
}, "de_StackEvents");
var de_StackInstance = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SSI] != null) {
    contents[_SSI] = (0, import_smithy_client.expectString)(output[_SSI]);
  }
  if (output[_Reg] != null) {
    contents[_Reg] = (0, import_smithy_client.expectString)(output[_Reg]);
  }
  if (output[_Acc] != null) {
    contents[_Acc] = (0, import_smithy_client.expectString)(output[_Acc]);
  }
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  if (output.ParameterOverrides === "") {
    contents[_PO] = [];
  } else if (output[_PO] != null && output[_PO][_m] != null) {
    contents[_PO] = de_Parameters((0, import_smithy_client.getArrayIfSingleItem)(output[_PO][_m]), context);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_SIS] != null) {
    contents[_SIS] = de_StackInstanceComprehensiveStatus(output[_SIS], context);
  }
  if (output[_SRt] != null) {
    contents[_SRt] = (0, import_smithy_client.expectString)(output[_SRt]);
  }
  if (output[_OUIr] != null) {
    contents[_OUIr] = (0, import_smithy_client.expectString)(output[_OUIr]);
  }
  if (output[_DSr] != null) {
    contents[_DSr] = (0, import_smithy_client.expectString)(output[_DSr]);
  }
  if (output[_LDCT] != null) {
    contents[_LDCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LDCT]));
  }
  if (output[_LOI] != null) {
    contents[_LOI] = (0, import_smithy_client.expectString)(output[_LOI]);
  }
  return contents;
}, "de_StackInstance");
var de_StackInstanceComprehensiveStatus = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DSeta] != null) {
    contents[_DSeta] = (0, import_smithy_client.expectString)(output[_DSeta]);
  }
  return contents;
}, "de_StackInstanceComprehensiveStatus");
var de_StackInstanceNotFoundException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_StackInstanceNotFoundException");
var de_StackInstanceResourceDriftsSummaries = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_StackInstanceResourceDriftsSummary(entry, context);
  });
}, "de_StackInstanceResourceDriftsSummaries");
var de_StackInstanceResourceDriftsSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  if (output[_LRI] != null) {
    contents[_LRI] = (0, import_smithy_client.expectString)(output[_LRI]);
  }
  if (output[_PRI] != null) {
    contents[_PRI] = (0, import_smithy_client.expectString)(output[_PRI]);
  }
  if (output.PhysicalResourceIdContext === "") {
    contents[_PRIC] = [];
  } else if (output[_PRIC] != null && output[_PRIC][_m] != null) {
    contents[_PRIC] = de_PhysicalResourceIdContext((0, import_smithy_client.getArrayIfSingleItem)(output[_PRIC][_m]), context);
  }
  if (output[_RTes] != null) {
    contents[_RTes] = (0, import_smithy_client.expectString)(output[_RTes]);
  }
  if (output.PropertyDifferences === "") {
    contents[_PD] = [];
  } else if (output[_PD] != null && output[_PD][_m] != null) {
    contents[_PD] = de_PropertyDifferences((0, import_smithy_client.getArrayIfSingleItem)(output[_PD][_m]), context);
  }
  if (output[_SRDS] != null) {
    contents[_SRDS] = (0, import_smithy_client.expectString)(output[_SRDS]);
  }
  if (output[_Ti] != null) {
    contents[_Ti] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_Ti]));
  }
  return contents;
}, "de_StackInstanceResourceDriftsSummary");
var de_StackInstanceSummaries = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_StackInstanceSummary(entry, context);
  });
}, "de_StackInstanceSummaries");
var de_StackInstanceSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SSI] != null) {
    contents[_SSI] = (0, import_smithy_client.expectString)(output[_SSI]);
  }
  if (output[_Reg] != null) {
    contents[_Reg] = (0, import_smithy_client.expectString)(output[_Reg]);
  }
  if (output[_Acc] != null) {
    contents[_Acc] = (0, import_smithy_client.expectString)(output[_Acc]);
  }
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_SRt] != null) {
    contents[_SRt] = (0, import_smithy_client.expectString)(output[_SRt]);
  }
  if (output[_SIS] != null) {
    contents[_SIS] = de_StackInstanceComprehensiveStatus(output[_SIS], context);
  }
  if (output[_OUIr] != null) {
    contents[_OUIr] = (0, import_smithy_client.expectString)(output[_OUIr]);
  }
  if (output[_DSr] != null) {
    contents[_DSr] = (0, import_smithy_client.expectString)(output[_DSr]);
  }
  if (output[_LDCT] != null) {
    contents[_LDCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LDCT]));
  }
  if (output[_LOI] != null) {
    contents[_LOI] = (0, import_smithy_client.expectString)(output[_LOI]);
  }
  return contents;
}, "de_StackInstanceSummary");
var de_StackNotFoundException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_StackNotFoundException");
var de_StackResource = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SN] != null) {
    contents[_SN] = (0, import_smithy_client.expectString)(output[_SN]);
  }
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  if (output[_LRI] != null) {
    contents[_LRI] = (0, import_smithy_client.expectString)(output[_LRI]);
  }
  if (output[_PRI] != null) {
    contents[_PRI] = (0, import_smithy_client.expectString)(output[_PRI]);
  }
  if (output[_RTes] != null) {
    contents[_RTes] = (0, import_smithy_client.expectString)(output[_RTes]);
  }
  if (output[_Ti] != null) {
    contents[_Ti] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_Ti]));
  }
  if (output[_RSeso] != null) {
    contents[_RSeso] = (0, import_smithy_client.expectString)(output[_RSeso]);
  }
  if (output[_RSR] != null) {
    contents[_RSR] = (0, import_smithy_client.expectString)(output[_RSR]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_DI] != null) {
    contents[_DI] = de_StackResourceDriftInformation(output[_DI], context);
  }
  if (output[_MI] != null) {
    contents[_MI] = de_ModuleInfo(output[_MI], context);
  }
  return contents;
}, "de_StackResource");
var de_StackResourceDetail = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SN] != null) {
    contents[_SN] = (0, import_smithy_client.expectString)(output[_SN]);
  }
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  if (output[_LRI] != null) {
    contents[_LRI] = (0, import_smithy_client.expectString)(output[_LRI]);
  }
  if (output[_PRI] != null) {
    contents[_PRI] = (0, import_smithy_client.expectString)(output[_PRI]);
  }
  if (output[_RTes] != null) {
    contents[_RTes] = (0, import_smithy_client.expectString)(output[_RTes]);
  }
  if (output[_LUTa] != null) {
    contents[_LUTa] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LUTa]));
  }
  if (output[_RSeso] != null) {
    contents[_RSeso] = (0, import_smithy_client.expectString)(output[_RSeso]);
  }
  if (output[_RSR] != null) {
    contents[_RSR] = (0, import_smithy_client.expectString)(output[_RSR]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(output[_Me]);
  }
  if (output[_DI] != null) {
    contents[_DI] = de_StackResourceDriftInformation(output[_DI], context);
  }
  if (output[_MI] != null) {
    contents[_MI] = de_ModuleInfo(output[_MI], context);
  }
  return contents;
}, "de_StackResourceDetail");
var de_StackResourceDrift = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  if (output[_LRI] != null) {
    contents[_LRI] = (0, import_smithy_client.expectString)(output[_LRI]);
  }
  if (output[_PRI] != null) {
    contents[_PRI] = (0, import_smithy_client.expectString)(output[_PRI]);
  }
  if (output.PhysicalResourceIdContext === "") {
    contents[_PRIC] = [];
  } else if (output[_PRIC] != null && output[_PRIC][_m] != null) {
    contents[_PRIC] = de_PhysicalResourceIdContext((0, import_smithy_client.getArrayIfSingleItem)(output[_PRIC][_m]), context);
  }
  if (output[_RTes] != null) {
    contents[_RTes] = (0, import_smithy_client.expectString)(output[_RTes]);
  }
  if (output[_EP] != null) {
    contents[_EP] = (0, import_smithy_client.expectString)(output[_EP]);
  }
  if (output[_AP] != null) {
    contents[_AP] = (0, import_smithy_client.expectString)(output[_AP]);
  }
  if (output.PropertyDifferences === "") {
    contents[_PD] = [];
  } else if (output[_PD] != null && output[_PD][_m] != null) {
    contents[_PD] = de_PropertyDifferences((0, import_smithy_client.getArrayIfSingleItem)(output[_PD][_m]), context);
  }
  if (output[_SRDS] != null) {
    contents[_SRDS] = (0, import_smithy_client.expectString)(output[_SRDS]);
  }
  if (output[_Ti] != null) {
    contents[_Ti] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_Ti]));
  }
  if (output[_MI] != null) {
    contents[_MI] = de_ModuleInfo(output[_MI], context);
  }
  return contents;
}, "de_StackResourceDrift");
var de_StackResourceDriftInformation = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SRDS] != null) {
    contents[_SRDS] = (0, import_smithy_client.expectString)(output[_SRDS]);
  }
  if (output[_LCT] != null) {
    contents[_LCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LCT]));
  }
  return contents;
}, "de_StackResourceDriftInformation");
var de_StackResourceDriftInformationSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SRDS] != null) {
    contents[_SRDS] = (0, import_smithy_client.expectString)(output[_SRDS]);
  }
  if (output[_LCT] != null) {
    contents[_LCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LCT]));
  }
  return contents;
}, "de_StackResourceDriftInformationSummary");
var de_StackResourceDrifts = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_StackResourceDrift(entry, context);
  });
}, "de_StackResourceDrifts");
var de_StackResources = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_StackResource(entry, context);
  });
}, "de_StackResources");
var de_StackResourceSummaries = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_StackResourceSummary(entry, context);
  });
}, "de_StackResourceSummaries");
var de_StackResourceSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_LRI] != null) {
    contents[_LRI] = (0, import_smithy_client.expectString)(output[_LRI]);
  }
  if (output[_PRI] != null) {
    contents[_PRI] = (0, import_smithy_client.expectString)(output[_PRI]);
  }
  if (output[_RTes] != null) {
    contents[_RTes] = (0, import_smithy_client.expectString)(output[_RTes]);
  }
  if (output[_LUTa] != null) {
    contents[_LUTa] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LUTa]));
  }
  if (output[_RSeso] != null) {
    contents[_RSeso] = (0, import_smithy_client.expectString)(output[_RSeso]);
  }
  if (output[_RSR] != null) {
    contents[_RSR] = (0, import_smithy_client.expectString)(output[_RSR]);
  }
  if (output[_DI] != null) {
    contents[_DI] = de_StackResourceDriftInformationSummary(output[_DI], context);
  }
  if (output[_MI] != null) {
    contents[_MI] = de_ModuleInfo(output[_MI], context);
  }
  return contents;
}, "de_StackResourceSummary");
var de_Stacks = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Stack(entry, context);
  });
}, "de_Stacks");
var de_StackSet = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SSN] != null) {
    contents[_SSN] = (0, import_smithy_client.expectString)(output[_SSN]);
  }
  if (output[_SSI] != null) {
    contents[_SSI] = (0, import_smithy_client.expectString)(output[_SSI]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_TB] != null) {
    contents[_TB] = (0, import_smithy_client.expectString)(output[_TB]);
  }
  if (output.Parameters === "") {
    contents[_P] = [];
  } else if (output[_P] != null && output[_P][_m] != null) {
    contents[_P] = de_Parameters((0, import_smithy_client.getArrayIfSingleItem)(output[_P][_m]), context);
  }
  if (output.Capabilities === "") {
    contents[_C] = [];
  } else if (output[_C] != null && output[_C][_m] != null) {
    contents[_C] = de_Capabilities((0, import_smithy_client.getArrayIfSingleItem)(output[_C][_m]), context);
  }
  if (output.Tags === "") {
    contents[_Ta] = [];
  } else if (output[_Ta] != null && output[_Ta][_m] != null) {
    contents[_Ta] = de_Tags((0, import_smithy_client.getArrayIfSingleItem)(output[_Ta][_m]), context);
  }
  if (output[_SSARN] != null) {
    contents[_SSARN] = (0, import_smithy_client.expectString)(output[_SSARN]);
  }
  if (output[_ARARN] != null) {
    contents[_ARARN] = (0, import_smithy_client.expectString)(output[_ARARN]);
  }
  if (output[_ERN] != null) {
    contents[_ERN] = (0, import_smithy_client.expectString)(output[_ERN]);
  }
  if (output[_SSDDD] != null) {
    contents[_SSDDD] = de_StackSetDriftDetectionDetails(output[_SSDDD], context);
  }
  if (output[_AD] != null) {
    contents[_AD] = de_AutoDeployment(output[_AD], context);
  }
  if (output[_PM] != null) {
    contents[_PM] = (0, import_smithy_client.expectString)(output[_PM]);
  }
  if (output.OrganizationalUnitIds === "") {
    contents[_OUI] = [];
  } else if (output[_OUI] != null && output[_OUI][_m] != null) {
    contents[_OUI] = de_OrganizationalUnitIdList((0, import_smithy_client.getArrayIfSingleItem)(output[_OUI][_m]), context);
  }
  if (output[_ME] != null) {
    contents[_ME] = de_ManagedExecution(output[_ME], context);
  }
  if (output.Regions === "") {
    contents[_Re] = [];
  } else if (output[_Re] != null && output[_Re][_m] != null) {
    contents[_Re] = de_RegionList((0, import_smithy_client.getArrayIfSingleItem)(output[_Re][_m]), context);
  }
  return contents;
}, "de_StackSet");
var de_StackSetAutoDeploymentTargetSummaries = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_StackSetAutoDeploymentTargetSummary(entry, context);
  });
}, "de_StackSetAutoDeploymentTargetSummaries");
var de_StackSetAutoDeploymentTargetSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OUIr] != null) {
    contents[_OUIr] = (0, import_smithy_client.expectString)(output[_OUIr]);
  }
  if (output.Regions === "") {
    contents[_Re] = [];
  } else if (output[_Re] != null && output[_Re][_m] != null) {
    contents[_Re] = de_RegionList((0, import_smithy_client.getArrayIfSingleItem)(output[_Re][_m]), context);
  }
  return contents;
}, "de_StackSetAutoDeploymentTargetSummary");
var de_StackSetDriftDetectionDetails = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DSr] != null) {
    contents[_DSr] = (0, import_smithy_client.expectString)(output[_DSr]);
  }
  if (output[_DDS] != null) {
    contents[_DDS] = (0, import_smithy_client.expectString)(output[_DDS]);
  }
  if (output[_LDCT] != null) {
    contents[_LDCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LDCT]));
  }
  if (output[_TSIC] != null) {
    contents[_TSIC] = (0, import_smithy_client.strictParseInt32)(output[_TSIC]);
  }
  if (output[_DSIC] != null) {
    contents[_DSIC] = (0, import_smithy_client.strictParseInt32)(output[_DSIC]);
  }
  if (output[_ISSIC] != null) {
    contents[_ISSIC] = (0, import_smithy_client.strictParseInt32)(output[_ISSIC]);
  }
  if (output[_IPSIC] != null) {
    contents[_IPSIC] = (0, import_smithy_client.strictParseInt32)(output[_IPSIC]);
  }
  if (output[_FSIC] != null) {
    contents[_FSIC] = (0, import_smithy_client.strictParseInt32)(output[_FSIC]);
  }
  return contents;
}, "de_StackSetDriftDetectionDetails");
var de_StackSetNotEmptyException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_StackSetNotEmptyException");
var de_StackSetNotFoundException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_StackSetNotFoundException");
var de_StackSetOperation = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OI] != null) {
    contents[_OI] = (0, import_smithy_client.expectString)(output[_OI]);
  }
  if (output[_SSI] != null) {
    contents[_SSI] = (0, import_smithy_client.expectString)(output[_SSI]);
  }
  if (output[_A] != null) {
    contents[_A] = (0, import_smithy_client.expectString)(output[_A]);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_OP] != null) {
    contents[_OP] = de_StackSetOperationPreferences(output[_OP], context);
  }
  if (output[_RSe] != null) {
    contents[_RSe] = (0, import_smithy_client.parseBoolean)(output[_RSe]);
  }
  if (output[_ARARN] != null) {
    contents[_ARARN] = (0, import_smithy_client.expectString)(output[_ARARN]);
  }
  if (output[_ERN] != null) {
    contents[_ERN] = (0, import_smithy_client.expectString)(output[_ERN]);
  }
  if (output[_CTre] != null) {
    contents[_CTre] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTre]));
  }
  if (output[_ETn] != null) {
    contents[_ETn] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_ETn]));
  }
  if (output[_DTep] != null) {
    contents[_DTep] = de_DeploymentTargets(output[_DTep], context);
  }
  if (output[_SSDDD] != null) {
    contents[_SSDDD] = de_StackSetDriftDetectionDetails(output[_SSDDD], context);
  }
  if (output[_SRt] != null) {
    contents[_SRt] = (0, import_smithy_client.expectString)(output[_SRt]);
  }
  if (output[_SD] != null) {
    contents[_SD] = de_StackSetOperationStatusDetails(output[_SD], context);
  }
  return contents;
}, "de_StackSetOperation");
var de_StackSetOperationPreferences = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RCT] != null) {
    contents[_RCT] = (0, import_smithy_client.expectString)(output[_RCT]);
  }
  if (output.RegionOrder === "") {
    contents[_RO] = [];
  } else if (output[_RO] != null && output[_RO][_m] != null) {
    contents[_RO] = de_RegionList((0, import_smithy_client.getArrayIfSingleItem)(output[_RO][_m]), context);
  }
  if (output[_FTC] != null) {
    contents[_FTC] = (0, import_smithy_client.strictParseInt32)(output[_FTC]);
  }
  if (output[_FTP] != null) {
    contents[_FTP] = (0, import_smithy_client.strictParseInt32)(output[_FTP]);
  }
  if (output[_MCC] != null) {
    contents[_MCC] = (0, import_smithy_client.strictParseInt32)(output[_MCC]);
  }
  if (output[_MCP] != null) {
    contents[_MCP] = (0, import_smithy_client.strictParseInt32)(output[_MCP]);
  }
  if (output[_CM] != null) {
    contents[_CM] = (0, import_smithy_client.expectString)(output[_CM]);
  }
  return contents;
}, "de_StackSetOperationPreferences");
var de_StackSetOperationResultSummaries = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_StackSetOperationResultSummary(entry, context);
  });
}, "de_StackSetOperationResultSummaries");
var de_StackSetOperationResultSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Acc] != null) {
    contents[_Acc] = (0, import_smithy_client.expectString)(output[_Acc]);
  }
  if (output[_Reg] != null) {
    contents[_Reg] = (0, import_smithy_client.expectString)(output[_Reg]);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_SRt] != null) {
    contents[_SRt] = (0, import_smithy_client.expectString)(output[_SRt]);
  }
  if (output[_AGR] != null) {
    contents[_AGR] = de_AccountGateResult(output[_AGR], context);
  }
  if (output[_OUIr] != null) {
    contents[_OUIr] = (0, import_smithy_client.expectString)(output[_OUIr]);
  }
  return contents;
}, "de_StackSetOperationResultSummary");
var de_StackSetOperationStatusDetails = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_FSIC] != null) {
    contents[_FSIC] = (0, import_smithy_client.strictParseInt32)(output[_FSIC]);
  }
  return contents;
}, "de_StackSetOperationStatusDetails");
var de_StackSetOperationSummaries = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_StackSetOperationSummary(entry, context);
  });
}, "de_StackSetOperationSummaries");
var de_StackSetOperationSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OI] != null) {
    contents[_OI] = (0, import_smithy_client.expectString)(output[_OI]);
  }
  if (output[_A] != null) {
    contents[_A] = (0, import_smithy_client.expectString)(output[_A]);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_CTre] != null) {
    contents[_CTre] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTre]));
  }
  if (output[_ETn] != null) {
    contents[_ETn] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_ETn]));
  }
  if (output[_SRt] != null) {
    contents[_SRt] = (0, import_smithy_client.expectString)(output[_SRt]);
  }
  if (output[_SD] != null) {
    contents[_SD] = de_StackSetOperationStatusDetails(output[_SD], context);
  }
  if (output[_OP] != null) {
    contents[_OP] = de_StackSetOperationPreferences(output[_OP], context);
  }
  return contents;
}, "de_StackSetOperationSummary");
var de_StackSetSummaries = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_StackSetSummary(entry, context);
  });
}, "de_StackSetSummaries");
var de_StackSetSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SSN] != null) {
    contents[_SSN] = (0, import_smithy_client.expectString)(output[_SSN]);
  }
  if (output[_SSI] != null) {
    contents[_SSI] = (0, import_smithy_client.expectString)(output[_SSI]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_AD] != null) {
    contents[_AD] = de_AutoDeployment(output[_AD], context);
  }
  if (output[_PM] != null) {
    contents[_PM] = (0, import_smithy_client.expectString)(output[_PM]);
  }
  if (output[_DSr] != null) {
    contents[_DSr] = (0, import_smithy_client.expectString)(output[_DSr]);
  }
  if (output[_LDCT] != null) {
    contents[_LDCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LDCT]));
  }
  if (output[_ME] != null) {
    contents[_ME] = de_ManagedExecution(output[_ME], context);
  }
  return contents;
}, "de_StackSetSummary");
var de_StackSummaries = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_StackSummary(entry, context);
  });
}, "de_StackSummaries");
var de_StackSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  if (output[_SN] != null) {
    contents[_SN] = (0, import_smithy_client.expectString)(output[_SN]);
  }
  if (output[_TDe] != null) {
    contents[_TDe] = (0, import_smithy_client.expectString)(output[_TDe]);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output[_LUT] != null) {
    contents[_LUT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LUT]));
  }
  if (output[_DTel] != null) {
    contents[_DTel] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_DTel]));
  }
  if (output[_SSta] != null) {
    contents[_SSta] = (0, import_smithy_client.expectString)(output[_SSta]);
  }
  if (output[_SSR] != null) {
    contents[_SSR] = (0, import_smithy_client.expectString)(output[_SSR]);
  }
  if (output[_PIa] != null) {
    contents[_PIa] = (0, import_smithy_client.expectString)(output[_PIa]);
  }
  if (output[_RIo] != null) {
    contents[_RIo] = (0, import_smithy_client.expectString)(output[_RIo]);
  }
  if (output[_DI] != null) {
    contents[_DI] = de_StackDriftInformationSummary(output[_DI], context);
  }
  return contents;
}, "de_StackSummary");
var de_StageList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_StageList");
var de_StaleRequestException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_StaleRequestException");
var de_StartResourceScanOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RSI] != null) {
    contents[_RSI] = (0, import_smithy_client.expectString)(output[_RSI]);
  }
  return contents;
}, "de_StartResourceScanOutput");
var de_StopStackSetOperationOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_StopStackSetOperationOutput");
var de_SupportedMajorVersions = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.strictParseInt32)(entry);
  });
}, "de_SupportedMajorVersions");
var de_Tag = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_K] != null) {
    contents[_K] = (0, import_smithy_client.expectString)(output[_K]);
  }
  if (output[_Val] != null) {
    contents[_Val] = (0, import_smithy_client.expectString)(output[_Val]);
  }
  return contents;
}, "de_Tag");
var de_Tags = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Tag(entry, context);
  });
}, "de_Tags");
var de_TemplateConfiguration = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DPe] != null) {
    contents[_DPe] = (0, import_smithy_client.expectString)(output[_DPe]);
  }
  if (output[_URP] != null) {
    contents[_URP] = (0, import_smithy_client.expectString)(output[_URP]);
  }
  return contents;
}, "de_TemplateConfiguration");
var de_TemplateParameter = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PK] != null) {
    contents[_PK] = (0, import_smithy_client.expectString)(output[_PK]);
  }
  if (output[_DV] != null) {
    contents[_DV] = (0, import_smithy_client.expectString)(output[_DV]);
  }
  if (output[_NE] != null) {
    contents[_NE] = (0, import_smithy_client.parseBoolean)(output[_NE]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  return contents;
}, "de_TemplateParameter");
var de_TemplateParameters = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_TemplateParameter(entry, context);
  });
}, "de_TemplateParameters");
var de_TemplateProgress = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RSesou] != null) {
    contents[_RSesou] = (0, import_smithy_client.strictParseInt32)(output[_RSesou]);
  }
  if (output[_RF] != null) {
    contents[_RF] = (0, import_smithy_client.strictParseInt32)(output[_RF]);
  }
  if (output[_RPes] != null) {
    contents[_RPes] = (0, import_smithy_client.strictParseInt32)(output[_RPes]);
  }
  if (output[_RPeso] != null) {
    contents[_RPeso] = (0, import_smithy_client.strictParseInt32)(output[_RPeso]);
  }
  return contents;
}, "de_TemplateProgress");
var de_TemplateSummaries = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_TemplateSummary(entry, context);
  });
}, "de_TemplateSummaries");
var de_TemplateSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_GTI] != null) {
    contents[_GTI] = (0, import_smithy_client.expectString)(output[_GTI]);
  }
  if (output[_GTN] != null) {
    contents[_GTN] = (0, import_smithy_client.expectString)(output[_GTN]);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_SRt] != null) {
    contents[_SRt] = (0, import_smithy_client.expectString)(output[_SRt]);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output[_LUT] != null) {
    contents[_LUT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LUT]));
  }
  if (output[_NOR] != null) {
    contents[_NOR] = (0, import_smithy_client.strictParseInt32)(output[_NOR]);
  }
  return contents;
}, "de_TemplateSummary");
var de_TestTypeOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_TVA] != null) {
    contents[_TVA] = (0, import_smithy_client.expectString)(output[_TVA]);
  }
  return contents;
}, "de_TestTypeOutput");
var de_TokenAlreadyExistsException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_TokenAlreadyExistsException");
var de_TransformsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_TransformsList");
var de_TypeConfigurationDetails = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  if (output[_Al] != null) {
    contents[_Al] = (0, import_smithy_client.expectString)(output[_Al]);
  }
  if (output[_Co] != null) {
    contents[_Co] = (0, import_smithy_client.expectString)(output[_Co]);
  }
  if (output[_LU] != null) {
    contents[_LU] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LU]));
  }
  if (output[_TA] != null) {
    contents[_TA] = (0, import_smithy_client.expectString)(output[_TA]);
  }
  if (output[_TN] != null) {
    contents[_TN] = (0, import_smithy_client.expectString)(output[_TN]);
  }
  if (output[_IDC] != null) {
    contents[_IDC] = (0, import_smithy_client.parseBoolean)(output[_IDC]);
  }
  return contents;
}, "de_TypeConfigurationDetails");
var de_TypeConfigurationDetailsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_TypeConfigurationDetails(entry, context);
  });
}, "de_TypeConfigurationDetailsList");
var de_TypeConfigurationIdentifier = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_TA] != null) {
    contents[_TA] = (0, import_smithy_client.expectString)(output[_TA]);
  }
  if (output[_TCA] != null) {
    contents[_TCA] = (0, import_smithy_client.expectString)(output[_TCA]);
  }
  if (output[_TCAy] != null) {
    contents[_TCAy] = (0, import_smithy_client.expectString)(output[_TCAy]);
  }
  if (output[_T] != null) {
    contents[_T] = (0, import_smithy_client.expectString)(output[_T]);
  }
  if (output[_TN] != null) {
    contents[_TN] = (0, import_smithy_client.expectString)(output[_TN]);
  }
  return contents;
}, "de_TypeConfigurationIdentifier");
var de_TypeConfigurationNotFoundException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_TypeConfigurationNotFoundException");
var de_TypeNotFoundException = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_M] != null) {
    contents[_M] = (0, import_smithy_client.expectString)(output[_M]);
  }
  return contents;
}, "de_TypeNotFoundException");
var de_TypeSummaries = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_TypeSummary(entry, context);
  });
}, "de_TypeSummaries");
var de_TypeSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_T] != null) {
    contents[_T] = (0, import_smithy_client.expectString)(output[_T]);
  }
  if (output[_TN] != null) {
    contents[_TN] = (0, import_smithy_client.expectString)(output[_TN]);
  }
  if (output[_DVI] != null) {
    contents[_DVI] = (0, import_smithy_client.expectString)(output[_DVI]);
  }
  if (output[_TA] != null) {
    contents[_TA] = (0, import_smithy_client.expectString)(output[_TA]);
  }
  if (output[_LU] != null) {
    contents[_LU] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LU]));
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_PI] != null) {
    contents[_PI] = (0, import_smithy_client.expectString)(output[_PI]);
  }
  if (output[_OTN] != null) {
    contents[_OTN] = (0, import_smithy_client.expectString)(output[_OTN]);
  }
  if (output[_PVN] != null) {
    contents[_PVN] = (0, import_smithy_client.expectString)(output[_PVN]);
  }
  if (output[_LPV] != null) {
    contents[_LPV] = (0, import_smithy_client.expectString)(output[_LPV]);
  }
  if (output[_PIu] != null) {
    contents[_PIu] = (0, import_smithy_client.expectString)(output[_PIu]);
  }
  if (output[_PN] != null) {
    contents[_PN] = (0, import_smithy_client.expectString)(output[_PN]);
  }
  if (output[_IA] != null) {
    contents[_IA] = (0, import_smithy_client.parseBoolean)(output[_IA]);
  }
  return contents;
}, "de_TypeSummary");
var de_TypeVersionSummaries = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_TypeVersionSummary(entry, context);
  });
}, "de_TypeVersionSummaries");
var de_TypeVersionSummary = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_T] != null) {
    contents[_T] = (0, import_smithy_client.expectString)(output[_T]);
  }
  if (output[_TN] != null) {
    contents[_TN] = (0, import_smithy_client.expectString)(output[_TN]);
  }
  if (output[_VI] != null) {
    contents[_VI] = (0, import_smithy_client.expectString)(output[_VI]);
  }
  if (output[_IDV] != null) {
    contents[_IDV] = (0, import_smithy_client.parseBoolean)(output[_IDV]);
  }
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  if (output[_TCi] != null) {
    contents[_TCi] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_TCi]));
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_PVN] != null) {
    contents[_PVN] = (0, import_smithy_client.expectString)(output[_PVN]);
  }
  return contents;
}, "de_TypeVersionSummary");
var de_UnprocessedTypeConfigurations = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_TypeConfigurationIdentifier(entry, context);
  });
}, "de_UnprocessedTypeConfigurations");
var de_UpdateGeneratedTemplateOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_GTI] != null) {
    contents[_GTI] = (0, import_smithy_client.expectString)(output[_GTI]);
  }
  return contents;
}, "de_UpdateGeneratedTemplateOutput");
var de_UpdateStackInstancesOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OI] != null) {
    contents[_OI] = (0, import_smithy_client.expectString)(output[_OI]);
  }
  return contents;
}, "de_UpdateStackInstancesOutput");
var de_UpdateStackOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  return contents;
}, "de_UpdateStackOutput");
var de_UpdateStackSetOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OI] != null) {
    contents[_OI] = (0, import_smithy_client.expectString)(output[_OI]);
  }
  return contents;
}, "de_UpdateStackSetOutput");
var de_UpdateTerminationProtectionOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  return contents;
}, "de_UpdateTerminationProtectionOutput");
var de_ValidateTemplateOutput = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Parameters === "") {
    contents[_P] = [];
  } else if (output[_P] != null && output[_P][_m] != null) {
    contents[_P] = de_TemplateParameters((0, import_smithy_client.getArrayIfSingleItem)(output[_P][_m]), context);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output.Capabilities === "") {
    contents[_C] = [];
  } else if (output[_C] != null && output[_C][_m] != null) {
    contents[_C] = de_Capabilities((0, import_smithy_client.getArrayIfSingleItem)(output[_C][_m]), context);
  }
  if (output[_CR] != null) {
    contents[_CR] = (0, import_smithy_client.expectString)(output[_CR]);
  }
  if (output.DeclaredTransforms === "") {
    contents[_DTec] = [];
  } else if (output[_DTec] != null && output[_DTec][_m] != null) {
    contents[_DTec] = de_TransformsList((0, import_smithy_client.getArrayIfSingleItem)(output[_DTec][_m]), context);
  }
  return contents;
}, "de_ValidateTemplateOutput");
var de_WarningDetail = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_T] != null) {
    contents[_T] = (0, import_smithy_client.expectString)(output[_T]);
  }
  if (output.Properties === "") {
    contents[_Pro] = [];
  } else if (output[_Pro] != null && output[_Pro][_m] != null) {
    contents[_Pro] = de_WarningProperties((0, import_smithy_client.getArrayIfSingleItem)(output[_Pro][_m]), context);
  }
  return contents;
}, "de_WarningDetail");
var de_WarningDetails = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_WarningDetail(entry, context);
  });
}, "de_WarningDetails");
var de_WarningProperties = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_WarningProperty(entry, context);
  });
}, "de_WarningProperties");
var de_WarningProperty = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PPr] != null) {
    contents[_PPr] = (0, import_smithy_client.expectString)(output[_PPr]);
  }
  if (output[_Req] != null) {
    contents[_Req] = (0, import_smithy_client.parseBoolean)(output[_Req]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  return contents;
}, "de_WarningProperty");
var de_Warnings = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.UnrecognizedResourceTypes === "") {
    contents[_URT] = [];
  } else if (output[_URT] != null && output[_URT][_m] != null) {
    contents[_URT] = de_ResourceTypes((0, import_smithy_client.getArrayIfSingleItem)(output[_URT][_m]), context);
  }
  return contents;
}, "de_Warnings");
var deserializeMetadata = /* @__PURE__ */ __name((output) => ({
  httpStatusCode: output.statusCode,
  requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
  extendedRequestId: output.headers["x-amz-id-2"],
  cfId: output.headers["x-amz-cf-id"]
}), "deserializeMetadata");
var throwDefaultError = (0, import_smithy_client.withBaseException)(CloudFormationServiceException);
var buildHttpRpcRequest = /* @__PURE__ */ __name(async (context, headers, path, resolvedHostname, body) => {
  const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
  const contents = {
    protocol,
    hostname,
    port,
    method: "POST",
    path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
    headers
  };
  if (resolvedHostname !== void 0) {
    contents.hostname = resolvedHostname;
  }
  if (body !== void 0) {
    contents.body = body;
  }
  return new import_protocol_http.HttpRequest(contents);
}, "buildHttpRpcRequest");
var SHARED_HEADERS = {
  "content-type": "application/x-www-form-urlencoded"
};
var _ = "2010-05-15";
var _A = "Action";
var _AC = "AfterContext";
var _ACT = "AttributeChangeType";
var _AD = "AutoDeployment";
var _AFT = "AccountFilterType";
var _AGR = "AccountGateResult";
var _AL = "AccountLimits";
var _AOA = "ActivateOrganizationsAccess";
var _AP = "ActualProperties";
var _AR = "AddResources";
var _ARARN = "AdministrationRoleARN";
var _AT = "ActivateType";
var _ATAC = "AcceptTermsAndConditions";
var _AU = "AutoUpdate";
var _AUc = "AccountsUrl";
var _AV = "AllowedValues";
var _AVc = "ActualValue";
var _AVf = "AfterValue";
var _Ac = "Accounts";
var _Acc = "Account";
var _Act = "Active";
var _Al = "Alias";
var _Ar = "Arn";
var _At = "Attribute";
var _BC = "BeforeContext";
var _BDTC = "BatchDescribeTypeConfigurations";
var _BT = "BearerToken";
var _BV = "BeforeValue";
var _C = "Capabilities";
var _CA = "CallAs";
var _CAo = "ConnectionArn";
var _CAon = "ConfigurationAlias";
var _CAonf = "ConfigurationArn";
var _CCS = "CreateChangeSet";
var _CE = "CausingEntity";
var _CGT = "CreateGeneratedTemplate";
var _CM = "ConcurrencyMode";
var _COS = "CurrentOperationStatus";
var _CR = "CapabilitiesReason";
var _CRT = "ClientRequestToken";
var _CS = "CreateStack";
var _CSI = "CreateStackInstances";
var _CSIh = "ChangeSetId";
var _CSN = "ChangeSetName";
var _CSS = "CreateStackSet";
var _CST = "ChangeSetType";
var _CSh = "ChangeSource";
var _CSo = "ConfigurationSchema";
var _CT = "ClientToken";
var _CTr = "CreationTime";
var _CTre = "CreationTimestamp";
var _CUR = "ContinueUpdateRollback";
var _CUS = "CancelUpdateStack";
var _Ca = "Category";
var _Ch = "Changes";
var _Co = "Configuration";
var _D = "Description";
var _DAL = "DescribeAccountLimits";
var _DCS = "DeleteChangeSet";
var _DCSH = "DescribeChangeSetHooks";
var _DCSe = "DescribeChangeSet";
var _DDS = "DriftDetectionStatus";
var _DGT = "DeleteGeneratedTemplate";
var _DGTe = "DescribeGeneratedTemplate";
var _DI = "DriftInformation";
var _DOA = "DeactivateOrganizationsAccess";
var _DOAe = "DescribeOrganizationsAccess";
var _DP = "DescribePublisher";
var _DPe = "DeletionPolicy";
var _DR = "DisableRollback";
var _DRS = "DescribeResourceScan";
var _DS = "DeleteStack";
var _DSD = "DetectStackDrift";
var _DSDDS = "DescribeStackDriftDetectionStatus";
var _DSE = "DescribeStackEvents";
var _DSI = "DeleteStackInstances";
var _DSIC = "DriftedStackInstancesCount";
var _DSIe = "DescribeStackInstance";
var _DSR = "DescribeStackResource";
var _DSRC = "DriftedStackResourceCount";
var _DSRD = "DescribeStackResourceDrifts";
var _DSRDe = "DetectStackResourceDrift";
var _DSRe = "DescribeStackResources";
var _DSRet = "DetectionStatusReason";
var _DSS = "DeleteStackSet";
var _DSSD = "DetectStackSetDrift";
var _DSSO = "DescribeStackSetOperation";
var _DSSe = "DescribeStackSet";
var _DSe = "DescribeStacks";
var _DSep = "DeprecatedStatus";
var _DSet = "DetectionStatus";
var _DSeta = "DetailedStatus";
var _DSr = "DriftStatus";
var _DT = "DeactivateType";
var _DTR = "DescribeTypeRegistration";
var _DTe = "DeregisterType";
var _DTec = "DeclaredTransforms";
var _DTel = "DeletionTime";
var _DTep = "DeploymentTargets";
var _DTes = "DescribeType";
var _DTi = "DifferenceType";
var _DU = "DocumentationUrl";
var _DV = "DefaultValue";
var _DVI = "DefaultVersionId";
var _De = "Details";
var _E = "Enabled";
var _EC = "ErrorCode";
var _ECS = "ExecuteChangeSet";
var _EI = "EventId";
var _EM = "ErrorMessage";
var _EN = "ExportName";
var _EP = "ExpectedProperties";
var _ERA = "ExecutionRoleArn";
var _ERN = "ExecutionRoleName";
var _ES = "ExecutionStatus";
var _ESI = "ExportingStackId";
var _ET = "EndTime";
var _ETC = "EstimateTemplateCost";
var _ETP = "EnableTerminationProtection";
var _ETn = "EndTimestamp";
var _EV = "ExpectedValue";
var _Er = "Errors";
var _Ev = "Evaluation";
var _Ex = "Exports";
var _F = "Format";
var _FM = "FailureMode";
var _FSIC = "FailedStackInstancesCount";
var _FTC = "FailureToleranceCount";
var _FTP = "FailureTolerancePercentage";
var _Fi = "Filters";
var _GGT = "GetGeneratedTemplate";
var _GSP = "GetStackPolicy";
var _GT = "GetTemplate";
var _GTI = "GeneratedTemplateId";
var _GTN = "GeneratedTemplateName";
var _GTS = "GetTemplateSummary";
var _H = "Hooks";
var _HFM = "HookFailureMode";
var _HIC = "HookInvocationCount";
var _HIP = "HookInvocationPoint";
var _HS = "HookStatus";
var _HSR = "HookStatusReason";
var _HT = "HookType";
var _I = "Id";
var _IA = "IsActivated";
var _IDC = "IsDefaultConfiguration";
var _IDV = "IsDefaultVersion";
var _IER = "ImportExistingResources";
var _INS = "IncludeNestedStacks";
var _IP = "InvocationPoint";
var _IPSIC = "InProgressStackInstancesCount";
var _IPV = "IncludePropertyValues";
var _IPd = "IdentityProvider";
var _ISSIC = "InSyncStackInstancesCount";
var _ISTSS = "ImportStacksToStackSet";
var _Im = "Imports";
var _K = "Key";
var _LC = "LoggingConfig";
var _LCS = "ListChangeSets";
var _LCT = "LastCheckTimestamp";
var _LDB = "LogDeliveryBucket";
var _LDCT = "LastDriftCheckTimestamp";
var _LE = "ListExports";
var _LGN = "LogGroupName";
var _LGT = "ListGeneratedTemplates";
var _LI = "ListImports";
var _LIH = "LogicalIdHierarchy";
var _LOI = "LastOperationId";
var _LPV = "LatestPublicVersion";
var _LRA = "LogRoleArn";
var _LRI = "LogicalResourceId";
var _LRIo = "LogicalResourceIds";
var _LRS = "ListResourceScans";
var _LRSR = "ListResourceScanResources";
var _LRSRR = "ListResourceScanRelatedResources";
var _LS = "ListStacks";
var _LSI = "ListStackInstances";
var _LSIRD = "ListStackInstanceResourceDrifts";
var _LSR = "ListStackResources";
var _LSS = "ListStackSets";
var _LSSADT = "ListStackSetAutoDeploymentTargets";
var _LSSO = "ListStackSetOperations";
var _LSSOR = "ListStackSetOperationResults";
var _LT = "ListTypes";
var _LTR = "ListTypeRegistrations";
var _LTV = "ListTypeVersions";
var _LU = "LastUpdated";
var _LUT = "LastUpdatedTime";
var _LUTa = "LastUpdatedTimestamp";
var _M = "Message";
var _MBS = "ManagedByStack";
var _MCC = "MaxConcurrentCount";
var _MCP = "MaxConcurrentPercentage";
var _ME = "ManagedExecution";
var _MI = "ModuleInfo";
var _MR = "MaxResults";
var _MTIM = "MonitoringTimeInMinutes";
var _MV = "MajorVersion";
var _Me = "Metadata";
var _N = "Name";
var _NARN = "NotificationARNs";
var _NE = "NoEcho";
var _NGTN = "NewGeneratedTemplateName";
var _NOR = "NumberOfResources";
var _NT = "NextToken";
var _O = "Outputs";
var _OF = "OnFailure";
var _OI = "OperationId";
var _OK = "OutputKey";
var _OP = "OperationPreferences";
var _OS = "OperationStatus";
var _OSF = "OnStackFailure";
var _OTA = "OriginalTypeArn";
var _OTN = "OriginalTypeName";
var _OUI = "OrganizationalUnitIds";
var _OUIr = "OrganizationalUnitId";
var _OV = "OutputValue";
var _P = "Parameters";
var _PA = "PolicyAction";
var _PC = "PercentageCompleted";
var _PCSI = "ParentChangeSetId";
var _PCa = "ParameterConstraints";
var _PD = "PropertyDifferences";
var _PI = "PublisherId";
var _PIa = "ParentId";
var _PIu = "PublisherIdentity";
var _PK = "ParameterKey";
var _PM = "PermissionModel";
var _PN = "PublisherName";
var _PO = "ParameterOverrides";
var _PP = "PublisherProfile";
var _PPr = "PropertyPath";
var _PRI = "PhysicalResourceId";
var _PRIC = "PhysicalResourceIdContext";
var _PS = "PublisherStatus";
var _PSr = "ProgressStatus";
var _PT = "PublishType";
var _PTA = "PublicTypeArn";
var _PTa = "ParameterType";
var _PTr = "ProvisioningType";
var _PV = "ParameterValue";
var _PVN = "PublicVersionNumber";
var _Pa = "Path";
var _Pr = "Progress";
var _Pro = "Properties";
var _R = "Resources";
var _RA = "ResourceAction";
var _RAR = "RefreshAllResources";
var _RARN = "RoleARN";
var _RAT = "RequiredActivatedTypes";
var _RC = "RollbackConfiguration";
var _RCSI = "RootChangeSetId";
var _RCT = "RegionConcurrencyType";
var _RCe = "ResourceChange";
var _REOC = "RetainExceptOnCreate";
var _RF = "ResourcesFailed";
var _RHP = "RecordHandlerProgress";
var _RI = "ResourceIdentifier";
var _RIS = "ResourceIdentifierSummaries";
var _RIe = "ResourceIdentifiers";
var _RIo = "RootId";
var _RM = "ResourceModel";
var _RO = "RegionOrder";
var _RP = "RegisterPublisher";
var _RPe = "ResourceProperties";
var _RPes = "ResourcesProcessing";
var _RPeso = "ResourcesPending";
var _RR = "RetainResources";
var _RRe = "RemoveResources";
var _RRel = "RelatedResources";
var _RReq = "RequiresRecreation";
var _RRes = "ResourcesRead";
var _RS = "RollbackStack";
var _RSF = "RegistrationStatusFilter";
var _RSI = "ResourceScanId";
var _RSOAR = "RetainStacksOnAccountRemoval";
var _RSR = "ResourceStatusReason";
var _RSS = "ResourceScanSummaries";
var _RSe = "RetainStacks";
var _RSes = "ResourcesScanned";
var _RSeso = "ResourceStatus";
var _RSesou = "ResourcesSucceeded";
var _RT = "RegisterType";
var _RTD = "ResourceTargetDetails";
var _RTI = "ResourcesToImport";
var _RTL = "RegistrationTokenList";
var _RTP = "ResourceTypePrefix";
var _RTS = "ResourcesToSkip";
var _RTe = "ResourceTypes";
var _RTeg = "RegistrationToken";
var _RTes = "ResourceType";
var _RTo = "RollbackTriggers";
var _RV = "ResolvedValue";
var _Re = "Regions";
var _Reg = "Region";
var _Rep = "Replacement";
var _Req = "Required";
var _S = "Status";
var _SA = "StagesAvailable";
var _SD = "StatusDetails";
var _SDDI = "StackDriftDetectionId";
var _SDS = "StackDriftStatus";
var _SE = "StackEvents";
var _SHP = "SchemaHandlerPackage";
var _SI = "StackId";
var _SIA = "StackInstanceAccount";
var _SIR = "StackInstanceRegion";
var _SIRDS = "StackInstanceResourceDriftStatuses";
var _SIS = "StackInstanceStatus";
var _SIU = "StackIdsUrl";
var _SIt = "StackIds";
var _SIta = "StackInstance";
var _SM = "StatusMessage";
var _SMV = "SupportedMajorVersions";
var _SN = "StackName";
var _SPB = "StackPolicyBody";
var _SPDUB = "StackPolicyDuringUpdateBody";
var _SPDUURL = "StackPolicyDuringUpdateURL";
var _SPURL = "StackPolicyURL";
var _SR = "SignalResource";
var _SRD = "StackResourceDrifts";
var _SRDS = "StackResourceDriftStatus";
var _SRDSF = "StackResourceDriftStatusFilters";
var _SRDt = "StackResourceDetail";
var _SRDta = "StackResourceDrift";
var _SRS = "StartResourceScan";
var _SRSt = "StackResourceSummaries";
var _SRt = "StatusReason";
var _SRta = "StackResources";
var _SS = "StackSet";
var _SSARN = "StackSetARN";
var _SSDDD = "StackSetDriftDetectionDetails";
var _SSF = "StackStatusFilter";
var _SSI = "StackSetId";
var _SSN = "StackSetName";
var _SSO = "StackSetOperation";
var _SSP = "SetStackPolicy";
var _SSR = "StackStatusReason";
var _SSSO = "StopStackSetOperation";
var _SSt = "StackSummaries";
var _SSta = "StackStatus";
var _ST = "StartTime";
var _STC = "SetTypeConfiguration";
var _STDV = "SetTypeDefaultVersion";
var _SU = "SourceUrl";
var _Sc = "Schema";
var _Sco = "Scope";
var _St = "Stacks";
var _Su = "Summaries";
var _T = "Type";
var _TA = "TypeArn";
var _TB = "TemplateBody";
var _TC = "TemplateConfiguration";
var _TCA = "TypeConfigurationAlias";
var _TCAy = "TypeConfigurationArn";
var _TCI = "TypeConfigurationIdentifiers";
var _TCIy = "TypeConfigurationIdentifier";
var _TCVI = "TypeConfigurationVersionId";
var _TCi = "TimeCreated";
var _TCy = "TypeConfigurations";
var _TD = "TargetDetails";
var _TDe = "TemplateDescription";
var _TH = "TypeHierarchy";
var _TIM = "TimeoutInMinutes";
var _TK = "TagKey";
var _TN = "TypeName";
var _TNA = "TypeNameAlias";
var _TNP = "TypeNamePrefix";
var _TS = "TemplateStage";
var _TSC = "TemplateSummaryConfig";
var _TSIC = "TotalStackInstancesCount";
var _TSy = "TypeSummaries";
var _TT = "TestType";
var _TTS = "TypeTestsStatus";
var _TTSD = "TypeTestsStatusDescription";
var _TTa = "TargetType";
var _TURL = "TemplateURL";
var _TURTAW = "TreatUnrecognizedResourceTypesAsWarnings";
var _TV = "TagValue";
var _TVA = "TypeVersionArn";
var _TVI = "TypeVersionId";
var _TVS = "TypeVersionSummaries";
var _TW = "TotalWarnings";
var _Ta = "Tags";
var _Tar = "Target";
var _Ti = "Timestamp";
var _U = "Url";
var _UGT = "UpdateGeneratedTemplate";
var _UI = "UniqueId";
var _UPT = "UsePreviousTemplate";
var _UPV = "UsePreviousValue";
var _URP = "UpdateReplacePolicy";
var _URT = "UnrecognizedResourceTypes";
var _US = "UpdateStack";
var _USI = "UpdateStackInstances";
var _USS = "UpdateStackSet";
var _UTC = "UnprocessedTypeConfigurations";
var _UTP = "UpdateTerminationProtection";
var _V = "Version";
var _VB = "VersionBump";
var _VI = "VersionId";
var _VT = "ValidateTemplate";
var _Va = "Values";
var _Val = "Value";
var _Vi = "Visibility";
var _W = "Warnings";
var _e = "entry";
var _m = "member";
var buildFormUrlencodedString = /* @__PURE__ */ __name((formEntries) => Object.entries(formEntries).map(([key, value]) => (0, import_smithy_client.extendedEncodeURIComponent)(key) + "=" + (0, import_smithy_client.extendedEncodeURIComponent)(value)).join("&"), "buildFormUrlencodedString");
var loadQueryErrorCode = /* @__PURE__ */ __name((output, data) => {
  var _a;
  if (((_a = data.Error) == null ? void 0 : _a.Code) !== void 0) {
    return data.Error.Code;
  }
  if (output.statusCode == 404) {
    return "NotFound";
  }
}, "loadQueryErrorCode");

// src/commands/ActivateOrganizationsAccessCommand.ts
var _ActivateOrganizationsAccessCommand = class _ActivateOrganizationsAccessCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ActivateOrganizationsAccess", {}).n("CloudFormationClient", "ActivateOrganizationsAccessCommand").f(void 0, void 0).ser(se_ActivateOrganizationsAccessCommand).de(de_ActivateOrganizationsAccessCommand).build() {
};
__name(_ActivateOrganizationsAccessCommand, "ActivateOrganizationsAccessCommand");
var ActivateOrganizationsAccessCommand = _ActivateOrganizationsAccessCommand;

// src/commands/ActivateTypeCommand.ts




var _ActivateTypeCommand = class _ActivateTypeCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ActivateType", {}).n("CloudFormationClient", "ActivateTypeCommand").f(void 0, void 0).ser(se_ActivateTypeCommand).de(de_ActivateTypeCommand).build() {
};
__name(_ActivateTypeCommand, "ActivateTypeCommand");
var ActivateTypeCommand = _ActivateTypeCommand;

// src/commands/BatchDescribeTypeConfigurationsCommand.ts




var _BatchDescribeTypeConfigurationsCommand = class _BatchDescribeTypeConfigurationsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "BatchDescribeTypeConfigurations", {}).n("CloudFormationClient", "BatchDescribeTypeConfigurationsCommand").f(void 0, void 0).ser(se_BatchDescribeTypeConfigurationsCommand).de(de_BatchDescribeTypeConfigurationsCommand).build() {
};
__name(_BatchDescribeTypeConfigurationsCommand, "BatchDescribeTypeConfigurationsCommand");
var BatchDescribeTypeConfigurationsCommand = _BatchDescribeTypeConfigurationsCommand;

// src/commands/CancelUpdateStackCommand.ts




var _CancelUpdateStackCommand = class _CancelUpdateStackCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "CancelUpdateStack", {}).n("CloudFormationClient", "CancelUpdateStackCommand").f(void 0, void 0).ser(se_CancelUpdateStackCommand).de(de_CancelUpdateStackCommand).build() {
};
__name(_CancelUpdateStackCommand, "CancelUpdateStackCommand");
var CancelUpdateStackCommand = _CancelUpdateStackCommand;

// src/commands/ContinueUpdateRollbackCommand.ts




var _ContinueUpdateRollbackCommand = class _ContinueUpdateRollbackCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ContinueUpdateRollback", {}).n("CloudFormationClient", "ContinueUpdateRollbackCommand").f(void 0, void 0).ser(se_ContinueUpdateRollbackCommand).de(de_ContinueUpdateRollbackCommand).build() {
};
__name(_ContinueUpdateRollbackCommand, "ContinueUpdateRollbackCommand");
var ContinueUpdateRollbackCommand = _ContinueUpdateRollbackCommand;

// src/commands/CreateChangeSetCommand.ts




var _CreateChangeSetCommand = class _CreateChangeSetCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "CreateChangeSet", {}).n("CloudFormationClient", "CreateChangeSetCommand").f(void 0, void 0).ser(se_CreateChangeSetCommand).de(de_CreateChangeSetCommand).build() {
};
__name(_CreateChangeSetCommand, "CreateChangeSetCommand");
var CreateChangeSetCommand = _CreateChangeSetCommand;

// src/commands/CreateGeneratedTemplateCommand.ts




var _CreateGeneratedTemplateCommand = class _CreateGeneratedTemplateCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "CreateGeneratedTemplate", {}).n("CloudFormationClient", "CreateGeneratedTemplateCommand").f(void 0, void 0).ser(se_CreateGeneratedTemplateCommand).de(de_CreateGeneratedTemplateCommand).build() {
};
__name(_CreateGeneratedTemplateCommand, "CreateGeneratedTemplateCommand");
var CreateGeneratedTemplateCommand = _CreateGeneratedTemplateCommand;

// src/commands/CreateStackCommand.ts




var _CreateStackCommand = class _CreateStackCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "CreateStack", {}).n("CloudFormationClient", "CreateStackCommand").f(void 0, void 0).ser(se_CreateStackCommand).de(de_CreateStackCommand).build() {
};
__name(_CreateStackCommand, "CreateStackCommand");
var CreateStackCommand = _CreateStackCommand;

// src/commands/CreateStackInstancesCommand.ts




var _CreateStackInstancesCommand = class _CreateStackInstancesCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "CreateStackInstances", {}).n("CloudFormationClient", "CreateStackInstancesCommand").f(void 0, void 0).ser(se_CreateStackInstancesCommand).de(de_CreateStackInstancesCommand).build() {
};
__name(_CreateStackInstancesCommand, "CreateStackInstancesCommand");
var CreateStackInstancesCommand = _CreateStackInstancesCommand;

// src/commands/CreateStackSetCommand.ts




var _CreateStackSetCommand = class _CreateStackSetCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "CreateStackSet", {}).n("CloudFormationClient", "CreateStackSetCommand").f(void 0, void 0).ser(se_CreateStackSetCommand).de(de_CreateStackSetCommand).build() {
};
__name(_CreateStackSetCommand, "CreateStackSetCommand");
var CreateStackSetCommand = _CreateStackSetCommand;

// src/commands/DeactivateOrganizationsAccessCommand.ts




var _DeactivateOrganizationsAccessCommand = class _DeactivateOrganizationsAccessCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DeactivateOrganizationsAccess", {}).n("CloudFormationClient", "DeactivateOrganizationsAccessCommand").f(void 0, void 0).ser(se_DeactivateOrganizationsAccessCommand).de(de_DeactivateOrganizationsAccessCommand).build() {
};
__name(_DeactivateOrganizationsAccessCommand, "DeactivateOrganizationsAccessCommand");
var DeactivateOrganizationsAccessCommand = _DeactivateOrganizationsAccessCommand;

// src/commands/DeactivateTypeCommand.ts




var _DeactivateTypeCommand = class _DeactivateTypeCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DeactivateType", {}).n("CloudFormationClient", "DeactivateTypeCommand").f(void 0, void 0).ser(se_DeactivateTypeCommand).de(de_DeactivateTypeCommand).build() {
};
__name(_DeactivateTypeCommand, "DeactivateTypeCommand");
var DeactivateTypeCommand = _DeactivateTypeCommand;

// src/commands/DeleteChangeSetCommand.ts




var _DeleteChangeSetCommand = class _DeleteChangeSetCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DeleteChangeSet", {}).n("CloudFormationClient", "DeleteChangeSetCommand").f(void 0, void 0).ser(se_DeleteChangeSetCommand).de(de_DeleteChangeSetCommand).build() {
};
__name(_DeleteChangeSetCommand, "DeleteChangeSetCommand");
var DeleteChangeSetCommand = _DeleteChangeSetCommand;

// src/commands/DeleteGeneratedTemplateCommand.ts




var _DeleteGeneratedTemplateCommand = class _DeleteGeneratedTemplateCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DeleteGeneratedTemplate", {}).n("CloudFormationClient", "DeleteGeneratedTemplateCommand").f(void 0, void 0).ser(se_DeleteGeneratedTemplateCommand).de(de_DeleteGeneratedTemplateCommand).build() {
};
__name(_DeleteGeneratedTemplateCommand, "DeleteGeneratedTemplateCommand");
var DeleteGeneratedTemplateCommand = _DeleteGeneratedTemplateCommand;

// src/commands/DeleteStackCommand.ts




var _DeleteStackCommand = class _DeleteStackCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DeleteStack", {}).n("CloudFormationClient", "DeleteStackCommand").f(void 0, void 0).ser(se_DeleteStackCommand).de(de_DeleteStackCommand).build() {
};
__name(_DeleteStackCommand, "DeleteStackCommand");
var DeleteStackCommand = _DeleteStackCommand;

// src/commands/DeleteStackInstancesCommand.ts




var _DeleteStackInstancesCommand = class _DeleteStackInstancesCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DeleteStackInstances", {}).n("CloudFormationClient", "DeleteStackInstancesCommand").f(void 0, void 0).ser(se_DeleteStackInstancesCommand).de(de_DeleteStackInstancesCommand).build() {
};
__name(_DeleteStackInstancesCommand, "DeleteStackInstancesCommand");
var DeleteStackInstancesCommand = _DeleteStackInstancesCommand;

// src/commands/DeleteStackSetCommand.ts




var _DeleteStackSetCommand = class _DeleteStackSetCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DeleteStackSet", {}).n("CloudFormationClient", "DeleteStackSetCommand").f(void 0, void 0).ser(se_DeleteStackSetCommand).de(de_DeleteStackSetCommand).build() {
};
__name(_DeleteStackSetCommand, "DeleteStackSetCommand");
var DeleteStackSetCommand = _DeleteStackSetCommand;

// src/commands/DeregisterTypeCommand.ts




var _DeregisterTypeCommand = class _DeregisterTypeCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DeregisterType", {}).n("CloudFormationClient", "DeregisterTypeCommand").f(void 0, void 0).ser(se_DeregisterTypeCommand).de(de_DeregisterTypeCommand).build() {
};
__name(_DeregisterTypeCommand, "DeregisterTypeCommand");
var DeregisterTypeCommand = _DeregisterTypeCommand;

// src/commands/DescribeAccountLimitsCommand.ts




var _DescribeAccountLimitsCommand = class _DescribeAccountLimitsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeAccountLimits", {}).n("CloudFormationClient", "DescribeAccountLimitsCommand").f(void 0, void 0).ser(se_DescribeAccountLimitsCommand).de(de_DescribeAccountLimitsCommand).build() {
};
__name(_DescribeAccountLimitsCommand, "DescribeAccountLimitsCommand");
var DescribeAccountLimitsCommand = _DescribeAccountLimitsCommand;

// src/commands/DescribeChangeSetCommand.ts




var _DescribeChangeSetCommand = class _DescribeChangeSetCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeChangeSet", {}).n("CloudFormationClient", "DescribeChangeSetCommand").f(void 0, void 0).ser(se_DescribeChangeSetCommand).de(de_DescribeChangeSetCommand).build() {
};
__name(_DescribeChangeSetCommand, "DescribeChangeSetCommand");
var DescribeChangeSetCommand = _DescribeChangeSetCommand;

// src/commands/DescribeChangeSetHooksCommand.ts




var _DescribeChangeSetHooksCommand = class _DescribeChangeSetHooksCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeChangeSetHooks", {}).n("CloudFormationClient", "DescribeChangeSetHooksCommand").f(void 0, void 0).ser(se_DescribeChangeSetHooksCommand).de(de_DescribeChangeSetHooksCommand).build() {
};
__name(_DescribeChangeSetHooksCommand, "DescribeChangeSetHooksCommand");
var DescribeChangeSetHooksCommand = _DescribeChangeSetHooksCommand;

// src/commands/DescribeGeneratedTemplateCommand.ts




var _DescribeGeneratedTemplateCommand = class _DescribeGeneratedTemplateCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeGeneratedTemplate", {}).n("CloudFormationClient", "DescribeGeneratedTemplateCommand").f(void 0, void 0).ser(se_DescribeGeneratedTemplateCommand).de(de_DescribeGeneratedTemplateCommand).build() {
};
__name(_DescribeGeneratedTemplateCommand, "DescribeGeneratedTemplateCommand");
var DescribeGeneratedTemplateCommand = _DescribeGeneratedTemplateCommand;

// src/commands/DescribeOrganizationsAccessCommand.ts




var _DescribeOrganizationsAccessCommand = class _DescribeOrganizationsAccessCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeOrganizationsAccess", {}).n("CloudFormationClient", "DescribeOrganizationsAccessCommand").f(void 0, void 0).ser(se_DescribeOrganizationsAccessCommand).de(de_DescribeOrganizationsAccessCommand).build() {
};
__name(_DescribeOrganizationsAccessCommand, "DescribeOrganizationsAccessCommand");
var DescribeOrganizationsAccessCommand = _DescribeOrganizationsAccessCommand;

// src/commands/DescribePublisherCommand.ts




var _DescribePublisherCommand = class _DescribePublisherCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribePublisher", {}).n("CloudFormationClient", "DescribePublisherCommand").f(void 0, void 0).ser(se_DescribePublisherCommand).de(de_DescribePublisherCommand).build() {
};
__name(_DescribePublisherCommand, "DescribePublisherCommand");
var DescribePublisherCommand = _DescribePublisherCommand;

// src/commands/DescribeResourceScanCommand.ts




var _DescribeResourceScanCommand = class _DescribeResourceScanCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeResourceScan", {}).n("CloudFormationClient", "DescribeResourceScanCommand").f(void 0, void 0).ser(se_DescribeResourceScanCommand).de(de_DescribeResourceScanCommand).build() {
};
__name(_DescribeResourceScanCommand, "DescribeResourceScanCommand");
var DescribeResourceScanCommand = _DescribeResourceScanCommand;

// src/commands/DescribeStackDriftDetectionStatusCommand.ts




var _DescribeStackDriftDetectionStatusCommand = class _DescribeStackDriftDetectionStatusCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeStackDriftDetectionStatus", {}).n("CloudFormationClient", "DescribeStackDriftDetectionStatusCommand").f(void 0, void 0).ser(se_DescribeStackDriftDetectionStatusCommand).de(de_DescribeStackDriftDetectionStatusCommand).build() {
};
__name(_DescribeStackDriftDetectionStatusCommand, "DescribeStackDriftDetectionStatusCommand");
var DescribeStackDriftDetectionStatusCommand = _DescribeStackDriftDetectionStatusCommand;

// src/commands/DescribeStackEventsCommand.ts




var _DescribeStackEventsCommand = class _DescribeStackEventsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeStackEvents", {}).n("CloudFormationClient", "DescribeStackEventsCommand").f(void 0, void 0).ser(se_DescribeStackEventsCommand).de(de_DescribeStackEventsCommand).build() {
};
__name(_DescribeStackEventsCommand, "DescribeStackEventsCommand");
var DescribeStackEventsCommand = _DescribeStackEventsCommand;

// src/commands/DescribeStackInstanceCommand.ts




var _DescribeStackInstanceCommand = class _DescribeStackInstanceCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeStackInstance", {}).n("CloudFormationClient", "DescribeStackInstanceCommand").f(void 0, void 0).ser(se_DescribeStackInstanceCommand).de(de_DescribeStackInstanceCommand).build() {
};
__name(_DescribeStackInstanceCommand, "DescribeStackInstanceCommand");
var DescribeStackInstanceCommand = _DescribeStackInstanceCommand;

// src/commands/DescribeStackResourceCommand.ts




var _DescribeStackResourceCommand = class _DescribeStackResourceCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeStackResource", {}).n("CloudFormationClient", "DescribeStackResourceCommand").f(void 0, void 0).ser(se_DescribeStackResourceCommand).de(de_DescribeStackResourceCommand).build() {
};
__name(_DescribeStackResourceCommand, "DescribeStackResourceCommand");
var DescribeStackResourceCommand = _DescribeStackResourceCommand;

// src/commands/DescribeStackResourceDriftsCommand.ts




var _DescribeStackResourceDriftsCommand = class _DescribeStackResourceDriftsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeStackResourceDrifts", {}).n("CloudFormationClient", "DescribeStackResourceDriftsCommand").f(void 0, void 0).ser(se_DescribeStackResourceDriftsCommand).de(de_DescribeStackResourceDriftsCommand).build() {
};
__name(_DescribeStackResourceDriftsCommand, "DescribeStackResourceDriftsCommand");
var DescribeStackResourceDriftsCommand = _DescribeStackResourceDriftsCommand;

// src/commands/DescribeStackResourcesCommand.ts




var _DescribeStackResourcesCommand = class _DescribeStackResourcesCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeStackResources", {}).n("CloudFormationClient", "DescribeStackResourcesCommand").f(void 0, void 0).ser(se_DescribeStackResourcesCommand).de(de_DescribeStackResourcesCommand).build() {
};
__name(_DescribeStackResourcesCommand, "DescribeStackResourcesCommand");
var DescribeStackResourcesCommand = _DescribeStackResourcesCommand;

// src/commands/DescribeStacksCommand.ts




var _DescribeStacksCommand = class _DescribeStacksCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeStacks", {}).n("CloudFormationClient", "DescribeStacksCommand").f(void 0, void 0).ser(se_DescribeStacksCommand).de(de_DescribeStacksCommand).build() {
};
__name(_DescribeStacksCommand, "DescribeStacksCommand");
var DescribeStacksCommand = _DescribeStacksCommand;

// src/commands/DescribeStackSetCommand.ts




var _DescribeStackSetCommand = class _DescribeStackSetCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeStackSet", {}).n("CloudFormationClient", "DescribeStackSetCommand").f(void 0, void 0).ser(se_DescribeStackSetCommand).de(de_DescribeStackSetCommand).build() {
};
__name(_DescribeStackSetCommand, "DescribeStackSetCommand");
var DescribeStackSetCommand = _DescribeStackSetCommand;

// src/commands/DescribeStackSetOperationCommand.ts




var _DescribeStackSetOperationCommand = class _DescribeStackSetOperationCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeStackSetOperation", {}).n("CloudFormationClient", "DescribeStackSetOperationCommand").f(void 0, void 0).ser(se_DescribeStackSetOperationCommand).de(de_DescribeStackSetOperationCommand).build() {
};
__name(_DescribeStackSetOperationCommand, "DescribeStackSetOperationCommand");
var DescribeStackSetOperationCommand = _DescribeStackSetOperationCommand;

// src/commands/DescribeTypeCommand.ts




var _DescribeTypeCommand = class _DescribeTypeCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeType", {}).n("CloudFormationClient", "DescribeTypeCommand").f(void 0, void 0).ser(se_DescribeTypeCommand).de(de_DescribeTypeCommand).build() {
};
__name(_DescribeTypeCommand, "DescribeTypeCommand");
var DescribeTypeCommand = _DescribeTypeCommand;

// src/commands/DescribeTypeRegistrationCommand.ts




var _DescribeTypeRegistrationCommand = class _DescribeTypeRegistrationCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DescribeTypeRegistration", {}).n("CloudFormationClient", "DescribeTypeRegistrationCommand").f(void 0, void 0).ser(se_DescribeTypeRegistrationCommand).de(de_DescribeTypeRegistrationCommand).build() {
};
__name(_DescribeTypeRegistrationCommand, "DescribeTypeRegistrationCommand");
var DescribeTypeRegistrationCommand = _DescribeTypeRegistrationCommand;

// src/commands/DetectStackDriftCommand.ts




var _DetectStackDriftCommand = class _DetectStackDriftCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DetectStackDrift", {}).n("CloudFormationClient", "DetectStackDriftCommand").f(void 0, void 0).ser(se_DetectStackDriftCommand).de(de_DetectStackDriftCommand).build() {
};
__name(_DetectStackDriftCommand, "DetectStackDriftCommand");
var DetectStackDriftCommand = _DetectStackDriftCommand;

// src/commands/DetectStackResourceDriftCommand.ts




var _DetectStackResourceDriftCommand = class _DetectStackResourceDriftCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DetectStackResourceDrift", {}).n("CloudFormationClient", "DetectStackResourceDriftCommand").f(void 0, void 0).ser(se_DetectStackResourceDriftCommand).de(de_DetectStackResourceDriftCommand).build() {
};
__name(_DetectStackResourceDriftCommand, "DetectStackResourceDriftCommand");
var DetectStackResourceDriftCommand = _DetectStackResourceDriftCommand;

// src/commands/DetectStackSetDriftCommand.ts




var _DetectStackSetDriftCommand = class _DetectStackSetDriftCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "DetectStackSetDrift", {}).n("CloudFormationClient", "DetectStackSetDriftCommand").f(void 0, void 0).ser(se_DetectStackSetDriftCommand).de(de_DetectStackSetDriftCommand).build() {
};
__name(_DetectStackSetDriftCommand, "DetectStackSetDriftCommand");
var DetectStackSetDriftCommand = _DetectStackSetDriftCommand;

// src/commands/EstimateTemplateCostCommand.ts




var _EstimateTemplateCostCommand = class _EstimateTemplateCostCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "EstimateTemplateCost", {}).n("CloudFormationClient", "EstimateTemplateCostCommand").f(void 0, void 0).ser(se_EstimateTemplateCostCommand).de(de_EstimateTemplateCostCommand).build() {
};
__name(_EstimateTemplateCostCommand, "EstimateTemplateCostCommand");
var EstimateTemplateCostCommand = _EstimateTemplateCostCommand;

// src/commands/ExecuteChangeSetCommand.ts




var _ExecuteChangeSetCommand = class _ExecuteChangeSetCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ExecuteChangeSet", {}).n("CloudFormationClient", "ExecuteChangeSetCommand").f(void 0, void 0).ser(se_ExecuteChangeSetCommand).de(de_ExecuteChangeSetCommand).build() {
};
__name(_ExecuteChangeSetCommand, "ExecuteChangeSetCommand");
var ExecuteChangeSetCommand = _ExecuteChangeSetCommand;

// src/commands/GetGeneratedTemplateCommand.ts




var _GetGeneratedTemplateCommand = class _GetGeneratedTemplateCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "GetGeneratedTemplate", {}).n("CloudFormationClient", "GetGeneratedTemplateCommand").f(void 0, void 0).ser(se_GetGeneratedTemplateCommand).de(de_GetGeneratedTemplateCommand).build() {
};
__name(_GetGeneratedTemplateCommand, "GetGeneratedTemplateCommand");
var GetGeneratedTemplateCommand = _GetGeneratedTemplateCommand;

// src/commands/GetStackPolicyCommand.ts




var _GetStackPolicyCommand = class _GetStackPolicyCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "GetStackPolicy", {}).n("CloudFormationClient", "GetStackPolicyCommand").f(void 0, void 0).ser(se_GetStackPolicyCommand).de(de_GetStackPolicyCommand).build() {
};
__name(_GetStackPolicyCommand, "GetStackPolicyCommand");
var GetStackPolicyCommand = _GetStackPolicyCommand;

// src/commands/GetTemplateCommand.ts




var _GetTemplateCommand = class _GetTemplateCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "GetTemplate", {}).n("CloudFormationClient", "GetTemplateCommand").f(void 0, void 0).ser(se_GetTemplateCommand).de(de_GetTemplateCommand).build() {
};
__name(_GetTemplateCommand, "GetTemplateCommand");
var GetTemplateCommand = _GetTemplateCommand;

// src/commands/GetTemplateSummaryCommand.ts




var _GetTemplateSummaryCommand = class _GetTemplateSummaryCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "GetTemplateSummary", {}).n("CloudFormationClient", "GetTemplateSummaryCommand").f(void 0, void 0).ser(se_GetTemplateSummaryCommand).de(de_GetTemplateSummaryCommand).build() {
};
__name(_GetTemplateSummaryCommand, "GetTemplateSummaryCommand");
var GetTemplateSummaryCommand = _GetTemplateSummaryCommand;

// src/commands/ImportStacksToStackSetCommand.ts




var _ImportStacksToStackSetCommand = class _ImportStacksToStackSetCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ImportStacksToStackSet", {}).n("CloudFormationClient", "ImportStacksToStackSetCommand").f(void 0, void 0).ser(se_ImportStacksToStackSetCommand).de(de_ImportStacksToStackSetCommand).build() {
};
__name(_ImportStacksToStackSetCommand, "ImportStacksToStackSetCommand");
var ImportStacksToStackSetCommand = _ImportStacksToStackSetCommand;

// src/commands/ListChangeSetsCommand.ts




var _ListChangeSetsCommand = class _ListChangeSetsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListChangeSets", {}).n("CloudFormationClient", "ListChangeSetsCommand").f(void 0, void 0).ser(se_ListChangeSetsCommand).de(de_ListChangeSetsCommand).build() {
};
__name(_ListChangeSetsCommand, "ListChangeSetsCommand");
var ListChangeSetsCommand = _ListChangeSetsCommand;

// src/commands/ListExportsCommand.ts




var _ListExportsCommand = class _ListExportsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListExports", {}).n("CloudFormationClient", "ListExportsCommand").f(void 0, void 0).ser(se_ListExportsCommand).de(de_ListExportsCommand).build() {
};
__name(_ListExportsCommand, "ListExportsCommand");
var ListExportsCommand = _ListExportsCommand;

// src/commands/ListGeneratedTemplatesCommand.ts




var _ListGeneratedTemplatesCommand = class _ListGeneratedTemplatesCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListGeneratedTemplates", {}).n("CloudFormationClient", "ListGeneratedTemplatesCommand").f(void 0, void 0).ser(se_ListGeneratedTemplatesCommand).de(de_ListGeneratedTemplatesCommand).build() {
};
__name(_ListGeneratedTemplatesCommand, "ListGeneratedTemplatesCommand");
var ListGeneratedTemplatesCommand = _ListGeneratedTemplatesCommand;

// src/commands/ListImportsCommand.ts




var _ListImportsCommand = class _ListImportsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListImports", {}).n("CloudFormationClient", "ListImportsCommand").f(void 0, void 0).ser(se_ListImportsCommand).de(de_ListImportsCommand).build() {
};
__name(_ListImportsCommand, "ListImportsCommand");
var ListImportsCommand = _ListImportsCommand;

// src/commands/ListResourceScanRelatedResourcesCommand.ts




var _ListResourceScanRelatedResourcesCommand = class _ListResourceScanRelatedResourcesCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListResourceScanRelatedResources", {}).n("CloudFormationClient", "ListResourceScanRelatedResourcesCommand").f(void 0, void 0).ser(se_ListResourceScanRelatedResourcesCommand).de(de_ListResourceScanRelatedResourcesCommand).build() {
};
__name(_ListResourceScanRelatedResourcesCommand, "ListResourceScanRelatedResourcesCommand");
var ListResourceScanRelatedResourcesCommand = _ListResourceScanRelatedResourcesCommand;

// src/commands/ListResourceScanResourcesCommand.ts




var _ListResourceScanResourcesCommand = class _ListResourceScanResourcesCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListResourceScanResources", {}).n("CloudFormationClient", "ListResourceScanResourcesCommand").f(void 0, void 0).ser(se_ListResourceScanResourcesCommand).de(de_ListResourceScanResourcesCommand).build() {
};
__name(_ListResourceScanResourcesCommand, "ListResourceScanResourcesCommand");
var ListResourceScanResourcesCommand = _ListResourceScanResourcesCommand;

// src/commands/ListResourceScansCommand.ts




var _ListResourceScansCommand = class _ListResourceScansCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListResourceScans", {}).n("CloudFormationClient", "ListResourceScansCommand").f(void 0, void 0).ser(se_ListResourceScansCommand).de(de_ListResourceScansCommand).build() {
};
__name(_ListResourceScansCommand, "ListResourceScansCommand");
var ListResourceScansCommand = _ListResourceScansCommand;

// src/commands/ListStackInstanceResourceDriftsCommand.ts




var _ListStackInstanceResourceDriftsCommand = class _ListStackInstanceResourceDriftsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListStackInstanceResourceDrifts", {}).n("CloudFormationClient", "ListStackInstanceResourceDriftsCommand").f(void 0, void 0).ser(se_ListStackInstanceResourceDriftsCommand).de(de_ListStackInstanceResourceDriftsCommand).build() {
};
__name(_ListStackInstanceResourceDriftsCommand, "ListStackInstanceResourceDriftsCommand");
var ListStackInstanceResourceDriftsCommand = _ListStackInstanceResourceDriftsCommand;

// src/commands/ListStackInstancesCommand.ts




var _ListStackInstancesCommand = class _ListStackInstancesCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListStackInstances", {}).n("CloudFormationClient", "ListStackInstancesCommand").f(void 0, void 0).ser(se_ListStackInstancesCommand).de(de_ListStackInstancesCommand).build() {
};
__name(_ListStackInstancesCommand, "ListStackInstancesCommand");
var ListStackInstancesCommand = _ListStackInstancesCommand;

// src/commands/ListStackResourcesCommand.ts




var _ListStackResourcesCommand = class _ListStackResourcesCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListStackResources", {}).n("CloudFormationClient", "ListStackResourcesCommand").f(void 0, void 0).ser(se_ListStackResourcesCommand).de(de_ListStackResourcesCommand).build() {
};
__name(_ListStackResourcesCommand, "ListStackResourcesCommand");
var ListStackResourcesCommand = _ListStackResourcesCommand;

// src/commands/ListStacksCommand.ts




var _ListStacksCommand = class _ListStacksCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListStacks", {}).n("CloudFormationClient", "ListStacksCommand").f(void 0, void 0).ser(se_ListStacksCommand).de(de_ListStacksCommand).build() {
};
__name(_ListStacksCommand, "ListStacksCommand");
var ListStacksCommand = _ListStacksCommand;

// src/commands/ListStackSetAutoDeploymentTargetsCommand.ts




var _ListStackSetAutoDeploymentTargetsCommand = class _ListStackSetAutoDeploymentTargetsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListStackSetAutoDeploymentTargets", {}).n("CloudFormationClient", "ListStackSetAutoDeploymentTargetsCommand").f(void 0, void 0).ser(se_ListStackSetAutoDeploymentTargetsCommand).de(de_ListStackSetAutoDeploymentTargetsCommand).build() {
};
__name(_ListStackSetAutoDeploymentTargetsCommand, "ListStackSetAutoDeploymentTargetsCommand");
var ListStackSetAutoDeploymentTargetsCommand = _ListStackSetAutoDeploymentTargetsCommand;

// src/commands/ListStackSetOperationResultsCommand.ts




var _ListStackSetOperationResultsCommand = class _ListStackSetOperationResultsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListStackSetOperationResults", {}).n("CloudFormationClient", "ListStackSetOperationResultsCommand").f(void 0, void 0).ser(se_ListStackSetOperationResultsCommand).de(de_ListStackSetOperationResultsCommand).build() {
};
__name(_ListStackSetOperationResultsCommand, "ListStackSetOperationResultsCommand");
var ListStackSetOperationResultsCommand = _ListStackSetOperationResultsCommand;

// src/commands/ListStackSetOperationsCommand.ts




var _ListStackSetOperationsCommand = class _ListStackSetOperationsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListStackSetOperations", {}).n("CloudFormationClient", "ListStackSetOperationsCommand").f(void 0, void 0).ser(se_ListStackSetOperationsCommand).de(de_ListStackSetOperationsCommand).build() {
};
__name(_ListStackSetOperationsCommand, "ListStackSetOperationsCommand");
var ListStackSetOperationsCommand = _ListStackSetOperationsCommand;

// src/commands/ListStackSetsCommand.ts




var _ListStackSetsCommand = class _ListStackSetsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListStackSets", {}).n("CloudFormationClient", "ListStackSetsCommand").f(void 0, void 0).ser(se_ListStackSetsCommand).de(de_ListStackSetsCommand).build() {
};
__name(_ListStackSetsCommand, "ListStackSetsCommand");
var ListStackSetsCommand = _ListStackSetsCommand;

// src/commands/ListTypeRegistrationsCommand.ts




var _ListTypeRegistrationsCommand = class _ListTypeRegistrationsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListTypeRegistrations", {}).n("CloudFormationClient", "ListTypeRegistrationsCommand").f(void 0, void 0).ser(se_ListTypeRegistrationsCommand).de(de_ListTypeRegistrationsCommand).build() {
};
__name(_ListTypeRegistrationsCommand, "ListTypeRegistrationsCommand");
var ListTypeRegistrationsCommand = _ListTypeRegistrationsCommand;

// src/commands/ListTypesCommand.ts




var _ListTypesCommand = class _ListTypesCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListTypes", {}).n("CloudFormationClient", "ListTypesCommand").f(void 0, void 0).ser(se_ListTypesCommand).de(de_ListTypesCommand).build() {
};
__name(_ListTypesCommand, "ListTypesCommand");
var ListTypesCommand = _ListTypesCommand;

// src/commands/ListTypeVersionsCommand.ts




var _ListTypeVersionsCommand = class _ListTypeVersionsCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ListTypeVersions", {}).n("CloudFormationClient", "ListTypeVersionsCommand").f(void 0, void 0).ser(se_ListTypeVersionsCommand).de(de_ListTypeVersionsCommand).build() {
};
__name(_ListTypeVersionsCommand, "ListTypeVersionsCommand");
var ListTypeVersionsCommand = _ListTypeVersionsCommand;

// src/commands/PublishTypeCommand.ts




var _PublishTypeCommand = class _PublishTypeCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "PublishType", {}).n("CloudFormationClient", "PublishTypeCommand").f(void 0, void 0).ser(se_PublishTypeCommand).de(de_PublishTypeCommand).build() {
};
__name(_PublishTypeCommand, "PublishTypeCommand");
var PublishTypeCommand = _PublishTypeCommand;

// src/commands/RecordHandlerProgressCommand.ts




var _RecordHandlerProgressCommand = class _RecordHandlerProgressCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "RecordHandlerProgress", {}).n("CloudFormationClient", "RecordHandlerProgressCommand").f(void 0, void 0).ser(se_RecordHandlerProgressCommand).de(de_RecordHandlerProgressCommand).build() {
};
__name(_RecordHandlerProgressCommand, "RecordHandlerProgressCommand");
var RecordHandlerProgressCommand = _RecordHandlerProgressCommand;

// src/commands/RegisterPublisherCommand.ts




var _RegisterPublisherCommand = class _RegisterPublisherCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "RegisterPublisher", {}).n("CloudFormationClient", "RegisterPublisherCommand").f(void 0, void 0).ser(se_RegisterPublisherCommand).de(de_RegisterPublisherCommand).build() {
};
__name(_RegisterPublisherCommand, "RegisterPublisherCommand");
var RegisterPublisherCommand = _RegisterPublisherCommand;

// src/commands/RegisterTypeCommand.ts




var _RegisterTypeCommand = class _RegisterTypeCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "RegisterType", {}).n("CloudFormationClient", "RegisterTypeCommand").f(void 0, void 0).ser(se_RegisterTypeCommand).de(de_RegisterTypeCommand).build() {
};
__name(_RegisterTypeCommand, "RegisterTypeCommand");
var RegisterTypeCommand = _RegisterTypeCommand;

// src/commands/RollbackStackCommand.ts




var _RollbackStackCommand = class _RollbackStackCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "RollbackStack", {}).n("CloudFormationClient", "RollbackStackCommand").f(void 0, void 0).ser(se_RollbackStackCommand).de(de_RollbackStackCommand).build() {
};
__name(_RollbackStackCommand, "RollbackStackCommand");
var RollbackStackCommand = _RollbackStackCommand;

// src/commands/SetStackPolicyCommand.ts




var _SetStackPolicyCommand = class _SetStackPolicyCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "SetStackPolicy", {}).n("CloudFormationClient", "SetStackPolicyCommand").f(void 0, void 0).ser(se_SetStackPolicyCommand).de(de_SetStackPolicyCommand).build() {
};
__name(_SetStackPolicyCommand, "SetStackPolicyCommand");
var SetStackPolicyCommand = _SetStackPolicyCommand;

// src/commands/SetTypeConfigurationCommand.ts




var _SetTypeConfigurationCommand = class _SetTypeConfigurationCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "SetTypeConfiguration", {}).n("CloudFormationClient", "SetTypeConfigurationCommand").f(void 0, void 0).ser(se_SetTypeConfigurationCommand).de(de_SetTypeConfigurationCommand).build() {
};
__name(_SetTypeConfigurationCommand, "SetTypeConfigurationCommand");
var SetTypeConfigurationCommand = _SetTypeConfigurationCommand;

// src/commands/SetTypeDefaultVersionCommand.ts




var _SetTypeDefaultVersionCommand = class _SetTypeDefaultVersionCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "SetTypeDefaultVersion", {}).n("CloudFormationClient", "SetTypeDefaultVersionCommand").f(void 0, void 0).ser(se_SetTypeDefaultVersionCommand).de(de_SetTypeDefaultVersionCommand).build() {
};
__name(_SetTypeDefaultVersionCommand, "SetTypeDefaultVersionCommand");
var SetTypeDefaultVersionCommand = _SetTypeDefaultVersionCommand;

// src/commands/SignalResourceCommand.ts




var _SignalResourceCommand = class _SignalResourceCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "SignalResource", {}).n("CloudFormationClient", "SignalResourceCommand").f(void 0, void 0).ser(se_SignalResourceCommand).de(de_SignalResourceCommand).build() {
};
__name(_SignalResourceCommand, "SignalResourceCommand");
var SignalResourceCommand = _SignalResourceCommand;

// src/commands/StartResourceScanCommand.ts




var _StartResourceScanCommand = class _StartResourceScanCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "StartResourceScan", {}).n("CloudFormationClient", "StartResourceScanCommand").f(void 0, void 0).ser(se_StartResourceScanCommand).de(de_StartResourceScanCommand).build() {
};
__name(_StartResourceScanCommand, "StartResourceScanCommand");
var StartResourceScanCommand = _StartResourceScanCommand;

// src/commands/StopStackSetOperationCommand.ts




var _StopStackSetOperationCommand = class _StopStackSetOperationCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "StopStackSetOperation", {}).n("CloudFormationClient", "StopStackSetOperationCommand").f(void 0, void 0).ser(se_StopStackSetOperationCommand).de(de_StopStackSetOperationCommand).build() {
};
__name(_StopStackSetOperationCommand, "StopStackSetOperationCommand");
var StopStackSetOperationCommand = _StopStackSetOperationCommand;

// src/commands/TestTypeCommand.ts




var _TestTypeCommand = class _TestTypeCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "TestType", {}).n("CloudFormationClient", "TestTypeCommand").f(void 0, void 0).ser(se_TestTypeCommand).de(de_TestTypeCommand).build() {
};
__name(_TestTypeCommand, "TestTypeCommand");
var TestTypeCommand = _TestTypeCommand;

// src/commands/UpdateGeneratedTemplateCommand.ts




var _UpdateGeneratedTemplateCommand = class _UpdateGeneratedTemplateCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "UpdateGeneratedTemplate", {}).n("CloudFormationClient", "UpdateGeneratedTemplateCommand").f(void 0, void 0).ser(se_UpdateGeneratedTemplateCommand).de(de_UpdateGeneratedTemplateCommand).build() {
};
__name(_UpdateGeneratedTemplateCommand, "UpdateGeneratedTemplateCommand");
var UpdateGeneratedTemplateCommand = _UpdateGeneratedTemplateCommand;

// src/commands/UpdateStackCommand.ts




var _UpdateStackCommand = class _UpdateStackCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "UpdateStack", {}).n("CloudFormationClient", "UpdateStackCommand").f(void 0, void 0).ser(se_UpdateStackCommand).de(de_UpdateStackCommand).build() {
};
__name(_UpdateStackCommand, "UpdateStackCommand");
var UpdateStackCommand = _UpdateStackCommand;

// src/commands/UpdateStackInstancesCommand.ts




var _UpdateStackInstancesCommand = class _UpdateStackInstancesCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "UpdateStackInstances", {}).n("CloudFormationClient", "UpdateStackInstancesCommand").f(void 0, void 0).ser(se_UpdateStackInstancesCommand).de(de_UpdateStackInstancesCommand).build() {
};
__name(_UpdateStackInstancesCommand, "UpdateStackInstancesCommand");
var UpdateStackInstancesCommand = _UpdateStackInstancesCommand;

// src/commands/UpdateStackSetCommand.ts




var _UpdateStackSetCommand = class _UpdateStackSetCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "UpdateStackSet", {}).n("CloudFormationClient", "UpdateStackSetCommand").f(void 0, void 0).ser(se_UpdateStackSetCommand).de(de_UpdateStackSetCommand).build() {
};
__name(_UpdateStackSetCommand, "UpdateStackSetCommand");
var UpdateStackSetCommand = _UpdateStackSetCommand;

// src/commands/UpdateTerminationProtectionCommand.ts




var _UpdateTerminationProtectionCommand = class _UpdateTerminationProtectionCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "UpdateTerminationProtection", {}).n("CloudFormationClient", "UpdateTerminationProtectionCommand").f(void 0, void 0).ser(se_UpdateTerminationProtectionCommand).de(de_UpdateTerminationProtectionCommand).build() {
};
__name(_UpdateTerminationProtectionCommand, "UpdateTerminationProtectionCommand");
var UpdateTerminationProtectionCommand = _UpdateTerminationProtectionCommand;

// src/commands/ValidateTemplateCommand.ts




var _ValidateTemplateCommand = class _ValidateTemplateCommand extends import_smithy_client.Command.classBuilder().ep({
  ...commonParams
}).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("CloudFormation", "ValidateTemplate", {}).n("CloudFormationClient", "ValidateTemplateCommand").f(void 0, void 0).ser(se_ValidateTemplateCommand).de(de_ValidateTemplateCommand).build() {
};
__name(_ValidateTemplateCommand, "ValidateTemplateCommand");
var ValidateTemplateCommand = _ValidateTemplateCommand;

// src/CloudFormation.ts
var commands = {
  ActivateOrganizationsAccessCommand,
  ActivateTypeCommand,
  BatchDescribeTypeConfigurationsCommand,
  CancelUpdateStackCommand,
  ContinueUpdateRollbackCommand,
  CreateChangeSetCommand,
  CreateGeneratedTemplateCommand,
  CreateStackCommand,
  CreateStackInstancesCommand,
  CreateStackSetCommand,
  DeactivateOrganizationsAccessCommand,
  DeactivateTypeCommand,
  DeleteChangeSetCommand,
  DeleteGeneratedTemplateCommand,
  DeleteStackCommand,
  DeleteStackInstancesCommand,
  DeleteStackSetCommand,
  DeregisterTypeCommand,
  DescribeAccountLimitsCommand,
  DescribeChangeSetCommand,
  DescribeChangeSetHooksCommand,
  DescribeGeneratedTemplateCommand,
  DescribeOrganizationsAccessCommand,
  DescribePublisherCommand,
  DescribeResourceScanCommand,
  DescribeStackDriftDetectionStatusCommand,
  DescribeStackEventsCommand,
  DescribeStackInstanceCommand,
  DescribeStackResourceCommand,
  DescribeStackResourceDriftsCommand,
  DescribeStackResourcesCommand,
  DescribeStacksCommand,
  DescribeStackSetCommand,
  DescribeStackSetOperationCommand,
  DescribeTypeCommand,
  DescribeTypeRegistrationCommand,
  DetectStackDriftCommand,
  DetectStackResourceDriftCommand,
  DetectStackSetDriftCommand,
  EstimateTemplateCostCommand,
  ExecuteChangeSetCommand,
  GetGeneratedTemplateCommand,
  GetStackPolicyCommand,
  GetTemplateCommand,
  GetTemplateSummaryCommand,
  ImportStacksToStackSetCommand,
  ListChangeSetsCommand,
  ListExportsCommand,
  ListGeneratedTemplatesCommand,
  ListImportsCommand,
  ListResourceScanRelatedResourcesCommand,
  ListResourceScanResourcesCommand,
  ListResourceScansCommand,
  ListStackInstanceResourceDriftsCommand,
  ListStackInstancesCommand,
  ListStackResourcesCommand,
  ListStacksCommand,
  ListStackSetAutoDeploymentTargetsCommand,
  ListStackSetOperationResultsCommand,
  ListStackSetOperationsCommand,
  ListStackSetsCommand,
  ListTypeRegistrationsCommand,
  ListTypesCommand,
  ListTypeVersionsCommand,
  PublishTypeCommand,
  RecordHandlerProgressCommand,
  RegisterPublisherCommand,
  RegisterTypeCommand,
  RollbackStackCommand,
  SetStackPolicyCommand,
  SetTypeConfigurationCommand,
  SetTypeDefaultVersionCommand,
  SignalResourceCommand,
  StartResourceScanCommand,
  StopStackSetOperationCommand,
  TestTypeCommand,
  UpdateGeneratedTemplateCommand,
  UpdateStackCommand,
  UpdateStackInstancesCommand,
  UpdateStackSetCommand,
  UpdateTerminationProtectionCommand,
  ValidateTemplateCommand
};
var _CloudFormation = class _CloudFormation extends CloudFormationClient {
};
__name(_CloudFormation, "CloudFormation");
var CloudFormation = _CloudFormation;
(0, import_smithy_client.createAggregatedClient)(commands, CloudFormation);

// src/pagination/DescribeAccountLimitsPaginator.ts

var paginateDescribeAccountLimits = (0, import_core.createPaginator)(CloudFormationClient, DescribeAccountLimitsCommand, "NextToken", "NextToken", "");

// src/pagination/DescribeStackEventsPaginator.ts

var paginateDescribeStackEvents = (0, import_core.createPaginator)(CloudFormationClient, DescribeStackEventsCommand, "NextToken", "NextToken", "");

// src/pagination/DescribeStackResourceDriftsPaginator.ts

var paginateDescribeStackResourceDrifts = (0, import_core.createPaginator)(CloudFormationClient, DescribeStackResourceDriftsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/DescribeStacksPaginator.ts

var paginateDescribeStacks = (0, import_core.createPaginator)(CloudFormationClient, DescribeStacksCommand, "NextToken", "NextToken", "");

// src/pagination/ListChangeSetsPaginator.ts

var paginateListChangeSets = (0, import_core.createPaginator)(CloudFormationClient, ListChangeSetsCommand, "NextToken", "NextToken", "");

// src/pagination/ListExportsPaginator.ts

var paginateListExports = (0, import_core.createPaginator)(CloudFormationClient, ListExportsCommand, "NextToken", "NextToken", "");

// src/pagination/ListGeneratedTemplatesPaginator.ts

var paginateListGeneratedTemplates = (0, import_core.createPaginator)(CloudFormationClient, ListGeneratedTemplatesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListImportsPaginator.ts

var paginateListImports = (0, import_core.createPaginator)(CloudFormationClient, ListImportsCommand, "NextToken", "NextToken", "");

// src/pagination/ListResourceScanRelatedResourcesPaginator.ts

var paginateListResourceScanRelatedResources = (0, import_core.createPaginator)(CloudFormationClient, ListResourceScanRelatedResourcesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListResourceScanResourcesPaginator.ts

var paginateListResourceScanResources = (0, import_core.createPaginator)(CloudFormationClient, ListResourceScanResourcesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListResourceScansPaginator.ts

var paginateListResourceScans = (0, import_core.createPaginator)(CloudFormationClient, ListResourceScansCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListStackInstancesPaginator.ts

var paginateListStackInstances = (0, import_core.createPaginator)(CloudFormationClient, ListStackInstancesCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListStackResourcesPaginator.ts

var paginateListStackResources = (0, import_core.createPaginator)(CloudFormationClient, ListStackResourcesCommand, "NextToken", "NextToken", "");

// src/pagination/ListStackSetOperationResultsPaginator.ts

var paginateListStackSetOperationResults = (0, import_core.createPaginator)(CloudFormationClient, ListStackSetOperationResultsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListStackSetOperationsPaginator.ts

var paginateListStackSetOperations = (0, import_core.createPaginator)(CloudFormationClient, ListStackSetOperationsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListStackSetsPaginator.ts

var paginateListStackSets = (0, import_core.createPaginator)(CloudFormationClient, ListStackSetsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListStacksPaginator.ts

var paginateListStacks = (0, import_core.createPaginator)(CloudFormationClient, ListStacksCommand, "NextToken", "NextToken", "");

// src/pagination/ListTypeRegistrationsPaginator.ts

var paginateListTypeRegistrations = (0, import_core.createPaginator)(CloudFormationClient, ListTypeRegistrationsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListTypeVersionsPaginator.ts

var paginateListTypeVersions = (0, import_core.createPaginator)(CloudFormationClient, ListTypeVersionsCommand, "NextToken", "NextToken", "MaxResults");

// src/pagination/ListTypesPaginator.ts

var paginateListTypes = (0, import_core.createPaginator)(CloudFormationClient, ListTypesCommand, "NextToken", "NextToken", "MaxResults");

// src/waiters/waitForChangeSetCreateComplete.ts
var import_util_waiter = require("@smithy/util-waiter");
var checkState = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeChangeSetCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.Status;
      }, "returnComparator");
      if (returnComparator() === "CREATE_COMPLETE") {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.Status;
      }, "returnComparator");
      if (returnComparator() === "FAILED") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "ValidationError") {
      return { state: import_util_waiter.WaiterState.FAILURE, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForChangeSetCreateComplete = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
}, "waitForChangeSetCreateComplete");
var waitUntilChangeSetCreateComplete = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilChangeSetCreateComplete");

// src/waiters/waitForStackCreateComplete.ts

var checkState2 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeStacksCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "CREATE_COMPLETE";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "UPDATE_COMPLETE";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "UPDATE_IN_PROGRESS";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "UPDATE_FAILED";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "UPDATE_ROLLBACK_IN_PROGRESS";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "UPDATE_ROLLBACK_FAILED";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "UPDATE_ROLLBACK_COMPLETE";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "CREATE_FAILED") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "DELETE_COMPLETE") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "DELETE_FAILED") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "ROLLBACK_FAILED") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "ROLLBACK_COMPLETE") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "ValidationError") {
      return { state: import_util_waiter.WaiterState.FAILURE, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForStackCreateComplete = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState2);
}, "waitForStackCreateComplete");
var waitUntilStackCreateComplete = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState2);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilStackCreateComplete");

// src/waiters/waitForStackDeleteComplete.ts

var checkState3 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeStacksCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "DELETE_COMPLETE";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "DELETE_FAILED") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "CREATE_FAILED") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "ROLLBACK_FAILED") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "UPDATE_ROLLBACK_IN_PROGRESS") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "UPDATE_ROLLBACK_FAILED") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "UPDATE_ROLLBACK_COMPLETE") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "UPDATE_COMPLETE") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "ValidationError") {
      return { state: import_util_waiter.WaiterState.SUCCESS, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForStackDeleteComplete = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState3);
}, "waitForStackDeleteComplete");
var waitUntilStackDeleteComplete = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState3);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilStackDeleteComplete");

// src/waiters/waitForStackExists.ts

var checkState4 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeStacksCommand(input));
    reason = result;
    return { state: import_util_waiter.WaiterState.SUCCESS, reason };
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "ValidationError") {
      return { state: import_util_waiter.WaiterState.RETRY, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForStackExists = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 5, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState4);
}, "waitForStackExists");
var waitUntilStackExists = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 5, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState4);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilStackExists");

// src/waiters/waitForStackImportComplete.ts

var checkState5 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeStacksCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "IMPORT_COMPLETE";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "ROLLBACK_COMPLETE") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "ROLLBACK_FAILED") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "IMPORT_ROLLBACK_IN_PROGRESS") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "IMPORT_ROLLBACK_FAILED") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "IMPORT_ROLLBACK_COMPLETE") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "ValidationError") {
      return { state: import_util_waiter.WaiterState.FAILURE, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForStackImportComplete = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState5);
}, "waitForStackImportComplete");
var waitUntilStackImportComplete = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState5);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilStackImportComplete");

// src/waiters/waitForStackRollbackComplete.ts

var checkState6 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeStacksCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "UPDATE_ROLLBACK_COMPLETE";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "UPDATE_FAILED") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "UPDATE_ROLLBACK_FAILED") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "DELETE_FAILED") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "ValidationError") {
      return { state: import_util_waiter.WaiterState.FAILURE, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForStackRollbackComplete = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState6);
}, "waitForStackRollbackComplete");
var waitUntilStackRollbackComplete = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState6);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilStackRollbackComplete");

// src/waiters/waitForStackUpdateComplete.ts

var checkState7 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeStacksCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "UPDATE_COMPLETE";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "UPDATE_FAILED") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "UPDATE_ROLLBACK_FAILED") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.Stacks);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.StackStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "UPDATE_ROLLBACK_COMPLETE") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "ValidationError") {
      return { state: import_util_waiter.WaiterState.FAILURE, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForStackUpdateComplete = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState7);
}, "waitForStackUpdateComplete");
var waitUntilStackUpdateComplete = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState7);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilStackUpdateComplete");

// src/waiters/waitForTypeRegistrationComplete.ts

var checkState8 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeTypeRegistrationCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.ProgressStatus;
      }, "returnComparator");
      if (returnComparator() === "COMPLETE") {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.ProgressStatus;
      }, "returnComparator");
      if (returnComparator() === "FAILED") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForTypeRegistrationComplete = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState8);
}, "waitForTypeRegistrationComplete");
var waitUntilTypeRegistrationComplete = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState8);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilTypeRegistrationComplete");
// Annotate the CommonJS export names for ESM import in node:

0 && (module.exports = {
  CloudFormationServiceException,
  __Client,
  CloudFormationClient,
  CloudFormation,
  $Command,
  ActivateOrganizationsAccessCommand,
  ActivateTypeCommand,
  BatchDescribeTypeConfigurationsCommand,
  CancelUpdateStackCommand,
  ContinueUpdateRollbackCommand,
  CreateChangeSetCommand,
  CreateGeneratedTemplateCommand,
  CreateStackCommand,
  CreateStackInstancesCommand,
  CreateStackSetCommand,
  DeactivateOrganizationsAccessCommand,
  DeactivateTypeCommand,
  DeleteChangeSetCommand,
  DeleteGeneratedTemplateCommand,
  DeleteStackCommand,
  DeleteStackInstancesCommand,
  DeleteStackSetCommand,
  DeregisterTypeCommand,
  DescribeAccountLimitsCommand,
  DescribeChangeSetCommand,
  DescribeChangeSetHooksCommand,
  DescribeGeneratedTemplateCommand,
  DescribeOrganizationsAccessCommand,
  DescribePublisherCommand,
  DescribeResourceScanCommand,
  DescribeStackDriftDetectionStatusCommand,
  DescribeStackEventsCommand,
  DescribeStackInstanceCommand,
  DescribeStackResourceCommand,
  DescribeStackResourceDriftsCommand,
  DescribeStackResourcesCommand,
  DescribeStackSetCommand,
  DescribeStackSetOperationCommand,
  DescribeStacksCommand,
  DescribeTypeCommand,
  DescribeTypeRegistrationCommand,
  DetectStackDriftCommand,
  DetectStackResourceDriftCommand,
  DetectStackSetDriftCommand,
  EstimateTemplateCostCommand,
  ExecuteChangeSetCommand,
  GetGeneratedTemplateCommand,
  GetStackPolicyCommand,
  GetTemplateCommand,
  GetTemplateSummaryCommand,
  ImportStacksToStackSetCommand,
  ListChangeSetsCommand,
  ListExportsCommand,
  ListGeneratedTemplatesCommand,
  ListImportsCommand,
  ListResourceScanRelatedResourcesCommand,
  ListResourceScanResourcesCommand,
  ListResourceScansCommand,
  ListStackInstanceResourceDriftsCommand,
  ListStackInstancesCommand,
  ListStackResourcesCommand,
  ListStackSetAutoDeploymentTargetsCommand,
  ListStackSetOperationResultsCommand,
  ListStackSetOperationsCommand,
  ListStackSetsCommand,
  ListStacksCommand,
  ListTypeRegistrationsCommand,
  ListTypeVersionsCommand,
  ListTypesCommand,
  PublishTypeCommand,
  RecordHandlerProgressCommand,
  RegisterPublisherCommand,
  RegisterTypeCommand,
  RollbackStackCommand,
  SetStackPolicyCommand,
  SetTypeConfigurationCommand,
  SetTypeDefaultVersionCommand,
  SignalResourceCommand,
  StartResourceScanCommand,
  StopStackSetOperationCommand,
  TestTypeCommand,
  UpdateGeneratedTemplateCommand,
  UpdateStackCommand,
  UpdateStackInstancesCommand,
  UpdateStackSetCommand,
  UpdateTerminationProtectionCommand,
  ValidateTemplateCommand,
  paginateDescribeAccountLimits,
  paginateDescribeStackEvents,
  paginateDescribeStackResourceDrifts,
  paginateDescribeStacks,
  paginateListChangeSets,
  paginateListExports,
  paginateListGeneratedTemplates,
  paginateListImports,
  paginateListResourceScanRelatedResources,
  paginateListResourceScanResources,
  paginateListResourceScans,
  paginateListStackInstances,
  paginateListStackResources,
  paginateListStackSetOperationResults,
  paginateListStackSetOperations,
  paginateListStackSets,
  paginateListStacks,
  paginateListTypeRegistrations,
  paginateListTypeVersions,
  paginateListTypes,
  waitForChangeSetCreateComplete,
  waitUntilChangeSetCreateComplete,
  waitForStackCreateComplete,
  waitUntilStackCreateComplete,
  waitForStackDeleteComplete,
  waitUntilStackDeleteComplete,
  waitForStackExists,
  waitUntilStackExists,
  waitForStackImportComplete,
  waitUntilStackImportComplete,
  waitForStackRollbackComplete,
  waitUntilStackRollbackComplete,
  waitForStackUpdateComplete,
  waitUntilStackUpdateComplete,
  waitForTypeRegistrationComplete,
  waitUntilTypeRegistrationComplete,
  AccountFilterType,
  AccountGateStatus,
  InvalidOperationException,
  OperationNotFoundException,
  ThirdPartyType,
  VersionBump,
  CFNRegistryException,
  TypeNotFoundException,
  AlreadyExistsException,
  AttributeChangeType,
  TypeConfigurationNotFoundException,
  CallAs,
  TokenAlreadyExistsException,
  Capability,
  Category,
  ChangeAction,
  ChangeSource,
  EvaluationType,
  ResourceAttribute,
  RequiresRecreation,
  PolicyAction,
  Replacement,
  ChangeType,
  HookFailureMode,
  HookInvocationPoint,
  HookTargetType,
  ChangeSetHooksStatus,
  ChangeSetNotFoundException,
  ChangeSetStatus,
  ExecutionStatus,
  ChangeSetType,
  OnStackFailure,
  InsufficientCapabilitiesException,
  LimitExceededException,
  ConcurrentResourcesLimitExceededException,
  GeneratedTemplateDeletionPolicy,
  GeneratedTemplateUpdateReplacePolicy,
  OnFailure,
  ConcurrencyMode,
  RegionConcurrencyType,
  OperationIdAlreadyExistsException,
  OperationInProgressException,
  StackSetNotFoundException,
  StaleRequestException,
  CreatedButModifiedException,
  PermissionModels,
  NameAlreadyExistsException,
  InvalidChangeSetStatusException,
  GeneratedTemplateNotFoundException,
  StackSetNotEmptyException,
  RegistryType,
  GeneratedTemplateResourceStatus,
  WarningType,
  GeneratedTemplateStatus,
  OrganizationStatus,
  IdentityProvider,
  PublisherStatus,
  ResourceScanStatus,
  ResourceScanNotFoundException,
  StackDriftDetectionStatus,
  StackDriftStatus,
  DetailedStatus,
  HookStatus,
  ResourceStatus,
  StackInstanceDetailedStatus,
  StackInstanceStatus,
  StackInstanceNotFoundException,
  StackResourceDriftStatus,
  DifferenceType,
  StackStatus,
  StackSetDriftDetectionStatus,
  StackSetDriftStatus,
  StackSetStatus,
  StackSetOperationAction,
  StackSetOperationStatus,
  DeprecatedStatus,
  ProvisioningType,
  TypeTestsStatus,
  Visibility,
  RegistrationStatus,
  TemplateFormat,
  TemplateStage,
  StackNotFoundException,
  ResourceScanInProgressException,
  StackInstanceFilterName,
  OperationResultFilterName,
  StackSetOperationResultStatus,
  InvalidStateTransitionException,
  OperationStatusCheckFailedException,
  OperationStatus,
  HandlerErrorCode,
  ResourceSignalStatus,
  ResourceScanLimitExceededException
});

