import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_BatchDescribeTypeConfigurationsCommand, se_BatchDescribeTypeConfigurationsCommand, } from "../protocols/Aws_query";
export { $Command };
export class BatchDescribeTypeConfigurationsCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "BatchDescribeTypeConfigurations", {})
    .n("CloudFormationClient", "BatchDescribeTypeConfigurationsCommand")
    .f(void 0, void 0)
    .ser(se_BatchDescribeTypeConfigurationsCommand)
    .de(de_BatchDescribeTypeConfigurationsCommand)
    .build() {
}
