import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DeactivateOrganizationsAccessCommand, se_DeactivateOrganizationsAccessCommand, } from "../protocols/Aws_query";
export { $Command };
export class DeactivateOrganizationsAccessCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "DeactivateOrganizationsAccess", {})
    .n("CloudFormationClient", "DeactivateOrganizationsAccessCommand")
    .f(void 0, void 0)
    .ser(se_DeactivateOrganizationsAccessCommand)
    .de(de_DeactivateOrganizationsAccessCommand)
    .build() {
}
