import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DescribeGeneratedTemplateCommand, se_DescribeGeneratedTemplateCommand } from "../protocols/Aws_query";
export { $Command };
export class DescribeGeneratedTemplateCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "DescribeGeneratedTemplate", {})
    .n("CloudFormationClient", "DescribeGeneratedTemplateCommand")
    .f(void 0, void 0)
    .ser(se_DescribeGeneratedTemplateCommand)
    .de(de_DescribeGeneratedTemplateCommand)
    .build() {
}
