import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DescribeStackDriftDetectionStatusCommand, se_DescribeStackDriftDetectionStatusCommand, } from "../protocols/Aws_query";
export { $Command };
export class DescribeStackDriftDetectionStatusCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "DescribeStackDriftDetectionStatus", {})
    .n("CloudFormationClient", "DescribeStackDriftDetectionStatusCommand")
    .f(void 0, void 0)
    .ser(se_DescribeStackDriftDetectionStatusCommand)
    .de(de_DescribeStackDriftDetectionStatusCommand)
    .build() {
}
