import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListStackInstancesCommand, se_ListStackInstancesCommand } from "../protocols/Aws_query";
export { $Command };
export class ListStackInstancesCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "ListStackInstances", {})
    .n("CloudFormationClient", "ListStackInstancesCommand")
    .f(void 0, void 0)
    .ser(se_ListStackInstancesCommand)
    .de(de_ListStackInstancesCommand)
    .build() {
}
