import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { DescribeOrganizationsAccessInput, DescribeOrganizationsAccessOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link DescribeOrganizationsAccessCommand}.
 */
export interface DescribeOrganizationsAccessCommandInput extends DescribeOrganizationsAccessInput {
}
/**
 * @public
 *
 * The output of {@link DescribeOrganizationsAccessCommand}.
 */
export interface DescribeOrganizationsAccessCommandOutput extends DescribeOrganizationsAccessOutput, __MetadataBearer {
}
declare const DescribeOrganizationsAccessCommand_base: {
    new (input: DescribeOrganizationsAccessCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeOrganizationsAccessCommandInput, DescribeOrganizationsAccessCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [DescribeOrganizationsAccessCommandInput]): import("@smithy/smithy-client").CommandImpl<DescribeOrganizationsAccessCommandInput, DescribeOrganizationsAccessCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Retrieves information about the account's <code>OrganizationAccess</code> status. This API can be called either
 *    by the management account or the delegated administrator by using the <code>CallAs</code> parameter. This API can
 *    also be called without the <code>CallAs</code> parameter by the management account.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, DescribeOrganizationsAccessCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, DescribeOrganizationsAccessCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // DescribeOrganizationsAccessInput
 *   CallAs: "SELF" || "DELEGATED_ADMIN",
 * };
 * const command = new DescribeOrganizationsAccessCommand(input);
 * const response = await client.send(command);
 * // { // DescribeOrganizationsAccessOutput
 * //   Status: "ENABLED" || "DISABLED" || "DISABLED_PERMANENTLY",
 * // };
 *
 * ```
 *
 * @param DescribeOrganizationsAccessCommandInput - {@link DescribeOrganizationsAccessCommandInput}
 * @returns {@link DescribeOrganizationsAccessCommandOutput}
 * @see {@link DescribeOrganizationsAccessCommandInput} for command's `input` shape.
 * @see {@link DescribeOrganizationsAccessCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link InvalidOperationException} (client fault)
 *  <p>The specified operation isn't valid.</p>
 *
 * @throws {@link OperationNotFoundException} (client fault)
 *  <p>The specified ID refers to an operation that doesn't exist.</p>
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 * @public
 */
export declare class DescribeOrganizationsAccessCommand extends DescribeOrganizationsAccessCommand_base {
}
