import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { ListResourceScansInput, ListResourceScansOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link ListResourceScansCommand}.
 */
export interface ListResourceScansCommandInput extends ListResourceScansInput {
}
/**
 * @public
 *
 * The output of {@link ListResourceScansCommand}.
 */
export interface ListResourceScansCommandOutput extends ListResourceScansOutput, __MetadataBearer {
}
declare const ListResourceScansCommand_base: {
    new (input: ListResourceScansCommandInput): import("@smithy/smithy-client").CommandImpl<ListResourceScansCommandInput, ListResourceScansCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [ListResourceScansCommandInput]): import("@smithy/smithy-client").CommandImpl<ListResourceScansCommandInput, ListResourceScansCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>List the resource scans from newest to oldest. By default it will return up to 10 resource scans.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, ListResourceScansCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, ListResourceScansCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // ListResourceScansInput
 *   NextToken: "STRING_VALUE",
 *   MaxResults: Number("int"),
 * };
 * const command = new ListResourceScansCommand(input);
 * const response = await client.send(command);
 * // { // ListResourceScansOutput
 * //   ResourceScanSummaries: [ // ResourceScanSummaries
 * //     { // ResourceScanSummary
 * //       ResourceScanId: "STRING_VALUE",
 * //       Status: "IN_PROGRESS" || "FAILED" || "COMPLETE" || "EXPIRED",
 * //       StatusReason: "STRING_VALUE",
 * //       StartTime: new Date("TIMESTAMP"),
 * //       EndTime: new Date("TIMESTAMP"),
 * //       PercentageCompleted: Number("double"),
 * //     },
 * //   ],
 * //   NextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param ListResourceScansCommandInput - {@link ListResourceScansCommandInput}
 * @returns {@link ListResourceScansCommandOutput}
 * @see {@link ListResourceScansCommandInput} for command's `input` shape.
 * @see {@link ListResourceScansCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 * @public
 * @example Listing Resource Scans
 * ```javascript
 * // This example shows how to list resource scans
 * const input = {};
 * const command = new ListResourceScansCommand(input);
 * const response = await client.send(command);
 * /* response ==
 * {
 *   "ResourceScanSummaries": [
 *     {
 *       "PercentageCompleted": 37.4,
 *       "ResourceScanId": "arn:aws:cloudformation:us-east-1:123456789012:resourceScan/51448627-817f-40f0-b37c-f6e0f974340c",
 *       "StartTime": "2024-01-24T00:33:29.673000+00:00",
 *       "Status": "IN_PROGRESS"
 *     },
 *     {
 *       "EndTime": "2024-01-02T23:25:48.075000+00:00",
 *       "PercentageCompleted": 100,
 *       "ResourceScanId": "arn:aws:cloudformation:us-east-1:123456789012:resourceScan/c19304f6-c4f1-4ff8-8e1f-35162e41d7e1",
 *       "StartTime": "2024-01-02T22:15:18.382000+00:00",
 *       "Status": "COMPLETE"
 *     }
 *   ]
 * }
 * *\/
 * // example id: to-list-resource-scans
 * ```
 *
 */
export declare class ListResourceScansCommand extends ListResourceScansCommand_base {
}
