/* CropView.c generated by valac 0.56.3, the Vala compiler
 * generated from CropView.vala, do not modify */

/*
* Copyright (c) 2014-2017 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Tom Beckmann
*              Marvin Beckers <beckersmarvin@gmail.com>
*/

#include "useraccounts.h"
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <glib-object.h>

#define SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_RADIUS 12

enum  {
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_0_PROPERTY,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXBUF_PROPERTY,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_user_accounts_widgets_crop_view_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_NUM_SIGNALS
};
static guint switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_NUM_SIGNALS] = {0};

struct _SwitchboardPlugUserAccountsWidgetsCropViewPrivate {
	GdkRectangle area;
	GdkPixbuf* _pixbuf;
	gdouble current_scale;
	gint* pos;
	gint pos_length1;
	gint pos_length2;
	GdkCursorType current_operation;
	gint temp_x;
	gint temp_y;
	gint offset_x;
	gint offset_y;
	gboolean mouse_button_down;
};

static gint SwitchboardPlugUserAccountsWidgetsCropView_private_offset;
static gpointer switchboard_plug_user_accounts_widgets_crop_view_parent_class = NULL;

static gboolean switchboard_plug_user_accounts_widgets_crop_view_real_button_press_event (GtkWidget* base,
                                                                                   GdkEventButton* event);
static gboolean switchboard_plug_user_accounts_widgets_crop_view_real_motion_notify_event (GtkWidget* base,
                                                                                    GdkEventMotion* event);
static gboolean switchboard_plug_user_accounts_widgets_crop_view_in_quad (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                   gint qx,
                                                                   gint qy,
                                                                   gint qw,
                                                                   gint qh,
                                                                   gint x,
                                                                   gint y);
static void switchboard_plug_user_accounts_widgets_crop_view_apply_cursor (SwitchboardPlugUserAccountsWidgetsCropView* self);
static gint switchboard_plug_user_accounts_widgets_crop_view_x_in_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                   gint ax);
static gint switchboard_plug_user_accounts_widgets_crop_view_y_in_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                   gint ay);
static gint switchboard_plug_user_accounts_widgets_crop_view_width_in_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                       gint aw,
                                                                       gint ax);
static gint switchboard_plug_user_accounts_widgets_crop_view_height_in_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                        gint ah,
                                                                        gint ay);
static gboolean switchboard_plug_user_accounts_widgets_crop_view_real_button_release_event (GtkWidget* base,
                                                                                     GdkEventButton* event);
static gboolean switchboard_plug_user_accounts_widgets_crop_view_real_draw (GtkWidget* base,
                                                                     cairo_t* cr);
static void switchboard_plug_user_accounts_widgets_crop_view_finalize (GObject * obj);
static GType switchboard_plug_user_accounts_widgets_crop_view_get_type_once (void);
static void _vala_switchboard_plug_user_accounts_widgets_crop_view_get_property (GObject * object,
                                                                          guint property_id,
                                                                          GValue * value,
                                                                          GParamSpec * pspec);
static void _vala_switchboard_plug_user_accounts_widgets_crop_view_set_property (GObject * object,
                                                                          guint property_id,
                                                                          const GValue * value,
                                                                          GParamSpec * pspec);

static inline gpointer
switchboard_plug_user_accounts_widgets_crop_view_get_instance_private (SwitchboardPlugUserAccountsWidgetsCropView* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugUserAccountsWidgetsCropView_private_offset);
}

SwitchboardPlugUserAccountsWidgetsCropView*
switchboard_plug_user_accounts_widgets_crop_view_construct_from_pixbuf (GType object_type,
                                                                        GdkPixbuf* pixbuf)
{
	SwitchboardPlugUserAccountsWidgetsCropView * self = NULL;
	g_return_val_if_fail (pixbuf != NULL, NULL);
	self = (SwitchboardPlugUserAccountsWidgetsCropView*) g_object_new (object_type, NULL);
	gtk_widget_add_events ((GtkWidget*) self, (gint) (GDK_POINTER_MOTION_MASK | GDK_BUTTON_MOTION_MASK));
	switchboard_plug_user_accounts_widgets_crop_view_set_pixbuf (self, pixbuf);
	if (gdk_pixbuf_get_width (pixbuf) > gdk_pixbuf_get_height (pixbuf)) {
		GdkPixbuf* _tmp0_;
		GdkPixbuf* _tmp1_;
		GdkRectangle _tmp2_ = {0};
		_tmp0_ = self->priv->_pixbuf;
		_tmp1_ = self->priv->_pixbuf;
		_tmp2_.x = 5;
		_tmp2_.y = 5;
		_tmp2_.width = gdk_pixbuf_get_height (_tmp0_) / 2;
		_tmp2_.height = gdk_pixbuf_get_height (_tmp1_) / 2;
		self->priv->area = _tmp2_;
	} else {
		if (gdk_pixbuf_get_width (pixbuf) < gdk_pixbuf_get_height (pixbuf)) {
			GdkRectangle _tmp3_ = {0};
			_tmp3_.x = 5;
			_tmp3_.y = 5;
			_tmp3_.width = gdk_pixbuf_get_width (pixbuf) / 2;
			_tmp3_.height = gdk_pixbuf_get_width (pixbuf) / 2;
			self->priv->area = _tmp3_;
		} else {
			GdkRectangle _tmp4_ = {0};
			_tmp4_.x = 5;
			_tmp4_.y = 5;
			_tmp4_.width = gdk_pixbuf_get_width (pixbuf) / 2;
			_tmp4_.height = gdk_pixbuf_get_height (pixbuf) / 2;
			self->priv->area = _tmp4_;
		}
	}
	return self;
}

SwitchboardPlugUserAccountsWidgetsCropView*
switchboard_plug_user_accounts_widgets_crop_view_new_from_pixbuf (GdkPixbuf* pixbuf)
{
	return switchboard_plug_user_accounts_widgets_crop_view_construct_from_pixbuf (SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_CROP_VIEW, pixbuf);
}

SwitchboardPlugUserAccountsWidgetsCropView*
switchboard_plug_user_accounts_widgets_crop_view_construct_from_pixbuf_with_size (GType object_type,
                                                                                  GdkPixbuf* pixbuf,
                                                                                  gint x,
                                                                                  gint y,
                                                                                  gboolean quadratic_selection)
{
	SwitchboardPlugUserAccountsWidgetsCropView * self = NULL;
	g_return_val_if_fail (pixbuf != NULL, NULL);
	self = (SwitchboardPlugUserAccountsWidgetsCropView*) g_object_new (object_type, NULL);
	gtk_widget_add_events ((GtkWidget*) self, (gint) (GDK_POINTER_MOTION_MASK | GDK_BUTTON_MOTION_MASK));
	switchboard_plug_user_accounts_widgets_crop_view_set_pixbuf (self, pixbuf);
	self->quadratic_selection = quadratic_selection;
	if (gdk_pixbuf_get_width (pixbuf) > gdk_pixbuf_get_height (pixbuf)) {
		GdkPixbuf* _tmp0_;
		GdkPixbuf* _tmp1_;
		GdkRectangle _tmp2_ = {0};
		gdouble temp_scale = 0.0;
		_tmp0_ = self->priv->_pixbuf;
		_tmp1_ = self->priv->_pixbuf;
		_tmp2_.x = 5;
		_tmp2_.y = 5;
		_tmp2_.width = gdk_pixbuf_get_height (_tmp0_) / 2;
		_tmp2_.height = gdk_pixbuf_get_height (_tmp1_) / 2;
		self->priv->area = _tmp2_;
		temp_scale = ((gdouble) x) / ((gdouble) gdk_pixbuf_get_width (pixbuf));
		if ((gdk_pixbuf_get_height (pixbuf) * temp_scale) < ((gdouble) y)) {
			y = (gint) (gdk_pixbuf_get_height (pixbuf) * temp_scale);
		}
	} else {
		if (gdk_pixbuf_get_width (pixbuf) < gdk_pixbuf_get_height (pixbuf)) {
			GdkPixbuf* _tmp3_;
			GdkRectangle _tmp4_ = {0};
			gdouble temp_scale = 0.0;
			_tmp3_ = self->priv->_pixbuf;
			_tmp4_.x = 5;
			_tmp4_.y = 5;
			_tmp4_.width = gdk_pixbuf_get_width (_tmp3_) / 2;
			_tmp4_.height = gdk_pixbuf_get_width (pixbuf) / 2;
			self->priv->area = _tmp4_;
			temp_scale = ((gdouble) y) / ((gdouble) gdk_pixbuf_get_height (pixbuf));
			if ((gdk_pixbuf_get_width (pixbuf) * temp_scale) < ((gdouble) x)) {
				x = (gint) (gdk_pixbuf_get_width (pixbuf) * temp_scale);
			}
		} else {
			GdkPixbuf* _tmp5_;
			GdkRectangle _tmp6_ = {0};
			_tmp5_ = self->priv->_pixbuf;
			_tmp6_.x = 5;
			_tmp6_.y = 5;
			_tmp6_.width = gdk_pixbuf_get_width (_tmp5_) / 2;
			_tmp6_.height = gdk_pixbuf_get_height (pixbuf) / 2;
			self->priv->area = _tmp6_;
		}
	}
	gtk_widget_set_size_request ((GtkWidget*) self, x, y);
	return self;
}

SwitchboardPlugUserAccountsWidgetsCropView*
switchboard_plug_user_accounts_widgets_crop_view_new_from_pixbuf_with_size (GdkPixbuf* pixbuf,
                                                                            gint x,
                                                                            gint y,
                                                                            gboolean quadratic_selection)
{
	return switchboard_plug_user_accounts_widgets_crop_view_construct_from_pixbuf_with_size (SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_CROP_VIEW, pixbuf, x, y, quadratic_selection);
}

/**
         * returns the current selected area as pixbuf
         */
GdkPixbuf*
switchboard_plug_user_accounts_widgets_crop_view_get_selection (SwitchboardPlugUserAccountsWidgetsCropView* self)
{
	GdkPixbuf* _tmp0_;
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkRectangle _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pixbuf;
	_tmp1_ = self->priv->area;
	_tmp2_ = self->priv->area;
	_tmp3_ = self->priv->area;
	_tmp4_ = self->priv->area;
	_tmp5_ = gdk_pixbuf_new_subpixbuf (_tmp0_, _tmp1_.x, _tmp2_.y, _tmp3_.width, _tmp4_.height);
	result = _tmp5_;
	return result;
}

static gboolean
switchboard_plug_user_accounts_widgets_crop_view_real_button_press_event (GtkWidget* base,
                                                                          GdkEventButton* event)
{
	SwitchboardPlugUserAccountsWidgetsCropView * self;
	gboolean result;
	self = (SwitchboardPlugUserAccountsWidgetsCropView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->mouse_button_down = TRUE;
	self->priv->temp_x = (gint) event->x;
	self->priv->temp_y = (gint) event->y;
	result = TRUE;
	return result;
}

static gboolean
switchboard_plug_user_accounts_widgets_crop_view_real_motion_notify_event (GtkWidget* base,
                                                                           GdkEventMotion* event)
{
	SwitchboardPlugUserAccountsWidgetsCropView * self;
	gboolean result;
	self = (SwitchboardPlugUserAccountsWidgetsCropView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (!self->priv->mouse_button_down) {
		gboolean determined_cursortype = FALSE;
		static const GdkCursorType CURSOR[8] = {GDK_TOP_LEFT_CORNER, GDK_TOP_SIDE, GDK_TOP_RIGHT_CORNER, GDK_RIGHT_SIDE, GDK_BOTTOM_RIGHT_CORNER, GDK_BOTTOM_SIDE, GDK_BOTTOM_LEFT_CORNER, GDK_LEFT_SIDE};
		determined_cursortype = FALSE;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					gint* _tmp2_;
					gint _tmp2__length1;
					gint _tmp2__length2;
					gint _tmp3_;
					gint* _tmp4_;
					gint _tmp4__length1;
					gint _tmp4__length2;
					gint _tmp5_;
					if (!_tmp0_) {
						gint _tmp1_;
						_tmp1_ = i;
						i = _tmp1_ + 1;
					}
					_tmp0_ = FALSE;
					if (!(i < 8)) {
						break;
					}
					_tmp2_ = self->priv->pos;
					_tmp2__length1 = self->priv->pos_length1;
					_tmp2__length2 = self->priv->pos_length2;
					_tmp3_ = _tmp2_[(i * _tmp2__length2) + 0];
					_tmp4_ = self->priv->pos;
					_tmp4__length1 = self->priv->pos_length1;
					_tmp4__length2 = self->priv->pos_length2;
					_tmp5_ = _tmp4_[(i * _tmp4__length2) + 1];
					if (switchboard_plug_user_accounts_widgets_crop_view_in_quad (self, _tmp3_ - SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_RADIUS, _tmp5_ - SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_RADIUS, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_RADIUS * 2, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_RADIUS * 2, (gint) event->x, (gint) event->y)) {
						GdkCursorType _tmp6_;
						_tmp6_ = CURSOR[i];
						self->priv->current_operation = _tmp6_;
						determined_cursortype = TRUE;
						break;
					}
				}
			}
		}
		if (!determined_cursortype) {
			GdkRectangle _tmp7_;
			GdkRectangle _tmp8_;
			GdkRectangle _tmp9_;
			GdkRectangle _tmp10_;
			_tmp7_ = self->priv->area;
			_tmp8_ = self->priv->area;
			_tmp9_ = self->priv->area;
			_tmp10_ = self->priv->area;
			if (switchboard_plug_user_accounts_widgets_crop_view_in_quad (self, (gint) floor (_tmp7_.x * self->priv->current_scale), (gint) floor (_tmp8_.y * self->priv->current_scale), (gint) floor (_tmp9_.width * self->priv->current_scale), (gint) floor (_tmp10_.height * self->priv->current_scale), (gint) (event->x - self->priv->offset_x), (gint) (event->y - self->priv->offset_y))) {
				self->priv->current_operation = GDK_FLEUR;
			} else {
				self->priv->current_operation = GDK_ARROW;
			}
		}
		switchboard_plug_user_accounts_widgets_crop_view_apply_cursor (self);
		result = TRUE;
		return result;
	} else {
		GdkRectangle _tmp65_;
		GdkRectangle _tmp66_;
		switch (self->priv->current_operation) {
			case GDK_FLEUR:
			{
				gint motion_x = 0;
				GdkRectangle _tmp11_;
				gint motion_y = 0;
				GdkRectangle _tmp12_;
				_tmp11_ = self->priv->area;
				motion_x = (gint) (_tmp11_.x + ((((gint) event->x) - self->priv->temp_x) / self->priv->current_scale));
				_tmp12_ = self->priv->area;
				motion_y = (gint) (_tmp12_.y + ((((gint) event->y) - self->priv->temp_y) / self->priv->current_scale));
				switch (switchboard_plug_user_accounts_widgets_crop_view_x_in_pixbuf (self, motion_x)) {
					case 0:
					{
						self->priv->area.x = motion_x;
						g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
						break;
					}
					case 1:
					{
						self->priv->area.x = 0;
						break;
					}
					case 2:
					{
						GdkPixbuf* _tmp13_;
						GdkRectangle _tmp14_;
						_tmp13_ = self->priv->_pixbuf;
						_tmp14_ = self->priv->area;
						self->priv->area.x = gdk_pixbuf_get_width (_tmp13_) - _tmp14_.width;
						break;
					}
					default:
					break;
				}
				switch (switchboard_plug_user_accounts_widgets_crop_view_y_in_pixbuf (self, motion_y)) {
					case 0:
					{
						self->priv->area.y = motion_y;
						g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
						break;
					}
					case 1:
					{
						self->priv->area.y = 0;
						break;
					}
					case 2:
					{
						GdkPixbuf* _tmp15_;
						GdkRectangle _tmp16_;
						_tmp15_ = self->priv->_pixbuf;
						_tmp16_ = self->priv->area;
						self->priv->area.y = gdk_pixbuf_get_height (_tmp15_) - _tmp16_.height;
						break;
					}
					default:
					break;
				}
				break;
			}
			case GDK_TOP_RIGHT_CORNER:
			case GDK_TOP_LEFT_CORNER:
			{
				gint motion_width = 0;
				gint motion_height = 0;
				gboolean _tmp21_ = FALSE;
				GdkRectangle _tmp23_;
				GdkRectangle _tmp27_;
				motion_width = 0;
				motion_height = 0;
				if (self->priv->current_operation == GDK_TOP_RIGHT_CORNER) {
					GdkRectangle _tmp17_;
					GdkRectangle _tmp18_;
					_tmp17_ = self->priv->area;
					motion_width = (gint) (_tmp17_.width + ((((gint) event->x) - self->priv->temp_x) / self->priv->current_scale));
					_tmp18_ = self->priv->area;
					motion_height = (gint) (_tmp18_.height - ((((gint) event->y) - self->priv->temp_y) / self->priv->current_scale));
				} else {
					GdkRectangle _tmp19_;
					GdkRectangle _tmp20_;
					_tmp19_ = self->priv->area;
					motion_width = (gint) (_tmp19_.width - ((((gint) event->x) - self->priv->temp_x) / self->priv->current_scale));
					_tmp20_ = self->priv->area;
					motion_height = (gint) (_tmp20_.height - ((((gint) event->y) - self->priv->temp_y) / self->priv->current_scale));
				}
				if (self->quadratic_selection) {
					_tmp21_ = motion_width >= motion_height;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					motion_height = motion_width;
				} else {
					gboolean _tmp22_ = FALSE;
					if (self->quadratic_selection) {
						_tmp22_ = motion_width < motion_height;
					} else {
						_tmp22_ = FALSE;
					}
					if (_tmp22_) {
						motion_width = motion_height;
					}
				}
				_tmp23_ = self->priv->area;
				switch (switchboard_plug_user_accounts_widgets_crop_view_width_in_pixbuf (self, motion_width, _tmp23_.x)) {
					case 0:
					{
						GdkRectangle _tmp24_;
						_tmp24_ = self->priv->area;
						if (switchboard_plug_user_accounts_widgets_crop_view_height_in_pixbuf (self, motion_height, _tmp24_.y) == 0) {
							self->priv->area.width = motion_width;
							self->priv->area.height = motion_height;
							g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
						}
						break;
					}
					case 1:
					{
						self->priv->area.width = 0;
						break;
					}
					case 2:
					{
						GdkPixbuf* _tmp25_;
						GdkRectangle _tmp26_;
						_tmp25_ = self->priv->_pixbuf;
						_tmp26_ = self->priv->area;
						self->priv->area.width = gdk_pixbuf_get_width (_tmp25_) - _tmp26_.x;
						break;
					}
					default:
					break;
				}
				_tmp27_ = self->priv->area;
				switch (switchboard_plug_user_accounts_widgets_crop_view_height_in_pixbuf (self, motion_height, _tmp27_.y)) {
					case 0:
					{
						GdkRectangle _tmp28_;
						_tmp28_ = self->priv->area;
						if (switchboard_plug_user_accounts_widgets_crop_view_width_in_pixbuf (self, motion_width, _tmp28_.x) == 0) {
							self->priv->area.height = motion_height;
							self->priv->area.width = motion_width;
							g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
						}
						break;
					}
					case 1:
					{
						self->priv->area.height = 0;
						break;
					}
					case 2:
					{
						GdkPixbuf* _tmp29_;
						GdkRectangle _tmp30_;
						_tmp29_ = self->priv->_pixbuf;
						_tmp30_ = self->priv->area;
						self->priv->area.height = gdk_pixbuf_get_height (_tmp29_) - _tmp30_.y;
						break;
					}
					default:
					break;
				}
				break;
			}
			case GDK_BOTTOM_RIGHT_CORNER:
			case GDK_BOTTOM_LEFT_CORNER:
			{
				gint motion_width = 0;
				gint motion_height = 0;
				gboolean _tmp35_ = FALSE;
				GdkRectangle _tmp37_;
				GdkRectangle _tmp41_;
				motion_width = 0;
				motion_height = 0;
				if (self->priv->current_operation == GDK_BOTTOM_RIGHT_CORNER) {
					GdkRectangle _tmp31_;
					GdkRectangle _tmp32_;
					_tmp31_ = self->priv->area;
					motion_width = (gint) (_tmp31_.width + ((((gint) event->x) - self->priv->temp_x) / self->priv->current_scale));
					_tmp32_ = self->priv->area;
					motion_height = (gint) (_tmp32_.height + ((((gint) event->y) - self->priv->temp_y) / self->priv->current_scale));
				} else {
					GdkRectangle _tmp33_;
					GdkRectangle _tmp34_;
					_tmp33_ = self->priv->area;
					motion_width = (gint) (_tmp33_.width - ((((gint) event->x) - self->priv->temp_x) / self->priv->current_scale));
					_tmp34_ = self->priv->area;
					motion_height = (gint) (_tmp34_.height + ((((gint) event->y) - self->priv->temp_y) / self->priv->current_scale));
				}
				if (self->quadratic_selection) {
					_tmp35_ = motion_width >= motion_height;
				} else {
					_tmp35_ = FALSE;
				}
				if (_tmp35_) {
					motion_height = motion_width;
				} else {
					gboolean _tmp36_ = FALSE;
					if (self->quadratic_selection) {
						_tmp36_ = motion_width < motion_height;
					} else {
						_tmp36_ = FALSE;
					}
					if (_tmp36_) {
						motion_width = motion_height;
					}
				}
				_tmp37_ = self->priv->area;
				switch (switchboard_plug_user_accounts_widgets_crop_view_width_in_pixbuf (self, motion_width, _tmp37_.x)) {
					case 0:
					{
						GdkRectangle _tmp38_;
						_tmp38_ = self->priv->area;
						if (switchboard_plug_user_accounts_widgets_crop_view_height_in_pixbuf (self, motion_height, _tmp38_.y) == 0) {
							self->priv->area.width = motion_width;
							self->priv->area.height = motion_height;
							g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
						}
						break;
					}
					case 1:
					{
						self->priv->area.width = 0;
						break;
					}
					case 2:
					{
						GdkPixbuf* _tmp39_;
						GdkRectangle _tmp40_;
						_tmp39_ = self->priv->_pixbuf;
						_tmp40_ = self->priv->area;
						self->priv->area.width = gdk_pixbuf_get_width (_tmp39_) - _tmp40_.x;
						break;
					}
					default:
					break;
				}
				_tmp41_ = self->priv->area;
				switch (switchboard_plug_user_accounts_widgets_crop_view_height_in_pixbuf (self, motion_height, _tmp41_.y)) {
					case 0:
					{
						GdkRectangle _tmp42_;
						_tmp42_ = self->priv->area;
						if (switchboard_plug_user_accounts_widgets_crop_view_width_in_pixbuf (self, motion_width, _tmp42_.x) == 0) {
							self->priv->area.height = motion_height;
							self->priv->area.width = motion_width;
							g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
						}
						break;
					}
					case 1:
					{
						self->priv->area.height = 0;
						break;
					}
					case 2:
					{
						GdkPixbuf* _tmp43_;
						GdkRectangle _tmp44_;
						_tmp43_ = self->priv->_pixbuf;
						_tmp44_ = self->priv->area;
						self->priv->area.height = gdk_pixbuf_get_height (_tmp43_) - _tmp44_.y;
						break;
					}
					default:
					break;
				}
				break;
			}
			case GDK_TOP_SIDE:
			case GDK_BOTTOM_SIDE:
			{
				gint motion_height = 0;
				motion_height = 0;
				if (self->priv->current_operation == GDK_BOTTOM_SIDE) {
					GdkRectangle _tmp45_;
					_tmp45_ = self->priv->area;
					motion_height = (gint) (_tmp45_.height + ((((gint) event->y) - self->priv->temp_y) / self->priv->current_scale));
				} else {
					GdkRectangle _tmp46_;
					_tmp46_ = self->priv->area;
					motion_height = (gint) (_tmp46_.height - ((((gint) event->y) - self->priv->temp_y) / self->priv->current_scale));
				}
				if (!self->quadratic_selection) {
					GdkRectangle _tmp47_;
					_tmp47_ = self->priv->area;
					switch (switchboard_plug_user_accounts_widgets_crop_view_height_in_pixbuf (self, motion_height, _tmp47_.y)) {
						case 0:
						{
							self->priv->area.height = motion_height;
							g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
							break;
						}
						case 1:
						{
							self->priv->area.height = 0;
							break;
						}
						case 2:
						{
							GdkPixbuf* _tmp48_;
							GdkRectangle _tmp49_;
							_tmp48_ = self->priv->_pixbuf;
							_tmp49_ = self->priv->area;
							self->priv->area.height = gdk_pixbuf_get_height (_tmp48_) - _tmp49_.y;
							break;
						}
						default:
						break;
					}
				} else {
					GdkRectangle _tmp50_;
					_tmp50_ = self->priv->area;
					switch (switchboard_plug_user_accounts_widgets_crop_view_height_in_pixbuf (self, motion_height, _tmp50_.y)) {
						case 0:
						{
							self->priv->area.width = motion_height;
							self->priv->area.height = motion_height;
							g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
							break;
						}
						case 1:
						{
							self->priv->area.width = 0;
							self->priv->area.height = 0;
							break;
						}
						case 2:
						{
							GdkPixbuf* _tmp51_;
							GdkRectangle _tmp52_;
							GdkPixbuf* _tmp53_;
							GdkRectangle _tmp54_;
							_tmp51_ = self->priv->_pixbuf;
							_tmp52_ = self->priv->area;
							self->priv->area.width = gdk_pixbuf_get_width (_tmp51_) - _tmp52_.x;
							_tmp53_ = self->priv->_pixbuf;
							_tmp54_ = self->priv->area;
							self->priv->area.height = gdk_pixbuf_get_height (_tmp53_) - _tmp54_.y;
							break;
						}
						default:
						break;
					}
				}
				break;
			}
			case GDK_RIGHT_SIDE:
			case GDK_LEFT_SIDE:
			{
				gint motion_width = 0;
				motion_width = 0;
				if (self->priv->current_operation == GDK_RIGHT_SIDE) {
					GdkRectangle _tmp55_;
					_tmp55_ = self->priv->area;
					motion_width = (gint) (_tmp55_.width + ((((gint) event->x) - self->priv->temp_x) / self->priv->current_scale));
				} else {
					GdkRectangle _tmp56_;
					_tmp56_ = self->priv->area;
					motion_width = (gint) (_tmp56_.width - ((((gint) event->x) - self->priv->temp_x) / self->priv->current_scale));
				}
				if (!self->quadratic_selection) {
					GdkRectangle _tmp57_;
					_tmp57_ = self->priv->area;
					switch (switchboard_plug_user_accounts_widgets_crop_view_width_in_pixbuf (self, motion_width, _tmp57_.x)) {
						case 0:
						{
							self->priv->area.width = motion_width;
							g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
							break;
						}
						case 1:
						{
							self->priv->area.width = 0;
							break;
						}
						case 2:
						{
							GdkPixbuf* _tmp58_;
							GdkRectangle _tmp59_;
							_tmp58_ = self->priv->_pixbuf;
							_tmp59_ = self->priv->area;
							self->priv->area.width = gdk_pixbuf_get_width (_tmp58_) - _tmp59_.x;
							break;
						}
						default:
						break;
					}
				} else {
					GdkRectangle _tmp60_;
					_tmp60_ = self->priv->area;
					switch (switchboard_plug_user_accounts_widgets_crop_view_width_in_pixbuf (self, motion_width, _tmp60_.x)) {
						case 0:
						{
							self->priv->area.width = motion_width;
							self->priv->area.height = motion_width;
							g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
							break;
						}
						case 1:
						{
							self->priv->area.width = 0;
							self->priv->area.height = 0;
							break;
						}
						case 2:
						{
							GdkPixbuf* _tmp61_;
							GdkRectangle _tmp62_;
							GdkPixbuf* _tmp63_;
							GdkRectangle _tmp64_;
							_tmp61_ = self->priv->_pixbuf;
							_tmp62_ = self->priv->area;
							self->priv->area.width = gdk_pixbuf_get_width (_tmp61_) - _tmp62_.x;
							_tmp63_ = self->priv->_pixbuf;
							_tmp64_ = self->priv->area;
							self->priv->area.height = gdk_pixbuf_get_height (_tmp63_) - _tmp64_.y;
							break;
						}
						default:
						break;
					}
				}
				break;
			}
			default:
			{
				break;
			}
		}
		_tmp65_ = self->priv->area;
		_tmp66_ = self->priv->area;
		if (_tmp65_.width != _tmp66_.height) {
			gint _tmp67_ = 0;
			GdkRectangle _tmp68_;
			GdkRectangle _tmp69_;
			gint smallest = 0;
			_tmp68_ = self->priv->area;
			_tmp69_ = self->priv->area;
			if (_tmp68_.width > _tmp69_.height) {
				GdkRectangle _tmp70_;
				_tmp70_ = self->priv->area;
				_tmp67_ = _tmp70_.height;
			} else {
				GdkRectangle _tmp71_;
				_tmp71_ = self->priv->area;
				_tmp67_ = _tmp71_.width;
			}
			smallest = _tmp67_;
			self->priv->area.width = smallest;
			self->priv->area.height = smallest;
		}
		self->priv->temp_x = (gint) event->x;
		self->priv->temp_y = (gint) event->y;
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	result = TRUE;
	return result;
}

static gboolean
switchboard_plug_user_accounts_widgets_crop_view_real_button_release_event (GtkWidget* base,
                                                                            GdkEventButton* event)
{
	SwitchboardPlugUserAccountsWidgetsCropView * self;
	gboolean result;
	self = (SwitchboardPlugUserAccountsWidgetsCropView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->current_operation = GDK_ARROW;
	self->priv->mouse_button_down = FALSE;
	switchboard_plug_user_accounts_widgets_crop_view_apply_cursor (self);
	result = TRUE;
	return result;
}

static gboolean
switchboard_plug_user_accounts_widgets_crop_view_real_draw (GtkWidget* base,
                                                            cairo_t* cr)
{
	SwitchboardPlugUserAccountsWidgetsCropView * self;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp0_ = {0};
	gint pixbuf_width = 0;
	GdkPixbuf* _tmp1_;
	gint pixbuf_height = 0;
	GdkPixbuf* _tmp2_;
	gdouble scale = 0.0;
	GtkAllocation _tmp3_;
	GtkAllocation _tmp6_;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	GtkAllocation _tmp11_;
	GtkAllocation _tmp12_;
	GdkPixbuf* _tmp13_;
	GdkPixbuf* _tmp14_;
	gint x = 0;
	GdkRectangle _tmp15_;
	gint y = 0;
	GdkRectangle _tmp16_;
	gint w = 0;
	GdkRectangle _tmp17_;
	gint h = 0;
	GdkRectangle _tmp18_;
	gint* _tmp19_;
	gboolean result;
	self = (SwitchboardPlugUserAccountsWidgetsCropView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	alloc = _tmp0_;
	_tmp1_ = self->priv->_pixbuf;
	pixbuf_width = gdk_pixbuf_get_width (_tmp1_);
	_tmp2_ = self->priv->_pixbuf;
	pixbuf_height = gdk_pixbuf_get_height (_tmp2_);
	scale = 1.0;
	_tmp3_ = alloc;
	if (pixbuf_width > _tmp3_.width) {
		GtkAllocation _tmp4_;
		GtkAllocation _tmp5_;
		_tmp4_ = alloc;
		scale = _tmp4_.width / ((gdouble) pixbuf_width);
		pixbuf_height = (gint) floor (scale * pixbuf_height);
		_tmp5_ = alloc;
		pixbuf_width = _tmp5_.width;
	}
	_tmp6_ = alloc;
	if (pixbuf_height > _tmp6_.height) {
		GtkAllocation _tmp7_;
		GtkAllocation _tmp8_;
		_tmp7_ = alloc;
		scale = _tmp7_.height / ((gdouble) pixbuf_height);
		pixbuf_width = (gint) floor (scale * pixbuf_width);
		_tmp8_ = alloc;
		pixbuf_height = _tmp8_.height;
	}
	_tmp9_ = self->priv->_pixbuf;
	_tmp10_ = gdk_pixbuf_scale_simple (_tmp9_, pixbuf_width, pixbuf_height, GDK_INTERP_BILINEAR);
	pixbuf = _tmp10_;
	_tmp11_ = alloc;
	self->priv->offset_x = (_tmp11_.width / 2) - (pixbuf_width / 2);
	_tmp12_ = alloc;
	self->priv->offset_y = (_tmp12_.height / 2) - (pixbuf_height / 2);
	_tmp13_ = pixbuf;
	gdk_cairo_set_source_pixbuf (cr, _tmp13_, (gdouble) self->priv->offset_x, (gdouble) self->priv->offset_y);
	cairo_paint (cr);
	_tmp14_ = self->priv->_pixbuf;
	scale = pixbuf_width / ((gdouble) gdk_pixbuf_get_width (_tmp14_));
	_tmp15_ = self->priv->area;
	x = self->priv->offset_x + ((gint) floor (_tmp15_.x * scale));
	_tmp16_ = self->priv->area;
	y = self->priv->offset_y + ((gint) floor (_tmp16_.y * scale));
	_tmp17_ = self->priv->area;
	w = (gint) floor (_tmp17_.width * scale);
	_tmp18_ = self->priv->area;
	h = (gint) floor (_tmp18_.height * scale);
	_tmp19_ = g_new0 (gint, 8 * 2);
	_tmp19_[0] = x;
	_tmp19_[1] = y;
	_tmp19_[2] = x + (w / 2);
	_tmp19_[3] = y;
	_tmp19_[4] = x + w;
	_tmp19_[5] = y;
	_tmp19_[6] = x + w;
	_tmp19_[7] = y + (h / 2);
	_tmp19_[8] = x + w;
	_tmp19_[9] = y + h;
	_tmp19_[10] = x + (w / 2);
	_tmp19_[11] = y + h;
	_tmp19_[12] = x;
	_tmp19_[13] = y + h;
	_tmp19_[14] = x;
	_tmp19_[15] = y + (h / 2);
	self->priv->pos = (g_free (self->priv->pos), NULL);
	self->priv->pos = _tmp19_;
	self->priv->pos_length1 = 8;
	self->priv->pos_length2 = 2;
	cairo_rectangle (cr, (gdouble) x, (gdouble) y, (gdouble) w, (gdouble) h);
	cairo_set_source_rgba (cr, 0.1, 0.1, 0.1, 0.2);
	cairo_fill (cr);
	cairo_rectangle (cr, (gdouble) x, (gdouble) y, (gdouble) w, (gdouble) h);
	cairo_set_source_rgb (cr, 1.0, 1.0, 1.0);
	cairo_set_line_width (cr, 1.0);
	cairo_stroke (cr);
	if (self->handles_visible) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp20_ = FALSE;
				_tmp20_ = TRUE;
				while (TRUE) {
					gint* _tmp22_;
					gint _tmp22__length1;
					gint _tmp22__length2;
					gint _tmp23_;
					gint* _tmp24_;
					gint _tmp24__length1;
					gint _tmp24__length2;
					gint _tmp25_;
					if (!_tmp20_) {
						gint _tmp21_;
						_tmp21_ = i;
						i = _tmp21_ + 1;
					}
					_tmp20_ = FALSE;
					if (!(i < 8)) {
						break;
					}
					_tmp22_ = self->priv->pos;
					_tmp22__length1 = self->priv->pos_length1;
					_tmp22__length2 = self->priv->pos_length2;
					_tmp23_ = _tmp22_[(i * _tmp22__length2) + 0];
					_tmp24_ = self->priv->pos;
					_tmp24__length1 = self->priv->pos_length1;
					_tmp24__length2 = self->priv->pos_length2;
					_tmp25_ = _tmp24_[(i * _tmp24__length2) + 1];
					cairo_arc (cr, (gdouble) _tmp23_, (gdouble) _tmp25_, (gdouble) SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_RADIUS, 0.0, 2 * G_PI);
					cairo_set_source_rgb (cr, 0.7, 0.7, 0.7);
					cairo_fill (cr);
				}
			}
		}
	}
	self->priv->current_scale = scale;
	result = TRUE;
	_g_object_unref0 (pixbuf);
	return result;
}

static gboolean
switchboard_plug_user_accounts_widgets_crop_view_in_quad (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                          gint qx,
                                                          gint qy,
                                                          gint qw,
                                                          gint qh,
                                                          gint x,
                                                          gint y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (x > qx) {
		_tmp2_ = x < (qx + qw);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = y > qy;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = y < (qy + qh);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_user_accounts_widgets_crop_view_apply_cursor (SwitchboardPlugUserAccountsWidgetsCropView* self)
{
	GdkWindow* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkCursor* _tmp2_;
	GdkCursor* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = gdk_display_get_default ();
	_tmp2_ = gdk_cursor_new_for_display (_tmp1_, self->priv->current_operation);
	_tmp3_ = _tmp2_;
	gdk_window_set_cursor (_tmp0_, _tmp3_);
	_g_object_unref0 (_tmp3_);
}

static gint
switchboard_plug_user_accounts_widgets_crop_view_x_in_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                              gint ax)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (ax < 0) {
		result = 1;
		return result;
	} else {
		GdkRectangle _tmp0_;
		GdkPixbuf* _tmp1_;
		_tmp0_ = self->priv->area;
		_tmp1_ = self->priv->_pixbuf;
		if ((ax + _tmp0_.width) > gdk_pixbuf_get_width (_tmp1_)) {
			result = 2;
			return result;
		}
	}
	result = 0;
	return result;
}

static gint
switchboard_plug_user_accounts_widgets_crop_view_y_in_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                              gint ay)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (ay < 0) {
		result = 1;
		return result;
	} else {
		GdkRectangle _tmp0_;
		GdkPixbuf* _tmp1_;
		_tmp0_ = self->priv->area;
		_tmp1_ = self->priv->_pixbuf;
		if ((ay + _tmp0_.height) > gdk_pixbuf_get_height (_tmp1_)) {
			result = 2;
			return result;
		}
	}
	result = 0;
	return result;
}

static gint
switchboard_plug_user_accounts_widgets_crop_view_width_in_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                  gint aw,
                                                                  gint ax)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (aw < 0) {
		result = 1;
		return result;
	} else {
		GdkPixbuf* _tmp0_;
		_tmp0_ = self->priv->_pixbuf;
		if (aw > (gdk_pixbuf_get_width (_tmp0_) - ax)) {
			result = 2;
			return result;
		}
	}
	result = 0;
	return result;
}

static gint
switchboard_plug_user_accounts_widgets_crop_view_height_in_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                   gint ah,
                                                                   gint ay)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (ah < 0) {
		result = 1;
		return result;
	} else {
		GdkPixbuf* _tmp0_;
		_tmp0_ = self->priv->_pixbuf;
		if (ah > (gdk_pixbuf_get_height (_tmp0_) - ay)) {
			result = 2;
			return result;
		}
	}
	result = 0;
	return result;
}

SwitchboardPlugUserAccountsWidgetsCropView*
switchboard_plug_user_accounts_widgets_crop_view_construct (GType object_type)
{
	SwitchboardPlugUserAccountsWidgetsCropView * self = NULL;
	self = (SwitchboardPlugUserAccountsWidgetsCropView*) g_object_new (object_type, NULL);
	return self;
}

SwitchboardPlugUserAccountsWidgetsCropView*
switchboard_plug_user_accounts_widgets_crop_view_new (void)
{
	return switchboard_plug_user_accounts_widgets_crop_view_construct (SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_CROP_VIEW);
}

GdkPixbuf*
switchboard_plug_user_accounts_widgets_crop_view_get_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pixbuf;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
switchboard_plug_user_accounts_widgets_crop_view_set_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                             GdkPixbuf* value)
{
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_pixbuf);
	self->priv->_pixbuf = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, switchboard_plug_user_accounts_widgets_crop_view_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXBUF_PROPERTY]);
}

static void
switchboard_plug_user_accounts_widgets_crop_view_class_init (SwitchboardPlugUserAccountsWidgetsCropViewClass * klass,
                                                             gpointer klass_data)
{
	switchboard_plug_user_accounts_widgets_crop_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugUserAccountsWidgetsCropView_private_offset);
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) switchboard_plug_user_accounts_widgets_crop_view_real_button_press_event;
	((GtkWidgetClass *) klass)->motion_notify_event = (gboolean (*) (GtkWidget*, GdkEventMotion*)) switchboard_plug_user_accounts_widgets_crop_view_real_motion_notify_event;
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) switchboard_plug_user_accounts_widgets_crop_view_real_button_release_event;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) switchboard_plug_user_accounts_widgets_crop_view_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_plug_user_accounts_widgets_crop_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_plug_user_accounts_widgets_crop_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_user_accounts_widgets_crop_view_finalize;
	/**
	         * The current pixbuf
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXBUF_PROPERTY, switchboard_plug_user_accounts_widgets_crop_view_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXBUF_PROPERTY] = g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * signal that is emitted when the selection area is changed in any way
	         */
	switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL] = g_signal_new ("area-changed", SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_CROP_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
switchboard_plug_user_accounts_widgets_crop_view_instance_init (SwitchboardPlugUserAccountsWidgetsCropView * self,
                                                                gpointer klass)
{
	gint* _tmp0_;
	self->priv = switchboard_plug_user_accounts_widgets_crop_view_get_instance_private (self);
	self->quadratic_selection = FALSE;
	self->handles_visible = TRUE;
	_tmp0_ = g_new0 (gint, 8 * 2);
	_tmp0_[0] = 0;
	_tmp0_[1] = 0;
	_tmp0_[2] = 0;
	_tmp0_[3] = 0;
	_tmp0_[4] = 0;
	_tmp0_[5] = 0;
	_tmp0_[6] = 0;
	_tmp0_[7] = 0;
	_tmp0_[8] = 0;
	_tmp0_[9] = 0;
	_tmp0_[10] = 0;
	_tmp0_[11] = 0;
	_tmp0_[12] = 0;
	_tmp0_[13] = 0;
	_tmp0_[14] = 0;
	_tmp0_[15] = 0;
	self->priv->pos = _tmp0_;
	self->priv->pos_length1 = 8;
	self->priv->pos_length2 = 2;
	self->priv->current_operation = GDK_ARROW;
	self->priv->mouse_button_down = FALSE;
}

static void
switchboard_plug_user_accounts_widgets_crop_view_finalize (GObject * obj)
{
	SwitchboardPlugUserAccountsWidgetsCropView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_CROP_VIEW, SwitchboardPlugUserAccountsWidgetsCropView);
	_g_object_unref0 (self->priv->_pixbuf);
	self->priv->pos = (g_free (self->priv->pos), NULL);
	G_OBJECT_CLASS (switchboard_plug_user_accounts_widgets_crop_view_parent_class)->finalize (obj);
}

static GType
switchboard_plug_user_accounts_widgets_crop_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugUserAccountsWidgetsCropViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_user_accounts_widgets_crop_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugUserAccountsWidgetsCropView), 0, (GInstanceInitFunc) switchboard_plug_user_accounts_widgets_crop_view_instance_init, NULL };
	GType switchboard_plug_user_accounts_widgets_crop_view_type_id;
	switchboard_plug_user_accounts_widgets_crop_view_type_id = g_type_register_static (gtk_event_box_get_type (), "SwitchboardPlugUserAccountsWidgetsCropView", &g_define_type_info, 0);
	SwitchboardPlugUserAccountsWidgetsCropView_private_offset = g_type_add_instance_private (switchboard_plug_user_accounts_widgets_crop_view_type_id, sizeof (SwitchboardPlugUserAccountsWidgetsCropViewPrivate));
	return switchboard_plug_user_accounts_widgets_crop_view_type_id;
}

GType
switchboard_plug_user_accounts_widgets_crop_view_get_type (void)
{
	static volatile gsize switchboard_plug_user_accounts_widgets_crop_view_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_user_accounts_widgets_crop_view_type_id__once)) {
		GType switchboard_plug_user_accounts_widgets_crop_view_type_id;
		switchboard_plug_user_accounts_widgets_crop_view_type_id = switchboard_plug_user_accounts_widgets_crop_view_get_type_once ();
		g_once_init_leave (&switchboard_plug_user_accounts_widgets_crop_view_type_id__once, switchboard_plug_user_accounts_widgets_crop_view_type_id);
	}
	return switchboard_plug_user_accounts_widgets_crop_view_type_id__once;
}

static void
_vala_switchboard_plug_user_accounts_widgets_crop_view_get_property (GObject * object,
                                                                     guint property_id,
                                                                     GValue * value,
                                                                     GParamSpec * pspec)
{
	SwitchboardPlugUserAccountsWidgetsCropView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_CROP_VIEW, SwitchboardPlugUserAccountsWidgetsCropView);
	switch (property_id) {
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXBUF_PROPERTY:
		g_value_set_object (value, switchboard_plug_user_accounts_widgets_crop_view_get_pixbuf (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_plug_user_accounts_widgets_crop_view_set_property (GObject * object,
                                                                     guint property_id,
                                                                     const GValue * value,
                                                                     GParamSpec * pspec)
{
	SwitchboardPlugUserAccountsWidgetsCropView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_CROP_VIEW, SwitchboardPlugUserAccountsWidgetsCropView);
	switch (property_id) {
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXBUF_PROPERTY:
		switchboard_plug_user_accounts_widgets_crop_view_set_pixbuf (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

