/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import jakarta.servlet.ServletException;
import java.io.IOException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleBase;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.buf.MessageBytes;

public class HealthCheckValve
extends ValveBase {
    private static final String UP = "{\n  \"status\": \"UP\",\n  \"checks\": []\n}";
    private static final String DOWN = "{\n  \"status\": \"DOWN\",\n  \"checks\": []\n}";
    private String path = "/health";
    protected boolean context = false;
    protected boolean checkContainersAvailable = true;

    public HealthCheckValve() {
        super(true);
    }

    public final String getPath() {
        return this.path;
    }

    public final void setPath(String string) {
        this.path = string;
    }

    public boolean getCheckContainersAvailable() {
        return this.checkContainersAvailable;
    }

    public void setCheckContainersAvailable(boolean bl) {
        this.checkContainersAvailable = bl;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        super.startInternal();
        this.context = this.getContainer() instanceof Context;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        MessageBytes messageBytes;
        MessageBytes messageBytes2 = messageBytes = this.context ? request.getRequestPathMB() : request.getDecodedRequestURIMB();
        if (messageBytes.equals(this.path)) {
            response.setContentType("application/json");
            if (!this.checkContainersAvailable || this.isAvailable(this.getContainer())) {
                response.getOutputStream().print(UP);
            } else {
                response.setStatus(503);
                response.getOutputStream().print(DOWN);
            }
        } else {
            this.getNext().invoke(request, response);
        }
    }

    protected boolean isAvailable(Container container) {
        for (Container container2 : container.findChildren()) {
            if (this.isAvailable(container2)) continue;
            return false;
        }
        if (container instanceof LifecycleBase) {
            return ((LifecycleBase)((Object)container)).getState().isAvailable();
        }
        return true;
    }
}

