/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class RequestUtil {
    private RequestUtil() {
    }

    public static String normalize(String string) {
        return RequestUtil.normalize(string, true);
    }

    public static String normalize(String string, boolean bl) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (bl && string2.indexOf(92) >= 0) {
            string2 = string2.replace('\\', '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        boolean bl2 = false;
        if (string2.endsWith("/.") || string2.endsWith("/..")) {
            string2 = string2 + "/";
            bl2 = true;
        }
        while ((n = string2.indexOf("//")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        while ((n = string2.indexOf("/./")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 2);
        }
        while ((n = string2.indexOf("/../")) >= 0) {
            if (n == 0) {
                return null;
            }
            int n2 = string2.lastIndexOf(47, n - 1);
            string2 = string2.substring(0, n2) + string2.substring(n + 3);
        }
        if (string2.length() > 1 && bl2) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static boolean isSameOrigin(HttpServletRequest httpServletRequest, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = httpServletRequest.getScheme();
        if (string2 == null) {
            return false;
        }
        string2 = string2.toLowerCase(Locale.ENGLISH);
        stringBuilder.append(string2);
        stringBuilder.append("://");
        String string3 = httpServletRequest.getServerName();
        if (string3 == null) {
            return false;
        }
        stringBuilder.append(string3);
        int n = httpServletRequest.getServerPort();
        if (stringBuilder.length() == string.length()) {
            if (("http".equals(string2) || "ws".equals(string2)) && n != 80 || ("https".equals(string2) || "wss".equals(string2)) && n != 443) {
                stringBuilder.append(':');
                stringBuilder.append(n);
            }
        } else {
            stringBuilder.append(':');
            stringBuilder.append(n);
        }
        return string.equals(stringBuilder.toString());
    }

    public static boolean isValidOrigin(String string) {
        URI uRI;
        if (string.contains("%")) {
            return false;
        }
        if ("null".equals(string)) {
            return true;
        }
        if (string.startsWith("file://")) {
            return true;
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
        return uRI.getScheme() != null;
    }
}

