/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import javax.servlet.ServletConfig;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.jasper.Constants;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.ExceptionUtils;
import org.apache.jasper.runtime.InstanceManagerFactory;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;

public class TagHandlerPool {
    private Tag[] handlers;
    public static final String OPTION_TAGPOOL = "tagpoolClassName";
    public static final String OPTION_MAXSIZE = "tagpoolMaxSize";
    private int current;
    protected InstanceManager instanceManager = null;

    public static TagHandlerPool getTagHandlerPool(ServletConfig servletConfig) {
        TagHandlerPool tagHandlerPool = null;
        String string = TagHandlerPool.getOption(servletConfig, OPTION_TAGPOOL, null);
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                tagHandlerPool = (TagHandlerPool)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                LogFactory.getLog(TagHandlerPool.class).info((Object)Localizer.getMessage("jsp.error.tagHandlerPool"), (Throwable)exception);
                tagHandlerPool = null;
            }
        }
        if (tagHandlerPool == null) {
            tagHandlerPool = new TagHandlerPool();
        }
        tagHandlerPool.init(servletConfig);
        return tagHandlerPool;
    }

    protected void init(ServletConfig servletConfig) {
        int n = -1;
        String string = TagHandlerPool.getOption(servletConfig, OPTION_MAXSIZE, null);
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = -1;
            }
        }
        if (n < 0) {
            n = 5;
        }
        this.handlers = new Tag[n];
        this.current = -1;
        this.instanceManager = InstanceManagerFactory.getInstanceManager(servletConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag get(Class<? extends Tag> clazz) throws JspException {
        TagHandlerPool tagHandlerPool = this;
        synchronized (tagHandlerPool) {
            if (this.current >= 0) {
                Tag tag = this.handlers[this.current--];
                return tag;
            }
        }
        try {
            if (Constants.USE_INSTANCE_MANAGER_FOR_TAGS) {
                return (Tag)this.instanceManager.newInstance(clazz.getName(), clazz.getClassLoader());
            }
            tagHandlerPool = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.instanceManager.newInstance((Object)tagHandlerPool);
            return tagHandlerPool;
        }
        catch (Exception exception) {
            Throwable throwable = ExceptionUtils.unwrapInvocationTargetException(exception);
            ExceptionUtils.handleThrowable(throwable);
            throw new JspException(exception.getMessage(), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reuse(Tag tag) {
        TagHandlerPool tagHandlerPool = this;
        synchronized (tagHandlerPool) {
            if (this.current < this.handlers.length - 1) {
                this.handlers[++this.current] = tag;
                return;
            }
        }
        JspRuntimeLibrary.releaseTag(tag, this.instanceManager);
    }

    public synchronized void release() {
        for (int i = this.current; i >= 0; --i) {
            JspRuntimeLibrary.releaseTag(this.handlers[i], this.instanceManager);
        }
    }

    protected static String getOption(ServletConfig servletConfig, String string, String string2) {
        if (servletConfig == null) {
            return string2;
        }
        String string3 = servletConfig.getInitParameter(string);
        if (string3 != null) {
            return string3;
        }
        if (servletConfig.getServletContext() == null) {
            return string2;
        }
        string3 = servletConfig.getServletContext().getInitParameter(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }
}

