/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.res.StringManager;

public class StructuredField {
    private static final StringManager sm;
    private static final int ARRAY_SIZE = 128;
    private static final boolean[] IS_KEY_FIRST;
    private static final boolean[] IS_KEY;
    private static final boolean[] IS_OWS;
    private static final boolean[] IS_BASE64;
    private static final boolean[] IS_TOKEN;

    static SfList parseSfList(Reader reader) throws IOException {
        StructuredField.skipSP(reader);
        SfList sfList = new SfList();
        if (StructuredField.peek(reader) != -1) {
            while (true) {
                SfListMember sfListMember = StructuredField.parseSfListMember(reader);
                sfList.addListMember(sfListMember);
                StructuredField.skipOWS(reader);
                if (StructuredField.peek(reader) == -1) break;
                StructuredField.requireChar(reader, 44);
                StructuredField.skipOWS(reader);
                StructuredField.requireNotChar(reader, -1);
            }
        }
        StructuredField.skipSP(reader);
        StructuredField.requireChar(reader, -1);
        return sfList;
    }

    static SfListMember parseSfListMember(Reader reader) throws IOException {
        SfListMember sfListMember = StructuredField.peek(reader) == 40 ? StructuredField.parseSfInnerList(reader) : StructuredField.parseSfBareItem(reader);
        StructuredField.parseSfParameters(reader, sfListMember);
        return sfListMember;
    }

    static SfInnerList parseSfInnerList(Reader reader) throws IOException {
        StructuredField.requireChar(reader, 40);
        SfInnerList sfInnerList = new SfInnerList();
        while (true) {
            StructuredField.skipSP(reader);
            if (StructuredField.peek(reader) == 41) break;
            SfItem<?> sfItem = StructuredField.parseSfBareItem(reader);
            StructuredField.parseSfParameters(reader, sfItem);
            sfInnerList.addListItem(sfItem);
            reader.mark(1);
            StructuredField.requireChar(reader, 32, 41);
            reader.reset();
        }
        StructuredField.requireChar(reader, 41);
        return sfInnerList;
    }

    static SfDictionary parseSfDictionary(Reader reader) throws IOException {
        StructuredField.skipSP(reader);
        SfDictionary sfDictionary = new SfDictionary();
        if (StructuredField.peek(reader) != -1) {
            while (true) {
                SfListMember sfListMember;
                String string = StructuredField.parseSfKey(reader);
                reader.mark(1);
                int n = reader.read();
                if (n == 61) {
                    sfListMember = StructuredField.parseSfListMember(reader);
                } else {
                    sfListMember = new SfBoolean(true);
                    reader.reset();
                }
                StructuredField.parseSfParameters(reader, sfListMember);
                sfDictionary.addDictionaryMember(string, sfListMember);
                StructuredField.skipOWS(reader);
                if (StructuredField.peek(reader) == -1) break;
                StructuredField.requireChar(reader, 44);
                StructuredField.skipOWS(reader);
                StructuredField.requireNotChar(reader, -1);
            }
        }
        StructuredField.skipSP(reader);
        StructuredField.requireChar(reader, -1);
        return sfDictionary;
    }

    static SfItem<?> parseSfItem(Reader reader) throws IOException {
        StructuredField.skipSP(reader);
        SfItem<?> sfItem = StructuredField.parseSfBareItem(reader);
        StructuredField.parseSfParameters(reader, sfItem);
        StructuredField.skipSP(reader);
        StructuredField.requireChar(reader, -1);
        return sfItem;
    }

    static SfItem<?> parseSfBareItem(Reader reader) throws IOException {
        SfItem sfItem;
        int n = reader.read();
        if (n == 45 || HttpParser.isNumeric(n)) {
            sfItem = StructuredField.parseSfNumeric(reader, n);
        } else if (n == 34) {
            sfItem = StructuredField.parseSfString(reader);
        } else if (n == 42 || HttpParser.isAlpha(n)) {
            sfItem = StructuredField.parseSfToken(reader, n);
        } else if (n == 58) {
            sfItem = StructuredField.parseSfByteSequence(reader);
        } else if (n == 63) {
            sfItem = StructuredField.parseSfBoolean(reader);
        } else {
            throw new IllegalArgumentException(sm.getString("sf.bareitem.invalidCharacter", new Object[]{String.format("\\u%40X", n)}));
        }
        return sfItem;
    }

    static void parseSfParameters(Reader reader, SfListMember sfListMember) throws IOException {
        while (StructuredField.peek(reader) == 59) {
            SfBoolean sfBoolean;
            StructuredField.requireChar(reader, 59);
            StructuredField.skipSP(reader);
            String string = StructuredField.parseSfKey(reader);
            reader.mark(1);
            int n = reader.read();
            if (n == 61) {
                sfBoolean = StructuredField.parseSfBareItem(reader);
            } else {
                sfBoolean = new SfBoolean(true);
                reader.reset();
            }
            sfListMember.addParameter(string, sfBoolean);
        }
    }

    static String parseSfKey(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        reader.mark(1);
        int n = reader.read();
        if (!StructuredField.isKeyFirst(n)) {
            throw new IllegalArgumentException(sm.getString("sf.key.invalidFirstCharacter", new Object[]{String.format("\\u%40X", n)}));
        }
        while (n != -1 && StructuredField.isKey(n)) {
            stringBuilder.append((char)n);
            reader.mark(1);
            n = reader.read();
        }
        reader.reset();
        return stringBuilder.toString();
    }

    static SfItem<?> parseSfNumeric(Reader reader, int n) throws IOException {
        int n2;
        int n3 = 1;
        boolean bl = true;
        int n4 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        if (n == 45) {
            n3 = -1;
            n2 = reader.read();
        } else {
            n2 = n;
        }
        if (!HttpParser.isNumeric(n2)) {
            throw new IllegalArgumentException(sm.getString("sf.numeric.invalidCharacter", new Object[]{String.format("\\u%40X", n2)}));
        }
        stringBuilder.append((char)n2);
        reader.mark(1);
        n2 = reader.read();
        while (n2 != -1) {
            if (HttpParser.isNumeric(n2)) {
                stringBuilder.append((char)n2);
            } else if (bl && n2 == 46) {
                if (stringBuilder.length() > 12) {
                    throw new IllegalArgumentException(sm.getString("sf.numeric.integralPartTooLong"));
                }
                bl = false;
                stringBuilder.append((char)n2);
                n4 = stringBuilder.length();
            } else {
                reader.reset();
                break;
            }
            if (bl && stringBuilder.length() > 15) {
                throw new IllegalArgumentException(sm.getString("sf.numeric.integerTooLong"));
            }
            if (!bl && stringBuilder.length() > 16) {
                throw new IllegalArgumentException(sm.getString("sf.numeric.decimalTooLong"));
            }
            reader.mark(1);
            n2 = reader.read();
        }
        if (bl) {
            return new SfInteger(Long.parseLong(stringBuilder.toString()) * (long)n3);
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) == '.') {
            throw new IllegalArgumentException(sm.getString("sf.numeric.decimalInvalidFinal"));
        }
        if (stringBuilder.length() - n4 > 3) {
            throw new IllegalArgumentException(sm.getString("sf.numeric.decimalPartTooLong"));
        }
        return new SfDecimal(Double.parseDouble(stringBuilder.toString()) * (double)n3);
    }

    static SfString parseSfString(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int n;
            if ((n = reader.read()) == 92) {
                StructuredField.requireNotChar(reader, -1);
                n = reader.read();
                if (n != 92 && n != 34) {
                    throw new IllegalArgumentException(sm.getString("sf.string.invalidEscape", new Object[]{String.format("\\u%40X", n)}));
                }
            } else {
                if (n == 34) break;
                if (n < 32 || n > 126) {
                    throw new IllegalArgumentException(sm.getString("sf.string.invalidCharacter", new Object[]{String.format("\\u%40X", n)}));
                }
            }
            stringBuilder.append((char)n);
        }
        return new SfString(stringBuilder.toString());
    }

    static SfToken parseSfToken(Reader reader, int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)n);
        while (true) {
            reader.mark(1);
            int n2 = reader.read();
            if (!StructuredField.isToken(n2)) break;
            stringBuilder.append((char)n2);
        }
        reader.reset();
        return new SfToken(stringBuilder.toString());
    }

    static SfByteSequence parseSfByteSequence(Reader reader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = reader.read()) != 58) {
            if (StructuredField.isBase64(n)) {
                stringBuilder.append((char)n);
                continue;
            }
            throw new IllegalArgumentException(sm.getString("sf.base64.invalidCharacter", new Object[]{String.format("\\u%40X", n)}));
        }
        return new SfByteSequence(Base64.getDecoder().decode(stringBuilder.toString()));
    }

    static SfBoolean parseSfBoolean(Reader reader) throws IOException {
        int n = reader.read();
        if (n == 49) {
            return new SfBoolean(true);
        }
        if (n == 48) {
            return new SfBoolean(false);
        }
        throw new IllegalArgumentException(sm.getString("sf.boolean.invalidCharacter", new Object[]{String.format("\\u%40X", n)}));
    }

    static void skipSP(Reader reader) throws IOException {
        reader.mark(1);
        int n = reader.read();
        while (n == 32) {
            reader.mark(1);
            n = reader.read();
        }
        reader.reset();
    }

    static void skipOWS(Reader reader) throws IOException {
        reader.mark(1);
        int n = reader.read();
        while (StructuredField.isOws(n)) {
            reader.mark(1);
            n = reader.read();
        }
        reader.reset();
    }

    static void requireChar(Reader reader, int ... nArray) throws IOException {
        int n = reader.read();
        for (int n2 : nArray) {
            if (n != n2) continue;
            return;
        }
        throw new IllegalArgumentException(sm.getString("sf.invalidCharacter", new Object[]{String.format("\\u%40X", n)}));
    }

    static void requireNotChar(Reader reader, int n) throws IOException {
        reader.mark(1);
        int n2 = reader.read();
        if (n2 == n) {
            throw new IllegalArgumentException(sm.getString("sf.invalidCharacter", new Object[]{String.format("\\u%40X", n2)}));
        }
        reader.reset();
    }

    static int peek(Reader reader) throws IOException {
        reader.mark(1);
        int n = reader.read();
        reader.reset();
        return n;
    }

    static boolean isKeyFirst(int n) {
        try {
            return IS_KEY_FIRST[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    static boolean isKey(int n) {
        try {
            return IS_KEY[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    static boolean isOws(int n) {
        try {
            return IS_OWS[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    static boolean isBase64(int n) {
        try {
            return IS_BASE64[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    static boolean isToken(int n) {
        try {
            return IS_TOKEN[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    private StructuredField() {
    }

    static {
        int n;
        sm = StringManager.getManager(StructuredField.class);
        IS_KEY_FIRST = new boolean[128];
        IS_KEY = new boolean[128];
        IS_OWS = new boolean[128];
        IS_BASE64 = new boolean[128];
        IS_TOKEN = new boolean[128];
        for (n = 0; n < 128; ++n) {
            if (n == 42 || n >= 97 && n <= 122) {
                StructuredField.IS_KEY_FIRST[n] = true;
                StructuredField.IS_KEY[n] = true;
                continue;
            }
            if ((n < 48 || n > 57) && n != 95 && n != 45 && n != 46) continue;
            StructuredField.IS_KEY[n] = true;
        }
        for (n = 0; n < 128; ++n) {
            if (n != 9 && n != 32) continue;
            StructuredField.IS_OWS[n] = true;
        }
        for (n = 0; n < 128; ++n) {
            if (!(n == 43 || n == 47 || n >= 48 && n <= 57 || n == 61 || n >= 65 && n <= 90) && (n < 97 || n > 122)) continue;
            StructuredField.IS_BASE64[n] = true;
        }
        for (n = 0; n < 128; ++n) {
            if (!HttpParser.isToken(n) && n != 58 && n != 47) continue;
            StructuredField.IS_TOKEN[n] = true;
        }
    }

    static class SfList {
        private List<SfListMember> listMembers = new ArrayList<SfListMember>();

        SfList() {
        }

        void addListMember(SfListMember sfListMember) {
            this.listMembers.add(sfListMember);
        }
    }

    static class SfListMember {
        private Map<String, SfItem<?>> parameters = null;

        SfListMember() {
        }

        void addParameter(String string, SfItem<?> sfItem) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap();
            }
            this.parameters.put(string, sfItem);
        }
    }

    static class SfInnerList
    extends SfListMember {
        List<SfItem<?>> listItems = new ArrayList();

        SfInnerList() {
        }

        void addListItem(SfItem<?> sfItem) {
            this.listItems.add(sfItem);
        }

        List<SfItem<?>> getListItem() {
            return this.listItems;
        }
    }

    static abstract class SfItem<T>
    extends SfListMember {
        private final T value;

        SfItem(T t) {
            this.value = t;
        }

        T getVaue() {
            return this.value;
        }
    }

    static class SfDictionary {
        private Map<String, SfListMember> dictionary = new LinkedHashMap<String, SfListMember>();

        SfDictionary() {
        }

        void addDictionaryMember(String string, SfListMember sfListMember) {
            this.dictionary.put(string, sfListMember);
        }

        SfListMember getDictionaryMember(String string) {
            return this.dictionary.get(string);
        }
    }

    static class SfBoolean
    extends SfItem<Boolean> {
        SfBoolean(boolean bl) {
            super(bl);
        }
    }

    static class SfString
    extends SfItem<String> {
        SfString(String string) {
            super(string);
        }
    }

    static class SfToken
    extends SfItem<String> {
        SfToken(String string) {
            super(string);
        }
    }

    static class SfByteSequence
    extends SfItem<byte[]> {
        SfByteSequence(byte[] byArray) {
            super(byArray);
        }
    }

    static class SfInteger
    extends SfItem<Long> {
        SfInteger(long l) {
            super(l);
        }
    }

    static class SfDecimal
    extends SfItem<Double> {
        SfDecimal(double d) {
            super(d);
        }
    }
}

