/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

public final class StringUtils {
    private static final String EMPTY_STRING = "";

    private StringUtils() {
    }

    public static String join(String string, String string2) {
        return StringUtils.join(new String[]{string, string2});
    }

    public static String join(String[] stringArray) {
        if (stringArray == null) {
            return EMPTY_STRING;
        }
        return StringUtils.join(Arrays.asList(stringArray));
    }

    public static void join(String[] stringArray, char c, StringBuilder stringBuilder) {
        if (stringArray == null) {
            return;
        }
        StringUtils.join(Arrays.asList(stringArray), c, stringBuilder);
    }

    public static String join(Collection<String> collection) {
        return StringUtils.join(collection, ',');
    }

    public static String join(Collection<String> collection, char c) {
        if (collection == null || collection.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringUtils.join(collection, c, stringBuilder);
        return stringBuilder.toString();
    }

    public static void join(Iterable<String> iterable, char c, StringBuilder stringBuilder) {
        StringUtils.join(iterable, c, (T string) -> string, stringBuilder);
    }

    public static <T> void join(T[] TArray, char c, Function<T, String> function, StringBuilder stringBuilder) {
        if (TArray == null) {
            return;
        }
        StringUtils.join(Arrays.asList(TArray), c, function, stringBuilder);
    }

    public static <T> void join(Iterable<T> iterable, char c, Function<T, String> function, StringBuilder stringBuilder) {
        if (iterable == null) {
            return;
        }
        boolean bl = true;
        for (T t : iterable) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(c);
            }
            stringBuilder.append(function.apply(t));
        }
    }

    public static String[] splitCommaSeparated(String string) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }
}

