/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class AsyncListenerWrapper {
    private AsyncListener listener = null;
    private ServletRequest servletRequest = null;
    private ServletResponse servletResponse = null;

    public void fireOnStartAsync(AsyncEvent asyncEvent) throws IOException {
        this.listener.onStartAsync(this.customizeEvent(asyncEvent));
    }

    public void fireOnComplete(AsyncEvent asyncEvent) throws IOException {
        this.listener.onComplete(this.customizeEvent(asyncEvent));
    }

    public void fireOnTimeout(AsyncEvent asyncEvent) throws IOException {
        this.listener.onTimeout(this.customizeEvent(asyncEvent));
    }

    public void fireOnError(AsyncEvent asyncEvent) throws IOException {
        this.listener.onError(this.customizeEvent(asyncEvent));
    }

    public AsyncListener getListener() {
        return this.listener;
    }

    public void setListener(AsyncListener asyncListener) {
        this.listener = asyncListener;
    }

    public void setServletRequest(ServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public void setServletResponse(ServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    private AsyncEvent customizeEvent(AsyncEvent asyncEvent) {
        if (this.servletRequest != null && this.servletResponse != null) {
            return new AsyncEvent(asyncEvent.getAsyncContext(), this.servletRequest, this.servletResponse, asyncEvent.getThrowable());
        }
        return asyncEvent;
    }
}

