/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.Serializable;
import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.tomcat.util.ExceptionUtils;

@Deprecated
public class JDBCRealm
extends RealmBase {
    protected String connectionName = null;
    protected String connectionPassword = null;
    protected String connectionURL = null;
    protected Connection dbConnection = null;
    protected Driver driver = null;
    protected String driverName = null;
    protected PreparedStatement preparedCredentials = null;
    protected PreparedStatement preparedRoles = null;
    protected String roleNameCol = null;
    protected String userCredCol = null;
    protected String userNameCol = null;
    protected String userRoleTable = null;
    protected String userTable = null;

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String string) {
        this.connectionName = string;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String string) {
        this.connectionPassword = string;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String string) {
        this.connectionURL = string;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String string) {
        this.driverName = string;
    }

    public String getRoleNameCol() {
        return this.roleNameCol;
    }

    public void setRoleNameCol(String string) {
        this.roleNameCol = string;
    }

    public String getUserCredCol() {
        return this.userCredCol;
    }

    public void setUserCredCol(String string) {
        this.userCredCol = string;
    }

    public String getUserNameCol() {
        return this.userNameCol;
    }

    public void setUserNameCol(String string) {
        this.userNameCol = string;
    }

    public String getUserRoleTable() {
        return this.userRoleTable;
    }

    public void setUserRoleTable(String string) {
        this.userRoleTable = string;
    }

    public String getUserTable() {
        return this.userTable;
    }

    public void setUserTable(String string) {
        this.userTable = string;
    }

    @Override
    public synchronized Principal authenticate(String string, String string2) {
        for (int i = 2; i > 0; --i) {
            try {
                this.open();
                Principal principal = this.authenticate(this.dbConnection, string, string2);
                return principal;
            }
            catch (SQLException sQLException) {
                this.containerLog.error((Object)sm.getString("jdbcRealm.exception"), (Throwable)sQLException);
                if (this.dbConnection == null) continue;
                this.close(this.dbConnection);
                continue;
            }
        }
        return null;
    }

    public synchronized Principal authenticate(Connection connection, String string, String string2) {
        if (string == null || string2 == null) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("jdbcRealm.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        String string3 = this.getPassword(string);
        if (string3 == null) {
            this.getCredentialHandler().mutate(string2);
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("jdbcRealm.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        boolean bl = this.getCredentialHandler().matches(string2, string3);
        if (bl) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("jdbcRealm.authenticateSuccess", new Object[]{string}));
            }
        } else {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("jdbcRealm.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        ArrayList<String> arrayList = this.getRoles(string);
        return new GenericPrincipal(string, string2, arrayList);
    }

    @Override
    public boolean isAvailable() {
        return this.dbConnection != null;
    }

    protected void close(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            this.preparedCredentials.close();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        this.preparedCredentials = null;
        try {
            this.preparedRoles.close();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        this.preparedRoles = null;
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            this.containerLog.warn((Object)sm.getString("jdbcRealm.close"), (Throwable)sQLException);
        }
        finally {
            this.dbConnection = null;
        }
    }

    protected PreparedStatement credentials(Connection connection, String string) throws SQLException {
        if (this.preparedCredentials == null) {
            StringBuilder stringBuilder = new StringBuilder("SELECT ");
            stringBuilder.append(this.userCredCol);
            stringBuilder.append(" FROM ");
            stringBuilder.append(this.userTable);
            stringBuilder.append(" WHERE ");
            stringBuilder.append(this.userNameCol);
            stringBuilder.append(" = ?");
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("credentials query: " + stringBuilder.toString()));
            }
            this.preparedCredentials = connection.prepareStatement(stringBuilder.toString());
        }
        if (string == null) {
            this.preparedCredentials.setNull(1, 12);
        } else {
            this.preparedCredentials.setString(1, string);
        }
        return this.preparedCredentials;
    }

    @Override
    protected synchronized String getPassword(String string) {
        String string2 = null;
        int n = 2;
        while (n > 0) {
            String string3;
            block12: {
                this.open();
                PreparedStatement preparedStatement = this.credentials(this.dbConnection, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    if (resultSet.next()) {
                        string2 = resultSet.getString(1);
                    }
                    this.dbConnection.commit();
                    if (string2 != null) {
                        string2 = string2.trim();
                    }
                    string3 = string2;
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        this.containerLog.error((Object)sm.getString("jdbcRealm.exception"), (Throwable)sQLException);
                        if (this.dbConnection != null) {
                            this.close(this.dbConnection);
                        }
                        --n;
                    }
                }
                resultSet.close();
            }
            return string3;
        }
        return null;
    }

    @Override
    protected synchronized Principal getPrincipal(String string) {
        return new GenericPrincipal(string, this.getPassword(string), this.getRoles(string));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected ArrayList<String> getRoles(String string) {
        if (this.allRolesMode != RealmBase.AllRolesMode.STRICT_MODE && !this.isRoleStoreDefined()) {
            return null;
        }
        for (int n = 2; n > 0; --n) {
            try {
                this.open();
                PreparedStatement preparedStatement = this.roles(this.dbConnection, string);
                try {
                    Object object;
                    block14: {
                        ResultSet resultSet = preparedStatement.executeQuery();
                        try {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            while (resultSet.next()) {
                                object = resultSet.getString(1);
                                if (null == object) continue;
                                arrayList.add(((String)object).trim());
                            }
                            object = arrayList;
                            if (resultSet == null) break block14;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return object;
                }
                finally {
                    this.dbConnection.commit();
                }
            }
            catch (SQLException sQLException) {
                this.containerLog.error((Object)sm.getString("jdbcRealm.exception"), (Throwable)sQLException);
                if (this.dbConnection == null) continue;
                this.close(this.dbConnection);
                continue;
            }
        }
        return null;
    }

    protected Connection open() throws SQLException {
        Serializable serializable;
        if (this.dbConnection != null) {
            return this.dbConnection;
        }
        if (this.driver == null) {
            try {
                serializable = Class.forName(this.driverName);
                this.driver = (Driver)((Class)serializable).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                throw new SQLException(throwable.getMessage(), throwable);
            }
        }
        serializable = new Properties();
        if (this.connectionName != null) {
            ((Properties)serializable).put("user", this.connectionName);
        }
        if (this.connectionPassword != null) {
            ((Properties)serializable).put("password", this.connectionPassword);
        }
        this.dbConnection = this.driver.connect(this.connectionURL, (Properties)serializable);
        if (this.dbConnection == null) {
            throw new SQLException(sm.getString("jdbcRealm.open.invalidurl", new Object[]{this.driverName, this.connectionURL}));
        }
        this.dbConnection.setAutoCommit(false);
        return this.dbConnection;
    }

    protected synchronized PreparedStatement roles(Connection connection, String string) throws SQLException {
        if (this.preparedRoles == null) {
            StringBuilder stringBuilder = new StringBuilder("SELECT ");
            stringBuilder.append(this.roleNameCol);
            stringBuilder.append(" FROM ");
            stringBuilder.append(this.userRoleTable);
            stringBuilder.append(" WHERE ");
            stringBuilder.append(this.userNameCol);
            stringBuilder.append(" = ?");
            this.preparedRoles = connection.prepareStatement(stringBuilder.toString());
        }
        this.preparedRoles.setString(1, string);
        return this.preparedRoles;
    }

    private boolean isRoleStoreDefined() {
        return this.userRoleTable != null || this.roleNameCol != null;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        try {
            this.open();
        }
        catch (SQLException sQLException) {
            this.containerLog.error((Object)sm.getString("jdbcRealm.open"), (Throwable)sQLException);
        }
        super.startInternal();
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.close(this.dbConnection);
    }
}

