/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.StringRefAddr;
import org.apache.naming.AbstractRef;
import org.apache.naming.HandlerRef;

public class ServiceRef
extends AbstractRef {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_FACTORY = "org.apache.naming.factory.webservices.ServiceRefFactory";
    public static final String SERVICE_INTERFACE = "serviceInterface";
    public static final String SERVICE_NAMESPACE = "service namespace";
    public static final String SERVICE_LOCAL_PART = "service local part";
    public static final String WSDL = "wsdl";
    public static final String JAXRPCMAPPING = "jaxrpcmapping";
    public static final String PORTCOMPONENTLINK = "portcomponentlink";
    public static final String SERVICEENDPOINTINTERFACE = "serviceendpointinterface";
    private final List<HandlerRef> handlers = new CopyOnWriteArrayList<HandlerRef>();

    public ServiceRef(String string, String string2, String[] stringArray, String string3, String string4) {
        this(string, string2, stringArray, string3, string4, null, null);
    }

    public ServiceRef(String string, String string2, String[] stringArray, String string3, String string4, String string5, String string6) {
        super(string2, string5, string6);
        StringRefAddr stringRefAddr = null;
        if (string2 != null) {
            stringRefAddr = new StringRefAddr(SERVICE_INTERFACE, string2);
            this.add(stringRefAddr);
        }
        if (stringArray[0] != null) {
            stringRefAddr = new StringRefAddr(SERVICE_NAMESPACE, stringArray[0]);
            this.add(stringRefAddr);
        }
        if (stringArray[1] != null) {
            stringRefAddr = new StringRefAddr(SERVICE_LOCAL_PART, stringArray[1]);
            this.add(stringRefAddr);
        }
        if (string3 != null) {
            stringRefAddr = new StringRefAddr(WSDL, string3);
            this.add(stringRefAddr);
        }
        if (string4 != null) {
            stringRefAddr = new StringRefAddr(JAXRPCMAPPING, string4);
            this.add(stringRefAddr);
        }
    }

    public HandlerRef getHandler() {
        return this.handlers.remove(0);
    }

    public int getHandlersSize() {
        return this.handlers.size();
    }

    public void addHandler(HandlerRef handlerRef) {
        this.handlers.add(handlerRef);
    }

    @Override
    protected String getDefaultFactoryClassName() {
        return DEFAULT_FACTORY;
    }
}

