/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.pac.datetime;

import java.util.Calendar;

class DateRange {
    private static final int UNDEFINED = -1;
    private final int yearMin;
    private final int yearMax;
    private final int monthMin;
    private final int monthMax;
    private final int dateMin;
    private final int dateMax;

    public DateRange(int n, int n2, int n3, int n4, int n5, int n6) {
        this.yearMin = n;
        this.yearMax = n2 == -1 && n != -1 ? n : n2;
        this.monthMin = n3;
        this.monthMax = n4 == -1 && n3 != -1 ? n3 : n4;
        this.dateMin = n5;
        this.dateMax = n6 == -1 && n5 != -1 ? n5 : n6;
    }

    public boolean isInRange(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        if (this.yearDefined() && (n < this.yearMin || n > this.yearMax)) {
            return false;
        }
        if (this.monthDefined()) {
            if (this.yearDefined()) {
                if (n == this.yearMin && n2 < this.monthMin) {
                    return false;
                }
                if (n == this.yearMax && n2 > this.monthMax) {
                    return false;
                }
            } else if (this.monthMin <= this.monthMax ? n2 < this.monthMin || n2 > this.monthMax : n2 < this.monthMin && n2 > this.monthMax) {
                return false;
            }
        }
        if (this.dateDefined()) {
            boolean bl = false;
            if (this.monthDefined()) {
                if (this.yearDefined()) {
                    if (n == this.yearMin && n2 == this.monthMin || n == this.yearMax && n2 == this.monthMax) {
                        bl = true;
                    }
                } else if (n2 == this.monthMin || n2 == this.monthMax) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl && (this.dateMin <= this.dateMax ? n3 < this.dateMin || n3 > this.dateMax : n3 < this.dateMin && n3 > this.dateMax)) {
                return false;
            }
        }
        return true;
    }

    private boolean yearDefined() {
        return this.yearMin != -1 || this.yearMax != -1;
    }

    private boolean monthDefined() {
        return this.monthMin != -1 || this.monthMax != -1;
    }

    private boolean dateDefined() {
        return this.dateMin != -1 || this.dateMax != -1;
    }

    public static DateRangeBuilder getBuilder() {
        return new DateRangeBuilder();
    }

    public static class DateRangeBuilder {
        private int yearMin = -1;
        private int yearMax = -1;
        private int monthMin = -1;
        private int monthMax = -1;
        private int dateMin = -1;
        private int dateMax = -1;

        private DateRangeBuilder() {
        }

        public DateRangeBuilder setYear(int n, int n2) {
            this.yearMin = n;
            this.yearMax = n2;
            return this;
        }

        public DateRangeBuilder setMonth(int n, int n2) {
            this.monthMin = n;
            this.monthMax = n2;
            return this;
        }

        public DateRangeBuilder setDate(int n, int n2) {
            this.dateMin = n;
            this.dateMax = n2;
            return this;
        }

        public DateRange createDateRange() {
            return new DateRange(this.yearMin, this.yearMax, this.monthMin, this.monthMax, this.dateMin, this.dateMax);
        }
    }
}

