"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ObservabilityPluginSetup", {
  enumerable: true,
  get: function () {
    return _types.ObservabilityPluginSetup;
  }
});
Object.defineProperty(exports, "ObservabilityPluginStart", {
  enumerable: true,
  get: function () {
    return _types.ObservabilityPluginStart;
  }
});
exports.config = void 0;
exports.plugin = plugin;
var _configSchema = require("@osd/config-schema");
var _plugin = require("./plugin");
var _types = require("./types");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function plugin(initializerContext) {
  return new _plugin.ObservabilityPlugin(initializerContext);
}
const observabilityConfig = {
  schema: _configSchema.schema.object({
    query_assist: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: false
      })
    }),
    summarize: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: false
      })
    })
  })
};
const config = exports.config = {
  schema: observabilityConfig.schema,
  exposeToBrowser: {
    query_assist: true,
    summarize: true
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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