"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDatasourcesRoute = registerDatasourcesRoute;
var _configSchema = require("@osd/config-schema");
var _shared = require("../../../common/constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerDatasourcesRoute(router) {
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.JOBS_BASE}`,
    validate: {
      body: _configSchema.schema.object({
        query: _configSchema.schema.string(),
        lang: _configSchema.schema.string(),
        datasource: _configSchema.schema.string(),
        sessionId: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    const params = {
      body: {
        ...request.body
      }
    };
    try {
      const res = await context.observability_plugin.observabilityClient.asScoped(request).callAsCurrentUser('observability.runDirectQuery', params);
      return response.ok({
        body: res
      });
    } catch (error) {
      console.error('Error in running direct query:', error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.body
      });
    }
  });
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.JOBS_BASE}/{queryId}`,
    validate: {
      params: _configSchema.schema.object({
        queryId: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    try {
      const res = await context.observability_plugin.observabilityClient.asScoped(request).callAsCurrentUser('observability.getJobStatus', {
        queryId: request.params.queryId
      });
      return response.ok({
        body: res
      });
    } catch (error) {
      console.error('Error in fetching job status:', error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.delete({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.JOBS_BASE}/{queryId}`,
    validate: {
      params: _configSchema.schema.object({
        queryId: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    try {
      const res = await context.observability_plugin.observabilityClient.asScoped(request).callAsCurrentUser('observability.deleteJob', {
        queryId: request.params.queryId
      });
      return response.ok({
        body: res
      });
    } catch (error) {
      console.error('Error in deleting job:', error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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