"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRoutes = setupRoutes;
var _dsl_facet = require("../services/facets/dsl_facet");
var _ppl_facet = require("../services/facets/ppl_facet");
var _saved_objects = _interopRequireDefault(require("../services/facets/saved_objects"));
var _queryService = require("../services/queryService");
var _app_analytics_router = require("./application_analytics/app_analytics_router");
var _panels_router = require("./custom_panels/panels_router");
var _visualizations_router = require("./custom_panels/visualizations_router");
var _datasources_router = require("./datasources/datasources_router");
var _data_connections_router = require("./data_connections/data_connections_router");
var _dsl = require("./dsl");
var _event_analytics_router = require("./event_analytics/event_analytics_router");
var _integrations_router = require("./integrations/integrations_router");
var _metrics_rounter = require("./metrics/metrics_rounter");
var _noteRouter = require("./notebooks/noteRouter");
var _paraRouter = require("./notebooks/paraRouter");
var _sqlRouter = require("./notebooks/sqlRouter");
var _vizRouter = require("./notebooks/vizRouter");
var _ppl = require("./ppl");
var _routes = require("./query_assist/routes");
var _trace_analytics_dsl_router = require("./trace_analytics_dsl_router");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupRoutes({
  router,
  client
}) {
  (0, _panels_router.PanelsRouter)(router);
  (0, _visualizations_router.VisualizationsRouter)(router);
  (0, _ppl.registerPplRoute)({
    router,
    facet: new _ppl_facet.PPLFacet(client)
  });
  (0, _dsl.registerDslRoute)({
    router,
    facet: new _dsl_facet.DSLFacet(client)
  });
  (0, _event_analytics_router.registerEventAnalyticsRouter)({
    router,
    savedObjectFacet: new _saved_objects.default(client)
  });
  (0, _app_analytics_router.registerAppAnalyticsRouter)(router);

  // TODO remove trace analytics route when DSL route for autocomplete is added
  (0, _trace_analytics_dsl_router.registerTraceAnalyticsDslRouter)(router);

  // notebooks routes
  (0, _paraRouter.registerParaRoute)(router);
  (0, _noteRouter.registerNoteRoute)(router);
  (0, _vizRouter.registerVizRoute)(router);
  const queryService = new _queryService.QueryService(client);
  (0, _sqlRouter.registerSqlRoute)(router, queryService);
  (0, _metrics_rounter.registerMetricsRoute)(router);
  (0, _integrations_router.registerIntegrationsRoute)(router);
  (0, _data_connections_router.registerDataConnectionsRoute)(router);
  (0, _datasources_router.registerDatasourcesRoute)(router);
  (0, _routes.registerQueryAssistRoutes)(router);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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