"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerMetricsRoute = registerMetricsRoute;
var _configSchema = require("@osd/config-schema");
var _shared = require("../../../common/constants/shared");
var _metrics_helper = require("../../common/metrics/metrics_helper");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerMetricsRoute(router) {
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}/stats`,
    validate: false
  }, async (context, request, response) => {
    try {
      const metrics = (0, _metrics_helper.getMetrics)();
      return response.ok({
        body: metrics
      });
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}/stats`,
    validate: {
      body: _configSchema.schema.object({
        element: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    try {
      const {
        element
      } = request.body;
      (0, _metrics_helper.addClickToMetric)(element);
      return response.ok();
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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